#!perl -w
use strict;

# import some modules
use File::Spec;

# define global variables
my $inputDir=$ARGV[0];
my $outOptionSetFile=$ARGV[1];
my $pathSetDir=$ARGV[2];
my $cfgFilesDir=$ARGV[3];

my %Symbols;
my @AoA_Pathes;
my %Conditions;

if ($#ARGV < 0) {
  print "usage:   gen_optionSet <inputDir> <outputFile> <pathSetDir> <cfgFilesDir>\n";
  print "example: gen_optionSet busyb_integration busyb_integration/osFragment.xml x:/g23m/system/busyb x:/g23m/__out__/ssa_config\n";
  exit;
}

# Find the target set files
#
my @osFiles = glob("$inputDir/*.os");
$#osFiles >= 0 || die "No *.os files found\n";

# open the output files
#
open (OUT,">$outOptionSetFile")||die "can't open $outOptionSetFile \n";


foreach (@osFiles) {
  my $condition = calcConditionFromFileName($_);

  my $condString = $_;
  $condString =~ /((\w|-)+)\.os/;
  $condString = "config_$1";

  # open the input file
  #
  open (IN,"<$_")||die "can't open $_ \n";
  
  # read the input file
  #
  my $line;
  while(defined($line = <IN>))
  {
    # remove trailing \n
    chomp($line);
      if ($line =~ /^\[(\w+)\]\s*/) {
        my @dirNames = split(/\s+/,$');
        foreach (@dirNames) {
          my $dirName = calcRelativePathFromPathset ($_, $pathSetDir);
          $Symbols{$1} .= "<condValue path=\"$dirName\" require=\"$condition\"/>\n";
        }
      }
  }
  $Conditions{$condition} = $condString;
}





# print the optionSet fragment
#
print OUT "<!-- This is a generated file! Do not change ! -->\n\n";
print OUT "<!-- It's output is based on the information in the following files:\n";
foreach (@osFiles) {
  print OUT "\t$_\n";
}
print OUT "\n<!-- All of it must be placed somewhere in a optionSet document! -->\n\n\n";


#print OUT "<optionDef description=\"auto generated options - SSA_WCP_INCLUDES\" name=\"SSA_WCP_INCLUDES\">\n";
#print OUT "<condOption name=\"include\">\n";
#foreach (sort(keys (%Symbols))) {
#  print OUT "<condValue valRef=\"$_.include\"/>\n";
#}
#print OUT "</condOption></optionDef>\n";

print OUT "<optionDef description=\"auto generated options - CFG_INCLUDES\" name=\"CFG_INCLUDES\">\n";
print OUT "<condOption name=\"include\">\n";
foreach (keys (%Conditions)) {
  my $path = calcRelativePathFromPathset($cfgFilesDir, $pathSetDir) . "\\" . $Conditions{$_};
  print OUT "<condValue path=\"$path\" require=\"$_\"/>\n";
}
print OUT "</condOption></optionDef>\n\n";


foreach (sort(keys (%Symbols))) {
  print OUT "<optionDef description=\"auto generated options - $_\" name=\"$_\">\n";
  print OUT "<condOption name=\"include\">\n";
  print OUT "$Symbols{$_}";
  print OUT "</condOption></optionDef>\n\n";
}


# close the files
#
close IN;
close OUT;


###########################################
# calculate the condition from the filename
# make aaa==1 &#38 bbb==2 from aaa1_bbb2.ts
#
sub calcConditionFromFileName
{
my $condition = "";
my @cond;
my $i = 0;

# remove directory part
my ($drive,$directories,$file);
($drive,$directories,$file) = File::Spec->splitpath($_[0]);

# now remove file extension
$file =~ /\.\w*/;

# now split the name into sub conditions e.g. aaa1 bbb2
@cond = split(/_/,$`);

foreach (@cond) {
  while (s/([a-zA-Z0-9]+)-(\d+)//) {
    $condition = $condition . "(" . $1 . "==" . $2 .")";
    defined($cond[++$i]) && ($condition = $condition . " &#38;&#38; ");
    }
  }
  $condition =~ s/ &#38;&#38; $//;
  return $condition;
}
###########################################

########################################################
# correct obscure behavior of File::Spec->abs2rel,
# which inserts a drive letter befor a relative path !!!
#
sub calcRelativePathFromPathset
{
  my ($drive,$directories,$file);

  ($drive,$directories,$file) = File::Spec->splitpath( File::Spec->abs2rel ($_[0], $_[1]) );

  return File::Spec->catpath("",$directories,$file);
}
########################################################
