/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: win_key.c       $|
| $Author:: Kk  $ CONDAT GmbH           $Revision:: 1               $|
| CREATED: 28.01.99                     $Modtime:: 3.01.00 19:35    $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : TI1_KEY

   PURPOSE : keyboard driver interface (TI1 VERSION)

   EXPORT  :

   TO DO   :

   $History:: win_key.c                                          $
 * 
 * *****************  Version 1  *****************
 * User: Kk           Date: 6.01.00    Time: 12:22
 * Created in $/GSM/Condat/MS/SRC/MFW
 *
 * *****************  Version 11  *****************
 * User: Es           Date: 9.07.99    Time: 21:29
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 10  *****************
 * User: Es           Date: 6.07.99    Time: 18:37
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 9  *****************
 * User: Es           Date: 6.07.99    Time: 12:41
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 8  *****************
 * User: Es           Date: 14.04.99   Time: 17:34
 * Updated in $/GSM/DEV/MS/SRC/MFW
 * moved to CST
 *
 * *****************  Version 7  *****************
 * User: Es           Date: 1.04.99    Time: 17:07
 * Updated in $/GSM/DEV/MS/SRC/MFW
 * removed lots of traces
 *
 * *****************  Version 6  *****************
 * User: Es           Date: 20.02.99   Time: 19:24
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 5  *****************
 * User: Es           Date: 20.02.99   Time: 18:22
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 4  *****************
 * User: Es           Date: 20.02.99   Time: 14:43
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 3  *****************
 * User: Es           Date: 17.02.99   Time: 20:00
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 2  *****************
 * User: Es           Date: 10.02.99   Time: 19:51
 * Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 1  *****************
 * User: Es           Date: 9.02.99    Time: 14:53
 * Created in $/GSM/DEV/MS/SRC/MFW
 * TI display & keyboard interface for MFW
*/

#include <string.h>
#include "STDDEFS.H"
#include "mfw_mfw.h"
#include "mfw_sys.h"
#include "gdi.h"
#include "kbd.h"

#include "drv_key.h"
#include "win_key.h"


static const U8 kbd_map [32] =          /* ti mapping               */
{                                       /* default keyboard mapping */
    /* KEY_0            */      0x30,
    /* KEY_1            */      0x31,
    /* KEY_2            */      0x32,
    /* KEY_3            */      0x33,
    /* KEY_4            */      0x34,
    /* KEY_5            */      0x35,
    /* KEY_6            */      0x36,
    /* KEY_7            */      0x37,
    /* KEY_8            */      0x38,
    /* KEY_9            */      0x39,
    /* KEY_STAR         */      0x2a,
    /* KEY_HASH         */      0x23,
    /* KEY_VOLUP        */      0xFE,
    /* KEY_VOLDOWN      */      0xFE,
    /* KEY_MNUUP        */      0x2d,
    /* KEY_MNUDOWN      */      0x62,
    /* KEY_LEFT         */      0x43,
    /* KEY_RIGHT        */      0x5e,
    /* KEY_CALL         */      0x61,
    /* KEY_HUP          */      0x56,
    /* KEY_OK           */      0xFE/*'f'*/,
    /* KEY_CLEAR        */      0xFE,
    /* KEY_ABC          */      0xFE,
    /* KEY_POWER        */      0x45,
    /* KEY_F1           */      0xFE,
    /* KEY_F2           */      0xFE,
    /* KEY_F3           */      0xFE,
    /* KEY_F4           */      0xFE,
    /* KEY_MAX          */      0xFE,
    /* KEY_UNDEFINED    */      0xFE,
    /* KEY_UNDEFINED    */      0xFE,
    /* KEY_UNDEFINED    */      0xFE
};

static const U8 simkbd_map [32] =       /* MOB SIM mapping          */
{                                       /* default keyboard mapping */
    /* KEY_0          0 */      0,
    /* KEY_1          1 */      1,
    /* KEY_2          2 */      2,
    /* KEY_3          3 */      3,
    /* KEY_4          4 */      4,
    /* KEY_5          5 */      5,
    /* KEY_6          6 */      6,
    /* KEY_7          7 */      7,
    /* KEY_8          8 */      8,
    /* KEY_9          9 */      9,
    /* KEY_STAR      10 */      10,
    /* KEY_HASH      11 */      11,
    /* KEY_VOLUP     12 */      12,
    /* KEY_VOLDOWN   13 */      13,
    /* KEY_MNUUP     14 */      14,
    /* KEY_MNUDOWN   15 */      15,
    /* KEY_LEFT      16 */      16,
    /* KEY_RIGHT     17 */      17,
    /* KEY_CALL      18 */      18,
    /* KEY_HUP       19 */      19,
    /* KEY_OK        20 */      20,
    /* KEY_CLEAR     21 */      21,
    /* KEY_ABC       22 */      22,
    /* KEY_POWER     23 */      23,
    /* KEY_F1        24 */      24,
    /* KEY_F2        25 */      25,
    /* KEY_F3        26 */      26,
    /* KEY_F4        27 */      27,
    /* KEY_MAX       28 */      28,
    /* KEY_AUTO      29 */      29,
    /* KEY_LONG      30 */      30,
    /* KEY_MAKE      31 */      31
};

static const char * config_map [32] =
{                                       /* CONFIG prim key names    */
    /* KEY_0            */      "0",
    /* KEY_1            */      "1",
    /* KEY_2            */      "2",
    /* KEY_3            */      "3",
    /* KEY_4            */      "4",
    /* KEY_5            */      "5",
    /* KEY_6            */      "6",
    /* KEY_7            */      "7",
    /* KEY_8            */      "8",
    /* KEY_9            */      "9",
    /* KEY_STAR         */      "STAR",
    /* KEY_HASH         */      "HASH",
    /* KEY_VOLUP        */      "VOL_PLUS",
    /* KEY_VOLDOWN      */      "VOL_MINUS",
    /* KEY_MNUUP        */      "UP",
    /* KEY_MNUDOWN      */      "DOWN",
    /* KEY_LEFT         */      "LEFT",
    /* KEY_RIGHT        */      "RIGHT",
    /* KEY_CALL         */      "SEND",
    /* KEY_HUP          */      "END",
    /* KEY_OK           */      "OK",
    /* KEY_CLEAR        */      "CLEAR",
    /* KEY_ABC          */      "ABC",
    /* KEY_POWER        */      "POWER",
    /* KEY_F1           */      "F1",
    /* KEY_F2           */      "F2",
    /* KEY_F3           */      "F3",
    /* KEY_F4           */      "F4",
    /* KEY_MAX          */      "",
    /* KEY_UNDEFINED    */      "",
    /* KEY_UNDEFINED    */      "",
    /* KEY_UNDEFINED    */      ""
};

                                        /* driver callback          */
static void kbdCb (drv_SignalID_Type *signal_params);

static void (*sig) (char,char) = 0;     /* kbd signaling function   */
static char *keyMap = (char *) kbd_map; /* current keyboard mapping */


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : ti1_key            |
| STATE   : code                        ROUTINE : keyInit            |
+--------------------------------------------------------------------+

  PURPOSE : initialize keyboard driver

*/

void keyInit (void (*s)(char,char))
{
    sig = s;
    /*
    *   read keyboard mapping from EEPROM.
    *   if this fails set keyboard mapping with default values.
    *
    *   EEPROM reading not now !!!
    */
    keyMap = (char *) kbd_map;
    kbd_Init(kbdCb);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : ti1_key            |
| STATE   : code                        ROUTINE : keyExit            |
+--------------------------------------------------------------------+

  PURPOSE : finalize keyboard driver

*/

void keyExit (void)
{
    sig = 0;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : ti1_key            |
| STATE   : code                        ROUTINE : drvKeyUpDown       |
+--------------------------------------------------------------------+

  PURPOSE : handle key event (called from keyboard)

*/

void drvKeyUpDown (char upDown, char key)
{
    char i;

    if (!sig) return;                   /* no event handler         */
//kk test    if (!key) return;                   /* no valid key             */

    for (i = 0; i < 32; i++)
    {
        if (keyMap[i] == key)
        {
            sig(!upDown,i);
            return;
        }
    }
                                        /* TEST only ES!!           */
    for (i = 0; i < 32; i++)
    {
        if (simkbd_map[i] == key)
        {
            sig(!upDown,i);
            return;
        }
    }
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : ti1_key            |
| STATE   : code                        ROUTINE : mfw_keystroke      |
+--------------------------------------------------------------------+

  PURPOSE : handle keystroke primitive (called from aci-pei)
            keystroke sent via 'PEI-CONFIG'-primitive
            used in Test cases and by RT;

*/

void mfw_keystroke (char * key)
{
    char i, number;

    if (!sig) return;                   /* no event handler         */
    if (!key) return;                   /* no valid key             */

    number = 0;
    while (strlen(key))
    {
        if (!strcmp(key,"#*43*1#"))
        {
            sig(1,19);                  /* simulate HUP             */
            sig(0,19);
            key += 7;
            continue;
        }
        if (!strcmp(key,"#*43*0#"))
        {
            sig(1,18);                  /* simulate CALL            */
            sig(0,18);
            key += 7;
            continue;
        }
        for (i = 0; i < 32; i++)
        {
            if (!strcmp(key,config_map[i]))
            {
                sig(1,i);               /* assume key down event    */
                sig(0,i);               /* add key down event       */
                key += strlen(config_map[i]);
                break;
            }
        }
        if (i < 32)
            continue;                   /* found config code        */

        if (*key >= '0' && *key <= '9')
        {
            number = 1;
            sig(1,(char) (*key-'0'));   /* assume a dial number     */
            sig(0,(char) (*key-'0'));
        }
        key++;
    }
    if (number)
    {
        sig(1,18);                      /* simulate CALL            */
        sig(0,18);
    }
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : ti1_key            |
| STATE   : code                        ROUTINE : kbd_callback       |
+--------------------------------------------------------------------+

  PURPOSE : Called by keyboard driver

*/

#include "prim.h"
#define hCommACI _ENTITY_PREFIXED(hCommACI)

static void kbdCb (drv_SignalID_Type *signal_params)
{
EXTERN T_VSI_CHANDLE hCommACI;

    U16 signal_high;
    U16 signal_low;
    PALLOC(key_ind,MMI_KEYPAD_IND);

    signal_high = (U16) (signal_params->UserData >> 16);
    signal_low = (U16) (signal_params->UserData & 0xFFFF);

    key_ind->key_code = (U8) (signal_low & 0xFF);
    if (signal_high == 1)
        key_ind->key_stat = KEY_STAT_PRS;
        
    else
        key_ind->key_stat = KEY_STAT_REL;

#if defined (_TMS470)
    vsi_c_send("",hCommACI,D2P(key_ind),
                    sizeof(T_PRIM_HEADER)+sizeof(T_MMI_KEYPAD_IND));
#else
    PSEND(ACI,key_ind);
#endif
}

