/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: mfw_phba.c      $|
| $Author:: Vo                          $Revision::  1              $|
| CREATED: 7.1.99                       $Modtime:: 21.12.99 14:15   $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_PHBA

   PURPOSE : This modul contains phonebook management functions.


   $History:: mfw_phba.c                                              $
 * 
 * *****************  Version 3  *****************
 * User: Vo           Date: 21.12.99   Time: 14:16
 * Updated in $/GSM/Condat/MS/SRC/MFW
 * 
 * *****************  Version 2  *****************
 * User: Vo           Date: 17.11.99   Time: 10:44
 * Updated in $/GSM/Condat/MS/SRC/MFW
 * 
 * *****************  Version 1  *****************
 * User: Vo           Date: 12.01.99   Time: 13:16
 * Created in $/GSM/DEV/MS/SRC/MFW


*/

#define ENTITY_MFW

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif

#include "message.h"
#include "prim.h"
#include "aci_cmh.h"
#include "ksd.h"

#ifdef FAX_AND_DATA
#include "aci_fd.h"
#endif
#include "prim.h"

#include "psa.h"
#include "phb.h"
#include "cmh.h"
#include "cmh_phb.h"

#include "mfw_mfw.h"
#include "mfw_phb.h"
#include "mfw_phbi.h"
#include "mfw_cm.h"
#include "mfw_cmi.h"

#include "mfw_nm.h"
#include "mfw_sim.h"
#include "mfw_sima.h"
#include "mfw_nmi.h"
#include "mfw_simi.h"

#include <string.h>


/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         MODULE: MFW_PHBA             |
| STATE  : code                         ROUTINE: sAT_PlusCPBRA       |
+--------------------------------------------------------------------+


   PURPOSE :

*/
#if defined(FF_2TO1_PS)
T_ACI_RETURN sAT_PlusCPBRA(UBYTE type,
                           UBYTE index,
                           T_ACI_PB_ENTR *pb_list)
{
  T_PHB_RECORD entry;

  if (pb_read_alpha_record(type, index, &entry) EQ PHB_FAIL)
    return AT_FAIL;

  cmhPHB_cpyRecEntr (&pb_list[0], &entry);
  return AT_CMPL;
}
#endif /* #if defined(FF_2TO1_PS) */

