/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: mfw_mme.h       $|
| $Author:: Es  $ CONDAT GmbH           $Revision:: 2               $|
| CREATED: 11.02.99                     $Modtime:: 22.02.00 11:20   $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_MME

   PURPOSE : Miscelleaneous Mobile Equipment

   EXPORT  :

   TO DO   :

   $History:: mfw_mme.h                                             $
 ************************************************************************
 *
 *  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
 * 	Description:	Support for various audio profiles
 *	Solution:	The support for audio device's carkit/headset/loudspeaker/handheld.
 *			The audio device is enabled as per the user actions.
 *
 * *****************  Version 2  *******************************************
 * User: Es           Date: 2.03.00    Time: 16:48
 * Updated in $/GSM/Condat/MS/SRC/MFW
 * generate battery/signal primitives with more info from driver
 * callbacks. Catch the primitives on reception and call MMI event
 * handler. Don't use ACI any longer for this purpose.
 *
 * *****************  Version 1  *****************
 * User: Es           Date: 20.02.99   Time: 11:54
 * Created in $/GSM/DEV/MS/SRC/MFW
 * mobile equipment
*/

#ifndef _DEF_MFW_MME_H_
#define _DEF_MFW_MME_H_

typedef struct MfwMmeTag                /* Equipment CONTROL BLOCK  */
{
    MfwEvt map;                         /* selection of events      */
    MfwCb handler;                      /* event handler            */
    U32 value;                          /* event related value      */
} MfwMme;

                                        /* EQUIPMENT FLAGS & EVENTS */
#define MfwMmeSignal        1           /* signal quality change    */
#define MfwMmeBattery       2           /* battery level change     */
#define MfwMmeBaState       4           /* state of power supply    */
#define MfwMmeRtcAlarm      8           /* real time clock alarm    */
#define MfwMmeHdsDetect    16           /* headset detection        */
#define MfwMmeIrdaMsg      32           /* IRDA event               */
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
#define MfwMmeHeadset 64	/* headset event */
#define MfwMmeCarkit 128		/* carkit event */
#endif


//Light level settings 
#define BL_NO_LIGHT 0
#define BL_MAX_LIGHT 255
#define BL_SET_IDLE -1
#define BL_NO_CHANGE -2

//Events that may affect the backlight 
enum {
	BL_INIT,
	BL_IDLE_TIMER,
	BL_KEY_PRESS,
	BL_INCOMING_SMS,
	BL_INCOMING_CALL,
	BL_EXIT,
	BL_SPARE_OPTION_1,
	BL_SPARE_OPTION_2,
	BL_SPARE_OPTION_3,
	BL_LAST_OPTION
};
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
#define MFW_AUD_HANDHELD			1
#define MFW_AUD_LOUDSPEAKER		2
#define MFW_AUD_HEADSET			3
#define MFW_AUD_CARKIT			4
#endif

                                        /* PROTOTYPES               */
MfwRes mmeInit (void);
MfwRes mmeExit (void);
MfwHnd mmeCreate (MfwHnd w, MfwEvt e, MfwCb f);
MfwRes mmeDelete (MfwHnd h);
void mmeSignal (U32 evt, U32 val);
void mmeBackLight (U8 level);
void mme_setBacklightEvent(int event, int lightLevel);
void mme_backlightEvent(int event);
void mmeAudioTone (U8 callTone, U8 volume, U8 toneStat);
MfwRes mmeSetVolume (U16 audioIn, U16 audioOut);
MfwRes mmeRtcInit (USHORT drvHandle, UBYTE *info);
MfwRes mmeHdsInit (void (*hds_init) ());

void mmeRxInfo (U8 intervalls, U16 level);
void mmeBattInfo (U8 intervalls, U16 level);
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
EXTERN void mfw_auido_device_indication(U8 notify);
EXTERN int mfw_get_current_audioDevice();
EXTERN void mfw_unset_stereo_path(int device);
EXTERN void mfw_set_stereo_path(int device);
#endif
#endif
