/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: mfw_mme.c       $|
| $Author:: Kk  $ CONDAT GmbH           $Revision:: 5               $|
| CREATED: 11.02.99                     $Modtime:: 3.03.00 17:40    $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_MME

   PURPOSE : Miscelleaneous Mobile Equipment functions

   EXPORT  :

   TO DO   :

   $History:: mfw_mme.c                                             $
 ************************************************************************
 *   	nekkareb - OMAPS00057367: 8 Dec 2005
 * 	Description: Fix build problems for fix of OMAPS00057367
 *	Solution: Included OMAPS00057367 changes under a flag ISAMPLE
 *
 *  	nekkareb - OMAPS00057367: 3 Dec 2005
 * 	Description: Locosto: TTY MT call does not work
 *	Solution: Extra TTY command added so as to initiate the AUDIO entity to send the 
 *	              TTY_START request to L1 only after the Vocoder enable is sent.
 *                  Current audio device is read from audio service entity functions.
 *
 *  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
 * 	Description:	Support for various audio profiles
 *	Solution:	The support for audio device's carkit/headset/loudspeaker/handheld.
 *			The audio device is enabled as per the user actions.
 *
 * *****************  Version 5  ********************************************
 * User: Kk           Date: 3.03.00    Time: 17:52
 * Updated in $/GSM/Condat/MS/SRC/MFW
 *
 * *****************  Version 4  *****************
 * User: Es           Date: 2.03.00    Time: 16:48
 * Updated in $/GSM/Condat/MS/SRC/MFW
 * generate battery/signal primitives with more info from driver
 * callbacks. Catch the primitives on reception and call MMI event
 * handler. Don't use ACI any longer for this purpose.
 *
 * *****************  Version 3  *****************
 * User: Es           Date: 14.04.99   Time: 17:34
 * Updated in $/GSM/DEV/MS/SRC/MFW
 * moved to CST
|
| *****************  Version 2  *****************
| User: Le           Date: 14.04.99   Time: 9:51
| Updated in $/GSM/DEV/MS/SRC/MFW
 *
 * *****************  Version 1  *****************
 * User: Es           Date: 20.02.99   Time: 11:54
 * Created in $/GSM/DEV/MS/SRC/MFW
 * mobile equipment
*/

#define ENTITY_MFW

#include <stdio.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "mfw_mfw.h"
#include "mfw_sys.h"
#include "prim.h"
#include "message.h"
#include "prim.h"
#include "aci_cmh.h"
#include "gdi.h"
#include "audio.h"
#include "pwr.h"
#include "rx.h"
#include "light.h"
#include "mfw_acie.h"
#include "mfw_mme.h"
#include "mfw_win.h"

/* OMAPS00057367, 8 Dec 2005, nekkare, build fix */
#if (BOARD == 71)
#define ISAMPLE
#endif

#define hCommPL _ENTITY_PREFIXED(hCommPL)
#define hCommACI _ENTITY_PREFIXED(hCommACI)

#if defined (NEW_FRAME)
EXTERN T_HANDLE hCommPL;
EXTERN T_HANDLE hCommACI;
#else
EXTERN T_VSI_CHANDLE hCommPL;
EXTERN T_VSI_CHANDLE hCommACI;
#endif

EXTERN MfwHdr * current_mfw_elem;

                                        /* FLAG DRIVER CALLBACKS    */
#define MmeFlagRtcAlarm         1       /* rtc alarm                */
#define MmeFlagHdsDetect        2       /* headset detection        */
#define MmeFlagIrdaMsg          4       /* IRDA event               */
U16 mfwMmeDrvFlag = 0;                  /* hold driver CB flags     */

static U8 battLevel = 0;                /* battery level            */
static U8 battState = 0;                /* state of power supply    */
static U16 hdsPresence = 0;				/* headset presence         */
static U16 irdaMsg = 0;                 /* IRDA message             */

static int mmeCommand (U32 cmd, void *h);

                                        /* driver callbacks         */
static void pwrCb (drv_SignalID_Type *signal_params);
static void rxCb (drv_SignalID_Type *signal_params);
static void rtcCb (drv_SignalID_Type *signal_params);

static BOOL mmePrimHandler (USHORT opc, void *data);
static int pSlot;                       /* primitive handler slot   */

static void hdsCb (drv_SignalID_Type *signal_params);
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
#define HANDHELD		"handheld" //0
#define LOUDSPEAKER		"handfree" // 1
#define HEADSET			"headset"    // 2
#define CARKIT			"carkit"   // 3
static UBYTE currAudioDevice = MFW_AUD_HANDHELD;
static UBYTE prevAudioDevice = MFW_AUD_HANDHELD;
UBYTE headsetInserted = FALSE;	//indicates if the headset is inserted or not
UBYTE carkitInserted = FALSE;		//indicates if the carkit is inserted or not
UBYTE mfwAudPlay = FALSE;		//indicates if any other audio media is being played or not
extern audio_set_device(char* mode);
void mfw_audio_headSet_indication ( T_AUDIO_ACCESSORY_NOTIFICATION notify, 
ACCESSORY_CALLBACK_PARAM callbackparam );
void mfw_audio_carKit_indication ( T_AUDIO_ACCESSORY_NOTIFICATION notify, 
ACCESSORY_CALLBACK_PARAM callbackparam );
#endif

void mfw_audio_set_device(int type);
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeInit            |
+--------------------------------------------------------------------+

  PURPOSE : initialize equipment handler

*/

MfwRes mmeInit (void)
{
//	int i;  // RAVI
//	 xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
//	the callback registeration variables are populated here and passed as 
//	argument to audio_init
#ifdef FF_MMI_AUDIO_PROFILE
	T_ACCESSORY_CALLBACK audio_device_config[MAX_EXT_AUD_DEVICE];
	
	audio_device_config[CALLBACK_HEADSET].callbackFunc = mfw_audio_headSet_indication;
	audio_device_config[CALLBACK_HEADSET].callbackVal = NULL;
	audio_device_config[CALLBACK_CARKIT].callbackFunc = mfw_audio_carKit_indication;
	audio_device_config[CALLBACK_CARKIT].callbackVal = NULL;
#endif

    mfwCommand[MfwTypMme] = (MfwCb) mmeCommand;

    mfwMmeDrvFlag = 0;

    battLevel = 0;
    battState = 0;
    hdsPresence = 0;
    irdaMsg = 0;

    pwr_Init(pwrCb); //power driver
    rx_Init(rxCb);   //fieldstrength driver
    light_Init();    //light emitting driver
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
    audio_Init(audio_device_config);
#else
    audio_Init(hdsCb); //audio driver
#endif    

    mmeBattInfo ( 10, 0);

    mmeRxInfo(5,0);

                                        /* install prim handler     */
    pSlot = aci_create((T_PRIM_HANDLER)mmePrimHandler,NULL);

	return MfwResOk;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeExit            |
+--------------------------------------------------------------------+

  PURPOSE : finalize equipment handler

*/

MfwRes mmeExit (void)
{
    aci_delete(pSlot);                  /* remove prim handler      */
    mfwCommand[MfwTypMme] = 0;

    return MfwResOk;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeCreate          |
+--------------------------------------------------------------------+

  PURPOSE : create equipment control

*/

MfwHnd mmeCreate (MfwHnd w, MfwEvt e, MfwCb f)
{
    MfwHdr *hdr = (MfwHdr *) mfwAlloc(sizeof(MfwHdr));
    MfwMme *mme = (MfwMme *) mfwAlloc(sizeof(MfwMme));
	MfwHdr *insert_status =0;
	
    if (!hdr || !mme)
    {
    	TRACE_ERROR("ERROR: mmeCreate() Mem Alloc Failed.");
			
	   	if(hdr)
   			mfwFree((U8*)hdr,sizeof(MfwHdr));
   		if(mme)
   			mfwFree((U8*)mme,sizeof(MfwMme));	
   		
	   	return 0;
  	}

    mme->map = e;
    mme->handler = f;
    mme->value = 0;

    hdr->data = mme;
    hdr->type = MfwTypMme;

    insert_status = mfwInsert(w,hdr);
    
    if(!insert_status)
	{
  		TRACE_ERROR("ERROR: mmeCreate() Failed to Install Handler. ");
   		mfwFree((U8*)hdr,sizeof(MfwHdr));
   		mfwFree((U8*)mme ,sizeof(MfwMme));
		return 0;
  	}
    return insert_status;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeDelete          |
+--------------------------------------------------------------------+

  PURPOSE : delete equipment control

*/

MfwRes mmeDelete (MfwHnd h)
{
    MfwRes res;

    if (!h)
        return MfwResIllHnd;

    res = (mfwRemove(h)) ? MfwResOk : MfwResIllHnd;

    mfwFree(((MfwHdr *) h)->data,sizeof(MfwMme));
    mfwFree(h,sizeof(MfwHdr));

    return res;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeHdsInit         |
+--------------------------------------------------------------------+

  PURPOSE : init the Headset detection and setup callback handler

*/

MfwRes mmeHdsInit (void (*hds_init) ())
{
    mfwMmeDrvFlag &= ~MmeFlagHdsDetect;

    return 1;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeRtcInit         |
+--------------------------------------------------------------------+

  PURPOSE : init the RTC and setup the alarm callback handler

extern UBYTE		clk_Init						(USHORT, drv_SignalCB_Type, UBYTE*);
*/

MfwRes mmeRtcInit (USHORT drvHandle, UBYTE *info)
{
    mfwMmeDrvFlag &= ~MmeFlagRtcAlarm;

   return 0;  // RAVI
}


static int mme_backlightStatus[BL_LAST_OPTION];
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mme_setBacklightIdle   |
+--------------------------------------------------------------------+

  PURPOSE : called when an event may change the backlight level/status

*/
void mme_backlightEvent(int event)
{
	int light;
	if ((event >=BL_INIT) && (event <BL_LAST_OPTION))
	{
		light  = mme_backlightStatus[event];
		if (light == BL_SET_IDLE)
		{
			light_setBacklightIdle();
		}
		else if (light == BL_NO_CHANGE)
		{
			//No change
		}
		else if ((light >=BL_NO_LIGHT) && (light <=BL_MAX_LIGHT))
		{
			mmeBackLight ((U8)light);
		}	
	
	}
}

/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mme_setBacklightIdle   |
+--------------------------------------------------------------------+

  PURPOSE : called to initialise backlight events

*/
void mme_setBacklightEvent(int event, int lightLevel)
{
	if ((event >=BL_INIT) && (event <BL_LAST_OPTION))
	{
		mme_backlightStatus[event] = lightLevel;
	}
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeBackLight       |
+--------------------------------------------------------------------+

  PURPOSE : set display backlight

*/
void mmeBackLight (U8 level)
{
    light_SetStatus(LIGHT_DEVICE_BACKLIGHT,level);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeAudioTone       |
+--------------------------------------------------------------------+

  PURPOSE : configure the buzzer

*/

void mmeAudioTone (U8 callTone, U8 volume, U8 toneStat)
{
    if (toneStat EQ TONE_SWT_OFF)
#ifdef FF_MMI_RINGTONE /* Stop MSL Play */
        audio_StopSoundbyID(AUDIO_SPEAKER, CALLTONE_SELECT);
#else
        audio_StopSoundbyID(AUDIO_SPEAKER,callTone);
#endif
    else
#ifdef FF_MMI_RINGTONE /* Play MSL Ring tone */
        audio_PlaySoundID(AUDIO_SPEAKER,CALLTONE_SELECT,volume,toneStat);
#else
        audio_PlaySoundID(AUDIO_SPEAKER,callTone,volume,toneStat);
#endif
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeSetVolume       |
+--------------------------------------------------------------------+

  PURPOSE : configure mic and speaker volume

*/

MfwRes mmeSetVolume (U16 audioIn, U16 audioOut)
{
    if (audioIn > 255) audioIn = 255;
    if (audioOut > 255) audioOut = 255;

	audio_SetAmplf(AUDIO_MICROPHONE,(U8) audioIn);
    audio_SetAmplf(AUDIO_SPEAKER,(U8) audioOut);

    return MfwResOk;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeRxInfo          |
+--------------------------------------------------------------------+

  PURPOSE : configure signal quality information:
            request from the PS an indication on change of the
            rx level with n intervalls.
            Parameters mode and level are not used in the moment.

*/

void mmeRxInfo (U8 intervalls, U16 level)
{
    rx_DCB_Type rx_DCB;

    rx_DCB.Steps = intervalls;
    rx_SetConfig(&rx_DCB);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeBattInfo        |
+--------------------------------------------------------------------+

  PURPOSE : configure battery level information
            

*/

void mmeBattInfo ( U8 intervalls, U16 level)
{
    pwr_DCB_Type pwr_DCB;

    if (level > 255) level = 255;

    pwr_DCB.RangeMin = (U8) level;      /* low level threshold      */
    pwr_DCB.RangeMax = 100;             /* 100 Percent              */
    pwr_DCB.Steps = intervalls;         /* n Steps                  */
    pwr_SetConfig(&pwr_DCB);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : sigExec            |
+--------------------------------------------------------------------+

  PURPOSE : execute equipment signal

*/

static int sigExec (MfwHdr *curElem, U32 evt, U32 val)
{
    MfwMme *ec;

    while (curElem)
    {
        if (curElem->type == MfwTypMme)
        {
            ec = curElem->data;
            if (ec->map & evt)
            {                           /* events match             */
                ec->value = val;
                if (ec->handler)        /* handler valid            */
                {
                  // PATCH LE 06.06.00
                  // store current mfw elem
                  current_mfw_elem = curElem;
                  // END PATCH LE 06.06.00
                  if ((*(ec->handler))(evt,ec))
                    return 1;       /* event consumed           */
                }
            }
        }
        curElem = curElem->next;
    }

    return 0;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeSignal          |
+--------------------------------------------------------------------+

  PURPOSE : equipment event (called by driver/PEI)

*/

void mmeSignal (U32 evt, U32 value)
{
UBYTE temp;

temp = dspl_Enable(0);
if (mfwSignallingMethod EQ 0)
  {
    if (mfwFocus)
        if (sigExec(mfwFocus,evt,value))
		{
			dspl_Enable(temp);            
			return;
		}
    if (mfwRoot)
        sigExec(mfwRoot,evt,value);
  }
  else
    {
      MfwHdr * h = 0;

      /*
       * Focus set, then start here
       */
      if (mfwFocus)
        h = mfwFocus;
      /*
       * Focus not set, then start root
       */
      if (!h)
        h = mfwRoot;

      /*
       * No elements available, return
       */

      while (h)


      {
        /*
         * Signal consumed, then return
         */
        if (sigExec (h, evt, value))
		{
			dspl_Enable(temp);            
			return;
		}

        /*
         * All windows tried inclusive root
         */
        if (h == mfwRoot)
		{
			dspl_Enable(temp);            
			return;
		}

        /*
         * get parent window
         */
        h = mfwParent(mfwParent(h));
		if(h)
			h = ((MfwWin * )(h->data))->elems;
      }
      sigExec (mfwRoot, evt, value);
      sigExec (mfwRoot, evt, value);

  }
dspl_Enable(temp);            
return;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeCommand         |
+--------------------------------------------------------------------+

  PURPOSE : handle mfw windows command

*/

static int mmeCommand (U32 cmd, void *h)
{
    switch (cmd)
    {
        case MfwCmdDelete:              /* delete me                */
            if (!h)
                return 0;
            mmeDelete(h);
            return 1;
        default:
            break;
    }

    return 0;
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : rAT_PercentSQ      |
+--------------------------------------------------------------------+

  PURPOSE : called by ACI on change of signal quality

*/

void rAT_PercentSQ (BYTE val)
{
    TRACE_FUNCTION("rAT_PercentSQ()");

//ES!! no longer needed    mmeSignal(MfwMmeSignal,val);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : rAT_PercentBC      |
+--------------------------------------------------------------------+

  PURPOSE : called by ACI on change of battery status

*/

void rAT_PercentBC (BYTE val)
{
    TRACE_FUNCTION("rAT_PercentBC()");

//ES!! no longer needed    mmeSignal(MfwMmeBattery,val);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmePrimHandler     |
+--------------------------------------------------------------------+

  PURPOSE : MME primitive handler

*/

static BOOL mmePrimHandler (USHORT opc, void *data)
{
    U8 level;
    U8 state;
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005
#ifdef FF_MMI_AUDIO_PROFILE
    U8 hdsData;
    U8 cktData;
#endif
	

//    TRACE_FUNCTION ("mmePrimHandler()");

    switch (opc)
    {
        case MMI_RXLEV_IND:
            level = ((T_MMI_RXLEV_IND *) data)->rxlev;
            mmeSignal(MfwMmeSignal,level);
            return TRUE;                /* processed by MME, delete */
        case MMI_BATTERY_IND:
            level = ((T_MMI_BATTERY_IND *) data)->volt;
            state = ((T_MMI_BATTERY_IND *) data)->temp;
            if (battLevel != level)
            {
                battLevel = level;
                mmeSignal(MfwMmeBattery,level);
            }
            if (battState != state)
            {
                battState = state;
                mmeSignal(MfwMmeBaState,state);
            }
            return TRUE;                /* processed by MME, delete */
//  	xpradipg - LOCOSTO-ENH-31895 : 23 June 2005			
//	the corresponding callback function is called in MMI context
//	this comment will be removed once the sap for this is available
#ifdef FF_MMI_AUDIO_PROFILE
       case MMI_HEADSET_IND:
	   	TRACE_EVENT("MMI_HEADSET_IND");
           hdsData = ((T_MMI_HEADSET_IND *) data)->headset_status;
           mmeSignal(MfwMmeHeadset,hdsData);
           return TRUE;                
       case MMI_CARKIT_IND:
	   	TRACE_EVENT("MMI_CARKIT_IND");
           cktData = ((T_MMI_CARKIT_IND *) data)->carkit_status;
	    mmeSignal(MfwMmeCarkit, cktData);
           return TRUE;  
#endif
    }

    return FALSE;                       /* not processed, forward   */
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mmeFlagHandler     |
+--------------------------------------------------------------------+

  PURPOSE : MME driver flag handler

*/

void mmeFlagHandler (void)
{
    TRACE_FUNCTION ("mmeFlagHandler()");

    while (mfwMmeDrvFlag)
    {
        if (mfwMmeDrvFlag & MmeFlagRtcAlarm)
        {
            mfwMmeDrvFlag &= ~MmeFlagRtcAlarm;
            mmeSignal(MfwMmeRtcAlarm,0);
        }
        else if (mfwMmeDrvFlag & MmeFlagHdsDetect)
        {
            mfwMmeDrvFlag &= ~MmeFlagHdsDetect;
            mmeSignal(MfwMmeHdsDetect,hdsPresence);
        }
        else if (mfwMmeDrvFlag & MmeFlagIrdaMsg)
		{
		}
        else
        {
            mfwMmeDrvFlag = 0;
        }
    }
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : pwr_callback       |
+--------------------------------------------------------------------+

  PURPOSE : Called by battery driver

*/

static void pwrCb (drv_SignalID_Type *signal_params)
{
    pwr_Status_Type *para;
    PALLOC(battery_ind, MMI_BATTERY_IND);

    para = (pwr_Status_Type *) signal_params->UserData;
    battery_ind->volt = para->BatteryLevel;
    battery_ind->temp = para->Status;

    PSENDX(ACI,battery_ind);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : rx_callback        |
+--------------------------------------------------------------------+

  PURPOSE : Called by fieldstrength driver

*/

static void rxCb (drv_SignalID_Type *signal_params)
{
    rx_Status_Type *para;
    PALLOC(rxlevel_ind,MMI_RXLEV_IND);

    para = (rx_Status_Type *) signal_params->UserData;
    rxlevel_ind->rxlev = para->actLevel;

    PSENDX(ACI,rxlevel_ind);
}


/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : rtcCb              |
+--------------------------------------------------------------------+

  PURPOSE : alarm callback from RTC

*/

static void rtcCb (drv_SignalID_Type *signal_params)
{
    mfwMmeDrvFlag |= MmeFlagRtcAlarm;
    vsi_c_awake(VSI_CALLER_SINGLE);
}



/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : hdsCb              |
+--------------------------------------------------------------------+

  PURPOSE : callback from headset detection

*/

static void hdsCb (drv_SignalID_Type *signal_params)
{
	if (signal_params->SignalType == 1)
	{
		hdsPresence = (U16)signal_params->UserData;
	    mfwMmeDrvFlag |= MmeFlagHdsDetect;
		vsi_c_awake(VSI_CALLER_SINGLE);
	}
}
#ifdef FF_MMI_AUDIO_PROFILE
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_set_stereo_path              |
+--------------------------------------------------------------------+

  PURPOSE : This sets the stereo path for the current audio profile

*/

void mfw_set_stereo_path(int device)
{
	TRACE_FUNCTION("mfw_set_stereo_path()");

	TRACE_EVENT_P1("Device === %d", device);
	 switch(device)
	 {
	  case MFW_AUD_HEADSET:
	  	audio_set_path(AUDIO_STEREO_SPEAKER_HEADPHONE, TRUE);
	   	break;
	  case MFW_AUD_HANDHELD:
	   	audio_set_path(AUDIO_STEREO_SPEAKER_HANDHELD, TRUE);
	   	break;
	  case MFW_AUD_CARKIT:
	   	audio_set_path(AUDIO_STEREO_SPEAKER_CARKIT, TRUE);
		break;
	  case MFW_AUD_LOUDSPEAKER:
		audio_set_path(AUDIO_STEREO_SPEAKER_HANDFREE, TRUE);
	   	break;
	  }
}
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_unset_stereo_path              |
+--------------------------------------------------------------------+

  PURPOSE : This resets the voice path for the current audio profile

*/
void mfw_unset_stereo_path(int device)
{
	TRACE_FUNCTION("mfw_unset_stereo_path()");

	TRACE_EVENT_P1("Device === %d", device);
	switch(device)
	 {
	  case MFW_AUD_HEADSET:
	   	audio_set_path(AUDIO_SPEAKER_HEADSET, FALSE);
	   	break;
	  case MFW_AUD_HANDHELD:
	   	audio_set_path(AUDIO_SPEAKER_HANDHELD, FALSE);
	   	break;
	  case MFW_AUD_CARKIT:
	   	audio_set_path(AUDIO_SPEAKER_CARKIT, FALSE);
		break;
	  case MFW_AUD_LOUDSPEAKER:
		audio_set_path(AUDIO_SPEAKER_HANDFREE, FALSE);
	   	break;
	  }
}

/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_audio_headSet_indication              |
+--------------------------------------------------------------------+

  PURPOSE :Callback function for the events related to headset  and create and post a primitive

*/
void mfw_audio_headSet_indication ( T_AUDIO_ACCESSORY_NOTIFICATION notify, 
ACCESSORY_CALLBACK_PARAM callbackparam )
{

	PALLOC(hdsData,MMI_HEADSET_IND);
	hdsData->headset_status = (U8)notify;
	PSENDX(ACI,hdsData);

}
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_audio_headSet_indication              |
+--------------------------------------------------------------------+

  PURPOSE :Callback function for the events related to carkit and create and post a primitive

*/
void mfw_audio_carKit_indication ( T_AUDIO_ACCESSORY_NOTIFICATION notify, 
	ACCESSORY_CALLBACK_PARAM callback_param )
{
	PALLOC(cktData,MMI_CARKIT_IND);
	cktData->carkit_status = (U8)notify;
	PSENDX(ACI,cktData);
}
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_audio_headSet_indication              |
+--------------------------------------------------------------------+

  PURPOSE :handles the request to switch to the respective device from the 
		    Bmi when the indications of insert and removal are received

*/
void mfw_audio_device_indication( U8 notify)
{	
	TRACE_FUNCTION("mfw_audio_device_indication()");

	TRACE_EVENT_P1(" Indication Type == %d",notify);
	switch(notify)
	{	
		case AUDIO_HEADSET_PLUGGED:
			if(currAudioDevice != MFW_AUD_HEADSET)
			{
				mfw_audio_set_device(MFW_AUD_HEADSET);
					headsetInserted = TRUE;
			}
			break;
		case AUDIO_HEADSET_UNPLUGGED:
			if( currAudioDevice == MFW_AUD_HEADSET)
			{
				mfw_audio_set_device(MFW_AUD_HANDHELD );
	
			}
			headsetInserted = FALSE;
			break;
		case AUDIO_HEADSET_HOOK_DETECT:
				break;
		case AUDIO_CARKIT_PLUGGED:
			if(currAudioDevice != MFW_AUD_CARKIT)
			{
				mfw_audio_set_device(MFW_AUD_CARKIT);
				carkitInserted = TRUE;
			}
			break;
		case AUDIO_CARKIT_UNPLUGGED:
			if( currAudioDevice == MFW_AUD_CARKIT)
			{
				if(headsetInserted == TRUE)
				{
					mfw_audio_set_device (MFW_AUD_HEADSET);
				}
				else
				{
					mfw_audio_set_device (MFW_AUD_HANDHELD);
				}
			}
			carkitInserted = FALSE;
			break;
		default:
			break;
	}
}
/*
+--------------------------------------------------------------------+
| PROJECT : MMI-Framework (8417)        MODULE  : MFW_MME            |
| STATE   : code                        ROUTINE : mfw_audio_headSet_indication              |
+--------------------------------------------------------------------+

  PURPOSE :This function handles the switch between the handheld and loudspeaker. 
		    The type of device to be loaded will be posted from the menu selection
		    When the profile changes if there is any other media played then the 
		    speaker should be set to stereo speaker

*/
void mfw_audio_set_device(int type)
{
/*Description: this array holds the file names on the ffs in which the audio profiles are stored.
The file names are yet to be confirmed from the audio services group*/
	//char aud_cg_file[4][15] = {"handheld","loudspeaker","headset","carkit"};
	TRACE_FUNCTION("mfw_audio_set_device()");

	TRACE_EVENT_P1("type of device = %d",type);
	switch(type)
	{
		case MFW_AUD_HANDHELD:
			audio_set_device((char*)HANDHELD);// (aud_cg_file[HANDHELD] );
			currAudioDevice = MFW_AUD_HANDHELD;
			break;
		case MFW_AUD_LOUDSPEAKER:
			audio_set_device((char*) LOUDSPEAKER);//(aud_cg_file[LOUDSPEAKER]);
			currAudioDevice = MFW_AUD_LOUDSPEAKER;
			break;
		case MFW_AUD_HEADSET:
			audio_set_device((char*)HEADSET);//(aud_cg_file[HEADSET]);
			currAudioDevice = MFW_AUD_HEADSET;
			break;
		case MFW_AUD_CARKIT:
			audio_set_device((char*)CARKIT);//(aud_cg_file[CARKIT]);
			currAudioDevice = MFW_AUD_CARKIT;
		default:
			break;
	}
	if(TRUE == mfwAudPlay)
  		mfw_set_stereo_path(currAudioDevice);

}

#ifdef ISAMPLE
/* OMAPS00057367, 3 Dec 2005, nekkareb : start */
/* Function mfw_get_current_audioDevice modified to read the
     current audio device using the audio service entity function
     audio_full_access_read. This solves some synchronisation
     problems b/n Audio & MMI for the DR OMAPS00057367 */
/*returns the current active audio device*/     
int mfw_get_current_audioDevice()
{
	T_AUDIO_FULL_ACCESS_READ read;
	INT8 speaker;

	read.variable_indentifier = AUDIO_SPEAKER_MODE;
	read.data = &speaker;
	
	TRACE_FUNCTION("mfw_get_current_audioDevice()");
	audio_full_access_read(&read );

	switch(speaker)
	{
	case AUDIO_SPEAKER_NONE:
		TRACE_EVENT("mfw_get_current_audioDevice() - SPEAKER PATH NOT CONFIGURED");
		currAudioDevice = MFW_AUD_HANDHELD; //Need to check the mapping
		break;
	case AUDIO_SPEAKER_HANDHELD:
		currAudioDevice = MFW_AUD_HANDHELD;
		break;
	case AUDIO_SPEAKER_HEADSET:
		currAudioDevice = MFW_AUD_HEADSET;
		break;
	case AUDIO_SPEAKER_AUX:
		currAudioDevice = MFW_AUD_LOUDSPEAKER; //Need to check the mapping
		break;
	case AUDIO_SPEAKER_CARKIT:
		currAudioDevice = MFW_AUD_CARKIT;
		break;
	case AUDIO_SPEAKER_HANDFREE:
	case AUDIO_SPEAKER_HANDFREE_CLASS_D:
		currAudioDevice = MFW_AUD_LOUDSPEAKER;
		break;
	case AUDIO_SPEAKER_INVERTED_VOICE:
		currAudioDevice = MFW_AUD_HEADSET; //Need to check the mapping
		break;
	}

	return currAudioDevice;
}
/* OMAPS00057367, 3 Dec 2005, nekkareb : end */
#else
/*returns the current active audio device*/
int mfw_get_current_audioDevice()
{
	TRACE_FUNCTION("mfw_get_current_audioDevice()");
	return currAudioDevice;
}
#endif //ISAMPLE
#endif


