/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: mfw_lng.h       $|
| $Author:: Kk  $ CONDAT GmbH           $Revision:: 2               $|
| CREATED: 27.08.99                     $Modtime:: 10.03.00 11:38   $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_LNG

   PURPOSE : Language Handler types & constants

   EXPORT  :

   TO DO   :

   $History:: mfw_lng.h                                             $
 * 
 * *****************  Version 2  *****************
 * User: Kk           Date: 14.03.00   Time: 15:48
 * Updated in $/GSM/Condat/MS/SRC/MFW
 * added handling of various texts
 * 
 * *****************  Version 1  *****************
 * User: Le           Date: 4.01.00    Time: 13:09
 * Created in $/GSM/Condat/MS/SRC/MFW
 * 
 * *****************  Version 2  *****************
 * User: Es           Date: 22.11.99   Time: 10:29
 * Updated in $/GSM/Condat/SND-MMI/MFW
 * 
 * *****************  Version 1  *****************
 * User: Es           Date: 18.11.99   Time: 16:35
 * Created in $/GSM/Condat/SND-MMI/MFW
 * Initial
*/

#ifndef _DEF_MFW_LNG_H_
#define _DEF_MFW_LNG_H_

#include "mfw_mfw.h"




typedef struct LngInfoTag               /* Language information     */
{
    int language;                       /* selected language        */
    unsigned int nPrompts;              /* number of prompts & text */
    const char* const* const* prompts;  /* prompts and menu texts   */
} LngInfo;

typedef struct MfwLngTag                /* LANGUAGE CONTROL BLOCK   */
{
    MfwEvt map;                         /* selection of events      */
    MfwEvt evt;                         /* current event            */
    MfwCb handler;                      /* event handler            */
    LngInfo *lng;                       /* language info block      */
} MfwLng;

                                        /* EVENTS                   */

                                        /* PROTOTYPES               */
MfwRes lngInit   (void);
MfwRes lngExit   (void);
MfwHnd lngCreate (MfwHnd w, MfwEvt e, LngInfo *lng, MfwCb f);
MfwRes lngDelete (MfwHnd h);
char * lngText   (MfwHnd h, unsigned int t);
void   lngSignal (void/*char make, char key*/);

#endif

