/*
+--------------------------------------------------------------------+
| PROJECT:	MMI-Framework (8417)		$Workfile::	mfw_fv.h	    $|
| $Author::	NDH							$Revision::	1			    $|
| CREATED:	21.05.04		     		$Modtime::	21.05.04	 14:58	$|
| STATE  :	code														 |
+--------------------------------------------------------------------+

   MODULE  : MFW_FV

   PURPOSE :This module contains File Viewer Interface functions.

   HISTORY  :

    Aug 22, 2005    REF: ENH 31154 xdeepadh
   	Description: Application to Test Camera
   	Solution: Implemeted the Fileviewer to view the jpeg images.Camera Application to 
   	preview,capture and save image has been implemented.
	

*/
#ifndef DEF_MFW_FV
#define DEF_MFW_FV

//Defines 

#define SCREEN_SIZE_X 				176	
#define SCREEN_SIZE_Y 				220	
#define  SK_HEIGHT_LATIN				24

#define FV_DSPL_WIDTH 				 SCREEN_SIZE_X
#define FV_DSPL_HEIGHT 				 (SCREEN_SIZE_Y - SK_HEIGHT_LATIN)
#define FV_DSPL_VOLUME 				FV_DSPL_WIDTH * FV_DSPL_HEIGHT

#define  FV_SCALE_VOLUME  			 FV_DSPL_VOLUME / 4

#define MFW_ZOOM_WIDTH_DELTA  	32
#define MFW_ZOOM_HEIGHT_DELTA  	35 


//Defines for zooming
#define FV_NO_ZOOM 		0
#define FV_ZOOM_IN 		1
#define FV_ZOOM_OUT 	2

//Defines for rotation
#define FV_ROTATE_90	 0
#define FV_ROTATE_180 	 1
#define FV_ROTATE_270 	 2
#define FV_ROTATE_360 	 3

int mfw_fv_decode_image(UBYTE * inputbuffer, int size);
SHORT  mfw_fv_zoom_image();
SHORT  mfw_fv_rotate_image();

#endif  //DEF_MFW_FV
