/*
+--------------------------------------------------------------------+
| PROJECT:	MMI-Framework (8417)		$Workfile::	mfw_fv.c	    $|
| $Author::	NDH							$Revision::	1			    $|
| CREATED:	21.05.04		     		$Modtime::	21.05.04 14:58	$|
| STATE  :	code														 |
+--------------------------------------------------------------------+

   MODULE  : MFW_FV

   PURPOSE : This module contains File Viewer Interface functions.

   HISTORY  :
   	Oct 06, 2005    REF: SPR 34560 xdeepadh
   	Description: File Viewer: Image stored in the FFS is not displayed in the file viewer
   	Solution: Screen updation will be performed , soon after the decoding/color conversion 
   	of the image is completed.
   	
   	Aug 22, 2005    REF: ENH 31154 xdeepadh
   	Description: Application to Test Camera
   	Solution: Implemeted the Fileviewer to view the jpeg images.Camera Application to 
   	preview,capture and save image has been implemented.
	
*/

#define ENTITY_MFW
/*
** Include Files
*/

/* includes */
#include <string.h>
#include "typedefs.h"
#include "mfw_mfw.h"
#include "mfw_sys.h"
#include "mfw_fv.h"

//Includes of IMGIL
#include "img/imgil1_api.h"
#include "img/imgil1_i.h"
#include "gil/gil_gpf.h"
#include "dspl.h"



//Variable defines

T_IMG_YUV_BUFFER qcif_yuv_tempbuf;
extern UINT8 qcif_yuv_lum[FV_DSPL_VOLUME]; 		 //decoded and Scaled  lum buffer
extern UINT8 qcif_yuv_cb[FV_SCALE_VOLUME];		//decoded and Scaled cb  buffer
extern UINT8 qcif_yuv_cr[FV_SCALE_VOLUME];		//decoded and Scaled cr buffer

extern UINT8 qcif_rgb_array[ FV_DSPL_VOLUME  *  2];			//Color converted buffer to view
extern UINT8 rgb_img_process_array[FV_DSPL_VOLUME  *  2];  	//Color converted buffer for zoom/rotate

T_IMG_YUV_BUFFER qcif_process_buffer;
extern UINT8 qcif_yuv_process_lum[FV_DSPL_VOLUME ];		//lum buffer for rotate and zoom
extern UINT8 qcif_yuv_process_cb[FV_SCALE_VOLUME];		//cb buffer for rotate and zoom
extern UINT8 qcif_yuv_process_cr[FV_SCALE_VOLUME];		//cr buffer for rotate and zoom

extern UBYTE  zoom_flag;
extern UBYTE  rotate_flag;

//Function Prototypes
static void mfw_fv_change_format_cb(void *parameter);
static void mfw_fv_zoom_cb(void *parameter);
static void mfw_fv_rotate_cb(void *parameter);
static void mfw_fv_color_convert_cb(void *parameter);
static void mfw_fv_process_cb(void *parameter);
GLOBAL UBYTE mfw_fv_display_image_in_center(
                          USHORT in_Width,
                          USHORT in_Height,
                          void * in_BmpPtr,
                          USHORT in_index,
                          int bmpFormat,
                          USHORT dsplWidth,
                          USHORT dsplHeight);



/*******************************************************************************

 $Function:     mfw_fv_decode_image

 $Description:		decode the jpeg image
 
 $Returns: Status

 $Arguments:		inputbuffer -Input Buffer
 				size- Size of the Input Buffer
 				

*******************************************************************************/

int  mfw_fv_decode_image(UBYTE * inputbuffer, int size)
{
	T_IMG_CHANGE_FORMAT_PARAM change_param;
	T_IMG_RETURN ret;

	TRACE_EVENT("mfw_fv_decode_image");
	
	qcif_yuv_tempbuf.lum = qcif_yuv_lum;
	qcif_yuv_tempbuf.cb = qcif_yuv_cb;
	qcif_yuv_tempbuf.cr = qcif_yuv_cr;
	qcif_yuv_tempbuf.width = FV_DSPL_WIDTH;
	qcif_yuv_tempbuf.height =FV_DSPL_HEIGHT;

	change_param.input_image_format = IMG_FORMAT_JPG ;
	change_param.decode_param.x_offset = 0;
	change_param.decode_param.y_offset = 0;
	change_param.decode_param.sampling_factor = 1;
	change_param.decode_param.num_rows = 0;
	change_param.decode_param.scaling_factor = 2;
	//This is the dummy parameter .The source color format will be retrieved  by reading the jpeg header.
	change_param.output_format.color_format = IMG_YUV420; 
	//The width and height should not be taken based on the resolution.
	change_param.output_format.resolution = 0; 
	change_param.output_format.x_length = FV_DSPL_WIDTH;		
	change_param.output_format.y_length = FV_DSPL_HEIGHT;

	//Call the Change Format API to decode/scale and color convert
	//Decode  and Scale the input image.

	ret = imgil_change_format((UINT8*)inputbuffer,size,change_param,&qcif_yuv_tempbuf,mfw_fv_change_format_cb,NULL);

	if(ret == IMG_OK)
	{
		TRACE_EVENT("mfw_fv_decode_image---OK");
		return 1;
	}
	else 
	{
		TRACE_EVENT("mfw_fv_decode_image--FAIL");
		return 0;
	}
}


/*******************************************************************************

 $Function:     mfw_fv_change_format_cb

 $Description: Callback for img_change_format.

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_fv_change_format_cb(void *parameter)
{
	T_IMG_RETURN ret;
	T_IMG_COLORCONV_PARAM color_param;
	UBYTE color_format;
	
	TRACE_EVENT("mfw_fv_change_format_cb()");
	color_param.actWidht = qcif_yuv_tempbuf.width;
	color_param.actHeight = qcif_yuv_tempbuf.height;
	color_param.srcClrFfmt =qcif_yuv_tempbuf.color_format;
	color_param.numBytes = 0;
	color_param.destClrFmt = IMG_RGB565 ;

	//Call the Color Conversion API
	memset(qcif_rgb_array,0,sizeof(qcif_rgb_array));
	imgil_color_convert(&qcif_yuv_tempbuf,color_param,qcif_rgb_array,mfw_fv_color_convert_cb);
}

/*******************************************************************************

 $Function:     mfw_fv_color_convert_cb

 $Description: Callback for imgil_color_convert API.

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_fv_color_convert_cb(void *parameter)
{
	TRACE_EVENT("mfw_fv_color_convert_cb()");
	//Draw the image on the LCD
	mfw_fv_display_image_in_center(qcif_yuv_tempbuf.width,qcif_yuv_tempbuf.height, qcif_rgb_array,0,0x05,FV_DSPL_WIDTH,FV_DSPL_HEIGHT);
}

/*******************************************************************************

 $Function:     mfw_fv_zoom_image

 $Description:		zoom the jpeg image

 $Returns: Status

 $Arguments:None
 				

*******************************************************************************/

SHORT  mfw_fv_zoom_image()
{
	T_IMG_SCALE_PARAM scale_param;
	T_IMG_RETURN ret;
	
	TRACE_FUNCTION("mfw_fv_zoom_image");

	qcif_process_buffer.lum = qcif_yuv_process_lum;
	qcif_process_buffer.cb = qcif_yuv_process_cb;
	qcif_process_buffer.cr = qcif_yuv_process_cr;
	qcif_process_buffer.width =0;
	qcif_process_buffer.height=0;
		
	scale_param.srcClrFmt = qcif_yuv_tempbuf.color_format;

	//Set the Zoom Parameters
	if(zoom_flag == FV_ZOOM_OUT)
		{
			//Zoom out the complete image to a smaller size
			scale_param.x_offset = 0 ;
			scale_param.y_offset = 0;
			scale_param.cropWidth = qcif_yuv_tempbuf.width ;
			scale_param.cropHeight = qcif_yuv_tempbuf.height;
			qcif_process_buffer.width = qcif_yuv_tempbuf.width  - MFW_ZOOM_WIDTH_DELTA;
			qcif_process_buffer.height = qcif_yuv_tempbuf.height - MFW_ZOOM_HEIGHT_DELTA;
			
		}
	else  //FV_ZOOM_IN
		{
			//Zoom out the central portion of the image to the display width and height
			scale_param.x_offset=MFW_ZOOM_WIDTH_DELTA ;		
			scale_param.y_offset=MFW_ZOOM_HEIGHT_DELTA;	
			scale_param.cropWidth=qcif_yuv_tempbuf.width - 2  *  MFW_ZOOM_WIDTH_DELTA;		
			scale_param.cropHeight=qcif_yuv_tempbuf.height - 2  *  MFW_ZOOM_HEIGHT_DELTA;		
			qcif_process_buffer.width = FV_DSPL_WIDTH;
			qcif_process_buffer.height = FV_DSPL_HEIGHT;
			
		}

	//Call the Scaling  API to zoom in or out based on the scaling parameters
	memset(qcif_yuv_process_lum,0,sizeof(qcif_yuv_process_lum));
	memset(qcif_yuv_process_cb,0,sizeof(qcif_yuv_process_cb));
	memset(qcif_yuv_process_cr,0,sizeof(qcif_yuv_process_cr));
	ret = imgil_scale(&qcif_yuv_tempbuf,scale_param,&qcif_process_buffer,mfw_fv_zoom_cb);
return 1;
}

/*******************************************************************************

 $Function:     mfw_fv_zoom_cb

 $Description: Callback function for imgil_scale

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_fv_zoom_cb(void *parameter)
{

	T_IMG_COLORCONV_PARAM color_param;

	TRACE_EVENT("mfw_fv_zoom_cb()");
	
	//Set the color conversion parameters
	color_param.actWidht = qcif_process_buffer.width;
	color_param.actHeight =qcif_process_buffer.height ;
	color_param.srcClrFfmt = qcif_yuv_tempbuf.color_format;
	color_param.numBytes = 0;
	color_param.destClrFmt = IMG_RGB565 ;
	
	memset(rgb_img_process_array,0,sizeof(rgb_img_process_array));
	//Call the Color Conversion API
	imgil_color_convert(&qcif_process_buffer,color_param,rgb_img_process_array,mfw_fv_process_cb);
}

/*******************************************************************************

 $Function:     mfw_fv_process_cb

 $Description: Callback for imgil_color_convert API while zooming and rotating

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_fv_process_cb(void *parameter)
{
	TRACE_EVENT("mfw_fv_process_cb()");

	//Draw the image on the LCD
	mfw_fv_display_image_in_center(qcif_process_buffer.width,qcif_process_buffer.height,rgb_img_process_array,0,BMP_FORMAT_16BIT_LCD_COMPRESSED_COLOUR,FV_DSPL_WIDTH,FV_DSPL_HEIGHT);
	
	if( rotate_flag == FV_ROTATE_90 || rotate_flag == FV_ROTATE_270)
		{
			//Unset the flag
			rotate_flag = FV_ROTATE_360;
		}
	else 	if(zoom_flag  ==  FV_ZOOM_OUT || zoom_flag == FV_ZOOM_IN)
		{
			//Unset the flag
			zoom_flag = FV_NO_ZOOM;
		}
}

/*******************************************************************************

 $Function:     mfw_fv_rotate_image

 $Description:		Rotate the jpeg image

 $Returns: Status

 $Arguments: None
 				

*******************************************************************************/

SHORT  mfw_fv_rotate_image()
{
	T_IMG_ROTATION_PARAM rotate_param;
	T_IMG_RETURN ret;
	
	TRACE_FUNCTION("mfw_fv_rotate_image");

	qcif_process_buffer.lum = qcif_yuv_process_lum;
	qcif_process_buffer.cb = qcif_yuv_process_cb;
	qcif_process_buffer.cr = qcif_yuv_process_cr;
	qcif_process_buffer.width =qcif_yuv_tempbuf.width;
	qcif_process_buffer.height=qcif_yuv_tempbuf.height;
		
	//Set the Rotate Parameters
	if(rotate_flag == FV_ROTATE_90)
		{
			rotate_param.rotate_flag = 1 ;
		}
	else if(rotate_flag == FV_ROTATE_180)
		{
			rotate_param.rotate_flag = 2 ;
		}
	else if(rotate_flag == FV_ROTATE_270)
		{
			rotate_param.rotate_flag = 3 ;
		}
	
	rotate_param.srcClrFmt = qcif_yuv_tempbuf.color_format;
	
	memset(qcif_yuv_process_lum,0,sizeof(qcif_yuv_process_lum));
	memset(qcif_yuv_process_cb,0,sizeof(qcif_yuv_process_cb));
	memset(qcif_yuv_process_cr,0,sizeof(qcif_yuv_process_cr));
	//Call the Rotate API to rotate by the set degree
	ret = imgil_rotate(&qcif_yuv_tempbuf,rotate_param,&qcif_process_buffer,mfw_fv_rotate_cb);
return 1;
}


/*******************************************************************************

 $Function:     mfw_fv_rotate_cb

 $Description: Callback function for imgil_roate 

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_fv_rotate_cb(void *parameter)
{
	T_IMG_COLORCONV_PARAM color_param;

	TRACE_EVENT("mfw_fv_rotate_cb()");

	//Set the Color Conversion Parameters
	color_param.actWidht =	 qcif_process_buffer.width;
	color_param.actHeight = qcif_process_buffer.height;
	color_param.actWidht = qcif_process_buffer.width;
	color_param.actHeight = qcif_process_buffer.height;
	color_param.srcClrFfmt =qcif_yuv_tempbuf.color_format;
	color_param.numBytes = 0;
	color_param.destClrFmt = IMG_RGB565 ;
	
	memset(rgb_img_process_array,0,sizeof(rgb_img_process_array));
	//Call the color Conversion API
	imgil_color_convert(&qcif_process_buffer,color_param,rgb_img_process_array,mfw_fv_process_cb);
}

/*******************************************************************************

 $Function:		mfw_fv_init

 $Description:		This function initialises the imgil interface.

 $Returns:		None

 $Arguments:		None

*******************************************************************************/
void mfw_fv_init(void)
{
	TRACE_EVENT("mfw_fv_init()");
	// Initialize IMGIL interface.
	if (imgil_init() != RV_OK)
	{
	    // @todo : use correct return code for error cases !
	    return ;
	}
}

/*******************************************************************************

 $Function:		mfw_fv_exit

 $Description:		This function will tidy up any resources used by the Mfw FileViewer Module
 				on Power Down

 $Returns:		None

 $Arguments:		None

*******************************************************************************/
void mfw_fv_exit(void)
{
	TRACE_EVENT("mfw_fv_exit()");
	/* nothing to do here... RAM will be automatically cleaned, and the flash wasn't modified */
}

/***********************************************************************************************************************
 $Function:		mfw_fv_display_image_in_center

 $Description:		This function will display the image in the center

 $Returns:		None

 $Arguments:		None

***********************************************************************************************************************/
GLOBAL UBYTE mfw_fv_display_image_in_center(
                          USHORT in_Width,
                          USHORT in_Height,
                          void * in_BmpPtr,
                          USHORT in_index,
                          int bmpFormat,
                          USHORT dsplWidth,
                          USHORT dsplHeight)
{
	 int x_offset,y_offset;
	 x_offset = (dsplWidth - in_Width) / 2 ;
	 y_offset = (dsplHeight- in_Height) / 2 ;

	 TRACE_EVENT_P2("width and height are %d ---%d",in_Width,in_Height);
	 TRACE_EVENT_P2("x and y offset are %d ---%d",x_offset,y_offset);
	 
	 if(zoom_flag == FV_ZOOM_OUT)
	 	{
	 		dspl_BitBlt2(x_offset,11,in_Width,in_Height,in_BmpPtr,in_index,bmpFormat);
			//Oct 06, 2005    REF: SPR 34560 xdeepadh
			//Screen updation will be performed , soon after the decoding/color conversion 
			//of the image is completed.
			dspl_Enable(1);
	 	}
	 else
	 	{
			#if 0
			if(in_Height < dsplHeight)
				{
					TRACE_EVENT("The height is lesser ");
					
					dspl_BitBlt2(x_offset,11,in_Width,in_Height,in_BmpPtr,in_index,bmpFormat);
				}
			else
				{
		       #endif		
					dspl_BitBlt2(x_offset,0,in_Width,in_Height,in_BmpPtr,in_index,bmpFormat);
					//Oct 06, 2005    REF: SPR 34560 xdeepadh
					//Screen updation will be performed , soon after the decoding/color conversion 
					//of the image is completed.
				       dspl_Enable(1);
	 	}
			return 1;
}



