/*
+--------------------------------------------------------------------+
| PROJECT:	MMI-Framework (8417)		$Workfile::	mfw_ffs.h    			$|
| $Author::								$Revision::	1			    	$|
| CREATED:			     		$Modtime::								$|
| STATE  :	code														  |
+--------------------------------------------------------------------+

   MODULE  : mfw_ffs

   PURPOSE : This module contains FFS Interface function declarations.

   HISTORY:

	Nov 14, 2005    REF: OMAPS00044445 xdeepadh
	Description: Implementation of Test Menu for AAC
	Solution: The existing MP3 test Application has been enhanced to support the AAC file testing.
	The interfaces have been made generic to support both MP3 and AAC files.

   	Sep 27,2005 REF: SPR 34402 xdeepadh  
	Bug:Mono option is always highlighted even when Stereo is selected
	Fix:The channel setting will be saved in the FFS, which will be retrieved later
		and the selected channel will be higlighted.
	
	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154
 	Description:	Application to test camera
 	Solution:	Implemented the camera application with following functionalities
 			preview, snapshot and image saving.
 			
	Apr 14, 2005	REF: CRR 29991   xpradipg
	Description:	Optimisation 5: Remove the static allocation and use dynamic 
					allocation/ deallocation for pb_list and black_list
	Solution:	The static definition is removed and replaced with the dynamic
					allocation   
   

    Aug 25, 2004  REF: CRR 20655  xnkulkar
    Description: Voice Memo functionality not working
    Solution:	  Added the prototype for flash_makedir() function.
    			 
*/

#ifndef MFW_FFS_H_
#define MFW_FFS_H_

/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#ifndef NEPTUNE_BOARD
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/
#include "ffs/ffs.h" /*SPR 1920*/
/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#else
#include "ffs.h"
#endif
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/

#ifndef PCM_2_FFS
#include "ffs_coat.h"
#endif

#ifdef FF_MMI_RINGTONE
#define MAX_RINGER_FILE_SIZE  50
#endif
typedef struct
{   uint8 IMEI[16]; 	/* in ASCII*/
    uint8 IMEI_bcd[8]; 	/*in BCD*/
	/*SPR 1725 removed date time and alarm data*/
	/*Call timers*/
	uint32 last_call_duration;
	uint32 incoming_calls_duration;
	uint32 outgoing_calls_duration;

	/*MSSET data*/

	uint8 output_volume;
	uint8 external_audio;
	uint8 voice_memo_position;
	uint8 PLMN_selection_mode;
	uint8 CLIR; //seem to only be used for supplementary services.
//  Jun 23, 2004    REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
//              		Storing the CF state in Flash						
 uint8 CFState;
	
//Jun 23, 2004      REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
//				Comented "uint8 CLIP" as it is not being used anywhere in the code currently.
// uint8 CLIP; 
	uint8 redial_mode;
	uint8 call_info_display;
	uint8 contrast;
	uint8 brightness;
	uint8 backlight_duration;
    uint8 recent_ldn_ref;
    uint8 recent_lrn_ref;
    uint8 recent_upn_ref;
    uint8 time_format;

 	/* Network Log              */
    uint8 net_log_status;                 /* status                   */
    uint8 plmn_name[20];                /* plmn name                */
    uint8 network_name [6];             /* plmn name numeric        */

    /*Setting status*/

	uint8 settings_status;

	uint8 voice_mail[22];

	/*mailbox number*/
	uint8 mbn_AlphId[10];
	uint8 mbn_len;
	uint8 mbn_numTp;
	uint8 mbn_Num[10];

	/*ringtones etc for MMisounds*/
	uint8 ringer;							// index of permanent active tune in soundlist and ringerItem
	uint8 vibrator;							// vibrator
	uint8 volumeSetting;					// values (0 = silent, 4= loud, 5 = increasing)
	uint8 keypadOn;							// on/off values
	uint8 AlarmOn;
	uint8 OrganiserAlert;
	uint8 CreditLow;
	uint8 SMSTone;
	uint8 SMSBroadcast;
	uint8 battLow;
	uint8 earpiece;
	uint8 language;
	uint8 Equalizer;

    /*Data for MmiSmsBroadcast*/


	//Predictive text Flags
	uint8 PredTextAvailable;
	uint8 PredTextSelected;

	//API - 01/10/02
	//Concatenate Flags 
	uint8 ConcatenateStatus;

	//API - 06/12/02
	//Idle Screen Background image
	uint8 IdleScreenBgd;
	uint8 MainMenuBgd;
	uint8 ProviderNetworkShow;

	//CPHS ALS info
	uint8 als_selLine;
  	uint8 als_statLine;

  	uint8 ccbs_status;  /* Marcus: CCBS: 13/11/2002 */

  	/* MC SPR 1392, call deflection flag*/
	uint8 call_deflection;


  	/* SPR#1352 - SH - TTY */
  	uint8 ttyAlwaysOn;

	/*API CQ10203 - Add the Flash define for Validity Period here*/
	uint8 vp_rel;
       uint8 image_usr_obj; // xrashmic 7 Dec, 2004 MMI-SPR-26161 and MMI-SPR-23965
       uint8 audio_usr_obj; // xrashmic 7 Dec, 2004 MMI-SPR-26161 and MMI-SPR-23965
//	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154      
#ifdef FF_MMI_TEST_CAMERA       
       uint8	camera_file_counter;
#endif
//Nov 14, 2005    REF: OMAPS00044445 xdeepadh
#if defined(FF_MMI_TEST_MP3) ||  defined(FF_MMI_TEST_AAC) 
//Sep 27,2005 REF: SPR 34402 xdeepadh   
//Variable to store the state of mp3 channel
 uint8	player_channel_state;
#endif
#ifdef FF_MMI_RINGTONE
char cpRingerFilePath [MAX_RINGER_FILE_SIZE];
char cpSMSFilePath[MAX_RINGER_FILE_SIZE];
char cpAlarmFilePath[MAX_RINGER_FILE_SIZE];
#endif
} FlashData;

extern FlashData FFS_flashData;

//flash access routines
effs_t flash_write(void);
int flash_read(void);
    /* Marcus: Issue 1719: 11/02/2003:
     * Changed return type to int: zero (EFFS_OK) if successful,
     * presumably -ve for errors, as in FFS_ERRORS (else read less than asked
     * for, but that value is internal to the function)
     */
effs_t flash_update(void);

//Generic flash access routines.
effs_t flash_data_write(const char* dir_name, const char* file_name, void* data_pointer, int data_size);
int flash_data_read(const char* dir_name, const char* file_name, void* data_pointer, int data_size);
     /* Marcus: Issue 1719: 11/02/2003:
      * Changed return type to int: data_size if successful,
      * presumably -ve for errors, as in FFS_ERRORS (else read less than asked for)
      */

     /* Aug 25, 2004  REF: CRR 20655  xnkulkar
         Added the prototype for flash_makedir() function
     */ 
void flash_makedir(char * dir_name); 
//	Apr 14, 2005	REF: CRR 29991   xpradipg
#ifdef FF_MMI_OPTIM
	int8 flash_MMI_blackList_open( );
	void flash_MMI_blackList_close(int8 handle);
	int flash_MMI_blackList_write(U8 *data, SHORT len, SHORT offset);
	int flash_MMI_blackList_read(int8 file,U8* data, SHORT len, SHORT offset);
#ifdef PCM_2_FFS
	T_FFS_SIZE ffs_ReadRecord(const char *name, void * addr, int size, int index, int recsize);
	T_FFS_RET ffs_WriteRecord(const char *name, void * addr, int size, int index, int recsize);
#endif
#endif
#endif
