/*
+--------------------------------------------------------------------+
| PROJECT:	MMI-Framework (8417)		$Workfile::	mfw_cam.h	    $|
| $Author::	NDH							$Revision::	1			    $|
| CREATED:	21.05.04		     		$Modtime::	21.05.04	 14:58	$|
| STATE  :	code														 |
+--------------------------------------------------------------------+

   MODULE  : MFW_CAM

   PURPOSE : This module contains the definitions for the Camera Interface.
/***********************************************************************************************
  $History: mfw_cam.h
  
  	Sep 13, 2005    REF: SPR 33992 xdeepadh
	Description: Image viewer cannot open file when saved in high quality
	Solution: The quality factor has been rearranged to support saving
	the images within 64KBlimit.
	
 	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154
 	Description:	Application to test camera
 	Solution:	Implemented the camera application with following functionalities
 			preview, snapshot and image saving.
************************************************************************************************/



#include "rv_swe.h"

//Different Camera States
#define CAMERA_STATE_IDLE			0
#define CAMERA_STATE_VIEWFINDER 	1
#define CAMERA_STATE_CONFIGURE	2
#define CAMERA_STATE_SNAPSHOT	3
#define CAMERA_STATE_SAVE			4

//Sep 13, 2005    REF: SPR 33992 xdeepadh
//The quality factor has been rearranged.
//Quality Factor
#define QUALITY_ECONOMY 			40
#define QUALITY_STANDARD  			55
#define QUALITY_HIGH  				65

#define CT_FILE_NAME_LENGTH 		15
#define CT_FULL_PATH_LENGTH 		10 + CT_FILE_NAME_LENGTH
#define CT_MAX_FILE 				10

#define JPEG_CONTENT_DIR   			"/mmi/jpeg"

/* Camera Test Return Values	*/
#define MFW_CAM_OK					(0)
#define MFW_CAM_FAILED			(-1)


/* Camera Test Functions Prototypes */
SHORT mfw_cam_take_snapshot(void);
SHORT mfw_cam_save_snapshot(void);
void mfw_cam_init(void);
void mfw_cam_exit(void);
T_MFW_HND mfw_camera_test_create(T_MFW_HND hWin, T_MFW_EVENT event, T_MFW_CB cbfunc);
SHORT mfw_cam_disable_sensor(void);
void mfw_cam_set_quality_factor(UBYTE factor);
UBYTE mfw_cam_get_quality_factor();
void  mfw_cam_set_viewfinder_mode(void);

