/*
+--------------------------------------------------------------------+
| PROJECT:	MMI-Framework (8417)		$Workfile::	mfw_cam.c	    $|
| $Author::	NDH							$Revision::	1			    $|
| CREATED:	21.05.04		     		$Modtime::	21.05.04 14:58	$|
| STATE  :	code														 |
+--------------------------------------------------------------------+

   MODULE  : MFW_CAM

   PURPOSE : This module contains Camera Interface functions.

   HISTORY:

       Nov 29, 2005 REF: MMI-SPR-33833(OMAPS00055207)- x0035544
       MMI making Riviera calls without using proper header files. So added appropriate header files.
       
    	Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
	Description: Locosto: MIgration to New LCD APIs
	Solution: Migrated to New APIs by replacing the old driver APIs with
	corresponding New LCD APIs

   	Sep 13, 2005    REF: SPR 33992 xdeepadh	
	Description: Image viewer cannot open file when saved in high quality	
	Solution: The quality factor has been rearranged to support saving	the images within 64KBlimit.

 	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154
 	Description:	Application to test camera
 	Solution:	Implemented the camera application with following functionalities
 			preview, snapshot and image saving.

*/


/*
** Include Files
*/

#define ENTITY_MFW
/* includes */
#include <string.h>


#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#include "message.h" /* included for aci_cmh.h .... */
#include "prim.h" /* included for aci_cmh.h .... */
#include "aci_cmh.h" /* included for mfw_sat.h, included for MmiDummy.h, included for MmiMenu.h */


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_cam.h"

//#include "img/img_api.h" //included for img_message.h
//#include "img/img_message.h"

#include "mks/mks_api.h"

//#include "r2d/lcd_messages_ti.h"
//#include "r2d/lcd_messages.h"
#include "r2d/r2d.h"
//#include "cama/cama_cfg.h"
//#include "cama/cama_i.h"
#include "cama/camil_api.h"
#include "cama/camil_i.h"
//#include "gil/gil_gpf.h"
#include "ffs/ffs_api.h"
#include "mfw_ffs.h"

#if (BOARD == 71)
#define ISAMPLE
#endif
//x0035544 29 Nov, 2005 MMI-SPR-55207
#ifndef NEPTUNE_BOARD //x0035544 Sudha - Guarded the below header file for Neptune.
#include "rv/rv_general.h"
#endif

#include "dspl.h"


/*Variable declarations*/

//Variable to track the different Camera states.
UBYTE camera_state = CAMERA_STATE_IDLE;

//Variable to store the quality factor.
static UBYTE quality_factor = QUALITY_STANDARD;

T_CAMA_VIEWFINDER_PARAMETERS viewfinder_parameters;  //For Future Use, when viewfinder parameters can be configured.

//File name for the jpeg image to be saved in FFS.
extern char new_filename[CT_FILE_NAME_LENGTH];

//Flag to check whether viewfinder parameter configuration has changed.
UBYTE configure_flag = FALSE;

//Riviera Callback Functions for CAMIL API
static void mfw_cam_save_image_cb(void *parameter);
static void mfw_cam_get_viewfinder_param_cb(void *parameter);
static void mfw_cam_set_viewfinder_param_cb(void *parameter);
static void mfw_cam_set_viewfinder_mode_cb(void *parameter);
static void mfw_cam_enable_viewfinder_mode_cb(void *parameter);
static void mfw_cam_disable_viewfinder_mode_cb(void *parameter);

//Local function prototypes
void mfw_cam_set_viewfinder_param(T_CAMA_VIEWFINDER_PARAMETERS param);
void mfw_cam_set_viewfinder_param_color(UBYTE blackandwhite);
void mfw_cam_set_viewfinder_param_zoom(UBYTE zoom);

extern  void display_saved_image(BOOL);

/*
** Public function Definitions
*/

/*******************************************************************************

 $Function:		mfw_cam_init

 $Description:		This function initialises the camil interface.

 $Returns:		None

 $Arguments:		None

*******************************************************************************/
void mfw_cam_init(void)
{
	T_FFS_DIR  dir;
 	T_FFS_RET ffsResult;
   	TRACE_EVENT("mfw_cam_init()");

        ffsResult = ffs_opendir(JPEG_CONTENT_DIR,&dir);                    
        if(EFFS_NOTFOUND == ffsResult)
        	{
        		//Directory does not exsists, create it and initialize the table and write it to FFS
			ffsResult = ffs_mkdir(JPEG_CONTENT_DIR);
			if(EFFS_OK == ffsResult)
			{
				TRACE_EVENT("Create Dir Passed"); 
    			}
    			else
       			 TRACE_EVENT("Create Dir Failed");    
        	}
	// Initialize CAMIL interface.
	if (camil_init() != RV_OK)
	{
	    // @todo : use correct return code for error cases !
	    return ;
	}

}

/*******************************************************************************

 $Function:     mfw_cam_get_viewfinder_param_cb

 $Description: Callback to get the viewfinder parameters.

 $Returns: None 

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_get_viewfinder_param_cb(void *parameter)
{
	viewfinder_parameters = ((T_CAMA_MSG *)parameter)->body.viewfinder_parameters;
}

/*******************************************************************************

 $Function:		mfw_cam_exit

 $Description:		This function will tidy up any resources used by the Mfw Camera Module
 				on Power Down

 $Returns:		None

 $Arguments:		None

*******************************************************************************/
void mfw_cam_exit(void)
{

	TRACE_EVENT("mfw_cam_exit()");

	/* nothing to do here... RAM will be automatically cleaned, and the flash wasn't modified */
}

/*******************************************************************************

 $Function:     mfw_cam_enable_sensor_dummy_cb

 $Description: dummy callback functions used to disable the camera

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_enable_sensor_dummy_cb(void *parameter)
{
	TRACE_EVENT("mfw_cam_enable_sensor_dummy_cb()");
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs	
	dspl_control(DSPL_ACCESS_ENABLE);
}


/*******************************************************************************

 $Function:     mfw_cam_disable_sensor

 $Description:Disables the camera - Called by the MMI

 $Returns: Execution status

 $Arguments: None
*******************************************************************************/
SHORT mfw_cam_disable_sensor(void)
{
	TRACE_EVENT("mfw_cam_disable_sensor()");
   	camil_enable_camera(FALSE, mfw_cam_enable_sensor_dummy_cb);

   return 1;
}


/*******************************************************************************

 $Function:     mfw_cam_enable_camera_cb

 $Description: Callback for Enabling camera.

 $Returns:  None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_enable_camera_cb(void *parameter)
{

	TRACE_EVENT("mfw_cam_enable_camera_cb()");
	//Set the camera state to viewfinder.
   camera_state = CAMERA_STATE_VIEWFINDER;
    //Disable R2D refresh to stabilize lcd display of viewfinder
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_DISABLE);
	//Set the viewfinder parameters
   mfw_cam_set_viewfinder_param(viewfinder_parameters);
}


/*******************************************************************************

 $Function:     mfw_cam_launch_viewfinder_dma

 $Description:launch camera in viewfinder mode

 $Returns:Execution status

 $Arguments: None

*******************************************************************************/
SHORT mfw_cam_launch_viewfinder_dma(void)
{
      TRACE_EVENT("mfw_cam_launch_viewfinder_dma()");
 	camil_enable_camera (TRUE, mfw_cam_enable_camera_cb);
   return 1;
}

/*******************************************************************************

 $Function:     mfw_cam_take_snapshot_cb

 $Description: Callback for Camera  take snapshot function.

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_take_snapshot_cb(void *parameter)
{

  TRACE_EVENT("mfw_cam_take_snapshot_cb()");
	//Set the camera state to Snapshot
	camera_state = CAMERA_STATE_SNAPSHOT;
}

/*******************************************************************************

 $Function:     mfw_cam_take_snapshot

 $Description:take a snapshot

 $Returns:Execution status

 $Arguments:		None

*******************************************************************************/
SHORT mfw_cam_take_snapshot(void)
{
   TRACE_EVENT("mfw_cam_take_snapshot()");   
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_DISABLE);
	camil_take_snapshot(mfw_cam_take_snapshot_cb);
  return 1;
}

/*******************************************************************************

 $Function:     mfw_camera_test_save_snapshot_cb

 $Description:save snapshot in phone memory

 $Returns:Execution status

 $Arguments: None

*******************************************************************************/
SHORT mfw_cam_save_snapshot(void)
{
//Sep 13, 2005    REF: SPR 33992 xdeepadh
//The fullpath will be included.
	char filename[CT_FULL_PATH_LENGTH];

	TRACE_EVENT("mfw_cam_save_snapshot()");
	sprintf(filename,"%s/%s%d.jpg",JPEG_CONTENT_DIR, new_filename,(int)FFS_flashData.camera_file_counter);
	TRACE_EVENT_P1("filename to be saved is %s",filename);
	if(camil_save_image((UINT16)mfw_cam_get_quality_factor(),filename,mfw_cam_save_image_cb) == RV_OK)
	{
		TRACE_EVENT("mfw_cam_save_snapshot() passed");	
		FFS_flashData.camera_file_counter++;
		flash_write();
		return MFW_CAM_OK;   	
	}  
	else  	
	{
		TRACE_EVENT("mfw_cam_save_snapshot() failed");  	
		return MFW_CAM_FAILED;  
	}
}

/*******************************************************************************

 $Function:     mfw_cam_save_image_cb

 $Description: Callback for save image

 $Returns:None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_save_image_cb(void *parameter)
{
	T_RV_RET status;
	TRACE_EVENT("mfw_cam_save_image_cb()");
	camera_state = CAMERA_STATE_VIEWFINDER;
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipgn
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_ENABLE);
	if( ((T_CAMA_MSG*)parameter)->status != RV_OK)
	{
		TRACE_EVENT("ERROR SAVING IMAGE");
		display_saved_image(FALSE);
	}
	else
	{
		TRACE_EVENT("IMAGE SAVED");
		display_saved_image(TRUE);
	}
}

/*******************************************************************************

 $Function:     mfw_cam_set_quality_factor
		
 $Description: Set the quality factor .This will be used while saving the jpeg image in ffs.
		
 $Returns: None
	
 $Arguments: factor-quality factor to be used to save the image.

*******************************************************************************/
void mfw_cam_set_quality_factor(UBYTE factor)
{
	TRACE_EVENT("mfw_cam_set_quality_factor()");
	quality_factor = factor;
}

/*******************************************************************************

 $Function:     mfw_cam_get_quality_factor

 $Description: This function returns the quality factor.

 $Returns: The quality factor

 $Arguments: None

*******************************************************************************/

UBYTE mfw_cam_get_quality_factor()
{
	TRACE_EVENT("mfw_cam_get_quality_factor()");
	return quality_factor;
}


/*******************************************************************************

 $Function:     mfw_cam_set_color

 $Description:

 $Returns:

 $Arguments: 

*******************************************************************************/
void mfw_cam_set_color(UBYTE factor)
{
	TRACE_EVENT("mfw_cam_set_color()");
}
/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_param_cb

 $Description: Callback for the Viewfinder set parameters.

 $Returns:None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_set_viewfinder_param_cb(void *parameter)
{
 TRACE_EVENT("mfw_cam_set_viewfinder_param_cb()");
 
	configure_flag = FALSE;
	/* start frame loop */
	camil_set_viewfinder_mode(mfw_cam_set_viewfinder_mode_cb);
}

/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_param_color_cb

 $Description: Callback for Viewfinder set Parameters

 $Returns: None 

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_set_viewfinder_param_color_cb(void *parameter)
{
  TRACE_EVENT("mfw_cam_set_viewfinder_param_color_cb()");
}

/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_param

 $Description: This function sets the Viewfinder Parameters.
 			The camera will be started in the viewfinder mode.

 $Returns: None

 $Arguments: param- Viewfinder Parameters

*******************************************************************************/

void mfw_cam_set_viewfinder_param(T_CAMA_VIEWFINDER_PARAMETERS param)
    {
	TRACE_EVENT("mfw_cam_set_viewfinder_param()");
	if(configure_flag)
	{
		camil_set_viewfinder_parameters(&param, mfw_cam_set_viewfinder_param_cb);
	}
	else
	{
	 	TRACE_EVENT("mfw_cam_set_viewfinder_param- no param chnaged.");
		/* start frame loop */
		camil_set_viewfinder_mode(mfw_cam_set_viewfinder_mode_cb);
	}
}

/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_param_color

 $Description: Sets the Viewfinder Parameter.

 $Returns: None

 $Arguments: blackandwhite- Viewfinder parameter

*******************************************************************************/

void mfw_cam_set_viewfinder_param_color(UBYTE blackandwhite)
{
	TRACE_EVENT("mfw_cam_set_viewfinder_param_color()");
	viewfinder_parameters.black_and_white = blackandwhite;
	//Configurations have changed. Set the configure_flag to TRUE.
	configure_flag = TRUE;
	//Set the Viewfinder parameters .
	//camil_set_viewfinder_parameters(&viewfinder_parameters, mfw_cam_set_viewfinder_param_color_cb);
}


/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_param_zoom

 $Description:	Sets the Viewfinder Parameter.

 $Returns: None

 $Arguments: zoom- Viewfinder parameter

*******************************************************************************/

void mfw_cam_set_viewfinder_param_zoom(UBYTE zoom)
{
	TRACE_EVENT("mfw_cam_set_viewfinder_param_zoom()");
	viewfinder_parameters.zoom = zoom;
	//Configurations have chnaged. Set the configure_flag to TRUE.
	configure_flag = TRUE;
	//Set the Viewfinder parameters .
	//camil_set_viewfinder_parameters(&viewfinder_parameters, mfw_cam_set_viewfinder_param_color_cb);
}



/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_mode_cb

 $Description: Callback for Setting Viewfinder.

 $Returns: None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_set_viewfinder_mode_cb(void *parameter)
{
	TRACE_EVENT("mfw_cam_set_viewfinder_mode_cb()");
	//added the refresh disable and state setting
	//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
	//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_DISABLE);
	camera_state = CAMERA_STATE_VIEWFINDER;
}


/*******************************************************************************

 $Function:     mfw_cam_set_viewfinder_mode

 $Description: This function disables and reenables camera and sets the viewfinder mode.

 $Returns:None

 $Arguments: None

*******************************************************************************/
#ifdef ISAMPLE
void  mfw_cam_set_viewfinder_mode(void)
{
   	TRACE_EVENT("mfw_cam_set_viewfinder_mode()");
   	camera_state  =  CAMERA_STATE_VIEWFINDER;
   	camil_set_viewfinder_mode(mfw_cam_set_viewfinder_mode_cb);
}

#else  //For ESAMPLE
void  mfw_cam_set_viewfinder_mode(void)
{
	TRACE_EVENT("mfw_cam_set_viewfinder_mode()");
	camil_enable_camera(FALSE, mfw_cam_disable_viewfinder_mode_cb);
}
#endif

/*******************************************************************************

 $Function:     mfw_cam_enable_viewfinder_mode_cb

 $Description: Callback for camil_enable_camera

 $Returns:None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_enable_viewfinder_mode_cb(void *parameter)
{
	TRACE_EVENT("mfw_cam_enable_viewfinder_mode_cb()");

	//Disable R2D refresh (to be sure)
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_DISABLE);
	camil_set_viewfinder_mode(mfw_cam_set_viewfinder_mode_cb);
}

/*******************************************************************************

 $Function:     mfw_cam_disable_viewfinder_mode_cb

 $Description: Callback for disabling camera

 $Returns:None

 $Arguments: Callback Parameter

*******************************************************************************/
static void mfw_cam_disable_viewfinder_mode_cb(void *parameter)
{
	TRACE_EVENT("mfw_cam_disable_viewfinder_mode_cb()");
	camil_enable_camera(TRUE, mfw_cam_enable_viewfinder_mode_cb);
}




