/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bte.h				$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 17.04.04				     $Modtime:: 17.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth Management

*/

#ifndef DEF_MFW_BT_HEADER
#define DEF_MFW_BT_HEADER

#define BT_INTERFACE
#include "bta_riviera.h"

#include "target.h"
#include "buildcfg.h"

#include "bta_api.h"
#include "mfw_mfw.h"
#include "mfw_win.h"

typedef enum {
	MFW_BT_UNKNOWN_DEVICE				= -8,
	MFW_BT_DATA_BASE_FULL				= -7,
	MFW_BT_NOT_INITIALISED				= -6,
	MFW_BT_FAILED_TO_STORE_EVENT		= -5,
	MFW_BT_INVALID_DATA					= -4,
	MFW_BT_INVALID_EVENT					= -3,
	MFW_BT_INVALID_ORIG					= -2,
	MFW_BT_UNABLE_TO_CREATE_EVT_BUF	= -1,
	MFW_BT_FAIL							= 0,
	MFW_BT_SUCCESS						= 1
 } T_MFW_BT_STATUS;



typedef enum
{
	MFW_BT_DEFAULT_VIS = -1,
	MFW_BT_SHOWN = BTA_DM_GENERAL_DISC,
	MFW_BT_HIDDEN = BTA_DM_NON_DISC
}T_MFW_STARTUP_VISIBILITY;



/*
** Debug Macros : These will enable easy enabling/disabling of tracing within the Bluetooth environment
*/
#define MFW_BT_DEBUG	1

#ifdef MFW_BT_DEBUG

#define 	MFW_BT_TRACE(a)								TRACE_EVENT(a)
#define	MFW_BT_TRACE_P1(s, a)							TRACE_EVENT_P1(s, a)
#define	MFW_BT_TRACE_P2(s, a, b)						TRACE_EVENT_P2(s, a, b)
#define	MFW_BT_TRACE_P3(s, a, b, c)						TRACE_EVENT_P3(s, a, b, c)
#define	MFW_BT_TRACE_P4(s, a, b, c, d)					TRACE_EVENT_P4(s, a, b, c, d)
#define	MFW_BT_TRACE_P5(s, a, b, c, d, e)					TRACE_EVENT_P5(s, a, b, c, d, e)
#define	MFW_BT_TRACE_P6(s, a, b, c, d, e, f)				TRACE_EVENT_P6(s, a, b, c, d, e, f)
#define	MFW_BT_TRACE_P7(s, a, b, c, d, e, f, g)			TRACE_EVENT_P7(s, a, b, c, d, e, f, g)
#define	MFW_BT_TRACE_P8(s, a, b, c, d, e, f, g, h)			TRACE_EVENT_P8(s, a, b, c, d, e, f, g, h)
#define	MFW_BT_TRACE_P9(s, a, b, c, d, e, f, g, h, i)		TRACE_EVENT_P9(s, a, b, c, d, e, f, g, h, i)

#else

#define 	MFW_BT_TRACE(a)
#define	MFW_BT_TRACE_P1(s, a)
#define	MFW_BT_TRACE_P2(s, a, b)
#define	MFW_BT_TRACE_P3(s, a, b, c)
#define	MFW_BT_TRACE_P4(s, a, b, c, d)
#define	MFW_BT_TRACE_P5(s, a, b, c, d, e)
#define	MFW_BT_TRACE_P6(s, a, b, c, d, e, f)
#define	MFW_BT_TRACE_P7(s, a, b, c, d, e, f, g)
#define	MFW_BT_TRACE_P8(s, a, b, c, d, e, f, g, h)
#define	MFW_BT_TRACE_P9(s, a, b, c, d, e, f, g, h, i)

#endif


/*
** Status return values : The Bluetooth module will use meaningful return values to the functions so the software
** can be engineered to react appropriately to specific events
*/



/**********************************************************************************************
**
**		Mfw	-> BMI Interface (Event related definitions)
**
**********************************************************************************************/

/*
 * Events are organised as bitmaps
 */
#define E_BT_ENABLE_CMPL			(T_MFW_EVENT)0x00000001
#define E_BT_DISABLE_CMPL			(T_MFW_EVENT)0x00000002

#define E_BT_ALL_GENERIC_SERVICES	(T_MFW_EVENT)0x0000000F


#define E_BT_ALL_SERVICES			( (T_MFW_EVENT)(E_BT_ALL_GENERIC_SERVICES) \
									  | (T_MFW_EVENT)(E_BT_ALL_DM_SERVICES)) 
/*#if 0  Not Implemented yet 
									  | (T_MFW_EVENT)(E_BT_ALL_DG_SERVICES) \
									  | (T_MFW_EVENT)(E_BT_ALL_AG_SERVICES) \
									  | (T_MFW_EVENT)(E_BT_ALL_OP_SERVICES) \
									  | (T_MFW_EVENT)(E_BT_ALL_FT_SERVICES) \
#endif
					*/				  

/*
** Signal Parameter Structure Definitions
*/
typedef struct {
	BOOL	Success;
} T_MFW_BT_ENABLE_CMPL;



#include "mfw_bt_dm.h"
#include "mfw_bt_dg.h"
#include "mfw_bt_ag.h"
#include "mfw_bt_op.h"
#include "mfw_bt_ft.h"
/*
 * BT Mfw -> BMI signal parameter
 */
typedef union
{
	/*
	** Generic Service Signal Parameters
	*/
	T_MFW_BT_ENABLE_CMPL		enable_cmpl;

	/*
	** Device Manager Signal Parameters
	*/
	T_MFW_BT_DM_LINK_UP			link_up;
	T_MFW_BT_DM_LINK_DOWN			link_down;
	T_MFW_BT_DM_INQ_RES			inq_res;
	T_MFW_BT_DM_INQ_CMPL			inq_cmpl;  
	T_MFW_BT_DM_DISC_RES			disc_res;
	T_MFW_BT_DM_PIN_REQ			pin_req;
	T_MFW_BT_DM_AUTH_CMPL			auth_cmpl;
	T_MFW_BT_DM_AUTHORIZE_REQ		authorize_req;
	T_MFW_BT_DM_SIG_STRENGTH_IND	sig_strength_ind;

} 
T_MFW_BT_PARA;

/*
 *  BT Control Block
 */
typedef struct
{
    T_MFW_EVENT      emask;         /* events of interest */
    T_MFW_EVENT      event;          /* current event */
    T_MFW_CB           handler;
    T_MFW_BT_PARA  para;
} T_MFW_BT;


void mfw_bt_signal(T_MFW_EVENT event, void *para);


/*******************************************************************************

 $Function:		mfw_bt_enable

 $Description:		This function will start the whole process of enabling Bluetooth.

 $Returns:		MFW_BT_FAIL if the chip is not stopped or if the generic event handler
 				doesn't start correctly.

 $Arguments:		Specify the visibility parameter at start-up. 	
 				MFW_BT_DEFAULT  => use value in flash
				MFW_BT_SHOWN 	=> device will be visible ( that doesn't update the flash ) 
				MFW_BT_HIDDEN   => device will be hidden ( ... )

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_enable(T_MFW_STARTUP_VISIBILITY startup_visibility );

/*  */
/*******************************************************************************

 $Function:		mfw_bt_enable_cb

 $Description:		mfw_bt_enable will cause a BTA_DM_SYS_START_EVT to be sent. At this 
 				moment we call BTA_EnableBluetooth. When we receive 
 				BTA_DM_ENABLE_EVT, we call this function.
 				
 $Returns:		Will send a BMI signal if there is no default name. If the user cancels the 
 				input, BT will then be stopped.
 				Will send a E_BT_ENABLE_CMPL event when the initialization is done. 

 $Arguments:		none 

*******************************************************************************/
void mfw_bt_enable_cb(void);

/*******************************************************************************
 $Function:		mfw_bt_disable
 $Description:		This function stops the BT system.
 $Returns:		None
 $Arguments:		
*******************************************************************************/
void mfw_bt_disable(void);


/*******************************************************************************
 $Function:		mfw_bt_init
 $Description:		This function initialises the Mfw Bluetooth Persistent Data on Power Up. 
 $Returns:		None
 $Arguments:		None
*******************************************************************************/
void mfw_bt_init(void);
/*******************************************************************************
 $Function:		mfw_bt_exit
 $Description:		This function will tidy up any resources used by the Mfw Bluetooth Module
				on Power Down
 $Returns:		None
 $Arguments:		None
*******************************************************************************/
void mfw_bt_exit(void);
/*******************************************************************************
 $Function:		mfw_bt_create
 $Description:		This function  initialises an Mfw Bluetooth entity and adds it to the Window Stack
 $Returns:		T_MFW_HND	: A handle for the entity
 $Arguments:		T_MFW_HND		: Parent Window Handle
 				T_MFW_EVENT	: Event Mask of the events to be handled
 				T_MFW_CB		: Callback function to handle the events
*******************************************************************************/
T_MFW_HND mfw_bt_create(T_MFW_HND hWin, T_MFW_EVENT event, T_MFW_CB cbfunc);
/*******************************************************************************
 $Function:		mfw_bt_delete
 $Description:		This function clears down an Mfw Bluetooth entity and removes it from the
				Window Stack
 $Returns:		T_MFW_RES	: The result of the function
 $Arguments:		T_MFW_HND	: The Handle of the entity to be removed
*******************************************************************************/
T_MFW_RES mfw_bt_delete(T_MFW_HND hnd);
/*******************************************************************************
 $Function:		mfw_bt_signal
 $Description:		This function sends the Mfw Bluetooth events from the Mfw to the BMI.
 $Returns:		None
 $Arguments:		T_MFW_EVENT	: The event to be sent to the BMI
				void *			: Pointer to the Event data
*******************************************************************************/
void mfw_bt_signal(T_MFW_EVENT event, void *para);
/*******************************************************************************
 $Function:		mfw_bt_sign_exec
 $Description:		This function sends the Mfw Bluetooth events from the Mfw to the BMI.
 $Returns:		None
 $Arguments:		None
*******************************************************************************/
BOOL mfw_bt_sign_exec (T_MFW_HDR * cur_elem, T_MFW_EVENT event, T_MFW_BT_PARA * para);

#endif

