/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8417)         $Workfile:: mfw_bta.c       $|
| $Author:: Rm                          $Revision::  1              $|
| CREATED: 04.01.01                     $Modtime:: 4.01.01 15:14    $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_BTA

   PURPOSE : This modul contains the additional functions for BT management.

*/
#define ENTITY_MFW

#include "mfw_sys.h"

#include "typedefs.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"

#include "prim.h"
#include "p_btp.h"

#include "Bti.h"
#include "bti_btp.h"
#include "mfw_mfw.h"
#include "mfw_acie.h"
#include "mfw_bt.h"
#include "mfw_bta.h"

#include <string.h>

/* TI BT header */
#ifdef BT_INTERFACE
#include "rv_general.h"
#include "hsg_general.h"
#include "hsg_messages.h"
#include "rvm_api.h"
#include "bmi_api.h"

/*#ifdef PCA_6350*/
#include "pca_gw_mmi.h"
/*#endif*/
#endif /* BT_INTERFACE */

#ifdef _SIMULATION_
#include "bti_win.h"
#endif

/* global used structures */
T_MFW_BT_SERVICE_LST found_headset;        /* list with found devices (headset) */
T_MFW_BT_DEVICE_LST service_list;          /* list with service id's related to a bd_addr */
T_MFW_BT_SERVICE_LST found_dial_up;        /* list with found services (dial_up) */
T_MFW_BT_SERVICE_LST found_fax;            /* list with found services (fax) */
T_MFW_BT_SERVICE_LST found_opp;            /* list with found services (OPP) */
T_MFW_BT_SERVICE_LST found_sync;           /* list with found services (SYNC) */
T_MFW_BT_SERVICE_LST found_sync_cmd;       /* list with found services (SYNC_CMD) */
T_MFW_BT_AUTHORIZATION_LIST authorized_devices_list; /* list of authorized devices */

char receiv_object_name[MFW_BT_OPP_OBJECT_NAME_MAX_LEN];/* static buffer for object name: limited with 256 characters */
char receiv_object_mime_type[MFW_BT_OPP_OBJECT_MIME_MAX_LEN];/* static buffer for MIME type of object: limited with 256 characters */
char receiv_sync_object_mime_type[MFW_BT_OPP_OBJECT_MIME_MAX_LEN];/* static buffer for MIME type of object: limited with 256 characters */
char sync_object_name[MFW_BT_OPP_OBJECT_NAME_MAX_LEN];/* static buffer for object name: limited with 256 characters */
char sync_object_location_id[MFW_BT_SYNC_OBJECT_IDENTIFIER];/* static buffer for sync object path on server: limited with 256 characters */

#ifdef _SIMULATION_
#define MFW_BT_OPP_BUFFER_LENGTH 10
static unsigned char server_syn_object[MFW_BT_OPP_BUFFER_LENGTH];
static  char mfw_test_syn_obj[] = {'v', 'C', 'a', 'l', '\0'};
static  char mfw_test_opp_obj_name[] = {'v', 'C', 'a', 'r', 'd', '\0'};
static  char hsg_default_name [] ={'H', 'S', 'G', '1', '\0'};
static  char client_obj_name [] ={'C', 'l', 'i', 'e', 'n', 't', '\0'};
static unsigned char server_business_card[MFW_BT_OPP_BUFFER_LENGTH];/* temporary field for the pulled server card */
static  char server_default_name [] ={'S', 'e', 'r', 'v', 'e', 'r', '\0'};
static unsigned char server_buffer[MFW_BT_OPP_BUFFER_LENGTH];/* temporary field for received client objects at the server  */
static unsigned char client_buffer[MFW_BT_OPP_BUFFER_LENGTH];/* temporary field for pushed client objects  */
static unsigned char client_business_card[MFW_BT_OPP_BUFFER_LENGTH];/* temporary field for his own client card */
#endif
/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         MODULE: MFW_BTA              |
| STATE  : code                         ROUTINE: bta_response_cb     |
+--------------------------------------------------------------------+

   PURPOSE : Response Callback Handler (receive bt primitive directly)
             Note that the input paramter opc will be casted to USHORT
             as Bluetooth is currently still using 16bit opcodes.

*/
GLOBAL BOOL bta_response_cb (ULONG opc, void * data)
{
  T_MFW_BT_PROFILE_CREATE_CNF *profile_create_cnf;
  T_MFW_BT_PROFILE_DELETE_CNF *profile_delete_cnf;
  T_MFW_BT_SERVICE_LST *id_ptr;
  T_MFW_BT_DEVICE_LST *idd_ptr;
  T_MFW_BT_SERVICE_ID *service_id;
  T_MFW_BT_DEVICE_ID *dev_id;
  T_MFW_BT_SERVICE_ID *help_id;
  T_MFW_BT_DEVICE_ID *help_serv_id;
  T_MFW_BT_PROFILE_CNF *profile_cnf_data;
  T_MFW_BT_PIN_IND *pin_indication;
  T_MFW_BT_DEV_PAIR_IND *pair_indication;
  T_MFW_BT_DEVICE_IND *device_indication;
  T_MFW_BT_SERVICE_IND *service_indication;
  T_MFW_BT_REST_CONFIG *restore_configuration;
  T_MFW_BT_DISCON_DUN_FAX_IND *disc_dun_fax_ind;
  T_MFW_BT_CALL_STATUS_DUN_FAX *dun_call_state;
  T_MFW_BT_AUTHORIZATION_IND *authorization_ind;
  T_MFW_BT_OPP_PUT_CNF *opp_put_cnf;
  T_MFW_BT_OPP_PUSH_CNF *opp_obj_push_cnf;
  T_MFW_BT_OPP_PULL_CNF *opp_obj_pull_cnf;
  T_MFW_BT_SERVICE_SEARCH_CNF *search_conf;
  T_MFW_BT_DEVICE_SEARCH_CNF *dev_search_conf;
  T_MFW_BT_CONNECT_IND *connect_ind;
  T_MFW_BT_CONNECT_INF *connect_inf;
  T_MFW_BT_CONNECT_CNF *connect_cnf;
  T_MFW_BT_DISCONNECT_CNF *disconnect_cnf;
  T_MFW_BT_DISCON_DUN_FAX_CNF *discon_dun_fax_cnf;
  T_MFW_BT_DISCONNECT_IND *disconnect_ind;
  T_MFW_BT_TRANSFER_AUDIO_OUT_CNF *audio_out_cnf;
  T_MFW_BT_TRANSFER_AUDIO_IN_CNF *audio_in_cnf;
  T_MFW_BT_OPP_PUT_IND *opp_put_ind;
  T_MFW_BT_SRV_SYNC_CNF *srv_sync_cnf;
  T_MFW_BT_SRV_SYNC_AUTH_IND * srv_sync_auth;
  T_MFW_BT_SRV_SYNC_PULL_IND * srv_sync_pull_ind;
  T_MFW_BT_SRV_SYNC_PUSH_IND * srv_sync_push_ind;
  T_MFW_BT_SRV_SYNC_PUSH_CNF * srv_sync_push_cnf;
  U8 len;
  T_MFW_BT_CHNG_LOCAL_NAME *c_loc_name;
  T_MFW_BT_READ_LOCAL_NAME *r_loc_name;
  T_MFW_BT_REMOTE_DEV_INFO_RES *rem_dev_info;
  T_MFW_BT_CHNG_CONNECTABLE_MODE *chng_cmode;
  T_MFW_BT_CHNG_DISCOVERABLE_MODE *chng_dmode;
  T_MFW_BT_READ_BD_ADDR *r_bd_addr;
/*#ifdef PCA_6350*/
  T_MFW_BT_PCA_GW_STATUS_CFM *pca_gw_status;
  T_MFW_BT_PCA_GW_LINK_MONITORING *pca_link_mon;
  T_MFW_BT_PCA_GW_CALL_MONITORING *pca_call_mon;
  T_MFW_BT_PCA_GW_HANGUP_CFM *pca_hangup;
/*#endif*/ /*PCA_6350*/

/* Cartman added begin */
  T_MFW_BT_HSG_HEADSET_CONNECTION_IND *hsg_headset_connection_ind;
  T_MFW_BT_HSG_SPECIFIC_CMD_CFM *hsg_specific_cmd_cfm;
  T_MFW_BT_HSG_SAVE_LIST_CNF *hsg_save_list_cnf;
/* Cartman added end */

#ifdef _SIMULATION_

  T_MFW_BT_SUBTYPE_DEV subtyp;
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SYNC_OBJECT syn_pull_obj, syn_push_obj;
  T_MFW_BT_SYN_PASSWD mfw_sync_password[MFW_BT_PIN_MAX_LEN];
  char * mfw_sync_password_ptr;
  char j;
  U8 headset_id, default_security;
  T_MFW_BT_BD_ADDR client_address[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_ADDR hsg_address[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_ADDR server_address[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_ADDR remote_address[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_SYN_OBJECT_STORE mfw_obj;
  T_MFW_BT_SYNC_COMMAND mfw_syn_action;
  T_MFW_BT_SYNC_SERVER_CONFIG syn_serv_config;
  T_MFW_BT_SYN_OBJECT_STORE_ITEM mfw_obj_list, mfw_obj_list1;
  T_MFW_BT_SYN_OBJECT_STORE_LIST mfw_obj_list_ptr, mfw_obj_list_ptr1;
  T_MFW_BT_HSG_CLIENT_CONFIG client_config;
  T_MFW_BT_HSG_SERVER_CONFIG server_conf;
  T_MFW_BT_HSG_PHONE_NUMBER test_mfw_phone_list[4][30];
  T_MFW_BT_HSG_KEY_LIST test_mfw_key_list[1];
  T_MFW_BT_HSG_NAME hsg_name[MFW_BT_HSG_NAME_MAX_LEN];
  T_MFW_BT_PRIORITY priority;
  T_MFW_BT_CNF_ID headset_cnf_id;
  BOOL rem_audio_ctr_supp_hsg;
  BOOL mfw_keep_connection_opp;
  T_MFW_BT_HEADSET_INFO hs_info;
  U16 new_value;
  T_MFW_BT_PARAM_NUMBER nb;
  T_MFW_BT_CHANGE_PARA type;
  T_MFW_BT_DUN_CONFIG dun_filter;
  T_MFW_BT_FAX_CONFIG fax_filter;
  T_MFW_BT_OPP_SERVER_CONFIG serv_config;
  T_MFW_BT_OPP_PUT_RES opp_put_res;
  T_MFW_BT_OPP_OBJECT receiv_obj, opp_push_obj, opp_pull_obj;
  T_MFW_BT_PIN pin_code[MFW_BT_PIN_MAX_LEN];
  T_MFW_BT_PIN_MODE pin_mode;
  T_MFW_BT_RESULT_BT result_bt;
  T_MFW_BT_PAIRABLE_MODE pair_mode;
  T_MFW_BT_DEV_PAIR_LIST pairing_list;
  T_MFW_BT_AUTHORIZATION_MASK auth_mask;
  T_MFW_BT_AUTHORIZATION_MODE auth_mode;
  T_MFW_BT_SECURITY_MODE sec_mode;

#endif

  TRACE_FUNCTION ("mfw_bta:bta_response_cb()");

  switch ((USHORT) opc)
  {
    case BTP_PROFILE_CREATE_CNF:
      MALLOC(profile_create_cnf, sizeof(T_MFW_BT_PROFILE_CREATE_CNF));
      profile_create_cnf->profile = ((T_BTP_PROFILE_CREATE_CNF *)data)->device;
      bt_signal(BT_CREATE_PROFILE_CNF, profile_create_cnf);
      MFREE(profile_create_cnf);
      return TRUE;

    case BTP_PROFILE_DELETE_CNF:
      MALLOC(profile_delete_cnf, sizeof(T_MFW_BT_PROFILE_DELETE_CNF));
      profile_delete_cnf->profile = ((T_BTP_PROFILE_DELETE_CNF *)data)->device;
      bt_signal(BT_DELETE_PROFILE_CNF, profile_delete_cnf);
      MFREE(profile_delete_cnf);
      return TRUE;

    case BTP_INIT_PROFILE_CNF:
      /* BTI confirms initialization of profile */
      MALLOC(profile_cnf_data, sizeof(T_MFW_BT_PROFILE_CNF));
      memset(profile_cnf_data, 0, sizeof(T_MFW_BT_PROFILE_CNF));
      profile_cnf_data->service = ((T_BTP_INIT_PROFILE_CNF *)data)->device;
      profile_cnf_data->result_bd = ((T_BTP_INIT_PROFILE_CNF *)data)->result;
      profile_cnf_data->action = ((T_BTP_INIT_PROFILE_CNF *)data)->action;
      profile_cnf_data->subtype = ((T_BTP_INIT_PROFILE_CNF *)data)->subtype;
      profile_cnf_data->mfw_opp_mode = ((T_BTP_INIT_PROFILE_CNF *)data)->opp_mode;
      profile_cnf_data->mfw_sync_mode = ((T_BTP_INIT_PROFILE_CNF *)data)->sync_serv_mode;
      profile_cnf_data->mfw_syn_aut_mode = ((T_BTP_INIT_PROFILE_CNF *)data)->sync_init_auth;
      bt_signal(BT_INIT_PROFILE_CNF, profile_cnf_data);
#ifdef _SIMULATION_
      if(profile_cnf_data->service EQ MFW_BT_SYNC)
      {
        TRACE_EVENT_P4("init cnf = %d, %d, %d, %d", profile_cnf_data->service, profile_cnf_data->subtype, profile_cnf_data->mfw_sync_mode, profile_cnf_data->mfw_syn_aut_mode);
      }
      else
      {
        TRACE_EVENT_P2("init cnf = %d, %d", profile_cnf_data->service, profile_cnf_data->subtype);
      }
#endif
      MFREE(profile_cnf_data);
      return TRUE;

    case BTP_DEINIT_PROFILE_CNF:
      /* BTI confirms deinitialization of profile */
      MALLOC(profile_cnf_data, sizeof(T_MFW_BT_PROFILE_CNF));
      memset(profile_cnf_data, 0, sizeof(T_MFW_BT_PROFILE_CNF));
      profile_cnf_data->service = ((T_BTP_DEINIT_PROFILE_CNF *)data)->device;
      profile_cnf_data->result_bd = ((T_BTP_DEINIT_PROFILE_CNF *)data)->result;
      profile_cnf_data->subtype = ((T_BTP_DEINIT_PROFILE_CNF *)data)->subtype;
      profile_cnf_data->mfw_opp_mode = ((T_BTP_DEINIT_PROFILE_CNF *)data)->opp_mode;
      profile_cnf_data->mfw_sync_mode = ((T_BTP_DEINIT_PROFILE_CNF *)data)->sync_serv_mode;
      profile_cnf_data->mfw_syn_aut_mode = ((T_BTP_DEINIT_PROFILE_CNF *)data)->sync_init_auth;
      bt_signal(BT_DEINIT_PROFILE_CNF, profile_cnf_data);
#ifdef _SIMULATION_
      if(profile_cnf_data->service EQ MFW_BT_SYNC)
      {
        TRACE_EVENT_P4("deinit cnf = %d, %d, %d, %d", profile_cnf_data->service, profile_cnf_data->subtype, profile_cnf_data->mfw_sync_mode, profile_cnf_data->mfw_syn_aut_mode);
      }
      else
      {
        TRACE_EVENT_P2("deinit cnf = %d, %d", profile_cnf_data->service, profile_cnf_data->subtype);
      }
#endif
      MFREE(profile_cnf_data);
      return TRUE;
  }

  switch ((USHORT) opc)
  {
    case BTP_RECONFIG_PROFILE_CNF:
      /* BTI confirms reconfiguration of profile */
      MALLOC(profile_cnf_data, sizeof(T_MFW_BT_PROFILE_CNF));
      memset(profile_cnf_data, 0, sizeof(T_MFW_BT_PROFILE_CNF));
      profile_cnf_data->service = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->device;
      profile_cnf_data->result_bd = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->result;
      profile_cnf_data->subtype = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->subtype;
      profile_cnf_data->mfw_opp_mode = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->opp_mode;
      profile_cnf_data->mfw_sync_mode = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->sync_serv_mode;
      profile_cnf_data->mfw_syn_aut_mode = ((T_BTP_RECONFIG_PROFILE_CNF *)data)->sync_init_auth;
      bt_signal(BT_RECONFIG_PROFILE_CNF, profile_cnf_data);
#ifdef _SIMULATION_
      if(profile_cnf_data->service EQ MFW_BT_SYNC)
      {
        TRACE_EVENT_P4("reconf cnf = %d, %d, %d, %d", profile_cnf_data->service, profile_cnf_data->subtype, profile_cnf_data->mfw_sync_mode, profile_cnf_data->mfw_syn_aut_mode);
      }
      else
      {
        TRACE_EVENT_P2("reconf cnf = %d, %d", profile_cnf_data->service, profile_cnf_data->subtype);
      }
#endif
      MFREE(profile_cnf_data);
      return TRUE;

    case BTP_RESTORE_LIST_RESULT:
      /* BTI confirms restoring of default device list */
      MALLOC(restore_configuration, sizeof(T_MFW_BT_REST_CONFIG));
      memset(restore_configuration, 0, sizeof(T_MFW_BT_REST_CONFIG));
      restore_configuration->service = ((T_BTP_RESTORE_LIST_RESULT *)data)->device;
      restore_configuration->cause = ((T_BTP_RESTORE_LIST_RESULT *)data)->cause;
      bt_signal(BT_RESTORE_LIST_RESULT, restore_configuration);
#ifdef _SIMULATION_
      if(restore_configuration->cause EQ MFW_BT_REST_LIST_ERR)
      {
          TRACE_EVENT("restore list err");
      }
      else if(restore_configuration->cause EQ MFW_BT_REST_CONFIG_ERR)
      {
          TRACE_EVENT("restore conf err");
      }
      else
      {
          TRACE_EVENT("restore conf no err");
      }
#endif
      MFREE(restore_configuration);
      return TRUE;

    case BTP_RESTORE_CONF_RESULT:
      /* BTI confirms restoring of configuration parameters */
      MALLOC(restore_configuration, sizeof(T_MFW_BT_REST_CONFIG));
      memset(restore_configuration, 0, sizeof(T_MFW_BT_REST_CONFIG));
      restore_configuration->service = ((T_BTP_RESTORE_CONF_RESULT *)data)->device;
      restore_configuration->cause = ((T_BTP_RESTORE_CONF_RESULT *)data)->cause;
      bt_signal(BT_RESTORE_CONF_RESULT, restore_configuration);
#ifdef _SIMULATION_
      if(restore_configuration->cause EQ MFW_BT_REST_LIST_ERR)
      {
          TRACE_EVENT("restore list err");
      }
      else if(restore_configuration->cause EQ MFW_BT_REST_CONFIG_ERR)
      {
          TRACE_EVENT("restore conf err");
      }
      else
      {
          TRACE_EVENT("restore conf no err");
      }
#endif
      MFREE(restore_configuration);
      return TRUE;

     case BTP_DEVICE_FOUND_IND:
      /* BTI confirms finding of bluetooth device with bd_addr and service id's)*/
      MALLOC(device_indication, sizeof(T_MFW_BT_DEVICE_IND));
      memset(device_indication, 0, sizeof(T_MFW_BT_DEVICE_IND));

      memcpy(device_indication->bd_addr, ((T_BTP_DEVICE_FOUND_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(device_indication->bd_name, ((T_BTP_DEVICE_FOUND_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      memcpy(device_indication->cod, ((T_BTP_DEVICE_FOUND_IND *)data)->cod, MFW_BT_DEVICE_CLASS_LEN);
      device_indication->num_services = ((T_BTP_DEVICE_FOUND_IND *)data)->num_services;
      device_indication->services = ((T_BTP_DEVICE_FOUND_IND *)data)->services;

      MALLOC(dev_id, sizeof(T_MFW_BT_DEVICE_ID));/* allocate memory for new device id */
      if(!dev_id)
        return FALSE; /* no more memory */

      memset(dev_id, 0, sizeof(T_MFW_BT_DEVICE_ID));
      idd_ptr = &service_list;    /* pointer to list of services */
      if(!idd_ptr->device_id)      /* test if any device id exist */
      {
        idd_ptr->device_id = dev_id; /* append new device_id */
        memcpy(idd_ptr->device_id->bd_addr, device_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
        memcpy(idd_ptr->device_id->bd_name, device_indication->bd_name, MFW_BT_NAME_MAX_LEN);/* new name */
        memcpy(idd_ptr->device_id->cod, device_indication->cod, MFW_BT_DEVICE_CLASS_LEN);/* new cod */
        idd_ptr->device_id->num_services = device_indication->num_services;
        idd_ptr->device_id->services = device_indication->services;
        idd_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P2("dev found ind = %x %s", service_list.device_id->services, service_list.device_id->bd_addr);
#endif
      }
      else
      {
        help_serv_id = idd_ptr->device_id;/* first element */
        while(help_serv_id->next)        /* look for next device_id                 */
        {
          help_serv_id = help_serv_id->next;
        }
        help_serv_id->next = dev_id;/* append new device_id */
        memcpy(help_serv_id->next->bd_addr, device_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
        memcpy(help_serv_id->next->bd_name, device_indication->bd_name, MFW_BT_NAME_MAX_LEN);/* new name */
        memcpy(help_serv_id->next->cod, device_indication->cod, MFW_BT_DEVICE_CLASS_LEN);/* new cod */
        help_serv_id->next->num_services = device_indication->num_services;/* number of services */
        help_serv_id->next->services = device_indication->services;/* service id bitmap */
        help_serv_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P2("dev found ind = %x %s ", help_serv_id->next->services, help_serv_id->next->bd_addr);
#endif
      }
      bt_signal(BT_DEVICE_FOUND_IND, device_indication);
      MFREE(device_indication);
      return TRUE;

    case BTP_SERVICE_FOUND_IND:
      /* BTI confirms finding of service names and bd_addr to the desired device typ (service id)*/
      MALLOC(service_indication, sizeof(T_MFW_BT_SERVICE_IND));
      memset(service_indication, 0, sizeof(T_MFW_BT_SERVICE_IND));

      service_indication->service = ((T_BTP_SERVICE_FOUND_IND *)data)->device;
      memcpy(service_indication->bd_addr, ((T_BTP_SERVICE_FOUND_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(service_indication->bd_name, ((T_BTP_SERVICE_FOUND_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      memcpy(service_indication->cod, ((T_BTP_SERVICE_FOUND_IND *)data)->cod, MFW_BT_DEVICE_CLASS_LEN);
      memcpy(service_indication->service_name, ((T_BTP_SERVICE_FOUND_IND *)data)->serv_name, MFW_BT_SERVICE_NAME_MAX_LEN);
/* information of new device(service) will be collected in list of found devices, but only after BT_SERVICE_SEARCH_CNF */
/* the list will be sent to MMI */
      if(service_indication->service EQ MFW_BT_HEADSET)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_headset;    /* pointer to list of founded headset devices */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {
          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */

          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          id_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("hsg found ind =  %s", found_headset.device_id->bd_name);
#endif
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("hsg found ind =  %s", help_id->next->bd_name);
#endif
        }
      }
      else if(service_indication->service EQ MFW_BT_DIAL_UP)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_dial_up;    /* pointer to list of detected dial up network services */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {

          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */
          id_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("dun found ind =  %s", found_dial_up.device_id->bd_name);
#endif
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("dun found ind =  %s", help_id->next->bd_name);
#endif
        }
      }
      else if(service_indication->service EQ MFW_BT_FAX_GW)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_fax;    /* pointer to list of detected fax services */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {

          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */
          id_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("fax found ind =  %s", found_fax.device_id->bd_name);
#endif
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("fax found ind =  %s", help_id->next->bd_name);
#endif
        }
      }
      else if(service_indication->service EQ MFW_BT_OPP)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_opp;    /* pointer to list of detected opp services */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {

          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */
          id_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("opp found ind =  %s", found_opp.device_id->bd_name);
#endif
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("opp found ind =  %s", help_id->next->bd_name);
#endif
        }
      }
      else if(service_indication->service EQ MFW_BT_SYNC)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_sync;    /* pointer to list of detected SYNC services */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {

          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */
          id_ptr->device_id->next = NULL; /* finish chain */
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
        }
      }
      else if(service_indication->service EQ MFW_BT_SYNC_CMD)
      {
        MALLOC(service_id, sizeof(T_MFW_BT_SERVICE_ID));/* allocate memory for new device id */
        if(!service_id)
          return FALSE;
        memset(service_id, 0, sizeof(T_MFW_BT_SERVICE_ID));
        len = sizeof(service_indication->service_name);
        id_ptr = &found_sync_cmd;    /* pointer to list of detected SYNC services with SYN commands support */
        if(!id_ptr->device_id)      /* test if does any device id exist */
        {

          id_ptr->device_id = service_id; /* append new device_id */
          memcpy(id_ptr->device_id->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */
          id_ptr->device_id->next = NULL; /* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("sync found ind =  %s", found_sync_cmd.device_id->bd_name);
#endif
        }
        else
        {
          help_id = id_ptr->device_id;/* first element */
          while(help_id->next)        /* look for next device_id                 */
          {
            help_id = help_id->next;
          }

          help_id->next = service_id;/* append new device_id */
          memcpy(help_id->next->bd_addr, service_indication->bd_addr, MFW_BT_ADDR_MAX_LEN);/* new address */
          memcpy(id_ptr->device_id->bd_name, service_indication->bd_name, MFW_BT_NAME_MAX_LEN);
          memcpy(id_ptr->device_id->cod, service_indication->cod, MFW_BT_DEVICE_CLASS_LEN);
          memcpy(id_ptr->device_id->service_name, service_indication->service_name, MFW_BT_SERVICE_NAME_MAX_LEN);/* new name */

          help_id->next->next = NULL;/* finish chain */
#ifdef _SIMULATION_
          TRACE_EVENT_P1("sync found ind =  %s", help_id->next->bd_name);
#endif
        }
      }
      bt_signal(BT_SERVICE_FOUND_IND, service_indication);
      MFREE(service_indication);
      return TRUE;

    case BTP_SERVICE_SEARCH_CNF:
    /* BTI confirms finish of search of services */
      MALLOC(search_conf, sizeof(T_MFW_BT_SERVICE_SEARCH_CNF));
      memset(search_conf, 0, sizeof(T_MFW_BT_SERVICE_SEARCH_CNF));
      search_conf->service = ((T_BTP_SERVICE_SEARCH_CNF *)data)->device;
      bt_signal(BT_SERVICE_SEARCH_CNF, search_conf);
#ifdef _SIMULATION_
        TRACE_EVENT("sync search cnf");
#endif
      MFREE(search_conf);
      return TRUE;

    case BTP_DEVICE_SEARCH_CNF:
    /* BTI confirms finish of search of devices */
      MALLOC(dev_search_conf, sizeof(T_MFW_BT_DEVICE_SEARCH_CNF));
      memset(dev_search_conf, 0, sizeof(T_MFW_BT_DEVICE_SEARCH_CNF));
      dev_search_conf->result = ((T_BTP_DEVICE_SEARCH_CNF *)data)->result;
      bt_signal(BT_DEVICE_SEARCH_CNF, dev_search_conf);
      MFREE(dev_search_conf);
      return TRUE;

    case BTP_CONNECT_DEVICE_CNF:
      /* BTI confirms connection */
      MALLOC(connect_cnf, sizeof(T_MFW_BT_CONNECT_CNF));
      memset(connect_cnf, 0, sizeof(T_MFW_BT_CONNECT_CNF));
      connect_cnf->service = ((T_BTP_CONNECT_DEVICE_CNF *)data)->device;
      memcpy(connect_cnf->bd_addr, ((T_BTP_CONNECT_DEVICE_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      connect_cnf->result_bd = ((T_BTP_CONNECT_DEVICE_CNF *)data)->result;
      connect_cnf->cnf_id = ((T_BTP_CONNECT_DEVICE_CNF *)data)->cnf_id;
      connect_cnf->cause = ((T_BTP_CONNECT_DEVICE_CNF *)data)->cause;
      bt_signal(BT_CONNECT_DEVICE_CNF, connect_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P4("conn cnf = %d, %d, %d, %s", connect_cnf->service, connect_cnf->result_bd, connect_cnf->cause, connect_cnf->bd_addr);
#endif
      MFREE(connect_cnf);
      return TRUE;

    case BTP_CONNECT_DEVICE_IND:
      /* BTI indicates that a remote device wants to establish a connection */
      MALLOC(connect_ind, sizeof(T_MFW_BT_CONNECT_IND));
      memset(connect_ind, 0, sizeof(T_MFW_BT_CONNECT_IND));
      connect_ind->service = ((T_BTP_CONNECT_DEVICE_IND *)data)->device;
      connect_ind->mfw_src_id = ((T_BTP_CONNECT_DEVICE_IND *)data)->src_id;
      switch(connect_ind->service)
      {
        case MFW_BT_SYNC_CMD:
          memcpy(connect_ind->bd_addr, ((T_BTP_CONNECT_DEVICE_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
          memcpy(connect_ind->bd_name, ((T_BTP_CONNECT_DEVICE_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
          connect_ind->ind_id = ((T_BTP_CONNECT_DEVICE_IND *)data)->ind_id;
          break;
        case MFW_BT_HEADSET:
          if(connect_ind->mfw_src_id NEQ MFW_BT_GSM_NETWORK) /* indication from remote headset */
          {
            connect_ind->ind_id = ((T_BTP_CONNECT_DEVICE_IND *)data)->ind_id;
            memcpy(connect_ind->bd_addr, ((T_BTP_CONNECT_DEVICE_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
          }
          break;
        default:
          break;
      }
      bt_signal(BT_CONNECT_DEVICE_IND, connect_ind);
#ifdef _SIMULATION_
      if((connect_ind->service EQ MFW_BT_SYNC_CMD) OR (connect_ind->service EQ MFW_BT_HEADSET))
      {
        TRACE_EVENT_P3("conn ind = %d %d %s", connect_ind->service, connect_ind->mfw_src_id, connect_ind->bd_addr);
      }
      else
        TRACE_EVENT_P2("conn ind = %d %d", connect_ind->service, connect_ind->mfw_src_id);
#endif
      MFREE(connect_ind);
      return TRUE;

    case BTP_PIN_IND:
      /* BTI indicates that a pin code is needed */
      MALLOC(pin_indication, sizeof(T_MFW_BT_PIN_IND));
      memset(pin_indication, 0, sizeof(T_MFW_BT_PIN_IND));
      memcpy(pin_indication->bd_addr, ((T_BTP_PIN_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(pin_indication->bd_name, ((T_BTP_PIN_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      bt_signal(BT_PIN_IND, pin_indication);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("pin = %s %s", pin_indication->bd_name, pin_indication->bd_addr);
#endif
      MFREE(pin_indication);
      return TRUE;

    case BTP_AUTHORIZATION_IND:
      /* BTI indicates that a authorization reply is needed */
      MALLOC(authorization_ind, sizeof(T_MFW_BT_AUTHORIZATION_IND));
      memset(authorization_ind, 0, sizeof(T_MFW_BT_AUTHORIZATION_IND));
      memcpy(authorization_ind->bd_addr, ((T_BTP_AUTHORIZATION_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(authorization_ind->bd_name, ((T_BTP_AUTHORIZATION_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      memcpy(authorization_ind->appli_name, ((T_BTP_AUTHORIZATION_IND *)data)->appli_name, MFW_BT_APPL_NAME_MAX_LEN);
      authorization_ind->auth_mask_mfw = ((T_BTP_AUTHORIZATION_IND *)data)->authorization_mask_serv;
      authorization_ind->connection_dir = ((T_BTP_AUTHORIZATION_IND *)data)->incom_conn;
      bt_signal(BT_AUTHORIZATION_IND, authorization_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P4("author ind = %x %d %s %s", authorization_ind->auth_mask_mfw, authorization_ind->connection_dir, authorization_ind->bd_name, authorization_ind->appli_name);
#endif
      MFREE(authorization_ind);
      return TRUE;

    case BTP_TRANSFER_AUDIO_OUT_CNF:
      /* BTI confirms audio connection to device */
      MALLOC(audio_out_cnf, sizeof(T_MFW_BT_TRANSFER_AUDIO_OUT_CNF));
      memset(audio_out_cnf, 0, sizeof(T_MFW_BT_TRANSFER_AUDIO_OUT_CNF));
      audio_out_cnf->service = ((T_BTP_TRANSFER_AUDIO_OUT_CNF *)data)->device;
      audio_out_cnf->result_bd = ((T_BTP_TRANSFER_AUDIO_OUT_CNF *)data)->result;
      memcpy(audio_out_cnf->bd_addr, ((T_BTP_TRANSFER_AUDIO_OUT_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      audio_out_cnf->cnf_id = ((T_BTP_TRANSFER_AUDIO_OUT_CNF *)data)->cnf_id;
      bt_signal(BT_TRANSFER_AUDIO_OUT_CNF, audio_out_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("audio out cnf = %d, %s", audio_out_cnf->service, audio_out_cnf->bd_addr);
#endif
      MFREE(audio_out_cnf);
      return TRUE;

    case BTP_TRANSFER_AUDIO_IN_CNF:
      /* BTI confirms audio connection from headset */
      MALLOC(audio_in_cnf, sizeof(T_MFW_BT_TRANSFER_AUDIO_IN_CNF));
      memset(audio_in_cnf, 0, sizeof(T_MFW_BT_TRANSFER_AUDIO_IN_CNF));
      audio_in_cnf->service = ((T_BTP_TRANSFER_AUDIO_IN_CNF *)data)->device;
      audio_in_cnf->result_bd = ((T_BTP_TRANSFER_AUDIO_IN_CNF *)data)->result;
      memcpy(audio_in_cnf->bd_addr, ((T_BTP_TRANSFER_AUDIO_IN_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      bt_signal(BT_TRANSFER_AUDIO_IN_CNF, audio_in_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("audio in cnf = %d, %s", audio_in_cnf->service, audio_in_cnf->bd_addr);
#endif
      MFREE(audio_in_cnf);
      return TRUE;

    case BTP_DISCONNECT_DEVICE_CNF:
      /* BTI confirms disconnection for profile hsg */
      MALLOC(disconnect_cnf, sizeof(T_MFW_BT_DISCONNECT_CNF));
      memset(disconnect_cnf, 0, sizeof(T_MFW_BT_DISCONNECT_CNF));
      disconnect_cnf->service = ((T_BTP_DISCONNECT_DEVICE_CNF *)data)->device;
      disconnect_cnf->cnf_id = ((T_BTP_DISCONNECT_DEVICE_CNF *)data)->cnf_id;
      memcpy(disconnect_cnf->bd_addr, ((T_BTP_DISCONNECT_DEVICE_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      bt_signal(BT_DISCONNECT_DEVICE_CNF, disconnect_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("disconn cnf = %d, %d, %s", disconnect_cnf->service, disconnect_cnf->cnf_id, disconnect_cnf->bd_addr);
#endif
      MFREE(disconnect_cnf);
      return TRUE;

    case BTP_DISCON_DUN_FAX_CNF:
      /* BTI confirms disconnection for profile dun/fax */
      MALLOC(discon_dun_fax_cnf, sizeof(T_MFW_BT_DISCON_DUN_FAX_CNF));
      memset(discon_dun_fax_cnf, 0, sizeof(T_MFW_BT_DISCON_DUN_FAX_CNF));
      discon_dun_fax_cnf->service = ((T_BTP_DISCON_DUN_FAX_CNF *)data)->device;
      discon_dun_fax_cnf->result_bd = ((T_BTP_DISCON_DUN_FAX_CNF *)data)->cause;
      bt_signal(BT_DISCON_DUN_FAX_CNF, discon_dun_fax_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("disconn cnf = %d, %d", discon_dun_fax_cnf->service, discon_dun_fax_cnf->result_bd);
#endif
      MFREE(discon_dun_fax_cnf);
      return TRUE;

    case BTP_DISCONNECT_DEVICE_IND:
      /* BTI indicats disconnection from headset*/
      MALLOC(disconnect_ind, sizeof(T_MFW_BT_DISCONNECT_IND));
      memset(disconnect_ind, 0, sizeof(T_MFW_BT_DISCONNECT_IND));
      disconnect_ind->service = ((T_BTP_DISCONNECT_DEVICE_IND *)data)->device;
      disconnect_ind->ind_id = ((T_BTP_DISCONNECT_DEVICE_IND *)data)->ind_id;
      memcpy(disconnect_ind->bd_addr, ((T_BTP_DISCONNECT_DEVICE_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      bt_signal(BT_DISCONNECT_DEVICE_IND, disconnect_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("disconn ind hsg = %d, %d, %s", disconnect_ind->service, disconnect_ind->ind_id, disconnect_ind->bd_addr);
#endif
      MFREE(disconnect_ind);
      return TRUE;

    case BTP_DISCON_DUN_FAX_IND:
      /* BTI indicates disconnection from remote dun/fax */
      MALLOC(disc_dun_fax_ind, sizeof(T_MFW_BT_DISCON_DUN_FAX_IND));
      memset(disc_dun_fax_ind, 0, sizeof(T_MFW_BT_DISCON_DUN_FAX_IND));
      disc_dun_fax_ind->service = ((T_BTP_DISCON_DUN_FAX_IND *)data)->device;
      bt_signal(BT_DISCON_DUN_FAX_IND, disc_dun_fax_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P1("disconn ind dun = %d", disc_dun_fax_ind->service);
#endif
      MFREE(disc_dun_fax_ind);
      return TRUE;

    case BTP_DEVICE_PAIRED_IND:
      /* BTI indicates that a pin code is needed */
      MALLOC(pair_indication, sizeof(T_MFW_BT_DEV_PAIR_IND));
      memset(pair_indication, 0, sizeof(T_MFW_BT_DEV_PAIR_IND));
      memcpy(pair_indication->rem_bd_addr, ((T_BTP_DEVICE_PAIRED_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(pair_indication->rem_bd_name, ((T_BTP_DEVICE_PAIRED_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      pair_indication->pair_res = ((T_BTP_DEVICE_PAIRED_IND *)data)->pair_result;
      bt_signal(BT_DEVICE_PAIRED_IND, pair_indication);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("pair ind = %d %s", pair_indication->pair_res, pair_indication->rem_bd_name);
#endif
      MFREE(pair_indication);
      return TRUE;

    case BTP_TRUSTED_DEV_LIST_FULL:
      /* BTI indicates that list of trusted devices is full */
      bt_signal(BT_TRUSTED_DEV_LIST_FULL, NULL);
#ifdef _SIMULATION_
      TRACE_EVENT("TRUSTED_DEV_LIST_FULL");
#endif
      return TRUE;

    case BTP_CALL_MONITORING_STATUS:
      /* BTI indicates call monitoring messages by dun/fax */
      MALLOC(dun_call_state, sizeof(T_MFW_BT_CALL_STATUS_DUN_FAX));
      memset(dun_call_state, 0, sizeof(T_MFW_BT_CALL_STATUS_DUN_FAX));
      dun_call_state->service = ((T_BTP_CALL_MONITORING_STATUS *)data)->device;
      switch(((T_BTP_CALL_MONITORING_STATUS *)data)->call_status)
      {
        case BTI_DUN_CALL_IN_PRO:
          dun_call_state->call_state = MFW_BT_CALL_IN_PROGRESS;
          break;
        case BTI_DUN_CALL_ESTABLISHED:
          dun_call_state->call_state = MFW_BT_CALL_ESTABLISHED;
          break;
        case BTI_DUN_CALL_PAUSED:
          dun_call_state->call_state = MFW_BT_CALL_PAUSED;
          break;
        case BTI_DUN_CALL_RESUMED:
          dun_call_state->call_state = MFW_BT_CALL_RESUMED;
          break;
        case BTI_DUN_CALL_HANGUP_IN_PR:
          dun_call_state->call_state = MFW_BT_HANGUP_IN_PROGRESS;
          break;
        case BTI_DUN_CALL_RELEASED:
          dun_call_state->call_state = MFW_BT_CALL_RELEASED;
          break;
        case BTI_FAX_CALL_IN_PRO:
          dun_call_state->call_state = MFW_BT_CALL_IN_PROGRESS;
          break;
        case BTI_FAX_CALL_ESTABLISHED:
          dun_call_state->call_state = MFW_BT_CALL_ESTABLISHED;
          break;
        case BTI_FAX_CALL_HANGUP_IN_PR:
          dun_call_state->call_state = MFW_BT_HANGUP_IN_PROGRESS;
          break;
        case BTI_FAX_CALL_RELEASED:
          dun_call_state->call_state = MFW_BT_CALL_RELEASED;
          break;
        default:
          break;
      }
      bt_signal(BT_CALL_MONITORING_STATUS, dun_call_state);
#ifdef _SIMULATION_
      TRACE_EVENT_P2("dun call monit = %d %d", dun_call_state->service, dun_call_state->call_state);
#endif
      MFREE(dun_call_state);
      return TRUE;
    case BTP_OPP_SERV_PUT_IND:
      /* BTI indicates that a put response is needed (OPP server) */
      MALLOC(opp_put_ind, sizeof(T_MFW_BT_OPP_PUT_IND));
      memset(opp_put_ind, 0, sizeof(T_MFW_BT_OPP_PUT_IND));
      opp_put_ind->service = ((T_BTP_OPP_SERV_PUT_IND *)data)->device;
      opp_put_ind->subtype = ((T_BTP_OPP_SERV_PUT_IND *)data)->subtype;
      memcpy(opp_put_ind->bd_addr, ((T_BTP_OPP_SERV_PUT_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memset(&receiv_object_name, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_name, &((T_BTP_OPP_SERV_PUT_IND *)data)->object_name, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);
      /* from string in Primitive to static buffer in MFW, pointer to MMI */
      opp_put_ind->mfw_opp_object.mfw_object_name = receiv_object_name;
      opp_put_ind->mfw_opp_object.mfw_object_length = ((T_BTP_OPP_SERV_PUT_IND *)data)->object_length;
      bt_signal(BT_OPP_SERV_PUT_IND, opp_put_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("opp put ind = %d, %d, %s", opp_put_ind->service, opp_put_ind->subtype, receiv_object_name);
#endif
      MFREE(opp_put_ind);
      return TRUE;
    case BTP_OPP_SERV_PUT_CNF:
      /* BTI indicates that an object push procedure is finished or cancelled */
      MALLOC(opp_put_cnf, sizeof(T_MFW_BT_OPP_PUT_CNF));
      memset(opp_put_cnf, 0, sizeof(T_MFW_BT_OPP_PUT_CNF));
      opp_put_cnf->service = ((T_BTP_OPP_SERV_PUT_CNF *)data)->device;
      opp_put_cnf->subtype = ((T_BTP_OPP_SERV_PUT_CNF *)data)->subtype;
      memcpy(opp_put_cnf->bd_addr, ((T_BTP_OPP_SERV_PUT_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      opp_put_cnf->mfw_opp_object.mfw_object_type = ((T_BTP_OPP_SERV_PUT_CNF *)data)->object_type;
      memset(&receiv_object_name, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_name, &((T_BTP_OPP_SERV_PUT_CNF *)data)->object_name, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);
      opp_put_cnf->mfw_opp_object.mfw_object_name = receiv_object_name;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      opp_put_cnf->mfw_opp_object.mfw_object_length = ((T_BTP_OPP_SERV_PUT_CNF *)data)->object_length;
      opp_put_cnf->error_cause = ((T_BTP_OPP_SERV_PUT_CNF *)data)->cause;
      bt_signal(BT_OPP_SERV_PUT_CNF, opp_put_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("opp put cnf = %d, %d, %s", opp_put_cnf->service, opp_put_cnf->subtype, receiv_object_name);
#endif
      MFREE(opp_put_cnf);
      return TRUE;
    case BTP_OPP_OBJECT_PUSH_CNF:
      /* BTI indicates that an object push procedure is finished or cancelled */
      MALLOC(opp_obj_push_cnf, sizeof(T_MFW_BT_OPP_PUSH_CNF));
      memset(opp_obj_push_cnf, 0, sizeof(T_MFW_BT_OPP_PUSH_CNF));
      opp_obj_push_cnf->service = ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->device;
      opp_obj_push_cnf->subtype = ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->subtype;
      memcpy(opp_obj_push_cnf->bd_addr, ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      opp_obj_push_cnf->mfw_opp_object.mfw_object_type = ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->object_type;
      memset(&receiv_object_name, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_name, &((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->object_name, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);
      opp_obj_push_cnf->mfw_opp_object.mfw_object_name = receiv_object_name;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      memset(&receiv_object_mime_type, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_mime_type, &((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->object_m_t, MFW_BT_OPP_OBJECT_MIME_MAX_LEN);
      opp_obj_push_cnf->mfw_opp_object.mfw_object_mime_type = receiv_object_mime_type;/* same comment like for ...object_name */
      opp_obj_push_cnf->mfw_opp_object.mfw_object_length = ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->object_length;
      opp_obj_push_cnf->error_cause = ((T_BTP_OPP_OBJECT_PUSH_CNF *)data)->cause;
      bt_signal(BT_OPP_OBJECT_PUSH_CNF, opp_obj_push_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("opp push cnf = %d, %d, %s", opp_obj_push_cnf->service, opp_obj_push_cnf->subtype, receiv_object_name);
#endif
      MFREE(opp_obj_push_cnf);
      return TRUE;
    case BTP_OPP_OBJECT_PULL_CNF:
      /* BTI indicates that an object push procedure is finished or cancelled */
      MALLOC(opp_obj_pull_cnf, sizeof(T_MFW_BT_OPP_PULL_CNF));
      memset(opp_obj_pull_cnf, 0, sizeof(T_MFW_BT_OPP_PULL_CNF));
      opp_obj_pull_cnf->service = ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->device;
      opp_obj_pull_cnf->subtype = ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->subtype;
      memcpy(opp_obj_pull_cnf->bd_addr, ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      opp_obj_pull_cnf->mfw_opp_object.mfw_object_type = ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->object_type;
      memset(&receiv_object_name, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_name, &((T_BTP_OPP_OBJECT_PULL_CNF *)data)->object_name, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);
      opp_obj_pull_cnf->mfw_opp_object.mfw_object_name = receiv_object_name;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      memset(&receiv_object_mime_type, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_object_mime_type, &((T_BTP_OPP_OBJECT_PULL_CNF *)data)->object_m_t, MFW_BT_OPP_OBJECT_MIME_MAX_LEN);
      opp_obj_pull_cnf->mfw_opp_object.mfw_object_mime_type = receiv_object_mime_type;/* same comment like for ...object_name */
      opp_obj_pull_cnf->mfw_opp_object.mfw_object_length = ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->object_length;
      opp_obj_pull_cnf->error_cause = ((T_BTP_OPP_OBJECT_PULL_CNF *)data)->cause;
      bt_signal(BT_OPP_OBJECT_PULL_CNF, opp_obj_pull_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("opp pull cnf = %d, %d, %s", opp_obj_pull_cnf->service, opp_obj_pull_cnf->subtype, receiv_object_name);
#endif
      MFREE(opp_obj_pull_cnf);
      return TRUE;
    case BTP_SRV_SYNC_CNF:
      /* BTI indicates that synchronization operation completes (initiated by client or server) */
      MALLOC(srv_sync_cnf, sizeof(T_MFW_BT_SRV_SYNC_CNF));
      memset(srv_sync_cnf, 0, sizeof(T_MFW_BT_SRV_SYNC_CNF));
      srv_sync_cnf->service = ((T_BTP_SRV_SYNC_CNF *)data)->device;
      srv_sync_cnf->subtype = ((T_BTP_SRV_SYNC_CNF *)data)->subtype;
      memcpy(srv_sync_cnf->mfw_client_bd_addr, ((T_BTP_SRV_SYNC_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(srv_sync_cnf->mfw_client_name, ((T_BTP_SRV_SYNC_CNF *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      srv_sync_cnf->mfw_error_state = ((T_BTP_SRV_SYNC_CNF *)data)->cause;
      bt_signal(BT_SRV_SYNC_CNF, srv_sync_cnf);
      MFREE(srv_sync_cnf);
      return TRUE;
    case BTP_SRV_SYNC_AUTH_IND:
      /* BTI indicates that synchronization operation completes (initiated by client or server) */
      MALLOC(srv_sync_auth, sizeof(T_MFW_BT_SRV_SYNC_AUTH_IND));
      memset(srv_sync_auth, 0, sizeof(T_MFW_BT_SRV_SYNC_AUTH_IND));
      srv_sync_auth->service = ((T_BTP_SRV_SYNC_AUTH_IND *)data)->device;
      srv_sync_auth->subtype = ((T_BTP_SRV_SYNC_AUTH_IND *)data)->subtype;
      memcpy(srv_sync_auth->mfw_client_bd_addr, ((T_BTP_SRV_SYNC_AUTH_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(srv_sync_auth->mfw_client_name, ((T_BTP_SRV_SYNC_AUTH_IND *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      bt_signal(BT_SRV_SYNC_AUTH_IND, srv_sync_auth);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("sync auth ind = %d, %d, %s", srv_sync_auth->service, srv_sync_auth->subtype, srv_sync_auth->mfw_client_bd_addr);
#endif
      MFREE(srv_sync_auth);
      return TRUE;
    case BTP_SRV_SYNC_PULL_IND:
      /* BTI indicates that the client requests to pull an object from the sync server */
      MALLOC(srv_sync_pull_ind, sizeof(T_MFW_BT_SRV_SYNC_PULL_IND));
      memset(srv_sync_pull_ind, 0, sizeof(T_MFW_BT_SRV_SYNC_PULL_IND));
      srv_sync_pull_ind->service = ((T_BTP_SRV_SYNC_PULL_IND *)data)->device;
      srv_sync_pull_ind->subtype = ((T_BTP_SRV_SYNC_PULL_IND *)data)->subtype;
      memcpy(srv_sync_pull_ind->mfw_client_bd_addr, ((T_BTP_SRV_SYNC_PULL_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      srv_sync_pull_ind->mfw_object_id.mfw_object_size = ((T_BTP_SRV_SYNC_PULL_IND *)data)->object_id_size;
      memset(&sync_object_location_id, 0, MFW_BT_SYNC_OBJECT_IDENTIFIER);/* limited with 256 characters */
      memcpy(&sync_object_location_id, &((T_BTP_SRV_SYNC_PULL_IND *)data)->object_id_loc, MFW_BT_SYNC_OBJECT_IDENTIFIER);
      srv_sync_pull_ind->mfw_object_id.mfw_location = sync_object_location_id;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      bt_signal(BT_SRV_SYNC_PULL_IND, srv_sync_pull_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("sync pull ind = %d, %d, %d", srv_sync_pull_ind->service, srv_sync_pull_ind->subtype, srv_sync_pull_ind->mfw_object_id.mfw_object_size);
#endif
      MFREE(srv_sync_pull_ind);
      return TRUE;
    case BTP_SRV_SYNC_PUSH_IND:
      /* BTI indicates that the client requests to pull an object from the sync server */
      MALLOC(srv_sync_push_ind, sizeof(T_MFW_BT_SRV_SYNC_PUSH_IND));
      memset(srv_sync_push_ind, 0, sizeof(T_MFW_BT_SRV_SYNC_PUSH_IND));
      srv_sync_push_ind->service = ((T_BTP_SRV_SYNC_PUSH_IND *)data)->device;
      srv_sync_push_ind->subtype = ((T_BTP_SRV_SYNC_PUSH_IND *)data)->subtype;
      memcpy(srv_sync_push_ind->mfw_client_bd_addr, ((T_BTP_SRV_SYNC_PUSH_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      srv_sync_push_ind->mfw_object_id.mfw_object_size = ((T_BTP_SRV_SYNC_PUSH_IND *)data)->object_id_size;
      memset(&sync_object_location_id, 0, MFW_BT_SYNC_OBJECT_IDENTIFIER);/* limited with 256 characters */
      memcpy(&sync_object_location_id, &((T_BTP_SRV_SYNC_PUSH_IND *)data)->object_id_loc, MFW_BT_SYNC_OBJECT_IDENTIFIER);
      srv_sync_push_ind->mfw_object_id.mfw_location = sync_object_location_id;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      bt_signal(BT_SRV_SYNC_PUSH_IND, srv_sync_push_ind);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("sync push ind = %d, %d, %d", srv_sync_push_ind->service, srv_sync_push_ind->subtype, srv_sync_push_ind->mfw_object_id.mfw_object_size);
#endif
      MFREE(srv_sync_push_ind);
      return TRUE;
    case BTP_SRV_SYNC_PUSH_CNF:
      /* BTI indicates that the client requests to pull an object from the sync server */
      MALLOC(srv_sync_push_cnf, sizeof(T_MFW_BT_SRV_SYNC_PUSH_CNF));
      memset(srv_sync_push_cnf, 0, sizeof(T_MFW_BT_SRV_SYNC_PUSH_CNF));
      srv_sync_push_cnf->service = ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->device;
      srv_sync_push_cnf->subtype = ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->subtype;
      memcpy(srv_sync_push_cnf->mfw_client_bd_addr, ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      srv_sync_push_cnf->mfw_object.mfw_object_type = ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_type;
      memset(&sync_object_name, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&sync_object_name, &((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_name, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);
      srv_sync_push_cnf->mfw_object.mfw_object_name = sync_object_name;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      memset(&receiv_sync_object_mime_type, 0, MFW_BT_OPP_OBJECT_NAME_MAX_LEN);/* limited with 256 characters */
      memcpy(&receiv_sync_object_mime_type, &((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_m_t, MFW_BT_OPP_OBJECT_MIME_MAX_LEN);
      srv_sync_push_cnf->mfw_object.mfw_object_mime_type = receiv_sync_object_mime_type;/* same comment like for ...object_name */
      srv_sync_push_cnf->mfw_object.mfw_object_length = ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_length;
      srv_sync_push_cnf->mfw_object_id.mfw_object_size = ((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_id_size;
      memset(&sync_object_location_id, 0, MFW_BT_SYNC_OBJECT_IDENTIFIER);/* limited with 256 characters */
      memcpy(&sync_object_location_id, &((T_BTP_SRV_SYNC_PUSH_CNF *)data)->object_id_loc, MFW_BT_SYNC_OBJECT_IDENTIFIER);
      srv_sync_push_cnf->mfw_object_id.mfw_location = sync_object_location_id;/* from string in Primitive to static buffer in MFW (pointer is not possible in Primitive), pointer of buffer */
      bt_signal(BT_SRV_SYNC_PUSH_CNF, srv_sync_push_cnf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("sync push cnf = %d, %d, %s", srv_sync_push_cnf->service, srv_sync_push_cnf->subtype, srv_sync_push_cnf->mfw_client_bd_addr);
#endif
      MFREE(srv_sync_push_cnf);
      return TRUE;

    case BTP_CONNECT_DEVICE_INF:
      /* BTI indicates that hsg manages a connection on RFCOMM level */
      MALLOC(connect_inf, sizeof(T_MFW_BT_CONNECT_INF));
      memset(connect_inf, 0, sizeof(T_MFW_BT_CONNECT_INF));
      connect_inf->service = ((T_BTP_CONNECT_DEVICE_INF *)data)->device;
      connect_inf->ind_id = ((T_BTP_CONNECT_DEVICE_INF *)data)->ind_id;

      if(connect_inf->ind_id EQ MFW_BT_INVALID_HEADSET_ID)
      {
        memcpy(connect_inf->bd_addr, ((T_BTP_CONNECT_DEVICE_INF *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      }
      bt_signal(BT_CONNECT_DEVICE_INF, connect_inf);
#ifdef _SIMULATION_
      TRACE_EVENT_P3("conn inf = %d %d %s", connect_inf->service, connect_inf->ind_id, connect_inf->bd_addr);
#endif
      MFREE(connect_inf);
      return TRUE;

  /* BT CTRL */
    case BTP_CHNG_LOCAL_NAME:
      MALLOC(c_loc_name, sizeof(T_MFW_BT_CHNG_LOCAL_NAME));
      c_loc_name->success = ((T_BTP_CHNG_LOCAL_NAME *)data)->success;
      bt_signal(BT_CHNG_LOCAL_NAME, c_loc_name);
      MFREE(c_loc_name);
      return TRUE;

    case BTP_READ_LOCAL_NAME:
      MALLOC(r_loc_name, sizeof(T_MFW_BT_READ_LOCAL_NAME));
      r_loc_name->success = ((T_BTP_READ_LOCAL_NAME *)data)->success;
      memcpy(r_loc_name->bd_name, ((T_BTP_READ_LOCAL_NAME *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      bt_signal(BT_READ_LOCAL_NAME, r_loc_name);
      MFREE(r_loc_name);
      return TRUE;

    case BTP_REMOTE_DEV_INFO_RES:
      MALLOC(rem_dev_info, sizeof(T_MFW_BT_REMOTE_DEV_INFO_RES));
      rem_dev_info->success = ((T_BTP_REMOTE_DEV_INFO_RES *)data)->success;
      memcpy(rem_dev_info->bd_addr, ((T_BTP_REMOTE_DEV_INFO_RES *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      memcpy(rem_dev_info->bd_name, ((T_BTP_REMOTE_DEV_INFO_RES *)data)->bd_name, MFW_BT_NAME_MAX_LEN);
      memcpy(rem_dev_info->cod, ((T_BTP_REMOTE_DEV_INFO_RES *)data)->cod, MFW_BT_DEVICE_CLASS_LEN);

      bt_signal(BT_REMOTE_DEV_INFO_RES, rem_dev_info);
      MFREE(rem_dev_info);
      return TRUE;

    case BTP_CHNG_CONNECTABLE_MODE:
      MALLOC(chng_cmode, sizeof(T_MFW_BT_CHNG_CONNECTABLE_MODE));
      chng_cmode->success = ((T_BTP_CHNG_CONNECTABLE_MODE *)data)->success;
      chng_cmode->mode = (T_MFW_BT_CONNECTABLE_MODE)((T_BTP_CHNG_CONNECTABLE_MODE *)data)->mode;
      chng_cmode->scan_interval = ((T_BTP_CHNG_CONNECTABLE_MODE *)data)->scan_interval;
      chng_cmode->scan_window = ((T_BTP_CHNG_CONNECTABLE_MODE *)data)->scan_window;

      bt_signal(BT_CHNG_CONNECTABLE_MODE, chng_cmode);
      MFREE(chng_cmode);
      return TRUE;

    case BTP_CHNG_DISCOVERABLE_MODE:
      MALLOC(chng_dmode, sizeof(T_MFW_BT_CHNG_DISCOVERABLE_MODE));
      chng_dmode->success = ((T_BTP_CHNG_DISCOVERABLE_MODE *)data)->success;
      chng_dmode->mode = (T_MFW_BT_DISCOVERABLE_MODE)((T_BTP_CHNG_DISCOVERABLE_MODE *)data)->mode;
      chng_dmode->scan_interval = ((T_BTP_CHNG_DISCOVERABLE_MODE *)data)->scan_interval;
      chng_dmode->scan_window = ((T_BTP_CHNG_DISCOVERABLE_MODE *)data)->scan_window;

      bt_signal(BT_CHNG_DISCOVERABLE_MODE, chng_dmode);
      MFREE(chng_dmode);
      return TRUE;

    case BTP_READ_BD_ADDR:
      MALLOC(r_bd_addr, sizeof(T_MFW_BT_READ_BD_ADDR));
      r_bd_addr->success = ((T_BTP_READ_BD_ADDR *)data)->success;
      memcpy(r_bd_addr->bd_addr, ((T_BTP_READ_BD_ADDR *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
      bt_signal(BT_READ_BD_ADDR, r_bd_addr);
      MFREE(r_bd_addr);
      return TRUE;

/*#ifdef PCA_6350*/
    case BTP_PCA_EVENT:
      if (((T_BTP_PCA_EVENT*)data)->pca_event == BTI_PCA_GW_STATUS_CFM)
      {
        MALLOC(pca_gw_status, sizeof(T_MFW_BT_PCA_GW_STATUS_CFM));
        pca_gw_status->status = ((T_BTP_PCA_EVENT*)data)->pca_gw_status;
        bt_signal(BT_PCA_GW_STATUS_CFM, pca_gw_status);
        return TRUE;
      }

      if (((T_BTP_PCA_EVENT*)data)->pca_event == BTI_PCA_GW_LINK_MONITORING)
      {
        MALLOC(pca_link_mon, sizeof(T_MFW_BT_PCA_GW_LINK_MONITORING));
        pca_link_mon->link_status = ((T_BTP_PCA_EVENT*)data)->pca_link_status;
        memcpy(pca_link_mon->bd_addr, ((T_BTP_PCA_EVENT *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);
        bt_signal(BT_PCA_GW_LINK_MONITORING, pca_link_mon);
        return TRUE;
      }

      if (((T_BTP_PCA_EVENT*)data)->pca_event == BTI_PCA_GW_CALL_MONITORING)
      {
        MALLOC(pca_call_mon, sizeof(T_MFW_BT_PCA_GW_CALL_MONITORING));
        pca_call_mon->call_status = ((T_BTP_PCA_EVENT*)data)->pca_call_status;
        bt_signal(BT_PCA_GW_CALL_MONITORING, pca_call_mon);
        return TRUE;
      }

      if (((T_BTP_PCA_EVENT*)data)->pca_event == BTI_PCA_GW_HANGUP_CFM)
      {
        MALLOC(pca_hangup, sizeof(T_MFW_BT_PCA_GW_HANGUP_CFM));
        pca_hangup->hangup = ((T_BTP_PCA_EVENT*)data)->pca_hangup;
        bt_signal(BT_PCA_GW_HANGUP_CFM, pca_hangup);
        return TRUE;
      }

    /* Cartman added begin */
    
    case BTP_HSG_HEADSET_CONNECTION_IND:
        MALLOC(hsg_headset_connection_ind, sizeof(T_MFW_BT_HSG_HEADSET_CONNECTION_IND));
        memset(hsg_headset_connection_ind, 0, sizeof(T_MFW_BT_HSG_HEADSET_CONNECTION_IND));
        
        hsg_headset_connection_ind->service = ((T_BTP_HSG_HEADSET_CONNECTION_IND *)data)->device;
        hsg_headset_connection_ind->ind_id = ((T_BTP_HSG_HEADSET_CONNECTION_IND *)data)->ind_id;
        memcpy(hsg_headset_connection_ind->bd_addr, ((T_BTP_HSG_HEADSET_CONNECTION_IND *)data)->bd_addr, MFW_BT_ADDR_MAX_LEN);

        bt_signal(BT_HSG_HEADSET_CONNECTION_IND, hsg_headset_connection_ind);    	
    	return TRUE;

    case BTP_HSG_SPECIFIC_CMD_RDY:
		MALLOC(hsg_specific_cmd_cfm, sizeof(T_MFW_BT_HSG_SPECIFIC_CMD_CFM));

		memcpy(hsg_specific_cmd_cfm->cmd,((T_BTP_HSG_SPECIFIC_CMD_RDY *)data)->cmd,100);
        
        bt_signal(BT_HSG_SPECIFIC_CMD_CFM,hsg_specific_cmd_cfm);
    	return TRUE;

    case BTP_HSG_SAVE_LIST_CNF:
        MALLOC(hsg_save_list_cnf, sizeof(T_MFW_BT_HSG_SAVE_LIST_CNF));
        hsg_save_list_cnf->result=((T_BTP_HSG_SAVE_LIST_CNF *)data)->result;
        
        bt_signal(BT_HSG_SAVE_LIST_CNF,hsg_save_list_cnf);
    	return TRUE;    	

    /* Cartman added end */
      
/*#endif*/ /* PCA_6350 */
  }

#ifdef _SIMULATION_
/*
 * kk 12.01.01
 * these primitives are available only for testing. they describe
 * function calls (loopbacked to ACI/MFW) made from MFW
 */

    switch ((USHORT) opc)
    {
        case BTP_INIT_PROFILE_REQ:
        TRACE_EVENT("bta_response_cb:BTP_INIT_PROFILE_REQ");
        return TRUE;

        case BTP_DEINIT_PROFILE_REQ:
        TRACE_EVENT("bta_response_cb:BTP_DEINIT_PROFILE_REQ");
        return TRUE;

        case BTP_DEVICE_SEARCH_REQ:
        TRACE_EVENT("bta_response_cb:BTP_DEVICE_SEARCH_REQ");
        return TRUE;

        case BTP_CONNECT_DEVICE_REQ:
        TRACE_EVENT("bta_response_cb:BTP_CONNECT_DEVICE_REQ");
        return TRUE;

        case BTP_CONNECT_DEVICE_RES:
        TRACE_EVENT("bta_response_cb:BTP_CONNECT_DEVICE_RES");
        return TRUE;

        case BTP_DISCONNECT_DEVICE_REQ:
        TRACE_EVENT("bta_response_cb:BTP_DISCONNECT_DEVICE_REQ");
        return TRUE;

        case BTP_TRANSFER_AUDIO_IN_REQ:
        TRACE_EVENT("bta_response_cb:BTP_TRANSFER_AUDIO_IN_REQ");
        return TRUE;

        case BTP_TRANSFER_AUDIO_OUT_REQ:
        TRACE_EVENT("bta_response_cb:BTP_TRANSFER_AUDIO_OUT_REQ");
        return TRUE;

        case BTP_RECONFIG_PROFILE_REQ:
        TRACE_EVENT("bta_response_cb:BTP_RECONFIG_PROFILE_REQ");
        return TRUE;

        case BTI_SEND_DATA_TEST:
        TRACE_EVENT("BTI_SEND_DATA_TEST");
        {
            UBYTE buf[2048];
            memset(buf, 0, 2048);
            memcpy(buf, ((T_BTI_SEND_DATA_TEST *)data)->ind_data, ((T_BTI_SEND_DATA_TEST *)data)->len);

            bti_simulate_dti_data_ind(((T_BTI_SEND_DATA_TEST *)data)->port_nb, ((T_BTI_SEND_DATA_TEST *)data)->len, buf);
        }
        return TRUE;

        case BTI_GET_DATA_TEST:
        TRACE_EVENT("BTI_GET_DATA_TEST");
        {
            UBYTE buf[2048];
            memset(buf, 0, 2048);
            memcpy(buf, ((T_BTI_GET_DATA_TEST *)data)->ind_data, ((T_BTI_GET_DATA_TEST *)data)->len);

            bti_simulate_data_bt_to_gsm(((T_BTI_GET_DATA_TEST *)data)->port_nb, ((T_BTI_GET_DATA_TEST *)data)->len, buf);
        }
        return TRUE;
/* for test bluetooth without BMI/MMI ******************************************/
        case BTP_SRV_SYNC_TEST:/* test SYNC profile */
        TRACE_EVENT("bta_response_cb:BTP_SRV_SYNC_TEST");
        switch(((T_BTP_SRV_SYNC_TEST *)data)->func_id)
        {
          case 1:/* start bluetooth primitive SYN_SERVER_SYNC_COMPLETE */
            bti_syn_server_sync_compl();
            break;
          case 2: /* start bluetooth function syn_server_sync_termination() */
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            if(bt_syn_s_sync_terminate(service, subtyp) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:sync termination Failure");
            }
            else
              TRACE_EVENT("sync termination ok");
            break;
          case 3: /* start bluetooth function syn_server_get_response() */
            memset(&syn_pull_obj, 0, sizeof(syn_pull_obj));
            memset(&server_syn_object, 0, MFW_BT_OPP_BUFFER_LENGTH);
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            syn_pull_obj.mfw_buffer_start = server_syn_object;
            syn_pull_obj.mfw_buffer_size = sizeof(&server_syn_object);
            syn_pull_obj.mfw_object_type = MFW_BT_BUFFER;/* store pulled object in buffer */
            syn_pull_obj.mfw_path = NULL;
            syn_pull_obj.mfw_object_length =  sizeof(&server_syn_object);
            syn_pull_obj.mfw_object_mime_type = NULL;/* MIME directory information only for object_type: MFW_BT_PATH */

            if(bt_syn_s_pull_resp(service, subtyp, syn_pull_obj) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:sync pull response Failure");
            }
            else
              TRACE_EVENT("sync pull response ok");
            break;
          case 4:/* start bluetooth primitive SYN_SERVER_PUT_REQUEST with TRACE_EVENT in mfw_bta */
            bti_sync_put_req();
            break;
          case 5:/* start bluetooth primitive SYN_SERVER_PUT_CFM with TRACE_EVENT in mfw_bta */
            bti_syn_server_put_confirm();
            break;
          case 6:/* start bluetooth primitive SYN_SERVER_GET_REQUEST with TRACE_EVENT in mfw_bta */
            bti_sync_get_req();
            break;
          case 7:/* start bluetooth primitive SYN_SERVER_AUTHENTICATION_REQUEST with TRACE_EVENT in mfw_bta */
            bti_sync_auth_req();
            break;
          case 8:/* start bluetooth primitive SYN_SERVER_CLIENT_IS_CONNECTED with TRACE_EVENT in mfw_bta */
            bti_sync_client_con_ind();
            break;
          case 9: /* start bluetooth function syn_server_put_response() */
            memset(&syn_push_obj, 0, sizeof(syn_push_obj));
            memset(&server_syn_object, 0, MFW_BT_OPP_BUFFER_LENGTH);
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            syn_push_obj.mfw_buffer_start = server_syn_object;
            syn_push_obj.mfw_buffer_size = sizeof(&server_syn_object);
            syn_push_obj.mfw_object_type = MFW_BT_BUFFER;/* store pushed object in buffer */
            syn_push_obj.mfw_path = NULL;
            syn_push_obj.mfw_object_length =  sizeof(&server_syn_object);
            syn_push_obj.mfw_object_mime_type = NULL;/* MIME directory information only for object_type: MFW_BT_PATH */

            if(bt_syn_s_push_resp(service, subtyp, syn_push_obj) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync push response Failure");
            }
            else
              TRACE_EVENT("sync push response ok");
            break;
          case 10: /* start bluetooth function syn_server_authentication_response() */
            memset(mfw_sync_password, 0, MFW_BT_PIN_MAX_LEN);
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            for(j=0;j<10;j++)
              mfw_sync_password[j] = j | 0x30;
            mfw_sync_password_ptr = &mfw_sync_password[0];
            if(bt_syn_s_auth_res(service, subtyp, mfw_sync_password_ptr) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:sync authentication response Failure");
            }
            else
              TRACE_EVENT("sync authentication response ok");
            break;
          case 11: /* start bluetooth function syn_server_send_sync_command() */
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            mfw_obj = mfw_test_syn_obj;/* object which will be supposed to be synchronized  */
            mfw_syn_action = MFW_BT_SYNC_CO_SYNC; /* request synchronization by specified SYNC client */
            /* specified client address by browsing SYNC Server with SYNC command support */
            memset(&client_address, 0xdd, MFW_BT_ADDR_MAX_LEN);/* example */
            if(bt_syn_s_send_com(service, subtyp, mfw_syn_action, mfw_obj, client_address) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync server send command Failure");
            }
            else
              TRACE_EVENT("sync server send command ok");
            break;
          case 12: /* start bluetooth function syn_server_enable() */
                   /* receive bluetooth primitive BTP_INIT_PROFILE_CNF in BTI */
            memset(&syn_serv_config, 0, sizeof(syn_serv_config));
            service = MFW_BT_SYNC;
            mfw_obj_list.object_store = mfw_test_syn_obj;
            mfw_obj_list.next_object = NULL;
            mfw_obj_list_ptr = &mfw_obj_list;
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            /* default value SYNC server mode */
            syn_serv_config.mfw_syn_srv_mode = MFW_BT_SYNC_GEN_MODE;
            /* default value SYNC server authentication mode */
            syn_serv_config.mfw_syn_srv_auth_mode = MFW_BT_SYNC_INIT_AUTH_MODE;
            if(bt_init_profile_syn_s(service, subtyp, mfw_obj_list_ptr, syn_serv_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync server enable Failure");
            }
            else
              TRACE_EVENT("sync server enable ok");
            break;
          case 13: /* start bluetooth SYNC server application function rvm_start_application() and syn_server_enable() */
            /* receive bluetooth primitive SYN_SERVER_CFM in BTI */
            service = MFW_BT_SYNC;
            if(bt_start_profile_application((T_BTI_DEVICE_TYPE)service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:sync server start and enable Failure");
            }
            else
              TRACE_EVENT("sync server start and enable ok");
            break;
          case 14: /* start bluetooth function syn_server_disable() */
            /* receive bluetooth primitive SYN_SERVER_CFM in BTI */
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync server disable Failure");
            }
            else
              TRACE_EVENT("sync server disable ok");
            break;
          case 15: /* start bluetooth function syn_server_enable() */
            /* receive bluetooth primitive SYN_SERVER_CFM in BTI */
            memset(&syn_serv_config, 0, sizeof(syn_serv_config));
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            mfw_obj_list.object_store = mfw_test_syn_obj;
            mfw_obj_list1.object_store = mfw_test_syn_obj;
            mfw_obj_list_ptr1 = &mfw_obj_list1;
            mfw_obj_list.next_object = mfw_obj_list_ptr1;
            mfw_obj_list1.next_object = NULL;
            mfw_obj_list_ptr = &mfw_obj_list;
            syn_serv_config.mfw_syn_srv_mode = MFW_BT_SYNC_INIT_MODE;/* change in test is not possible that means it is not changed in call back func */
            syn_serv_config.mfw_syn_srv_auth_mode = MFW_BT_SYNC_NO_INIT_AUTH_MODE;/* change in test is not possible that means it is not changed in call back func */
            if(bt_reconf_profile_syn_s(service, subtyp, mfw_obj_list_ptr1, syn_serv_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync server reconfiguration Failure");
            }
            else
              TRACE_EVENT("sync server reconfiguration ok");
            break;
          case 16: /* start bluetooth SYNC server application function syn_server_disable() and rvm_stop_application()*/
            service = MFW_BT_SYNC;
            subtyp = MFW_BT_SERVER;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync server disable and stop application Failure");
            }
            else
              TRACE_EVENT("sync server disable and stop application ok");
            break;
          case 17: /* start bluetooth function bmi_service_browse() for sync client with SYNC command support*/
            service = MFW_BT_SYNC_CMD;
            if(bt_service_search(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:sync search sync client Failure");
            }
            else
              TRACE_EVENT("sync search sync client ok");
            break;
          case 18: /* start mfw function bt_clear_list_found_serv() of found sync */
            service = MFW_BT_SYNC_CMD;
            if(bt_clear_list_found_serv(service) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:sync list del Failure");
            }
            else
              TRACE_EVENT("sync list del ok");
            break;
        }
        return TRUE;
        case BTP_SRV_OPP_TEST:/* test OPP profile, server */
        TRACE_EVENT("bta_response_cb:BTP_SRV_OPP_TEST");
        switch(((T_BTP_SRV_OPP_TEST *)data)->func_id)
        {
          case 1: /* start bluetooth OPP server and client application function
             rvm_start_application() and opp_server_enable() and opp_client_enable() */
            /* receive bluetooth primitive OPP_SERVER_CFM/OPP_CLIENT_CFM in BTI*/
            service = MFW_BT_OPP;
            if(bt_start_profile_application((T_BTI_DEVICE_TYPE)service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:opp client + server start and enable Failure");
            }
            else
              TRACE_EVENT("opp client + server start and enable ok");
            break;
          case 2: /* start bluetooth OPP server application function opp_server_enable()*/
            /* receive bluetooth primitive OPP_SERVER_CFM in BTI */
            /* initialize opp server */
            memset(&serv_config, 0, sizeof(serv_config));
            subtyp = MFW_BT_SERVER;
            service = MFW_BT_OPP;
            /* example for default business card;mfw_path and mime_type parameters are NULL because
            mode MFW_BT_OPP_BUFFER_MODE */
            serv_config.mfw_opp_mode = MFW_BT_OPP_BUFFER_MODE;/* OPP server mode */
            serv_config.mfw_inbox_path = NULL;/* not use file system currently */
            serv_config.mfw_opp_object.mfw_object_type = MFW_BT_BUFFER;/* server_business_card in buffer */
            serv_config.mfw_opp_object.mfw_buffer_start = server_business_card;
            serv_config.mfw_opp_object.mfw_buffer_size = sizeof(&server_business_card);
            serv_config.mfw_opp_object.mfw_object_name = server_default_name;
            serv_config.mfw_opp_object.mfw_object_length = sizeof(server_business_card);
            serv_config.mfw_opp_object.mfw_path = NULL;
            serv_config.mfw_opp_object.mfw_object_mime_type = NULL;/* MIME directory information only for object_type: MFW_BT_PATH */

            if(bt_init_profile_opp(service, subtyp, serv_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp server initialize Failure");
            }
            else
              TRACE_EVENT("opp server initialize ok");
            break;
          case 3: /* start bluetooth function opp_server_disable() */
            /* receive bluetooth primitive OPP_SERVER_CFM in BTI */
            subtyp = MFW_BT_SERVER;
            service = MFW_BT_OPP;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp server disable Failure");
            }
            else
              TRACE_EVENT("opp server disable ok");
            break;
          case 4: /* start bluetooth OPP server application function opp_server_enable()*/
            /* receive bluetooth primitive OPP_SERVER_CFM in BTI */
            /* reconfigure opp server */
            memset(&serv_config, 0, sizeof(serv_config));
            subtyp = MFW_BT_SERVER;
            service = MFW_BT_OPP;
            /* example for default business card;mfw_path and mime_type parameters are NULL because
            mode MFW_BT_OPP_BUFFER_MODE */
            serv_config.mfw_opp_mode = MFW_BT_OPP_BUFFER_MODE;/* OPP server mode */
            serv_config.mfw_inbox_path = NULL;/* not use file system currently */
            serv_config.mfw_opp_object.mfw_object_type = MFW_BT_BUFFER;/* bmi_server_business_card in buffer */
            serv_config.mfw_opp_object.mfw_buffer_start = server_business_card;
            serv_config.mfw_opp_object.mfw_buffer_size = sizeof(&server_business_card);
            serv_config.mfw_opp_object.mfw_object_name = server_default_name;
            serv_config.mfw_opp_object.mfw_path = NULL;
            serv_config.mfw_opp_object.mfw_object_mime_type = NULL;/* MIME directory information only for object_type: MFW_BT_PATH */
            serv_config.mfw_opp_object.mfw_object_length = sizeof(server_business_card);

            if(bt_reconf_profile_opp(service, subtyp, serv_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp server reconfigure Failure");
            }
            else
              TRACE_EVENT("opp server reconfigure ok");
            break;
          case 5: /* start bluetooth OPP server application function opp_server_disable() and rvm_stop_application()*/
            service = MFW_BT_OPP;
            subtyp = MFW_BT_SERVER;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp server disable and stop application Failure");
            }
            else
              TRACE_EVENT("opp server disable and stop application ok");
            break;
          case 6: /* start bluetooth OPP server application function opp_server_put_response()*/
            /* reply to OPP_SERVER_PUT_REQUEST of remote opp client(about server)*/
            service = MFW_BT_OPP;
            subtyp = MFW_BT_SERVER;
            memset(&receiv_obj, 0, sizeof(receiv_obj));
            opp_put_res = MFW_BT_OPP_CONTINUE;/* positive response */
            receiv_obj.mfw_object_type = MFW_BT_BUFFER;
            /*  requested location for store of objects*/
            receiv_obj.mfw_buffer_start = server_buffer;
             /* with respect to object length delivered in BTP_OPP_SERV_PUT_IND;it can be bigger or smaller (loss data) - MMI decision */
            receiv_obj.mfw_buffer_size = sizeof(&server_buffer);
            receiv_obj.mfw_path = NULL;
            /* with respect to delivered object name in BTP_OPP_SERV_PUT_IND */
            receiv_obj.mfw_object_name = mfw_test_opp_obj_name;
            /* with respect to delivered object length in BTP_OPP_SERV_PUT_IND */
            receiv_obj.mfw_object_length = sizeof(&server_buffer);
            if(bt_opp_put_reply(service, subtyp, opp_put_res, receiv_obj) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:opp response to put request Failure");
            }
            else
              TRACE_EVENT("opp response to put request ok");
            break;
          case 7: /* start bluetooth primitive OPP_SERVER_PUT_REQUEST with TRACE_EVENT in mfw_bta */
            bti_opp_s_put_req();
            break;
          case 8: /* start bluetooth primitive OPP_SERVER_PUT_CFM with TRACE_EVENT in mfw_bta */
            bti_opp_server_put_cnf();
            break;

        }
        return TRUE;
        case BTP_CL_OPP_TEST:/* test OPP profile, client */
        TRACE_EVENT("bta_response_cb:BTP_CL_OPP_TEST");
        switch(((T_BTP_CL_OPP_TEST *)data)->func_id)
        {
          case 1: /* start bluetooth OPP client application function opp_client_enable()*/
            /* receive bluetooth primitive OPP_CLIENT_CFM in BTI */
            /* initialize opp client */
            memset(&serv_config, 0, sizeof(serv_config));
            subtyp = MFW_BT_CLIENT;
            service = MFW_BT_OPP;
            if(bt_init_profile_opp(service, subtyp, serv_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client initialize Failure");
            }
            else
              TRACE_EVENT("opp client initialize ok");
            break;
          case 2: /* start bluetooth function opp_client_disable() */
            /* receive bluetooth primitive OPP_CLIENT_CFM in BTI */
            subtyp = MFW_BT_CLIENT;
            service = MFW_BT_OPP;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client disable Failure");
            }
            else
              TRACE_EVENT("opp client disable ok");
            break;
          case 3: /* start bluetooth function bmi_service_browse() for OPP server
                   because only servers are registered in data base and clients
                   has to look for remote OPP server */
            service = MFW_BT_OPP;
            if(bt_service_search(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp search Failure");
            }
            else
              TRACE_EVENT("opp search client ok");
            break;
          case 4: /* start mfw function bt_clear_list_found_serv() of found opp */
            service = MFW_BT_OPP;
            if(bt_clear_list_found_serv(service) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:opp list del Failure");
            }
            else
              TRACE_EVENT("opp list del ok");
            break;
          case 5: /* start bluetooth OPP client application function opp_client_disable() and rvm_stop_application()*/
            service = MFW_BT_OPP;
            subtyp = MFW_BT_CLIENT;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client disable and stop application Failure");
            }
            else
              TRACE_EVENT("opp client disable and stop application ok");
            break;
          case 6: /* start bluetooth OPP client application function opp_push_object() */
            /* push object to a specific server */
            memset(&opp_push_obj, 0, sizeof(opp_push_obj));
            service = MFW_BT_OPP;
            subtyp = MFW_BT_CLIENT;
            memset(&server_address, 0xaa, MFW_BT_ADDR_MAX_LEN);/* OPP address with help of browsing procedure */
            mfw_keep_connection_opp = FALSE; /* first block is also last block */
            /*  mfw_keep_connection_opp = TRUE;  further blocks will follow */
            opp_push_obj.mfw_buffer_start = client_buffer;/* content: client object which is desired to push */
            opp_push_obj.mfw_buffer_size = sizeof(&client_buffer);
            opp_push_obj.mfw_object_type = MFW_BT_BUFFER;
            opp_push_obj.mfw_path = NULL;
            opp_push_obj.mfw_object_name = client_obj_name;
            opp_push_obj.mfw_object_length =  sizeof(&client_buffer);
            opp_push_obj.mfw_object_mime_type = NULL;/* MMI must know the mime_type of pushed object */
            if(bt_opp_push_object(service, subtyp, server_address, mfw_keep_connection_opp, opp_push_obj) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client pushs an object Failure");
            }
            else
              TRACE_EVENT("opp client pushs an object ok");
            break;
          case 7: /* start bluetooth primitive OPP_OBJECT_PUSH_CFM with TRACE_EVENT in mfw_bta */
            bti_opp_client_push_cnf();
            break;
          case 8: /* start bluetooth OPP client application function opp_pull_object() */
            /* pull object from a specific server */
            memset(&opp_pull_obj, 0, sizeof(opp_pull_obj));
            service = MFW_BT_OPP;
            subtyp = MFW_BT_CLIENT;
            memset(&server_address, 0xaa, MFW_BT_ADDR_MAX_LEN);
            /* the specific server address can received
             with help of function bt_service_search(service) and  BT_SERVICE_SEARCH_CNF */
            mfw_keep_connection_opp = FALSE; /* first block is also last block */
          /*  mfw_keep_connection_opp = TRUE;  further pull procedures will follow; MMI decision */
            opp_pull_obj.mfw_buffer_start = server_business_card;
            opp_pull_obj.mfw_buffer_size = sizeof(&server_business_card);
            opp_pull_obj.mfw_object_type = MFW_BT_BUFFER;/* store pulled object in buffer */
            opp_pull_obj.mfw_path = NULL;
            opp_pull_obj.mfw_object_length =  sizeof(&server_business_card);
            opp_pull_obj.mfw_object_mime_type = NULL;/* MMI must know the mime_type of pulled object; it is only a test value */
            if(bt_opp_pull_object(service, subtyp, server_address, mfw_keep_connection_opp, opp_pull_obj) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client pulls an object Failure");
            }
            else
              TRACE_EVENT("opp client pulls an object ok");
            break;
          case 9: /* start bluetooth primitive OPP_OBJECT_PULL_CFM with TRACE_EVENT in mfw_bta */
            bti_opp_client_pull_cnf();
            break;
          case 10: /* start bluetooth OPP client application function opp_exchange_card() */
            /* push an object to a specific server and pull object from a specific server */
            memset(&opp_push_obj, 0, sizeof(opp_push_obj));
            memset(&opp_pull_obj, 0, sizeof(opp_pull_obj));
            service = MFW_BT_OPP;
            subtyp = MFW_BT_CLIENT;
            memset(&server_address, 0xaa, MFW_BT_ADDR_MAX_LEN);
            /* the specific server address can received
             with help of function bt_service_search(service) and  BT_SERVICE_SEARCH_CNF */
            mfw_keep_connection_opp = FALSE; /* first block is also last block */
          /*  mfw_keep_connection_opp = TRUE;  further blocks will follow */
            opp_push_obj.mfw_buffer_start = client_business_card;
            opp_push_obj.mfw_buffer_size = sizeof(&client_business_card);
            opp_push_obj.mfw_object_type = MFW_BT_BUFFER;
            opp_push_obj.mfw_path = NULL;
            opp_push_obj.mfw_object_name = client_obj_name;
            opp_push_obj.mfw_object_length =  sizeof(&client_buffer);
            opp_push_obj.mfw_object_mime_type = NULL;

            opp_pull_obj.mfw_buffer_start = server_business_card;
            opp_pull_obj.mfw_buffer_size = sizeof(&server_business_card);
            opp_pull_obj.mfw_object_type = MFW_BT_BUFFER;
            opp_pull_obj.mfw_path = NULL;
            opp_pull_obj.mfw_object_length =  sizeof(&server_business_card);
            opp_pull_obj.mfw_object_mime_type = NULL;

            if(bt_opp_exch_objects(service, subtyp, opp_push_obj, opp_pull_obj, server_address, mfw_keep_connection_opp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:opp client and server exchange object Failure");
            }
            else
              TRACE_EVENT("opp client and server exchange an object ok");
            break;
        }
        return TRUE;

        case BTP_CL_HSG_TEST:/* test HSG profile, client and common hsg features */
        TRACE_EVENT("bta_response_cb:BTP_CL_HSG_TEST");
        switch(((T_BTP_CL_HSG_TEST *)data)->func_id)
        {
          case 1: /* start bluetooth HSG server and client application function rvm_start_application()
                  and hsg_client_enable() and hsg_server_enable() */
            /* receive bluetooth primitive HSG_CLIENT_ENABLE_CFM/HSG_SERVER_ENABLE_CFM in BTI */
            service = MFW_BT_HEADSET;
            if(bt_start_profile_application((T_BTI_DEVICE_TYPE)service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:hsg client + server start and enable Failure");
            }
            else
              TRACE_EVENT("hsg client + server start and enable ok");
            break;
          case 2: /* start bluetooth HSG client application function hsg_client_enable()*/
            /* receive bluetooth primitive HSG_CLIENT_ENABLE_CFM in BTI */
            /* initialize headset client */
            memset(&client_config, 0, sizeof(client_config));
            service = MFW_BT_HEADSET;
            client_config.config_mode = MFW_BT_AUTO_OUTG_DEF_CONN_ON;
            if(bt_init_profile_hsg_cl(service, client_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg client initialize Failure");
            }
            else
              TRACE_EVENT("hsg client initialize ok");
            break;
          case 3: /* start bluetooth HSG client application function hsg_client_enable()*/
            /* receive bluetooth primitive HSG_CLIENT_ENABLE_CFM in BTI */
            /* reconfigure headset client */
            memset(&client_config, 0, sizeof(client_config));
            service = MFW_BT_HEADSET;
            client_config.config_mode = MFW_BT_AUTO_OUTG_DEF_CONN_OFF;
            if(bt_reconfig_profile_hsg_cl(service, client_config) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg client reconfigure Failure");
            }
            else
              TRACE_EVENT("hsg client reconfigure ok");
            break;
          case 4: /* start bluetooth HSG client application function hsg_get_configs()*/
            /* get state of connection mode for headset client */
            memset(&client_config, 0, sizeof(client_config));
            service = MFW_BT_HEADSET;
            if(bt_get_auto_connect(service, &client_config) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:hsg client connection mode Failure");
            }
            else
            {
              TRACE_EVENT_P1("connect mode = %d", client_config.config_mode);
            }
            break;
          case 5: /* start bluetooth HSG client application function hsg_get_configs()*/
            /* get headset client and server configuration */
            memset(&server_conf, 0, sizeof(server_conf));
            memset(&client_config, 0, sizeof(client_config));
            service = MFW_BT_HEADSET;
            if(bt_get_config(service, &client_config, &server_conf) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:hsg client and server configuration failure");
            }
            else
            {
              TRACE_EVENT_P1("client connect mode = %d", client_config.config_mode);
              TRACE_EVENT_P1("server number phone list = %d", server_conf.nb_phone);
            }
            break;
          case 6: /* start bluetooth HSG client application function hsg_client_enable()*/
            /* set state of connection mode for headset client */
            service = MFW_BT_HEADSET;
            if(bt_auto_connect(service, MFW_BT_AUTO_CONNECT_ON) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:hsg client set connection mode failure");
            }
            else
              TRACE_EVENT("hsg client set connection mode ok");
            break;
          case 7: /* start bluetooth function hsg_client_disable() */
            /* receive bluetooth primitive HSG_CLIENT_ENABLE_CFM in BTI */
            service = MFW_BT_HEADSET;
            subtyp = MFW_BT_CLIENT;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg client disable Failure");
            }
            else
              TRACE_EVENT("hsg client disable ok");
            break;
          case 8: /* start bluetooth HSG client application function hsg_client_disable() and rvm_stop_application()*/
            service = MFW_BT_HEADSET;
            subtyp = MFW_BT_CLIENT;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg client disable and stop application Failure");
            }
            else
              TRACE_EVENT("hsg client disable and stop application ok");
            break;
          case 9: /* start bluetooth HSG client application function hsg_out_connection_transfer()*/
            service = MFW_BT_HEADSET;
            for(j =0;j<MFW_BT_ADDR_MAX_LEN;j++)
              hsg_address[j] = 0xbb;
            headset_id = MFW_BT_INVALID_HEADSET_ID;
            if(bt_transfer_audio_out(service, headset_id, hsg_address) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:transfer audio out Failure");
            }
            else
              TRACE_EVENT("transfer audio out ok");
            break;
          case 10: /* start bluetooth HSG client application function hsg_in_connection_transfer()*/
            service = MFW_BT_HEADSET;
            if(bt_transfer_audio_in(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:transfer audio in Failure");
            }
            else
              TRACE_EVENT("transfer audio in ok");
            break;
          case 11: /* start bluetooth HSG client application function hsg_save_config()*/
            /* not supported TI 5.3.0 BT */
            service = MFW_BT_HEADSET;
            if(bt_save_config(service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:save hsg config Failure");
            }
            else
              TRACE_EVENT("save hsg config ok");
            break;
          case 12: /* start bluetooth HSG client application function hsg_restore_config()*/
            /* not supported TI 5.3.0 BT */
            service = MFW_BT_HEADSET;
            if(bt_restore_config(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:restore hsg config Failure");
            }
            else
              TRACE_EVENT("restore hsg config ok");
            break;
          case 13: /* start bluetooth HSG client application function hsg_save_default_list()*/
            /*  save in non-volatile memory, not supported TI 5.3.0 BT */
            service = MFW_BT_HEADSET;
            if(bt_save_default_list(service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:save hsg def list Failure");
            }
            else
              TRACE_EVENT("save hsg def list ok");
            break;
          case 14: /* start bluetooth HSG client application function hsg_restore_default_list()*/
            /*  save in non-volatile memory, not supported TI 5.3.0 BT */
            service = MFW_BT_HEADSET;
            if( bt_restore_default_list(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:restore hsg def list Failure");
            }
            else
              TRACE_EVENT("restore hsg def list ok");
            break;
          case 15: /* start bluetooth primitive HSG_DEVICE_CONNECTION_IND */
            bti_conn_ind_hsg();
            break;
          case 16: /* start bluetooth primitive HSG_HEADSET_CONNECTION_CLOSED */
            bti_hsg_disconnect();
            break;
          case 17: /* start bluetooth primitive HSG_CONNECTION_FAILED */
            bti_hsg_connect_failed();
            break;
          case 18: /* start bluetooth primitive HSG_GSM_CONNECTION_IND */
            bti_hsg_gsm_connect_ind();
            break;
        }
        return TRUE;
        case BTP_SRV_HSG_TEST:/* test HSG profile, server and common hsg functions */
        TRACE_EVENT("bta_response_cb:BTP_SRV_HSG_TEST");
        switch(((T_BTP_SRV_HSG_TEST *)data)->func_id)
        {
          case 1: /* start bluetooth HSG server application function hsg_server_enable()*/
            /* receive bluetooth primitive HSG_SERVER_ENABLE_CFM in BTI */
            /* initialize headset server */
            memset(&server_conf, 0, sizeof(server_conf));
            memset(test_mfw_key_list, 0, sizeof(test_mfw_key_list));
            test_mfw_key_list[0] =  0xFE;   /* f.e.KEY_F1 */
            memset(test_mfw_phone_list, 0, sizeof(test_mfw_phone_list));
            for(j=0;j<4;j++)
                        test_mfw_phone_list[1][j] = j | 0x30;
            service = MFW_BT_HEADSET;
            server_conf.serv_con_conf = 0;  /* TI not used */
            server_conf.conn_break = MFW_BT_CONN_SCAN_BREAK_DEFAULT_VALUE;
            server_conf.conn_time = MFW_BT_CONN_SCAN_TIME_DEFAULT_VALUE;
            server_conf.nb_phone = 1;/* currently only one number from remote headset is supported */
            memcpy(server_conf.mfw_phone_list, test_mfw_phone_list, sizeof(test_mfw_phone_list));
            memcpy(server_conf.mfw_key_list, test_mfw_key_list, sizeof(test_mfw_key_list));
            if(bt_init_profile_hsg_serv(service, server_conf) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg server initialize Failure");
            }
            else
              TRACE_EVENT("hsg server initialize ok");
            break;
          case 2: /* start bluetooth HSG server application function hsg_server_enable()*/
            /* receive bluetooth primitive HSG_SERVER_ENABLE_CFM in BTI */
            /* reconfigure headset server */
            memset(&server_conf, 0, sizeof(server_conf));
            memset(test_mfw_key_list, 0, sizeof(test_mfw_key_list));
            test_mfw_key_list[0] =  0xFE;   /* f.e. KEY_F1 */
            memset(test_mfw_phone_list, 0, sizeof(test_mfw_phone_list));
            for(j=0;j<4;j++)
                        test_mfw_phone_list[1][j] = j | 0x30;
            service = MFW_BT_HEADSET;
            server_conf.serv_con_conf = 0;  /* TI not used */
            server_conf.conn_break = MFW_BT_CONN_SCAN_BREAK_DEFAULT_VALUE;
            server_conf.conn_time = MFW_BT_CONN_SCAN_TIME_DEFAULT_VALUE;
            server_conf.nb_phone = 1;/* currently only one number from remote headset is supported */
            memcpy(server_conf.mfw_phone_list, test_mfw_phone_list, sizeof(test_mfw_phone_list));
            memcpy(server_conf.mfw_key_list, test_mfw_key_list, sizeof(test_mfw_key_list));
            if(bt_reconfig_profile_hsg_serv(service, server_conf) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg server reconfigure Failure");
            }
            else
              TRACE_EVENT("hsg server reconfigure ok");
            break;
          case 3: /* start bluetooth function hsg_server_disable() */
            /* receive bluetooth primitive HSG_SERVER_ENABLE_CFM in BTI */
            service = MFW_BT_HEADSET;
            subtyp = MFW_BT_SERVER;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg server disable Failure");
            }
            else
              TRACE_EVENT("hsg server disable ok");
            break;
          case 4: /* start bluetooth HSG client application function hsg_server_disable() and rvm_stop_application()*/
            service = MFW_BT_HEADSET;
            subtyp = MFW_BT_SERVER;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:hsg server disable and stop application Failure");
            }
            else
              TRACE_EVENT("hsg server disable and stop application ok");
            break;
          case 5: /* start bluetooth HSG client application function hsg_add_default_headset()*/
            memset(&hsg_name, 0, sizeof(hsg_name));
            service = MFW_BT_HEADSET;
            for(j =0;j<MFW_BT_ADDR_MAX_LEN;j++)
              hsg_address[j] = 0xbb;/* address of new add headset */
            strcpy(hsg_name, hsg_default_name);/* name of new add headset */
            priority = 2;/* desired priority of new add headset in list */
            rem_audio_ctr_supp_hsg = TRUE;/* headset supports remote audio control */
            if(bt_set_pref_headset(service, hsg_address, hsg_name, priority, rem_audio_ctr_supp_hsg, &headset_cnf_id) NEQ MFW_BT_OK)
            /* get id in default headset list */
            {
              TRACE_EVENT("mfw_bta:hsg add default headset Failure");
            }
            else
              TRACE_EVENT_P1("add hsg: id = %d", headset_cnf_id);
            break;
          case 6: /* start bluetooth function bmi_service_browse() for headset */
            service = MFW_BT_HEADSET;
            if(bt_service_search(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:headset search Failure");
            }
            else
              TRACE_EVENT("headset search ok");
            break;
          case 7: /* start bluetooth function hsg_remove_default_headset() */
            headset_id = 1;
            service = MFW_BT_HEADSET;
            if(bt_reset_pref_hsg(service, headset_id) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:remove headset Failure");
            }
            else
              TRACE_EVENT("remove headset ok");
            break;
          case 8: /* start bluetooth function hsg_get_default_headset_info() */
            memset(&hs_info, 0, sizeof(hs_info));
            headset_id  = 3;
            service = MFW_BT_HEADSET;
            if(bt_get_default_service_info(service, headset_id, &hs_info) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:get headset info Failure");
            }
            else
              TRACE_EVENT_P4("hsg info: %d %d %s %s", hs_info.priority, hs_info.mfw_remote_audio_control_support, hs_info.hsg_name, hs_info.bd_addr);
            break;
          case 9: /* start bluetooth function hsg_change_default_headset_info() */
            service = MFW_BT_HEADSET;
            headset_id = 3;
            priority = 4;
            if(bt_set_prio_default_service(service, headset_id, priority) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:change headset info Failure");
            }
            else
              TRACE_EVENT("change headset info ok");
            break;
          case 10: /* start bluetooth function hsg_connect() */
            service = MFW_BT_HEADSET;
            for(j =0;j<MFW_BT_ADDR_MAX_LEN;j++)
              hsg_address[j] = 0xbb;
            headset_id = MFW_BT_INVALID_HEADSET_ID;
            if(bt_connect_hsg(service, headset_id, hsg_address, 0) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:connect headset Failure");
            }
            else
              TRACE_EVENT("connect headset ok");
            break;
          case 11: /* start bluetooth function hsg_disconnect() */
            service = MFW_BT_HEADSET;
            if(bt_disconnect_service(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:disconnect headset Failure");
            }
            else
              TRACE_EVENT("disconnect headset ok");
            break;
          case 12: /* start bluetooth function hsg_update_params() */
            service = MFW_BT_HEADSET;
            nb = MFW_BT_SPEAKER_GAIN;/* MFW_BT_MIC_GAIN */
            type = MFW_BT_PARA_INC; /* MFW_BT_PARA_SET */
            new_value = 0;
            if(bt_set_param_headset(service, nb, type, new_value) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set params headset Failure");
            }
            else
              TRACE_EVENT("set params headset ok");
            break;
          case 13: /* start mfw function bt_clear_list_found_serv() of found hsg */
            service = MFW_BT_HEADSET;
            if(bt_clear_list_found_serv(service) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:hsg list del Failure");
            }
            else
              TRACE_EVENT("hsg list del ok");
            break;
          case 14: /* start bluetooth primitive HSG_DEVICE_CONNECTION_PERFORMED */
            bti_hsg_dev_connect_inf();
            break;
          case 15: /* start mfw function hsg_is_default_headset()*/
            service = MFW_BT_HEADSET;
            for(j =0;j<MFW_BT_ADDR_MAX_LEN;j++)
              hsg_address[j] = 0xbb;
            if(bt_is_pref_headset(service, hsg_address, &headset_cnf_id) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:hsg list del Failure");
            }
            else
            {
              if(headset_cnf_id EQ MFW_BT_INVALID_HEADSET_ID)
              {
                TRACE_EVENT("hsg not in default list");
              }
              else
              {
                TRACE_EVENT_P1("hsg id in default list:%d", headset_cnf_id);
              }
            }
            break;
        }
        return TRUE;
        case BTP_FAX_TEST:/* test FAX profile */
        TRACE_EVENT("bta_response_cb:BTP_FAX_TEST");
        switch(((T_BTP_FAX_TEST *)data)->func_id)
        {
            case 1:/*start bluetooth function fax_gw_config()*/
            service = MFW_BT_FAX_GW;
            fax_filter.link_event = MFW_BT_LINK_MONIT_ON;
            fax_filter.call_event = MFW_BT_CALL_MONIT_ON;
            if(bt_init_profile_fax(service, fax_filter) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:init fax Failure");
            }
            else
              TRACE_EVENT("init fax ok");
            break;
          case 2: /* start bluetooth fax application function
             rvm_start_application(), fax_gw_enable(), fax_gw_config() */
            /* receive bluetooth primitive FAX_GW_STATUS_CFM in BTI */
            service = MFW_BT_FAX_GW;
            if(bt_start_profile_application((T_BTI_DEVICE_TYPE)service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:fax server start and enable Failure");
            }
            else
              TRACE_EVENT("fax start and enable ok");
            break;
          case 3:/* start bluetooth function fax_gw_config()*/
            service = MFW_BT_FAX_GW;
            fax_filter.link_event = MFW_BT_LINK_MONIT_OFF;
            fax_filter.call_event = MFW_BT_CALL_MONIT_OFF;
            if(bt_reconfig_profile_fax(service, fax_filter) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:reconfig fax Failure");
            }
            else
              TRACE_EVENT("reconfig fax ok");
            break;
          case 4: /* start bluetooth FAX application function fax_gw_disable() and rvm_stop_application()*/
            service = MFW_BT_FAX_GW;
            subtyp = MFW_BT_NO_SUBTYPE;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:fax disable and stop application Failure");
            }
            else
              TRACE_EVENT("fax disable and stop application ok");
            break;
          case 5: /* start bluetooth function fax_gw_disable() */
            service = MFW_BT_FAX_GW;
            subtyp = MFW_BT_NO_SUBTYPE;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:deinit fax Failure");
            }
            else
              TRACE_EVENT("deinit fax ok");
            break;
          case 6: /* start bluetooth function bmi_service_browse() for FAX */
            service = MFW_BT_FAX_GW;
            if(bt_service_search(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:search fax Failure");
            }
            else
              TRACE_EVENT("search fax ok");
            break;
          case 7: /* start bluetooth function bmi_service_browse() for FAX and delete list of found fax*/
            service = MFW_BT_FAX_GW;
            if(bt_clear_list_found_serv(service) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:search/delete fax Failure");
            }
            else
              TRACE_EVENT("search/delete fax ok");
            break;
          case 8: /* start bluetooth function fax_gw_hangup() */
            service = MFW_BT_FAX_GW;
            if(bt_disconnect_service(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:disconn req fax Failure");
            }
            else
              TRACE_EVENT("disconn req fax ok");
            break;
          case 9: /* start bluetooth primitive FAX_GW_LINK_MONITORING:FAX_GW_CONNECTED */
            bti_conn_ind_fax();
            break;
          case 10: /* start bluetooth primitive FAX_GW_LINK_MONITORING:FAX_GW_NOT_CONNECTED */
            bti_fax_disconnect();
            break;
          case 11: /* start bluetooth primitive FAX_GW_CALL_MONITORING:FAX_GW_CALL_IN_PROGRESS */
            bti_fax_call_mon();
            break;
        }
        return TRUE;
        case BTP_DUN_TEST:/* test DUN profile */
        TRACE_EVENT("bta_response_cb:BTP_DUN_TEST");
        switch(((T_BTP_DUN_TEST *)data)->func_id)
        {
          case 1: /* start bluetooth function dun_gw_config() */
            service = MFW_BT_DIAL_UP;
            dun_filter.link_event = MFW_BT_LINK_MONIT_ON;
            dun_filter.call_event = MFW_BT_CALL_MONIT_ON;
            if(bt_init_profile_dun(service, dun_filter) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:init dun Failure");
            }
            else
              TRACE_EVENT("init dun ok");
            break;
          case 2: /* start bluetooth dial up application function
             rvm_start_application(), dun_gw_enable(), dun_gw_config() */
            /* receive bluetooth primitive DUN_GW_STATUS_CFM in BTI */
            service = MFW_BT_DIAL_UP;
            if(bt_start_profile_application((T_BTI_DEVICE_TYPE)service) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:dun server start and enable Failure");
            }
            else
              TRACE_EVENT("dun start and enable ok");
            break;
          case 3: /* start bluetooth function dun_gw_config() */
            service = MFW_BT_DIAL_UP;
            dun_filter.link_event = MFW_BT_LINK_MONIT_ON;
            dun_filter.call_event = MFW_BT_CALL_MONIT_ON;
            if(bt_reconfig_profile_dun(service, dun_filter) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:reconf dun Failure");
            }
            else
              TRACE_EVENT("reconf dun ok");
            break;
          case 4: /* start bluetooth function dun_gw_disable() */
            service = MFW_BT_DIAL_UP;
            subtyp = MFW_BT_NO_SUBTYPE;
            if(bt_deinit_profile(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:deinit dun Failure");
            }
            else
              TRACE_EVENT("deinit dun ok");
            break;
          case 5: /* start bluetooth DUN application function dun_gw_disable() and rvm_stop_application()*/
            service = MFW_BT_DIAL_UP;
            subtyp = MFW_BT_NO_SUBTYPE;
            if(bt_stop_profile_application(service, subtyp) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:stop dun Failure");
            }
            else
              TRACE_EVENT("stop dun ok");
            break;
          case 6: /* start bluetooth function bmi_service_browse() for DUN */
            service = MFW_BT_DIAL_UP;
              if(bt_service_search(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:search dun Failure");
            }
            else
              TRACE_EVENT("search dun ok");
            break;
          case 7: /* start bluetooth function bmi_service_browse() for DUN and delete list of found dun*/
            service = MFW_BT_DIAL_UP;
            if(bt_clear_list_found_serv(service) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:search/delete dun Failure");
            }
            else
              TRACE_EVENT("search/delete dun ok");
            break;
          case 8: /* start bluetooth function dun_gw_hangup() */
            service = MFW_BT_DIAL_UP;
            if(bt_disconnect_service(service) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:disconn req dun Failure");
            }
            else
              TRACE_EVENT("disconn req dun ok");
            break;
          case 9: /* start bluetooth primitive DUN_GW_LINK_MONITORING:DUN_GW_NOT_CONNECTED */
            bti_dun_disconnect();
            break;
          case 10: /* start bluetooth primitive DUN_GW_LINK_MONITORING:DUN_GW_CONNECTED */
            bti_conn_ind_dun();
            break;
          case 11: /* start bluetooth primitive DUN_GW_CALL_MONITORING:DUN_GW_CALL_IN_PROGRESS ... */
            bti_dun_call_mon();
            break;
        }
        return TRUE;
        case BTP_SEC_BROWS_TEST:/* test browsing and security bluetooth function  */
        TRACE_EVENT("bta_response_cb:BTP_SEC_BROWS_TEST");
        switch(((T_BTP_SEC_BROWS_TEST *)data)->func_id)
        {
          case 1:/* register in security managment of bluetooth */
            if(bt_register_sm() NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:SCM register Failure");
            }
            else
              TRACE_EVENT("SCM register ok");
            break;
          case 2:/* set general security mode of bluetooth device with default value */
            if(bt_set_security_mode(MFW_BT_SECURITY_MODE_2) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:SCM sec mode Failure");
            }
            else
              TRACE_EVENT("SCM sec mode ok");
            break;
          case 3:/*  set bluetooth device in pairable mode */
            if(bt_set_pair_mode (MFW_BT_PAIRABLE) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:SCM pair mode Failure");
            }
            else
              TRACE_EVENT("SCM pair mode ok");
            break;
          case 4:/*  search bluetooth devices with their services */
            if(bt_device_search() NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:search devices Failure");
            }
            else
              TRACE_EVENT("search devices ok");
            break;
          case 5:/*  terminate browsing procedure */
            if(bt_search_abort() NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:search abort Failure");
            }
            else
              TRACE_EVENT("search abort ok");
            break;
          case 6: /* start bluetooth primitive SCM_PIN_CODE_REQUEST */
            bti_send_pin_request();
            break;
          case 7: /* start bluetooth function scm_pin_code_reply() */
            memset(&hsg_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            memset(&pin_code, 0x35, MFW_BT_PIN_MAX_LEN);
            pin_mode = PIN_PROVIDED;
            result_bt = bt_send_pin(hsg_address, pin_code, pin_mode);
            if(result_bt EQ MFW_BT_INVALID_PARA)
            {
              TRACE_EVENT("mfw_bta:Wrong Pin");
            }
            else if(result_bt NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:pin Failure");
            }
            else
              TRACE_EVENT("pin ok");
            break;
          case 8: /* start bluetooth primitive SCM_DEVICE_PAIRED_RESULT */
            bti_pin_code_cnf();
            break;
          case 9: /* start bluetooth function scm_get_next_authorized_device() for sync */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            auth_mask = MFW_SERVICE_SYNC_C;
            if(bt_authorized_devices(&authorized_devices_list, auth_mask) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P3("auth sync:%d %x %s", authorized_devices_list.count, authorized_devices_list.auth_devices[1].mask_authorization, authorized_devices_list.auth_devices[1].remote_bd_addr);
            break;
          case 10: /* start bluetooth function scm_get_next_authorized_device() for opp */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            auth_mask = MFW_SERVICE_OPP;
            if(bt_authorized_devices(&authorized_devices_list, auth_mask) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P3("auth opp:%d %x %s", authorized_devices_list.count, authorized_devices_list.auth_devices[1].mask_authorization, authorized_devices_list.auth_devices[1].remote_bd_addr);
            break;
          case 11: /* start bluetooth function scm_get_next_authorized_device() for fax */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            auth_mask = MFW_SERVICE_FAX;
            if(bt_authorized_devices(&authorized_devices_list, auth_mask) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P3("auth fax:%d %x %s", authorized_devices_list.count, authorized_devices_list.auth_devices[1].mask_authorization, authorized_devices_list.auth_devices[1].remote_bd_addr);
            break;
          case 12: /* start bluetooth function scm_get_next_authorized_device() for hsg */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            auth_mask = MFW_SERVICE_HSG;
            if(bt_authorized_devices(&authorized_devices_list, auth_mask) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P3("auth hsg:%d %x %s", authorized_devices_list.count, authorized_devices_list.auth_devices[1].mask_authorization, authorized_devices_list.auth_devices[1].remote_bd_addr);
            break;
          case 13: /* start bluetooth function scm_get_next_authorized_device() for dun */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            auth_mask = MFW_SERVICE_DUN;
            if(bt_authorized_devices(&authorized_devices_list, auth_mask) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P3("auth dun:%d %x %s", authorized_devices_list.count, authorized_devices_list.auth_devices[1].mask_authorization, authorized_devices_list.auth_devices[1].remote_bd_addr);
            break;
          case 14: /* start bluetooth function scm_get_next_authorized_device() for all existing services */
            memset(&authorized_devices_list, 0, sizeof(authorized_devices_list));
            if(bt_list_auth_dev(&authorized_devices_list) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:auth list Failure");
            }
            else
              TRACE_EVENT_P1("auth list:%d", authorized_devices_list.count);
            break;
          case 15: /* start bluetooth function scm_set_device_authorization() for sync */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_SYNC_C;
            if(bt_del_authorization(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del auth Failure");
            }
            else
              TRACE_EVENT("del auth ok");
            break;
          case 16: /* start bluetooth function scm_set_device_authorization() for dun */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_DUN;
            if(bt_del_authorization(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del auth Failure");
            }
            else
              TRACE_EVENT("del auth ok");
            break;
          case 17: /* start bluetooth function scm_set_device_authorization() for fax */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_FAX;
            if(bt_del_authorization(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del auth Failure");
            }
            else
              TRACE_EVENT("del auth ok");
            break;
          case 18: /* start bluetooth function scm_set_device_authorization() for opp */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_OPP;
            if(bt_del_authorization(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del auth Failure");
            }
            else
              TRACE_EVENT("del auth ok");
            break;
          case 19: /* start bluetooth function scm_set_device_authorization() for hsg */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_HSG;
            if(bt_del_authorization(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del auth Failure");
            }
            else
              TRACE_EVENT("del auth ok");
            break;
          case 20: /* start bluetooth function scm_set_device_authorization() for hsg */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            if(bt_del_authorizations_device(remote_address) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:del authorization device Failure");
            }
            else
              TRACE_EVENT("del authorization device auth ok");
            break;
          case 21: /* start bluetooth function scm_set_security_mode() */
            sec_mode = MFW_BT_SECURITY_MODE_3;
            if(bt_set_security_mode(sec_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set common security level Failure");
            }
            else
              TRACE_EVENT("set common security level ok");
            break;
          case 22: /* start bluetooth function scm_set_default_security_requirements() */
            default_security = MFW_BT_INCOM_AUTHENTICATION | MFW_BT_INCOM_AUTHORIZATION |MFW_BT_OUTGO_ENCRYPTION;
            if(bt_set_default_security(default_security) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set default security values Failure");
            }
            else
              TRACE_EVENT("set default security values ok");
            break;
          case 23:/* deregister in security managment of bluetooth */
            if(bt_deregister_sm() NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:SCM deregister Failure");
            }
            else
              TRACE_EVENT("SCM deregister ok");
            break;
        }
        return TRUE;
        case BTP_OTHER_TEST:/* test common bluetooth function (lists) */
        TRACE_EVENT("bta_response_cb:BTP_OTHER_TEST");
        switch(((T_BTP_OTHER_TEST *)data)->func_id)
        {
          case 1:/*  delete list of found bluetooth devices */
            if(bt_clear_list_found_dev() NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:clear device list Failure");
            }
            else
              TRACE_EVENT("clear device list ok");
            break;
          case 2:/*  delete lists of found bluetooth services */
            if(bt_clear_all_lists_found_serv() NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:clear service lists Failure");
            }
            else
              TRACE_EVENT("clear service lists ok");
            break;
          case 3:/* start bluetooth function scm_set_pairable_mode() */
            pair_mode = MFW_BT_PAIRABLE;
            if(bt_set_pair_mode(pair_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set pair mode Failure");
            }
            else
              TRACE_EVENT("set pair mode on ok");
            break;
          case 4:/* start bluetooth function scm_set_pairable_mode() */
            pair_mode = MFW_BT_NON_PAIRABLE;
            if(bt_set_pair_mode(pair_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set pair mode Failure");
            }
            else
              TRACE_EVENT("set pair mode off ok");
            break;
          case 5:/* start bluetooth function scm_start_pairing() */
            memset(&hsg_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            memset(&pin_code, 0x35, MFW_BT_PIN_MAX_LEN);
            pin_mode = PIN_PROVIDED;
            if(bt_start_pairing(hsg_address, pin_code, pin_mode) NEQ MFW_BT_EXECUTE)
            {
              TRACE_EVENT("mfw_bta:start pairing mode Failure");
            }
            else
              TRACE_EVENT("start pairing ok");
            break;
          case 6: /* start bluetooth primitive SCM_DEVICE_PAIRED_RESULT */
            bti_pairing_cnf();
            break;
          case 7:/* start bluetooth function scm_is_device_paired() */
            memset(&hsg_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            if(bt_check_pair(hsg_address) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:check pairing Failure");
            }
            else
              TRACE_EVENT("check pairing ok");
            break;
          case 8:/* start bluetooth function scm_get_next_paired_device() */
            memset(&pairing_list, 0, sizeof(T_MFW_BT_DEV_PAIR_LIST));
           if(bt_list_paired_dev(&pairing_list) NEQ MFW_BT_RET_OK)
            {
              TRACE_EVENT("mfw_bta:pairing list Failure");
            }
            else
              TRACE_EVENT("pairing list ok");
            break;
          case 9:/* start bluetooth function scm_delete_paired_device() */
            memset(&hsg_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            if(bt_delete_paired_device(hsg_address) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:delete paired device Failure");
            }
            else
              TRACE_EVENT("delete paired devicet ok");
            break;
          case 10: /* start bluetooth primitive SCM_AUTHORIZATION_REQUEST for profile sync */
            bti_send_sync_authorization_request();
            break;
          case 11: /* start bluetooth primitive SCM_AUTHORIZATION_REQUEST for profile hsg */
            bti_send_hsg_authorization_request();
            break;
          case 12: /* start bluetooth primitive SCM_AUTHORIZATION_REQUEST for profile fsx */
            bti_send_fax_authorization_request();
            break;
          case 13: /* start bluetooth primitive SCM_AUTHORIZATION_REQUEST for profile dun */
            bti_send_dun_authorization_request();
            break;
          case 14: /* start bluetooth primitive SCM_AUTHORIZATION_REQUEST for profile opp */
            bti_send_opp_authorization_request();
            break;
          case 15: /* start bluetooth function scm_authorization_reply() for sync */
            auth_mode = MFW_BT_AUTHORIZED_ONCE;
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_SYNC_C;
            if(bt_authorization_reply(remote_address, auth_mask, auth_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:auth reply sync Failure");
            }
            else
              TRACE_EVENT("auth reply sync ok");
            break;
          case 16: /* start bluetooth function scm_authorization_reply() for hsg */
            auth_mode = MFW_BT_AUTHORIZED_ONCE;
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_HSG;
            if(bt_authorization_reply(remote_address, auth_mask, auth_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:auth reply hsg Failure");
            }
            else
              TRACE_EVENT("auth reply hsg ok");
            break;
          case 17: /* start bluetooth function scm_authorization_reply() for dun */
            auth_mode = MFW_BT_AUTHORIZED_ONCE;
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_DUN;
            if(bt_authorization_reply(remote_address, auth_mask, auth_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:auth reply dun Failure");
            }
            else
              TRACE_EVENT("auth reply dun ok");
            break;
          case 18: /* start bluetooth function scm_authorization_reply() for fax */
            auth_mode = MFW_BT_AUTHORIZED_ONCE;
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_FAX;
            if(bt_authorization_reply(remote_address, auth_mask, auth_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:auth reply fax Failure");
            }
            else
              TRACE_EVENT("auth reply fax ok");
            break;
          case 19: /* start bluetooth function scm_authorization_reply() for opp */
            auth_mode = MFW_BT_AUTHORIZED_ONCE;
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_OPP;
            if(bt_authorization_reply(remote_address, auth_mask, auth_mode) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:auth reply opp Failure");
            }
            else
              TRACE_EVENT("auth reply opp ok");
            break;
          case 20: /* start bluetooth function scm_get_device_authorization() */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            if(bt_get_authorization_device(remote_address, &auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:get device authorizations Failure");
            }
            else
            {
              TRACE_EVENT_P1("get authorizations:%x", auth_mask);
            }
            break;
          case 21: /* start bluetooth function scm_set_device_authorization() for fax */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_FAX;
            if(bt_set_authorization_device(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set device authorization Failure");
            }
            else
              TRACE_EVENT("set authorization ok");
            break;
          case 22: /* start bluetooth function scm_set_device_authorization() for dun */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_DUN;
            if(bt_set_authorization_device(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set device authorization Failure");
            }
            else
              TRACE_EVENT("set authorization ok");
            break;
          case 23: /* start bluetooth function scm_set_device_authorization() for hsg */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_HSG;
            if(bt_set_authorization_device(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set device authorization Failure");
            }
            else
              TRACE_EVENT("set authorization ok");
            break;
          case 24: /* start bluetooth function scm_set_device_authorization() for opp */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_OPP;
            if(bt_set_authorization_device(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set device authorization Failure");
            }
            else
              TRACE_EVENT("set authorization ok");
            break;
          case 25: /* start bluetooth function scm_set_device_authorization() for sync */
            memset(&remote_address, 0xcc, MFW_BT_ADDR_MAX_LEN);
            auth_mask = MFW_SERVICE_SYNC_C;
            if(bt_set_authorization_device(remote_address, auth_mask) NEQ MFW_BT_OK)
            {
              TRACE_EVENT("mfw_bta:set device authorization Failure");
            }
            else
              TRACE_EVENT("set authorization ok");
            break;
        }
        return TRUE;

/* end for test bluetooth without BMI/MMI ******************************************/
    }
#endif

  return FALSE;       /* not processed by extension */
}

