/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt_op.h				$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 17.04.04				     $Modtime:: 17.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth Object Push Profile

*/

#ifndef DEF_MFW_BT_OP_HEADER
#define DEF_MFW_BT_OP_HEADER

#include "bta_op_api.h"
#include "mfw_bte.h"

/*
** The following Macros define the Object Push Signals (BT -> Mfw)
*/
#define T_MFW_BT_OPC_EVT				tBTA_OPC_EVT
#define T_MFW_BT_OPC_SIG_DATA		tBTA_OPC

#define T_MFW_BT_OPS_EVT				tBTA_OPS_EVT
#define T_MFW_BT_OPS_SIG_DATA		tBTA_OPS

/*
** Event Identifiers (Mfw -> BMI)
*/


/*
** Event Parameter Structure Definitions
*/

typedef struct {
	UINT32 dummy;
}T_MFW_BT_OP_DUMMY_SIG;

/*
** Bluetooth Object Push Profile Prototypes
*/
void	mfw_bt_opc_cb(T_MFW_BT_OPC_EVT event, T_MFW_BT_OPC_SIG_DATA *data);
void	mfw_bt_ops_cb(T_MFW_BT_OPS_EVT event, T_MFW_BT_OPS_SIG_DATA *data);

T_MFW_BT_STATUS mfw_bt_opc_hndlr (T_MFW_BT_OPC_EVT event, T_MFW_BT_OPC_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_ops_hndlr (T_MFW_BT_OPS_EVT event, T_MFW_BT_OPS_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_op_init( void );

#endif

