/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)		$Workfile:: mfw_bt_op.c			$|
| $Author:: NDH						$Revision::  1						$|
| CREATED: 22.04.04					$Modtime:: 22.04.04 11:16			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT_OP

   PURPOSE : This module contains the functions for MFW Bluetooth Object Push Profile


*/

#define ENTITY_MFW

#include <string.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "bta_riviera.h"

#include "mfw_bte.h"
#include "mfw_bt_op.h"
#include "mfw_bt_geh.h"


/*******************************************************************************

 $Function:		mfw_bt_op_init

 $Description:		Start the OPP subsystem.

 $Returns:		T_MFW_BT_STATUS

 $Arguments:		none

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_op_init( void )
{
		MFW_BT_TRACE("mfw_bt_op_init: starting the OPP BT subsystem.");
		return MFW_BT_SUCCESS;
}


/*
** MFW Bluetooth Object Push Callback Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_opc_cb

 $Description:		This is the Object Push Client Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA OPC Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
void	mfw_bt_opc_cb(T_MFW_BT_OPC_EVT event, T_MFW_BT_OPC_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_opc_cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_OPC_ENABLE_EVT:
		case BTA_OPC_OPEN_EVT:
			dataLen = 0;
			break;

#if 0
		case BTA_OPC_PROGRESS_EVT:
			dataLen = sizeof(tBTA_OPC_PROGRESS);	/* This structure is in the BTA interface document, but not in the header files!!! */
			break;
#endif

		case BTA_OPC_OBJECT_EVT:
			dataLen = sizeof(tBTA_OPC_OBJECT);
			break;

		case BTA_OPC_CLOSE_EVT:
			dataLen = sizeof(tBTA_OPC_STATUS);
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_opc_cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_opc_cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_OPC, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_OPC, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_opc_cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}

/*******************************************************************************

 $Function:		mfw_bt_ops_cb

 $Description:		This is the Object Push Server Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA OPS Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
void	mfw_bt_ops_cb(T_MFW_BT_OPS_EVT event, T_MFW_BT_OPS_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_ops_cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_OPS_ENABLE_EVT:
		case BTA_OPS_OPEN_EVT:
		case BTA_OPS_CLOSE_EVT:
			dataLen = 0;
			break;

#if 0
		case BTA_OPS_PROGRESS_EVT:
			dataLen = sizeof(tBTA_OPS_PROGRESS);	/* This structure is in the BTA interface document, but not in the header files!!! */
			break;
#endif

		case BTA_OPS_OBJECT_EVT:
			dataLen = sizeof(tBTA_OPS_OBJECT);
			break;

#if 0	/* This event is in the BTA interface document, but not in the header files!!! */
		case BTA_OPS_ACCESS_EVT:
			dataLen = sizeof(tBTA_OPS_ACCESS);	/* This structure is in the BTA interface document, but not in the header files!!! */
			break;
#endif

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_ops_cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_ops_cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_OPS, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_OPS, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_ops_cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}


/*
** MFW Bluetooth Object Push Signal Handler Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_opc_hndlr

 $Description:		This function recieves the BTA Object Push Client events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_opc_hndlr (T_MFW_BT_OPC_EVT event, T_MFW_BT_OPC_SIG_DATA *data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_opc_hndlr");

	switch (event)
	{
		case BTA_OPC_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_opc_hndlr > BTA_OPC_ENABLE_EVT event received");
			break;

		case BTA_OPC_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_opc_hndlr > BTA_OPC_OPEN_EVT event received");
			break;

		case BTA_OPC_PROGRESS_EVT:
			MFW_BT_TRACE("mfw_bt_opc_hndlr > BTA_OPC_PROGRESS_EVT event received");
			break;

		case BTA_OPC_OBJECT_EVT:
			MFW_BT_TRACE("mfw_bt_opc_hndlr > BTA_OPC_OBJECT_EVT event received");
			break;

		case BTA_OPC_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_opc_hndlr > BTA_OPC_CLOSE_EVT event received");
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_opc_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
	}

	return retVal;
}

/*******************************************************************************

 $Function:		mfw_bt_ops_hndlr

 $Description:		This function recieves the BTA Object Push Server events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_ops_hndlr (T_MFW_BT_OPS_EVT event, T_MFW_BT_OPS_SIG_DATA *data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_ops_hndlr");

	switch (event)
	{
		case BTA_OPS_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr > BTA_OPS_ENABLE_EVT event received");
			break;

		case BTA_OPS_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr > BTA_OPS_OPEN_EVT event received");
			break;

		case BTA_OPS_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr > BTA_OPS_CLOSE_EVT event received");
			break;

		case BTA_OPS_PROGRESS_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr > BTA_OPS_PROGRESS_EVT event received");
			break;

		case BTA_OPS_OBJECT_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr > BTA_OPS_OBJECT_EVT event received");
			break;

#if 0	/* This event is in the BTA interface document, but not in the header files!!! */
		case BTA_OPS_ACCESS_EVT:
			MFW_BT_TRACE("mfw_bt_ops_hndlr >  event received");
			break;
#endif

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_ops_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
	}

	return retVal;
}

