/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt_geh.h			$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 22.04.04				     $Modtime:: 22.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth File Transfer Profile

*/

#ifndef DEF_MFW_BT_GEH_HEADER
#define DEF_MFW_BT_GEH_HEADER

#include "mfw_bte.h"


/*
** The signals processed by the Bluetooth Event Handler are defined by the individual profiles, which it serves.
*/
typedef union {
	T_MFW_BT_DM_SEC_SIG_DATA	dmSecSignals;
	T_MFW_BT_DM_SRCH_SIG_DATA dmSrchSignals;
	T_MFW_BT_DG_SIG_DATA dgSignals;
	T_MFW_BT_AG_SIG_DATA agSignals;
	T_MFW_BT_OPC_SIG_DATA opcSignals;
	T_MFW_BT_OPS_SIG_DATA opsSignals;
	T_MFW_BT_FTC_SIG_DATA ftcSignals;
	T_MFW_BT_FTS_SIG_DATA ftsSignals;
} T_MFW_BT_SIG_DATA;


/*
** The events stored in the Event Buffer contain an EventId, Originator and the original Signal Data.
*/
typedef struct {
	ULONG event;				/* Combination of Event Id and Originator */
	T_MFW_BT_SIG_DATA data;
} T_MFW_BT_SIGNALS;


/*
** BT Originators, used to identify the originating profile of each event
*/
typedef enum {
	MFW_BT_DM_SECURITY	= 0x10000,
	MFW_BT_DM_SEARCH		= 0x20000,
	MFW_BT_DG				= 0X30000,
	MFW_BT_AG				= 0X40000,
	MFW_BT_OPC			= 0X50000,
	MFW_BT_OPS			= 0X60000,
	MFW_BT_FTC			= 0X70000,
	MFW_BT_FTS			= 0X80000,

	MFW_BT_MAX_ORIGINATOR		/* This should ALWAYS be the final entry */
}T_MFW_BT_ORIGINATORS;


/*
** MFW_BT_MAX_SIG_Q_ENTRIES macro defines the maximum size of the circular buffer in terms of the number of signals which
** can be stored in it.	*** NOTE : This should be an even number, as the size will be halved if the buffer cannot be created. ***
*/
#define MFW_BT_MAX_SIG_Q_ENTRIES 20


/*
** The Bluetooth Event handler, in the GPF context, on receipt of the MMI_BT_CB_NOTIFY_IND primitive, will handle up to a maximum
** of MFW_BT_MAX_CONSEC_SIG_PROC consecutive events before reposting the MMI_BT_CB_NOTIFY_IND primitive and relinquishing
** control.
*/
#define MFW_BT_MAX_CONSEC_SIG_PROC 4


/*
** Generic Bluetooth Event Handler Prototypes
*/
T_MFW_BT_STATUS mfw_bt_ge_enable (void);

void mfw_bt_ge_disable (void);

T_MFW_BT_STATUS mfw_bt_ge_post_event (T_MFW_BT_ORIGINATORS originator,
											 ULONG eventId,
											 void *data,
											 int dataLen);

void mfw_bt_cb_notify_rxd (void);

#endif

