/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt_ft.h				$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 17.04.04				     $Modtime:: 17.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth File Transfer Profile

*/

#ifndef DEF_MFW_BT_FT_HEADER
#define DEF_MFW_BT_FT_HEADER

#include "bta_ft_api.h"
#include "mfw_bte.h"

/*
** The following Macros define the File Transfer Signals (BT -> Mfw)
*/
#define T_MFW_BT_FTC_EVT				tBTA_FTC_EVT
#define T_MFW_BT_FTC_SIG_DATA		tBTA_FTC

#define T_MFW_BT_FTS_EVT				tBTA_FTS_EVT
#define T_MFW_BT_FTS_SIG_DATA		tBTA_FTS

/*
** Event Identifiers (Mfw -> BMI)
*/


/*
** Event Parameter Structure Definitions
*/

typedef struct {
	UINT32 dummy;
}T_MFW_BT_FT_DUMMY_SIG;

/*
** Bluetooth File Transfer Profile Prototypes
*/
void	mfw_bt_ftc_cb(T_MFW_BT_FTC_EVT event, T_MFW_BT_FTC_SIG_DATA *data);
void	mfw_bt_fts_cb(T_MFW_BT_FTS_EVT event, T_MFW_BT_FTS_SIG_DATA *data);

T_MFW_BT_STATUS mfw_bt_ftc_hndlr (T_MFW_BT_FTC_EVT event, T_MFW_BT_FTC_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_fts_hndlr (T_MFW_BT_FTS_EVT event, T_MFW_BT_FTS_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_ft_init( void );



#endif


