/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)		$Workfile:: mfw_bt_ft.c				$|
| $Author:: NDH						$Revision::  1						$|
| CREATED: 22.04.04					$Modtime:: 22.04.04 11:17			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT_FT

   PURPOSE : This module contains the functions for MFW Bluetooth File Transfer Profile


*/

#define ENTITY_MFW

#include <string.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "bta_riviera.h"

#include "mfw_bte.h"
#include "mfw_bt_ft.h"
#include "mfw_bt_geh.h"



/*******************************************************************************

 $Function:		mfw_bt_ft_init

 $Description:		Start the FTP subsystem.

 $Returns:		T_MFW_BT_STATUS

 $Arguments:		none

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_ft_init( void )
{
		MFW_BT_TRACE("mfw_bt_ft_init: starting the FTP BT subsystem.");
		return MFW_BT_SUCCESS;
}


/*
** MFW Bluetooth File Transfer Callback Function Definitions
*/
/*******************************************************************************

 $Function:		

 $Description:		This is the File Transfer Client Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA FTC Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
void	mfw_bt_ftc_cb(T_MFW_BT_FTC_EVT event, T_MFW_BT_FTC_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_ftc_cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_FTC_ENABLE_EVT:
		case BTA_FTC_CLOSE_EVT:
			dataLen = 0;
			break;

		case BTA_FTC_OPEN_EVT:
			dataLen = sizeof(tBTA_FTC_OPEN);
			break;

		case BTA_FTC_AUTH_EVT:
			dataLen = sizeof(tBTA_FTC_AUTH);
			break;

		case BTA_FTC_LIST_EVT:
			dataLen = sizeof(tBTA_FTC_LIST);
			break;

		case BTA_FTC_PROGRESS_EVT:
			dataLen = sizeof(tBTA_FTC_PROGRESS);
			break;

		case BTA_FTC_GETFILE_EVT:
		case BTA_FTC_PUTFILE_EVT:
			dataLen = sizeof(tBTA_FTC_STATUS);
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_ftc_cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_ftc_cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_FTC, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_FTC, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_ftc_cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}

/*******************************************************************************

 $Function:		

 $Description:		This is the File Transfer Server Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA FTS Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
void	mfw_bt_fts_cb(T_MFW_BT_FTS_EVT event, T_MFW_BT_FTS_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_fts_cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_FTS_ENABLE_EVT:
		case BTA_FTS_OPEN_EVT:
		case BTA_FTS_CLOSE_EVT:
			dataLen = 0;
			break;

		case BTA_FTS_AUTH_EVT:
			dataLen = sizeof(tBTA_FTS_AUTH);
			break;

#if 0	/* These events and their structures are in the BTA interface document, but not in the header files!!! */
		case BTA_FTS_ACCESS_EVT:
			dataLen = sizeof(tBTA_FTS_ACCESS);
			break;

		case BTA_FTS_PROGRESS_EVT:
			dataLen = sizeof(tBTA_FTS_PROGRESS);
			break;
#endif

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_fts_cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_fts_cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_FTS, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_FTS, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_fts_cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}


/*
** MFW Bluetooth File Transfer Signal Handler Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_ftc_hndlr

 $Description:		This function recieves the BTA File Transfer Client events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_ftc_hndlr (T_MFW_BT_FTC_EVT event, T_MFW_BT_FTC_SIG_DATA *data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_ftc_hndlr");

	switch (event)
	{
		case BTA_FTC_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_ENABLE_EVT event received");
			break;

		case BTA_FTC_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_CLOSE_EVT event received");
			break;

		case BTA_FTC_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_OPEN_EVT event received");
			break;

		case BTA_FTC_AUTH_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_AUTH_EVT event received");
			break;

		case BTA_FTC_LIST_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_LIST_EVT event received");
			break;

		case BTA_FTC_PROGRESS_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_PROGRESS_EVT event received");
			break;

		case BTA_FTC_GETFILE_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_GETFILE_EVT event received");
			break;

		case BTA_FTC_PUTFILE_EVT:
			MFW_BT_TRACE("mfw_bt_ftc_hndlr > BTA_FTC_PUTFILE_EVT event received");
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_ftc_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
	}

	return retVal;
}

/*******************************************************************************

 $Function:		mfw_bt_fts_hndlr

 $Description:		This function recieves the BTA File Transfer Server events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_fts_hndlr (T_MFW_BT_FTS_EVT event, T_MFW_BT_FTS_SIG_DATA *data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_fts_hndlr");

	switch (event)
	{
		case BTA_FTS_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_ENABLE_EVT event received");
			break;

		case BTA_FTS_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_OPEN_EVT event received");
			break;

		case BTA_FTS_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_CLOSE_EVT event received");
			break;

		case BTA_FTS_AUTH_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_AUTH_EVT event received");
			break;

#if 0	/* These events are in the BTA interface document, but not in the header files!!! */
		case BTA_FTS_ACCESS_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_ACCESS_EVT event received");
			break;

		case BTA_FTS_PROGRESS_EVT:
			MFW_BT_TRACE("mfw_bt_fts_hndlr > BTA_FTS_PROGRESS_EVT event received");
			break;
#endif

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_fts_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
	}

	return retVal;
}

