/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt_flash.h			$|
| $Author:: Thomas Sommer		     $Revision::  1						$|
| CREATED: 17.04.04				     $Modtime:: 17.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT_FLASH

   PURPOSE : This module contains the functions for MFW Bluetooth Data Base facilities. It is a LOCAL
   			DATA BASE, thus doesn't require the BT stack to be started. Just call the mfw_bt_flash_init( )
   			function to be able to use the following functions.

*/

#ifndef DEF_MFW_BT_FLASH_HEADER
#define DEF_MFW_BT_FLASH_HEADER

#include "bta_api.h"
#include "mfw_bte.h"

/* default  values for mfw_bt_default_cfg */
#define MFW_BT_ENABLED FALSE
#define MFW_BT_DISCOVERABLE_MODE TRUE
#define MFW_BT_DEVICE_NAME "BT Mobile Phone"

/* config and device db paths */
#define MFW_BT_CFG_ROOT_PATH "/bt"
#define MFW_BT_CFG_FILE "conf"
#define MFW_BT_SEC_FILE "security"
#define MFW_BT_VAR_ROOT_PATH "/var/bt"
#define RIV_PATH_SEP "/"


#define MFW_BT_MAX_PATH_LENGTH       127


/* this is the core configuration for bta/riviera */
typedef struct
{
	BOOL              	bt_enable; /* TRUE if bluetooth is enabled */
	BOOL			discoverable; /* discoverable mode FALSE = NONE, TRUE = GENERAL */
	char                	local_device_name[MFW_BT_NAME_LENGTH];    /* our device name */
} tMFW_BT_CFG;







/*
** Bluetooth Flash Manager Profile Prototypes
*/

/*******************************************************************************
 $Function:		mfw_bt_flash_init
 $Description:		update the RAM information with the files in flash
 $Returns:		TRUE if OK, wrong is something failed => no stored file, and not possible to 
				create a new one. Typically, this mean the flash is not formatted.
 $Arguments:		None
*******************************************************************************/
BOOL mfw_bt_flash_init( void );

/*******************************************************************************
 $Function:		mfw_bt_read_status
 $Description:		update the flash information with the files in flash
 $Returns:		TRUE if OK, wrong is something failed => no stored file, and not possible to 
 				create a new one. Typically, this mean the flash is not formatted
 $Arguments:		UINT32, value of bt_enable flag. 1 if enabled.
*******************************************************************************/
BOOL mfw_bt_read_status( void );

/*******************************************************************************
 $Function:		mfw_bt_store_status
 $Description:		update the BT status in flash
 $Returns:		MFW_BT_SUCCESS if OK, wrong is something failed => no stored file, and not possible to 
 				create a new one. Typically, this mean the flash is not formatted
 $Arguments:		new BT status: TRUE if enabled, FALSE if disabled.
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_store_status( BOOL new_enable_status );

/*******************************************************************************
 $Function:		mfw_bt_read_visibility
 $Description:		read the discoverability setting
 $Returns:		discoverability setting => TRUE if visible, FALSE if hidden
 $Arguments:		None
*******************************************************************************/
BOOL mfw_bt_read_visibility( void );

/*******************************************************************************
 $Function:		mfw_bt_store_visibility
 $Description:		store the discoverability setting
 $Returns:		MFW_BT_SUCCESS if OK, MFW_BT_FAIL is something failed 
				=> no stored file, and not possible to 
 				create a new one. Typically, this mean the flash is not formatted
 $Arguments:		new discoverability setting: TRUE if visible, FALSE if hidden
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_store_visibility( BOOL new_visibility );

/*******************************************************************************
 $Function:		mfw_bt_read_local_name
 $Description:		read local BT name
 $Returns:		local BT name. Pointer to a the string in the local database => this has to 
 				be copied if needed for other things.
 $Arguments:		None
*******************************************************************************/
UINT8* mfw_bt_read_local_name( void );

/*******************************************************************************
 $Function:		mfw_bt_store_local_name
 $Description:		update the local name in flash
 $Returns:		MFW_BT_SUCCESS if OK, MFW_BT_FAIL is something failed 
 				=> typically, this mean the flash is not formatted
 $Arguments:		new local name. This data is copied and not freed.
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_store_local_name( char* new_name );

 
/*******************************************************************************
 $Function:		mfw_bt_flash_store_device
 $Description:		stores peer device to NVRAM. If device not already in data base => add it. If
 				there, update its information. !!! It will overwrite existing information! Use
 				this function wisely!=> typically, call mfw_bt_flash_get_device_info before to
 				get the pointer of an existing device, or allocate memory for a new one.
 $Returns:		MFW_BT_DATA_BASE_FULL if data base full. MFW_BT_FAIL if not 
 				able to write in flash. Else, success.
 $Arguments:		pointer to a device descriptor. IF NOT ALREADY IN THE DATABASE, WILL BE
 				COPIED. IF ALREADY IN THE DATABASE, THE DATA IS NOT COPIED!
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_flash_store_device( T_MFW_BT_REM_DEVICE * p_rem_device);

/*******************************************************************************
 $Function:		mfw_bt_clean_inq_db
 $Description:		clean the contents of the inquiry data base in RAM. To be called before each
 				new inquiry/discovery.
 $Returns:		
 $Arguments:		
*******************************************************************************/
void mfw_bt_clean_inq_db( void );

/*******************************************************************************
 $Function:		mfw_bt_add_inq_device
 $Description:		copy the information received into the RAM inquiry database. 
 $Returns:		T_MFW_BT_STATUS. MFW_BT_DATA_BASE_FULL or SUCCESS.
 $Arguments:		pointer to an inquiry result. Data is copied.
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_add_inq_device( T_MFW_BT_DM_INQ_RES* p_rem_device);

/*******************************************************************************
 $Function:		mfw_bt_add_disc_device
 $Description:		copy the information received into the RAM inquiry database.  
 $Returns:		T_MFW_BT_STATUS. MFW_BT_DATA_BASE_FULL or SUCCESS.
 $Arguments:		pointer to a discovery result. Data is copied.
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_add_disc_device( T_MFW_BT_DM_DISC_RES* p_rem_device);

/*******************************************************************************
 $Function:		mfw_bt_get_device_info
 $Description:		gets the device record of a stored device.  
 $Returns:		NULL if device not found. Pointer to a device structure if found. This data should
 				be copied if wanted to be used somewhere else.
 				If the device is not stored in Flash, the is_new flag is set => this means it is
 				a newly found device ( from an inquiry or discovery result ).
 $Arguments:		DB_ADDR of the device wanted.
*******************************************************************************/
T_MFW_BT_REM_DEVICE * mfw_bt_get_device_info(BD_ADDR bd_addr);

/*******************************************************************************
 $Function:		mfw_bt_get_device_by_service
 $Description:		gets a list of device records corresponding to the given service. If service = 0,
 				will return all the stored devices.
 $Returns:		T_MFW_BT_STATUS
 $Arguments:		services => mask of services to look for

 				pp_device: a pointer to a T_MFW_BT_REM_DEVICE[MFW_BT_NUM_REM_DEVICE]
 				array. THIS MEMORY HAVE TO BE ALLOCATED!!! This function will add the 
 				pointers one by one into this array!!! The pointers are pointing on local data =>
 				might need to be copied.
 				
 				number_of_devices: will be used to return the number of devices matching
 				the service mask.			
*******************************************************************************/
void mfw_bt_get_device_by_service(	T_MFW_BT_SERVICE_MASK services,
														T_MFW_BT_REM_DEVICE ** pp_device,
														UINT8*	number_of_devices );

/*******************************************************************************
 $Function:		mfw_bt_flash_delete_device
 $Description:		deletes the device from nvram
 $Returns:		MFW_BT_FAIL, MFW_BT_SUCCESS, 
 				MFW_BT_UNKNOWN_DEVICE
 $Arguments:		BD_ADDR of the device to remove from flash.				
*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_flash_delete_device(BD_ADDR bd_addr);


#endif




