/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)		$Workfile:: mfw_bt_dg.c			$|
| $Author:: NDH						$Revision::  1						$|
| CREATED: 22.04.04					$Modtime:: 22.04.04 11:09			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT_DG

   PURPOSE : This module contains the functions for MFW Bluetooth Data Gateway Profile


*/

#define ENTITY_MFW

#include <string.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "bta_riviera.h"
#include "mfw_bte.h"
#include "mfw_bt_dg.h"
#include "mfw_bt_geh.h"



T_MFW_BT_STATUS mfw_bt_dg_init( void )
{
		MFW_BT_TRACE("mfw_bt_dg_init: starting the DG BT subsystem.");
}

/*
** MFW Bluetooth Data Gateway Callback Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_Dg_Cb

 $Description:		This is the Data Gateway Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA DG Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
void	mfw_bt_dg_cb(T_MFW_BT_DG_EVT event, T_MFW_BT_DG_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_Dg_Cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_DG_ENABLE_EVT:
			dataLen = 0;
			break;
			
		case BTA_DG_LISTEN_EVT:
			dataLen = sizeof(tBTA_DG_LISTEN);
			break;


		case BTA_DG_OPENING_EVT:
			dataLen = sizeof(tBTA_DG_OPENING);
			break;

		case BTA_DG_OPEN_EVT:
			dataLen = sizeof(tBTA_DG_OPEN);
			break;

		case BTA_DG_CLOSE_EVT:
			dataLen = sizeof(tBTA_DG_CLOSE);
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_Dg_Cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_Dg_Cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_DG, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_DG, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_Dg_Cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}


/*
** MFW Bluetooth Data Gateway Signal Handler Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_dg_hndlr

 $Description:		This function recieves the BTA Data Gateway events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_dg_hndlr (T_MFW_BT_DG_EVT event, T_MFW_BT_DG_SIG_DATA *data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;
	
	MFW_BT_TRACE("mfw_bt_dg_hndlr");

	switch (event)
	{
		case BTA_DG_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_dg_hndlr > BTA_DG_ENABLE_EVT event received");
			break;
			
		case BTA_DG_LISTEN_EVT:
			MFW_BT_TRACE("mfw_bt_dg_hndlr > BTA_DG_LISTEN_EVT event received");
			break;


		case BTA_DG_OPENING_EVT:
			MFW_BT_TRACE("mfw_bt_dg_hndlr > BTA_DG_OPENING_EVT event received");
			break;

		case BTA_DG_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_dg_hndlr > BTA_DG_OPEN_EVT event received");
			break;

		case BTA_DG_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_dg_hndlr > BTA_DG_CLOSE_EVT event received");
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_dg_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
			
	}

	return retVal;
}

