/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt_ag.h				$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 17.04.04				     $Modtime:: 17.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth Audio Gateway Profile

*/

#ifndef DEF_MFW_BT_AG_HEADER
#define DEF_MFW_BT_AG_HEADER

#include "bta_ag_api.h"
#include "mfw_bte.h"

/*
** The following Macros define the Audio Gateway Signals (BT -> Mfw)
*/
#define T_MFW_BT_AG_EVT			tBTA_AG_EVT
#define T_MFW_BT_AG_SIG_DATA		tBTA_AG

/*
** Event Identifiers (Mfw -> BMI)
*/
#define E_BT_ALL_AG_SERVICES		(T_MFW_EVENT)0x00FF0000


/*
** Event Parameter Structure Definitions
*/

typedef struct {
	UINT32 dummy;
}T_MFW_BT_AG_DUMMY_SIG;

/*
** Bluetooth Audio Gateway Profile Prototypes
*/
void	mfw_bt_ag_cb(T_MFW_BT_AG_EVT event, T_MFW_BT_AG_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_ag_hndlr (T_MFW_BT_AG_EVT event, T_MFW_BT_AG_SIG_DATA *data);
T_MFW_BT_STATUS mfw_bt_ag_init( void );

#endif

