/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)		$Workfile:: mfw_bt_ag.c			$|
| $Author:: NDH						$Revision::  1						$|
| CREATED: 22.04.04					$Modtime:: 22.04.04 11:07			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT_AG

   PURPOSE : This module contains the functions for MFW Bluetooth Audio Gateway Profile


*/

#define ENTITY_MFW

#include <string.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "bta_riviera.h"

#include "mfw_bte.h"
#include "mfw_bt_ag.h"
#include "mfw_bt_geh.h"


/*******************************************************************************

 $Function:		mfw_bt_ag_init

 $Description:		Start the audio gateway subsystem.

 $Returns:		T_MFW_BT_STATUS

 $Arguments:		none

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_ag_init( void )
{
		MFW_BT_TRACE("mfw_bt_ag_init: starting the AG BT subsystem.");
		return MFW_BT_SUCCESS;
}



/*
** MFW Bluetooth Audio Gateway Callback Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_Ag_Cb

 $Description:		This is the Audio Gateway Callback function, a pointer to it is passed
 				to the Bluetooth Module in the BTA AG Enable function and it is
 				used to return information from the Bluetooth Module

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/


void	mfw_bt_ag_cb(T_MFW_BT_AG_EVT event, T_MFW_BT_AG_SIG_DATA *data)
{
	int dataLen;
	T_MFW_BT_STATUS	geRetVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_Ag_Cb");

	/*
	** Set the expected data size according to the received event
	*/
	switch (event)
	{
		case BTA_AG_ENABLE_EVT:
			dataLen = 0;
			break;
			
		case BTA_AG_OPEN_EVT:
			dataLen = sizeof(tBTA_AG_OPEN);
			break;

#if 0
		case BTA_AG_CONN_EVT:	/* This event is in the BTA interface document, but not in the header files!!! */
		case BTA_AG_CLOSE_EVT:
		case BTA_AG_AUDIO_OPEN_EVT:
		case BTA_AG_AUDIO_CLOSE_EVT:
			dataLen = sizeof(tBTA_AG_HDR);	/* This structure is in the BTA interface document, but not in the header files!!! */
			break;
			
		case BTA_AG_SPK_EVT:
		case BTA_AG_MIC_EVT:
		case BTA_AG_CKPD_EVT:
		case BTA_AG_AT_A_EVT:
		case BTA_AG_AT_D_EVT:
		case BTA_AG_AT_CHLD_EVT:
		case BTA_AG_AT_CHUP_EVT:
		case BTA_AG_AT_CIND_EVT:
		case BTA_AG_AT_VTS_EVT:
		case BTA_AG_AT_BINP_EVT:
		case BTA_AG_AT_BLDN_EVT:
		case BTA_AG_AT_BVRA_EVT:
		case BTA_AG_AT_NREC_EVT:
		case BTA_AG_AT_CNUM_EVT:
			dataLen = sizeof(tBTA_AG_VAL);	/* This structure is in the BTA interface document, but not in the header files!!! */
			break;
#endif
			
		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_Ag_Cb > Unexpected Event %d", event);
			dataLen = -1;
			
	}


	if (dataLen > 0)
	{
		/*
		** Data is expected with the received signal
		*/
		if ((void *)data == (void *)0)
		{
			/*
			** The data pointer is NULL, report the error
			*/
			MFW_BT_TRACE_P1("mfw_bt_Ag_Cb > Event : %d, Data Pointer is NULL, but data is expected", event);
		}
		else
		{
			/*
			** Post the event and data to the Generic event handler
			*/
			geRetVal = mfw_bt_ge_post_event(MFW_BT_AG, (ULONG)event, (void *)data, dataLen);
		}
	}
	else if (dataLen == 0)
	{
		/*
		** There is no expected data with the received signal, post the event to the Generic event handler
		*/
		geRetVal = mfw_bt_ge_post_event(MFW_BT_AG, (ULONG)event, (void *)0, 0);
	}

	if (geRetVal != MFW_BT_SUCCESS)
	{
		/*
		** There is an error, but there is nothing that can be done other than to report it.
		*/
		MFW_BT_TRACE_P1("mfw_bt_Ag_Cb > Failed to post the event. Error %d", geRetVal);
	}

	return;
}


/*
** MFW Bluetooth Audio Gateway Signal Handler Function Definitions
*/
/*******************************************************************************

 $Function:		mfw_bt_ag_hndlr

 $Description:		This function recieves the BTA Audio Gateway events from the Generic Event Handler
 				and either processes them in their entirety or passes them to the MMI for further
 				processing.

 $Returns:		None

 $Arguments:		event	: Event Id returned from the Bluetooth Module
 				data		: pointer to the relevant data returned from the Mluetooth Module

*******************************************************************************/
T_MFW_BT_STATUS mfw_bt_ag_hndlr(T_MFW_BT_AG_EVT event, T_MFW_BT_AG_SIG_DATA * data)
{
	T_MFW_BT_STATUS retVal = MFW_BT_SUCCESS;

	MFW_BT_TRACE("mfw_bt_Ag_Cb");

	switch (event)
	{
		case BTA_AG_ENABLE_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_ENABLE_EVT event received");
			break;
			
		case BTA_AG_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_OPEN_EVT event received");
			break;

#if 0	/* This event is in the BTA interface document, but not in the header files!!! */
		case BTA_AG_CONN_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_CONN_EVT event received");
			break;
#endif

		case BTA_AG_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_CLOSE_EVT event received");
			break;

		case BTA_AG_AUDIO_OPEN_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AUDIO_OPEN_EVT event received");
			break;

		case BTA_AG_AUDIO_CLOSE_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AUDIO_CLOSE_EVT event received");
			break;
			
		case BTA_AG_SPK_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_SPK_EVT event received");
			break;

		case BTA_AG_MIC_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_MIC_EVT event received");
			break;

		case BTA_AG_CKPD_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_CKPD_EVT event received");
			break;

		case BTA_AG_AT_A_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_A_EVT event received");
			break;

		case BTA_AG_AT_D_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_D_EVT event received");
			break;

		case BTA_AG_AT_CHLD_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_CHLD_EVT event received");
			break;

		case BTA_AG_AT_CHUP_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_CHUP_EVT event received");
			break;

		case BTA_AG_AT_CIND_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_CIND_EVT event received");
			break;

		case BTA_AG_AT_VTS_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_VTS_EVT event received");
			break;

		case BTA_AG_AT_BINP_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_BINP_EVT event received");
			break;

		case BTA_AG_AT_BLDN_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_BLDN_EVT event received");
			break;

		case BTA_AG_AT_BVRA_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_BVRA_EVT event received");
			break;

		case BTA_AG_AT_NREC_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_NREC_EVT event received");
			break;

		case BTA_AG_AT_CNUM_EVT:
			MFW_BT_TRACE("mfw_bt_ag_hndlr > BTA_AG_AT_CNUM_EVT event received");
			break;

		default:
			/*
			** Unexpected Event, setthe data sized to -1 to exit with no further action
			*/
			MFW_BT_TRACE_P1("mfw_bt_ag_hndlr > Unexpected Event %d", event);
			retVal = MFW_BT_INVALID_EVENT;
	}

	return retVal;
	
}

