/*
+--------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mfw_bt.h        $|
| $Author:: Rm                          $Revision::  1              $|
| CREATED: 03.01.01                      $Modtime:: 03.01.01 10:48  $|
| STATE  : code                                                      |
+--------------------------------------------------------------------+

   MODULE  : MFW_BT

   PURPOSE : This modul contains the definition for BT management.
*/

#ifndef DEF_MFW_BT_HEADER
#define DEF_MFW_BT_HEADER

/*
 * events are usually organised as bitmaps
 * due to the amount of events (more than 32) these are coded as enum
 */
typedef enum
{
 BT_NO_EVENT = 0,
 BT_CREATE_PROFILE_CNF,
 BT_DELETE_PROFILE_CNF,
 BT_INIT_PROFILE_CNF,
 BT_DEINIT_PROFILE_CNF,
 BT_SERVICE_SEARCH_CNF,
 BT_DEVICE_FOUND_IND,
 BT_CONNECT_DEVICE_CNF,
 BT_CONNECT_DEVICE_IND,
 BT_DISCONNECT_DEVICE_CNF,
 BT_DISCONNECT_DEVICE_IND,
 BT_SRV_SYNC_CNF,
 BT_TRANSFER_AUDIO_IN_CNF,
 BT_TRANSFER_AUDIO_OUT_CNF,
 BT_PIN_IND,
 BT_RECONFIG_PROFILE_CNF,
 BT_RESTORE_LIST_RESULT,
 BT_SRV_SYNC_AUTH_IND,
 BT_RESTORE_CONF_RESULT,
 BT_SERVICE_FOUND_IND,
 BT_DEVICE_SEARCH_CNF,
 BT_DEVICE_PAIRED_IND,
 BT_DISCON_DUN_FAX_CNF,
 BT_CALL_MONITORING_STATUS,
 BT_AUTHORIZATION_IND,
 BT_DISCON_DUN_FAX_IND,
 BT_OPP_OBJECT_PUSH_CNF,
 BT_OPP_OBJECT_PULL_CNF,
 BT_OPP_SERV_PUT_IND,
 BT_OPP_SERV_PUT_CNF,
 BT_SRV_SYNC_PULL_IND,
 BT_SRV_SYNC_PUSH_IND,
 BT_SRV_SYNC_PUSH_CNF,
 BT_CONNECT_DEVICE_INF,
 BT_TRUSTED_DEV_LIST_FULL,
 BT_CHNG_LOCAL_NAME,
 BT_READ_LOCAL_NAME,
 BT_REMOTE_DEV_INFO_RES,
 BT_CHNG_CONNECTABLE_MODE,
 BT_CHNG_DISCOVERABLE_MODE,
 BT_READ_BD_ADDR
/*#ifdef PCA_6350*/
  ,
  BT_PCA_GW_STATUS_CFM,
  BT_PCA_GW_LINK_MONITORING,
  BT_PCA_GW_CALL_MONITORING,
  BT_PCA_GW_HANGUP_CFM,
/*#endif*/ /* PCA_6350 */
/* Cartman added begin */
BT_HSG_HEADSET_CONNECTION_IND,
BT_HSG_SPECIFIC_CMD_CFM,
BT_HSG_SAVE_LIST_CNF
/* Cartman added end */
} T_MFW_BT_EVENT;

/* constants */
#define MFW_BT_ADDR_MAX_LEN BTI_BD_ADDR_LENGTH
#define MFW_BT_NAME_MAX_LEN BTI_BD_NAME_LENGTH
#define MFW_BT_DEVICE_CLASS_LEN BTI_DEVICE_CLASS_LENGTH
#define MFW_BT_PIN_MAX_LEN BTI_PIN_LENGTH
#define MFW_BT_SERVICE_NAME_MAX_LEN BTI_SERVICE_NAME_LENGTH
#define MFW_BT_HSG_NAME_MAX_LEN BTI_HSG_NAME_LENGTH
#define MFW_BT_APPL_NAME_MAX_LEN BTI_APPLI_NAME_LENGTH
#define MFW_BT_PHONE_LIST_MAX_LEN BTI_PHONE_NB_LIST_MAX_LENGTH
#define MFW_BT_KEY_LIST_MAX_LEN BTI_PHONE_NB_LIST_MAX_LENGTH
#define MFW_BT_PHONE_NUMBER_MAX_LEN BTI_PHONE_NUMBER_MAX_LENGTH
#define MFW_BT_OPP_OBJECT_NAME_MAX_LEN BTI_OPP_NAME_MAX_LENGTH
#define MFW_BT_OPP_OBJECT_MIME_MAX_LEN BTI_OPP_MIME_MAX_LENGTH
/* default values */
#define MFW_BT_CONN_SCAN_TIME_DEFAULT_VALUE  BTI_CONN_SCAN_TIME_DEFAULT_VALUE  /*  1,28 s */
#define MFW_BT_CONN_SCAN_BREAK_DEFAULT_VALUE BTI_CONN_SCAN_BREAK_DEFAULT_VALUE /*  1,28 s */

#define MFW_BT_DEFAULT_HEADSET_ID   BTI_DEFAULT_HEADSET_ID
#define MFW_BT_INVALID_HEADSET_ID   BTI_INVALID_HEADSET_ID
#define MFW_BT_NO_ID                BTI_NO_ID

/* service id's  */
#define MFW_BT_Serial_Port BTI_Serial_Port
#define MFW_BT_LAN_Access BTI_LAN_Access
#define MFW_BT_Dial_Up_Networking BTI_Dial_Up_Networking
#define MFW_BT_IrMC_Sync BTI_IrMC_Sync
#define MFW_BT_OBEX_Object_Push BTI_OBEX_Object_Push
#define MFW_BT_OBEX_File_Transfer BTI_OBEX_File_Transfer
#define MFW_BT_IrMC_Sync_Command BTI_IrMC_Sync_Command
#define MFW_BT_Ser_Headset BTI_Headset
#define MFW_BT_Cordless_telephony BTI_Cordless_telephony
#define MFW_BT_Intercom BTI_Intercom
#define MFW_BT_Fax BTI_Fax
#define MFW_BT_Headset_Audio_Gateway BTI_Headset_Audio_Gateway
#define MFW_BT_WAP BTI_WAP
#define MFW_BT_WAP_Client BTI_WAP_Client

/* service names */
#define MFW_BT_SERV_HSG SERVICE_HSG
#define MFW_BT_SERV_DUN SERVICE_DUN
#define MFW_BT_SERV_FAX SERVICE_FAX_GW
#define MFW_BT_SERV_OPP SERVICE_OPP
#define MFW_BT_SERV_SYNC_C SERVICE_SYNC_C

/* authorization id's */
#define MFW_SERVICE_HSG SERVICE_HSG_ID
#define MFW_SERVICE_DUN SERVICE_DUN_ID
#define MFW_SERVICE_FAX SERVICE_FAX_ID
#define MFW_SERVICE_OPP SERVICE_OPP_ID
#define MFW_SERVICE_SYNC_C SERVICE_SYNC_C_ID

/* service id's */
#define MFW_SERVICE_ID_SPP           BTI_SERVICE_ID_SPP
#define MFW_SERVICE_ID_LAN           BTI_SERVICE_ID_LAN
#define MFW_SERVICE_ID_DUN           BTI_SERVICE_ID_DUN
#define MFW_SERVICE_ID_SYNC          BTI_SERVICE_ID_SYNC
#define MFW_SERVICE_ID_OPP           BTI_SERVICE_ID_OPP
#define MFW_SERVICE_ID_FTP           BTI_SERVICE_ID_FTP
#define MFW_SERVICE_ID_SYNC_CMD      BTI_SERVICE_ID_SYNC_CMD
#define MFW_SERVICE_ID_HS            BTI_SERVICE_ID_HS
#define MFW_SERVICE_ID_CORDLESS      BTI_SERVICE_ID_CORDLESS
#define MFW_SERVICE_ID_INTERCOM      BTI_SERVICE_ID_INTERCOM
#define MFW_SERVICE_ID_FAX           BTI_SERVICE_ID_FAX
#define MFW_SERVICE_ID_HSG           BTI_SERVICE_ID_HSG
#define MFW_SERVICE_ID_WAP           BTI_SERVICE_ID_WAP
#define MFW_SERVICE_ID_WAP_CLIENT    BTI_SERVICE_ID_WAP_CLIENT
#define MFW_SERVICE_ID_GENERIC_AUDIO BTI_SERVICE_ID_GENERIC_AUDIO

/* hsg security */
#define MFW_BT_HSG_CLIENT_NO_SECURITY    (BTI_HSG_CLIENT_NO_SECURITY)
#define MFW_BT_HSG_CLIENT_AUTHENTICATION (BTI_HSG_CLIENT_AUTHENTICATION)
#define MFW_BT_HSG_CLIENT_ENCRYPTION     (BTI_HSG_CLIENT_ENCRYPTION)
#define MFW_BT_HSG_CLIENT_AUTHORIZATION  (BTI_HSG_CLIENT_AUTHORIZATION)

#define MFW_BT_HSG_SERVER_NO_SECURITY    (BTI_HSG_SERVER_NO_SECURITY)
#define MFW_BT_HSG_SERVER_AUTHENTICATION (BTI_HSG_SERVER_AUTHENTICATION)
#define MFW_BT_HSG_SERVER_ENCRYPTION     (BTI_HSG_SERVER_ENCRYPTION)
#define MFW_BT_HSG_SERVER_AUTHORIZATION  (BTI_HSG_SERVER_AUTHORIZATION)

/* type definitions */
typedef unsigned char T_MFW_BT_BD_NAME;
typedef unsigned char T_MFW_BT_SERVICE_NAME;
typedef unsigned char T_MFW_BT_HSG_NAME;
typedef unsigned char T_MFW_BT_APPL_NAME;
typedef unsigned char T_MFW_BT_BD_ADDR;
typedef unsigned char T_MFW_DEVICE_CLASS;
typedef unsigned char T_MFW_BT_PIN;
typedef unsigned char T_MFW_BT_SYN_PASSWD;

typedef unsigned char T_MFW_BT_REQ_ID;
typedef unsigned char T_MFW_BT_CNF_ID;
typedef unsigned char T_MFW_BT_DEV_ID;
typedef unsigned char T_MFW_BT_IND_ID;
typedef unsigned char T_MFW_BT_SECURITY;
typedef unsigned char T_MFW_BT_CONN_TIME;
typedef unsigned char T_MFW_BT_NB_PHONE;
typedef unsigned char T_MFW_BT_SERVER_CONN_CNF;

typedef unsigned short T_MFW_BT_CONN_BREAK;
typedef unsigned char T_MFW_BT_PRIORITY;
typedef unsigned long T_MFW_BT_AUTHORIZATION_MASK;

typedef unsigned short T_MFW_BT_HSG_SERVER_SECURITY_MODE;
typedef unsigned short T_MFW_BT_HSG_CLIENT_SECURITY_MODE;

typedef unsigned short T_MFW_SERVICE_ID;

typedef char * T_MFW_BT_OPP_FILE_PATH;
/* the object store name */
typedef char * T_MFW_BT_SYN_OBJECT_STORE;
#define MFW_BT_SYNC_OBJECT_IDENTIFIER BTI_SYNC_OBJECT_IDENTIFIER

/* declaration security level */
#define MFW_BT_INCOM_AUTHENTICATION BTI_INCOMING_AUTHENTICATION
#define MFW_BT_INCOM_ENCRYPTION BTI_INCOMING_ENCRYPTION
#define MFW_BT_INCOM_AUTHORIZATION BTI_INCOMING_AUTHORIZATION
#define MFW_BT_OUTGO_AUTHENTICATION BTI_OUTGOING_AUTHENTICATION
#define MFW_BT_OUTGO_ENCRYPTION BTI_OUTGOING_ENCRYPTION
#define MFW_BT_OUTGO_AUTHORIZATION BTI_OUTGOING_AUTHORIZATION

/* declaration phone number list */
typedef unsigned char T_MFW_BT_HSG_PHONE_NUMBER;
#define T_MFW_BT_HSG_PHONE_NUMBER_LIST T_MFW_BT_HSG_PHONE_NUMBER[MFW_BT_PHONE_NUMBER_MAX_LEN];
/* declaration key list */
typedef unsigned char T_MFW_BT_HSG_KEY_LIST;
/* declaration error code by BT */
typedef unsigned char T_MFW_BT_ERROR_CAUSE;
#define MFW_BT_ERROR_TIMEOUT BTI_HSG_TIMEOUT
#define MFW_BT_NO_DEVICE BTI_HSG_NO_DEVICE
#define MFW_BT_DEV_CONN_FAIL BTI_HSG_DEVICE_CONNECTION_FAILED
#define MFW_BT_INV_PARA BTI_HSG_INVALID_PARAMETERS
#define MFW_BT_REST_LIST_ERR BTI_HSG_RESTORE_LIST_ERROR
#define MFW_BT_REST_CONFIG_ERR BTI_HSG_RESTORE_CONFIG_ERROR
#define MFW_BT_NO_ERROR BTI_NO_ERROR
#define MFW_BT_OPP_ABORTED BTI_OPP_ABORTED
#define MFW_BT_SYNC_ABORTED BTI_SYNC_ABORTED
/* declaration pairing status by BT */
typedef  unsigned char T_MFW_BT_PAIRED_RESULT;
#define MFW_BT_PAIR_SUCCESS BTI_PAIRING_SUCESSFULL
#define MFW_BT_PAIR_FAIL BTI_PAIRING_FAILURE
/* maximal pairing address entries */
#define MAX_MFW_PAIRED_ADDR MAX_PAIRED_ADDR
#define MAX_MFW_AUTHORIZ_ADDR MAX_AUTH_ADDR

/* headset priorities in default headset list */
#define MFW_HSG_HEADSET_MAX_PRIORITY BTI_HSG_HEADSET_MAX_PRIORITY

/* Cartman added begin */
typedef char T_MFW_BT_HSG_CMD_TO_HS;
/* Cartman added end */


/* MFW - BT management functional return codes */
typedef enum
{
   MFW_BT_RET_FAIL = -1,         /* execution of command failed    */
   MFW_BT_RET_OK                 /* execution of command completed */
} T_MFW_BT_RETURN;

/* declaration auto connect state */
typedef enum
{
  MFW_BT_AUTO_CONNECT_ON = 0,
  MFW_BT_AUTO_CONNECT_OFF
} T_MFW_BT_AUTO_CONNECT_STATE;

/* declaration service type */
typedef enum
{
  MFW_BT_HEADSET = BTI_HEADSET,
  MFW_BT_DIAL_UP = BTI_DIAL_UP,
  MFW_BT_FAX_GW  = BTI_FAX_GW,
  MFW_BT_OPP     = BTI_OPP,
  MFW_BT_SYNC    = BTI_SYNC,
  MFW_BT_SYNC_CMD = BTI_SYNC_CMD,
  MFW_BT_PCA_GW  = BTI_PCA_GW
} T_MFW_BT_SERVICE_TYPE;

/* declaration subtype of profile */
typedef enum
{
  MFW_BT_CLIENT = BTI_CLIENT,
  MFW_BT_SERVER = BTI_SERVER,
  MFW_BT_NO_SUBTYPE  = BTI_NO_SUBTYP
} T_MFW_BT_SUBTYPE_DEV;

/* declaration connection mode */
typedef enum
{
  MFW_BT_AUTO_OUTG_DEF_CONN_OFF = 0,
  MFW_BT_AUTO_OUTG_DEF_CONN_ON
} T_MFW_BT_CONFIG_MODE;

/* declaration mode of PIN delivery */
typedef enum
{
  PIN_PROVIDED,
  PIN_UNABLE
} T_MFW_BT_PIN_MODE;

/* declaration result by BT */
typedef enum
{
  MFW_BT_OK = BTI_OK,
  MFW_BT_NOK = BTI_NOK,
  MFW_BT_NO_SUPP = BTP_NOT_SUPP,
  MFW_BT_INVALID_PARA = BTP_INVALID_PARAMETER,
  MFW_BT_NOT_READY = BTP_NOT_READY,
  MFW_BT_INT_ERR = BTP_INT_ERR,
  MFW_BT_MEM_ERR = BTP_MEMORY_ERR,
  MFW_BT_EXECUTE,
  MFW_BT_FAIL,
  MFW_BT_HSG_ALREADY_STORED
} T_MFW_BT_RESULT_BT;

typedef enum
{
  MFW_BT_PROFILE_INIT = BTI_PROFILE_INIT,
  MFW_BT_PROFILE_ENABLE = BTI_PROFILE_ENABLE
} T_MFW_BT_ACTION;
/* declaration config dialup */
typedef enum
{
  MFW_BT_LINK_MONIT_ON = BTI_DUN_LINK_MONIT_ON,
  MFW_BT_LINK_MONIT_OFF = BTI_DUN_LINK_MONIT_OFF
} T_MFW_BT_LINK_EVENT;

typedef enum
{
  MFW_BT_CALL_MONIT_ON = BTI_DUN_CALL_MONIT_ON,
  MFW_BT_CALL_MONIT_OFF = BTI_DUN_CALL_MONIT_OFF
} T_MFW_BT_CALL_EVENT;


/* declaration common security modes */
typedef enum
{
  MFW_BT_SECURITY_MODE_1 = BTI_SM_SECURITY_MODE_1,
  MFW_BT_SECURITY_MODE_2 = BTI_SM_SECURITY_MODE_2,
  MFW_BT_SECURITY_MODE_3 = BTI_SM_SECURITY_MODE_3
} T_MFW_BT_SECURITY_MODE;

/* declaration opp put response */
typedef enum
{
  MFW_BT_OPP_CONTINUE = BTI_OPP_CONT,
  MFW_BT_OPP_R_ENTITY_TOO_L = BTI_OPP_TOO_LARGE,
  MFW_BT_OPP_FORBIDDEN = BTI_OPP_FORBIDDEN
} T_MFW_BT_OPP_PUT_RES;

/* declaration storing type of object */
typedef enum
{
  MFW_BT_PATH = BTI_TYPE_PATH,
  MFW_BT_BUFFER = BTI_TYPE_BUFFER
} T_MFW_BT_OBJ_TYPE;

/* declaration pairable modes */
typedef enum
{
  MFW_BT_PAIRABLE = BTI_PAIRABLE,
  MFW_BT_NON_PAIRABLE = BTI_NON_PAIRABLE
} T_MFW_BT_PAIRABLE_MODE;

/* declaration parameter headset */
typedef enum
{
  MFW_BT_MIC_GAIN = BTI_MIC_GAIN,
  MFW_BT_SPEAKER_GAIN = BTI_SPEAKER_GAIN
} T_MFW_BT_PARAM_NUMBER;

typedef enum
{
  MFW_BT_PARA_INC = BTI_PARA_INC,
  MFW_BT_PARA_DEC = BTI_PARA_DEC,
  MFW_BT_PARA_SET = BTI_PARA_SET
} T_MFW_BT_CHANGE_PARA;
/* call monitoring status by dun */
typedef enum
{
  MFW_BT_CALL_IN_PROGRESS = 0,
  MFW_BT_CALL_ESTABLISHED,
  MFW_BT_CALL_PAUSED,
  MFW_BT_CALL_RESUMED,
  MFW_BT_HANGUP_IN_PROGRESS,
  MFW_BT_CALL_RELEASED
} T_MFW_BT_CALL_STATUS;

/* declaration data authorization modi */
typedef enum
{
  MFW_BT_AUTHORIZED_ONCE = BTI_AUTHORIZED_ONCE,
  MFW_BT_AUTHORIZED_ALWAYS = BTI_AUTHORIZED_ALWAYS,
  MFW_BT_UNAUTHORIZED = BTI_UNAUTHORIZED
}T_MFW_BT_AUTHORIZATION_MODE;

/* declaration data connection direction */
typedef enum
{
  MFW_BT_INCOM  = INCOM_CONN,
  MFW_BT_OUTGO = OUTGO_CONN
} T_MFW_BT_CONN_DIR;

/* declaration opp server mode */
typedef enum
{
  MFW_BT_OPP_NO_MODE  = BTI_NO_OPP_MODE,
  MFW_BT_OPP_SILENT_MODE = BTI_OPP_SILENT_FILE_MODE,
  MFW_BT_OPP_FILE_MODE = BTI_OPP_EVENT_FILE_MODE,
  MFW_BT_OPP_BUFFER_MODE = BTI_OPP_EVENT_BUFFER_MODE
} T_MFW_BT_OPP_SERV_MODE;

/* declaration syn server mode */
typedef enum
{
  MFW_BT_SYNC_NO_MODE  = BTI_NO_SYNC_MODE,
  MFW_BT_SYNC_GEN_MODE  = BTI_GEN_SYNC,
  MFW_BT_SYNC_INIT_MODE = BTI_INIT_SYNC
} T_MFW_BT_SYNC_SERV_MODE;

/* declaration syn server authentication mode */
typedef enum
{
  MFW_BT_SYNC_NO_AUTH_MODE  = BTI_NO_SYNC_AUTHENTICATION_MODE,
  MFW_BT_SYNC_INIT_AUTH_MODE  = BTI_INITIATE_AUTHENTICATION,
  MFW_BT_SYNC_NO_INIT_AUTH_MODE = BTI_NO_INITIATE_AUTHENTICATION
} T_MFW_BT_SYNC_AUTH_MODE;

/* declaration syn server commands */
typedef enum
{
  MFW_BT_SYNC_CO_SYNC  = BTI_SYNC_COM_SYNC,
  MFW_BT_SYNC_CO_PUT  = BTI_SYNC_COM_PUT
} T_MFW_BT_SYNC_COMMAND;

/* declaration source ids in connection indication */
typedef enum
{
  MFW_BT_REM_HEADSET = REM_HEADSET,
  MFW_BT_GSM_NETWORK = GSM_NETWORK,
  MFW_BT_NO_HSG      = NO_PROFILE_HSG
} T_MFW_BT_SOURCE;

/* declaration of discoverable modes for btctrl */
typedef enum
{
  MFW_BT_NON_DISCOVERABLE     = BTI_NON_DISCOVERABLE,
  MFW_BT_LIMITED_DISCOVERABLE = BTI_LIMITED_DISCOVERABLE,
  MFW_BT_GENERAL_DISCOVERABLE = BTI_GENERAL_DISCOVERABLE
} T_MFW_BT_DISCOVERABLE_MODE;

/* declaration of connectable modes for btctrl */
typedef enum
{
  MFW_BT_NON_CONNECTABLE = BTI_NON_CONNECTABLE,
  MFW_BT_CONNECTABLE     = BTI_CONNECTABLE
}T_MFW_BT_CONNECTABLE_MODE;


/* structures */
/* declaration headset client configuration parameter */
typedef struct
{
  T_MFW_BT_CONFIG_MODE config_mode;
  T_MFW_BT_HSG_CLIENT_SECURITY_MODE security;
} T_MFW_BT_HSG_CLIENT_CONFIG;


/* declaration sync server configuration parameter */
typedef struct
{
  T_MFW_BT_SYNC_SERV_MODE mfw_syn_srv_mode;
  T_MFW_BT_SYNC_AUTH_MODE mfw_syn_srv_auth_mode;
} T_MFW_BT_SYNC_SERVER_CONFIG;

/* declaration headset server configuration parameter */
typedef struct
{
  T_MFW_BT_SERVER_CONN_CNF serv_con_conf;
  T_MFW_BT_CONN_BREAK conn_break;
  T_MFW_BT_CONN_TIME conn_time;
  T_MFW_BT_NB_PHONE nb_phone;
  T_MFW_BT_HSG_SERVER_SECURITY_MODE security;
  T_MFW_BT_HSG_PHONE_NUMBER mfw_phone_list[MFW_BT_PHONE_LIST_MAX_LEN][MFW_BT_PHONE_NUMBER_MAX_LEN];
  T_MFW_BT_HSG_KEY_LIST mfw_key_list[MFW_BT_KEY_LIST_MAX_LEN];
} T_MFW_BT_HSG_SERVER_CONFIG;

/* declaration dial up configuration parameter */
typedef struct
{
  T_MFW_BT_LINK_EVENT link_event;
  T_MFW_BT_CALL_EVENT call_event;
} T_MFW_BT_DUN_CONFIG;

/* declaration fax gateway configuration parameter */
typedef struct
{
  T_MFW_BT_LINK_EVENT link_event;
  T_MFW_BT_CALL_EVENT call_event;
} T_MFW_BT_FAX_CONFIG;


/* declaration opp type object */
typedef struct
{
  T_MFW_BT_OBJ_TYPE mfw_object_type;
  U8 * mfw_buffer_start;
  U16 mfw_buffer_size;
  T_MFW_BT_OPP_FILE_PATH mfw_path;/* path to delivered object (f.e.default business card) */
  char * mfw_object_name;
  char * mfw_object_mime_type;
  ULONG mfw_object_length;
}T_MFW_BT_OPP_OBJECT;

#define T_MFW_BT_SYNC_OBJECT T_MFW_BT_OPP_OBJECT

/* declaration opp server configuration parameter */
typedef struct
{
  T_MFW_BT_OPP_SERV_MODE mfw_opp_mode;
  T_MFW_BT_OPP_FILE_PATH mfw_inbox_path;/* path for store of objects */
  T_MFW_BT_OPP_OBJECT mfw_opp_object;
} T_MFW_BT_OPP_SERVER_CONFIG;


/* declaration opp server put request parameter */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_OPP_OBJECT mfw_opp_object;
} T_MFW_BT_OPP_PUT_IND;

/* declaration opp server put confirm parameter */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_OPP_OBJECT mfw_opp_object;
  T_MFW_BT_ERROR_CAUSE error_cause;
} T_MFW_BT_OPP_PUT_CNF;

/* declaration opp client push object parameter to server */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_OPP_OBJECT mfw_opp_object;
  T_MFW_BT_ERROR_CAUSE error_cause;
} T_MFW_BT_OPP_PUSH_CNF;

/* declaration opp client pull object parameter from server */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_OPP_OBJECT mfw_opp_object;
  T_MFW_BT_ERROR_CAUSE error_cause;
} T_MFW_BT_OPP_PULL_CNF;

/* declaration info structure of headset */
typedef struct
{
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_HSG_NAME hsg_name[MFW_BT_HSG_NAME_MAX_LEN];
  T_MFW_BT_PRIORITY priority;
  BOOL mfw_remote_audio_control_support;
} T_MFW_BT_HEADSET_INFO;

/* declaration data disconnection confirm profile hsg */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_CNF_ID cnf_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
} T_MFW_BT_DISCONNECT_CNF;

/* declaration data disconnection confirm profile dun/fax */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_RESULT_BT result_bd;
} T_MFW_BT_DISCON_DUN_FAX_CNF;

/* declaration data pin indication */
typedef struct
{
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
} T_MFW_BT_PIN_IND;

/* declaration data authorization indication */
typedef struct
{
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  T_MFW_BT_APPL_NAME appli_name[MFW_BT_APPL_NAME_MAX_LEN];
  T_MFW_BT_AUTHORIZATION_MASK auth_mask_mfw;
  T_MFW_BT_CONN_DIR connection_dir;
} T_MFW_BT_AUTHORIZATION_IND;

/*declaration data service paramater */
typedef struct
{
  T_MFW_BT_AUTHORIZATION_MASK mfw_authorization_mask;
  T_MFW_BT_SERVICE_NAME service_name[MFW_BT_SERVICE_NAME_MAX_LEN];
} T_MFW_BT_SERVICE_PARAM;

/* declaration data transfer audio out confirm */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_CNF_ID cnf_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_RESULT_BT result_bd;
} T_MFW_BT_TRANSFER_AUDIO_OUT_CNF;

/* declaration data transfer audio in confirm */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_RESULT_BT result_bd;
} T_MFW_BT_TRANSFER_AUDIO_IN_CNF;

/* declaration data connection confirm for headset */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_CNF_ID cnf_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_ERROR_CAUSE cause;
  T_MFW_BT_RESULT_BT result_bd;
} T_MFW_BT_CONNECT_CNF;

/* declaration data connection indication*/
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_IND_ID ind_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  T_MFW_BT_SOURCE mfw_src_id;
} T_MFW_BT_CONNECT_IND;

/* declaration data connection information */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_IND_ID ind_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
} T_MFW_BT_CONNECT_INF;

/* declaration data disconnection indication for fax and dun */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
} T_MFW_BT_DISCON_DUN_FAX_IND;

/* declaration data disconnection indication */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_IND_ID ind_id;
} T_MFW_BT_DISCONNECT_IND;

/* declaration data search confirm */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
} T_MFW_BT_SERVICE_SEARCH_CNF;

/* declaration data search confirm */
typedef struct
{
  T_MFW_BT_RESULT_BT result;
} T_MFW_BT_DEVICE_SEARCH_CNF;


/* declaration data service indication */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_DEVICE_CLASS cod[MFW_BT_DEVICE_CLASS_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  T_MFW_BT_SERVICE_NAME service_name[MFW_BT_SERVICE_NAME_MAX_LEN];
} T_MFW_BT_SERVICE_IND;

/* declaration data device indication */
typedef struct
{
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_DEVICE_CLASS cod[MFW_BT_DEVICE_CLASS_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  U32 num_services;
  U32 services;
} T_MFW_BT_DEVICE_IND;

/* declaration data profile confirm */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_RESULT_BT result_bd;
  T_MFW_BT_ACTION action;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_OPP_SERV_MODE mfw_opp_mode;
  T_MFW_BT_SYNC_SERV_MODE mfw_sync_mode;
  T_MFW_BT_SYNC_AUTH_MODE mfw_syn_aut_mode;
} T_MFW_BT_PROFILE_CNF;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE profile;
} T_MFW_BT_PROFILE_CREATE_CNF;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE profile;
} T_MFW_BT_PROFILE_DELETE_CNF;

typedef struct
{
  U8 id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_HSG_NAME hsg_name[MFW_BT_HSG_NAME_MAX_LEN];
  T_MFW_BT_PRIORITY priority;
}T_MFW_BT_DEFAULT_DEV;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_ERROR_CAUSE cause;
}T_MFW_BT_REST_CONFIG;

typedef struct
{
  T_MFW_BT_BD_ADDR rem_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME rem_bd_name[MFW_BT_NAME_MAX_LEN];
  T_MFW_BT_PAIRED_RESULT pair_res;
}T_MFW_BT_DEV_PAIR_IND;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_CALL_STATUS call_state;
} T_MFW_BT_CALL_STATUS_DUN_FAX;

/* structures for list with addresses and names of desired device(service id) - dynamicly */
typedef struct T_MFW_BT_SERVICE_ID_TAG
{
  struct T_MFW_BT_SERVICE_ID_TAG *next; /* next block of bluetooth device */
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_DEVICE_CLASS cod[MFW_BT_DEVICE_CLASS_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  T_MFW_BT_SERVICE_NAME service_name[MFW_BT_SERVICE_NAME_MAX_LEN];
} T_MFW_BT_SERVICE_ID;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SERVICE_ID *device_id;
} T_MFW_BT_SERVICE_LST;
/* structure for pointer to list of found devices */
typedef struct
{
  T_MFW_BT_SERVICE_LST *list_ptr;
} T_MFW_BT_SERVICE_LST_P;

/* structures for list with address and names of found services of a device - dynamicly */
typedef struct T_MFW_BT_DEVICE_ID_TAG
{
  struct T_MFW_BT_DEVICE_ID_TAG *next; /* next block of bluetooth device */
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_DEVICE_CLASS cod[MFW_BT_DEVICE_CLASS_LEN];
  T_MFW_BT_BD_NAME bd_name[MFW_BT_NAME_MAX_LEN];
  U32 num_services;
  U32 services;
} T_MFW_BT_DEVICE_ID;

typedef struct
{
  T_MFW_BT_DEVICE_ID *device_id;
} T_MFW_BT_DEVICE_LST;
/* structure for pointer to list of found devices and their services */
typedef struct
{
  T_MFW_BT_DEVICE_LST *list_ptr;
} T_MFW_BT_DEVICE_LST_P;

/* structure of list of paired devices */
typedef struct
{
  U8 count;
  T_MFW_BT_BD_ADDR paired_bd_addr[MAX_MFW_PAIRED_ADDR][MFW_BT_ADDR_MAX_LEN];
} T_MFW_BT_DEV_PAIR_LIST;

/* structure of list of authorization database devices */
typedef struct
{
  T_MFW_BT_AUTHORIZATION_MASK mask_authorization;
  T_MFW_BT_BD_ADDR remote_bd_addr[MFW_BT_ADDR_MAX_LEN];
} T_MFW_BT_AUTHORIZATION_ELEMENT;


typedef struct
{
  U8 count;
  T_MFW_BT_AUTHORIZATION_ELEMENT auth_devices[MAX_MFW_AUTHORIZ_ADDR];
} T_MFW_BT_AUTHORIZATION_LIST;

/* an sync object store list */
typedef struct mfw_bt_object_store_list_struct
{
  struct mfw_bt_object_store_list_struct *next_object;  /* pointer to next object */
  T_MFW_BT_SYN_OBJECT_STORE object_store;         /* name of the object store */
  /* usually this is where the char array for the object store name can be found */
} T_MFW_BT_SYN_OBJECT_STORE_ITEM;

/* the list is just a pointer to the first item */
typedef T_MFW_BT_SYN_OBJECT_STORE_ITEM * T_MFW_BT_SYN_OBJECT_STORE_LIST;

/* structure syn object id */
typedef struct
{
  U16 mfw_object_size;
  char * mfw_location;
} T_MFW_BT_SYNC_OBJECT_ID;

/* structure for response of synchronization operation */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_ERROR_CAUSE mfw_error_state;
  T_MFW_BT_BD_ADDR mfw_client_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME mfw_client_name[MFW_BT_NAME_MAX_LEN];
} T_MFW_BT_SRV_SYNC_CNF;

/* structure for request authentication password */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR mfw_client_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_BD_NAME mfw_client_name[MFW_BT_NAME_MAX_LEN];
} T_MFW_BT_SRV_SYNC_AUTH_IND;

/* structure for request pull object from server */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR mfw_client_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_SYNC_OBJECT_ID mfw_object_id;
} T_MFW_BT_SRV_SYNC_PULL_IND;

/* structure for request push object to server */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR mfw_client_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_SYNC_OBJECT_ID mfw_object_id;
} T_MFW_BT_SRV_SYNC_PUSH_IND;


/* structure for confirm object push to server */
typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_SUBTYPE_DEV subtype;
  T_MFW_BT_BD_ADDR mfw_client_bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_SYNC_OBJECT mfw_object;
  T_MFW_BT_SYNC_OBJECT_ID mfw_object_id;
} T_MFW_BT_SRV_SYNC_PUSH_CNF;

/* BT CTRL events */
typedef struct
{
  BOOL                     success;                  /*<  0:  1> BTCTRL success                                     */
} T_MFW_BT_CHNG_LOCAL_NAME;

typedef struct
{
  BOOL                     success;                  /*<  0:  1> BTCTRL success                                     */
  T_MFW_BT_BD_NAME         bd_name[MFW_BT_NAME_MAX_LEN]; /*<  1:248> Bluetooth device name                              */
} T_MFW_BT_READ_LOCAL_NAME;

typedef struct
{
  BOOL                     success;                  /*<  0:  1> BTCTRL success                                     */
  T_MFW_BT_BD_ADDR         bd_addr[MFW_BT_ADDR_MAX_LEN]; /*<  1:  6> Bluetooth device address                           */
  T_MFW_DEVICE_CLASS       cod[MFW_BT_DEVICE_CLASS_LEN]; /*<  7:  3> Bluetooth class of device                          */
  T_MFW_BT_BD_NAME         bd_name[MFW_BT_NAME_MAX_LEN]; /*< 10:248> Bluetooth device name                              */
} T_MFW_BT_REMOTE_DEV_INFO_RES;

typedef struct
{
  BOOL                      success;                  /*<  0:  1> BTCTRL success                                     */
  T_MFW_BT_CONNECTABLE_MODE mode;                     /*<  1:  4> Conn/Disc Mode                                     */
  ULONG                     scan_interval;            /*<  5:  4> Scan Interval                                      */
  ULONG                     scan_window;              /*<  9:  4> Scan Window                                        */
} T_MFW_BT_CHNG_CONNECTABLE_MODE;

typedef struct
{
  BOOL                        success;                  /*<  0:  1> BTCTRL success                                     */
  T_MFW_BT_DISCOVERABLE_MODE  mode;                     /*<  1:  4> Conn/Disc Mode                                     */
  ULONG                       scan_interval;            /*<  5:  4> Scan Interval                                      */
  ULONG                       scan_window;              /*<  9:  4> Scan Window                                        */
} T_MFW_BT_CHNG_DISCOVERABLE_MODE;

typedef struct
{
  BOOL                    success;                  /*<  0:  1> BTCTRL success                                     */
  T_MFW_BT_BD_ADDR        bd_addr[MFW_BT_ADDR_MAX_LEN]; /*<  1:  6> Bluetooth device address                           */
} T_MFW_BT_READ_BD_ADDR;

/*#ifdef PCA_6350*/

typedef enum
{
  MFW_BT_PCA_LINK_MONIT_ON = BTI_PCA_LINK_MONIT_ON,
  MFW_BT_PCA_LINK_MONIT_OFF = BTI_PCA_LINK_MONIT_OFF
} T_MFW_BT_PCA_LINK_EVENT;

typedef enum
{
  MFW_BT_PCA_CALL_MONIT_ON = BTI_PCA_CALL_MONIT_ON,
  MFW_BT_PCA_CALL_MONIT_OFF = BTI_PCA_CALL_MONIT_OFF
} T_MFW_BT_PCA_CALL_EVENT;

/* declaration pca gateway configuration parameter */
typedef struct
{
  T_MFW_BT_PCA_LINK_EVENT link_event;
  T_MFW_BT_PCA_CALL_EVENT call_event;
} T_MFW_BT_PCA_CONFIG;

typedef enum
{
  MFW_BT_PCA_GW_DISABLED = BTI_PCA_GW_DISABLED,
  MFW_BT_PCA_GW_ENABLED  = BTI_PCA_GW_ENABLED
} T_MFW_BT_PCA_GW_STATUS;

typedef enum
{
  MFW_BT_PCA_GW_NOT_CONNECTED = BTI_PCA_GW_NOT_CONNECTED,
  MFW_BT_PCA_GW_CONNECTED     = BTI_PCA_GW_CONNECTED
} T_MFW_BT_PCA_GW_LINK_STATUS;

typedef enum
{
  MFW_BT_PCA_GW_CALL_IN_PROGRESS = BTI_PCA_GW_CALL_IN_PROGRESS,
  MFW_BT_PCA_GW_CALL_ESTABLISHED = BTI_PCA_GW_CALL_ESTABLISHED,
  MFW_BT_PCA_GW_CALL_PAUSED      = BTI_PCA_GW_CALL_PAUSED,
  MFW_BT_PCA_GW_CALL_RESUMED     = BTI_PCA_GW_CALL_RESUMED,
  MFW_BT_PCA_GW_HANGUP_IN_PROGRESS = BTI_PCA_GW_HANGUP_IN_PROGRESS,
  MFW_BT_PCA_GW_CALL_RELEASED    = BTI_PCA_GW_CALL_RELEASED
} T_MFW_BT_PCA_GW_CALL_STATUS;

typedef struct
{
  T_MFW_BT_PCA_GW_STATUS status;
} T_MFW_BT_PCA_GW_STATUS_CFM;

typedef struct
{
  T_MFW_BT_BD_ADDR            bd_addr[MFW_BT_ADDR_MAX_LEN];
  T_MFW_BT_PCA_GW_LINK_STATUS link_status;
} T_MFW_BT_PCA_GW_LINK_MONITORING;

typedef struct
{
  T_MFW_BT_PCA_GW_CALL_STATUS call_status;
} T_MFW_BT_PCA_GW_CALL_MONITORING;

typedef struct
{
  BOOL hangup;
} T_MFW_BT_PCA_GW_HANGUP_CFM;
/*#endif*/ /* PCA_6350 */


/* Cartman added begin */

typedef enum
{
  MFW_BT_HSG_CONNECT_NETWORK_ANSWER_OK = (BTI_HSG_CONNECT_NETWORK_ANSWER_OK),
  MFW_BT_HSG_CONNECT_NETWORK_ANSWER_NOK = (BTI_HSG_CONNECT_NETWORK_ANSWER_NOK)
} T_MFW_BT_HSG_CONNECT_NETWORK_ANSWER;

typedef enum
{
  MFW_BT_HSG_CONNECT_NETWORK_TYPE_AUTOMATIC_DIAL = (BTI_HSG_CONNECT_NETWORK_TYPE_AUTOMATIC_DIAL),
  MFW_BT_HSG_CONNECT_NETWORK_TYPE_MANUAL_DIAL = (BTI_HSG_CONNECT_NETWORK_TYPE_MANUAL_DIAL)
}T_MFW_BT_HSG_CONNECT_NETWORK_TYPE;

typedef enum
{
  MFW_BT_HSG_CMD_TYPE_RESULT_CODE = (BTI_HSG_CMD_TYPE_RESULT_CODE),
  MFW_BT_HSG_CMD_TYPE_UNSOLICITED_RESULT = (BTI_HSG_CMD_TYPE_UNSOLICITED_RESULT)
}T_MFW_BT_HSG_SPECIFIC_CMD_TYPE;

typedef struct
{
  T_MFW_BT_SERVICE_TYPE service;
  T_MFW_BT_IND_ID ind_id;
  T_MFW_BT_BD_ADDR bd_addr[MFW_BT_ADDR_MAX_LEN];
} T_MFW_BT_HSG_HEADSET_CONNECTION_IND;

typedef struct
{
  T_MFW_BT_HSG_CMD_TO_HS cmd[100];
} T_MFW_BT_HSG_SPECIFIC_CMD_CFM;

typedef struct
{
  UBYTE result;
} T_MFW_BT_HSG_SAVE_LIST_CNF;

/* Cartman added end */



/*
 * BT Parameter
 */
typedef union
{
   T_MFW_BT_PROFILE_CREATE_CNF prof_create_cnf;
   T_MFW_BT_PROFILE_DELETE_CNF prof_delete_cnf;
   T_MFW_BT_SERVICE_SEARCH_CNF search_conf;  /* finish search of services */
   T_MFW_BT_DEVICE_SEARCH_CNF dev_search_conf;/* finish search of devices and their services */
   T_MFW_BT_DEVICE_IND device_ind;           /* found new device */
   T_MFW_BT_SERVICE_IND service_ind;         /* found new service */
   T_MFW_BT_SERVICE_LST_P service_lst_p;     /* pointer to list of found devices (search confirm)*/
   T_MFW_BT_DEVICE_LST_P device_lst_p;       /* pointer to list of found services (device confirm)*/
   T_MFW_BT_TRANSFER_AUDIO_IN_CNF audio_in_cnf;/* info audio in confirm */
   T_MFW_BT_TRANSFER_AUDIO_OUT_CNF audio_out_cnf;/* info audio out confirm */
   T_MFW_BT_DISCONNECT_IND disconnect_ind;   /* info disconnection indication */
   T_MFW_BT_PIN_IND pin_ind;                 /* info pin indication (remote request) */
   T_MFW_BT_AUTHORIZATION_IND authoriz_ind;  /* info authorization indication (remote request) */
   T_MFW_BT_DISCON_DUN_FAX_CNF disc_dun_fax_cnf;/* info disconnect dun/ fax */
   T_MFW_BT_DISCONNECT_CNF disconnect_cnf;   /* info disconnection confirm */
   T_MFW_BT_CONNECT_CNF connect_cnf;         /* info connection confirm */
   T_MFW_BT_DISCON_DUN_FAX_IND con_dun_fax_ind; /* info disconnection indication dial up and fax */
   T_MFW_BT_PROFILE_CNF profile;             /* info init/deinit profile confirm */
   T_MFW_BT_REST_CONFIG restore_conf;        /* result restoring configuration bluetooth device */
   T_MFW_BT_CONNECT_IND connect_indication;  /* info connection indication by remote device */
   T_MFW_BT_CONNECT_INF connect_information; /* connection information RFCOMM level */
   T_MFW_BT_DEV_PAIR_IND pair_ind;           /* result of pairing procedure with remote device */
   T_MFW_BT_CALL_STATUS_DUN_FAX call_status; /* call monitoring status dun,fax            */
   T_MFW_BT_OPP_PUT_IND opp_s_obj;           /* info about opp server object put request from client to server (server side)*/
   T_MFW_BT_OPP_PUT_CNF opp_s_obj_cnf;       /* info about success of object put procedure from client to server (server side) */
   T_MFW_BT_OPP_PUSH_CNF opp_cl_push_ob_cnf; /* info about success of object push procedure to server (client side) */
   T_MFW_BT_OPP_PULL_CNF opp_cl_pull_ob_cnf; /* info about success of object push procedure from server (client side) */
   T_MFW_BT_SRV_SYNC_CNF srv_sync_cnf;       /* info about success of synchronization operation */
   T_MFW_BT_SRV_SYNC_AUTH_IND srv_sync_auth; /* request password for authentication at OBEX level for synchronization */
   T_MFW_BT_SRV_SYNC_PULL_IND sync_pull_ind; /* request to pull an syn object from server to the sync client */
   T_MFW_BT_SRV_SYNC_PUSH_IND sync_push_ind; /* request to push an syn object to the server from the sync client */
   T_MFW_BT_SRV_SYNC_PUSH_CNF sync_push_cnf; /* confirmation that push of syn object is done */
   T_MFW_BT_CHNG_LOCAL_NAME chng_local_name; /* result of change local name request */
   T_MFW_BT_READ_LOCAL_NAME read_local_name; /* result of read local name request */
   T_MFW_BT_REMOTE_DEV_INFO_RES remote_dev_info; /* remote device information */
   T_MFW_BT_CHNG_CONNECTABLE_MODE chng_conn_mode; /* result of change connectable mode request */
   T_MFW_BT_CHNG_DISCOVERABLE_MODE chng_disc_mode; /* result of change discoverable mode request */
   T_MFW_BT_READ_BD_ADDR read_bd_addr;       /* bt device address */
/*#ifdef PCA_6350*/
   T_MFW_BT_PCA_GW_STATUS_CFM pca_gw_status;
   T_MFW_BT_PCA_GW_LINK_MONITORING pca_link_mon;
   T_MFW_BT_PCA_GW_CALL_MONITORING pca_call_mon;
   T_MFW_BT_PCA_GW_HANGUP_CFM pca_hangup;
/*#endif*/ /* PCA_6350 */

   /* Cartman added begin */
   T_MFW_BT_HSG_HEADSET_CONNECTION_IND hsg_headset_connection_ind;
   T_MFW_BT_HSG_SPECIFIC_CMD_CFM hsg_specific_cmd_cfm;
   T_MFW_BT_HSG_SAVE_LIST_CNF hsg_save_list_cnf;
   /* Cartman added end */

} T_MFW_BT_PARA;

/*
 *  BT Control Block
 */
typedef struct
{
    T_MFW_EVENT     emask;          /* events of interest */
    T_MFW_EVENT     event;          /* current event */
    T_MFW_CB        handler;
    T_MFW_BT_PARA   para;
} T_MFW_BT;



int              bt_init             (void);
void             bt_exit             (void);
EXTERN T_MFW_HND       bt_create           (T_MFW_HND hWin,
                                             T_MFW_EVENT event,
                                             T_MFW_CB cbfunc);
EXTERN T_MFW_RES       bt_delete           (T_MFW_HND hWin);
EXTERN T_MFW_BT_RESULT_BT bt_init_profile_hsg_cl (T_MFW_BT_SERVICE_TYPE service,
                                            T_MFW_BT_HSG_CLIENT_CONFIG config);
EXTERN T_MFW_BT_RESULT_BT bt_init_profile_hsg_serv (T_MFW_BT_SERVICE_TYPE service,
                                  T_MFW_BT_HSG_SERVER_CONFIG mfw_config);
EXTERN T_MFW_BT_RESULT_BT bt_init_profile_dun (T_MFW_BT_SERVICE_TYPE service,
                                            T_MFW_BT_DUN_CONFIG dun_filter);
EXTERN T_MFW_BT_RESULT_BT bt_deinit_profile (T_MFW_BT_SERVICE_TYPE service,
                                             T_MFW_BT_SUBTYPE_DEV subtype);
EXTERN T_MFW_BT_RESULT_BT bt_reconfig_profile_hsg_cl (T_MFW_BT_SERVICE_TYPE service,
                                                T_MFW_BT_HSG_CLIENT_CONFIG config);
EXTERN T_MFW_BT_RESULT_BT bt_reconfig_profile_hsg_serv (T_MFW_BT_SERVICE_TYPE service,
                                  T_MFW_BT_HSG_SERVER_CONFIG mfw_config);
EXTERN T_MFW_BT_RESULT_BT bt_reconfig_profile_dun (T_MFW_BT_SERVICE_TYPE service,
                                                T_MFW_BT_DUN_CONFIG dun_filter);

/* Searching devices/services */
EXTERN T_MFW_BT_RESULT_BT bt_device_search(void);
EXTERN T_MFW_BT_RESULT_BT bt_service_search(T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT bt_extended_search(UINT8 inq_length,
                     UINT8                  max_num_of_responses,
                     T_MFW_DEVICE_CLASS  class_of_device[],
                     BOOLEAN                need_device_name,
                     BOOLEAN                need_services,
                     T_MFW_SERVICE_ID       service_id);
EXTERN T_MFW_BT_RESULT_BT bt_search_abort(void);


EXTERN T_MFW_BT_RESULT_BT  bt_connect_hsg (T_MFW_BT_SERVICE_TYPE service,
                                    T_MFW_BT_REQ_ID req_id,
                                    T_MFW_BT_BD_ADDR bd_addr[], UINT8 mode);
EXTERN T_MFW_BT_RESULT_BT bt_auto_connect(T_MFW_BT_SERVICE_TYPE service,
                                       T_MFW_BT_AUTO_CONNECT_STATE set_state);
EXTERN T_MFW_BT_RESULT_BT bt_get_auto_connect(T_MFW_BT_SERVICE_TYPE service,
                                           T_MFW_BT_HSG_CLIENT_CONFIG *conf);
EXTERN T_MFW_BT_RESULT_BT bt_set_pref_headset(T_MFW_BT_SERVICE_TYPE service,
                                       T_MFW_BT_BD_ADDR bd_addr[],
                                       T_MFW_BT_HSG_NAME hsg_name[],
                                       T_MFW_BT_PRIORITY priority,
                                       BOOL rem_audio_ctr_supp_hsg,
                                       T_MFW_BT_CNF_ID * headset_cnf_id);
EXTERN T_MFW_BT_RESULT_BT  bt_reset_pref_hsg(T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_DEV_ID dev_id);

EXTERN T_MFW_BT_RESULT_BT bt_disconnect_service (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT bt_send_pin (T_MFW_BT_BD_ADDR bd_addr[],
                                    T_MFW_BT_PIN pin_code[],
                                    T_MFW_BT_PIN_MODE pin_mode);
EXTERN T_MFW_BT_RESULT_BT bt_authorization_reply (T_MFW_BT_BD_ADDR bd_addr[],
                                                  T_MFW_BT_AUTHORIZATION_MASK mfw_auth_mask,
                                                  T_MFW_BT_AUTHORIZATION_MODE auth_mode);
EXTERN T_MFW_BT_RESULT_BT bt_get_authorization_device (T_MFW_BT_BD_ADDR bd_addr[],
                                            T_MFW_BT_AUTHORIZATION_MASK * mask);
EXTERN T_MFW_BT_RESULT_BT bt_set_authorization_device (T_MFW_BT_BD_ADDR bd_addr[],
                                            T_MFW_BT_AUTHORIZATION_MASK mask);
EXTERN T_MFW_BT_RESULT_BT bt_del_authorizations_device (T_MFW_BT_BD_ADDR bd_addr[]);
EXTERN T_MFW_BT_RESULT_BT bt_del_authorization (T_MFW_BT_BD_ADDR bd_addr[],T_MFW_BT_AUTHORIZATION_MASK service_mask);
#ifdef _SIMULATION_
EXTERN T_MFW_BT_RESULT_BT bt_transfer_audio_in (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT bt_transfer_audio_out(T_MFW_BT_SERVICE_TYPE service,
                                             T_MFW_BT_REQ_ID req_id,
                                             T_MFW_BT_BD_ADDR bd_addr[]);
#endif
EXTERN T_MFW_BT_RESULT_BT bt_set_param_headset (T_MFW_BT_SERVICE_TYPE service,
                                         T_MFW_BT_PARAM_NUMBER nb,
                                         T_MFW_BT_CHANGE_PARA type,
                                         U16 new_value);
EXTERN T_MFW_BT_RESULT_BT bt_get_default_service_info (T_MFW_BT_SERVICE_TYPE service,
                                            T_MFW_BT_DEV_ID dev_id,
                                            T_MFW_BT_HEADSET_INFO *hs_info);
EXTERN T_MFW_BT_RESULT_BT bt_set_prio_default_service (T_MFW_BT_SERVICE_TYPE service,
                                                    T_MFW_BT_DEV_ID dev_id,
                                                    T_MFW_BT_PRIORITY priority);
EXTERN T_MFW_BT_RETURN  bt_list_paired_dev(T_MFW_BT_DEV_PAIR_LIST * pair_list);
EXTERN T_MFW_BT_RETURN  bt_list_auth_dev(T_MFW_BT_AUTHORIZATION_LIST * authorization_list);
EXTERN T_MFW_BT_RETURN  bt_clear_all_lists_found_serv (void);
EXTERN T_MFW_BT_RETURN  bt_clear_list_found_dev (void);
EXTERN T_MFW_BT_RETURN  bt_clear_list_found_serv (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RETURN  bt_authorized_devices(T_MFW_BT_AUTHORIZATION_LIST * authorization_list,T_MFW_BT_AUTHORIZATION_MASK service_mask );
EXTERN void             bt_signal             (MfwEvt event, void *para);
EXTERN int              bt_sign_exec          (T_MFW_HDR * hdr,T_MFW_EVENT event,
                                               T_MFW_BT_PARA *para);
EXTERN T_MFW_BT_RESULT_BT  bt_get_config (T_MFW_BT_SERVICE_TYPE service,
                                T_MFW_BT_HSG_CLIENT_CONFIG *client_conf,
                                T_MFW_BT_HSG_SERVER_CONFIG *server_conf);
#ifdef _SIMULATION_
EXTERN T_MFW_BT_RESULT_BT  bt_save_config (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT  bt_restore_config (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT  bt_save_default_list (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT  bt_restore_default_list (T_MFW_BT_SERVICE_TYPE service);
#endif
EXTERN T_MFW_BT_RESULT_BT  bt_set_security_mode (T_MFW_BT_SECURITY_MODE sec_mode);
EXTERN T_MFW_BT_RESULT_BT  bt_set_pair_mode (T_MFW_BT_PAIRABLE_MODE pair_mode);
EXTERN T_MFW_BT_RESULT_BT  bt_start_profile_application (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT  bt_stop_profile_application (T_MFW_BT_SERVICE_TYPE service);
EXTERN T_MFW_BT_RESULT_BT  bt_set_default_security (U8 security_level);
EXTERN T_MFW_BT_RESULT_BT  bt_start_pairing (T_MFW_BT_BD_ADDR bd_addr[],
                                          T_MFW_BT_PIN pin_code[],
                                          T_MFW_BT_PIN_MODE pin_mode);
EXTERN T_MFW_BT_RESULT_BT bt_delete_paired_device (T_MFW_BT_BD_ADDR bd_addr[]);
EXTERN T_MFW_BT_RESULT_BT bt_check_pair (T_MFW_BT_BD_ADDR bd_addr[]);
EXTERN T_MFW_BT_RESULT_BT bt_register_sm (void);
EXTERN T_MFW_BT_RESULT_BT bt_deregister_sm(void);
EXTERN T_MFW_BT_RESULT_BT bt_init_profile_fax (T_MFW_BT_SERVICE_TYPE service,
                                     T_MFW_BT_FAX_CONFIG fax_filter);
EXTERN T_MFW_BT_RESULT_BT bt_reconfig_profile_fax (T_MFW_BT_SERVICE_TYPE service,
                                     T_MFW_BT_FAX_CONFIG fax_filter);

EXTERN T_MFW_BT_RESULT_BT bt_init_profile_opp (T_MFW_BT_SERVICE_TYPE service,
                                        T_MFW_BT_SUBTYPE_DEV subtype,
                                        T_MFW_BT_OPP_SERVER_CONFIG serv_config);
EXTERN T_MFW_BT_RESULT_BT bt_reconf_profile_opp (T_MFW_BT_SERVICE_TYPE service,
                                        T_MFW_BT_SUBTYPE_DEV subtype,
                                        T_MFW_BT_OPP_SERVER_CONFIG serv_config);
EXTERN T_MFW_BT_RESULT_BT bt_opp_put_reply (  T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_OPP_PUT_RES opp_put_res,
                                      T_MFW_BT_OPP_OBJECT received_obj);
EXTERN T_MFW_BT_RESULT_BT bt_opp_push_object (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_BD_ADDR server_address[],
                                      BOOL mfw_keep_connection,
                                      T_MFW_BT_OPP_OBJECT mfw_obj_to_push);
EXTERN T_MFW_BT_RESULT_BT bt_opp_pull_object (T_MFW_BT_SERVICE_TYPE service,
                                       T_MFW_BT_SUBTYPE_DEV subtype,
                                       T_MFW_BT_BD_ADDR server_address[],
                                       BOOL mfw_keep_connection,
                                       T_MFW_BT_OPP_OBJECT mfw_obj_to_pull);
EXTERN T_MFW_BT_RESULT_BT bt_opp_exch_objects (T_MFW_BT_SERVICE_TYPE service,
                                        T_MFW_BT_SUBTYPE_DEV subtype,
                                        T_MFW_BT_OPP_OBJECT obj_to_push,
                                        T_MFW_BT_OPP_OBJECT obj_to_pull,
                                        T_MFW_BT_BD_ADDR server_address[],
                                        BOOL mfw_keep_connection);
EXTERN T_MFW_BT_RESULT_BT bt_init_profile_syn_s (T_MFW_BT_SERVICE_TYPE service,
                                          T_MFW_BT_SUBTYPE_DEV subtype,
                                  T_MFW_BT_SYN_OBJECT_STORE_LIST list_availabe_objects,
                                  T_MFW_BT_SYNC_SERVER_CONFIG mfw_config);
EXTERN T_MFW_BT_RESULT_BT bt_reconf_profile_syn_s (T_MFW_BT_SERVICE_TYPE service,
                                          T_MFW_BT_SUBTYPE_DEV subtype,
                                  T_MFW_BT_SYN_OBJECT_STORE_LIST list_availabe_objects,
                                  T_MFW_BT_SYNC_SERVER_CONFIG mfw_config);
EXTERN T_MFW_BT_RESULT_BT bt_syn_s_send_com (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_SYNC_COMMAND sync_comm,
                                      T_MFW_BT_SYN_OBJECT_STORE sync_object,
                                      T_MFW_BT_BD_ADDR sync_client_address[]);
EXTERN T_MFW_BT_RESULT_BT bt_syn_s_auth_res (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_SYN_PASSWD * mfw_sync_password);
EXTERN T_MFW_BT_RESULT_BT bt_syn_s_sync_terminate (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype);
EXTERN T_MFW_BT_RESULT_BT bt_syn_s_pull_resp (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_SYNC_OBJECT mfw_syn_pull_obj);
EXTERN T_MFW_BT_RESULT_BT bt_syn_s_push_resp (T_MFW_BT_SERVICE_TYPE service,
                                      T_MFW_BT_SUBTYPE_DEV subtype,
                                      T_MFW_BT_SYNC_OBJECT mfw_syn_push_obj);
EXTERN T_MFW_BT_RESULT_BT bt_is_pref_headset(T_MFW_BT_SERVICE_TYPE service,
                                       T_MFW_BT_BD_ADDR bd_addr[],
                                       T_MFW_BT_CNF_ID * headset_cnf_id);
/* BT CTRL */

EXTERN T_MFW_BT_RESULT_BT bt_set_conn_mode(T_MFW_BT_CONNECTABLE_MODE cmode,
                                  UINT16 scan_interval,
                                  UINT16 scan_window);


EXTERN T_MFW_BT_RESULT_BT bt_set_disc_mode(T_MFW_BT_DISCOVERABLE_MODE dmode,
                                  UINT16 scan_interval,
                                  UINT16 scan_window);

EXTERN T_MFW_BT_RESULT_BT bt_get_local_name(void);
EXTERN T_MFW_BT_RESULT_BT bt_set_local_name(T_MFW_BT_BD_NAME name[]);
EXTERN T_MFW_BT_RESULT_BT bt_get_bd_addr(void);

EXTERN T_MFW_BT_RESULT_BT bt_get_remote_dev_info(T_MFW_BT_BD_ADDR bd_addr[]);
EXTERN T_MFW_BT_RESULT_BT bt_start_btctrl(void);
EXTERN T_MFW_BT_RESULT_BT bt_stop_btctrl(void);

/* enable profiles */
EXTERN T_MFW_BT_RESULT_BT bt_enable_hsg_profile(void);
EXTERN T_MFW_BT_RESULT_BT bt_enable_dun_profile(void);
EXTERN T_MFW_BT_RESULT_BT bt_enable_fax_profile(void);

EXTERN T_MFW_BT_RESULT_BT bt_hsg_client_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_hsg_server_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_dun_gw_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_fax_gw_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_opp_client_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_opp_server_disable(void);
EXTERN T_MFW_BT_RESULT_BT bt_syn_server_disable(void);

/*#ifdef PCA_6350*/
EXTERN T_MFW_BT_RESULT_BT bt_pca_gw_enable(void);
EXTERN T_MFW_BT_RESULT_BT bt_pca_gw_config(T_MFW_BT_PCA_CONFIG event_filters);
EXTERN T_MFW_BT_RESULT_BT bt_pca_gw_security(UINT8 security_level);
EXTERN T_MFW_BT_RESULT_BT bt_pca_gw_hangup(void);
EXTERN T_MFW_BT_RESULT_BT bt_pca_gw_disable(void);

/*#endif*/ /* PCA_6350 */

/* Cartman added begin */

EXTERN T_MFW_BT_RESULT_BT bt_hsg_connect_network (T_MFW_BT_HSG_CONNECT_NETWORK_ANSWER network_answer,
                                                  T_MFW_BT_HSG_CONNECT_NETWORK_TYPE network_type,
                                                  T_MFW_BT_HSG_PHONE_NUMBER phone_nb[]);
EXTERN T_MFW_BT_RESULT_BT bt_hsg_send_specific_cmd_to_hs (T_MFW_BT_HSG_SPECIFIC_CMD_TYPE command_type,
                                                  T_MFW_BT_HSG_CMD_TO_HS cmd[]);
EXTERN T_MFW_BT_RESULT_BT bt_dun_gw_security (UINT8  security_level);
EXTERN T_MFW_BT_RESULT_BT bt_opp_client_security (UINT8  security_level);
EXTERN T_MFW_BT_RESULT_BT bt_opp_server_security (UINT8  security_level);

/* Cartman added end */

#endif
