#
#	Setting Directory for Layer4 Objects
#
#OBJ := $(L23_OBJ_DIR)/mfw
TARID := mfw$(NSRVC)$(NTK)$(NWAP)$(NBT)$(NCOMPTRC)$(NUNIC)$(NEM)
OBJ := $(CONDAT_DIR)/obj/obj_$(TARID)

#containing compileroptions specific for this library
SPECOPT = $(FDOPT) $(MMIOPT) $(BTOPT) $(CPHSOPT)

# must not be empty. set to "-D" for no local flags.
#MY_OPTIONS = -D
MY_OPTIONS = -DUMTS -DTARGET -D_RVF -DFF_SAT_E -DFF_2TO1_PS

#INCLAYER4 = -I$(SRCMFW)  -I$(SRCACI)  -I$(SRCSMI) -I$(SRCKSD) $(INCBTI)
INCLAYER4 = -I$(SRCMFW)  -I$(SRCACI)  -I$(SRCACIDTI)  -I$(SRCACIEXT)  -I$(SRCSMI) -I$(SRCKSD) $(INCBTI)

SRCOBJ = $(MFWOBJ)
SRCATB = $(CONDAT_DIR)/ms/src/atb
# New editor. 1 -> Compile. 0 -> Don't compile, compile old editor.
NEWED = 1

#
# Sim apllication setting
#	
ifeq ($(TK),1)
COPT1 += -dSIM_TOOLKIT
else
COPT1 += -uSIM_TOOLKIT
endif

#
# Support for light version
#
#JVJ-SPR-1298. Provisional until a new option in the .inf file is inserted.

ifeq ($(SRVC),0)
COPT1 += -dMMI_LITE
else
COPT1 += -uMMI_LITE
endif



#SMS PDU mode settings	
ifeq ($(PDU),1)
COPT1 += -dSMS_PDU_SUPPORT
else
COPT1 += -uSMS_PDU_SUPPORT
endif

#
# Support for UNICODE
#	
ifeq ($(UNIC),1)
COPT1 += -dNO_ASCIIZ
endif

# Support for MMI gprs
ifeq ($(PMODE),2)
COPT1 += -dMMI_GPRS_ENABLED
else
COPT1 += -uMMI_GPRS_ENABLED
endif

#
# Internal Phonebook
# Currently always on
#
#ifeq ($(INTPB),1)
COPT1 += -dINT_PHONEBOOK
#else
#COPT1 += -uINT_PHONEBOOK
#endif

#
# New editor (SPR#1428 - SH)
#
ifeq ($(NEWED),1)
COPT1 += -dNEW_EDITOR
else
COPY1 += -uNEW_EDITOR
endif

#
# Begin MFW
#
ifeq ($(TK),0)
MFWOBJ := $(OBJ)/ti1_key.$(OBJ_TAIL) \
	$(OBJ)/ti1_tmr.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mfw.$(OBJ_TAIL) \
	  $(OBJ)/mfw_win.$(OBJ_TAIL) \
	  $(OBJ)/mfw_kbd.$(OBJ_TAIL) \
	  $(OBJ)/mfw_tim.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mnu.$(OBJ_TAIL) \
	  $(OBJ)/mfw_icn.$(OBJ_TAIL)	$(OBJ)/mfw_ext.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cm.$(OBJ_TAIL)	$(OBJ)/mfw_ss.$(OBJ_TAIL) \
	  $(OBJ)/mfw_nm.$(OBJ_TAIL)	$(OBJ)/mfw_nma.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sim.$(OBJ_TAIL)	$(OBJ)/mfw_sima.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sms.$(OBJ_TAIL)	$(OBJ)/mfw_phb.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mme.$(OBJ_TAIL)	$(OBJ)/mfw_cb.$(OBJ_TAIL)  \
	  $(OBJ)/mfw_acie.$(OBJ_TAIL)	$(OBJ)/mfw_lng.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cnvt.$(OBJ_TAIL)	$(OBJ)/mfw_cphs.$(OBJ_TAIL) \
	  $(OBJ)/mfw_str.$(OBJ_TAIL)	$(OBJ)/mfw_ffs.$(OBJ_TAIL) \
	  $(OBJ)/CPHS_mod.$(OBJ_TAIL) $(OBJ)/mfw_band.$(OBJ_TAIL) \
	  $(OBJ)/mfw_utils.$(OBJ_TAIL)	$(OBJ)/mfw_aud.$(OBJ_TAIL) \
	  $(OBJ)/mfw_td.$(OBJ_TAIL) $(OBJ)/mfw_cam.$(OBJ_TAIL)
else
MFWOBJ := $(OBJ)/ti1_key.$(OBJ_TAIL) \
		$(OBJ)/ti1_tmr.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mfw.$(OBJ_TAIL) \
	  $(OBJ)/mfw_win.$(OBJ_TAIL) \
	  $(OBJ)/mfw_kbd.$(OBJ_TAIL) \
	  $(OBJ)/mfw_tim.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mnu.$(OBJ_TAIL) \
	  $(OBJ)/mfw_icn.$(OBJ_TAIL) \
	  $(OBJ)/mfw_ext.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cm.$(OBJ_TAIL) \
	  $(OBJ)/mfw_ss.$(OBJ_TAIL) \
	  $(OBJ)/mfw_nm.$(OBJ_TAIL) \
	  $(OBJ)/mfw_nma.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sim.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sima.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sms.$(OBJ_TAIL) \
	  $(OBJ)/mfw_phb.$(OBJ_TAIL) \
	  $(OBJ)/mfw_mme.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cb.$(OBJ_TAIL)  \
	  $(OBJ)/mfw_acie.$(OBJ_TAIL) \
	  $(OBJ)/mfw_sat.$(OBJ_TAIL) \
	  $(OBJ)/mfw_lng.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cnvt.$(OBJ_TAIL) \
	  $(OBJ)/mfw_cphs.$(OBJ_TAIL) \
	  $(OBJ)/mfw_str.$(OBJ_TAIL) \
	  $(OBJ)/mfw_ffs.$(OBJ_TAIL) \
	  $(OBJ)/mfw_band.$(OBJ_TAIL) \
	  $(OBJ)/mfw_utils.$(OBJ_TAIL) \
	  $(OBJ)/mfw_aud.$(OBJ_TAIL) \
	  $(OBJ)/mfw_td.$(OBJ_TAIL) \
#	  $(OBJ)/mfw_mp3test.$(OBJ_TAIL) \
#      $(OBJ)/mfw_cam.$(OBJ_TAIL)

endif

# SH - Only compile mfw_edt if new editor is not defined
ifeq ($(NEWED),0)
MFWOBJ += $(OBJ)/mfw_edt.$(OBJ_TAIL)
endif

ifeq ($(BT),2)
MFWOBJ += $(OBJ)/mfw_bt.$(OBJ_TAIL)    $(OBJ)/mfw_bta.$(OBJ_TAIL)
endif

ifeq ($(EM),1)
MFWOBJ +=	$(OBJ)/mfw_em.$(OBJ_TAIL) #SPR1209
endif
#
# Add necessary GPRS modules when GPRS is requested
#
ifeq ($(PMODE),2)
MFWOBJ += $(OBJ)/mfw_gprs.$(OBJ_TAIL)
endif


#
# Common files for ATB
#
ifeq ($(NEWED),1)
MFWATBOBJ :=$(OBJ)/ATBCommon.$(OBJ_TAIL) \
	$(OBJ)/ATBDisplay.$(OBJ_TAIL)
endif


#
# New Editor
#
ifeq ($(NEWED),1)
MFWATBOBJ += $(OBJ)/ATBEditor.$(OBJ_TAIL)
endif

#
# Internal phonebook
# Currently always on
#
#ifeq ($(INTPB),1)
MFWATBOBJ += $(OBJ)/ATBPb.$(OBJ_TAIL) \
	$(OBJ)/ATBPbGI.$(OBJ_TAIL) \
	$(OBJ)/ATBPbFS.$(OBJ_TAIL)
#endif

#
# End MFW
#


#
# Creating mfw.lib
#


$(TOP_DIR)/$(MFW_LIB) : $(OBJ) $(SRCOBJ) $(MFWATBOBJ)
	-$(PERL) $(CONDAT_DIR)/int/bin/make_ver.pl
	$(AR) r $(TOP_DIR)/$(MFW_LIB) $(SRCOBJ) $(MFWATBOBJ) ver.$(OBJ_TAIL)

$(OBJ): 
	mkdir $(subst /,$(SLASH),$(OBJ))
	
clean: 
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))


$(MFWOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCMFW)/%.c
	echo -D$(NCONFIG) >  cmd
	echo $(MY_OPTIONS) >> cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCATB) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCACIDTI) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(MFWATBOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCATB)/%.c
	echo -D$(NCONFIG) >  cmd
	echo $(MY_OPTIONS) >> cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo $(SPECOPT) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(SRCATB) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd
