#ifndef _CPHS_H_
#define _CPHS_H_
/*-----------------------------------------------------------------------*
 *                                                                       *
 *     CPHS / SIM lock  Standalone module                                                  *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*
 *     CPHS Part                                                         *
 *-----------------------------------------------------------------------*/


/*---- Constants --------------------------------------------------------*/
#define CPHS_CSP_SIZE 20

/*---- Types ------------------------------------------------------------*/

#define SHORT short
#define UBYTE unsigned char
#define BYTE unsigned char
#define BOOL UBYTE


typedef enum              /* SIM operation status */
{
 	SIMOP_UNKNOWN = 20,
 	SIMOP_WRITE_ERR,
  	SIMOP_WRITE_OK,
 	SIMOP_READ_ERR,
  	SIMOP_READ_OK
} T_CPHS_SIMOP_STATUS;

typedef enum
{
  CPHS_FAIL = -1,
  CPHS_NOT_PRESENT,
  CPHS_IS_OK,
  CPHS_EXEC,
  CPHS_NOT_INIT,
  CPHS_SIM_READ_ERROR,
  CPHS_SIM_WRITE_ERROR
} T_CPHS_RET; 			//function return status

typedef enum			//line identifier values
{
  CPHS_LINE_INDEX_LINE1 = 1,
  CPHS_LINE_INDEX_LINE2 = 2,
  CPHS_LINE_INDEX_FAX   = 4,
  CPHS_LINE_INDEX_DATA  = 8
} T_CPHS_LINE_INDEX;

typedef enum			//Roaming indicator values
{
  CPHS_ROAMING_OFF,
  CPHS_ROAMING_ON
} T_CPHS_ROAMING_IND;


typedef enum					//Voicemail/divert status flags
{
  CPHS_FLAG_NOT_PRESENT = -1,
  CPHS_LINEFLAG_NOT_SET,
  CPHS_LINEFLAG_SET
} T_CPHS_FLAG_STATUS;


typedef enum					//possible emergency numbers
{
  CPHS_EMERGENCY_NUM_112 = 112,
  CPHS_EMERGENCY_NUM_999 = 999
} T_CPHS_EMERGENCY_NUM;

typedef struct					//format of text strings
{
  UBYTE len;
  //UBYTE* data;
  UBYTE data[22];
} T_CPHS_DATA;



typedef struct		//status of lines for voicemail/divert 
{
	UBYTE result;      //result of read/write op
  T_CPHS_FLAG_STATUS line1;
  T_CPHS_FLAG_STATUS line2;
  T_CPHS_FLAG_STATUS fax;
  T_CPHS_FLAG_STATUS data;
} T_CPHS_LINE_IND;

typedef struct				//ALS selected line 
{
  UBYTE result;
  T_CPHS_LINE_INDEX  line;
  T_CPHS_FLAG_STATUS locked;
} T_CPHS_ALS_INFO;

typedef struct				//ALS line description
{
  UBYTE result;
  T_CPHS_LINE_INDEX  line;
  T_CPHS_DATA        description;
} T_CPHS_ALS_LINE;

typedef struct			//operator name in long and short forms
{
  UBYTE result;
  T_CPHS_DATA long_name;
  T_CPHS_DATA short_name;
} T_CPHS_OPN;



typedef struct			//CPHS config info
{
  UBYTE phase;
  BOOL  opn_short;
  BOOL  mailbox_num;
  BOOL  sst;
  BOOL  csp;
  BOOL  info_num;
} T_CPHS_INFO;

typedef struct				//single Customer service profile entry
{
  UBYTE group_code;
  UBYTE services;
} T_CPHS_CSP_ENTRY;

typedef struct				//customer service Profile
{
	UBYTE result; //Result of last read/write
  T_CPHS_CSP_ENTRY csp[CPHS_CSP_SIZE];
  //UBYTE csp[CPHS_CSP_SIZE];
} T_CPHS_CSP;

typedef struct				//single mailbox entry
{
  UBYTE       index;
  T_CPHS_DATA alpha;
  UBYTE number[22];
  UBYTE       ton;
  UBYTE       npi;
  UBYTE       service;
} T_CPHS_MAILBOX_NUM_ENTRY;

typedef struct				//mailbox entries 
{
  UBYTE 					result; //read/write result
  UBYTE                     count;
 // T_CPHS_MAILBOX_NUM_ENTRY *entries;
 T_CPHS_MAILBOX_NUM_ENTRY entries[4];
} T_CPHS_MAILBOX_NUM_LIST;



typedef struct					//single information number list entry
{
  UBYTE       index;
  T_CPHS_DATA alpha;
  UBYTE       entryStat;
} T_CPHS_INFO_NUM;

typedef struct				//information number
{ 
  UBYTE		entryStat;
  UBYTE 		result; //result of last read/write op
  UBYTE       index;
  T_CPHS_DATA alpha;
  UBYTE number[22];
  UBYTE       ton;
  UBYTE       npi;
} T_CPHS_INFO_NUM_ENTRY;

typedef struct			//information number list
{
  UBYTE 				count; //no of entries
  UBYTE                  level;
  UBYTE                  index;
  //T_CPHS_INFO_NUM       *entry;
  T_CPHS_INFO_NUM       entry[10];
} T_CPHS_INFO_NUM_LIST;


//Callback function type
typedef int (*T_CPHS_CB_FUNC) (T_CPHS_INFO_NUM_LIST *,T_CPHS_INFO_NUM_ENTRY *);


/*---- Functions --------------------------------------------------------*/

  /* all CPHS functions return the following values:                     */
  /*                                                                     */
  /*   CPHS_OK                : on successfull execution                 */
  /*   CPHS_EXEC              : if CPHS operation is still executing     */
  /*   CPHS_NOT_INIT          : if a CPHS function is called before the  */
  /*                            CPHS initialize function has been called */
  /*   CPHS_NOT_PRESENT       : if current function is not present for   */
  /*                            current SIM                              */
  /*   CPHS_SIM_READ_ERROR    : on SIM read operation failure            */
  /*   CPHS_SIM_WRITE_ERROR   : on SIM read operation failure            */
  /*   CPHS_FAIL              : on other failures                        */



  /* set the roaming indicator                                           */




T_CPHS_RET cphs_Init(T_CPHS_CB_FUNC callback);
  /* initializes CPHS module, reads CPHS data fields from SIM and caches */
  /* the read data.   */


T_CPHS_RET cphs_refresh(T_CPHS_CB_FUNC callback);
  /* reads CPHS data fields from SIM and updates the cached CPHS data    */

T_CPHS_RET cphs_Exit();
  /* de-initializes CPHS module                                          */



T_CPHS_RET cphs_getOPN            ( T_CPHS_OPN* opn );
  /* reads from SIM the operator long name and if available the short    */
  /* name, too                                                          */


T_CPHS_RET cphs_setDivertCallInd  ( UBYTE              line_mask,
                                    T_CPHS_FLAG_STATUS flag );
  /* sets on SIM the divert call flag for the given lines in the         */
  /* parameter line_mask. The bitmask will be created by oring the lines.*/
  /* The bits for the lines are defined in T_CPHS_LINE_INDEX.            */



T_CPHS_RET cphs_getAlsInfo        ( T_CPHS_ALS_INFO *info );
  /* reads from SIM the information of alternate line service            */
  /* ( selected line, alternate line service locked/unlocked)            */

T_CPHS_RET cphs_setAlsInfo        ( T_CPHS_ALS_INFO *info );
  /* sets on SIM the informtion of alternate line service / selects the  */
  /* active line                                                         */
  
T_CPHS_RET cphs_setRoamingInd  ( T_CPHS_ROAMING_IND* indicator );

  
T_CPHS_RET cphs_getAlsLineDescr   ( T_CPHS_ALS_LINE* line );
  /* reads the (alpha)numeric description for the given line             */

T_CPHS_RET cphs_setAlsLineDescr   ( T_CPHS_ALS_LINE line );
  /* sets a (alpha)numeric description for the given line                */
  
T_CPHS_RET cphs_getRoamingInd     ( T_CPHS_ROAMING_IND* indicator );
  /* checks if roaming is active 
  */

/* reads from SIMif calls shall be diverted for the available lines    */
  /* (line1, line2, fax, data)                                           */
T_CPHS_RET cphs_getDivertCallInd  ( T_CPHS_LINE_IND* indicator );



T_CPHS_RET cphs_getVoiceMessageInd( T_CPHS_LINE_IND* indicator);
  /* reads from SIM if voice mails are waiting for the available lines   */
  /* (line1, line2, fax, data)                                           */

T_CPHS_RET cphs_setVoiceMessageInd( UBYTE              line_mask,
                                    T_CPHS_FLAG_STATUS flag );
  /* sets on SIM the voice mail waiting flag for the given lines in the  */
  /* parameter line_mask. The bitmask will be created by oring the lines.*/
  /* The bits for the lines are defined in T_CPHS_LINE_INDEX.            */




T_CPHS_RET cphs_checkEmergencyCall( char* num );
/* check if the current call number(ASCII encoded) is an emergency number supported     */
/* by CPHS.                                                              */



T_CPHS_RET cphs_getCPHSInfo       ( T_CPHS_INFO *info );
  /* reads from SIM the phase of the SIM and which optional datafields   */
  /* are present in the SIM                                              */
  /* (operator name shortform, mailbox numbers, service string table,    */
  /*  information numbers)                                               */



T_CPHS_RET cphs_getCSP            ( T_CPHS_CSP *csp );
  /* reads all entries of the customer service profile and fills         */



T_CPHS_RET cphs_getMailboxNumbers ( T_CPHS_MAILBOX_NUM_LIST *nums );
  /* reads all mailbox numbers from the SIM fills all mailbox number     */
  /* entries in the mailbox number list                                  */



T_CPHS_RET cphs_getInfoNumbers    ( T_CPHS_INFO_NUM_LIST *nums, UBYTE level, UBYTE startIndex, T_CPHS_CB_FUNC callback);
  // reads all information numbers from the SIM fills all information    
  // numbers into the array of pointers at the directory level specified from the specified
  //index until an entry of a different level is encountered
  //The callback function is called when the list has been retrieved from the SIM and is passed
  //the list as a parameter
  //e.g. cphs_getInfoNumbers(NumberList, 1, 1, callback_func) would get the first level
  //in the information numbers list
  //to get the directory below an item in this list, you'd have to read the entry index and
  //call cphs_getInfoNumbers(NewNumberList, entry_level+1, entry_index+1, callback_func), as
  //directory contents are stored right after the directory heading.
  //The MSB of the entryStat field in a info number list entry is set to 1 if it is a number
  //and 0 if it is a directory heading.
  

T_CPHS_RET cphs_selectInfoNumber  ( USHORT                 index,
                                    T_CPHS_INFO_NUM_ENTRY *num, T_CPHS_CB_FUNC callback);
  // reads the information number entry given by index from    */
  // the SIM   */                                                          */
  //The index of a desired entry can be found in the "index" field of that entry in a previously
  //retrieved information number list


 


/*-----------------------------------------------------------------------*
 *       SIMLOCK Part                                                    *
 *-----------------------------------------------------------------------*/


/*---- Predefined Values ------------------------------------------------*/

#define SIMLOCK_PWD_MAX_LEN       16
#define SIMLOCK_PWD_MIN_LEN_SIM    6
#define SIMLOCK_PWD_MIN_LEN_OTHER  8


/*---- Types ------------------------------------------------------------*/

typedef enum
{
  SIMLOCK_FAIL = -1,
  SIMLOCK_ENABLE,
  SIMLOCK_DISABLE,
  SIMLOCK_LOCKED,
  SIMLOCK_BLOCKED
} T_SIMLOCK_RET;

typedef enum
{
  SIMLOCK_NETWORK = 0,
  SIMLOCK_NETWORK_SUBSET,
  SIMLOCK_SERVICE_PROVIDER,
  SIMLOCK_CORPORATE,
  SIMLOCK_SIM,
  SIMLOCK_FIRST_SIM
} T_SIMLOCK_TYPE;


/*---- Functions --------------------------------------------------------*/

//T_SIMLOCK_RET simlock_checkLock   ( T_SIMLOCK_TYPE type );
/* checks the lock status of the given lock type. On successfull check   */
/* the status will be returned. If an error occured SIMLOCK_FAIL will    */

//#define _TESTING__
#ifdef _TESTING__
void Cphs_reading_test();
void Cphs_writing_test();
#endif

#endif //_CPHS_H_

