
/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMI Project                                                     
 $Project code:	BMI (6349)                                                           
 $Module:		MMI
 $File:		    MmiWindow.c
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    28/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMI window
    application modules.
   
********************************************************************************
 $History: MmiWindow.c

    CRR 23959: xpradipg 26 Aug 2004
    Description: List not updated after deleting the messages in Unsent/Inbox folder
    Solution: The list is refreshed everytime the user returns from the options menu
    
	13 Aug 2004			xreddymn: Extended MFW to support Suspend and Resume of third-party applications
	28/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/
#define MMI_MMIWINDOW_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"

#include "psa_util.h"

#include "dspl.h"
// #include "unicode_types.h"

#include "MmiMain.h"
#include "MmiDummy.h"
//#include "MmiLists.h"
#include "MmiMmi.h"
#include "mmiCall.h"//GW 29/11/01 for 'callNumber'

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
//#include "MmiEditor.h"
#include "MmiBookShared.h" // MZ 
#include "mfw_ffs.h"
#include "mmiwindow.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "aci_cmh.h"	//GW 29/11/01 added for types in aci_fd.h
#include "aci_fd.h"		//GW 29/11/01 added for types in 'cmh.h'
#include "cmh.h" 		//GW 29/11/01 added for types in 'cmh_phb.h'
#include "cmh_phb.h"	//GW 29/11/01 added for cmhPHB_getAdrStr

#include "mmiColours.h"

//GW 29/11/01 - added header file - removed extern void callNumber(UBYTE* number);
extern MfwWin* getWinData( MfwHnd win);

/*********************************************************************

				 DYNAMIC MENU WINDOW. DECLARATION

**********************************************************************/
//CRR 23959 - xpradipg 26 Aug 2004
//moved the structure declaration to mmiwindow.h

static T_MMIWINDOW* getUserData_T_MMIWINDOW( T_MFW_WIN *win)
{
	if (win == NULL)
		return (NULL);
	return((T_MMIWINDOW *)win->user);
}


/*******************************************************************************

 $Function:    	MMIWindow_win_cb

 $Description:	Window callback function of the MMI window
 
 $Returns:		none

 $Arguments:	w - mfw window handler
 			e - mfw event
 				
*******************************************************************************/

static int MMIWindow_win_cb (MfwEvt e, MfwWin *w) 
{
	T_MMIWINDOW* data     = (T_MMIWINDOW *)w->user;
	TRACE_FUNCTION ("MMIWindow_win_cb()");
	switch (e)
	{
	case MfwWinVisible:  /* window is visible  */	    
		SEND_EVENT(data->win,MWM_ONDRAW,0,0 );
		break;
		
	/* xreddymn Aug-09-2004, MMI-SPR-23964 (TII_MMS33) 
	 * Implemented suspend and resume functionality for MFW windows
	 * The following code posts SUSPEND event
	 */
	case MfwWinSuspend:  /* window is suspended  */
		SEND_EVENT(data->win,MWM_SUSPEND,0,0 );
		break;

	/* xreddymn Aug-09-2004, MMI-SPR-23964 (TII_MMS33) 
	 * Implemented suspend and resume functionality for MFW windows
	 * The following code posts RESUME event
	 */
	case MfwWinResume: 	/* window is resumed */
		SEND_EVENT(data->win,MWM_RESUME,0,0 );
		break;

	case MfwWinFocussed: /* input focus / selected   */	
	case MfwWinDelete:   /* window will be deleted   */        
	default:	    
		return MFW_EVENT_REJECTED;
	}
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMIWindow_kbd_cb

 $Description:	keyboard callback function for the MMI window 
 
 $Returns:		execution status

 $Arguments:	e - event id
 			k - keyboard info
*******************************************************************************/

int MMIWindow_kbd_cb (MfwEvt e, MfwKbd *k)
    /* SmsRead_R_OPT keyboard event handler */
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    T_MFW_WIN  * win_data = ((T_MFW_HDR *)win)->data;
    T_MMIWINDOW      * data = (T_MMIWINDOW *)win_data->user;

    TRACE_FUNCTION ("MMIWindow_kbd_cb()");
 
    if (e & KEY_LONG)
	{
	    switch (k->code)
		{
		case KCD_HUP: /* back to previous menu */
		    mnuEscape(data->menu);
		    break;
		case KCD_RIGHT: /* Power Down */
		    return MFW_EVENT_REJECTED; /* handled by idle */
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    else
	{
	    switch (k->code)
		{
		case KCD_MNUUP: /* highlight previous entry */
		    mnuUp(data->menu);
		    break;
		case KCD_MNUDOWN: /* highlight next entry */
		    mnuDown(data->menu);
		    break;
		case KCD_MNUSELECT:
		case KCD_LEFT: /* activate this entry */
		    mnuSelect(data->menu);
		    break;
		case KCD_HUP: /* back to previous menu */
		case KCD_RIGHT: /* back to previous menu */
		    mnuEscape(data->menu);
		    break;
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    return MFW_EVENT_CONSUMED;
}



/*******************************************************************************

 $Function:    	MMIWindow_mnu_cb

 $Description:	Menu callback function for the MMI window
 
 $Returns:		none

 $Arguments:	e - event id
 				m - menu handle
*******************************************************************************/

static int MMIWindow_mnu_cb (MfwEvt e, MfwMnu *m)
    
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    T_MFW_WIN  * win_data = ((T_MFW_HDR *)win)->data;
    T_MMIWINDOW      * data = (T_MMIWINDOW *)win_data->user;

    TRACE_FUNCTION ("MMIWindow_mnu_cb()");

    switch (e)
        {
	case E_MNU_ESCAPE: /* back to previous menu */
	    MMI_DestoryWindow(data->win);
	    break;
	default: /* in mnuCreate() only E_MNU_ESCAPE has been enabled! */
	    return MFW_EVENT_REJECTED;
        }
    return MFW_EVENT_CONSUMED;
}


GLOBAL_EXT T_MFW_HND  MMI_CreateWindow(T_MFW_HND hWinParent, 
											T_DIALOG_FUNC  win_exec_cb,
											void * parameter,
											MfwCb kbd_cb,
											MfwMnuAttr *pMnuAttr,	
											unsigned long dwStyle)
{
    T_MMIWINDOW*	data = (T_MMIWINDOW *)ALLOC_MEMORY (sizeof (T_MMIWINDOW));
    T_MFW_WIN * 		win;

    TRACE_FUNCTION ("MMI_CreateWindow()");

   memset(data,0,sizeof (T_MMIWINDOW));
    /*
     * Create window handler
     */

    /* xreddymn Aug-09-2004, MMI-SPR-23964 (TII_MMS33) 
     * Implemented suspend and resume functionality for MFW windows
     * Subscribed for MfwWinSuspend and MfwWinResume events
     */
    data->win =win_create (hWinParent, 0, E_WIN_VISIBLE|MfwWinSuspend|MfwWinResume, (T_MFW_CB)MMIWindow_win_cb);
    if (data->win EQ NULL)
	{
	    return NULL;
	}
    /* 
     * connect the dialog data to the MFW-window
     */

	data->mmi_control.dialog = (T_DIALOG_FUNC)win_exec_cb;
	data->mmi_control.data   = data;
	win                      = getWinData(data->win);
	win->user                = (void *)data;
	
	data->parent             = hWinParent;
    	data->id = 0;
	data->info_win=0;

	if(pMnuAttr)
	{
                //CRR 23959: xpradipg 26 Aug 2004
                //Do not create the default kbd handler if there is one specified 
		if(!kbd_cb)
		{
	    	data->kbd =      kbdCreate(data->win,KEY_ALL,         (MfwCb)MMIWindow_kbd_cb);
	    	data->kbd_long = kbdCreate(data->win,KEY_ALL|KEY_LONG,(MfwCb)MMIWindow_kbd_cb);
		}
		data->menu =     mnuCreate(data->win,pMnuAttr, E_MNU_ESCAPE, (MfwCb)MMIWindow_mnu_cb);
		mnuLang(data->menu,mainMmiLng);
		/* put the (new) dialog window on top of the window stack */
		mnuUnhide(data->menu);
	}
        //CRR 23959: xpradipg 26 Aug 2004
        //check for the keyboard handler irrespective of the menu attribute presence
	if(kbd_cb)
	{
	    	data->kbd =      kbdCreate(data->win,KEY_ALL,         (MfwCb)kbd_cb);
	    	data->kbd_long = kbdCreate(data->win,KEY_ALL|KEY_LONG,(MfwCb)kbd_cb);
	}

     
	if (data->win NEQ NULL)
	{
		SEND_EVENT (data->win, MWM_CREATE, 0, (void *)parameter);
	}

	winShow(data->win);
	return data->win;

}
GLOBAL_EXT T_MFW_HND  MMI_DestoryWindow(T_MFW_HND hWin)
{
	T_MFW_WIN * 		win_data;
	T_MMIWINDOW* 	data;
	USHORT i;

	TRACE_FUNCTION ("MMI_DestoryWindow()");

	if (hWin)
	{
		win_data = getWinData(hWin); 
		data = getUserData_T_MMIWINDOW(win_data);
		SEND_EVENT (data->win, MWM_DESTORY, 0, (void *)0);
		if (data)
		{
			/*
			* Delete WIN handler
			*/ 

			if (data->info_win)
			{
				SEND_EVENT(data->info_win,DIALOG_DESTROY,0,0 );
				data->info_win = 0;
			}
			if (data->list_win){
				SEND_EVENT(data->list_win,DIALOG_DESTROY,0,0 );
				data->list_win = 0;
			}
			if (data->kbd)
			{
				kbd_delete(data->kbd);
				data->kbd = 0;
			}
			if (data->kbd_long)
			{
				kbd_delete(data->kbd_long);
				data->kbd_long = 0;
			}
			if (data->menu){
				mnuDelete(data->menu);
				data->menu=0;
			}

			win_delete (data->win);
			FREE_MEMORY ((void *)data, sizeof (T_MMIWINDOW));

		}else
		{
			TRACE_EVENT ("MMSBox_destory() called twice");
		}
	}
}

GLOBAL_EXT T_MFW_HND  MMI_ParentWindow(T_MFW_HND hWin)
{
	T_MFW_WIN * 		win_data;
	T_MMIWINDOW* 	data;

	TRACE_FUNCTION ("MMI_ParentWindow()");

	if (hWin)
	{
		win_data = getWinData(hWin); 
		data = getUserData_T_MMIWINDOW(win_data);
		return data->parent;
	}
	return NULL;
}

#undef MMI_MMIWINDOW_C


