/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                     
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    MmiMMSSetting.c
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                          
 $Date:		    26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSSetting.c
 
    Bug Id 26: 16 Aug 2004
    Description: The MMSc Address is changed pressing the delete sokftkey / the hangup key
    Solution: The change is stored onto a temporary buffer and updated only when the user confirms
    
	17/01/04			Replace mfw edit with AUI edit.	

	29/10/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/

#define MMI_MMSSETTING_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"

#include "mfw_mfw.h"
#include "mfw_win.h"

#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"


#include "dspl.h"

#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiMmi.h"

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"

#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else /* NEW_EDITOR */
#ifdef EASY_TEXT_ENABLED
#include "MmiLatinPredText.h"
#endif /* EASY_TEXT_ENABLED */
#include "MmiEditor.h"
#endif /* NEW_EDITOR */

#include "MmiBookShared.h"
#include "mmimmsmenu.h"
#include "mmimmssetting.h"
#include "mmiwindow.h"

#include "mmiSmsMenu.h"
#include "mmismssend.h"

#include "cus_aci.h"

#include "mfw_ffs.h"
//#include "pcm.h"

#include "mmiColours.h"

//Bug ID 26: 16 Aug 2004 - xpradipg
//the maximum length of the MMSc Address
#define MMS_ADDR_MAX_LEN 150


static char scenter[32]="\0";
static T_MFW_HND	    editor=NULL;
   //Bug Id 26: 16 Aug 2004 - xpradipg
   //Temporary buffer added to hold the MMSc address, the address is updated only
   //when the user confirms 
UBYTE *Temp_MMSC_Addr;
static void MMSSetting_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason)
{
	T_MFW_WIN	        * win_data = ((T_MFW_HDR *) win)->data;
	T_DISPLAY_DATA display_info;
       char* pMmscAddress = NULL;
	TRACE_EVENT_P1("MMSSetting_edit_cb() %d", Identifier);


	switch (reason)
    {
	case INFO_KCD_LEFT:  // confirm (press LEFT soft key)
        	TRACE_EVENT_P1("scenter: %s",scenter);
		//Bug Id 26: 16 Aug 2004 - xpradipg
		//retrieve the original buffer to which the MMSc address is to be updated
		//and update and save it with the temprorary buffer contents
		pMmscAddress =(char*) ATB_mms_get_MmscAddress();
		strcpy(pMmscAddress,(char*)Temp_MMSC_Addr);
              ATB_mms_profile_save();
              /* save mmsc profile */
        	MMI_DestoryWindow(win);
    	break;

	case INFO_KCD_RIGHT:
	case INFO_KCD_HUP:
	    	MMI_DestoryWindow(win);
    	break;
	default:
	    	TRACE_EVENT("Err: Default");
    	break;
    }
	
}

/*******************************************************************************

 $Function:    	MMSSetting_exec_cb

 $Description:	Callback handler for events sent by the window itself
 
 $Returns:    	none

 $Arguments:	win - current window
             	event - event id
             	parameter - optional data.
*******************************************************************************/
extern char* ATB_mms_get_MmscAddress(void);
static void MMSSetting_exec_cb(T_MFW_HND win, USHORT event, void *parameter)
{
	T_MFW_WIN      * win_data = ((T_MFW_HDR *) win)->data;
	//T_EDITOR_DATA	editor_data;
	T_AUI_EDITOR_DATA editor_data;
	char* pMmscAddress = NULL;

	
	TRACE_FUNCTION ("MMSSetting_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		//MMSSetting_loadEditDefault(&editor_data);
		//Bug Id 26: 16 Aug 2004 - xpradipg
		//Allocate memory to hold the MMSc Address
		Temp_MMSC_Addr=(UBYTE*)mfwAlloc(MMS_ADDR_MAX_LEN+1);
		memset(Temp_MMSC_Addr,'\0',MMS_ADDR_MAX_LEN+1);
		pMmscAddress = ATB_mms_get_MmscAddress();
		//Bug Id 26: 16 Aug 2004 - xpradipg
		//and retrieve the current MMSc address to the temp buffer
		strcpy((char*)Temp_MMSC_Addr,pMmscAddress);
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, PHNO_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, SMSSEND_ID_NBEDIT, TRUE, FOREVER, (T_AUI_EDIT_CB)MMSSetting_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtServiceCentre, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, NULL, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
		//Bug Id 26: 16 Aug 2004 - xpradipg
		//pass the temporary buffer to the editor
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)Temp_MMSC_Addr, 50);
		editor = AUI_edit_Start(win, &editor_data);
	    	break;
	case MWM_ONDRAW:
		break;
	case MWM_DESTORY:
		//Bug Id 26: 16 Aug 2004 - xpradipg
		//free the memory allocated for the temp buffer
		mfwFree(Temp_MMSC_Addr,MMS_ADDR_MAX_LEN+1);
		break;
	default:
	    	TRACE_EVENT("Err: Default");
    	break;
    }
}


T_MFW_HND MMSSetting_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	MMI_CreateWindow(parent_window, (T_DIALOG_FUNC) MMSSetting_exec_cb, (void *) menuAttr, 0, 0, 0);
}


#undef MMI_MMSSETTING_C


