#ifndef _DEF_MMI_MMSOM_H_
#define _DEF_MMI_MMSOM_H_


/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    MmiMMSom.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    28/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSom.h

    xrashmic 7 Dec, 2004 MMI-SPR-23965
    Description: Not able to extract the objects in EMS message
    Solution: Extract and store the objects in the Object Manager

    Bug Id 1 & 9 : 		12 Aug, 2004 - xpradipg  
    Description:"No Media" displayed instead of Options screen 
    Solution: Added the BMI information window instead of writing directly onto the display

	28/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/
#undef GLOBAL_EXT
#if defined (MMI_MMSOM_C)
	#define GLOBAL_EXT
#else
	#define GLOBAL_EXT extern
#endif

/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/

#include "mfw_mfw.h"



/*******************************************************************************
                                                                              
                        Shared Structure Definitions
                                                                              
*******************************************************************************/

// Length = to len("from ") + len(number) + len(sms text) + 4 (for \0 \n and optional ionternational character +)
//+possible addition of concatenated status information SPR 1833
#define MAX_EDITOR_LEN (5+MFW_NUM_LEN+MAX_MSG_LEN+4+30)
#define MAX_MMS_MEDIA 		20


#define MMS_INSERT_PICTURE 0
#define MMS_INSERT_SOUND   1
#define EMS_INSERT_PICTURE       2
#define EMS_INSERT_SOUND          3
//xrashmic 7 Dec, 2004 MMI-SPR-23965
#define EMS_INSERT_PICTURE_USR       4
#define EMS_INSERT_SOUND_USR    5


/*******************************************************************************
                                                                              
                                Function Prototypes
                                                                              
*******************************************************************************/
// Entry points for the different MMS blocs
GLOBAL_EXT T_MFW_HND MMSom_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);
//callback for the information dialog
static void No_Media_info_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason);


/*******************************************************************************
                                                                              
                              DUMMY DECLARATIONS	
                                                                              
*******************************************************************************/

//Dummy defines

// Dummy global variables



#endif /* _DEF_MMI_MMSOM_H_ */



