
/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                    
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    MmiMMSom.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    28/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSom.c

    xreddymn Aug-20-2005 MMI-SPR-32709
    Added support for previewing objects before inserting into MMS

       xrashmic 08 Feb, 2005 MMI-SPR-27853
       Added more parameters to the information_dialog function

    xreddymn Jan-31-2005 MMI-SPR-28483: Support for MIDI objects

    xrashmic 28 Jan, 2004 MMI-SPR-28166
    Added support for saving Plugin Images

    xrashmic 7 Dec, 2004 MMI-SPR-23965
    Description: Not able to extract the objects in EMS message
    Solution: Extract and store the objects in the Object Manager

        xrashmic 29 Nov, 2004 MMI-SPR-26161
        Description: The downloaded object through wap was not visible to the MMI
        Solution: The downloaded wap object is available in the object manager 
        and can be used by the MMS

    Bug Id 1 & 9 : 		12 Aug, 2004 - xpradipg  
    Description:"No Media" displayed instead of Options screen 
    Solution: Added the BMI information window instead of writing directly onto the display

	Bug Id 25 : 		13 Aug, 2004 - xrashmic
	Description: Changed the Insert note to Insert, Preview is not yet implemented, 
	therefore commented for time being

	28/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/
#define MMI_MMSOM_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"

#include "psa_util.h"

#include "dspl.h"
// #include "unicode_types.h"

#include "MmiMain.h"
#include "MmiDummy.h"
//#include "MmiLists.h"
#include "MmiMmi.h"
#include "mmiCall.h"//GW 29/11/01 for 'callNumber'

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
//#include "MmiEditor.h"
#include "MmiBookShared.h" // MZ 
#include "mmimmsmenu.h"
#include "mmimmsom.h"
#include "mmiwindow.h"
#include "mfw_ffs.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "aci_cmh.h"	//GW 29/11/01 added for types in aci_fd.h
#include "aci_fd.h"		//GW 29/11/01 added for types in 'cmh.h'
#include "cmh.h" 		//GW 29/11/01 added for types in 'cmh_phb.h'
#include "cmh_phb.h"	//GW 29/11/01 added for cmhPHB_getAdrStr

#include "mmiColours.h"



// ronaldc 8-5

#include "mg4def.h"
#include "evtdefs.h"
#include "mg4stu.h"
#include "Mg4Dal.h"
#include "mg4devif.h"
#include "dalevt.h"
#include "evif.h"
#include "mg4str.h"
#include "mmif.h"
#include "mg4mem.h"


MfwWin* getWinData( MfwHnd win);

/*********************************************************************

				 DYNAMIC MENU WINDOW. DECLARATION

**********************************************************************/



static MfwMnuAttr MmsOm_menuAttrib =
{
    &melody_menuArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    NULL,                               /* with these items         */
    0,                                   /* number of items     */
	COLOUR_LIST_XX, TxtNull, MNUATTRSPARE
};

extern ESTATUS DisplayImageByObjId(MDword id, MBool bFullScreen);

static int MMSom_OPTexeInsert(MfwMnu* m, MfwMnuItem* i);
static int MMSom_OPTexePreview(MfwMnu* m, MfwMnuItem* i);
static int MMSom_OPTexeDelete(MfwMnu* m, MfwMnuItem* i);
USHORT MMSom_OPTexePreview_Available( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );

static MfwMnuItem MMSom_OPTItems [] =
{
    {0,0,0,(char *)TxtMMSInsert,0,(MenuFunc)MMSom_OPTexeInsert,item_flag_none},
    {0,0,0,(char *)TxtDelete,0,(MenuFunc)MMSom_OPTexeDelete,item_flag_none},
    {0,0,0,(char *)TxtMMSPreview,0,(MenuFunc)MMSom_OPTexePreview,MMSom_OPTexePreview_Available},
};

static MfwMnuAttr MMSom_OPTAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    MMSom_OPTItems,                      /* with these items         */
    sizeof(MMSom_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE

};
static ListMenuData *menu_list_data=NULL;

#if 1

static int currentObjectNumber = 0;

/***********************************************************************************************************************


***********************************************************************************************************************/

#pragma DATA_SECTION (g_ObjectBuffer, ".MMSFSBUF0");

UCS2 g_ObjectFilename[] = {'j','p','g','0',0};
UCS2 g_AMRFilename[] = {'a','m','r','0',0};

unsigned char g_ObjectBuffer[30 * 1024];//liuyu do not need in mass production
//xrashmic 7 Dec, 2004 MMI-SPR-23965
extern EV_S_EXTRACTABLE_IN_MESSAGE apExtractableInMessage;
extern PP_S_OBJECT_DATA  *appObj;
extern int attachmentInEMS;
UCS2 filename[14];
ESTATUS M4_StoreExtractedObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type);
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback);

/*!	\brief	Notify the menu system that the action has failed
 */
void M4_ActionError(ESTATUS aEStatus)
{
	if(aEStatus==EObjectAlreadyExists)
	{
		TRACE_EVENT("EObjectAlreadyExists!!!");
	}else
		TRACE_EVENT_P1("MMS action error: %d",(int )aEStatus);
}

/*!	\brief	Notify the menu system that the action has been completed successfully.
 *
 */
void M4_ActionComplete()
{
	TRACE_EVENT("MMS action complete");
}

void M4_ObjectAttribFreeFunc (void *aObjectAtrrib)
{
	M4_S_OBJECT_ATTRIB *objectAttrib = aObjectAtrrib;
	TRACE_FUNCTION("M4_ObjectAttribFreeFunc");

	FREE_MEMORY((void*)objectAttrib, sizeof(*objectAttrib));
}

void M4_ObjectItemFreeFunc ( void *aObjectItem)
{
	M4_S_OBJECT_ITEM *objectItem = aObjectItem;
	TRACE_FUNCTION("M4_ObjectItemFreeFunc");

	FREE_MEMORY((void*)objectItem, sizeof(*objectItem));
}
ESTATUS M4_StorePicEventHandler(EVENT_ID aeId, EVENT_TYPE aeType, 
                           MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
	TRACE_FUNCTION("M4_StorePicObjectEventHandlerFunc");
	switch (aeId)
	{
	case EMG4_FileOpDone :
		currentObjectNumber++;
		TRACE_EVENT("mms:case EMG4_FileOpDone begin");
		M4_StoreNextPicObject(EvtHandle);
		break;
	default:
		TRACE_EVENT("mms:default EMG4_FileOpDone begin");
		FREE_MEMORY((void*)EvtHandle, sizeof(*EvtHandle));
	}

	return ENoError;
}

ESTATUS M4_StoreSndEventHandler(EVENT_ID aeId, EVENT_TYPE aeType, 
                           MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
	TRACE_FUNCTION("M4_StoreSndObjectEventHandlerFunc");
	switch (aeId)
	{
	case EMG4_FileOpDone :
		currentObjectNumber++;
		TRACE_EVENT("mms:case EMG4_FileOpDone begin");
		M4_StoreNextSndObject(EvtHandle);
		break;
	default:
		TRACE_EVENT("mms:default EMG4_FileOpDone begin");
		FREE_MEMORY((void*)EvtHandle, sizeof(*EvtHandle));
	}

	return ENoError;
}

void M4_StoreNextSndObject(EVT_HANDLE aEvtHandler)
{
	TRACE_FUNCTION("M4_StoreNextSndObject");
	if (currentObjectNumber < MAX_MMS_MEDIA)
	{
		ESTATUS estatus;
		M4_S_OBJECT_ITEM *objectItem = NULL;
		M4_S_OBJECT_ATTRIB *objectAttrib = NULL;

		objectItem   = (M4_S_OBJECT_ITEM*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ITEM));
		objectAttrib  = (M4_S_OBJECT_ATTRIB*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ATTRIB));
		
		{
			struct stat_s  stat;
			char filename[]="/amr0";
                     signed char Ffs_ret;
			
			filename[4]='0'+currentObjectNumber;
			g_AMRFilename[3]='0'+currentObjectNumber;
			
			Ffs_ret = ffs_stat(filename, &stat); 
            
                     if (Ffs_ret != 0)//empty file id found 
                     { 
                         //xmzhou_trace_string("M4_StoreNextSndObject file not found");
                         return;
                     }
                     
			TRACE_EVENT_P1("read jpg size: %d", stat.size);
			ffs_fread(filename, (void *) g_ObjectBuffer,stat.size);
			
			objectItem->objectSize			= stat.size;
			objectItem->pData			= (MByte *)g_ObjectBuffer;
			objectItem->memHdr.freeFunc	= M4_ObjectItemFreeFunc;

			objectAttrib->drmInfo				= EDrmNotSet;
			objectAttrib->memHdr.freeFunc		= M4_ObjectAttribFreeFunc;
			objectAttrib->objectFile.fileNameLen= 10;
			objectAttrib->objectFile.pFileName  = (UCS2 *)g_AMRFilename;
			objectAttrib->objectId				= 100 + currentObjectNumber;
			objectAttrib->objectSize			= stat.size;
			objectAttrib->type					= EMtMimeAmr;
		}

			
		TRACE_EVENT("MMS: OM_StoreObjectAsync begin");
		estatus = OM_StoreObjectAsync(aEvtHandler,objectItem,objectAttrib);
		TRACE_EVENT_P1("MMS: OM_StoreObjectAsync end:%d",estatus);
		if (estatus != ENoError)
		{
			M4_ActionError(estatus);
			FREE_MEMORY((void*)aEvtHandler, sizeof(*aEvtHandler));
		}
	}
	else
	{
		FREE_MEMORY((void*)aEvtHandler, sizeof(*aEvtHandler));
		M4_ActionComplete();
	}

}

void M4_StoreNextPicObject(EVT_HANDLE aEvtHandler)
{
	TRACE_FUNCTION("M4_StoreNextPicObject");
	if (currentObjectNumber < MAX_MMS_MEDIA)
	{
		ESTATUS estatus;
		M4_S_OBJECT_ITEM *objectItem = NULL;
		M4_S_OBJECT_ATTRIB *objectAttrib = NULL;

		objectItem   = (M4_S_OBJECT_ITEM*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ITEM));
		objectAttrib  = (M4_S_OBJECT_ATTRIB*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ATTRIB));
		
		{
			struct stat_s  stat;
			char filename[]="/jpg0";
                     signed char Ffs_ret;
			
			filename[4]='0'+currentObjectNumber;
			g_ObjectFilename[3]='0'+currentObjectNumber;
			
			Ffs_ret = ffs_stat(filename, &stat); 
            
                     if (Ffs_ret != 0)//empty file id found 
                     { 
                         //xmzhou_trace_string("M4_StoreNextPicObject file not found");
                         return;
                     }
                     
			TRACE_EVENT_P1("read jpg size: %d", stat.size);
			ffs_fread(filename, (void *) g_ObjectBuffer,stat.size);
			
			objectItem->objectSize			= stat.size;
			objectItem->pData			= (MByte *)g_ObjectBuffer;
			objectItem->memHdr.freeFunc	= M4_ObjectItemFreeFunc;

			objectAttrib->drmInfo				= EDrmNotSet;
			objectAttrib->memHdr.freeFunc		= M4_ObjectAttribFreeFunc;
			objectAttrib->objectFile.fileNameLen= 10;
			objectAttrib->objectFile.pFileName  = (UCS2 *)g_ObjectFilename;
			objectAttrib->objectId				= 100+currentObjectNumber;
			objectAttrib->objectSize			= stat.size;
			objectAttrib->type					= EMtMimeJpeg;;
		}

			
		TRACE_EVENT("MMS: OM_StoreObjectAsync begin");
		estatus = OM_StoreObjectAsync(aEvtHandler,objectItem,objectAttrib);
		TRACE_EVENT_P1("MMS: OM_StoreObjectAsync end:%d",estatus);
		if (estatus != ENoError)
		{
			M4_ActionError(estatus);
			FREE_MEMORY((void*)aEvtHandler, sizeof(*aEvtHandler));
		}
	}
	else
	{
		FREE_MEMORY((void*)aEvtHandler, sizeof(*aEvtHandler));
		M4_ActionComplete();
	}

}


// insert objects into OM.
void M4_InsertPicObjectIntoOM()
{

	EVT_HANDLE evtHandler=NULL;
	TRACE_FUNCTION("M4_InsertPicObjectIntoOM");

       evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));

	memset(evtHandler,0x00,sizeof(EVT_STRUCT));
	evtHandler->handler         = M4_StorePicEventHandler;

	currentObjectNumber = 0;

	M4_StoreNextPicObject(evtHandler);
}
void M4_InsertSndObjectIntoOM()
{
	EVT_HANDLE evtHandler=NULL;
	TRACE_FUNCTION("M4_InsertSndObjectIntoOM");

	   evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));

	memset(evtHandler,0x00,sizeof(EVT_STRUCT));
	evtHandler->handler 		= M4_StoreSndEventHandler;

	currentObjectNumber = 0;

	M4_StoreNextSndObject(evtHandler);
}

// insert Object into current message

void M4_InsertObjectIntoMessage(M4_OBJECT_ID aObjectID)
{
	ESTATUS eResult=0;
	TRACE_FUNCTION("M4_InsertObjectIntoMessage");
	eResult=DAL_PostMessage(EMG4_InsertObject,EMG4_Type_NotUsed,aObjectID,0);
	TRACE_EVENT_P2("MMS: M4_InsertObjectIntoMessage:%d, obj:%d", eResult,aObjectID);
}

/*
delete obejct from OM.
*/
ESTATUS M4_DeleteObjectEventHandlerFunc(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
	TRACE_FUNCTION("M4_DeleteObjectEventHandlerFunc");
	switch (aeId)
	{
	case EMG4_FileOpDone :
		M4_ActionComplete();
		break;
	}
	FREE_MEMORY((void*)evtHandle, sizeof(*evtHandle));
	return ENoError;
}


void M4_DeleteObjectFromOM(M4_OBJECT_ID aObjectID)
{
	EVT_HANDLE evtHandler;
	ESTATUS eResult=0;

	/* Create the event handler */
    evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));	
	if (evtHandler == NULL)
	{
		M4_ActionError(EOutOfMemory);
		return;
	}

	memset(evtHandler,0x00,sizeof(EVT_STRUCT));						/* Reset the structure */		
	evtHandler->handler = M4_DeleteObjectEventHandlerFunc;
	
	eResult=OM_DeleteObjectAsync(evtHandler,aObjectID);
	TRACE_EVENT_P1("MMS: OM_DeleteObjectAsync:%d", eResult);	
}


/*
List obejct from OM.
*/

static M4_S_OBJECT_LIST*		g_pObjectList	= NULL;
static UBYTE          				g_current_select=0;  /*indicate the current object*/

void M4_ListObjects(UINT32 ObjType)
{
	MDword conditions = 0;
	ESTATUS eResult=0;
	TRACE_FUNCTION("M4_ListObjects");

    if (ObjType == MMS_INSERT_SOUND)
    {
        conditions = OM_MT_SOUND_NO_DRM;
    }
    else if (ObjType == MMS_INSERT_PICTURE)
    {
        conditions = OM_MT_IMAGE_NO_DRM;
    }    
    else if (ObjType == EMS_INSERT_SOUND)
    {
        conditions = OM_MT_EMS_PREDEF_SOUND;
    }
    else if (ObjType == EMS_INSERT_PICTURE)
    {
        conditions = OM_MT_EMS_PREDEF_ANIM;
    }
//xrashmic 7 Dec, 2004 MMI-SPR-23965
// Separate lists for the user defined Image and Picture objects
    else if (ObjType == EMS_INSERT_PICTURE_USR)
    {
        conditions = OM_MT_EMS_IMAGE;
    }
    else if (ObjType == EMS_INSERT_SOUND_USR)
    {
        conditions = OM_MT_EMS_SOUND;
    }
    
    else
    {
        //xmzhou_trace_string("M4_ListObjects() error ObjType");
        return;
    }
	
	//conditions = OM_MT_SOUND_NO_DRM;
	eResult=OM_ListObjectsByParam(conditions,&g_pObjectList);
	if(eResult==EObjectNotFound)
	{
		TRACE_EVENT("MMS: OM_ListObjectsByParam:not found");	
	}else
	{	TRACE_EVENT_P1("MMS: OM_ListObjectsByParam:%d", eResult);	
	}
	M4_ActionComplete();	/* Post back to the menu system to say that we have finished the action */
}
void M4_FreeListObjectsMemory()
{
	TRACE_FUNCTION("M4_FreeListObjectsMemory");
	if (g_pObjectList)
	{
		g_pObjectList->memHdr.freeFunc(g_pObjectList);
		g_pObjectList = NULL;
	}
}

//int ConvertUcs2To8BitString(pUcs2String, uLength, p8BitString)

#endif

#define MMS_OM_LIST_BEGIN


/*******************************************************************************

 $Function:     MMSomList_cb

 $Description:  Callback function for the melody list.

 $Returns:    none

 $Arguments:  Parent - parent window.
        ListData - Menu item list
*******************************************************************************/

void MMSomList_cb(T_MFW_HND * Parent, ListMenuData * ListData)
{

	if ((ListData->Reason EQ LISTS_REASON_BACK) || (ListData->Reason EQ LISTS_REASON_CLEAR)
	|| (ListData->Reason EQ LISTS_REASON_HANGUP))	// sbh - added hangup key
	{
		listsDestroy(ListData->win);
		MMI_DestoryWindow(Parent);
	}
	else if(ListData->Reason EQ LISTS_REASON_SELECT)
	{
		g_current_select=ListData->CursorPosition;
		MMSom_OPT_start(ListData->win,0);
	}else if(ListData->Reason EQ LISTS_REASON_SCROLL)
	{
		TRACE_FUNCTION ("MMSom_OPTexePreview()");
		DisplayImageByObjId(g_pObjectList->pList[ListData->CursorPosition].objectId,EFalse);

	}
}


//    Bug Id 1 & 9 : 		12 Aug, 2004 - xpradipg  
/*******************************************************************************

 $Function:     No_Media_info_cb

 $Description:  Callback function for the information dialogue when media list is empty

 $Returns:    none

 $Arguments:   
*******************************************************************************/
static void No_Media_info_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	switch(reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
		case INFO_KCD_CLEAR:
		case INFO_TIMEOUT:
			TRACE_EVENT_P1("the value of win in No_media_info_cb is %x",*((int*)win));
			MMI_DestoryWindow(win);
		    	break;
		default:
	    	break;
    }
}

/*******************************************************************************

 $Function:    	MMSom_exec_cb

 $Description:	Exec callback function of the MMS Create window 
 
 $Returns:		none

 $Arguments:	win - window handler
 				event - mfw event
 				parameter - optional data.
 
*******************************************************************************/
char g_ObjectTitle[MAX_MMS_MEDIA][32];

void MMSom_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
	int i;
        T_DISPLAY_DATA display_info;

	TRACE_FUNCTION ("MMSom_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		/* initialization of administrative data */
		TRACE_EVENT("MWM_CREATE");

		//yanbin:  call magic4 function to create object list
		M4_ListObjects((UINT32)parameter);
		
		if(g_pObjectList==NULL)
		{
			TRACE_EVENT("!!!no media object");
			TRACE_EVENT ("Insert objects into OM");
			
			if ((UINT32)parameter == MMS_INSERT_SOUND)
			{
				M4_InsertSndObjectIntoOM();
			}
			else if ((UINT32)parameter == MMS_INSERT_PICTURE)
			{
				M4_InsertPicObjectIntoOM();
			}
			else
			{ 
				//xmzhou_trace_string("MMSom_exec_cb error obj type");
			}
			
			// xreddymn Aug-09-2004, Why is winShow being called in a Window Callback ?
			//winShow(win);
			break;
		}
		
		TRACE_EVENT_P1("M4_ListObjects total:%d",g_pObjectList->numItems);
		
		menu_list_data =(ListMenuData *) ALLOC_MEMORY(sizeof(ListMenuData));
        if (menu_list_data == NULL)
            {
//                xmzhou_trace_string("menu_list_data == NULL error");
                return;
            }
		menu_list_data->List = (T_MFW_MNU_ITEM *)ALLOC_MEMORY( g_pObjectList->numItems * sizeof(T_MFW_MNU_ITEM) );
        
        if (menu_list_data->List  == NULL)
            {
//                xmzhou_trace_string("menu_list_data->List == NULL error");
                return;
            }
		
		for (i = 0; i < g_pObjectList->numItems ; i++)
		{
			char tempbuf[64];
			mnuInitDataItem(&menu_list_data->List[i]);
			menu_list_data->List[i].flagFunc = item_flag_none;
			ConvertUcs2To8BitString(g_pObjectList->pList[i].objectFile.pFileName, 
									g_pObjectList->pList[i].objectFile.fileNameLen, (MByte*) tempbuf);
			sprintf(g_ObjectTitle[i],"%d:%s-(%d B)",i,tempbuf, g_pObjectList->pList[i].objectSize);
//			data->menu_list_data->List[i].str  = "pic1";
			menu_list_data->List[i].str  = g_ObjectTitle[i];
		}

		menu_list_data->ListLength =g_pObjectList->numItems;
		menu_list_data->ListPosition = 1;
		menu_list_data->CursorPosition = 1;
		menu_list_data->SnapshotSize = g_pObjectList->numItems;
		menu_list_data->Font = 0;
		menu_list_data->LeftSoftKey = TxtSoftSelect;
		menu_list_data->RightSoftKey = TxtSoftBack;
		menu_list_data->KeyEvents = KEY_ALL;
		menu_list_data->Reason = 0;
		menu_list_data->Strings = TRUE;
		menu_list_data->Attr   = &MmsOm_menuAttrib;
		menu_list_data->autoDestroy    = FALSE;
		listDisplayListMenu(win,menu_list_data,(ListCbFunc)MMSomList_cb,0);
		
		/* put the (new) dialog window on top of the window stack */
		// xreddymn Aug-09-2004, Why is winShow being called in a Window Callback ?
		//winShow(win);
		break;
		
	case MWM_ONDRAW:
		TRACE_EVENT("MWM_ONDRAW");
		//xpradipg 12 Aug, 2004 : Bug Id 1 & 9
		//"No Media" displayed instead of Options screen 
		//check for any object present in the object buffer before displaying the error screen.
		//since MWM_ONDRAW is called for every draw. Add the BMI information dialog screen.
		if(g_pObjectList ==NULL)
		{
		
			dlg_initDisplayData_TextStr( &display_info,  TxtNull, TxtSoftBack, "No Media",  TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)No_Media_info_cb, FOREVER, KEY_HUP| KEY_RIGHT);
	   		info_dialog (win, &display_info);
		}
		break;
	case MWM_DESTORY:
	     	if(menu_list_data)
	     	{
	     		if(menu_list_data->List)
	     		{
	     			FREE_MEMORY((void*)(menu_list_data->List),g_pObjectList->numItems* sizeof(T_MFW_MNU_ITEM ));
	     		}
		 	FREE_MEMORY((void*)(menu_list_data),sizeof(ListMenuData));
	     	}
		M4_FreeListObjectsMemory();
		break;
	default:
	    break;
	}
}


/**/
T_MFW_HND l_omwin=NULL;
/*******************************************************************************

 $Function:    	MMSom_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSom_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{

	TRACE_FUNCTION ("MMSom_start()");
	l_omwin= MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSom_exec_cb,(void*)menuAttr, 0, 0, 0);
	return l_omwin;
}


#define MMS_OM_OPTION_BEGIN

/*******************************************************************************

 $Function:    	MMSom_OPT_exec_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:		none

 $Arguments:	win - current window
 				event - event id
 				value - unique id
 				parameter - optional data.
 			
*******************************************************************************/

void MMSom_OPT_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	TRACE_FUNCTION ("MMSom_OPT_exec_cb()");
	switch (event)
	{
	case MWM_CREATE:
		
		TRACE_EVENT("Event:MWM_CREATE");
		/* initialization of administrative data */
		//		data->parent_data = parent_data;		
		winShow(win);
		break;
	case MWM_ONDRAW:
		dspl_ClearAll();
		displaySoftKeys(TxtSoftOK,TxtSoftBack);
		break;
	case MWM_DESTORY:
		break;
	default:
	    return;
	}
}


/*******************************************************************************

 $Function:    	MMSom_OPT_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSom_OPT_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{

	TRACE_FUNCTION ("SmsRead_R_start()");
	return MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSom_OPT_exec_cb, (void*)menuAttr,0,&MMSom_OPTAttrib, 0);
}



static int MMSom_OPTexeInsert(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND    win  = mfwParent(mfw_header());

       TRACE_EVENT_P1("MMSom_OPTexeInsert():%d",g_current_select);
	//data->current_select
	DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
       M4_InsertObjectIntoMessage(g_pObjectList->pList[g_current_select].objectId);
	MMI_DestoryWindow(win);
}

//xreddymn Aug-19-2005 MMI-SPR-32709: Preview of Objects

extern MDword DeviceMelodyId;
extern BOOL g_M4_display_active;

BOOL g_M4_object_preview = FALSE;

/*******************************************************************************

 $Function:    	MMSom_OPTexePreview_Available

 $Description:	Decides whether to display "Preview" or not for the selected
                object
 
 $Returns:		0 = Do not display the "Preview" option
                1 = Display the "preview" option

 $Arguments:	m = MfwMnuTag, passed by MFW
 				ma = MfwMnuAttrTag, passed by MFW
 				mi = MfwMnuItemTag, passed by MFW
 
*******************************************************************************/

USHORT MMSom_OPTexePreview_Available( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
	switch(g_pObjectList->pList[g_current_select].type)
	{
		case EMtEmsPredefMelody:
		case EMtEmsMelody:
		case EMtMimeAmr:
		case EMtMimeMidi:
//		case EMtMimeSMidi:
//		case EAudioWav:
//		case EMtSMAF:
				return 0;
		case EMtMimeBmp:
		case EMtMimePng:
		case EMtMimeGif:
		case EMtMimeJpeg:
		case EMtMimeWbmp:
				return 0;
		default:
				return 1;
	}
}

/*******************************************************************************

 $Function:    	MMSom_OPTexePreview_kbd_cb

 $Description:	Key handler for object preview
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	e = Event
 				k = structure containing key code
 
*******************************************************************************/

static int MMSom_OPTexePreview_kbd_cb (MfwEvt e, MfwKbd *k)
{
    T_MFW_HND    win  = mfwParent(mfw_header());

    if (e & KEY_LONG)
    {
        switch (k->code)
        {
    	case KCD_HUP:
    	case KCD_RIGHT:
            MMI_DestoryWindow(win);
            break;
    	default:
            return MFW_EVENT_CONSUMED;
        }
    }
    else
    {
        switch (k->code)
        {
    	case KCD_HUP:
    	case KCD_RIGHT:
            MMI_DestoryWindow(win);
            break;
    	default:
            return MFW_EVENT_CONSUMED;
        }
    }
    return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	MMSom_OPTexePreview_cb

 $Description:	Window handler for object preview
 
 $Returns:		None

 $Arguments:	win = Handle to the window
 				event = Window event
 
*******************************************************************************/

void MMSom_OPTexePreview_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
	int i;
    T_DISPLAY_DATA display_info;
    MRect apClientRect;

	switch (event)
	{
		case MWM_CREATE:
			break;

		case MWM_ONDRAW:
			dspl_Enable(0);
			g_M4_object_preview = TRUE;
			g_M4_display_active = TRUE;
			DeviceGetClientRect(&apClientRect);
			dspl_SetBgdColour(COL_White);
			dspl_Clear(apClientRect.topLeft.uX, apClientRect.topLeft.uY, apClientRect.bottomRight.uX, apClientRect.bottomRight.uY);
			DisplayImageByObjId(g_pObjectList->pList[g_current_select].objectId,EFalse);
			displaySoftKeys(TxtNull,TxtSoftBack);
			g_M4_display_active = FALSE;
			g_M4_object_preview = FALSE;
			dspl_Enable(1);
			break;

		case MWM_DESTORY:
			break;

		default:
		    break;
	}
}

/*******************************************************************************

 $Function:    	MMSom_OPTexePreview_Start

 $Description:	Opens the object preview window
 
 $Returns:		Handle to the object preview window

 $Arguments:	parent_window = Handle to the parent window
 				menuAttr = Menu Attributes (Optional)
 
*******************************************************************************/

T_MFW_HND MMSom_OPTexePreview_Start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	T_MFW_HND win;
	win= MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSom_OPTexePreview_cb,(void*)menuAttr, (MfwCb)MMSom_OPTexePreview_kbd_cb, 0, 0);
	return win;
}

/*******************************************************************************

 $Function:    	MMSom_preview_dialog_cb

 $Description:	Handles dialog events for preview window for sound objects
 
 $Returns:		None

 $Arguments:	win = Handle to the window
 				identifier = (Not used in this function)
 				reason = Dialog event
 
*******************************************************************************/

static void MMSom_preview_dialog_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	switch(reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
		case INFO_KCD_CLEAR:
		case INFO_TIMEOUT:
			MMI_DestoryWindow(win);
			DeviceCancelMelody(DeviceMelodyId);
	    	break;
		default:
	    	break;
    }
}

/*******************************************************************************

 $Function:    	MMSom_OPTexePreview

 $Description:	Called when "preview" is selected in the menu
 
 $Returns:		None

 $Arguments:	win = Handle to the window
 				identifier = (Not used in this function)
 				reason = Dialog event
 
*******************************************************************************/

static int MMSom_OPTexePreview(MfwMnu* m, MfwMnuItem* i)
{
	M4_S_OBJECT_ITEM *appObjectItem;
	T_MFW_HND    win  = mfwParent(mfw_header());

	TRACE_FUNCTION ("MMSom_OPTexePreview()");
	
	switch(g_pObjectList->pList[g_current_select].type)
	{
		case EMtEmsPredefMelody:
		case EMtEmsMelody:
		case EMtMimeAmr:
		case EMtMimeMidi:
//		case EMtMimeSMidi:
//		case EAudioWav:
//		case EMtSMAF:
			{
				T_DISPLAY_DATA display_info;
				OM_RetrieveObject(&appObjectItem, g_pObjectList->pList[g_current_select].objectId);
				DevicePlayMelody(g_pObjectList->pList[g_current_select].type, appObjectItem->pData, appObjectItem->objectSize, NULL);
				dlg_initDisplayData_TextStr( &display_info,  TxtNull, TxtSoftBack, "Playing ...",  TxtNull, COLOUR_STATUS);
				dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSom_preview_dialog_cb, FOREVER, KEY_HUP | KEY_RIGHT);
		   		info_dialog (win, &display_info);
		   	}
			break;

		case EMtMimeBmp:
		case EMtMimePng:
		case EMtMimeGif:
		case EMtMimeJpeg:
		case EMtMimeWbmp:
			MMSom_OPTexePreview_Start(win, NULL);
			break;

		default:
			break;
	}
}

//xreddymn Aug-19-2005 MMI-SPR-32709: Preview of Objects, changes end

static void MMSom_Delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{

	T_MFW_HND l_parent=NULL;
	TRACE_FUNCTION("MMSom_Delete_cb");

	switch (reason)
	{
	case INFO_KCD_LEFT:
		//yanbin: Call magic4 function to delete current object
		M4_DeleteObjectFromOM(g_pObjectList->pList[g_current_select].objectId);
		l_parent=MMI_ParentWindow(win);
		MMI_DestoryWindow(win);
		TRACE_EVENT_P2("l_omwin:%x,l_parent:%x ", l_omwin, l_parent);
//		MMI_DestoryWindow(l_omwin);
		break;
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		//return back
		MMI_DestoryWindow(win);
		break;
	default:
		break;
	}
}
static int MMSom_OPTexeDelete(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSom_Delete_cb, FOREVER, KEY_LEFT|KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	info_dialog (win, &display_info);
}

#undef MMI_MMSOM_C

 /*******************************************************************************

 $Function:     M4_StoreExtarctedObjectEventHandler

 $Description:  Event handler for M4_StoreDownloadedObject 
                      xrashmic 7 Dec, 2004 MMI-SPR-21621
 $Returns:    ESTATUS

 $Arguments:  
*******************************************************************************/

ESTATUS M4_StoreDownloadObjEventHandler(EVENT_ID aeId, EVENT_TYPE aeType, 
                           MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
    switch (aeId)
    {
        case EMG4_FileOpDone :
            break;
        default:
            FREE_MEMORY((void*)EvtHandle, sizeof(*EvtHandle));
    }

    return ENoError;
}

 /*******************************************************************************

 $Function:     M4_StorePluginObjEventHandler

 $Description:  Event handler for M4_StorePluginObject 
                      xrashmic 28 Jan, 2005 MMI-SPR-28166
 $Returns:    ESTATUS

 $Arguments:  
*******************************************************************************/

ESTATUS M4_StorePluginObjEventHandler(EVENT_ID aeId, EVENT_TYPE aeType, 
                           MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
    switch (aeId)
    {
        case EMG4_FileOpDone :
	            //xrashmic 28 Jan, 2005 MMI-SPR-28166
                    information_dialog(TxtSaved, TxtNull, NULL, NULL, TxtNull, TxtSoftBack, THREE_SECS, KEY_RIGHT|KEY_HUP, NULL);
            break;
        default:
            FREE_MEMORY((void*)EvtHandle, sizeof(*EvtHandle));
    }

    return ENoError;
    }

 /*******************************************************************************

 $Function:     M4_StoreExtarctedObjectEventHandler

 $Description:  Event handler for M4_StoreExtarctedObject 
                      xrashmic 7 Dec, 2004 MMI-SPR-23965
 $Returns:    ESTATUS

 $Arguments:  
*******************************************************************************/

ESTATUS M4_StoreExtractedObjectEventHandler(EVENT_ID aeId, EVENT_TYPE aeType, 
                           MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
    ESTATUS status;
    switch (aeId)
    {
        case EMG4_FileOpDone :
                attachmentInEMS++;
                if(appObj)
                    appObj->oms.freeFunc(appObj);
                if(attachmentInEMS<apExtractableInMessage.NumOfAttachments)
                {
                    EV_ReadExtractableItem(&apExtractableInMessage.pAttachmentsInMessage[attachmentInEMS],&appObj);
                    status = M4_StoreExtractedObject((char *)appObj->objData.pByteData, appObj->lObjectDataSize, appObj->contentType);
                 }
                else 
                {
                    apExtractableInMessage.omh.freeFunc(&apExtractableInMessage);
                    //xrashmic 08 Feb, 2005 MMI-SPR-27853
                    //Added more parameters to the information_dialog function
                    information_dialog(TxtAllObjects, TxtExtracted, NULL,NULL, TxtNull, TxtSoftBack, FOREVER, KEY_RIGHT|KEY_HUP, NULL);
                }   
            break;
         case EOutOfMemory:   
                    //xrashmic 08 Feb, 2005 MMI-SPR-27853
                    //Added more parameters to the information_dialog function
                   information_dialog(TxtError, TxtExtracting, NULL,NULL, TxtNull, TxtSoftBack, FOREVER, KEY_RIGHT|KEY_HUP, NULL);
            break;         
        default:
            FREE_MEMORY((void*)EvtHandle, sizeof(*EvtHandle));
    }

    return ENoError;
}

 /*******************************************************************************

 $Function:     M4_StoreIntoObjectManager

 $Description:  Stores objects into Object manager.
                      xrashmic 7 Dec, 2004 MMI-SPR-23965, MMI-SPR-26161
 $Returns:    ESTATUS

 $Arguments:  objbuffer - The object data
                     size - The object size
                     evtHandler - contains the call back function for the events
                     obj_Type - The type of the object
                     objectId - Object Id
*******************************************************************************/

ESTATUS M4_StoreIntoObjectManager(char *objbuffer, int size,EVT_HANDLE evtHandler, M4_E_OBJECT_TYPE obj_Type,M4_OBJECT_ID objectId)
{
    ESTATUS estatus;
    M4_S_OBJECT_ITEM *objectItem = NULL;
    M4_S_OBJECT_ATTRIB *objectAttrib = NULL;
    TRACE_FUNCTION("M4_StoreIntoObjectManager");

    objectItem   = (M4_S_OBJECT_ITEM*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ITEM));
    objectAttrib  = (M4_S_OBJECT_ATTRIB*) ALLOC_MEMORY( sizeof(M4_S_OBJECT_ATTRIB));

    objectItem->objectSize			= size;
    objectItem->pData			= (MByte *)objbuffer;
    objectItem->memHdr.freeFunc	= M4_ObjectItemFreeFunc;

    objectAttrib->drmInfo				= EDrmNotSet;
    objectAttrib->memHdr.freeFunc		= M4_ObjectAttribFreeFunc;
    objectAttrib->objectFile.fileNameLen= sizeof(filename);
    objectAttrib->objectFile.pFileName  = filename;
    objectAttrib->objectId				= objectId;
    objectAttrib->objectSize			= size;
    objectAttrib->type					= obj_Type;
    estatus = OM_StoreObjectAsync(evtHandler,objectItem,objectAttrib);
    if (estatus != ENoError)
    {
        TRACE_EVENT("ERROR inserting into obejct manager");
        switch(estatus)
        {
            case ENotActive:
                TRACE_EVENT("ERROR ENotActive");
                break;
            case EBadArgument:
                TRACE_EVENT("ERROR EBadArgument ");
                break;
            case EObjectAlreadyExists:
                TRACE_EVENT("ERROR EObjectAlreadyExists");
                break;
            case EOutOfMemory:
                TRACE_EVENT("ERROR EOutOfMemory");
                break;
             default:
                TRACE_EVENT("ERROR");
            }
    }
    return estatus;
}
 /*******************************************************************************

 $Function:     M4_StoreExtarctedObject

 $Description:  Insert the extracted object into Object manager.
                      xrashmic 7 Dec, 2004 MMI-SPR-23965
 $Returns:    ESTATUS

 $Arguments:  objbuffer - The object data
                     size - The object size
                     obj_Type - The type of the object
*******************************************************************************/

ESTATUS M4_StoreExtractedObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type)
{
    ESTATUS estatus;
    EVT_HANDLE evtHandler=NULL;
    char tempFile[14];
    int strLength=0;
    M4_OBJECT_ID objectId;
    TRACE_FUNCTION("M4_StoreExtractedObject");
    memset(evtHandler,0x00,sizeof(EVT_STRUCT));

    evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));
    evtHandler->handler         = M4_StoreExtractedObjectEventHandler;


    if(obj_Type== EMtEmsMelody || obj_Type==EMtEmsNoteFormat)
    {
        FFS_flashData.audio_usr_obj++;
        strLength=sprintf(tempFile,"Audio%d",FFS_flashData.audio_usr_obj);
        objectId=500+ FFS_flashData.audio_usr_obj;        
    }
    else  
    {
        FFS_flashData.image_usr_obj++;
        strLength=sprintf(tempFile,"Image%d",FFS_flashData.image_usr_obj);     
        objectId=500+ FFS_flashData.image_usr_obj;      
    }
    Convert8BitStringToUcs2((const MByte *)&tempFile,strLength,filename);
    estatus = M4_StoreIntoObjectManager(objbuffer,size,evtHandler,obj_Type,objectId);
    // To update the number of extracted objects.
    flash_write();  
    return estatus;
}


/*******************************************************************************

 $Function:     M4_StoreDownloadedObject

 $Description:  Insert the downloaded object into Object manager.
                      xrashmic 29 Nov, 2004 MMI-SPR-26161
 $Returns:    ESTATUS

 $Arguments:  objbuffer - The object data
                     size - The object size
                     obj_Type - The type of the object
*******************************************************************************/
ESTATUS M4_StoreDownloadedObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type )
{
    ESTATUS estatus;
    EVT_HANDLE evtHandler=NULL;
        char tempFile[14];
    int strLength=0;
    M4_OBJECT_ID objectId;

    TRACE_FUNCTION("M4_StoreDownloadedObject");
    memset(evtHandler,0x00,sizeof(EVT_STRUCT));
    evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));
    evtHandler->handler         = M4_StoreDownloadObjEventHandler;
    // xreddymn Jan-31-2005 MMI-SPR-28483: Included MIDI MIME type
    if((obj_Type==EMtMimeAmr)||(obj_Type==EMtMimeMidi))
    {
        FFS_flashData.audio_usr_obj++;
        strLength=sprintf(tempFile,"Audio%d",FFS_flashData.audio_usr_obj);
        objectId=500+ FFS_flashData.audio_usr_obj;                
    }
    else  
    {
         FFS_flashData.image_usr_obj++;
        strLength=sprintf(tempFile,"Image%d",FFS_flashData.image_usr_obj);     
        objectId=500+ FFS_flashData.image_usr_obj;        
    }
    Convert8BitStringToUcs2((const MByte *)&tempFile,strLength,filename);
    estatus = M4_StoreIntoObjectManager(objbuffer,size,evtHandler,obj_Type,objectId);
    // To update the number of downloaded objects.
    flash_write();
    return estatus;

}

/*******************************************************************************

 $Function:     M4_StorePluginObject

 $Description:  Insert the Pluign object into Object manager.
                      xrashmic 28 Jan, 2004 MMI-SPR-28166
 $Returns:    ESTATUS

 $Arguments:  objbuffer - The object data
                     size - The object size
                     obj_Type - The type of the object
*******************************************************************************/
ESTATUS M4_StorePluginObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type )
{
    ESTATUS estatus;
    EVT_HANDLE evtHandler=NULL;
        char tempFile[14];
    int strLength=0;
    M4_OBJECT_ID objectId;

    TRACE_FUNCTION("M4_StoreDownloadedObject");
    memset(evtHandler,0x00,sizeof(EVT_STRUCT));
    evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));
    evtHandler->handler         = M4_StorePluginObjEventHandler;
    // xreddymn Jan-31-2005 MMI-SPR-28483: Included MIDI MIME type
    if((obj_Type==EMtMimeAmr)||(obj_Type==EMtMimeMidi))
    {
        FFS_flashData.audio_usr_obj++;
        strLength=sprintf(tempFile,"Audio%d",FFS_flashData.audio_usr_obj);
        objectId=500+ FFS_flashData.audio_usr_obj;                
    }
    else  
    {
         FFS_flashData.image_usr_obj++;
        strLength=sprintf(tempFile,"Image%d",FFS_flashData.image_usr_obj);     
        objectId=500+ FFS_flashData.image_usr_obj;        
    }
    Convert8BitStringToUcs2((const MByte *)&tempFile,strLength,filename);
    estatus = M4_StoreIntoObjectManager(objbuffer,size,evtHandler,obj_Type,objectId);
    // To update the number of downloaded objects.
    flash_write();
    return estatus;

}

 
#undef MMI_MMSOM_C

