#ifndef _DEF_MMI_MMSMENU_H_
#define _DEF_MMI_MMSMENU_H_


/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                    
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    mmimmsmenu.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: mmimmsmenu.h
       May 11 2005  REF:  MMI-SPR-29887  x0012849
       To Implement the deferred MMS retrieval.
	xrashmic 14 Oct, 2004 MMI-SPR-25291

	26/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/
#undef GLOBAL_EXT
#if defined (MMI_MMSMENU_C)
	#define GLOBAL_EXT
#else
	#define GLOBAL_EXT extern
#endif

/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/

#include "mfw_mfw.h"



/*******************************************************************************
                                                                              
                        Shared Structure Definitions
                                                                              
*******************************************************************************/

#define MENU_TEXT_LENGTH 16	//TBD: to include in common .h
#define MENU_HEADER_LENGTH MENU_TEXT_LENGTH - 4 //TBD: to include in common .h

// Length = to len("from ") + len(number) + len(sms text) + 4 (for \0 \n and optional ionternational character +)
//+possible addition of concatenated status information SPR 1833
#define MAX_EDITOR_LEN (5+MFW_NUM_LEN+MAX_MSG_LEN+4+30)

typedef enum
{
	E_MODE_INIT = 0x0801,
	E_MODE_TOPIC,
	E_MODE_NUMBER,
	E_MODE_TEXT,
	E_MODE_BACK,
	E_MODE_ABORT,
	E_MODE_EXIT,
	E_MODE_OK
} e_MMS_events;

#define MMS_INBOX	0
#define MMS_UNSENT 1
#define MMS_OUTBOX 2
//CRR: 25291 - xrashmic 14 Oct 2004
#define MMS_SENT 3
/*******************************************************************************
                                                                              
                                Function Prototypes
                                                                              
*******************************************************************************/
// Entry points for the different MMS blocs
GLOBAL_EXT int M_exeMMSCreate(MfwMnu* m, MfwMnuItem* i);
// pinghua add for EMS test !!
GLOBAL_EXT int M_exeEMSCreate(MfwMnu* m, MfwMnuItem* i);

GLOBAL_EXT int M_exeMMSInbox(MfwMnu* m, MfwMnuItem* i);
GLOBAL_EXT int M_exeMMSUnsent(MfwMnu* m, MfwMnuItem* i);
//CRR: 25291 - xrashmic 14 Oct 2004
//The Outbox has been removed, instead we now have Sent folder in MMS
GLOBAL_EXT int M_exeMMSSent(MfwMnu* m, MfwMnuItem* i);
GLOBAL_EXT int M_exeMMSSettings(MfwMnu* m, MfwMnuItem* i);
// May 11 2005  REF:  MMI-SPR-29887  x0012849
// prototype of the function
GLOBAL_EXT int MmsRetrievalTypeRequest(MfwMnu* m, MfwMnuItem* i);  



/*******************************************************************************
                                                                              
                              DUMMY DECLARATIONS	
                                                                              
*******************************************************************************/

//Dummy defines

// Dummy global variables



#endif /* _DEF_MMI_MMSMENU_H_ */


