/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                     
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    mmimmsmenu.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                          
 $Date:		    26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSMenu.c

    May 11 2005  REF:  MMI-SPR-29887  x0012849
    To Implement the deferred MMS retrieval.
    CRR: 25291 - xrashmic 14 Oct 2004
    Description: The sent EMS is stored in unsent folder.
    Solution: The Outbox has been removed, instead we now have Sent folder for the sent EMS 

    CRR 25277: 06 Oct 2004 - xpradipg
    Description: Recieving an ems when inbox is open
    Solution: A refresh event is sent to the Inbox list which inturn updates 
    the list

    xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
    All the status screen, .i.e sending, receiving etc. are displayed separatly for the MMS module.
    Previously the WAP screens were being used. 

	26/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/

#define MMI_MMSMENU_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
//#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"


#include "dspl.h"

#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiMmi.h"

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
//#include "MmiEditor.h"
#include "MmiBookShared.h"
#include "mmimmsmenu.h"
#include "mmimmsbox.h"
//#include "mmismssend.h"
//#include "mmiSmsIdle.h"

#include "cus_aci.h"

#include "mfw_ffs.h"
//#include "pcm.h"

#include "mmiColours.h"

extern T_MFW_HND MMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);

//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
int MMSactive=FALSE;
//CRR 25277: 06 Oct 2004 - xpradipg
//stores the window handle for the MMS Inbox listing
MfwHnd mmsboxwinhnd;
/*******************************************************************************

 $Function:     M_exeMMSCreate

 $Description:  This function is called when the user press Create MMS in the
          main MMS menu

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/

int M_exeMMSCreate(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());
    //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
    //This flag is set as soon as we enter the MMS create screen. So that all the status/error information
    // is passed to the MMS module.
    MMSactive=TRUE;
#ifdef FF_MMI_MMS
  /* Call the function that manages Create MMS */
  MMSCreate_start(win, NULL);
#endif

  return 1;
}

/*******************************************************************************

 $Function:     M_exeEMSCreate   pinghua add  for EMS test add 

 $Description:  This function is called when the user press Create MMS in the
          main MMS menu

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/

int M_exeEMSCreate(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());

   /* Call the function that manages Create EMS */
   EMSCreate_start(win, NULL);
   //T_MFW_HND EMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);

  return 1;
}

/*******************************************************************************

 $Function:     M_exeMMSInbox

 $Description:  This function is called when the user press MMS inbox in the
          main MMS menu

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/

int M_exeMMSInbox(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());

  /* Call the function that manages Inbox */
  //CRR 25277: 06 Oct 2004 - xpradipg
  //The Inbox window handle is being assigned
  mmsboxwinhnd = MMSBox_start(win, (MfwMnuAttr*)MMS_INBOX);

  return 1;
}

/*******************************************************************************

 $Function:     M_exeMMSUnsent

 $Description:  This function is called when the user press MMS outbox in the
          main MMS menu

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/
int M_exeMMSUnsent(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());

  /* Call the function that manages Create MMS */
  MMSBox_start(win, (MfwMnuAttr*)MMS_UNSENT);

  return 1;
}

/*******************************************************************************

 $Function:     M_exeMMSSent

 $Description:  This function is called when the user press MMS Sent in the
          main MMS menu.
      	   CRR: 25291 - xrashmic 14 Oct 2004
	   The Outbox has been removed, instead we now have Sent folder in MMS

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/
int M_exeMMSSent(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());

  /* Call the function that manages Create MMS */
  MMSBox_start(win, (MfwMnuAttr*)MMS_SENT);

  return 1;
}

/*******************************************************************************

 $Function:     M_exeMMSSettings

 $Description:  This function is called when the user press MMS settings in the
          main MMS menu

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/
int M_exeMMSSettings(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND       win  = mfwParent(mfw_header());


#ifdef FF_MMI_MMS
  /* Call the function that manages Create MMS */
  MMSSetting_start(win, NULL);
#endif

  return 1;
}
// May 11 2005  REF:  MMI-SPR-29887  x0012849
// New Function is added.
/*******************************************************************************
 $Function:     MmsRetrievalTypeRequest

 $Description:  This function is called when the user press MMS Retrieval Type  in the
          main MMS menu
 $Returns:    1 always 
 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/
int MmsRetrievalTypeRequest(MfwMnu* m, MfwMnuItem* i)
{
    int index = m->lCursor[m->level];
    T_DISPLAY_DATA DisplayInfo;   
    T_MFW_HND win  = mfwParent(mfw_header());
     int TextId2;
     int8 Result;	
    BOOL RetrievalType=FALSE;
    TRACE_FUNCTION("MmsRetrievalTypeRequest");     
    switch(index)
    	{
    	  case 0:
		  Result=flash_mms_retrieval_type_write( 0);	
		   if(0 ==  Result)
		   	TextId2 = TxtChanged ;
		   else
		   	TextId2 = TxtFailed; 
		  break;
         case 1:
	 	 Result=flash_mms_retrieval_type_write( 1);
		   if(0 ==  Result)
		   	TextId2 = TxtChanged ;
		   else
		   	TextId2 = TxtFailed; 		 
		 break; 
	  case 2:
	        flash_mms_retrieval_type_read(&RetrievalType);
	        if(0 == RetrievalType) // immediate
		      TextId2      = TxtImmediate;
		 else
		      TextId2      = TxtDeferred;	
		 break;
	  default:
	  	 break;
    	}	  
	dlg_initDisplayData_TextId( &DisplayInfo, TxtSoftOK, TxtNull,TxtRetrieveCondition, TextId2, COLOUR_POPUP);
       dlg_initDisplayData_events( &DisplayInfo, (T_VOID_FUNC)NULL, THREE_SECS, KEY_LEFT );	
      	info_dialog(win,&DisplayInfo);       
    	return 1;
}
#undef MMI_MMSMENU_C

