#ifndef _DEF_MMI_MMSCREATE_H_
#define _DEF_MMI_MMSCREATE_H_


/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                     
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    MmiMMSCreate.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSCreate.h

       x0012849:Feb 03 2005 MMI-SPR-28224 
       To allow user to enter more no of characters while creating MMS.   
       
	26/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/

/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/

#include "mfw_mfw.h"

/*******************************************************************************
                                                                              
                        Shared Structure Definitions
                                                                              
*******************************************************************************/

#define MENU_TEXT_LENGTH 16	//TBD: to include in common .h
#define MENU_HEADER_LENGTH MENU_TEXT_LENGTH - 4 //TBD: to include in common .h
//x0012849 Feb-03-2005 MMI-SPR-28224 :
//To allow more characters to be entered while creating MMS .
#define MAX_MMS_TEXT_LEN 	100  // was 32 
#define MAX_MMS_TOPIC_LEN 16



/*******************************************************************************
                                                                              
                                Function Prototypes
                                                                              
*******************************************************************************/

T_MFW_HND MMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);
T_MFW_HND MMSInbox_start(T_MFW_HND parent_window, MfwMnuAttr *data);
T_MFW_HND MMSOutbox_start(T_MFW_HND parent_window, MfwMnuAttr *data);
T_MFW_HND MMSSettings_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);
//xrashmic 14 Dec, 2004 MMI-SPR-23921
T_MFW_HND MMSFwd_start();
/*******************************************************************************
                                                                              
                              DUMMY DECLARATIONS	
                                                                              
*******************************************************************************/

//Dummy defines

// Dummy global variables



#endif /* _DEF_MMI_MMSCREATE_H_ */

