
/*******************************************************************************

                	TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                      
 $Project code:	BMI (6349)                                                           
 $Module:    	MMS
 $File:            MmiMMSCreate.h
 $Revision:    	1.0                                                       
                                                                              
 $Author:    	Yan Bin(bin-yan@ti.com)                                                         
 $Date:            26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSCreate.h
    Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
    Description:	MMS: During MMS Reply, Enter Number shows Empty.
    Solution:		Senders number is extracted from the Message Header and is displayed.

    xrashmic 17 Jun, 2005 MMI-SPR-29992
    For sending MMS on CHT sim, the FROM address should be NULL. 
    May 11 2005  REF:  MMI-SPR-29887  x0012849
    To Implement the deferred MMS retrieval.

    xreddymn Mar-08-2005, MMI-SPR-28820
    Fix for flickering issue (drawing occuring more than once) when
    forwarding MMS and creating new MMS

    xreddymn Feb-07-2005, MMI-SPR-28277
    Fix for blank content on entering the MMS Editor-Viewer when
    forwarding MMS messages.
     xreddymn Mar-04-2005 MMI-SPR-26144
    Added changes for cancel sending MMS

    xrashmic 08 Feb, 2005 MMI-SPR-27853
    Error handling in sending MMS and also displaying the progress  value
       
    x0012849 Feb- 03 -2005 : MMI-SPR-28224 
    To allow user to scroll up and down if contents of MMS are bigger than screen size.
    
    xrashmic 14 Dec, 2004 MMI-SPR-23921
    Implementing the forward functionality for MMS

    xrashmic 30 Nov, 2004 MMI-SPR-26145
    xrashmic 22 Dec, 2004 MMI-SPR-27798
    Moving the MMS to sent folder after it is sent

    xrashmic 3 Nov, 2004 MMI-SPR-26145
    Deleting the compose and option window after sending the MMS

    MMI-SPR-25278: Nov-29-2004 - xreddymn
    Implemented FFS limits for MMS/EMS storage

    CRR: 25302 - xpradipg 10 Nov 2004
    Description: Should be able to select the number from the phonebook while
    sending MMS/EMS.
    Solution: The new feature to select the number from phonebook while sending
    MMS/EMS is added

    xrashmic 9 Nov, 2004 MMI-SPR-26147
    Description: The inserted text in the MMS message was not editable and the 
    text editor was limited to a maximum of 32 characters.
    Solution: The text buffer is memset to '\0' only once at the time of 
    MMS create - MWM_CREATE and increased the editor max size to 512.

    xrashmic 6 Oct, 2004 MMI-SPR-25147
    MMS not saving to unsent folder for all scenarios.

    MMI-SPR-24735: Sep-16-2004 - xreddymn
    Changes related to EMS screen flickering issue

    MMI-SPR-24733, Sep-17-2004 - xreddymn
    Modified case MWM_REFRESH to prevent edit mode being disabled

    CRR: 23942 - xpradipg 26 Aug 2004
    Description: Default values to be removed in text editor of MMS and EMS
    Solution: The buffer assigned to the text editor is reset.

    xreddymn 03 Sep, 2004
    Display issue MMI-SPR-23961 related changes: Modified suspend and resume operation of MMS editor

    CRR:23923 - xpradipg 06 Sept 2004
    Description: MMS Preview not working
    Solution: The preview is displayed in a new window by posting the 
    appropriate events to MMS client

    CRR: 23942 - xpradipg 26 Aug 2004
    Description: Default values to be removed in number editor of MMS and EMS
    Solution: The strcpy() of the hardcoded numbers to the editor buffer are commented

    xreddymn 20 Aug, 2004
    Display issue MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): Added mechanism to prevent MMS/EMS display, while outside the MMS/EMS editor
    MMS save issue MMI-SPR-24113 (TII_MMS53): Prevented creation of entries for unsaved messages on pressing back from MMS editor

    xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
    All the status screen, .i.e sending, receiving etc. are displayed separatly for the MMS module.
    Previously the WAP screens were being used. 

    Bug Id 23 : 		16 Aug, 2004 - xpradipg  
    Description:Remove insert slide from options menu
    Solution: removed the insert slide item from the menu item array

	17/01/04			Replace mfw edit with AUI edit.	
	26/08/03	    	Original TI(Shanghai) BMI version.    
       
 $End

*******************************************************************************/
#define MMI_MMSCREATE_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
//#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"

#include "psa_util.h"

#include "dspl.h"
// #include "unicode_types.h"

#include "MmiMain.h"
#include "MmiDummy.h"
//#include "MmiLists.h"
#include "MmiMmi.h"
#include "mmiCall.h"//GW 29/11/01 for 'callNumber'

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"

#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else /* NEW_EDITOR */
#ifdef EASY_TEXT_ENABLED
#include "MmiLatinPredText.h"
#endif /* EASY_TEXT_ENABLED */
#include "MmiEditor.h"
#endif /* NEW_EDITOR */

#include "MmiBookShared.h" // MZ 
#include "mmimmsmenu.h"
#include "mmimmscreate.h"
#include "mmimmsom.h"
#include "mmiwindow.h"
#include "mfw_ffs.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "aci_cmh.h"    //GW 29/11/01 added for types in aci_fd.h
#include "aci_fd.h"        //GW 29/11/01 added for types in 'cmh.h'
#include "cmh.h"         //GW 29/11/01 added for types in 'cmh_phb.h'
#include "cmh_phb.h"    //GW 29/11/01 added for cmhPHB_getAdrStr

#include "mmiColours.h"

//CRR: 25302 - xpradipg 10 Nov 2004
#include "mmiSmsMenu.h"
#include "mmismssend.h"

// ronaldc 8-5

#include "mg4def.h"
#include "evtdefs.h"
#include "mg4stu.h"
#include "Mg4Dal.h"
#include "mg4devif.h"
#include "dalevt.h"
#include "evif.h"
#include "mg4str.h"
#include "mmif.h"
#include "mg4mem.h"

#include "AUIWapext.h"
#include "ATBData.h"
#include "AUIWap.h"
//xmzhou02 to include definition for ALL_WIN & WAP_MMS



//GW 29/11/01 - added header file - removed extern void callNumber(UBYTE* number);
MfwWin* getWinData( MfwHnd win);

//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
extern int MMSactive;

extern void M4_DebugMessage(unsigned long para);
//CRR:23923 - xpradipg 06 Sept 2004
extern int MMSBox_Read_kbd_cb (MfwEvt e, MfwKbd *k);

//xrashmic 30 Nov, 2004 MMI-SPR-26145
//xrashmic 20 Dec, 2004  MMI-SPR-23921
T_MFW_HND mms_create_opt_hnd=NULL;
T_MFW_HND mms_create_hnd=NULL;

//xrashmic 14 Dec, 2004 MMI-SPR-23921
T_MFW_HND mms_Fwdcreate_hnd=NULL;
extern MM_S_MESSAGE_HEADER_LIST*	g_pMessageHeaderList;
extern int g_currentMessage;
MM_S_MESSAGE_HEADER 	*fwd_msg_header;


/*********************************************************************

                 DYNAMIC MENU WINDOW. DECLARATION

**********************************************************************/


static int MMSCreate_OPTexeSend(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeInsPicture(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeInsSound(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeInsText(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeInsSlide(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeDelPicture(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeDelSound(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeDelText(MfwMnu* m, MfwMnuItem* i);
static int MMSCreate_OPTexeSave(MfwMnu* m, MfwMnuItem* i);
//CRR:23923 - xpradipg 06 Sept 2004
static int MMSCreate_OPTpreviewMsg(MfwMnu* m, MfwMnuItem* i);

static MfwMnuItem MMSCreate_OPTDeleteItems [] =
{
    {0,0,0,(char *)TxtMMSDeletePicture,0,(MenuFunc)MMSCreate_OPTexeDelPicture,item_flag_none},
    {0,0,0,(char *)TxtMMSDeleteSound,0,(MenuFunc)MMSCreate_OPTexeDelSound,item_flag_none},
    {0,0,0,(char *)TxtMMSDeleteText,0,(MenuFunc)MMSCreate_OPTexeDelText,item_flag_none}
};
static MfwMnuAttr MMSCreate_OPTDeleteAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    MMSCreate_OPTDeleteItems,                      /* with these items         */
    sizeof(MMSCreate_OPTDeleteItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE
};

static MfwMnuItem MMSCreate_OPTItems [] =
{
    {0,0,0,(char *)TxtSend,0,(MenuFunc)MMSCreate_OPTexeSend,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertPicture,0,(MenuFunc)MMSCreate_OPTexeInsPicture,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertSound,0,(MenuFunc)MMSCreate_OPTexeInsSound,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertText,0,(MenuFunc)MMSCreate_OPTexeInsText,item_flag_none},
    //Bug Id 23 : 		16 Aug, 2004 - xpradipg  
    //Description:Remove insert slide from options menu 
    //{0,0,0,(char *)TxtMMSInsertSlide,0,(MenuFunc)MMSCreate_OPTexeInsSlide,item_flag_none},
    {0,0,0,(char *)TxtSave,0,(MenuFunc)MMSCreate_OPTexeSave,item_flag_none},
    {0,0,0,(char *)TxtMMSDelete,&MMSCreate_OPTDeleteAttrib,0,item_flag_none},
    //CRR:23923 - xpradipg 06 Sept 2004
    //Added the functionality for preview message
   //xrashmic 6 Oct, 2004 MMI-SPR-25147
   //Since the Compose screen itself is in preview mode, no need for this 
   //in the options menu
   // {0,0,0,(char *)TxtMMSPreview,0,(MenuFunc)MMSCreate_OPTpreviewMsg,item_flag_none}
};

static MfwMnuAttr MMSCreate_OPTAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    MMSCreate_OPTItems,                      /* with these items         */
    sizeof(MMSCreate_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE

};

#if 1

// bernards bbssoo 25.9.2003 begin

typedef enum 
{
	MMI2_NEW_MSG= -9,
	MMI2_DELETE_MSG,
	MMI2_STORE_MSG_HDR,
	MMI2_SEND_MSG,
	MMI2_GET_MSG,
	MMI2_FWD_MSG,
	MMI2_PROCESSACK
}MMI2_EVT_TYPE;

typedef struct 
{
   EVT_STRUCT    evtStruct; 
   MMI2_EVT_TYPE  eType;
}MMI2_EVT_STRUCT;

typedef MMI2_EVT_STRUCT* MMI2_EVT_HANDLE;

static ESTATUS MMI_2_EventHandler(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle);


MM_S_MESSAGE_HEADER *msgHeader=NULL;

// ronaldc 9-4 to 9-5: add start
MM_S_MESSAGE_HEADER 	g_msg_header;
EVT_STRUCT     	g_event_struct;
EVT_STRUCT     	g_doc_event_struct;
MM_MESSAGE_ID		g_msg_id;
EV_S_NEWSLIDE_INFO g_NewSlideInfo;
UCS2 g_insertString[128] = {'t','e','s','t',0};
MSafeString g_safeString;
BOOL g_inSendMode=FALSE;

//xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): To keep track of MMS display
BOOL g_M4_display_active=FALSE;
//xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): To keep track of saved messages
BOOL g_M4_message_saved=FALSE;
BOOL g_inSaveMode=FALSE;
//xreddymn Aug-26-2004
extern UINT8 gucMmsTitleBarHeight;
//xreddymn Nov-26-2004 MMI-SPR-25278
T_MFW_HND g_inSaveModeWin;
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern void AUI_mms_status_notify(int status);

//xrashmic 9 Nov, 2004 MMI-SPR-26147
static char text[MAX_MMS_TEXT_LEN];
//xreddymn Feb-02-2005 MMI-SPR-28277: Used to trigger EMG4_Refresh when forwarding MMS
BOOL gMmsForwardStart=FALSE;

void DummyFreeFunc(void *pMemBlock)
{
    return;
}
//xrashmic 08 Feb, 2005 MMI-SPR-27853
int progressValue=0;

ESTATUS MMI_1_EventHandler(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{

	M4_DebugMessage((unsigned long) 0x9700);
	M4_DebugMessage((unsigned long) aeId);
	M4_DebugMessage((unsigned long) aeType);
	M4_DebugMessage((unsigned long) ampParam);
	M4_DebugMessage((unsigned long) evtHandle);


	switch(aeId)
	{
#if 0

	case EMG4_PlayComplete:
		switch(MMI1EvtHandle->mmievtType)
		{
		case MMI1_EV_PLAY_MSG:
			// Message has finished playing, so tell user thru EV window
			aPoint.uX = 0;
			aPoint.uY = 0;
			DeviceClearOffscreenBuffer();
			DAL_DrawText(&aPoint, _T("(End of show)"), 13, afmStyle, &aColour);
			DeviceUpdateScreen();
			break;
		};
		 break;

	case EMG4_PreviewComplete:
		switch(MMI1EvtHandle->mmievtType)
		{
		case MMI1_EV_CREATE_MSG:
		case MMI1_EV_OPEN_MSG:
			/*Call Preview Routine to post end Preview */
			if(l_bIsPreview)
			{
				MMI_1_Preview(g_hwndMMI1);
			}
			break;
		default:
			break;
		};
		break;
#endif

/*********************  Editor Viewer CallBacks   *********************/
	case EMG4_FileOpDone:
		M4_DebugMessage((unsigned long) 0x9701);
		// xreddymn Feb-02-2005 MMI-SPR-28277: If forwarding an MMS message, post EMG4_Refresh
		if(gMmsForwardStart == TRUE)
		{
			// xreddymn Mar-08-2005 MMI-SPR-28820: change sequence of posting
			// EMG4_Preview and EMG4_Resume
			action_PreviewMessage();
			action_ResumeEditor();
			gMmsForwardStart = FALSE;
		}
		if (g_inSendMode == TRUE) 
		{
			M4_DebugMessage((unsigned long) 0x9702);
                    //xrashmic 08 Feb, 2005 MMI-SPR-27853
                    //Indicate the saving is done and sending has started
                    // xreddymn Mar-04-2005 MMI-SPR-26144
                    // MMS send progress is updated by WAP FSM
                    // progressValue=0;
                    // AUI_mms_status_notify(MMS_SEND_PROGRESS);
			MMI_2_OnSendMessage();
                    //xrashmic 08 Feb, 2005 MMI-SPR-27853
                    //Indicate the saving is done and sending has started
                    // progressValue=0;
                    // AUI_mms_status_notify(MMS_SEND_PROGRESS); 
			g_inSendMode=FALSE;

			// xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): To keep track of saved messages
			g_M4_message_saved=TRUE;
		}		
		// xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): To keep track of saved messages
		if(g_inSaveMode == TRUE)
		{
			winDelete(g_inSaveModeWin);
			g_inSaveMode=FALSE;
			g_M4_message_saved=TRUE;
			// xreddymn Nov-27-2004 MMI-SPR-25278: Display "Saved" dialog here
                    //xrashmic 08 Feb, 2005 MMI-SPR-27853
                    //Added few more parameters for this function   
        		information_dialog(TxtSaved,TxtNull,NULL,NULL, TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
		}
		break;
	// xrashmic Nov-17-2004 MMI-SPR-25278: Changes for FFS error handling
	case EMG4_OpError:
		{
			MDword reason;

			// xreddymn Feb-02-2005 MMI-SPR-28277: If forwarding an MMS message and OpenDocument fails, reset gMmsForwardStart
			if(gMmsForwardStart==TRUE)
			{
				gMmsForwardStart=FALSE;
			}
			if(g_inSaveMode == TRUE)
			{
				winDelete(g_inSaveModeWin);
				g_inSaveMode=FALSE;
				g_M4_message_saved=FALSE;
			}
                                    
			reason = (ampParam & 0x3FFF);
			switch(reason)
			{
				case EFileOpFailed:
                                //xrashmic 08 Feb, 2005 MMI-SPR-27853
                                //When sending MMS if there are file op erros, we need to handle them here
                                if (g_inSendMode == TRUE) 
                                {
                                       g_inSendMode=FALSE;
                                       AUI_mms_status_notify(MMS_SEND_FAIL); 
                                }
                                else
                                {
            				// xreddymn Nov-27-2004 MMI-SPR-25278: Display "Error" dialog here
                                        //xrashmic 08 Feb, 2005 MMI-SPR-27853
                                        //Added few more parameters for this function   
            				information_dialog(TxtFailed,TxtFatalError,NULL,NULL, TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
                                }
				break;
			}
		
		}
		break;
     default:
        break;  
	}

	return ENoError;

}






ESTATUS Handler_MM_CreateMessageEntryAsync(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
		
	ESTATUS eStatus;

//	TRACE_EVENT("MAGIC4: Handler_MM_CreateMessageEntryAsync()");
        
	g_msg_id = (MM_MESSAGE_ID) ampParam;

	M4_DebugMessage((unsigned long) 0x30000);
	M4_DebugMessage((unsigned long) g_msg_id);


	g_doc_event_struct.handler = MMI_1_EventHandler;
	g_doc_event_struct.parentEvtHandle = NULL;
	g_doc_event_struct.pData = NULL;
	g_doc_event_struct.userFlag = 0;

	eStatus=EV_CreateDocument(&g_doc_event_struct, EMtMmsSmil, g_msg_id);

	if (eStatus!=ENoError) {
    	M4_DebugMessage((unsigned long) 0x34000);
    	M4_DebugMessage((unsigned long) eStatus);
    }

	g_NewSlideInfo.omh.freeFunc = DummyFreeFunc;
// xreddymn Aug-27-2004 MMI-SPR-23919 (TII_MMS6): Modified slide duration to infinite
//	g_NewSlideInfo.slideDuration = 5000;
	g_NewSlideInfo.slideDuration = 0;
	g_NewSlideInfo.slidePosition = 1;

//	rvf_delay(10);
	DAL_PostMessage(EMG4_InsertNewSlide, EMG4_Type_NotUsed, (MESSAGE_PARAM)&g_NewSlideInfo, 0);
#if 0	
//	rvf_delay(10);    
	DAL_PostMessage(EMG4_InsertString, EMG4_Type_NotUsed, (MESSAGE_PARAM)g_TestString, 0);
//	rvf_delay(10);
	DAL_PostMessage(EMG4_SaveMsg, EMG4_Type_NotUsed, 0, 0);
//	rvf_delay(10);
	DAL_PostMessage(EMG4_Exit, EMG4_Type_NotUsed, 0, 0);
//	rvf_delay(10);
#endif	
	M4_DebugMessage((unsigned long) 0x30001);
	return ENoError;
}
 
void OrthusCreateMessageEntryAsync(void)
{
	ESTATUS eResult;
    
	TRACE_EVENT("MAGIC4: OrthusCreateMessageEntryAsync()");
        
	g_msg_header.memHdr.freeFunc = DummyFreeFunc;
    
	g_msg_header.id = MM_INVALID_MESSAGE_ID;
	g_msg_header.messageFlags = 0;
	g_msg_header.reference = 0;
	g_msg_header.read = EFalse;
	g_msg_header.complete = EFalse;
	g_msg_header.drmSet = EFalse;
    
	memset(&(g_msg_header.timestamp), 0, sizeof(MM_S_TIME_STAMP));
        
	g_msg_header.timestamp.type = ETimestampAbsolute;
	g_msg_header.location = EMlDraft;
    
	g_msg_header.type = EMtMmsSmil;
    
	g_msg_header.messageTypeHeader.mmsHeader.pBccList = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pCcList = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pContentType = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pFrom = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pMmsTransactionId = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pServerMessageId = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pSubject = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pToList = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.pUrl = NULL;
	g_msg_header.messageTypeHeader.mmsHeader.size = 0;
	g_msg_header.messageTypeHeader.mmsHeader.version = 1;
	g_msg_header.messageTypeHeader.mmsHeader.deliveryReport = EFalse;
	g_msg_header.messageTypeHeader.mmsHeader.readReport = EFalse;
        
	memset(&(g_msg_header.messageTypeHeader.mmsHeader.expiryTime), 0, sizeof(MM_S_TIME_STAMP));
	memset(&(g_msg_header.messageTypeHeader.mmsHeader.currentDate), 0, sizeof(MM_S_TIME_STAMP));
        
	g_msg_header.messageTypeHeader.mmsHeader.currentDate.type = ETimestampAbsolute;

	g_msg_header.messageTypeHeader.mmsHeader.expiryTime.type = ETimestampRelative;
            
	g_msg_header.messageTypeHeader.mmsHeader.priority = EMPnormal;
    
	g_msg_header.messageTypeHeader.mmsHeader.setDeferred = EFalse;
	g_msg_header.messageTypeHeader.mmsHeader.setRejected = EFalse;
	g_msg_header.messageTypeHeader.mmsHeader.expired = EFalse;        
	g_msg_header.messageTypeHeader.mmsHeader.retrieved = EFalse;
	g_msg_header.messageTypeHeader.mmsHeader.readRemote = EFalse;    
    
	g_event_struct.handler = Handler_MM_CreateMessageEntryAsync;
	g_event_struct.parentEvtHandle = NULL;
	g_event_struct.pData = NULL;
	g_event_struct.userFlag = 0;

	M4_DebugMessage((unsigned long) g_event_struct.handler);

	eResult = MM_CreateMessageEntryAsync((EVT_HANDLE) &g_event_struct, &g_msg_header);    
	if(eResult!=ENoError)
	{
		TRACE_EVENT("MAGIC4: MM_CreateMessageEntryAsync() fail");
	}
	// xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): To keep track of when the MMS is saved
	else
	{
		g_M4_message_saved=FALSE;
	}

	g_safeString.memHeader.freeFunc = DummyFreeFunc;    /*!< Pointer to memory deallocation function */
	g_safeString.size=10;                            /*!< size of the string */
	g_safeString.pString=g_insertString;            /*!< Pointer to UCS2 string */
}


/*************************************************************************/
/**
    Send the selected message...

    \param hWnd [in] Of this Window...i.e MMI_2

    \return <???>

/*************************************************************************/
BOOL MMI_2_OnSendMessage()
{
    //MInt32 nSel=0; 
    MMI2_EVT_HANDLE pHandle=NULL;
    ESTATUS eResult=ENoError;

 	pHandle = (MMI2_EVT_HANDLE)malloc(sizeof(MMI2_EVT_STRUCT));
	if(!pHandle)
	{
		//M4_SIM_DisplayError(hWnd,_T("Mem Alloc Error"));
		return TRUE;
	}
        
	pHandle->evtStruct.handler = MMI_2_EventHandler;
    	pHandle->evtStruct.parentEvtHandle = NULL;
    	pHandle->evtStruct.pData = NULL;
    	pHandle->evtStruct.userFlag = 0;
    	pHandle->eType              = MMI2_SEND_MSG;

       M4_DebugMessage((unsigned long) 0x94001);

       eResult= TM_SendMessageAsync((EVT_HANDLE)pHandle, g_msg_id);
       
       M4_DebugMessage((unsigned long)g_msg_id);

    
	if(eResult!=ENoError)
	{
               //M4_SIM_ReportError(eResult,hWnd);
    		free(pHandle);
	    	pHandle=NULL;
	}   
	return TRUE;
}

/*********************/

//NM moved this function  to mmimmsbox.c
#if 0
UCS2 * MMS_ConvertStringToUcs2 (const MByte * const p8BitString,
                                           const MUint uLength,
                                           UCS2        * pUcs2String)
{
    if ((UCS2 *) NULL == pUcs2String)
    {
        pUcs2String = (UCS2 *)MM_MALLOC(sizeof(UCS2) * (1 + uLength));
    }

    if ((UCS2 *)NULL != pUcs2String)
    {
        register MUint uIndex;
        for (uIndex = 0; uIndex < uLength; ++uIndex)
        {
            pUcs2String[uIndex] = (UCS2)p8BitString[uIndex];
        }
        pUcs2String[uIndex] = NULLCHAR;
    }

    return pUcs2String;
}

#endif

/*******************************************************************************

 $Function:    	cancel_TMsend

 $Description:	Posts MMS send cancel to MMS client
 
 $Returns:    	none

 $Arguments:	none

*******************************************************************************/

//xrashmic 26144
void cancel_TMsend(void)
{
     char temp[100];
    ESTATUS eResult=ENoError;
    TRACE_EVENT("cancelSendingMMS");
    sprintf(temp, "####cancelSendingMMS");
    M4_DebugStringMessage(temp, strlen(temp), 0);
    eResult= TM_SendMessageCancel( g_msg_id);
    if(eResult!=ENoError)
    {
     sprintf(temp, "####cancelSendingMMS done");
                   M4_DebugStringMessage(temp, strlen(temp), 0);
    }   
}

//May 17 2005  REF:  MMI-SPR-29887  x0012849
// Called when user cancels the recieving operation
void cancel_TMrecieve(void)
{
    ESTATUS eResult=ENoError;
    TRACE_EVENT("cancel_TMrecieve");
    eResult= TM_GetMessageCancel ( g_pMessageHeaderList->ppList[g_currentMessage].id);  
    if(eResult!=ENoError)
    {
       TRACE_EVENT("CancelRecievingMMS done");		
    }   
}
//Jun 28 2005  REF:  MMI-SPR-29887  x0012849  
ESTATUS Handler_MM_DeleteMessageBodyEntryAsync(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
	return ENoError;
}
//Jun 28 2005  REF:  MMI-SPR-29887  x0012849  
void  Delete_Body(void) 
  {
   g_event_struct.handler = Handler_MM_DeleteMessageBodyEntryAsync;
   g_event_struct.parentEvtHandle = NULL;
   g_event_struct.pData = NULL;
   g_event_struct.userFlag = 0;
   MM_DeleteMessageBodyAsync((EVT_HANDLE) &g_event_struct, g_pMessageHeaderList->ppList[g_currentMessage].id);
  }

void MMI_2_SaveHeaderInfo(char *topic, char *number)
{

    //char from[]="13801639314/TYPE=PLMN";//bernard
    //char from[]="60765943/TYPE=PLMN";
    char from[]="/TYPE=PLMN";
    
    UCS2    *pUcsFrom= NULL;
    UCS2    *pUcsTopic = NULL;
    UCS2    *pUcsNumber = NULL;
    MMI2_EVT_HANDLE evtHandle=NULL;
    ESTATUS eResult;

    char temp[100];
    char tempNumber[100];

    sprintf(temp, "MMI_2_SaveHeaderInfo called %s, %s", topic, number);
    //M4_DebugStringMessage(temp, strlen(temp), 0);
    
    //xrashmic 17 Jun, 2005 MMI-SPR-29992
    //For sending MMS on CHT sim, the FROM address should be NULL. 
    /*pUcsFrom= (UCS2 *)MMS_ConvertStringToUcs2((const MByte *)from, 
                                            GetByteStringLength((const MByte *)from),
                                            pUcsFrom);
    */
    pUcsTopic = (UCS2 *)MMS_ConvertStringToUcs2((const MByte *)topic, 
                                            GetByteStringLength((const MByte *)topic),
                                            pUcsTopic);
    if (NULL == pUcsTopic)
    {
        sprintf(temp, "MMI_2_SaveHeaderInfo called pUcsTopic = NULL");
        //M4_DebugStringMessage(temp, strlen(temp), 0);
        return;
    }

    sprintf(temp, "MMI_2_SaveHeaderInfo number=%s", number);
    //M4_DebugStringMessage(temp, strlen(temp), 0);

    strcpy(tempNumber, number);
    strcat(tempNumber,"/TYPE=PLMN"); 

    sprintf(temp, "MMI_2_SaveHeaderInfo tempNumber=%s", tempNumber);
    //M4_DebugStringMessage(temp, strlen(temp), 0);

    pUcsNumber= (UCS2 *)MMS_ConvertStringToUcs2((const MByte *)tempNumber, 
                                           GetByteStringLength((const MByte *)tempNumber),
                                           pUcsNumber);
    
    if (pUcsNumber == NULL)
    {
        sprintf(temp, "MMI_2_SaveHeaderInfo pUcsNumber == NULL");
        //M4_DebugStringMessage(temp, strlen(temp), 0);
    }    
    
    if (NULL == pUcsNumber)
    {
        MMS_FREE(pUcsTopic);
        return;
    }

//-----------------------

	eResult= DAL_RetrieveMessageHeader(g_msg_id,&msgHeader);
	if(eResult!=ENoError)
	{
		M4_DebugMessage((unsigned long)0x4400);
		return;
	}

       msgHeader->messageTypeHeader.mmsHeader.pFrom = pUcsFrom;
       msgHeader->messageTypeHeader.mmsHeader.pToList = pUcsNumber;
       msgHeader->messageTypeHeader.mmsHeader.pSubject = pUcsTopic;
       
	   
//-----------------------


	/* Form the event Handler */
	evtHandle = (MMI2_EVT_HANDLE)malloc(sizeof(MMI2_EVT_STRUCT));
	evtHandle->evtStruct.handler =  MMI_2_EventHandler;
	evtHandle->evtStruct.parentEvtHandle = NULL;
	evtHandle->evtStruct.pData    = NULL;
	evtHandle->evtStruct.userFlag = 0;
	evtHandle->eType			  =  MMI2_STORE_MSG_HDR;

	DAL_ModifyMessageParamsAsync((EVT_HANDLE)evtHandle,g_msg_id,msgHeader);

	//msgHeader->memHdr.freeFunc(msgHeader);

}


/*************************************************************************/
/**
    EVENT HANDLER: Message Dialog (MMI_2)    
    
    \param  aeId      [in]     EVENT_ID
    \param  ampParam  [in]     MESSAGE_PARAM
    \param  evtHandle [in]     EVT_HANDLE
    \return None      [out]    
/*************************************************************************/
ESTATUS MMI_2_EventHandler(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{
	MMI2_EVT_HANDLE MMI2evtHandle = (MMI2_EVT_HANDLE) EvtHandle;
	BOOL bProcessed = FALSE;
	T_WAP_DATA *data = AUI_wap_data();
	data->View->Title[0] = 0;

	M4_DebugMessage((unsigned long) 0x9800);
	M4_DebugMessage((unsigned long) aeId);
	M4_DebugMessage((unsigned long) aeType);
	M4_DebugMessage((unsigned long) ampParam);
	M4_DebugMessage((unsigned long) EvtHandle);


    switch(aeId)
    {
        case EMG4_NetworkOpDone:
        switch(MMI2evtHandle->eType)
        {
        case MMI2_SEND_MSG:
            //xrashmic 22 Dec, 2004 MMI-SPR-27798
            // MMS send is successful, save it to sent folder
            MM_BeginUpdateHeader(g_msg_id);
            MM_UtilSetFolder(g_msg_id,EMlSent);
            MM_CommitUpdateHeaderAsync(NULL, g_msg_id);

            //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
            // To display the MMS send Success dialog here.
            //xrashmic 08 Feb, 2005 MMI-SPR-27853
            AUI_mms_status_notify(MMS_SEND_SUCCESS); 
            bProcessed=TRUE;
        	break;
        default:
             break;
        }
    	break;
        //xrashmic 08 Feb, 2005 MMI-SPR-27853
        // Need to display to the user the send progress infomation
        case EMG4_OpProgress:
                switch(MMI2evtHandle->eType)
                {
                    case MMI2_SEND_MSG:
                            // xreddymn Mar-04-2005 MMI-SPR-26144
                            // MMS progress is updated by WAP FSM
                            // progressValue=ampParam;
                            // AUI_mms_status_notify(MMS_SEND_PROGRESS); 
                        break;
                    default:
                        break;
                }
            break;
        //xrashmic 08 Feb, 2005 MMI-SPR-27853
        //Need to catch the errors when the sending fails            
        case EMG4_OpError:
                switch(MMI2evtHandle->eType)
                {
                    case MMI2_SEND_MSG:
                            AUI_mms_status_notify(MMS_SEND_FAIL); 
                        break;
                }
            break;
            
    }

    if(MMI2evtHandle && bProcessed)
    {
    	free(MMI2evtHandle);
    	MMI2evtHandle= NULL;
    }
    return ENoError;
}



/* 1. User selects 'Preview' from user menu (MMI) */
/* 2. MMI calls action_ResumeEditor() to resume the magic4 client and suspends the menu system */

void action_ResumeEditor()
{
	/* resume magic4 editor */
	DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
	/* if necessary, add code here to suspend display of the menu system */
}
 

/* 3. After action_ResumeEditor has been completed, MMI then calls action_PreviewMessage() to preview the message currently in the magic4 editor */

void action_PreviewMessage()
{
	/* inform magic4 editor to preview the current message */
	DAL_PostMessage(EMG4_Preview,EMG4_Type_NotUsed,0,NULL);
}

/* 4. After action_PreviewMessage has been completed, MMI then calls action_SuspendEditor() to suspend the magic4 client and resume the menu system */

void action_SuspendEditor()
{
	/* suspend magic4 editor */
	DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
	DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed, EPlayModeStop,NULL);
	/* if necessary, add code here to resume display of the menu system */
}

/* 5. Done */



#endif
// ronaldc 9-4 to 9-5: add end


/*******************************************************************************

 $Function:    	MMSCreate_exec_cb

 $Description:	Exec callback function of the MMS Create window 
 
 $Returns:    	none

 $Arguments:	win - window handler
             	event - mfw event
             	parameter - optional data.
 
*******************************************************************************/
void MMSCreate_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
    
    TRACE_FUNCTION ("MMSCreate_exec_cb()");

    switch (event)
    {
	case MWM_CREATE:
		/* initialization of administrative data */
		TRACE_EVENT("MWM_CREATE");

		//yanbin init MMS create  bbssoo - EV_createmessageasync()
		// ronaldc 9-5
		OrthusCreateMessageEntryAsync();    
		//TraceOrthusCreateMessageEntryAsyncReturn();

                //xrashmic 9 Nov, 2004 MMI-SPR-26147
                //The text buffer is memset to '\0' only once at the time of MMS create - MWM_CREATE 
                memset(text,'\0',MAX_MMS_TEXT_LEN);

		//xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		break;
	case MWM_ONDRAW:
		TRACE_EVENT("MWM_ONDRAW");
		dspl_Enable(0);
		// xreddymn Aug-26-2004: Modified Title display
		{
			unsigned short width, height;
			DeviceGetScreenMetrics(&width,&height);
			dspl_SetBgdColour(COL_White);
			dspl_Clear(0, gucMmsTitleBarHeight, width-1, height-1);
			resources_setTitleColour(COLOUR_EDITOR);
			dspl_Clear(0, 0, width-1, gucMmsTitleBarHeight-1);
			dspl_TextOut(1, 0, DSPL_TXTATTR_HLIGHT,"Create MMS");
		}
		//yanbin: here call Magic4 functions to show MMS slides
		// bbssoo - After Creating MMS, display the "create MMS display" in the middle screen.
		// xreddymn Mar-08-2005 MMI-SPR-28820: changed order of posting EMG4_Preview and EMG4_Resume
		action_PreviewMessage();
		action_ResumeEditor();
		//xrashmic 6 Oct, 2004 MMI-SPR-25147
		//comenting action_SuspendEditor() as the Sound was not heard in the 
		//compose screen 
		//action_SuspendEditor();
		displaySoftKeys(TxtSoftOptions,TxtSoftBack);
		dspl_Enable(1);
		break;
	case MWM_DESTORY:
		TRACE_EVENT("MWM_DESTROY");
		//xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
		dspl_Enable(1);
		DAL_PostMessage(EMG4_Exit, EMG4_Type_NotUsed, 0, 0);
		//xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		//xrashmic 20 Dec, 2004  MMI-SPR-23921
		// On deleting the window, set the handler to NULL
              	mms_create_hnd=NULL;
		break;
	case MWM_SUSPEND:
		TRACE_EVENT("MWM_SUSPEND");
		//xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
		dspl_Enable(1);
		//xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		// xreddymn Sep-03-2004 MMI-SPR-23961
		DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
		DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed, EPlayModeStop,NULL);
		//xrashmic 6 Oct, 2004 MMI-SPR-25147
		//The editor needs to be in EDIT mode when inserting, Saving, etc.	
		DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
		break;
	case MWM_RESUME:
		TRACE_EVENT("MWM_RESUME");
		//xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		// xreddymn Sep-03-2004 MMI-SPR-23961
		// xreddymn Sep-17-2004 MMI-SPR-24733: Removed EMG4_Preview from here as it was disabling edit mode
		// xreddymn Sep-17-2004, Removed EMG4_Resume here as it is redundant (See MWM_ONDRAW of this function)
		// DAL_PostMessage(EMG4_Preview,EMG4_Type_NotUsed,0,NULL);
		// DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
		break;
	default:
        break;
    }
}

// xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): Delete message handler
ESTATUS Handler_MM_DeleteMessageEntryAsync(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
	return ENoError;
}

/*******************************************************************************

 $Function:    	MMSCreate_kbd_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:    	execution status

 $Arguments:	e - event id
             	k - keyboard info
*******************************************************************************/

static int MMSCreate_kbd_cb (MfwEvt e, MfwKbd *k)
    /* SmsRead_R_OPT keyboard event handler */
{
    T_MFW_HND    win  = mfwParent(mfw_header());


    TRACE_FUNCTION ("MMSCreate_kbd_cb()");

    if (e & KEY_LONG)
    {
        switch (k->code)
        {
    	case KCD_HUP: /* back to previous menu */
            //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
            //Once outside the MMS create screen, this flag needs to be unset
            MMSactive=FALSE;
            /* xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): Delete message on pressing back,
             * if it has not been saved. (Otherwise, it appears in the Unsent messages folder)
             */
            if(g_M4_message_saved == FALSE)
            {
                g_event_struct.handler = Handler_MM_DeleteMessageEntryAsync;
                g_event_struct.parentEvtHandle = NULL;
                g_event_struct.pData = NULL;
                g_event_struct.userFlag = 0;
                MM_DeleteMessageAsync((EVT_HANDLE) &g_event_struct, g_msg_id);
            }
            MMI_DestoryWindow(win);
            break;
    	case KCD_RIGHT: /* Power Down */
            return MFW_EVENT_REJECTED; /* handled by idle */
    	default: /* no response to all other keys */
            return MFW_EVENT_CONSUMED;
        }
    }
    else
    {
        switch (k->code)
        {
    	case KCD_MNUSELECT:
    	case KCD_LEFT:
            MMSCreate_OPT_start(win,0);
            break;
    	case KCD_HUP: /* back to previous menu */
    	case KCD_RIGHT: /* back to previous menu */
            //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
            //Once outside the MMS create screen, this flag needs to be unset
            MMSactive=FALSE;
            /* xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): Delete message on pressing back,
             * if it has not been saved. (Otherwise, it appears in the Unsent messages folder)
             */
            if(g_M4_message_saved == FALSE)
            {
                g_event_struct.handler = Handler_MM_DeleteMessageEntryAsync;
                g_event_struct.parentEvtHandle = NULL;
                g_event_struct.pData = NULL;
                g_event_struct.userFlag = 0;
                MM_DeleteMessageAsync((EVT_HANDLE) &g_event_struct, g_msg_id);
            }
        	MMI_DestoryWindow(win);
            break;
        //x0012849 Feb-03-2005 MMI-SPR-28224 : 
        //Handled the cases of scroll up and down
       case KCD_MNUDOWN: 
	     DAL_PostMessage(EMG4_ScrollDown,EMG4_Type_NotUsed,0,NULL);
	     break;
       case KCD_MNUUP :
	     DAL_PostMessage(EMG4_ScrollUp,EMG4_Type_NotUsed,0,NULL);
	     break;

    	default: /* no response to all other keys */
            return MFW_EVENT_CONSUMED;
        }
    }
    return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMSCreate_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:    	mfw window handler 

 $Arguments:	parent_window - Parent window handler
             	menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSCreate_start()");
    //xrashmic 3 Nov, 2004 MMI-SPR-26145
    //Storing the handle of the create window to delete later    
    mms_create_hnd =MMI_CreateWindow(parent_window, (T_DIALOG_FUNC) MMSCreate_exec_cb, (void*)menuAttr,(MfwCb)MMSCreate_kbd_cb, 0,0);
    return mms_create_hnd ;
}


#define MMS_SEND_SUBJUCT_NUMBER

static T_MFW_HND	    editor=NULL;
//CRR: 25302 - xpradipg 10 Nov 2004
//global to hold the number editor handle    
static T_MFW_HND    number_edit=NULL;
static char number[MAX_PHB_NUM_LEN];
static char topic[MAX_MMS_TOPIC_LEN]="\0";



static void MMSCreate_SEND_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason)
{
	T_MFW_WIN	        * win_data = ((T_MFW_HDR *) win)->data;
	T_DISPLAY_DATA display_info;
    char temp[100];
    
	TRACE_EVENT_P1("MMSCreate_SEND_edit_cb() %d", Identifier);


	switch (reason)
    {
	case INFO_KCD_LEFT:  // confirm (press LEFT soft key)
    	if (Identifier==E_MODE_TOPIC)
        { 
            // subject input 
        	TRACE_EVENT_P1("topic: %s",topic);
        	SEND_EVENT(win,E_MODE_NUMBER, 0, 0);
            // wait for getting number (below) and do it all together.
        }
        else if (Identifier==E_MODE_NUMBER)
        {
            // phone number input
        	TRACE_EVENT_P2("topic: %s, number: %s",topic,number);
            
            //yanbin: Call magic4 function to send MMS,  bbssoo - send MMS with the topic (subject) and number, then save the MMS.
            //topic: topic;
            //number: number;

        	M4_DebugMessage(0x93000);
            
            //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
            //This dialog screen is displayed as soon as the user selects the left softkey after entering the number to start sending MMS
            //xrashmic 08 Feb, 2005 MMI-SPR-27853
              AUI_mms_status_notify(MMS_PLEASEWAIT);             
	    	MMI_2_SaveHeaderInfo(topic,number);

	    	DAL_PostMessage(EMG4_SaveMsg, EMG4_Type_NotUsed, 0, 0);
		    //DAL_PostMessage(EMG4_Exit,EMG4_Type_NotUsed,0,NULL);

            g_inSendMode=TRUE;

        	M4_DebugMessage(0x93001);
           	MMI_DestoryWindow(win);
            //CRR: 25302 - xpradipg 10 Nov 2004
            //Number entry editor needs to be deleted explicitly
            AUI_edit_Destroy(number_edit);
        }
        else
        {
        	TRACE_EVENT_P1("text: %s",text);
        	M4_DebugMessage(0x92000);
//        	rvf_delay(10);
		g_safeString.size=2*(strlen(text)+1);
                MMS_ConvertStringToUcs2((const MByte *)(text), strlen(text), g_insertString);
		g_safeString.pString=g_insertString;
		DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
                //xrashmic 9 Nov, 2004 MMI-SPR-26147
                //Text in the MMS message needs to be deleted, before inserting the edited text.
                DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteText,NULL);
        	DAL_PostMessage(EMG4_InsertString, EMG4_Type_NotUsed, (MESSAGE_PARAM)&g_safeString, 0);
//		M4_DebugMessage(g_safeString.size);
        	M4_DebugMessage(0x92001);

//        	rvf_delay(10);
        	MMI_DestoryWindow(win);
            //yanbin: Call magic4 function to insert text into MMS
            //text: text;
            // bbssoo - insert string to MMS message.
        }
    	break;
        //CRR: 25302 - xpradipg 10 Nov 2004
        //the alternate left softkey event is handled for the number entry screen
       case INFO_KCD_ALTERNATELEFT:
	bookPhonebookStart(win, PhbkFromMms);
	break;
	case INFO_KCD_RIGHT:
	case INFO_KCD_HUP:
     //CRR: 25302 - xpradipg 10 Nov 2004
     //The number editor needs to be explicitly destroyed on pressing back sk
     if(E_MODE_NUMBER == Identifier)
        AUI_edit_Destroy(number_edit);
    	MMI_DestoryWindow(win);
    	break;
	default:
    	TRACE_EVENT("Err: Default");
    	break;
    }
}

//    Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
//    Fix:		A global variable to store the Mms Number extracted from the message header.
char MmsNumber[MAX_PHB_NUM_LEN];

/*******************************************************************************

 $Function:    	MMSCreate_SEND_exec_cb

 $Description:	Callback handler for events sent by the window itself and to recieve the data 
 
 $Returns:    	none

 $Arguments:	win - current window
             	event - event id
             	Identifier - optional data
             	parameter - optional data.
*******************************************************************************/

static void MMSCreate_SEND_exec_cb(T_MFW_HND win, USHORT event, USHORT Identifier,void *parameter)
{
	T_MFW_WIN      * win_data = ((T_MFW_HDR *) win)->data;
	T_AUI_EDITOR_DATA	editor_data;

	TRACE_FUNCTION ("MMSCreate_SEND_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		break;
	case E_MODE_TOPIC:

		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, ZONE_FULL_SK_TITLE_SCROLL, COLOUR_EDITOR, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_TOPIC, TRUE, FOREVER, (T_AUI_EDIT_CB)MMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtTopics, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, NULL, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
        //void AUI_edit_SetBuffer(T_AUI_EDITOR_DATA *editor_data, UBYTE dcs, UBYTE *text, USHORT size)
        //void AUI_edit_SetBuffer(T_AUI_EDITOR_DATA *editor_data, UBYTE dcs, UBYTE *text, USHORT size);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII,(UBYTE*) topic, sizeof(topic));
		editor = AUI_edit_Start(win, &editor_data);

                        		
	    	break;
	case E_MODE_NUMBER:

	    	TRACE_EVENT("enter number");
		//CRR: 23942 - xpradipg 26 Aug 2004
		//comment the hardcoded string. This will display an empty number editor.
                //strcpy(number,"01705713488");//"13816687053");//13801639314
		//strcpy(number,"+38516610401");
             //CRR: 25302 - xpradipg 10 Nov 2004
             // The editor attributes are changed to hold alternate strings
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, PHNO_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_NUMBER, FALSE, FOREVER, (T_AUI_EDIT_CB)MMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSend, TxtDelete, TxtSmsEnterNumber, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 1, TxtNames, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,0, ED_CURSOR_UNDERLINE);
              memset(number,'\0', sizeof(number));

	       //Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
              //Fix:	Get only the 13digits corresponding to the senders phone number from the senders address
		strncpy(number,MmsNumber,13);

		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE*)number, sizeof(number));
		number_edit = AUI_edit_Start(win, &editor_data);
	    	break;
	case E_MODE_TEXT:
	    	TRACE_EVENT("enter text");
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, ZONE_FULL_SK_TITLE_SCROLL, COLOUR_EDITOR, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_TEXT, TRUE, FOREVER, (T_AUI_EDIT_CB)MMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtMessage, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, NULL, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
                //CRR: 23942 - xpradipg 26 Aug 2004
                //reset the text buffer
                //xrashmic 9 Nov, 2004 MMI-SPR-26147
                //Moved it to MMCreate_exec_cb MWM_CREATE as the user should be able to edit the inserted text. Hence we need to
                // retain the data in "text" buffer.
                //memset(text,'\0',MAX_MMS_TEXT_LEN);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE*)text, sizeof(text));
		editor = AUI_edit_Start(win, &editor_data);

	    	break;
  //             case PHBK_ID:
        //CRR: 25302 - xpradipg 10 Nov 2004
        //handle the even sent back by the phone number module
        case MMS_EMS_PHBK_NUMBER:
              MmsSend_PHBK_exec_cb(number_edit, event, parameter);
		break; 
	case MWM_ONDRAW:
		break;
	case MWM_DESTORY:
		break;
	default:
	    	TRACE_EVENT("Err: Default");
    	break;
    }
}


/*******************************************************************************

 $Function:    	MMSCreate_SEND_start

 $Description:	Create SMS send window
 
 $Returns:    	execution status

 $Arguments:	parent_window - parent window.
             	UserData - SMS data
*******************************************************************************/

T_MFW_HND MMSCreate_SEND_start(T_MFW_HND parent_window, void *UserData)
{
	T_MFW_HND win;
	TRACE_FUNCTION ("MMSCreate_SEND_start()");
	win=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC) MMSCreate_SEND_exec_cb, (void*)UserData,0, 0,0);
	if(UserData) SEND_EVENT(win, (USHORT)UserData, 0, 0);
	return win;
}

//CRR:23923 - xpradipg 06 Sept 2004
/*******************************************************************************

 $Function:    	MMSCreate_Prev_exec_cb

 $Description:	Callback handler for events sent by the window itself
 
 $Returns:    	none

 $Arguments:	win - current window
             	       event - event id
              	parameter - optional data.
*******************************************************************************/

void MMSCreate_Prev_exec_cb(T_MFW_HND win, USHORT event, SHORT value, void * parameter)
/* callback handler for events sent to to trigger execution */
{
	TRACE_FUNCTION ("MMSBox_read_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		g_M4_display_active = TRUE;
		break;
	case MWM_ONDRAW:
		dspl_Enable(0);
		dspl_SetBgdColour(COL_White);
		dspl_ClearAll();
		DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
		//xrashmic 6 Oct, 2004 MMI-SPR-25147
		//EMG4_Preview does not require any EPlayModeRun.
		DAL_PostMessage(EMG4_Preview, EMG4_Type_NotUsed, 0, 0);
		displaySoftKeys(TxtNull,TxtSoftBack);
		dspl_Enable(1);
		break;
	case MWM_DESTORY:
		DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
		//xrashmic 6 Oct, 2004 MMI-SPR-25147
		//Exiting the Preview screen, the editor should be in editable mode.
		DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
		g_M4_display_active=FALSE;
		break;
	case MWM_SUSPEND:
		g_M4_display_active=FALSE;
		DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
		DAL_PostMessage(EMG4_Preview,EMG4_Type_NotUsed, EPlayModeStop,NULL);
		break;
	case MWM_RESUME:
		g_M4_display_active=TRUE;
		DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
		DAL_PostMessage(EMG4_Refresh, EMG4_Type_NotUsed, 0, 0);
break;
	default:
	    break;
	}
}

//CRR:23923 - xpradipg 06 Sept 2004
/*******************************************************************************

 $Function:    	MMSCreate_Prev_start

 $Description:	Create Preview window
 
 $Returns:    	window handler

 $Arguments:	parent_window - parent window.
             		menuAttr - Menu attributes
*******************************************************************************/

T_MFW_HND MMSCreate_Prev_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	return MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSCreate_Prev_exec_cb,(void*)menuAttr,(T_MFW_CB)MMSBox_Read_kbd_cb,0,0);
}

#define MMS_CREATE_OPTION
/*******************************************************************************

 $Function:    	MMSCreate_OPTexeSend

 $Description:	Called when the user press send in the Option menu
             
 $Returns:    	event status.

 $Arguments:	m - pointer to menu.
             	i - index if selected menu item.
*******************************************************************************/
static int MMSCreate_OPTexeSend(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	MMSCreate_SEND_start(win, (void*)E_MODE_TOPIC);
}

//CRR:23923 - xpradipg 06 Sept 2004
/*******************************************************************************

 $Function:    	MMSCreate_OPTpreviewMsg

 $Description:	Called when the user press Preview in the Option menu
             
 $Returns:    	event status.

 $Arguments:	m - pointer to menu.
             	i - index if selected menu item.
*******************************************************************************/
static int MMSCreate_OPTpreviewMsg(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());

	MMSCreate_Prev_start(win,NULL);
}
static int MMSCreate_OPTexeInsPicture(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	MMSom_start(win, (MfwMnuAttr *) MMS_INSERT_PICTURE);
}

static int MMSCreate_OPTexeInsSound(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	MMSom_start(win, (MfwMnuAttr *) MMS_INSERT_SOUND);
}

static int MMSCreate_OPTexeInsText(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	MMSCreate_SEND_start(win, (void*)E_MODE_TEXT);
}
static int MMSCreate_OPTexeSave(MfwMnu* m, MfwMnuItem* i)
{
	
	//xrashmic 6 Oct, 2004 MMI-SPR-25147
	//The Messages are saved only in EDIT mode.
	DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
	DAL_PostMessage(EMG4_SaveMsg, EMG4_Type_NotUsed, 0, 0);

	//xreddymn Aug-18-2004 MMI-SPR-24113 (TII_MMS53): To keep track of saved messages
	g_inSaveMode=TRUE;

	// xreddymn Nov-26-2004 MMI-SPR-25278: Display an "In Progress" screen
       //xrashmic 08 Feb, 2005 MMI-SPR-27853
       //Added few more parameters for this function
	g_inSaveModeWin=information_dialog(TxtPleaseWait,TxtNull,NULL,NULL, TxtNull,TxtNull,FOREVER,0,NULL);

}
static int MMSCreate_OPTexeInsSlide(MfwMnu* m, MfwMnuItem* i)
{
	TRACE_EVENT("insert pic into OM");
	M4_InsertPicObjectIntoOM();
}

//CRR: 25302 - xpradipg 10 Nov 2004
/*******************************************************************************

 $Function:    	MmsSend_PHBK_exec_cb

 $Description:	Populates the text structure with the phone Number and sends 
                     an event to update the editor buffer
 
 $Returns:    	

 $Arguments:	
*******************************************************************************/
 void MmsSend_PHBK_exec_cb(T_MFW_HND win, USHORT event, void *parameter)
{
#ifdef NEW_EDITOR
	T_ATB_TEXT		text;	/* Used to insert phone numbers into editors */
#endif

	TRACE_FUNCTION ("MmsSend_PHBK_exec_cb()");

	switch (event)
	{
	/* SPR#1428 - SH - New Editor changes.  Insert phone number into editor */
#ifdef NEW_EDITOR
		case MMS_EMS_PHBK_NUMBER:		/* Service centre number */
			text.dcs = ATB_DCS_ASCII;
			text.len = strlen((char *)parameter);
			text.data = (UBYTE *)parameter;
			SEND_EVENT(number_edit, E_ED_INSERT, 0, (void *)&text);
			break;
#endif /* NEW_EDITOR */
			break;
		default:
			TRACE_EVENT("Err: Default");
			break;
	}
}


/*******************************************************************************

 $Function:    	MMSCreate_OPT_exec_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:    	none

 $Arguments:	win - current window
             	event - event id
             	value - unique id
             	parameter - optional data.
             
*******************************************************************************/

void MMSCreate_OPT_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
    TRACE_FUNCTION ("MMSCreate_OPT_exec_cb()");
    switch (event)
    {
	case MWM_CREATE:
	    	TRACE_EVENT("MWM_CREATE");
	        /* initialization of administrative data */
	    	winShow(win);
	    	break;
	case MWM_ONDRAW:
		dspl_ClearAll();
		displaySoftKeys(TxtSoftOK,TxtSoftBack);
		break;
	case MWM_DESTORY:
		//xrashmic 20 Dec, 2004  MMI-SPR-23921
		// On deleting the window, set the handler to NULL
               	mms_create_opt_hnd=NULL;
		break;
	default:
        return;
    }
}

/*******************************************************************************

 $Function:    	MMSCreate_OPT_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:    	mfw window handler 

 $Arguments:	parent_window - Parent window handler
             	menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSCreate_OPT_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSCreate_OPT_start()");
    //xrashmic 3 Nov, 2004 MMI-SPR-26145
    //Storing the handle of the options window to delete later    
    mms_create_opt_hnd = MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSCreate_OPT_exec_cb,(void*)menuAttr, (T_MFW_CB)0, &MMSCreate_OPTAttrib,0);
    return mms_create_opt_hnd;
}

#define MMS_DELETE_PICTURE		0
#define MMS_DELETE_SOUND		1
#define MMS_DELETE_TEXT		2

static void MMSCreate_Delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	TRACE_FUNCTION("MMSCreate_Delete_cb");

	switch (reason)
	{
	case INFO_KCD_LEFT:
	    	switch(identifier)
	        {
	    	case MMS_DELETE_PICTURE:
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
			DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteImage,NULL);
	        	break;
	    	case MMS_DELETE_SOUND:
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
			DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteAudio,NULL);
	        	break;
	    	case MMS_DELETE_TEXT:
                        DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
                        DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteText,NULL);
                        //xrashmic 9 Nov, 2004 MMI-SPR-26147            
                        //The text buffer should be reset when the text data 
                        //is deleted in the MMS message 
                        memset(text,'\0',MAX_MMS_TEXT_LEN);
	        	break;
	        }
		MMI_DestoryWindow(win);
	    	break;
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		MMI_DestoryWindow(win);
	    	break;
	default:
    	break;
    }
}
static int MMSCreate_OPTexeDelPicture(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=MMS_DELETE_PICTURE;
	info_dialog (win, &display_info);
}
static int MMSCreate_OPTexeDelSound(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=MMS_DELETE_SOUND;
	info_dialog (win, &display_info);
}
static int MMSCreate_OPTexeDelText(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=MMS_DELETE_TEXT;
	info_dialog (win, &display_info);
}

void FUN_TRACE_EVENT(char * text, unsigned long param)
{
	TRACE_EVENT_P1(text, param);
}


/*******************************************************************************
 $Function:    	Handler_Fwd_CreateMessageEntryAsync

 $Description:	Callback function for MM_CreateMessageEntryAsync for forward.
                    //xrashmic 14 Dec, 2004 MMI-SPR-23921
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

ESTATUS Handler_Fwd_CreateMessageEntryAsync(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
   ESTATUS eResult;
   //Using the same create editor event handler for forward editor 
   g_doc_event_struct.handler = MMI_1_EventHandler;
   g_doc_event_struct.parentEvtHandle = NULL;
   g_doc_event_struct.pData = NULL;
   g_doc_event_struct.userFlag = 0;
   g_msg_id= (MM_MESSAGE_ID) ampParam;
   eResult = DAL_OpenDocument((EVT_HANDLE) &g_doc_event_struct,  g_pMessageHeaderList->ppList[g_currentMessage].id,  g_msg_id);
}

/*******************************************************************************

 $Function:    	MMSBox_Forward

 $Description:	Creating a new Id for the MMS message being forwarded
                    //xrashmic 14 Dec, 2004 MMI-SPR-23921
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/
void MMSBox_Forward(void)
{
    ESTATUS eResult;
    MDword MessageID = g_pMessageHeaderList->ppList[g_currentMessage].id;
    TRACE_FUNCTION ("MMSBox_Forward()");
    eResult = DAL_RetrieveMessageHeader(MessageID,&fwd_msg_header);
    fwd_msg_header->location = EMlDraft;
    g_event_struct.handler = Handler_Fwd_CreateMessageEntryAsync;
    g_event_struct.parentEvtHandle = NULL;
    g_event_struct.pData = NULL;
    g_event_struct.userFlag = 0;
    eResult=MM_CreateMessageEntryAsync((EVT_HANDLE) &g_event_struct, fwd_msg_header); 
    g_safeString.memHeader.freeFunc = DummyFreeFunc;    /*!< Pointer to memory deallocation function */
    g_safeString.size=10;                            /*!< size of the string */
    g_safeString.pString=g_insertString;            /*!< Pointer to UCS2 string */
    
}

/*******************************************************************************

 $Function:    	MMSFwd_exec_cb

 $Description:	Event handler for the MMS forward window
                    //xrashmic 14 Dec, 2004 MMI-SPR-23921
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

void MMSFwd_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;

    TRACE_FUNCTION ("MMSFwd_exec_cb()");

    switch (event)
    {
	case MWM_CREATE:
            //xrashmic 14 Dec, 2004 MMI-SPR-23921
            // Create a new Msg ID, Open the editor and copy the message being forwarded, into this editor.
            MMSBox_Forward();
            //xrashmic 9 Nov, 2004 MMI-SPR-26147
            //The text buffer is memset to '\0' only once at the time of MMS create - MWM_CREATE 
            memset(text,'\0',MAX_MMS_TEXT_LEN);
            g_M4_display_active=TRUE;
            // xreddymn Feb-02-2005 MMI-SPR-28277: This is set to TRUE when forwarding MMS messages
            gMmsForwardStart=TRUE;
            break;
	case MWM_ONDRAW:
            TRACE_EVENT("MWM_ONDRAW");
            dspl_Enable(0);
            {
            	unsigned short width, height;
            	DeviceGetScreenMetrics(&width,&height);
            	dspl_SetBgdColour(COL_White);
            	dspl_Clear(0, gucMmsTitleBarHeight, width-1, height-1);
            	resources_setTitleColour(COLOUR_EDITOR);
            	dspl_Clear(0, 0, width-1, gucMmsTitleBarHeight-1);
            	dspl_TextOut(1, 0, DSPL_TXTATTR_HLIGHT,"Forwarding MMS");
            }

            //yanbin: here call Magic4 functions to show MMS slides
            // bbssoo - After Creating MMS, display the "create MMS display" in the middle screen.
            // xreddymn Mar-08-2005 MMI-SPR-28820: changed order of posting 
            //    EMG4_Preview and EMG4_Resume.
            //    When forwarding MMS, the first Preview-Resume occurs 
            //    through the callback MMI_1_EventHandler
            if(FALSE == gMmsForwardStart)
            {
                action_PreviewMessage();
                action_ResumeEditor();
            }
            //xrashmic 6 Oct, 2004 MMI-SPR-25147
            //comenting action_SuspendEditor() as the Sound was not heard in the 
            //compose screen 
            //action_SuspendEditor();
            displaySoftKeys(TxtSoftOptions,TxtSoftBack);
            dspl_Enable(1);
            break;
	case MWM_DESTORY:
            TRACE_EVENT("MWM_DESTROY");
            //xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
            dspl_Enable(1);
            DAL_PostMessage(EMG4_Exit, EMG4_Type_NotUsed, 0, 0);
            //xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
            g_M4_display_active=FALSE;
            //xrashmic 20 Dec, 2004  MMI-SPR-23921
            // On deleting the window, set the handler to NULL
	    mms_Fwdcreate_hnd=NULL;
            break;
	case MWM_SUSPEND:
            TRACE_EVENT("MWM_SUSPEND"); 
            //xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
            dspl_Enable(1);
            //xreddymn Aug-16-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
            g_M4_display_active=FALSE;
            // xreddymn Sep-03-2004 MMI-SPR-23961
            DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
            DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed, EPlayModeStop,NULL);
            //xrashmic 6 Oct, 2004 MMI-SPR-25147
            //The editor needs to be in EDIT mode when inserting, Saving, etc.	
            DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
            break;
	case MWM_RESUME:
            TRACE_EVENT("MWM_RESUME");
            //xreddymn Aug-16-2004: M4 client will now use the display
            g_M4_display_active=TRUE;
            break;
	default:
            break;
    }
}


/*******************************************************************************

 $Function:    	MMSFwd_kbd_cb

 $Description:	Keyboard handler for the MMS forward window
 		       //xrashmic 14 Dec, 2004 MMI-SPR-23921
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

static int MMSFwd_kbd_cb (MfwEvt e, MfwKbd *k)
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    TRACE_FUNCTION ("MMSFwd_kbd_cb()");
    if (e & KEY_LONG)
    {
        switch (k->code)
        {
            case KCD_HUP: /* back to previous menu */
                //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
                //Once outside the MMS create screen, this flag needs to be unset
                MMSactive=FALSE;
                if(g_M4_message_saved == FALSE)
                {
                    g_event_struct.handler = Handler_MM_DeleteMessageEntryAsync;
                    g_event_struct.parentEvtHandle = NULL;
                    g_event_struct.pData = NULL;
                    g_event_struct.userFlag = 0;
                    MM_DeleteMessageAsync((EVT_HANDLE) &g_event_struct, g_msg_id);
                }
                MMI_DestoryWindow(win);
        	  break;
            case KCD_RIGHT: /* Power Down */
                return MFW_EVENT_REJECTED; /* handled by idle */
            default: /* no response to all other keys */
                return MFW_EVENT_CONSUMED;
        }
    }
    else
    {
        switch (k->code)
        {
            case KCD_MNUSELECT:
            case KCD_LEFT:    	                    
        	MMSCreate_OPT_start(win,0);
            	break;
            case KCD_HUP: /* back to previous menu */
            case KCD_RIGHT: /* back to previous menu */
                //xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
                //Once outside the MMS create screen, this flag needs to be unset
                MMSactive=FALSE;
                if(g_M4_message_saved == FALSE)
                {
                    g_event_struct.handler = Handler_MM_DeleteMessageEntryAsync;
                    g_event_struct.parentEvtHandle = NULL;
                    g_event_struct.pData = NULL;
                    g_event_struct.userFlag = 0;
                    MM_DeleteMessageAsync((EVT_HANDLE) &g_event_struct, g_msg_id);
                }
                MMI_DestoryWindow(win);
                break;
            case KCD_MNUUP:
                 //x0012849 Feb-03-2005 MMI-SPR-28224 
                 //send the scrollup event to see the contents above the screen
		   DAL_PostMessage(EMG4_ScrollUp,EMG4_Type_NotUsed,0,NULL);   
		   break;
            case KCD_MNUDOWN:
		    //x0012849 Feb-03-2005 MMI-SPR-28224		 
                  //send the scrolldown event to see the contents below the screen		       
   		    DAL_PostMessage(EMG4_ScrollDown,EMG4_Type_NotUsed,0,NULL);  
   		    break;
            case KCD_MNULEFT:
            case KCD_MNURIGHT:

                break;
                return MFW_EVENT_CONSUMED;
        }
    }
    return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	MMSFwd_start

 $Description:	Creates Forward window for the selected MMS.
 		       //xrashmic 14 Dec, 2004 MMI-SPR-23921
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

T_MFW_HND MMSFwd_start(void)
{
    T_MFW_HND   win  = mfwParent(mfw_header());
    TRACE_FUNCTION ("MMSCreate_start()");
    mms_Fwdcreate_hnd=MMI_CreateWindow(win, (T_DIALOG_FUNC) MMSFwd_exec_cb, NULL,(MfwCb)MMSFwd_kbd_cb, 0,0);
    return  mms_Fwdcreate_hnd;
}


#undef MMI_MMSCREATE_C

