
/*******************************************************************************

					TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                     
 $Project code:	BMI (6349)                                                           
 $Module:		MMS
 $File:		    mmimmsbox.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Yan Bin(bin-yan@ti.com)                                                         
 $Date:		    28/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMmsBox.c

     xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
     Play mms error restart rectified. Removing unwanted screens in the callback of the "New mms"
     dialog screen.
	xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
	Changed from static allocations for g_mmstopic and g_mmsstatus to dynamic allocation.

    Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
    Description:	MMS: During MMS Reply, Enter Number shows Empty.
    Solution:		Senders number is extracted from the Message Header and is displayed.

  	Nov 02, 2005    REF:ER OMAPS00039044  xdeepadh
	Description:   Mp3 Ringer Implementation
	Solution: The Midi Ringer application has been enhanced to support mp3 as ringer.
	The interface  function names have been modified.
	
     May 11 2005  REF:  MMI-SPR-29887  x0012849
     To Implement the deferred MMS retrieval.
    Apr 07 2005  REF:  MMI-SPR-27826  x0012849
    To avoid crash when a user replies to the MMS which is there in Inbox

    xrashmic 08 Feb, 2005 MMI-SPR-27853
     Added more parameters to the information_dialog function
       
 	Apr 05, 2005    REF: ENH 29994 xdeepadh
   	Description: Implementation of Generic Midi Ringer and Modification of existing Midi Test Application
   	Solution: Generic Midi Ringer and Midi Test Application were implemented.
 
    xreddymn Jan-31-2004 MMI-SPR-28483: Support for MIDI objects

     x0012849 Feb-03-2005 MMI-SPR-28224 :
     To allow the user to scroll up and down while creating, reading or forwarding MMS .   
     
    xrashmic 14 Dec, 2004 MMI-SPR-23921
    Implementing the forward functionality for MMS  

    
    xreddymn Dec-20-2004 MMI-SPR-27382
    (1) Added "Please Wait" screen when deleting messages from a folder.
    This prevents the user from navigating menus during the process.
    (2) Modified inbox refresh to occur only when inside the inbox list screen.

    MMI-SPR-27384: Dec-17-2004 - xreddymn
    Changes for MMS/EMS Inbox/Sent/Unsent folder presentation

    xrashmic 7 Dec, 2004 MMI-SPR-23965
    Description: Not able to extract the objects in EMS message
    Solution: Extract and store the objects in the Object Manager
    
    MMI-SPR-23981: Nov-30-2004 - xreddymn
    Modified delete message behaviour. 
    Fixed "Play MMS Error" message that appears when trying to read messages

    MMI-SPR-25278: Nov-29-2004 - xreddymn
    Implemented FFS limits for MMS/EMS storage

    CRR 24456: 19 Oct 2004 - xpradipg
    Description: On opening MMS with PNG image "Play MMS Error" is displayed.
    On pressing Back D-sample resets.
    Solution: The EPlayModeStop was posted even if the EPlayModeRun was not 
    posted. The EPlayModeStop event posting is controled.
 
    CRR: 25291 - xrashmic 14 Oct 2004
    Description: The sent EMS is stored in unsent folder.
    Solution: The Outbox has been removed, instead we now have Sent folder for the sent EMS 

    MMI-SPR-25273: Oct-14-2004 - xreddymn
    Description: EMS forward not working
    Solution: Added changes to implement the EMS forward feature

    CRR 25268: 13 Oct 2004 - xpradipg
    Description: Unable to see the Number / name and the status read/unread of
    the received EMS/MMS
    Solution: The status of each message is updated as soon as the Message is 
    read, and "old"/"new" is appended based on the status flag
    
    CRR 25270: 13 Oct 2004 - xpradipg
    Description: EMS: Titles such as "no name" is added to EMSs with no titles
    Solution: The corresponding name is retrieved from the phone book for the
    number from which EMS is received, if name is not present number is 
    displayed in Inbox

    CRR 25277: 06 Oct 2004 - xpradipg
    Description: Recieving an ems when inbox is open
    Solution: A refresh event is sent to the Inbox list which inturn updates 
    the list

    MMI-SPR-25148: Sep-24-2004 - xreddymn
    Changes to map object index correctly to displayed list index
    in case of extractable object list.

    xrashmic 22 Sep, 2004 MMI-SPR-25032
    To play the buzzer when there are sound objects in EMS message

    MMI-SPR-24735: Sep-16-2004 - xreddymn
    Changes related to EMS screen flickering issue

    MMI-SPR-23962 (TII_MMS31): Aug-20-2004 - xreddymn
    Extract objects modified not to include text and unknown objects

    MMI-SPR-23933 (TII_MMS17): Aug-17-2004 - xreddymn
    Display a more meaningful error message when playback fails.

    MMI-SPR-23972 (TII_MMS41) Aug-27-2004 - xreddymn
    Correctly close message session when extracting objects or reading the message	

    MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): Aug-26-2004 - xreddymn
    Keep track of MMS/EMS display

    CRR 23963: xpradipg 26 Aug 2004
    Description: Remove "Reply" option from Unsent folder
    Solution: The current selected folder is stored in a variable and depending on the selected folder
    the menu item display is controled.
    
    CRR 23959: xpradipg 26 Aug 2004
    Description: List not updated after deleting the messages in Unsent/Inbox folder
    Solution: The list is refreshed everytime the user returns from the options menu
   
    xrashmic 26 Aug, 2004 MMI-SPR-23931
    Only the complete message will be displayed in the inbox, outbox, unsent folders

    Bug Id 19 : 		13 Aug, 2004 - xrashmic  
    Description: MMS compose is displayed when reply option is selected 
    for an EMS message
    Solution: 	When reply is selected for a message from the inbox, we need to display corresponding 
    compose screen i.e either EMS compose or MMS compose screen

	17/01/04			Replace mfw edit with AUI edit.	
	28/08/03			Original TI(Shanghai) BMI version.	
	   
 $End

*******************************************************************************/
#define MMI_MMSBOX_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"

#include "psa_util.h"

#include "dspl.h"
// #include "unicode_types.h"

#include "MmiMain.h"
#include "MmiDummy.h"
//#include "MmiLists.h"
#include "MmiMmi.h"
#include "mmiCall.h"//GW 29/11/01 for 'callNumber'

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"

#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else /* NEW_EDITOR */
#ifdef EASY_TEXT_ENABLED
#include "MmiLatinPredText.h"
#endif /* EASY_TEXT_ENABLED */
#include "MmiEditor.h"
#endif /* NEW_EDITOR */

#include "MmiBookShared.h" // MZ 
#include "mmimmsmenu.h"
#include "mmimmsbox.h"
#include "mfw_ffs.h"
#include "mmiwindow.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif

#include "aci_cmh.h"	//GW 29/11/01 added for types in aci_fd.h
#include "aci_fd.h"		//GW 29/11/01 added for types in 'cmh.h'
#include "cmh.h" 		//GW 29/11/01 added for types in 'cmh_phb.h'
#include "cmh_phb.h"	//GW 29/11/01 added for cmhPHB_getAdrStr

#include "mmiColours.h"
//xrashmic 22 Sep, 2004 MMI-SPR-25032
#include "audio.h"


#include "mg4def.h"
#include "evtdefs.h"
#include "mg4stu.h"
#include "Mg4Dal.h"
#include "mg4devif.h"
#include "dalevt.h"
#include "evif.h"
#include "mg4str.h"
#include "mmif.h"
#include "mg4mem.h"
//Apr 05, 2005    REF: ENH 29994 xdeepadh
#ifdef FF_MIDI_RINGER 
#include "mfw_midi.h"
#include "MmiSounds.h"
#endif
//xrashmic 14 Dec, 2004 MMI-SPR-23921
#include "mmimmscreate.h"
extern int MMSactive;


//xreddymn Aug-26-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): To keep track of MMS display
extern BOOL g_M4_display_active;

//CRR 25270: 13 Oct 2004 - xpradipg
extern T_idle idle_data;
extern int bookFindNameInPhonebook( const char *p_pszNumber, T_MFW_PHB_ENTRY *p_pEntry );
int MMS_Is_Unread_Msgs_Inbox(void);

//CRR 23959: xpradipg 26 Aug 2004
//CRR 23963: xpradipg 26 Aug 2004
//Holdsthe current selected folder value. Default is set to 0xFF - 
//indicating no folder is assigned
UBYTE folder=0xFF;
// May 12 2005  REF:  MMI-SPR-29887  
// is_deferdownload will be TRUE when Deferred retrieval of MMS starts
BOOL is_deferdownload = FALSE;  
#define MMS_RECEIVE_PROGRESS -27
// May 12 2005  REF:  MMI-SPR-29887
//Used to check whther control went to DeviceEndAck while Retrieving the MMS
// If that is the case then dont display NewNotificaion dialog.
BOOL is_notifyResponse = FALSE;  
// Jun 23 2005  REF:  MMI-SPR-29887  x0012849
extern BOOL is_downloadcancelled;  
extern UBYTE rtvprogressValue; 
//CRR 25277: xpradipg 06 Oct 2004
extern MfwHnd mmsboxwinhnd;
//GW 29/11/01 - added header file - removed extern void callNumber(UBYTE* number);
MfwWin* getWinData( MfwHnd win);

// xreddymn Nov-29-2004: Added externals
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback);

extern T_MFW_HND g_inSaveModeWin;

// xreddymn Nov-30-2004 MMI-SPR-23981
T_MFW_HND g_OptionsWin;
T_MFW_HND g_MmsBoxWin;
//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
T_MFW_HND g_MmsReadWin;
T_MFW_HND g_MmsExtractEdtWin;
// xreddymn Dec-20-2004 MMI-SPR-27382
T_MFW_HND g_MmsBoxWinSavedHnd;
T_MFW_HND g_MmsPleaseWaitWin;

//xrashmic 7 Dec, 2004 MMI-SPR-23965
int attachmentInEMS=0;
EV_S_EXTRACTABLE_IN_MESSAGE apExtractableInMessage;
PP_S_OBJECT_DATA  *appObj;

/*********************************************************************

				 DYNAMIC MENU WINDOW. DECLARATION

**********************************************************************/

/* xreddymn Dec-16-2004 MMI-SPR-27384: MMS/EMS message list is now displayed as a two line per item list */
static MfwMnuAttr MmsBox_menuAttrib =
{
    &melody_menuArea,
    MNU_LEFT | MNU_LIST_2_LINE | MNU_CUR_LINE, /* double line menu       */
    -1,                                 /* use default font         */
    NULL,                               /* with these items         */
    0,                                   /* number of items     */
	COLOUR_LIST_XX, TxtNull, MNUATTRSPARE

};

static MfwMnuAttr MmsBox_ExtractMedia_menuAttrib =
{
    &melody_menuArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    NULL,                               /* with these items         */
    0,                                   /* number of items     */
	COLOUR_LIST_XX, TxtNull, MNUATTRSPARE

};

static int MMSBox_OPTexeRead(MfwMnu* m, MfwMnuItem* i);
// May 12 2005  REF:  MMI-SPR-29887  x0012849
//Prototyes of the functions. START
static int MMSBox_OPTexeDeferDownload(MfwMnu* m, MfwMnuItem* i); 
static void  DeferDownloadMsg(MM_MESSAGE_ID msgId); 
void  MMSDownLoadNow(MM_MESSAGE_ID msgId);
static ESTATUS DeferDownloadMsgCallback(EVENT_ID		aeId,  
		          EVENT_TYPE	aeType,
				  MESSAGE_PARAM	ampParam,
				  EVT_HANDLE	evtHandle);
// May 12 2005  REF:  MMI-SPR-29887  x0012849
//Prototyes of the functions. END
static int MMSBox_OPTexeExtract(MfwMnu* m, MfwMnuItem* i);
static int MMSBox_OPTexeForward(MfwMnu* m, MfwMnuItem* i);
static int MMSBox_OPTexeDelete(MfwMnu* m, MfwMnuItem* i);
static int MMSBox_OPTexeReply(MfwMnu* m, MfwMnuItem* i);
//CRR 23963: xpradipg 26 Aug 2004
USHORT MMSBox_Is_Unsent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
// May 12 2005  REF:  MMI-SPR-29887  x0012849
//Prototyes of the function
USHORT MMSBox_Is_NotRetrieved( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
// May 12 2005  REF:  MMI-SPR-29887  x0012849
//Prototyes of the function
USHORT MMSBox_Is_Retrieved( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
void MMSBox_Extract_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter);


static MfwMnuItem MMSBox_OPTItems [] =
{
    // May 11 2005  REF:  MMI-SPR-29887  x0012849
    //Choose either of one Read or Retrieve based on the type of MMS.
    {0,0,0,(char *)TxtRead,0,(MenuFunc)MMSBox_OPTexeRead,MMSBox_Is_Retrieved}, 
    // May 11 2005  REF:  MMI-SPR-29887  x0012849
    //Retrieve will be showed in case if the MMS is not complete
    {0,0,0,(char *)TxtRetrieve,0,(MenuFunc)MMSBox_OPTexeDeferDownload,MMSBox_Is_NotRetrieved},		
    {0,0,0,(char *)TxtExtract,0,(MenuFunc)MMSBox_OPTexeExtract,MMSBox_Is_Retrieved},
     //CRR 23963: xpradipg 26 Aug 2004
     //added MMSBox_Is_Unsent which controls the display of the menu item
    {0,0,0,(char *)TxtReply,0,(MenuFunc)MMSBox_OPTexeReply,MMSBox_Is_Unsent},
    {0,0,0,(char *)TxtForward,0,(MenuFunc)MMSBox_OPTexeForward,MMSBox_Is_Retrieved},
    {0,0,0,(char *)TxtDelete,0,(MenuFunc)MMSBox_OPTexeDelete,item_flag_none},
};

//xrashmic 7 Dec, 2004 MMI-SPR-23965
// Separate options list for the EMS message. The extract menu item is removed from this list
static MfwMnuItem EMSBox_OPTItems [] =
{
    {0,0,0,(char *)TxtRead,0,(MenuFunc)MMSBox_OPTexeRead,item_flag_none},
     //CRR 23963: xpradipg 26 Aug 2004
     //added MMSBox_Is_Unsent which controls the display of the menu item
    {0,0,0,(char *)TxtReply,0,(MenuFunc)MMSBox_OPTexeReply,MMSBox_Is_Unsent},
    {0,0,0,(char *)TxtForward,0,(MenuFunc)MMSBox_OPTexeForward,item_flag_none},
    {0,0,0,(char *)TxtDelete,0,(MenuFunc)MMSBox_OPTexeDelete,item_flag_none},
};

static MfwMnuAttr MMSBox_OPTAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    MMSBox_OPTItems,                      /* with these items         */
    sizeof(MMSBox_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE

};
//xrashmic 7 Dec, 2004 MMI-SPR-23965
// Separate options list for the EMS message. The extract menu item is removed from this list
static MfwMnuAttr EMSBox_OPTAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    EMSBox_OPTItems,                      /* with these items         */
    sizeof(EMSBox_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE

};

#define MMS_BOX_LISTALLMMS_BEGIN

/* pointer used to get mms list */
MM_S_MESSAGE_HEADER_LIST*	g_pMessageHeaderList	= NULL;
int g_currentMessage=0;

//CRR 25270 & CRR 25268: 14 Oct 2004 - xpradipg 
// xreddymn Dec-16-2004 MMI-SPR-27384: Modified string lengths for Inbox/Unsent/Sent presentation
#define MMS_BOX_LIST_STRING_MAX_LENGTH  72
#define MMS_BOX_LIST_LINE_MAX_LENGTH    36
#define MMS_BOX_LIST_SUB_MAX_LENGTH     28
//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
//Changed the static allocation to dynamic for the following variables
char *g_mmstopic;
char *g_mmsstatus;

static ListMenuData *box_menu_list_data=NULL;
static ListMenuData *extra_menu_list_data=NULL;

// xreddymn Sep-24-2004 MMI-SPR-25148 : An array that maps displayed index to an index in the list of objects extracted
static S16 *extra_menu_list_indices=NULL;

//CRR 24456: 19 Oct 2004 - xpradipg
//flag to control the posting of EPlayModeStop
static int MmsReadStatus =ENoError;
void M4_FreeListFolderMemory(void)
{
	/* If there is any data */
	if (g_pMessageHeaderList != NULL)
	{
		g_pMessageHeaderList->memHdr.freeFunc(g_pMessageHeaderList);
        
		g_pMessageHeaderList = NULL;
	}

	return;
}
//CRR 23963: xpradipg 26 Aug 2004
/*******************************************************************************

 $Function:     MMSBox_Is_Unsent

 $Description:  decides if the Reply menu item needs to be displayed or not

 $Returns:    False if it should be displayed

 $Arguments:
*******************************************************************************/
USHORT MMSBox_Is_Unsent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
    // May 11 2005  REF:  MMI-SPR-29887  x0012849
    if(folder == MMS_UNSENT ||(g_pMessageHeaderList->ppList[g_currentMessage].complete == FALSE ))
    {
  	return 1;
     }		
  return 0;
}
 // May 11 2005  REF:  MMI-SPR-29887  x0012849
 // New Function added
/*******************************************************************************
 $Function:     MMSBox_Is_NotRetrieved
 $Description:  decides whether Retrieve option need to be displayed or not 
 $Returns:    False if it should be displayed
 $Arguments:
*******************************************************************************/
USHORT MMSBox_Is_NotRetrieved( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
    if(g_pMessageHeaderList->ppList[g_currentMessage].complete == FALSE)
    {
  	return 0;
     }		
  return 1;
}
 // May 11 2005  REF:  MMI-SPR-29887  x0012849
 // New Function added
/*******************************************************************************
 $Function:     MMSBox_Is_Retrieved
 $Description:  decides whether Read options need to be displayed or not
 $Returns:    False if it should be displayed
 $Arguments:
*******************************************************************************/
USHORT MMSBox_Is_Retrieved( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
   if(g_pMessageHeaderList->ppList[g_currentMessage].complete == TRUE)
    {
  	return 0;
     }		
  return 1;
}

/*******************************************************************************

 $Function:     MMSBoxList_cb

 $Description:  Callback function for the melody list.

 $Returns:    none

 $Arguments:  Parent - parent window.
        ListData - Menu item list
*******************************************************************************/

void MMSBoxList_cb(T_MFW_HND * Parent, ListMenuData * ListData)
{
	T_MFW_HND    win  = mfwParent(mfw_header());

	TRACE_EVENT_P1("MMSBoxList_cb : %d", ListData->Reason);
	if ((ListData->Reason EQ LISTS_REASON_BACK) || (ListData->Reason EQ LISTS_REASON_CLEAR)
		|| (ListData->Reason EQ LISTS_REASON_HANGUP))	// sbh - added hangup key
	{
		listsDestroy(ListData->win);
		MMI_DestoryWindow(Parent);
	}
	else if(ListData->Reason EQ LISTS_REASON_SELECT)
	{
		g_currentMessage=ListData->CursorPosition;
		MMSBox_OPT_start(ListData->win,0);
	}
}

static void MMSBox_info_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	TRACE_FUNCTION("MMSBox_info_cb");
	switch (reason)
	{
	case INFO_KCD_LEFT:
		MMI_DestoryWindow(win);
	    	break;
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		MMI_DestoryWindow(win);
    	break;
	default:
    	break;
    }
}

/*******************************************************************************

 $Function:    	MMSBox_DT_string

 $Description:  Forms a string from a date/time structure
 
 $Returns:      none

 $Arguments:    s - String into which the output is written.
                Must be sufficiently large: Doesn't perform any bounds check.
                t - MMS time stamp structure

                xreddymn Dec-16-2004

*******************************************************************************/
void MMSBox_DT_string(char *s,MM_S_TIME_STAMP *t)
{
	sprintf(s,"%02d/%02d %02d:%02d",t->day,t->month,t->hour,t->min);
}

/*******************************************************************************

 $Function:    	MMSBox_exec_cb

 $Description:	Exec callback function of the MMS Create window 
 
 $Returns:		none

 $Arguments:	win - window handler
 				event - mfw event
 				parameter - optional data.
 
*******************************************************************************/
void MMSBox_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
	int i;
	ESTATUS eStatus=0;
	MM_LIST_PARAM listParams = 0;
       //CRR 25270 && CRR 25268: 13 Oct 2004 - xpradipg
       //moved the declaration to the start of the function
       int lenSub=0;
       T_MFW_PHB_ENTRY phonebook_entry;
     // May 17 2005  REF:  MMI-SPR-29887  xreddymn
     //list_size will give the value - No of Messages presently in the list
	int list_size;                   
	TRACE_FUNCTION ("MMSBox_exec_cb()");
	
	switch (event)
	{
	//CRR 23963: xpradipg 26 Aug 2004
	//New case added, this is invoked when ever the user returns back from the 
	//options screen. This cleans the list of messages and re-populates the list
	case MWM_REDRAW:
		// we delete the list - free the list - before actually allocating and drawing.
		list_size = box_menu_list_data->ListLength;
		if(box_menu_list_data->win)
			listsDestroy(box_menu_list_data->win);
		if(box_menu_list_data)
		{
			if(box_menu_list_data->List && g_pMessageHeaderList)
			{
                           // May 17 2005  REF:  MMI-SPR-29887  xreddymn
                           // Use list_size to while freeing the memory
				FREE_MEMORY((void*)(box_menu_list_data->List), list_size * sizeof(T_MFW_MNU_ITEM ));
			}
			FREE_MEMORY((void*)(box_menu_list_data),sizeof(ListMenuData));
		}
		//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
		//Freeing the allocated memory on exiting the list screen
		if(g_mmsstatus)
			FREE_MEMORY((void*)g_mmsstatus,MMS_BOX_LIST_STRING_MAX_LENGTH);
		if(g_mmstopic)
			FREE_MEMORY((void*)g_mmstopic,MMS_BOX_LIST_STRING_MAX_LENGTH*g_pMessageHeaderList->size);

		//CRR 23963: xpradipg 26 Aug 2004
		//the break; is omitted intentionally, since the list is recreated using the below code
	case MWM_CREATE:
              //CRR 25277: xpradipg 06 Oct 2004
              //the display needs to be refreshed forcibly
               dspl_Enable(0);
		/* initialization of administrative data */
		TRACE_EVENT(" Event: MWM_CREATE");
		//yanbin:  call magic4 function to create MMS list
		/* make sure g_pMessageHeaderList be freed if not free */
		M4_FreeListFolderMemory();
		box_menu_list_data=NULL;
		//CRR 23963: xpradipg 26 Aug 2004
		//CRR 23963: xpradipg 26 Aug 2004
		//check if no folder number is assigned before assigning
		if(folder == 0xFF)
			folder = (UBYTE)parameter;
		else
			parameter=(void*)folder;
		TRACE_EVENT_P1("the value of folder is %d",folder);
		//parameter=(folder==0xFF)?parameter:(void*)folder;
		if (parameter == (void *)MMS_INBOX)
		{
			//xrashmic 26 Aug, 2004 MMI-SPR-23931
			//added MM_LIST_COMPLETE so that the list does not contain 
			//incomplete messages
			//listParams  = MM_LIST_INBOX|MM_LIST_COMPLETE; 			
                     //May 17 2005  REF:  MMI-SPR-29887  x0012849
                     //To Implement the deferred MMS retrieval.
			listParams  = MM_LIST_INBOX|MM_LIST_NOT_RETRIEVED;
		}
		//CRR: 25291 - xrashmic 14 Oct 2004
		//To display a list of the sent messages.
		else if (parameter == (void *)MMS_SENT)
		{
			// xreddymn May-18-2005 MMI-SPR-29887: Removed MM_LIST_COMPLETE
			// as it causes messages from Inbox to be listed, with the new MMS library
			listParams  = MM_LIST_SENT;
		}
		else
		{
			// xreddymn May-18-2005 MMI-SPR-29887: Removed MM_LIST_COMPLETE
			// as it causes messages from Sent to be listed, with the new MMS library
	    	listParams  = MM_LIST_DRAFT;
		}
		
		eStatus = DAL_ListMessagesByParam(&g_pMessageHeaderList, listParams);

		if(eStatus != ENoError)
		{
			//M4_DebugStringMessage("MMSBox_exec_cb: eStatus != ENoError",sizeof("MMSBox_exec_cb: eStatus != ENoError"),0);
		}

		if(g_pMessageHeaderList == NULL || g_pMessageHeaderList->size ==0 )
		{
			T_DISPLAY_DATA display_info;
			//M4_DebugStringMessage("g_pMessageHeaderList->size==0",sizeof("g_pMessageHeaderList->size==0"),0);
			if(g_pMessageHeaderList != NULL) M4_FreeListFolderMemory();
			
			dlg_initDisplayData_TextId( &display_info,  TxtNull, TxtSoftBack,TxtEmptyList, TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_info_cb, FOREVER, KEY_RIGHT|KEY_CLEAR|KEY_HUP);
			display_info.Identifier=0;
			info_dialog (win, &display_info);
			dspl_Enable(1);
			break;
		}
		
		box_menu_list_data =(ListMenuData *) ALLOC_MEMORY(sizeof(ListMenuData));
		box_menu_list_data->List = (T_MFW_MNU_ITEM *)ALLOC_MEMORY( g_pMessageHeaderList->size * sizeof(T_MFW_MNU_ITEM) );
		//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
		//dynamically allocating memory for g_mmstopic. Total size = max size of one string in the list X total number of mms
		g_mmstopic=(char*)ALLOC_MEMORY(MMS_BOX_LIST_STRING_MAX_LENGTH*g_pMessageHeaderList->size);
		g_mmsstatus=(char*)ALLOC_MEMORY(MMS_BOX_LIST_STRING_MAX_LENGTH);

		// xreddymn Dec-15-2004 MMI-SPR-27384: Modifications for Inbox/Unsent/Sent box presentation
		// xrashmicn OMAPS00050170
		for (i = 0; (i < g_pMessageHeaderList->size) ; i++)
		{
			//CRR 25270: xpradipg    
			mnuInitDataItem(&box_menu_list_data->List[i]);
			box_menu_list_data->List[i].flagFunc = item_flag_none;
			//CRR 25270 && CRR 25268: 14 Oct 2004 - xpradipg
			//the temporary buffer is reset after every iteration
			memset(g_mmsstatus,'\0',MMS_BOX_LIST_STRING_MAX_LENGTH);

			//CRR 25270 & CRR 25268: 13 Oct 2004 - xpradipg
			//Set the title to Saved if the folder being listed is Unsent
			//Otherwise append thestring "New"/"Old" depending on the 
			//status of the read flag in the message header
			if(!(listParams & MM_LIST_DRAFT))
			{
				//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
				//Changed from static allocations for g_mmstopic and g_mmsstatus to dynamic allocation.
				if(g_pMessageHeaderList->ppList[i].read== TRUE)
					strcpy(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],"Old: ");
				else
					strcpy(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],"New: ");
			}
			else
			{
				//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
				//Changed from static allocations for g_mmstopic and g_mmsstatus to dynamic allocation.
				strcpy(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],"Saved: ");
				box_menu_list_data->List[i].str  = &g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH];
				// continue;
			}
			//CRR 25270 & CRR 25268: 13 Oct 2004 - xpradipg
			//The Topic is displayed for the mms, if the topic is not present
			//then the name is searched for corresponding to the number from
			//which the message was received. For EMS only the number /name is 
			//displayed
			if(g_pMessageHeaderList->ppList[i].type!=EMtSms)
			{
				lenSub=GetStringBytes(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pSubject);
				//CRR 25270: xpradipg 
				if(lenSub==0)
				{
					// xreddymn Dec-15-2004 MMI-SPR-27384
					switch((UBYTE)parameter)
					{
						case MMS_INBOX:
							lenSub=GetStringBytes(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pFrom);		
							break;
						case MMS_SENT:
							lenSub=GetStringBytes(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pToList);
							break;
						default:
							lenSub=0;
							break;
					}
					if(lenSub==0)
					{
						strcpy(g_mmsstatus,"No name");
					}
					else
					{
						if(lenSub>MMS_BOX_LIST_SUB_MAX_LENGTH) lenSub=MMS_BOX_LIST_SUB_MAX_LENGTH;
						// xreddymn Dec-15-2004 MMI-SPR-27384
						switch((UBYTE)parameter)
						{
							case MMS_INBOX:
								ConvertUcs2To8BitString(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pFrom, lenSub, (MByte*)g_mmsstatus);
								break;
							case MMS_SENT:
								ConvertUcs2To8BitString(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pToList, lenSub, (MByte*)g_mmsstatus);
								break;
							default:
								strcpy(g_mmsstatus,"");
								break;
						}
						if (bookFindNameInPhonebook( g_mmsstatus, &phonebook_entry ))
						{
							if (phonebook_entry.name.len >0)
							{
								strncpy(g_mmsstatus,(const char*)phonebook_entry.name.data,lenSub);
							}
						}
					}
				}
				else
				{
					if(lenSub>MMS_BOX_LIST_SUB_MAX_LENGTH) lenSub=MMS_BOX_LIST_SUB_MAX_LENGTH;
					ConvertUcs2To8BitString(g_pMessageHeaderList->ppList[i].messageTypeHeader.mmsHeader.pSubject, lenSub, (MByte*)g_mmsstatus);
				}
				//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
				//Changed from static allocations for g_mmstopic and g_mmsstatus to dynamic allocation.
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],g_mmsstatus);
				/* Dec-15-2004 MMI-SPR-27384: Insert the time stamp information */
				MMSBox_DT_string((char*)g_mmsstatus,&g_pMessageHeaderList->ppList[i].timestamp);
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],"\n");
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],g_mmsstatus);
			}
			//CRR 25270 & CRR 25268: 13 Oct 2004 - xpradipg
			//retrieve the number from the ems and look for the
			//corresponding entry in the phonebook, populate the
			//name if present else display the number
			else
			{
				lenSub=GetStringBytes(g_pMessageHeaderList->ppList[i].messageTypeHeader.smsHeader.pszAddress);
				if(lenSub>0)
				{
					if(lenSub>MMS_BOX_LIST_SUB_MAX_LENGTH) lenSub=MMS_BOX_LIST_SUB_MAX_LENGTH;
					ConvertUcs2To8BitString(g_pMessageHeaderList->ppList[i].messageTypeHeader.smsHeader.pszAddress, lenSub, (MByte*)g_mmsstatus);
					if (bookFindNameInPhonebook( g_mmsstatus, &phonebook_entry ))
					{
						if (phonebook_entry.name.len >0)
						{
							strncpy(g_mmsstatus,(const char*)phonebook_entry.name.data,lenSub);
						}
					}
				}
				//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
				//Changed from static allocations for g_mmstopic and g_mmsstatus to dynamic allocation.
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],g_mmsstatus);
				/* Dec-15-2004 MMI-SPR-27384: Insert the time stamp information */
				MMSBox_DT_string((char*)g_mmsstatus,&g_pMessageHeaderList->ppList[i].timestamp);
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],"\n");
				strcat(&g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH],g_mmsstatus);
			}
			box_menu_list_data->List[i].str  = &g_mmstopic[i*MMS_BOX_LIST_STRING_MAX_LENGTH];
		}

		box_menu_list_data->ListLength =g_pMessageHeaderList->size;
		box_menu_list_data->ListPosition = 1;
		box_menu_list_data->CursorPosition = 1;
		box_menu_list_data->SnapshotSize = g_pMessageHeaderList->size;
		box_menu_list_data->Font = 0;
		box_menu_list_data->LeftSoftKey = TxtSoftSelect;
		box_menu_list_data->RightSoftKey = TxtSoftBack;
		box_menu_list_data->KeyEvents = KEY_ALL;
		box_menu_list_data->Reason = 0;
		box_menu_list_data->Strings = TRUE;
		box_menu_list_data->Attr   = &MmsBox_menuAttrib;
		box_menu_list_data->autoDestroy    = FALSE;
		listDisplayListMenu(win,box_menu_list_data,(ListCbFunc)MMSBoxList_cb,0);
		//CRR 25277: xpradipg 06 Oct 2004
		//the display needs to be refreshed forcibly
		dspl_Enable(1);
		break;
		
	case MWM_DESTORY:
		TRACE_EVENT(" Event: MWM_DESTORY");
		if(box_menu_list_data)
		{
			if(box_menu_list_data->List && g_pMessageHeaderList)
			{
				FREE_MEMORY((void*)(box_menu_list_data->List),g_pMessageHeaderList->size * sizeof(T_MFW_MNU_ITEM ));
			}
			FREE_MEMORY((void*)(box_menu_list_data),sizeof(ListMenuData));
		}
		//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
		//Freeing the allocated memory on exiting the list screen
		if(g_mmsstatus)
			FREE_MEMORY((void*)g_mmsstatus,MMS_BOX_LIST_STRING_MAX_LENGTH);
		if(g_mmstopic)
			FREE_MEMORY((void*)g_mmstopic,MMS_BOX_LIST_STRING_MAX_LENGTH*g_pMessageHeaderList->size);
		
		//CRR 23963: xpradipg 26 Aug 2004
		//reset the folder value to default
		folder = 0xFF;
                //CRR 25277: xpradipg 06 Oct 2004
                //set the handle to NULL on destroying the window
                mmsboxwinhnd=NULL;
				g_MmsBoxWin=NULL;//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
		//M4_FreeListFolderMemory frees the memory for g_pMessageHeaderList. But g_pMessageHeaderList->size is used to
		//free memory for various dynamically allocated pointers eg. g_mmstopic. Hence this should be done at the end .
		M4_FreeListFolderMemory();
		break;
	case MWM_ONDRAW:
		TRACE_EVENT(" Event: MWM_ONDRAW");
		displaySoftKeys(TxtSoftOptions,TxtSoftBack);
		break;

	// xreddymn Dec-20-2004 MMI-SPR-27382: Save the handle to Inbox window
	case MWM_SUSPEND:
		g_MmsBoxWinSavedHnd=mmsboxwinhnd;
		mmsboxwinhnd=NULL;
		break;

	// xreddymn Dec-20-2004 MMI-SPR-27382: Restore the handle to Inbox window
	case MWM_RESUME:
		if(!mmsboxwinhnd)
		{
			mmsboxwinhnd=g_MmsBoxWinSavedHnd;
		}
		break;
		
	default:
	    break;
	}

	return;
}


/**/

/*******************************************************************************

 $Function:    	MMSBox_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSBox_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSBox_start()");
	mmeBackLight(64);
	// xreddymn Nov-30-2004 MMI-SPR-23981: Retain the handle to the Message List menu window
	g_MmsBoxWin=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSBox_exec_cb,(void*)menuAttr,(T_MFW_CB)0,0,0);
	return g_MmsBoxWin;
}


#define MMS_BOX_EXTERACT_MEDIA
#define MWM_EXTRACT_MEDIA_LIST	(MWM_USER+1)
#define MWM_EXTRACT_MEDIA_NONE	(MWM_USER+2)
#define MMS_EXTRACT_MEDIA_ERROR	(MWM_USER+3)

#if 1

PP_MESSAGE_HANDLE msgHandle = PP_MESSAGE_HANDLE_INVALID;

PP_S_OBJECT_DATA *pObjData = NULL;

PP_S_OBJECT_ATTRIB *pObjAttrib = NULL;

PP_S_MIME_OBJECT_ARRAY	*pObjArray = NULL;

M4_S_OBJECT_ITEM *pItem = NULL;

M4_S_OBJECT_ATTRIB *pAttrib = NULL;

UCS2 medianame[32]={'p','i','c','0',0};
int len_medianame=10;


void M4_FreeAttrib(void * block)	/*Pointer to function used to free this block of memory*/
{
	if(block)
		FREE_MEMORY((void*)block,sizeof(M4_S_OBJECT_ATTRIB));
}
void M4_FreeItem(void * block)	/*Pointer to function used to free this block of memory*/
{
	if(block)
		FREE_MEMORY((void*)block,sizeof(M4_S_OBJECT_ITEM));
}

/*****************************************************************************
 * Func : SaveObjectDone
 * Desc : It is the callback function indicating the result of saving object.
 *****************************************************************************/
ESTATUS M4_SaveObjectDone(EVENT_ID			aeId,
		       EVENT_TYPE		aeType,
			   MESSAGE_PARAM	ampParam,
			   EVT_HANDLE		evtHandle)
{
	switch(aeId)
	{
		case(EMG4_FileOpDone):
			{
				/* NOTES:
				 * Object storing is done
				 */

				/* 
				 * Further notification to upper layer if necessary
				 */
				DAL_PostMessage(EMG4_FileOpDone,
						        EVENT_REACTIVE,
								0,
								evtHandle->parentEvtHandle);
				// xreddymn Nov-26-2004 MMI-SPR-25278
				winDelete(g_inSaveModeWin);
                            //xrashmic 08 Feb, 2005 MMI-SPR-27853
                            //Added few more parameters for this function
				information_dialog(TxtSaved,TxtNull,NULL,NULL, TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
			}
			break;

		case(EMG4_OpError):
		// xreddymn Nov-26-2004 MMI-SPR-25278
		winDelete(g_inSaveModeWin);
              //xrashmic 08 Feb, 2005 MMI-SPR-27853
              //Added few more parameters for this function
		information_dialog(TxtFailed,TxtFatalError,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
		default:
			break;
	}

	if(evtHandle)
	{
		FREE_MEMORY((void*)evtHandle,sizeof(*evtHandle));
	}
	// xreddymn Aug-26-2004, MMI-SPR-24113 (TII_MMS53) and MMI-SPR-23972 (TII_MMS41)
	// Removed the following lines since this is done in MWM_DESTROY of MMSBox_Extract_exec_cb
#if(0)
	/* NOTES:
	 * The PP Session must be closed 
	 */
	DAL_CloseMessageSession(msgHandle);

	/* Free the memory allocated before */
	pObjArray->oms.freeFunc(pObjArray);
	pObjData->oms.freeFunc(pObjData);
#endif
	return ENoError;
}
/*****************************************************************************
 * Func : SaveObject
 * Desc : User selects the object being saved
 *****************************************************************************/
ESTATUS M4_SaveObject(PP_OBJECT_ID	objId, EVT_HANDLE parentHandle)
{
	ESTATUS 	status = ENoError;
	EVT_HANDLE 	evtHandle = NULL;

	// xreddymn Nov-26-2004 MMI-SPR-25278
        //xrashmic 08 Feb, 2005 MMI-SPR-27853
        //Added few more parameters for this function
	g_inSaveModeWin=information_dialog(TxtPleaseWait,TxtNull,NULL,NULL,TxtNull,TxtNull,FOREVER,0,NULL);

	status = DAL_GetObjectByID(msgHandle, objId, &pObjData);
	TRACE_EVENT_P1("DAL_GetObjectByID :%d", status);

	if(ENoError != status)
	{
		return status;
	}

	status = DAL_GetObjectAttributes(msgHandle, objId, &pObjAttrib);
	TRACE_EVENT_P1("DAL_GetObjectAttributes :%d", status);

	if(ENoError != status)
	{
		pObjData->oms.freeFunc(pObjData);
		return status;
	}	

	pItem = (M4_S_OBJECT_ITEM *)ALLOC_MEMORY(sizeof(M4_S_OBJECT_ITEM));

	pAttrib = (M4_S_OBJECT_ATTRIB *)ALLOC_MEMORY(sizeof(M4_S_OBJECT_ATTRIB));

	evtHandle = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));

	if((NULL == evtHandle) || (NULL == pItem) || (NULL == pAttrib))
	{
		if(pItem)
		{
			FREE_MEMORY((void*)pItem,sizeof(*pItem));
		}

		if(pAttrib)
		{
			FREE_MEMORY((void*)pAttrib,sizeof(*pAttrib));
		}

		if(evtHandle)
		{
			FREE_MEMORY((void*)evtHandle,sizeof(*evtHandle));
		}
		return EOutOfMemory;
	}

	memset((void*)pItem, 0x00, sizeof(M4_S_OBJECT_ITEM));
	memset((void*)pAttrib, 0x00, sizeof(M4_S_OBJECT_ATTRIB));
	memset((void*)evtHandle, 0x00, sizeof(EVT_STRUCT));

	/* NOTES:
	 * Copy the information into appropriate structure
	 */
	pItem->memHdr.freeFunc = M4_FreeItem;/* Object free function */
	pItem->objectSize = pObjData->lObjectDataSize;
	pItem->pData = pObjData->objData.pByteData;

	pAttrib->memHdr.freeFunc = M4_FreeAttrib;/* Object free function */
	pAttrib->type = pObjAttrib->contentType/* Object Type: EMtMimeWbmp, etc*/;
	pAttrib->objectSize = pObjData->lObjectDataSize;
	pAttrib->drmInfo =  EDrmNotSet; /* DRM info */
	pAttrib->objectFile.fileNameLen = len_medianame; /* User Input FileName Size */ ;
	pAttrib->objectFile.pFileName = medianame;  /* User Input File Name */;

		
	/* NOTES:
	 * Setup the event handler
	 */

	evtHandle->handler = M4_SaveObjectDone;
	evtHandle->pData = pObjData;
	evtHandle->parentEvtHandle = parentHandle;

	status = DAL_StoreObjectAsync(evtHandle, pItem, pAttrib);
	TRACE_EVENT_P1("DAL_StoreObjectAsync :%d", status);

	return status;
}

/*****************************************************************************
 * Func: PPOpenMessageCallback
 * Desc: 
 *****************************************************************************/
ESTATUS M4_PPOpenMessageCallback(EVENT_ID			aeId,
		              EVENT_TYPE		aeType,
					  MESSAGE_PARAM		ampParam,
					  EVT_HANDLE		evtHandle)
{
	ESTATUS	status = ENoError;
	PP_OBJECT_ID 			objId;
	T_MFW_HND    win  = mfwParent(mfw_header());
	//M4_DebugStringMessage("M4_PPOpenMessageCallback", sizeof("M4_PPOpenMessageCallback"), 0);

	switch(aeId)
	{
		case(EMG4_FileOpDone):
			{
				/* 
				 * The PP Session is ready for listing objects available
				 */
				msgHandle = (PP_MESSAGE_HANDLE)ampParam;
				
				status = DAL_ListMessageObjects(msgHandle, &pObjArray);

				/* User use the this information to display the associated objects
				 * in this message
				 */
				//M4_DebugStringMessage("DAL_ListMessageObjects", sizeof("DAL_ListMessageObjects"), 0);
				M4_DebugMessage(status);
				//M4_DebugStringMessage("pObjArray->numOfObjects", sizeof("pObjArray->numOfObjects"), pObjArray->numOfObjects);
				M4_DebugMessage(pObjArray->numOfObjects);
				if(pObjArray==NULL || pObjArray->numOfObjects==0)
				{
					//SEND_EVENT(win, MWM_EXTRACT_MEDIA_NONE, 0, 0);
					MMSBox_Extract_exec_cb (win, MWM_EXTRACT_MEDIA_NONE, 0, 0);
				}else
				{
					// SEND_EVENT(win, MWM_EXTRACT_MEDIA_LIST, 0, 0);
					MMSBox_Extract_exec_cb (win, MWM_EXTRACT_MEDIA_LIST, 0, 0);
				}
			}
			break;

		case(EMG4_OpError):
			// xreddymn Aug-20-2004 MMI-SPR-23962 (TII_MMS31): Added error handling
			//SEND_EVENT(win, MMS_EXTRACT_MEDIA_ERROR, 0, 0);
			MMSBox_Extract_exec_cb (win, MMS_EXTRACT_MEDIA_ERROR, 0, 0);
			break;

		default:
			break;
	}

	if(evtHandle)
	{
		FREE_MEMORY ((void *)evtHandle, sizeof (EVT_STRUCT));
	}
	
	return ENoError;
}

ESTATUS M4_ExtractMedia(MM_MESSAGE_ID selectedMsgId, EVT_HANDLE parentHandle)
{
	EVT_HANDLE	evtHandler = NULL;
	ESTATUS		status = ENoError;

	evtHandler = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));

	if(NULL == evtHandler)
	{
		/* Error */
		return EOutOfMemory;
	}
	
	memset((void*)evtHandler, 0x00, sizeof(EVT_STRUCT));

	evtHandler->handler = M4_PPOpenMessageCallback;
	evtHandler->parentEvtHandle = parentHandle;

	/* 
	 * Open the PP session & wait for EMG4_FileOpDone
	 */
	
	status = DAL_OpenMessageAsync(evtHandler, selectedMsgId);
	TRACE_EVENT_P1("DAL_OpenMessageAsync :%d", status);
	if(ENoError != status)
	{
		FREE_MEMORY ((void *)evtHandler, sizeof (EVT_STRUCT));
	}
	return status;
}

ESTATUS DeleteMsgCallback(EVENT_ID		aeId,
		          EVENT_TYPE	aeType,
				  MESSAGE_PARAM	ampParam,
				  EVT_HANDLE	evtHandle)
{
	switch(aeId)
	{
		case(EMG4_FileOpDone):
			/*
			 * Msg Delete Successful
			 */
			// xreddymn Dec-20-2004 MMI-SPR-27382: Remove the "Please wait" screen
			winDelete(g_MmsPleaseWaitWin);
			// xreddymn Nov-30-2004 MMI-SPR-23981: Reload the message list
			MMI_DestoryWindow(g_OptionsWin);
			SEND_EVENT (g_MmsBoxWin, MWM_REDRAW, 0,(void *)folder);
			break;

		case(EMG4_OpError):
			/*
			 * Msg Delete Fail with error code in ampParam
			 */
			// xreddymn Dec-20-2004 MMI-SPR-27382: Remove the "Please wait" screen
			winDelete(g_MmsPleaseWaitWin);
			// xreddymn Nov-30-2004 MMI-SPR-23981: Display an error dialog
			MMI_DestoryWindow(g_OptionsWin);
			SEND_EVENT (g_MmsBoxWin, MWM_REDRAW, 0,(void *)folder);
			break;
		default:
			break;
	}

	if(evtHandle)
	{
		FREE_MEMORY ((void *)evtHandle, sizeof (EVT_STRUCT));

	}
}
/*****************************************************************************
 *
 *****************************************************************************/
ESTATUS DeleteMsg(MM_MESSAGE_ID msgId)
{
	EVT_HANDLE evtHandle = NULL;

	evtHandle = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));

	if(NULL == evtHandle)
	{
		return EOutOfMemory;
	}

	memset((void*)evtHandle, 0x00, sizeof(EVT_STRUCT));

	evtHandle->handler = DeleteMsgCallback;
	
	(void)DAL_DeleteMessageAsync(evtHandle, msgId);

	return ENoError;
}


#endif

static T_MFW_HND l_extractwin=NULL;
static char topic[16];


static void MMSBox_ExtractMedia_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason)
{
	T_MFW_WIN	        * win_data = ((T_MFW_HDR *) win)->data;
	T_DISPLAY_DATA display_info;
    	ESTATUS status;

	TRACE_EVENT_P1("MMSBox_ExtractMedia_edit_cb() %d", Identifier);

	switch (reason)
    {
	case INFO_KCD_LEFT:  // confirm (press LEFT soft key)
        { 


		MMS_ConvertStringToUcs2((const MByte *)(topic), 
                                            strlen(topic),
                                            medianame);

		len_medianame=2*(strlen(topic)+1);
		status=M4_SaveObject((PP_OBJECT_ID)Identifier, 0);
		if(status==ENoError)
		{
		}else if(status==EObjectAlreadyExists)
		{
			
		}else
		{
		}
        }
    	break;

	case INFO_KCD_RIGHT:
	case INFO_KCD_HUP:
    		//xreddymn Aug-20-2004 MMI-SPR-24114 (TII_MMS54)
    		//MMI_DestoryWindow(win);
    	break;
	default:
    		TRACE_EVENT("Err: Default");
    	break;
    }
    g_MmsExtractEdtWin=NULL;//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
}

/*******************************************************************************

 $Function:     MMSBoxList_ExtractMedia_cb

 $Description:  Callback function for the melody list.

 $Returns:    none

 $Arguments:  Parent - parent window.
        ListData - Menu item list
*******************************************************************************/

void MMSBoxList_ExtractMedia_cb(T_MFW_HND * Parent, ListMenuData * ListData)
{
	TRACE_EVENT_P1("MMSBoxList_ExtractMedia_cb : %d", ListData->Reason);
	TRACE_EVENT_P2("ExtractMedia win parent: %x, l_extractwin: %x", Parent,l_extractwin);
	
	if ((ListData->Reason EQ LISTS_REASON_BACK) || (ListData->Reason EQ LISTS_REASON_CLEAR)
		|| (ListData->Reason EQ LISTS_REASON_HANGUP))	// sbh - added hangup key
	{
		listsDestroy(ListData->win);
		MMI_DestoryWindow(l_extractwin);
	}
	else if(ListData->Reason EQ LISTS_REASON_SELECT)
	{
		T_AUI_EDITOR_DATA editor_data;

		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, CENTRE_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT);

		//xreddymn Sep-24-2004 MMI-SPR-25148 : Modified this to get the object index from the array of indices
//		AUI_edit_SetEvents(&editor_data, (USHORT)( pObjArray->pMsgObject[ListData->CursorPosition].objId),
//			TRUE, FOREVER, (T_AUI_EDIT_CB)MMSBox_ExtractMedia_edit_cb);
		AUI_edit_SetEvents(&editor_data, (USHORT)( pObjArray->pMsgObject[extra_menu_list_indices[ListData->CursorPosition]].objId),
			TRUE, FOREVER, (T_AUI_EDIT_CB)MMSBox_ExtractMedia_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtTopics, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, TxtNames, TRUE, TxtSoftBack);
              //AUI_edit_SetMode(&editor_data,ED_MODE_ALL, ED_CURSOR_UNDERLINE);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE*)topic, 16);
		g_MmsExtractEdtWin = AUI_edit_Start(ListData->win, &editor_data);//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
	}
}

/*******************************************************************************

 $Function:    	MMSBox_Extract_exec_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:		none

 $Arguments:	win - current window
 				event - event id
 				value - unique id
 				parameter - optional data.
 			
*******************************************************************************/

/* xreddymn Aug-20-2004, MMI-SPR-23962 (TII_MMS31), Changes start:
 * Set to 1 for information display using dialog box
 * Set to 0 for information display using direct calls to display functions
 */
#define MMS_DIALOG_DISPLAY	1

/* In some cases, after object extraction, we may get an empty list. For such cases,
 * MMSBox_Extract_exec_list will be set to FALSE.
 */
BOOL MMSBox_Extract_exec_list=FALSE;

/* Keeps track of the window used to display the list or empty dialog */
T_MFW_HND MMSBox_Extract_exec_win;

/* Default key handler for MMIWindow. Control would be passed to this
 * in case a list menu is displayed, otherwise, a custom key handler will be called
 */
extern int MMIWindow_kbd_cb (MfwEvt e, MfwKbd *k);

#if(MMS_DIALOG_DISPLAY)
/* Call back function for the "Empty List" information dialog */
static void MMSBox_extract_info_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	switch (reason)
	{
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		MMI_DestoryWindow(MMSBox_Extract_exec_win);
		break;
	default:
		break;
	}
}
#endif // MMS_DIALOG_DISPLAY

/* Key handler: In case of list menu, control is passed to the default key handler */
int MMSBox_Extract_exec_kbd_cb (MfwEvt e, MfwKbd *k)
{
	if(MMSBox_Extract_exec_list == TRUE)
	{
		return MMIWindow_kbd_cb(e, k);
	}
	else
	{
		switch (k->code)
		{
		case KCD_HUP:
		case KCD_RIGHT:
		case KCD_CLEAR:
		 	MMI_DestoryWindow(MMSBox_Extract_exec_win);
			return MFW_EVENT_CONSUMED;
		    break;
		default:
		    return MFW_EVENT_CONSUMED;
		}
	}
}

/* xreddymn Aug-20-2004, MMI-SPR-23962 (TII_MMS31): Changes end */

void MMSBox_Extract_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	int i, count;
	TRACE_FUNCTION ("MMSBox_Extract_exec_cb()");
	//M4_DebugStringMessage("MMSBox_Extract_exec_cb", sizeof("MMSBox_Extract_exec_cb"),0);
	
	switch (event)
	{
	case MWM_CREATE:
		TRACE_EVENT(" Event: MWM_CREATE");
		/* initialization of data */
		msgHandle = PP_MESSAGE_HANDLE_INVALID;
		pObjData = NULL;
		pObjAttrib = NULL;
		pObjArray = NULL;
		pItem = NULL;
		pAttrib = NULL;
		M4_ExtractMedia(g_pMessageHeaderList->ppList[g_currentMessage].id, 0);
		break;
	case MWM_EXTRACT_MEDIA_NONE:
		{
			T_DISPLAY_DATA display_info;
			T_MFW_HND *win_handle;
			//M4_DebugStringMessage("pObjArray->numOfObjects==0",sizeof("pObjArray->numOfObjects==0"),0);
			//xreddymn Aug-17-2004, MMI-SPR-23962 (TII_MMS31): Moved back functionality to RSK
			dspl_Enable(0);
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtSoftBack, TxtEmptyList, TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_info_cb, FOREVER, KEY_RIGHT|KEY_CLEAR|KEY_HUP);
			display_info.Identifier=0;
			win_handle=info_dialog (win, &display_info);
			win_show(win_handle);
			dspl_Enable(1);
		}
		break;
	// xreddymn Aug-20-2004 MMI-SPR-23962 (TII_MMS31): Added error handling
	case MMS_EXTRACT_MEDIA_ERROR:
		{
			T_DISPLAY_DATA display_info;
			T_MFW_HND *win_handle;
			dspl_Enable(0);
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtSoftBack, TxtFailed, TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_extract_info_cb, FOREVER, KEY_RIGHT|KEY_CLEAR|KEY_HUP);
			display_info.Identifier=0;
			win_handle=info_dialog (win, &display_info);
			win_show(win_handle);
			dspl_Enable(1);
		}
		break;
	case MWM_EXTRACT_MEDIA_LIST:
		//M4_DebugStringMessage("MWM_EXTRACT_MEDIA_LIST", sizeof("MWM_EXTRACT_MEDIA_LIST"), pObjArray->numOfObjects);
		M4_DebugMessage(pObjArray->numOfObjects);
		extra_menu_list_data =(ListMenuData *) ALLOC_MEMORY(sizeof(ListMenuData));
		// xreddymn Aug-09-2004: MMI-SPR-23920 (TII_MMS7), If the object list is empty, then break out
		if(extra_menu_list_data==NULL)
		{
			//M4_DebugStringMessage("extra_menu_list_data Alloc memory fail", sizeof("extra_menu_list_data Alloc memory fail"), 0);
			break;
		}
		extra_menu_list_data->List = (T_MFW_MNU_ITEM *)ALLOC_MEMORY( pObjArray->numOfObjects* sizeof(T_MFW_MNU_ITEM) );
		if(extra_menu_list_data->List==NULL)
		{
			break;
		}
		// xreddymn Sep-24-2004, MMI-SPR-25148 : Allocate memory for the list of indices
		extra_menu_list_indices = (S16*) ALLOC_MEMORY(pObjArray->numOfObjects * sizeof(S16));
		if(extra_menu_list_indices==NULL)
		{
			break;
		}
		/* xreddymn Aug-18-2004, MMI-SPR-23962 (TII_MMS31): i is now used to index into
		 * extra_menu_list_data->List[] and count is used to index into pObjArray->pMsgObject[]
		 * On exit of the loop, count will contain the total objects listed
		 */
		for (count = 0, i=0; i < pObjArray->numOfObjects; count++, i++)
		{
			mnuInitDataItem(&extra_menu_list_data->List[count]);
			
			extra_menu_list_data->List[count].flagFunc = item_flag_none;
			M4_DebugMessage(pObjArray->pMsgObject[i].contentType);
			//xreddymn Sep-24-2004 MMI-SPR-25148 : Insert object index into the list of indices
			extra_menu_list_indices[count]=i;
			switch(pObjArray->pMsgObject[i].contentType)
			{
			case EMtMimeJpeg:
				extra_menu_list_data->List[count].str  = "Jpeg picture";
				break;
			case EMtMimeGif:
				extra_menu_list_data->List[count].str  = "Gif picture";
				break;
			case EMtMimeBmp:
				extra_menu_list_data->List[count].str  = "Bmp picture";
				break;
			case EMtMimeWbmp:
				extra_menu_list_data->List[count].str  = "WBmp picture";
				break;
			case EMtMimePng:
				extra_menu_list_data->List[count].str  = "Png picture";
				break;
			case EMtTextPlain:
				//xreddymn Aug-17-2004 MMI-SPR-23962 (TII_MMS31): Disabled text extraction
				//extra_menu_list_data->List[i].str  = "Plain text";
				--count;
				break;
			case EMtTextPhoneNumber:
				extra_menu_list_data->List[count].str  = "Phone Number";
				break;
			case EMtTextEmail:
				extra_menu_list_data->List[count].str  = "Email";
				break;
			//xreddymn Aug-23-2004 MMI-SPR-23962 (TII_MMS31): Audio AMR included for listing
			case EMtMimeAmr:
				extra_menu_list_data->List[count].str  = "Audio AMR";
				break;
			//xreddymn Jan-31-2004 MMI-SPR-28483: Audio MIDI included for listing
			case EMtMimeMidi:
				extra_menu_list_data->List[count].str  = "Audio MIDI";
				break;
			default:
				//xreddymn Aug-17-2004 MMI-SPR-23962 (TII_MMS31): Disabled Unknown object extraction
				//extra_menu_list_data->List[i].str  = "Unknown";
				--count;
			}
		}
		// xreddymn Aug-09-2004: MMI-SPR-23962 (TII_MMS31), Display a dialog if there are no objects to extract
		if(count<=0)
		{
			MMSBox_Extract_exec_list=FALSE;
#if(MMS_DIALOG_DISPLAY)
			{
			/* Display information using a dialog box */
			T_DISPLAY_DATA display_info;
			T_MFW_HND *win_handle;
			dspl_Enable(0);
 			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtSoftBack, TxtEmptyList, TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_extract_info_cb, FOREVER, KEY_RIGHT|KEY_CLEAR|KEY_HUP);
			display_info.Identifier=0;
			win_handle=info_dialog (win, &display_info);
			win_show(win_handle);
			dspl_Enable(1);
			}
#else // MMS_DIALOG_DISPLAY
			{
			/* Display information directly */
			char *str=MmiRsrcGetText(TxtEmptyList);
			dspl_Enable(0);
			dspl_SetBgdColour(COL_White);
			dspl_ClearAll();
			dspl_SetFgdColour(COL_Black);
			dspl_TextOut(0,32,0,str);
			displaySoftKeys(TxtNull,TxtSoftBack);
			dspl_Enable(1);	
			}
#endif // MMS_DIALOG_DISPLAY
			break;
		}
		extra_menu_list_data->ListLength = count;
		extra_menu_list_data->ListPosition = 1;
		extra_menu_list_data->CursorPosition = 1;
		extra_menu_list_data->SnapshotSize = count;
		extra_menu_list_data->Font = 0;
		extra_menu_list_data->LeftSoftKey = TxtSoftSelect;
		extra_menu_list_data->RightSoftKey = TxtSoftBack;
		extra_menu_list_data->KeyEvents = KEY_ALL;
		extra_menu_list_data->Reason = 0;
		extra_menu_list_data->Strings = TRUE;
		extra_menu_list_data->Attr   = &MmsBox_ExtractMedia_menuAttrib;
		extra_menu_list_data->autoDestroy    = FALSE;
		listDisplayListMenu(win,extra_menu_list_data,(ListCbFunc)MMSBoxList_ExtractMedia_cb,0);
		dspl_Enable(1);
		break;
	case MWM_DESTORY:
		TRACE_EVENT(" Event: MWM_DESTORY");
		if(extra_menu_list_data)
		{
			if(extra_menu_list_data->List && pObjArray)
			{
				FREE_MEMORY((void*)(extra_menu_list_data->List), pObjArray->numOfObjects* sizeof(T_MFW_MNU_ITEM ));
			}
			FREE_MEMORY((void*)(extra_menu_list_data),sizeof(ListMenuData));
		}
		//xreddymn Sep-24-2004 MMI-SPR-25148 : Free memory for list of indices
		if(extra_menu_list_indices)
		{
			FREE_MEMORY((void*)extra_menu_list_indices, pObjArray->numOfObjects * sizeof(S16));
		}
		if(pObjArray) pObjArray->oms.freeFunc(pObjArray);
		//xreddymn Aug-24-2004 MMI-SPR-23972 (TII_MMS41) and MMI-SPR-24113 (TII_MMS53): Close the message session if it hasn't been already done
		if(pObjData) pObjData->oms.freeFunc(pObjData);
		if(msgHandle!=PP_MESSAGE_HANDLE_INVALID)
		{
			DAL_CloseMessageSession(msgHandle);
			msgHandle=PP_MESSAGE_HANDLE_INVALID;
		}
		MMSBox_Extract_exec_win=NULL;//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		break;
	case MWM_ONDRAW:
		TRACE_EVENT(" Event: MWM_ONDRAW");
		// xreddymn Aug-20-2004, MMI-SPR-23962 (TII_MMS31): Removed direct display for now
#if(MMS_DIALOG_DISPLAY)
		// Dialog display to be added
#else // MMS_DIALOG_DISPLAY
		dspl_ClearAll();
		dspl_TextOut(0,32,0,"Please Wait");
		displaySoftKeys(TxtSoftOK,TxtSoftBack);
#endif // MMS_DIALOG_DISPLAY
		break;
	default:
	    return;
	}
}

/*******************************************************************************

 $Function:    	MMSBox_Extract_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSBox_Extract_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSBox_Extract_start()");
	// xreddymn Aug-20-2004, MMI-SPR-23962 (TII_MMS31): Initialization
	MMSBox_Extract_exec_list=TRUE;
	MMSBox_Extract_exec_win=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSBox_Extract_exec_cb,(void*)menuAttr,(T_MFW_CB)MMSBox_Extract_exec_kbd_cb,0,0);
	return MMSBox_Extract_exec_win;
}


#define MMS_BOX_OPTION_BEGIN


/*******************************************************************************

 $Function:    	MMSBox_OPT_exec_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:		none

 $Arguments:	win - current window
 				event - event id
 				value - unique id
 				parameter - optional data.
 			
*******************************************************************************/
void MMSBox_OPT_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	TRACE_FUNCTION ("MMSBox_OPT_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		TRACE_EVENT(" Event: MWM_CREATE");
		/* initialization of administrative data */
		winShow(win);
		break;
	case MWM_DESTORY:
		TRACE_EVENT(" Event: MWM_DESTORY");
		// xreddymn Nov-30-2004 MMI-SPR-23981: Moved this from MMSBox_Read_exec_cb
		//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
		//Only for Inbbox this check for new ems messages are necessary not for other folders
		if(folder==MM_LIST_INBOX)
		{
			if( MMS_Is_Unread_Msgs_Inbox())
			{
				idle_data.ems = TRUE;
			}
			else
			{
				idle_data.ems = FALSE;
			}
		}
              //xrashmic 20 Dec, 2004  MMI-SPR-23921
              // On deleting the window, set the handler to NULL
              g_OptionsWin=NULL;
		break;
	case MWM_ONDRAW:
		TRACE_EVENT(" Event: MWM_ONDRAW");
		dspl_ClearAll();
		displaySoftKeys(TxtSoftOK,TxtSoftBack);
		break;
	default:
	    return;
	}
}


extern void EMS_RetriveSendMsg(UINT32 MsgId);
// xrashmic 13 Aug, 2004 Bug: 19
extern T_MFW_HND EMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);

//CRR 23963: xpradipg 26 Aug 2004
/*******************************************************************************

 $Function:    	MMSBox_OPT_kbd_cb

 $Description:	Keyboard handler for the options menu
 
 $Returns:	if event consumed or not

 $Arguments:	 
 
*******************************************************************************/

static int MMSBox_OPT_kbd_cb(MfwEvt e, MfwKbd *k)
{
  T_MFW_HND    win  = mfwParent(mfw_header());
    T_MFW_WIN  * win_data = ((T_MFW_HDR *)win)->data;
    T_MMIWINDOW      * data = (T_MMIWINDOW *)win_data->user;

    TRACE_FUNCTION ("MMIWindow_kbd_cb()");

 	 if (e & KEY_LONG)
	{
	    switch (k->code)
		{
		case KCD_HUP: /* back to previous menu */
		    mnuEscape(data->menu);
		    break;
		case KCD_RIGHT: /* Power Down */
		    return MFW_EVENT_REJECTED; /* handled by idle */
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    else
	{
	    switch (k->code)
		{
		case KCD_MNUUP: /* highlight previous entry */
		    mnuUp(data->menu);
		    break;
		case KCD_MNUDOWN: /* highlight next entry */
		    mnuDown(data->menu);
		    break;
		case KCD_MNUSELECT:
		case KCD_LEFT: /* activate this entry */
		    mnuSelect(data->menu);
		    break;
		case KCD_HUP: /* back to previous menu */
		case KCD_RIGHT: /* back to previous menu */
			{
				T_MFW_HND    pWin  = data->parent ;
				T_MFW_WIN  * pwin_data = ((T_MFW_HDR *)pWin)->data;
    				T_MMIWINDOW      * pdata = (T_MMIWINDOW *)pwin_data->user;

				mnuEscape(data->menu);
				if (pdata NEQ NULL)
				{
					SEND_EVENT (pdata->parent, MWM_REDRAW, 0,(void *)folder);
				}
			}
		     break;
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMSBox_OPT_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSBox_OPT_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSBox_OPT_start()");
	//CRR 23963: xpradipg 26 Aug 2004
	//keyboard handler added for the options menu
	// xreddymn Nov-30-2004 MMI-SPR-23981: Retain handle to Message Options sub-menu window
    if(g_pMessageHeaderList->ppList[g_currentMessage].type==EMtSms)
    {
        //xrashmic 7 Dec, 2004 MMI-SPR-23965
        // Separate Option list for EMS. 
        g_OptionsWin=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSBox_OPT_exec_cb,(void*)menuAttr,(T_MFW_CB)MMSBox_OPT_kbd_cb,&EMSBox_OPTAttrib,0);    
    }
    else
    {
        g_OptionsWin=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSBox_OPT_exec_cb,(void*)menuAttr,(T_MFW_CB)MMSBox_OPT_kbd_cb,&MMSBox_OPTAttrib,0);
    }       
    return g_OptionsWin;    
}
//menu call back
static int MMSBox_OPTexeRead(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    MMSBox_Read_start(win, NULL);
}
 // May 11 2005  REF:  MMI-SPR-29887  x0012849
 // New Function which is called when tried to retrieve the incomplete MMS.
/*******************************************************************************
 $Function:    	MMSBox_OPTexeDeferDownload
 $Description:	Starts the retrieval of MMS from the server
 $Returns:		
 $Arguments:	
*******************************************************************************/
extern T_idle idle_data;	
static int MMSBox_OPTexeDeferDownload(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND dlg_win = NULL;  
    TRACE_EVENT("MMSBox_OPTexeDeferDownload");
    MMSactive = TRUE ; 
    if (idle_data.search)
    {
         dlg_win= information_dialog(TxtNotConnected,TxtNull,NULL,NULL, TxtNull,TxtNull,TWO_SECS,0,NULL);
 	  return 1;	
    }
    DeferDownloadMsg(g_pMessageHeaderList->ppList[g_currentMessage].id);
    return 0;	
}
  // May 12 2005  REF:  MMI-SPR-29887  x0012849
 // New Function which is called when tried to retrieve the incomplete MMS.
/*******************************************************************************
 $Function:    	DeferDownloadMsg
 $Description:	Starts the retrieval of MMS from the server
 $Returns:	 return the status of the operation.	
 $Arguments: msgID  - For which the MMS body need to be retrieved	 
*******************************************************************************/

void DeferDownloadMsg(MM_MESSAGE_ID msgId)
{

     MM_S_MESSAGE_HEADER *appMessageHeader;
	TRACE_FUNCTION ("DeferDownloadMsg()");
       // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
	 is_downloadcancelled=FALSE; 	 
        is_deferdownload = TRUE; 
   	 AUI_mms_status_notify(MMS_RECEIVE_PROGRESS);       
       MMSDownLoadNow(msgId);
       // May 11 2005  REF:  MMI-SPR-29887  xrashmi
      AUI_retrievemms_gprs_set_callback();
}

 // May 12 2005  REF:  MMI-SPR-29887  x0012849
 // New Function which is called when tried to retrieve the incomplete MMS.
/*******************************************************************************
 $Function:    	MMSDownLoadNow
 $Description:	Starts the download of MMS  from the server
 $Returns:	 return the status of the operation.	
 $Arguments: msgID  - For which the MMS body need to be retrieved	 
*******************************************************************************/

 void MMSDownLoadNow(MM_MESSAGE_ID msgId)
{
   EVT_HANDLE evtHandle = NULL;
   ESTATUS status;
TRACE_FUNCTION ("MMSDownLoadNow()"); 
   evtHandle = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));
   if(NULL == evtHandle)    
       return;    
   is_deferdownload = TRUE;  
   is_notifyResponse= TRUE;   
   // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
   rtvprogressValue=0;                    
   memset((void*)evtHandle, 0x00, sizeof(EVT_STRUCT));
   evtHandle->handler = DeferDownloadMsgCallback;
   status = DAL_GetMessageAsync(evtHandle, msgId);    
   }

 // May 12 2005  REF:  MMI-SPR-29887  x0012849
 // New Function which is called when tried to retrieve the incomplete MMS.
/*******************************************************************************
 $Function:    	 DeferDownloadMsgCallback
 $Description:	Starts the retrieval of MMS from the server
 $Returns:	status of the operation	
 $Arguments: 	 
*******************************************************************************/

static ESTATUS DeferDownloadMsgCallback(EVENT_ID		aeId,
		          EVENT_TYPE	aeType,
				  MESSAGE_PARAM	ampParam,
				  EVT_HANDLE	evtHandle)
{
                               
    
    BOOL deferdownload_finish = FALSE;
   TRACE_FUNCTION ("DeferDownloadMsgCallback()");       
    switch(aeId)
    {
        case(EMG4_NetworkOpDone):
            deferdownload_finish = TRUE;		 	   
           break;
       case(EMG4_OpProgress):
	   deferdownload_finish = FALSE;
         // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
         // Whenever there is a progress while retrieving MMS, update the display with the value..
        if(FALSE== is_downloadcancelled   &&  (ampParam > ( rtvprogressValue +5 )) )	 	
        	{ 

                if(ampParam < 0)
  		    rtvprogressValue=0;
		  else if(ampParam > 95 )
                   rtvprogressValue=100;	    	 	
		  else
                   rtvprogressValue=ampParam; 
		  AUI_mms_status_notify(MMS_RECEIVE_PROGRESS );
        	}
          break;
      case(EMG4_OpError):
	    deferdownload_finish = TRUE;	   		 
           break;
      default:			
           break;
   }
   if(deferdownload_finish == TRUE)
   {        
        if(evtHandle)
        {
            FREE_MEMORY ((void *)evtHandle, sizeof (EVT_STRUCT));
        }

     }                       
}
static int MMSBox_OPTexeExtract(MfwMnu* m, MfwMnuItem* i)
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    l_extractwin=MMSBox_Extract_start(win, NULL);
}

// xreddymn Oct-14-2004 MMI-SPR-25273
extern char EmsNumber[];
extern BOOL gEmsForward;
extern UINT32 gEmsMsgId;

static int MMSBox_OPTexeForward(MfwMnu* m, MfwMnuItem* i)
{
// xreddymn Oct-14-2004 MMI-SPR-25273: Re-implemented this function
	// xreddymn Oct-14-2004 MMI-SPR-25273: Added forward feature for EMS messages
	if(g_pMessageHeaderList->ppList[g_currentMessage].type==EMtSms)
	{
#ifdef FF_MMI_EMS
		T_MFW_HND win = mfwParent(mfw_header());
		gEmsForward=TRUE;
		gEmsMsgId = g_pMessageHeaderList->ppList[g_currentMessage].id;
/* 1 -> Insert existing phone number into the editor
 * 0 -> Start with blank phone number editor
 */
#if(0)
	{
		U16 *data;
		S32	length;
		data=(U16*)(g_pMessageHeaderList->ppList[g_currentMessage].messageTypeHeader.smsHeader.pszAddress);
		length=GetStringBytes((const UCS2 *)data);
		if(length>0)
		{
			ConvertUcs2To8BitString((const UCS2 * const)g_pMessageHeaderList->ppList[g_currentMessage].messageTypeHeader.smsHeader.pszAddress,
				length,(MByte*)EmsNumber);
		}
		else /* If the number is not valid, then start with blank number and ask the user to input */
		{
			strcpy((char*)EmsNumber,"");
		}
	}
#else // if(0)
		// Clear the number - Start with a blank number on the phone number input screen
		strcpy((char*)EmsNumber,"");
#endif // if(0)
		EMSCreate_start(win, 0);
#endif // FF_MMI_EMS
	}
//xrashmic 14 Dec, 2004 MMI-SPR-23921
// Added forward feature for MMS messages
       else
       {        
                 MMSactive=TRUE;
                 MMSFwd_start();
       }

}

//    Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
//    Fix:		An external variable to store the Mms Number extracted from the message header.
extern char MmsNumber[];

static int MMSBox_OPTexeReply(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	//Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
       //Fix:		A local variable to store the length of the senders address.
	S32	length;

	// xrashmic 13 Aug, 2004 Bug: 19
	// When reply is selected for a message from the inbox, we need to display corresponding 
	// compose screen i.e either EMS compose or MMS compose screen
	// TRACE_EVENT("Message Type = %d",g_pMessageHeaderList->ppList[g_currentMessage].type);
	if(g_pMessageHeaderList->ppList[g_currentMessage].type==EMtSms)
	{
#ifdef FF_MMI_EMS
		EMSCreate_start(win, 0);
#endif
	}
	else
	{
#ifdef FF_MMI_MMS
              //Nov 05, 2005	REF: OMAPS00049502   Sumanth Kumar. C
              //Fix:	Extraction of Senders number from the message header in the form of Unicode and converting it to 8bit string.
		length=GetStringBytes((const UCS2 *)g_pMessageHeaderList->ppList[g_currentMessage].messageTypeHeader.mmsHeader.pFrom);
		if(length>0)
		{
			ConvertUcs2To8BitString((const UCS2 * const)g_pMessageHeaderList->ppList[g_currentMessage].messageTypeHeader.mmsHeader.pFrom,
				length,(MByte*)MmsNumber);
		}
		else /* If the number is not valid, then start with blank number and ask the user to input */
		{
			strcpy((char*)MmsNumber,"");
		}

                // Apr 07 2005  REF:  MMI-SPR-27826  x0012849
               // To avoid crash when a user replies to the MMS which is there in Inbox 
               // If it is not set to TRUE , ATB_wap_content() will display the windows saying downloading data.
               MMSactive=TRUE;          
		MMSCreate_start(win, 0);
#endif
	}
}

static void MMSBox_Delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{

	TRACE_FUNCTION("MMSBox_Delete_cb");

	switch (reason)
	{
	case INFO_KCD_LEFT:
		//yanbin: Call magic4 function to delete text
		DeleteMsg(g_pMessageHeaderList->ppList[g_currentMessage].id);
		// xreddymn Dec-20-2004 MMI-SPR-27382: Display a "Please Wait" screen while deleting a message
		{
			T_DISPLAY_DATA display_info;
			T_MFW_HND    win  = mfwParent(mfw_header());

			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtPleaseWait, TxtNull, COLOUR_STATUS);
			dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_Delete_cb, FOREVER, 0);
			g_MmsPleaseWaitWin=info_dialog (win, &display_info);
		}
		break;
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		//return back
		break;
	default:
		break;
	}
}
static int MMSBox_OPTexeDelete(MfwMnu* m, MfwMnuItem* i)
{
	T_DISPLAY_DATA display_info;
	T_MFW_HND    win  = mfwParent(mfw_header());
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)MMSBox_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	info_dialog (win, &display_info);
}



#define PLAY_CURRENT_MMS_BEGIN
/*
void M4_DebugMessage_Pn ( char *format, ... )
{
	char trace_buf[128];
	va_list varpars;

	va_start (varpars, format);      
	vsprintf(trace_buf,format,varpars);
	va_end (varpars);             
	//M4_DebugStringMessage(trace_buf,strlen(trace_buf), 0);
}
*/
ESTATUS M4_PlayMessageEventHandlerFunc(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
//	M4_DebugMessage_Pn("M4_PlayMessageEventHandlerFunc() aeId: %d,aeType: %d,ampParam:%d",aeId,aeType,ampParam);
	switch(aeId)
	{
		case EMG4_FileOpDone:
//			M4_DebugMessage_Pn("EMG4_FileOpDone");
			DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
			
			DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed,EPlayModeRun,NULL);

			break;
			
		case EMG4_End:
			{
//				M4_DebugMessage_Pn("EMG4_End");
				/* Message has finished */
				FREE_MEMORY((U8*)evtHandle, sizeof(EVT_STRUCT));
			}
			break;
		case EMG4_PlayComplete:
//			M4_DebugMessage_Pn("EMG4_PlayComplete");
			
			/* TODO */
			break;
		case EMG4_OpProgress:
//			M4_DebugMessage_Pn("EMG4_OpProgress");
			dspl_TextOut(16, 16, 0,"Please wait!");
			break;
		case EMG4_OpError:
			{
				int type;
				int module;
				int status;
//				M4_DebugMessage_Pn("EMG4_OpError");

				status = (ampParam & 0x3FFF);
				module = (ampParam >> 22) & 0x1F;
				type   = (ampParam >> 28) & 0x1F;
				//M4_ActionError(status);
				dspl_TextOut(16, 16, 0,"Play MMS Error!");
				//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
				//To display the specific errors encountered
				switch(status)
				{
					case EFileNotFound:
						dspl_TextOut(16, 40, 0,"File not found");
						break;
					case EInvalidMediaType:
						dspl_TextOut(16, 40, 0,"Media Not Supported");
						break;
					case EMsgInComplete:
						 dspl_TextOut(16, 40, 0,"Incomplete Message");
						break;
					case EInvalidMsgId:
						 dspl_TextOut(16, 40, 0,"InvalidMsgID");
						break;

				}
				
                            MmsReadStatus = status;
				dspl_Enable(1);

				FREE_MEMORY((U8*)evtHandle, sizeof(EVT_STRUCT));

			}
			break;
	}

	return ENoError;
}

void M4_PlayMessage(MM_MESSAGE_ID aMessageID)
{
	EVT_HANDLE evtHandler;
	TRACE_EVENT("M4_PlayMessage");

	/* Create the event handler */
       evtHandler  = (EVT_HANDLE)ALLOC_MEMORY(sizeof(EVT_STRUCT));
	
	if (evtHandler == NULL)
	{
		//M4_DebugStringMessage("M4_PlayMessage: can not alloc message!", sizeof("M4_PlayMessage: can not alloc message!"), 0);
		return;
	}

	memset(evtHandler, 0x00, sizeof(EVT_STRUCT));				/* Reset the structure */
	evtHandler->handler = M4_PlayMessageEventHandlerFunc;	/* Set the event handler function */
	
	DAL_PlayMessage(evtHandler, aMessageID);
}


/*******************************************************************************

 $Function:    	MMSBox_read_exec_cb

 $Description:	Exec callback function of the MMS Create window 
 
 $Returns:		none

 $Arguments:	win - window handler
 				event - mfw event
 				parameter - optional data.
 
*******************************************************************************/
void MMSBox_Read_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
	TRACE_FUNCTION ("MMSBox_read_exec_cb()");

	switch (event)
	{
	case MWM_CREATE:
		TRACE_EVENT(" Event: MWM_CREATE");
		//xreddymn Aug-26-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		break;
	case MWM_ONDRAW:
		TRACE_EVENT(" Event: MWM_ONDRAW");
		dspl_Enable(0);
		dspl_SetBgdColour(COL_White);
		dspl_ClearAll();
		//yanbin: here call Magic4 functions to play MMS slides
		M4_PlayMessage(g_pMessageHeaderList->ppList[g_currentMessage].id);
              //CRR 25270 & CRR 25268: 13 Oct 2004 - xpradipg 
              //the status of the message is not updated if it is already in the read state
              //else the header of the message is edited and the flag is set to true
              if(g_pMessageHeaderList->ppList[g_currentMessage].read!=TRUE)
		{
        	     MM_BeginUpdateHeader(g_pMessageHeaderList->ppList[g_currentMessage].id);
        	     MM_UtilSetRead(g_pMessageHeaderList->ppList[g_currentMessage].id, TRUE);
                   MM_CommitUpdateHeaderAsync(NULL, g_pMessageHeaderList->ppList[g_currentMessage].id);
                 // xreddymn Nov-30-2004 MMI-SPR-23981: Update g_pMessageHeaderList
                 g_pMessageHeaderList->ppList[g_currentMessage].read=TRUE;
                 }
		//xmzhou_trace_string_value("MMSBox_Read_win_cb: M4_PlayMessage with id = ",  g_pMessageHeaderList->ppList[g_currentMessage].id);
              // xrashmic 7 Dec, 2004 MMI-SPR-23965
              if(g_pMessageHeaderList->ppList[g_currentMessage].type==EMtSms)
		displaySoftKeys(TxtExtract,TxtSoftBack);
		else
		displaySoftKeys(NULL,TxtSoftBack);    
		dspl_Enable(1);
		break;
	case MWM_DESTORY:
		TRACE_EVENT(" Event: MWM_DESTORY");
		//xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
		dspl_Enable(1);
              //CRR 24456: 19 Oct 2004 - xpradipg
              //check if the error has occurred while playing the message if
              //post the EPlayModeStop event else reset the error
              if(MmsReadStatus == ENoError)
                {
			DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed, EPlayModeStop,NULL);
			//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
			//EMG4_Exit should be done for only MMS that are sucessfully played.
			//For MMS which throw EMG4_OpError when DAL_PlayMessage is called, 
			//EMG4_Exit should not be done
			DAL_PostMessage(EMG4_Exit, EMG4_Type_NotUsed, 0, NULL);
                }
              else
                {
                    MmsReadStatus = ENoError;
                }
		
// xreddymn Nov-30-2004 MMI-SPR-23981: Moved this to MMSBox_OPT_exec_cb
#if(0)
              if(MMS_Is_Unread_Msgs_Inbox())
                idle_data.ems = TRUE;
              else
                idle_data.ems = FALSE;
#endif
		//xreddymn Aug-26-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		g_MmsReadWin=NULL;//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		break;
	case MWM_SUSPEND:
		TRACE_EVENT("MWM_SUSPEND");
		//xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
		dspl_Enable(1);
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
		DAL_PostMessage(EMG4_PlayMode,EMG4_Type_NotUsed, EPlayModeStop,NULL);
		break;
	case MWM_RESUME:
		TRACE_EVENT("MWM_RESUME");
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
		DAL_PostMessage(EMG4_Refresh, EMG4_Type_NotUsed, 0, 0);
		break;
	default:
	    break;
	}
}

/*******************************************************************************

 $Function:    	    extractEMSObjects

 $Description:	    To extract user defined objects in EMS
                         xrashmic 7 Dec, 2004 MMI-SPR-23965

 $Returns:	    none

 $Arguments:	    none
*******************************************************************************/
void extractEMSObjects(void)
{
    ESTATUS status;
    attachmentInEMS=0;
    EV_GetExtractableList(EAllMessage, &apExtractableInMessage);
    if(apExtractableInMessage.NumOfAttachments)
    {
        EV_ReadExtractableItem(&apExtractableInMessage.pAttachmentsInMessage[attachmentInEMS],&appObj);
        status = M4_StoreExtractedObject((char *)appObj->objData.pByteData, appObj->lObjectDataSize, appObj->contentType);
    }
    else 
    {
        apExtractableInMessage.omh.freeFunc(&apExtractableInMessage);
        //xrashmic 08 Feb, 2005 MMI-SPR-27853
        //Added few more parameters for this function   
        information_dialog(TxtNoObjects, TxtExtractable, NULL,NULL, TxtNull, TxtSoftBack, 0, KEY_RIGHT, NULL); 
    }   
}
/*******************************************************************************

 $Function:    	MMSBox_Read_kbd_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:		execution status

 $Arguments:	e - event id
 				k - keyboard info
*******************************************************************************/

int MMSBox_Read_kbd_cb (MfwEvt e, MfwKbd *k)
    /* SmsRead_R_OPT keyboard event handler */
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    TRACE_FUNCTION ("MMSBox_Read_kbd_cb()");

    if (e & KEY_LONG)
	{
	    switch (k->code)
		{
		case KCD_HUP: /* back to previous menu */
			MMI_DestoryWindow(win);
		    break;
            case  KCD_MNUUP:
                DAL_PostMessage(EVT_StartOfMessage, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNUDOWN:
                 DAL_PostMessage(EVT_EndOfMessage, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNULEFT:
                 DAL_PostMessage(EVT_StartOfLine, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNURIGHT:
                 DAL_PostMessage(EVT_EndOfLine, EMG4_Type_NotUsed, 0, NULL);
                 break;
		case KCD_RIGHT: /* Power Down */
		    return MFW_EVENT_REJECTED; /* handled by idle */
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    else
	{
	    switch (k->code)
		{
		case KCD_MNUUP: /* highlight previous entry */
		   //x0012849 Feb-03-2005 MMI-SPR-28224
		   //send scrollUp Event instead of cursorup
                   DAL_PostMessage(EMG4_ScrollUp,EMG4_Type_NotUsed,0,NULL);                		 			
                   break;
             case KCD_MNUDOWN:
		   //x0012849 Feb-03-2005 MMI-SPR-28224 	
		   //send scroDown Event instead of cursordown
		   DAL_PostMessage(EMG4_ScrollDown,EMG4_Type_NotUsed,0,NULL);		
                 break;
             case KCD_MNULEFT:
                 DAL_PostMessage(EMG4_CursorLeft, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNURIGHT:
                 DAL_PostMessage(EMG4_CursorRight, EMG4_Type_NotUsed, 0, NULL);
		    break;
		case KCD_MNUSELECT:
                break;
		case KCD_LEFT: /* activate this entry */
                        // xrashmic 7 Dec, 2004 MMI-SPR-23965
                        // Allows the user to extract objects in the EMS message. For extracting the objects,  
                        // the editor has to be initialized.
                        if(g_pMessageHeaderList->ppList[g_currentMessage].type==EMtSms)
                            extractEMSObjects();
		    break;
		case KCD_HUP: /* back to previous menu */
		case KCD_RIGHT: /* back to previous menu */
			MMI_DestoryWindow(win);
		    break;
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    return MFW_EVENT_CONSUMED;
}

/**/

/*******************************************************************************

 $Function:    	MMSBox_Read_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:		mfw window handler 

 $Arguments:	parent_window - Parent window handler
 				menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND MMSBox_Read_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSBox_Read_start()");
	//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
	g_MmsReadWin= MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)MMSBox_Read_exec_cb,(void*)menuAttr,(T_MFW_CB)MMSBox_Read_kbd_cb,0,0);

	return g_MmsReadWin;
}



/*******************************************************************************

 $Function:    	MMS_ConvertStringToUcs2

 $Description:	converting string to ucs2
 
 $Returns:		

 $Arguments:	
 				
 
*******************************************************************************/
UCS2 * MMS_ConvertStringToUcs2 (const MByte * const p8BitString,
                                           const MUint uLength,
                                           UCS2        * pUcs2String)
{
    if ((UCS2 *) NULL == pUcs2String)
    {
        pUcs2String = (UCS2 *)MM_MALLOC(sizeof(UCS2) * (1 + uLength));
    }

    if ((UCS2 *)NULL != pUcs2String)
    {
        register MUint uIndex;
        for (uIndex = 0; uIndex < uLength; ++uIndex)
        {
            pUcs2String[uIndex] = (UCS2)p8BitString[uIndex];
        }
        pUcs2String[uIndex] = NULLCHAR;
    }

    return pUcs2String;
}

//xrashmic 22 Sep, 2004 MMI-SPR-25032
// To play the buzzer when there are sound objects in EMS message
//Apr 05, 2005    REF: ENH 29994 xdeepadh
//To Play the default midi file when there are sound objects in EMS message.
void playBuzzerForEMS(void)
{

#ifdef FF_MIDI_RINGER  
	T_AS_PLAYER_TYPE player_type;
#ifdef FF_MIDI_LOAD_FROM_MEM
	T_MELODY melody_data;
#else
	char* midi_file;

#endif
//Nov 02, 2005    REF:ER OMAPS00039044  xdeepadh
#ifdef FF_MIDI_LOAD_FROM_MEM
	melody_data=sounds_midi_return_memory_location(0);
	player_type=mfw_ringer_deduce_player_type(melody_data.melody_name);
	mfw_player_start_memory(player_type,(UINT32*)melody_data.melody,melody_data.melody_size,AS_VOLUME_MEDIUM,FALSE,sounds_midi_player_start_cb);
#else
	midi_file=sounds_midi_return_file_name(0);
	player_type=mfw_ringer_deduce_player_type(midi_file);
	mfw_player_start_file(player_type,midi_file,AS_VOLUME_MEDIUM,FALSE,sounds_midi_player_start_cb);
#endif 		
#else
    UBYTE currentVoiceTone; 
    currentVoiceTone = getcurrentVoiceTone();
    audio_PlaySoundID( AUDIO_BUZZER, currentVoiceTone, 200, AUDIO_PLAY_ONCE );
#endif
}

//CRR 25270 & CRR 25268: 13 Oct 2004 - xpradipg
/*******************************************************************************

 $Function:    	MMS_Is_Unread_Msgs_Inbox

 $Description:	Lists out all the messages in the inbox and returns true if the status of one of the 
                     message is not set to read = true
  $Returns:		

 $Arguments:	
 				
*******************************************************************************/

int MMS_Is_Unread_Msgs_Inbox(void)
{
    //xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
    //Inbox listing params were changed in MMI-SPR-29887
    MM_LIST_PARAM listParams = MM_LIST_INBOX|MM_LIST_NOT_RETRIEVED;
    ESTATUS eStatus=0;
    int i;
	//xrashmic 29 Nov, 2005 MMI-SPR-OMAPS00050170
	//g_pMessageHeaderList will be populated again, hence need to release the memory already allocated to it
	if(g_pMessageHeaderList != NULL) 
		M4_FreeListFolderMemory();
	eStatus = DAL_ListMessagesByParam(&g_pMessageHeaderList, listParams);
    for(i=0;i<g_pMessageHeaderList->size;i++)
     {   if(g_pMessageHeaderList->ppList[i].read == FALSE)
            return TRUE;
      }
    return FALSE;
}
#undef MMI_MMSBOX_C

