
/*******************************************************************************

                	TI (Shanghai)

********************************************************************************                                                                              

 This software product is the property of TI (Shanghai) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	TISHMMS Project                                                      
 $Project code:	BMI (6349)                                                           
 $Module:    	MMS
 $File:            MmiEMSCreate.c
 $Revision:    	1.0                                                       
                                                                              
 $Author:    	Pinghua create (pinghua-zhang@ti.com )                                                         
 $Date:            26/08/03                                                     
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides definitions of the types and
    constants which are shared across the MMS
    application modules.
   
********************************************************************************
 $History: MmiMMSCreate.h

    xrashmic 08 Feb, 2005 MMI-SPR-27853
    Added more parameters to the information_dialog function
       
    MMI-SPR-27384 Dec-16-2004 - xreddymn
    Modifications for EMS inbox presentation

    xrashmic 9 Dec, 2004 MMI-SPR-27385
    Description: No response on selecting the EMS preview option
    Solution: Removed the EMS preview option, since the editor itself acts as preview.

    xrashmic 7 Dec, 2004 MMI-SPR-23965
    Description: Not able to extract the objects in EMS message
    Solution: Extract and store the objects in the Object Manager

    MMI-SPR-25278: Nov-29-2004 - xreddymn
    Implemented FFS limits for MMS/EMS storage

    CRR: 25302 - xpradipg 10 Nov 2004
    Description: Should be able to select the number fro the phonebook while
    sending MMS/EMS.
    Solution: The new feature to select the number from phonebook while sending
    MMS/EMS is added
    
    CRR: 25329 - xpradipg 27 Oct 2004
    Description: Delete option in EMS create does not work
    Solution: the option is removed since a Softkey is provided in the compose 
    screen, that can be used to delete objects directly.
    
    MMI-SPR-25273: Oct-14-2004 - xreddymn
    Description: EMS forward not working
    Solution: Added changes to implement the EMS forward feature

    CRR: 25291 - xrashmic 14 Oct 2004
    Description: The sent EMS is stored in unsent folder.
    Solution: The Outbox has been removed, instead we now have Sent folder for the sent EMS 

    CRR: 24741 - xpradipg 17 Sept 2004
    Description: Default values to be removed in text editor of MMS and EMS
    Solution: The buffer assigned to the text editor is reset.
    
    MMI-SPR-24735: Sep-16-2004 - xreddymn
    Added changes to reduce flickering of EMS editor screen when the user is
    deleting or navigating

    xrashmic 13 Sep, 2004 MMI-SPR-24744
    Description: No indication of the EMS sent. Also after sending EMS, the option 
    screen is displayed.
    Solution: Implemented the indication of EMS sent screen. 

    MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): Aug-17-2004 - xreddymn
    Keep track of MMS/EMS display

    CRR: 23942 - xpradipg 26 Aug 2004
    Description: Default values to be removed in text editor of MMS and EMS
    Solution: The buffer assigned to the text editor is reset.
    
    CRR: 23942 - xpradipg 26 Aug 2004
    Description: Default values to be removed in number editor of MMS and EMS
    Solution: The strcpy() of the hardcoded numbers to the editor buffer are commented
    
    Bug Id 23 : 		16 Aug, 2004 - xpradipg  
    Description:Remove insert slide form options menu 
    Solution: removed the insert slide item from the menu item array

	17/01/04		Replace mfw edit with AUI edit.	
	26/08/03	    	Original TI(Shanghai) BMI version.    
       
 $End

*******************************************************************************/
#define MMI_MMSCREATE_C

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
//#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_smsi.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"

#include "psa_util.h"

#include "dspl.h"
// #include "unicode_types.h"

#include "MmiMain.h"
#include "MmiDummy.h"
//#include "MmiLists.h"
#include "MmiMmi.h"
#include "mmiCall.h"//GW 29/11/01 for 'callNumber'

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"

#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else /* NEW_EDITOR */
#ifdef EASY_TEXT_ENABLED
#include "MmiLatinPredText.h"
#endif /* EASY_TEXT_ENABLED */
#include "MmiEditor.h"
#endif /* NEW_EDITOR */

#include "MmiBookShared.h" // MZ 
#include "mmimmsmenu.h"
#include "mmiemscreate.h"    //  pinghua modify 
#include "mmimmscreate.h" 
#include "mmimmsom.h"
#include "mmiwindow.h"
#include "mfw_ffs.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "aci_cmh.h"    //GW 29/11/01 added for types in aci_fd.h
#include "aci_fd.h"        //GW 29/11/01 added for types in 'cmh.h'
#include "cmh.h"         //GW 29/11/01 added for types in 'cmh_phb.h'
#include "cmh_phb.h"    //GW 29/11/01 added for cmhPHB_getAdrStr

#include "mmiColours.h"


// ronaldc 8-5

#include "mg4def.h"
#include "evtdefs.h"
#include "mg4stu.h"
#include "Mg4Dal.h"
#include "mg4devif.h"
#include "dalevt.h"
#include "evif.h"
#include "mg4str.h"
#include "mmif.h"
#include "mg4mem.h"

#include "AUIWapext.h"
#include "ATBData.h"
#include "dspl.h" //    xrashmic 13 Sep, 2004 MMI-SPR-24744

// xreddymn Dec-16-2004 MMI-SPR-27384
#include "Mfw_td.h"

 UCS2 ems_g_insertString[128] = {'t','e','s','t',0};
 MSafeString ems_g_safeString;

 UINT32 gEmsMsgId = MM_INVALID_MESSAGE_ID;

// xreddymn Dec-16-2004 MMI-SPR-27384
MM_S_MESSAGE_HEADER *EmsMsgHeader=NULL;
EVT_STRUCT     	g_EMS_event_struct;
extern T_MFW_TIME current_time;
extern T_MFW_DATE current_date;

//GW 29/11/01 - added header file - removed extern void callNumber(UBYTE* number);
MfwWin* getWinData( MfwHnd win);

extern void M4_DebugMessage(unsigned long para);

//xreddymn Aug-26-2004
extern UINT8 gucMmsTitleBarHeight;

//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): To keep track of MMS display
extern BOOL g_M4_display_active;

//xreddymn Oct-14-2004 MMI-SPR-25273: Used to maintain the state when forwarding an EMS message
BOOL gEmsForward=FALSE;

//xreddymn Nov-26-2004
extern T_MFW_HND g_inSaveModeWin;
extern BOOL g_inSaveMode;
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback);




/*********************************************************************

                 DYNAMIC MENU WINDOW. DECLARATION

**********************************************************************/


static int EMSCreate_OPTexeSend(MfwMnu* m, MfwMnuItem* i);
//xrashmic 7 Dec, 2004 MMI-SPR-23965
static int EMSCreate_OPTexeInsPreDefPicture(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeInsPicture(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeInsPreDefSound(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeInsSound(MfwMnu* m, MfwMnuItem* i);

static int EMSCreate_OPTexeInsText(MfwMnu* m, MfwMnuItem* i);
//static int MMSCreate_OPTexeInsSlide(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeDelPicture(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeDelSound(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeDelText(MfwMnu* m, MfwMnuItem* i);
static int EMSCreate_OPTexeSave(MfwMnu* m, MfwMnuItem* i);

static MfwMnuItem EMSCreate_OPTDeleteItems [] =
{
    {0,0,0,(char *)TxtMMSDeletePicture,0,(MenuFunc)EMSCreate_OPTexeDelPicture,item_flag_none},
    {0,0,0,(char *)TxtMMSDeleteSound,0,(MenuFunc)EMSCreate_OPTexeDelSound,item_flag_none},
    {0,0,0,(char *)TxtMMSDeleteText,0,(MenuFunc)EMSCreate_OPTexeDelText,item_flag_none}
};
static MfwMnuAttr MMSCreate_OPTDeleteAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    EMSCreate_OPTDeleteItems,                      /* with these items         */
    sizeof(EMSCreate_OPTDeleteItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE
};

static MfwMnuItem EMSCreate_OPTItems [] =
{
    {0,0,0,(char *)TxtSend,0,(MenuFunc)EMSCreate_OPTexeSend,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertPrePicture,0,(MenuFunc)EMSCreate_OPTexeInsPreDefPicture,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertPicture,0,(MenuFunc)EMSCreate_OPTexeInsPicture,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertPreSound,0,(MenuFunc)EMSCreate_OPTexeInsPreDefSound,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertSound,0,(MenuFunc)EMSCreate_OPTexeInsSound,item_flag_none},
    {0,0,0,(char *)TxtMMSInsertText,0,(MenuFunc)EMSCreate_OPTexeInsText,item_flag_none},
    //Bug Id 23 : 		16 Aug, 2004 - xpradipg  
    //Description:Remove insert slide form options menu 
//    {0,0,0,(char *)TxtMMSInsertSlide,0,(MenuFunc)EMSCreate_OPTexeInsSlide,item_flag_none},
    {0,0,0,(char *)TxtSave,0,(MenuFunc)EMSCreate_OPTexeSave,item_flag_none},
    //CRR: 25329 - xpradipg 25 Oct 2004
//    {0,0,0,(char *)TxtMMSDelete,&MMSCreate_OPTDeleteAttrib,0,item_flag_none},

    //xrashmic 9 Dec, 2004 MMI-SPR-27385
    //Removed the EMS preview option, since the editor itself acts as preview.
  //  {0,0,0,(char *)TxtMMSPreview,0,(MenuFunc)NULL,item_flag_none}
};

static MfwMnuAttr EMSCreate_OPTAttrib =
{
    &SmsRead_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    EMSCreate_OPTItems,                      /* with these items         */
    sizeof(EMSCreate_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, MNUATTRSPARE

};

/* 1. User selects 'Preview' from user menu (MMI) */
/* 2. MMI calls action_ResumeEditor() to resume the magic4 client and suspends the menu system */
void action_EMS_ResumeEditor()
{
	/* resume magic4 editor */
	DAL_PostMessage(EMG4_Resume,EMG4_Type_NotUsed,0,NULL);
	/* if necessary, add code here to suspend display of the menu system */
}
 

/* 3. After action_ResumeEditor has been completed, MMI then calls action_PreviewMessage() to preview the message currently in the magic4 editor */



void action_EMS_SuspendEditor()
{
	/* suspend magic4 editor */
	DAL_PostMessage(EMG4_Suspend,EMG4_Type_NotUsed,0,NULL);
	/* if necessary, add code here to resume display of the menu system */
}

/*******************************************************************************

 $Function:    	set_MMS_current_time_stamp

 $Description:  Sets current time in the time stamp structure

 $Returns:    	none

 $Arguments:    t - Time stamp to be updated by this function

 $author  :     xreddymn
 
*******************************************************************************/

void set_MMS_current_time_stamp(MM_S_TIME_STAMP *t)
{
	t->day=current_date.day;
	t->month=current_date.month;
	t->year=current_date.year;
	t->hour=current_time.hour;
	t->min=current_time.minute;
	t->sec=current_time.second;
}

/*******************************************************************************

 $Function:    	EMS_update_header_handler
 
 $Description:  Callback function for DAL_ModifyMessageParamsAsync
 
 $Returns:    	none
 
 $Arguments:    As specified by M4
 
 $author  :     xreddymn
                Currently, this is a dummy function
 
*******************************************************************************/

ESTATUS EMS_update_header_handler(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE EvtHandle)
{

}

EVT_STRUCT      CreatEmsDocumentevtHandle;

ESTATUS Handler_EMS_CreateDocument(EVENT_ID aeId, EVENT_TYPE aeType, MESSAGE_PARAM ampParam, EVT_HANDLE evtHandle)
{
    //xmzhou_trace_string_value("Handler_EMS_CreateDocument aeId = ", aeId);
    
    switch(aeId)
 	{
        case EMG4_FileOpDone:

        //xmzhou_trace_string_value("gEmsMsgId = ampParam = ", ampParam);
        
        gEmsMsgId = (UINT32)ampParam;

		  if(g_inSaveMode==TRUE)
        {
			g_inSaveMode=FALSE;
			// xreddymn Nov-26-2004 MMI-SPR-25278
			winDelete(g_inSaveModeWin);
                     //xrashmic 08 Feb, 2005 MMI-SPR-27853
                     //Added few more parameters for this function       
			information_dialog(TxtSaved,TxtNull, NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
			/* xreddymn Dec-15-2004 MMI-SPR-27384
			 * Update EMS message header with the current time stamp
			 */
			{
				ESTATUS eResult= DAL_RetrieveMessageHeader(gEmsMsgId,&EmsMsgHeader);
				if(eResult==ENoError)
				{
					set_MMS_current_time_stamp(&EmsMsgHeader->timestamp);
					g_EMS_event_struct.handler = EMS_update_header_handler;
					g_EMS_event_struct.parentEvtHandle = NULL;
					g_EMS_event_struct.pData = NULL;
					g_EMS_event_struct.userFlag = 0;
					DAL_ModifyMessageParamsAsync((EVT_HANDLE)&g_EMS_event_struct,gEmsMsgId,EmsMsgHeader);
				}
			}
        }
        break;

        // xrashmic Nov-17-2004: Changes for FFS error handling
        case EMG4_OpError:
        {
            MDword reason;
            reason = (ampParam & 0x3FFF);
            // xreddymn Nov-27-2004 MMI-SPR-25278
            switch(reason)
			{
				case EFileOpFailed:
            	winDelete(g_inSaveModeWin);
              //xrashmic 08 Feb, 2005 MMI-SPR-27853
              //Added few more parameters for this function       
            	information_dialog(TxtFailed,TxtFatalError,NULL,NULL, TxtNull,TxtSoftBack,FOREVER,KEY_CLEAR|KEY_RIGHT|KEY_HUP,NULL);
            	break;
            }
        }
        break;
    }
    
    return ENoError;
}

/*******************************************************************************

 $Function:    	EMSCreate_exec_cb

 $Description:	Exec callback function of the MMS Create window 
 
 $Returns:    	none

 $Arguments:	win - window handler
             	event - mfw event
             	parameter - optional data.
 $author  :  pinghua for EMS modify !!
 
*******************************************************************************/
void EMSCreate_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
    ESTATUS eStatus;
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
    
    TRACE_FUNCTION ("EMSCreate_exec_cb()");
	
	//xmzhou_trace_string_value("EMSCreate_exec_cb called", event);

    switch (event)
    {
	case MWM_CREATE:
		/* initialization of administrative data */
		TRACE_EVENT("MWM_CREATE");

		// xreddymn Oct-14-2004 MMI-SPR-25273: Open an existing EMS message to forward
		if(gEmsForward==TRUE)
		{
			CreatEmsDocumentevtHandle.handler = Handler_EMS_CreateDocument;
			CreatEmsDocumentevtHandle.parentEvtHandle = NULL;
			CreatEmsDocumentevtHandle.pData = NULL;
			CreatEmsDocumentevtHandle.userFlag = 0;

			eStatus = EV_OpenDocument((EVT_HANDLE) &CreatEmsDocumentevtHandle, (MM_MESSAGE_ID) gEmsMsgId, (MM_MESSAGE_ID) MM_INVALID_MESSAGE_ID);
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
		}
		else
		{
            //Creat a document for one EMS
            CreatEmsDocumentevtHandle.handler = Handler_EMS_CreateDocument;
            CreatEmsDocumentevtHandle.parentEvtHandle = NULL;
            CreatEmsDocumentevtHandle.pData = NULL;
            CreatEmsDocumentevtHandle.userFlag = 0;
            
            eStatus = EV_CreateDocument((EVT_HANDLE) &CreatEmsDocumentevtHandle,  EMtSms, (MM_MESSAGE_ID) MM_INVALID_MESSAGE_ID);
            if (eStatus!=ENoError)
            {
                //xmzhou_trace_string_value("EMSCreate_exec_cb EV_CreateDocument return error num = ",  eStatus);
            }
            else
             {
                //xmzhou_trace_string("EMSCreate_exec_cb EV_CreateDocument return ENoError");
                gEmsMsgId = MM_INVALID_MESSAGE_ID;
             }
		}
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		break;
		
	case MWM_ONDRAW:
		TRACE_EVENT("MWM_ONDRAW");
		dspl_Enable(0);
#if(0)
		dspl_ClearAll();
		dspl_TextOut(32, 0, DSPL_TXTATTR_HLIGHT,"Create EMS");
#else
		// xreddymn Aug-26-2004: Modified Title display
		{
			unsigned short width, height;
			DeviceGetScreenMetrics(&width,&height);
			dspl_SetBgdColour(COL_White);
			dspl_Clear(0, gucMmsTitleBarHeight, width-1, gucMmsTitleBarHeight+height-1);
			resources_setTitleColour(COLOUR_EDITOR);
			dspl_Clear(0, 0, width-1, gucMmsTitleBarHeight-1);
			dspl_TextOut(1, 0, DSPL_TXTATTR_HLIGHT,"Create EMS");
		}
#endif
		//xmzhou_trace_string("action_EMS_ResumeEditor in EMSCreate_exec_cb called");
		action_EMS_ResumeEditor();
		displaySoftKeys(TxtSoftOptions,TxtDelete);
		dspl_Enable(1);
		break;

	// xreddymn Aug-09-2004
	case MWM_SUSPEND:
		TRACE_EVENT("MWM_SUSPEND");
		//xreddymn Sep-16-2004 MMI-SPR-24735
		dspl_Enable(1);
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		action_EMS_SuspendEditor();
		break;

	// xreddymn Aug-27-2004 
	case MWM_RESUME:
		TRACE_EVENT("MWM_RESUME");
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): M4 client will now use the display
		g_M4_display_active=TRUE;
		//xreddymn Sep-16-2004 MMI-SPR-24735: Removed editor resume and refresh
		//action_EMS_ResumeEditor();
		//DAL_PostMessage(EMG4_Refresh, EMG4_Type_NotUsed, 0, 0);
		break;

	case MWM_DESTORY:
		TRACE_EVENT("MWM_DESTROY");
		//xreddymn Sep-16-2004: Changes related to MMI-SPR-24735
		dspl_Enable(1);
        //xmzhou_trace_string("EMSCreate_exec_cb EMG4_Exit be posted");
		DAL_PostMessage(EMG4_Exit, EMG4_Type_NotUsed, 0, 0);
		//xreddymn Aug-27-2004 MMI-SPR-23926 (TII_MMS12) and  MMI-SPR-24115 (TII_MMS55): BMI will now use the display
		g_M4_display_active=FALSE;
		break;
	default:
        break;
    }
}




/*******************************************************************************

 $Function:    	MMSCreate_kbd_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:    	execution status

 $Arguments:	e - event id
             	k - keyboard info
 $Author :   pignhua add these code for EMS  ()
*******************************************************************************/

static int EMSCreate_kbd_cb (MfwEvt e, MfwKbd *k)
    /* SmsRead_R_OPT keyboard event handler */
{
    T_MFW_HND    win  = mfwParent(mfw_header());


    TRACE_FUNCTION ("MMSCreate_kbd_cb()");
	//xreddymn Sep-16-2004 MMI-SPR-24735: Reduce screen flickering in EMS editor when user presses keys
	dspl_Enable(0);
    if (e & KEY_LONG)
    {
        switch (k->code)
        {
    	case KCD_HUP: /* back to previous menu */
        	MMI_DestoryWindow(win);
            	break;
    	case KCD_RIGHT: /* delete one */
         DAL_PostMessage(EMG4_BackSpace, EMG4_Type_NotUsed, 0, NULL);
            break ; 
       case  KCD_MNUUP:
           DAL_PostMessage(EVT_StartOfMessage, EMG4_Type_NotUsed, 0, NULL);
            break;
        case KCD_MNUDOWN:
            DAL_PostMessage(EVT_EndOfMessage, EMG4_Type_NotUsed, 0, NULL);
            break;
        case KCD_MNULEFT:
            DAL_PostMessage(EVT_StartOfLine, EMG4_Type_NotUsed, 0, NULL);
            break;
        case KCD_MNURIGHT:
            DAL_PostMessage(EVT_EndOfLine, EMG4_Type_NotUsed, 0, NULL);
            break;
    	default: /* no response to all other keys */
            return MFW_EVENT_CONSUMED;
        }
    }
    else
    {
        switch (k->code)
        {
    	case KCD_MNUSELECT:
    	case KCD_LEFT:
        	EMSCreate_OPT_start(win,0);
            	break;
    	case KCD_HUP: /* back to previous menu */
        	MMI_DestoryWindow(win);
            break;
             case KCD_RIGHT: /* delete one */
                DAL_PostMessage(EMG4_BackSpace, EMG4_Type_NotUsed, 0, NULL);
                 break ; 
            case  KCD_MNUUP:
                DAL_PostMessage(EVT_CursorUp, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNUDOWN:
                 DAL_PostMessage(EVT_CursorDown, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNULEFT:
                 DAL_PostMessage(EMG4_CursorLeft, EMG4_Type_NotUsed, 0, NULL);
                 break;
             case KCD_MNURIGHT:
                 DAL_PostMessage(EMG4_CursorRight, EMG4_Type_NotUsed, 0, NULL);
                 break;
    	default: /* no response to all other keys */
            return MFW_EVENT_CONSUMED;
        }
    }
    return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMSCreate_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:    	mfw window handler 

 $Arguments:	parent_window - Parent window handler
             	menuAttr	  - Menu attributes.
 
*******************************************************************************/
T_MFW_HND EMSCreate_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("MMSCreate_start()");
	return  MMI_CreateWindow(parent_window, (T_DIALOG_FUNC) EMSCreate_exec_cb, (void*)menuAttr,(MfwCb)EMSCreate_kbd_cb, 0,0);
}


#define MMS_SEND_SUBJUCT_NUMBER

static T_MFW_HND	    editor=NULL;
//CRR: 25302 - xpradipg 10 Nov 2004
//Global to hold the number editor handle
static T_MFW_HND	    number_edit=NULL;
static char text[MAX_EMS_TEXT_LEN];
char EmsNumber[MAX_PHB_NUM_LEN];
static char topic[MAX_EMS_TOPIC_LEN]="\0";


void Free_MMISafeString(void * paData)
{
    MSafeString *pSafeString = (MSafeString *)paData;
    if (pSafeString!= NULL)
    {        
        mfwFree((U8 *)(pSafeString->pString), pSafeString->size);
        pSafeString->pString = NULL;
    }
}


UINT32 EMS_CaculateByteSize(MDword  rawDataSize, MM_E_SMS_ENCODING encoding)
{
    UINT32 ulBitLength;
    UINT32 ulByteSize;
    
    switch (encoding)
    {   
        case EEncodingGSM7Bit:
        case EEncoding7BitASCII:
        {
            ulBitLength = rawDataSize * 7;
            
            if ((ulBitLength & 0x07) == 0)
            {
                ulByteSize = ulBitLength/8;
            }
            else
            {
                ulByteSize = ulBitLength/8 + 1;
            }
            break;
        }
        case EEncoding8BitASCII:
        case EEncodingGSM8Bit:
        {
            ulByteSize =  rawDataSize;
            break;
        }
        
        case EEncodingUCS2:
        case EEncodingUNICODE:
        {
            ulByteSize = rawDataSize;
            break;
        }
        default:
        {
            //xmzhou_trace_string_value("EMS_CaculateByteSize error case encoding = ", encoding);
            ulByteSize = 0;
            break;
        }
    }/* end switch (encoding) */

    return ulByteSize;
}/* end of EMS_CaculateByteSize */

LOCAL MM_S_MESSAGE *EmsMesg;
LOCAL UINT16 ulSendIndex;

//number
LOCAL void ems_submit_error_proc (T_ACI_AT_CMD cmdId, T_ACI_CMS_ERR err,
                                   T_EXT_CMS_ERROR *ce)
{
	//CRR: 24741 - xpradipg 17 Sept 2004
	//The error message is displayed
	T_MFW_HND win = mfwParent(mfw_header());
	T_DISPLAY_DATA displayInfo;
	
	TRACE_FUNCTION("ems_submit_error_proc called");
	dlg_initDisplayData_TextStr(&displayInfo, TxtSoftOK,TxtNull, "EMS Send", "Failed", COLOUR_STATUS);
	dlg_initDisplayData_events(&displayInfo, (T_VOID_FUNC)NULL, FOREVER, KEY_LEFT |KEY_HUP);
	info_dialog(win,&displayInfo);
	EmsMesg->memHdr.freeFunc(EmsMesg);
}


void ems_prepare8bitBufferforACIfrom7bit(MByte* textBuffer, UBYTE NumTxt, UBYTE OriginalOffest, UBYTE* SmsTextOut)
{
	UBYTE ByteOne;
	U16     ByteTwo;
	U16     ulConcated2Bytes;
	UBYTE TextBufferOffset = 0;
	UBYTE ByteOffset = 0;
	UBYTE BitOffset;
	UINT16 i;

	if ((textBuffer == NULL) || (SmsTextOut == NULL))
	{
		return;
	}
	
	BitOffset = OriginalOffest;

	for (i = 0; i < NumTxt; i++)
	{
		ByteOne = textBuffer[TextBufferOffset];
		ByteTwo = textBuffer[TextBufferOffset + 1];
		
		ulConcated2Bytes = ByteOne;
		ulConcated2Bytes = ulConcated2Bytes | ((ByteTwo <<8) & 0xFF00);
		
		SmsTextOut[ByteOffset] = 0;

		if (BitOffset == 0)
		{
			SmsTextOut[ByteOffset] = 0x7f & ByteOne;
			BitOffset = 7;
			//TextBufferOffset = TextBufferOffset;//do not change
		}
		else if (BitOffset == 1)
		{
			SmsTextOut[ByteOffset] = 0x7f & (ByteOne >> BitOffset);
			BitOffset = 0;
			TextBufferOffset++;
		}
		else
		{
			SmsTextOut[ByteOffset] = (UBYTE)(0x7f & (ulConcated2Bytes >> BitOffset));
			BitOffset --;
			TextBufferOffset++;
		}
		
		ByteOffset++;
	}/* end of for */

	return;
}
void ems_submit(UBYTE mr, UBYTE numSeg)
{
	T_ACI_TOA		  toa;
	T_ACI_TOA		  tosca;
	SHORT			 rp;

	T_ACI_UDH_DATA udh;
	T_ACI_SM_DATA tar_data;

	T_MFW_SMS_INFO	  sms_parameter;
	
	MByte * rawData;
       MDword  rawDataSize;
       UINT32 BytesSize;
	   UINT32 ulTextByteLengh;
	   MM_E_SMS_ENCODING M4Encoding;

	   T_ACI_RETURN AciReturn;

	   UBYTE OriginalOffest;

	//xmzhou_trace_string_value("ems_submit called ulSendIndex = ", ulSendIndex);
	TRACE_FUNCTION("ems_submit called");
	
	if (ulSendIndex >= EmsMesg->pBody->numMessageParts)
	{
		/* xreddymn Dec-15-2004 MMI-SPR-27384
		 * Update EMS message header with the current time stamp and Destination Address
		 */
		{
			ESTATUS eResult= DAL_RetrieveMessageHeader(gEmsMsgId,&EmsMsgHeader);
			if(eResult==ENoError)
			{
				UCS2 temp_string[128];
				//CRR: 25291 - xrashmic 14 Oct 2004
				//Once the EMS is sent successfully, move this EMS into Sent folder.
				EmsMsgHeader->location=EMlSent;
				MMS_Convert8BitStringToUcs2((MByte*)EmsNumber,strlen(EmsNumber),(UCS2*)temp_string);
				EmsMsgHeader->messageTypeHeader.smsHeader.pszAddress=temp_string;
				set_MMS_current_time_stamp(&EmsMsgHeader->timestamp);
				g_EMS_event_struct.handler = EMS_update_header_handler;
				g_EMS_event_struct.parentEvtHandle = NULL;
				g_EMS_event_struct.pData = NULL;
				g_EMS_event_struct.userFlag = 0;
				DAL_ModifyMessageParamsAsync((EVT_HANDLE)&g_EMS_event_struct,gEmsMsgId,EmsMsgHeader);
			}
		}
		//xmzhou_trace_string("EMS post success!");
		//xrashmic 13 Sep, 2004 MMI-SPR-24744
		//Displaying a dialog after all the parts of EMS are sent. 
		ems_dialog(TxtEMS,TxtSent,NULL,TxtSoftBack,FOREVER);
		EmsMesg->memHdr.freeFunc(EmsMesg);
		return;
	}
	
	rp = -1;	/* reply path = default *//*for MFW_SMS_SUBMIT*/
	
	toa.ton = phb_ncvtTon(NULL);
	toa.npi = NPI_IsdnTelephony;
	tosca.ton = phb_ncvtTon(NULL);
	tosca.npi = NPI_IsdnTelephony;
	
	SmsSend_get_config_data(&sms_parameter);
	
	if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingGSM7Bit) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncoding7BitASCII))
	{
		sms_parameter.dcs = MFW_DCS_7bits;

	}
	else if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingUCS2) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingUNICODE))
	{
		sms_parameter.dcs = MFW_DCS_UCS2;
	}
	else if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncoding8BitASCII) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingGSM8Bit))
	{
		sms_parameter.dcs = MFW_DCS_8bits;
	}
	else
	{
		//xmzhou_trace_string_value("EMS_RetriveSendMsg error encoding = ",  
		//	EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding);
		return;
	}
	
	rawData = EmsMesg->pBody->ppMessageParts[ulSendIndex]->pData;
	rawDataSize = EmsMesg->pBody->ppMessageParts[ulSendIndex]->size;
	M4Encoding = EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding;
	BytesSize = EMS_CaculateByteSize(rawDataSize, M4Encoding);
	
	if ( EmsMesg->pBody->ppMessageParts[ulSendIndex]->xData == 0x40 ) //EMS
	{
	   //xmzhou_trace_string_value("Call Send EMS, rawDataSize = ", rawDataSize);
	   //xmzhou_trace_n_bytes((char *) rawData, (UINT32) rawDataSize);
	   
	   udh.len = rawData[0];
	   memcpy(udh.data, &rawData[1], udh.len);
	   
	   //tar_data.len = BytesSize - udh.len - 1;
	   ulTextByteLengh = BytesSize - udh.len - 1;
	   
	   if ((M4Encoding == EEncodingGSM7Bit) ||(M4Encoding == EEncoding7BitASCII))
	   {
		tar_data.len = rawDataSize - (((udh.len + 1)*8 + 6) / 7);
		OriginalOffest = (rawDataSize-tar_data.len) * 7 -(udh.len + 1) * 8; //filing bit of sms
		
		//tar_data.data will be fit with 8bit buffer for ACI
		ems_prepare8bitBufferforACIfrom7bit(&rawData[udh.len+1], tar_data.len,  OriginalOffest, tar_data.data);
	   }
	   else if ((M4Encoding == EEncodingUCS2) ||(M4Encoding == EEncodingUNICODE))
	   {
	   	memcpy(tar_data.data, &rawData[udh.len+1], ulTextByteLengh);
	   	
		tar_data.data[ulTextByteLengh] = 0x00;
		tar_data.data[ulTextByteLengh + 1] = 0x00;
	   	tar_data.len = ulTextByteLengh + 2;
	   }
	   else
	   {
	   	memcpy(tar_data.data, &rawData[udh.len+1], ulTextByteLengh);
	   	tar_data.len = ulTextByteLengh;
	   }

	   
	   AciReturn = sAT_PlusCMGS_Gl(CMD_SRC_LCL, 	EmsNumber, NULL,  &tar_data, &udh, sms_parameter.sc_addr, NULL, rp, ems_submit, ems_submit_error_proc);
	   //AciReturn = sAT_PlusCMGS_Gl(CMD_SRC_LCL, 	EmsNumber, NULL,  &tar_data, NULL, sms_parameter.sc_addr, NULL, rp, ems_submit, ems_submit_error_proc);
	   if (AciReturn NEQ AT_EXCT)
	   {
		   //xmzhou_trace_string("ems_submit sAT_PlusCMGS_Gl fail!");
	   }
	}
	else//SMS
	{
		tar_data.len = rawDataSize;

		if ((M4Encoding == EEncodingGSM7Bit) ||(M4Encoding == EEncoding7BitASCII))
		{
		 tar_data.len = rawDataSize;
		 OriginalOffest = 0; //filing bit of sms is 0 for text only
		 
		 //tar_data.data will be fit with 8bit buffer for ACI
		 ems_prepare8bitBufferforACIfrom7bit(rawData, tar_data.len,  OriginalOffest, tar_data.data);
		}
		else
		{
		 memcpy(tar_data.data, rawData, ulTextByteLengh);
		 tar_data.len = rawDataSize;
		}
		
		AciReturn = sAT_PlusCMGS_Gl(CMD_SRC_LCL, EmsNumber,NULL, &tar_data, NULL, sms_parameter.sc_addr, NULL, rp, ems_submit, ems_submit_error_proc);
		if (AciReturn NEQ AT_EXCT)
		{
			//xmzhou_trace_string("ems_submit sAT_PlusCMGS_Gl for sms fail!");
		}
	}

	ulSendIndex++;

	return ;
}/* end of ems_submit */


void EMS_RetriveSendMsg(UINT32 MsgId)
{
	T_MFW_SMS_INFO	  sms_parameter;
	ESTATUS estatus;
	UBYTE mr;
	UBYTE numSeg;

    estatus = DAL_RetrieveMessageComplete(&EmsMesg, MsgId);

    if ( estatus != ENoError )
    {
        //xmzhou_trace_string("EMS_RetriveSendMsg estatus != ENoError then return");
        return;
    }
    
    if (EmsMesg->pBody->numMessageParts > 255)
    {
        //xmzhou_trace_string("EMS_RetriveSendMsg numMessageParts > 255 then return");
        return;
    }
	ulSendIndex = 0;
	
	SmsSend_get_config_data(&sms_parameter);
	
	if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingGSM7Bit) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncoding7BitASCII))
	{
		sms_parameter.dcs = MFW_DCS_7bits;
	}
	else if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingUCS2) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingUNICODE))
	{
		sms_parameter.dcs = MFW_DCS_UCS2;
	}
	else if ((EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncoding8BitASCII) ||
		(EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding == EEncodingGSM8Bit))
	{
		sms_parameter.dcs = MFW_DCS_8bits;
	}
	else
	{
		//xmzhou_trace_string_value("EMS_RetriveSendMsg error encoding = ",  
		//	EmsMesg->pHeader->messageTypeHeader.smsHeader.encoding);
		return;
	}
	SmsSend_set_dcs_number (&sms_parameter);
             
    ems_submit(mr, numSeg);
	
	return;
}
//CRR: 25302 - xpradipg 10 Nov 2004
/*******************************************************************************

 $Function:    	EmsSend_PHBK_exec_cb

 $Description:	Populates the text structure with the phone Number and sends 
                     an event to update the editor buffer
 
 $Returns:    	

 $Arguments:	
*******************************************************************************/
 void EmsSend_PHBK_exec_cb(T_MFW_HND win, USHORT event, void *parameter)
{
#ifdef NEW_EDITOR
	T_ATB_TEXT		text;	/* Used to insert phone numbers into editors */
#endif

	TRACE_FUNCTION ("EmsSend_PHBK_exec_cb()");

	switch (event)
	{
	/* SPR#1428 - SH - New Editor changes.  Insert phone number into editor */
#ifdef NEW_EDITOR
		case MMS_EMS_PHBK_NUMBER:		/* Service centre number */
			text.dcs = ATB_DCS_ASCII;
			text.len = strlen((char *)parameter);
			text.data = (UBYTE *)parameter;
			SEND_EVENT(number_edit, E_ED_INSERT, 0, (void *)&text);
			break;
#endif /* NEW_EDITOR */
			break;
		default:
			TRACE_EVENT("Err: Default");
			break;
	}
}



static void EMSCreate_SEND_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason)
{
	T_MFW_WIN	        * win_data = ((T_MFW_HDR *) win)->data;
	T_DISPLAY_DATA display_info;
    char temp[100];
        T_MFW_HND parent_win, parent_parent_win;// xrashmic 13 Sep, 2004 MMI-SPR-24744
    
	TRACE_EVENT_P1("EMSCreate_SEND_edit_cb() %d", Identifier);


	switch (reason)
    {
	case INFO_KCD_LEFT:  // confirm (press LEFT soft key)
    	if (Identifier==E_MODE_TOPIC)
        { 
            // subject input 
        	TRACE_EVENT_P1("topic: %s",topic);
        	SEND_EVENT(win,E_MODE_NUMBER, 0, 0);
            // wait for getting number (below) and do it all together.
        }
        else if (Identifier==E_MODE_NUMBER)
        {
            // phone number input
        	TRACE_EVENT_P2("topic: %s, number: %s",topic,EmsNumber);
            
            //After phone number OK, retrive and send EMS
            if (gEmsMsgId != MM_INVALID_MESSAGE_ID)
            {
                EMS_RetriveSendMsg(gEmsMsgId);
		//xmzhou_trace_string("EMS_RetriveSendMsg return");
            }
            else
            {
                //xmzhou_trace_string("EMSCreate_SEND_edit_cb MM_INVALID_MESSAGE_ID error!!!");
            }
            // xrashmic 13 Sep, 2004 MMI-SPR-24744
            // Geting the Options and the Message preview screen.
            parent_win=    MMI_ParentWindow(win);
            parent_parent_win= MMI_ParentWindow(parent_win);

            MMI_DestoryWindow(win); //This deletes the number entry screen

            // xrashmic 13 Sep, 2004 MMI-SPR-24744
            // Deleting the Options and the Message preview screens.
            MMI_DestoryWindow(parent_win);
            MMI_DestoryWindow(parent_parent_win);
            //CRR: 25302 - xpradipg 10 Nov 2004
            //the number editor needs to be destroyed explicitly
            AUI_edit_Destroy(number_edit);
        }
        else
        {
        	TRACE_EVENT_P1("text: %s",text);
		ems_g_safeString.size=2*(strlen(text)+1);
              //ems_g_safeString.memHeader.freeFunc = DummyFreeFunc;
              ems_g_safeString.memHeader.freeFunc = Free_MMISafeString;
        
		MMS_ConvertStringToUcs2((const MByte *)(text), 
                                            strlen(text),
                                            ems_g_insertString);
		ems_g_safeString.pString = ems_g_insertString;
        	DAL_PostMessage(EMG4_InsertString, EMG4_Type_NotUsed, (MESSAGE_PARAM)&ems_g_safeString, 0);

        	MMI_DestoryWindow(win);
        }
    	break;
       //CRR: 25302 - xpradipg 10 Nov 2004
        //the alternate left softkey event is handled for the number entry screen        
       case INFO_KCD_ALTERNATELEFT:
	bookPhonebookStart(win, PhbkFromMms);
       break;
	case INFO_KCD_RIGHT:
	case INFO_KCD_HUP:
        //CRR: 25302 - xpradipg 10 Nov 2004
        //the number editor needs to be destroyed explicitly
        AUI_edit_Destroy(number_edit);
    	MMI_DestoryWindow(win);
    	break;
	default:
    	TRACE_EVENT("Err: Default");
    	break;
    }
}


/*******************************************************************************

 $Function:    	EMSCreate_SEND_exec_cb

 $Description:	Callback handler for events sent by the window itself
 
 $Returns:    	none

 $Arguments:	win - current window
             	event - event id
             	parameter - optional data.
*******************************************************************************/
//CRR: 25302 - xpradipg 10 Nov 2004
//added new parameter Identifier - optional - but helps decode the data
static void EMSCreate_SEND_exec_cb(T_MFW_HND win, USHORT event, USHORT Identifier,void *parameter)
{
	T_MFW_WIN      * win_data = ((T_MFW_HDR *) win)->data;
	T_AUI_EDITOR_DATA	editor_data;

	TRACE_FUNCTION ("EMSCreate_SEND_exec_cb()");
	//xmzhou_trace_string_value("EMSCreate_SEND_exec_cb called", event);

	switch (event)
	{
	case MWM_CREATE:
		break;
	case E_MODE_TOPIC:

		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, ZONE_FULL_SK_TITLE_SCROLL, COLOUR_EDITOR, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_TOPIC, TRUE, FOREVER, (T_AUI_EDIT_CB)EMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtTopics, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, NULL, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
        //void AUI_edit_SetBuffer(T_AUI_EDITOR_DATA *editor_data, UBYTE dcs, UBYTE *text, USHORT size)
        //void AUI_edit_SetBuffer(T_AUI_EDITOR_DATA *editor_data, UBYTE dcs, UBYTE *text, USHORT size);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII,(UBYTE*) topic, sizeof(topic));
		editor = AUI_edit_Start(win, &editor_data);

                        		
	    	break;
	case E_MODE_NUMBER:
	    	TRACE_EVENT("enter number");
		//CRR: 23942 - xpradipg 26 Aug 2004
		//comment the hardcoded string. This will display an empty number editor.
		//strcpy(EmsNumber,"01792910943");//"13816687053");//13801639314//01792910943
		//CRR: 25302 - xpradipg 10 Nov 2004
		//the changes are made to hold the alternate softkey and functionality
		//for the same
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, PHNO_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_NUMBER, FALSE, FOREVER, (T_AUI_EDIT_CB)EMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSend, TxtDelete, TxtSmsEnterNumber, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 1, TxtNames, TRUE, TxtSoftBack);
		//AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
		AUI_edit_SetMode(&editor_data,0, ED_CURSOR_UNDERLINE);
              memset(EmsNumber,'\0',sizeof(EmsNumber));
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE*)EmsNumber, sizeof(EmsNumber));
             	number_edit = AUI_edit_Start(win, &editor_data);
		
#if 0
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, PHNO_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, SMSSEND_ID_NBEDIT, FALSE, FOREVER, (T_AUI_EDIT_CB)SmsSend_NBEDIT_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSend, TxtDelete, TxtSmsEnterNumber, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 1, TxtNames, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data, 0, ED_CURSOR_UNDERLINE);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, parent_data->edt_data.NumberBuffer, PHB_MAX_LEN);
		parent_data->number_editor = AUI_edit_Start(parent_data->win, &editor_data);
		
#endif
	    	break;
	case E_MODE_TEXT:
	    	TRACE_EVENT("enter text");
		AUI_edit_SetDefault(&editor_data);
		AUI_edit_SetDisplay(&editor_data, ZONE_FULL_SK_TITLE_SCROLL, COLOUR_EDITOR, EDITOR_FONT);
		AUI_edit_SetEvents(&editor_data, E_MODE_TEXT, TRUE, FOREVER, (T_AUI_EDIT_CB)EMSCreate_SEND_edit_cb);
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtMessage, NULL);
		AUI_edit_SetAltTextStr(&editor_data, 0, NULL, TRUE, TxtSoftBack);
		AUI_edit_SetMode(&editor_data,ED_MODE_ALPHA, ED_CURSOR_UNDERLINE);
		//CRR: 23942 - xpradipg 26 Aug 2004
		//reset the text buffer
		memset(text,'\0',MAX_EMS_TEXT_LEN);
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE*)text, sizeof(text));
		editor = AUI_edit_Start(win, &editor_data);

	    	break;
       //CRR :25302 - xpradipg 10 Nov 2004
       case MMS_EMS_PHBK_NUMBER:
            //   TRACE_EVENT("calling MmsSend_PHBK_exec_cb() from MmsCreate_send_exec_cb()");
              EmsSend_PHBK_exec_cb(number_edit, event, parameter);
	    	break;
	case MWM_ONDRAW:
		break;
	case MWM_DESTORY:
		break;
	default:
	    	TRACE_EVENT("Err: Default");
    	break;
    }
}


/*******************************************************************************

 $Function:    	MMSCreate_SEND_start

 $Description:	Create SMS send window
 
 $Returns:    	execution status

 $Arguments:	parent_window - parent window.
             	UserData - SMS data
*******************************************************************************/

T_MFW_HND EMSCreate_SEND_start(T_MFW_HND parent_window, void *UserData)
{
	T_MFW_HND win;
	TRACE_FUNCTION ("EMSCreate_SEND_start()");
	win=MMI_CreateWindow(parent_window, (T_DIALOG_FUNC) EMSCreate_SEND_exec_cb, (void*)UserData,0, 0,0);
	if(UserData) SEND_EVENT(win, (USHORT)UserData, 0, 0);
	return win;
}

#define MMS_CREATE_OPTION


/*******************************************************************************

 $Function:    	MMSCreate_OPTexeSend

 $Description:	Called when the user press send in the Option menu
             
 $Returns:    	event status.

 $Arguments:	m - pointer to menu.
             	i - index if selected menu item.
*******************************************************************************/

static int EMSCreate_OPTexeSend(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
    
	DAL_PostMessage(EMG4_SaveMsg, EMG4_Type_NotUsed, 0, 0);
    
       EMSCreate_SEND_start(win, (void*)E_MODE_NUMBER);


}

/*******************************************************************************

 $Function:    	EMSCreate_OPTexeInsPreDefPicture

 $Description:	Displays list of the pre-defined pictures for EMS
                     //xrashmic 7 Dec, 2004 MMI-SPR-23965 
 $Returns:		

 $Arguments:	
 				
*******************************************************************************/

static int EMSCreate_OPTexeInsPreDefPicture(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
//	MMSom_start(win, (MfwMnuAttr *) MMS_INSERT_PICTURE);
//   pinghua  modify for  test EMS  
      MMSom_start(win, (MfwMnuAttr *) EMS_INSERT_PICTURE);
}

/*******************************************************************************

 $Function:    	EMSCreate_OPTexeInsPicture

 $Description:	Displays list of the user-defined pictures for EMS
                     //xrashmic 7 Dec, 2004 MMI-SPR-23965 
 $Returns:		

 $Arguments:	
 				
*******************************************************************************/
static int EMSCreate_OPTexeInsPicture(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
      MMSom_start(win, (MfwMnuAttr *) EMS_INSERT_PICTURE_USR);
}

/*******************************************************************************

 $Function:    	EMSCreate_OPTexeInsPreDefSound

 $Description:	Displays list of the pre-defined sound for EMS
                     //xrashmic 7 Dec, 2004 MMI-SPR-23965 
 $Returns:		

 $Arguments:	
 				
*******************************************************************************/
static int EMSCreate_OPTexeInsPreDefSound(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
//	MMSom_start(win, (MfwMnuAttr *) MMS_INSERT_SOUND);
//    pinghua  modify for test EMS!!
       MMSom_start(win, (MfwMnuAttr *) EMS_INSERT_SOUND);
}

/*******************************************************************************

 $Function:    	EMSCreate_OPTexeInsSound

 $Description:	Displays list of the user-defined sound for EMS
                     //xrashmic 7 Dec, 2004 MMI-SPR-23965 
 $Returns:		

 $Arguments:	
 				
*******************************************************************************/
static int EMSCreate_OPTexeInsSound(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
      MMSom_start(win, (MfwMnuAttr *) EMS_INSERT_SOUND_USR);
}


static int EMSCreate_OPTexeInsText(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	EMSCreate_SEND_start(win, (void*)E_MODE_TEXT);
}
static int EMSCreate_OPTexeSave(MfwMnu* m, MfwMnuItem* i)
{
	DAL_PostMessage(EMG4_SaveMsg, EMG4_Type_NotUsed, 0, 0);

	// xreddymn Nov-27-2004 MMI-SPR-25278
	g_inSaveMode=TRUE;
       //xrashmic 08 Feb, 2005 MMI-SPR-27853
       //Added few more parameters for this function
	g_inSaveModeWin = information_dialog(TxtPleaseWait,TxtNull,NULL,NULL, TxtNull,TxtNull,FOREVER,0,NULL);
}
#if  0
static int MMSCreate_OPTexeInsSlide(MfwMnu* m, MfwMnuItem* i)
{
	TRACE_EVENT("insert pic into OM");
	M4_InsertPicObjectIntoOM();
}

#endif 
/*******************************************************************************

 $Function:    	MMSCreate_OPT_exec_cb

 $Description:	Exec callback function for the Option window
 
 $Returns:    	none

 $Arguments:	win - current window
             	event - event id
             	value - unique id
             	parameter - optional data.
             
*******************************************************************************/

void EMSCreate_OPT_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
    /* callback handler for events sent to to trigger execution */
{
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
    TRACE_FUNCTION ("MMSCreate_OPT_exec_cb()");
	//xmzhou_trace_string_value("EMSCreate_OPT_exec_cb called", event);
    switch (event)
    {
	case MWM_CREATE:
	    	TRACE_EVENT("MWM_CREATE");
	        /* initialization of administrative data */
	    	winShow(win);
	    	break;
	case MWM_ONDRAW:
		dspl_ClearAll();
		displaySoftKeys(TxtSoftOK,TxtSoftBack);
		break;
	case MWM_DESTORY:
		//xmzhou_trace_string("action_EMS_ResumeEditor in EMSCreate_OPT_exec_cb called");
		// xreddymn Sep-14-2004 MMI-SPR-24735: EMS editor is now resumed in EMSCreate_exec_cb
		// action_EMS_ResumeEditor();
		break;
	default:
        return;
    }
}

/*******************************************************************************

 $Function:    	MMSCreate_OPT_start

 $Description:	Start the creation of the main window for Create MMS
 
 $Returns:    	mfw window handler 

 $Arguments:	parent_window - Parent window handler
             	menuAttr	  - Menu attributes.
 $Authors :   pinghua add for EMS test 
 
*******************************************************************************/
T_MFW_HND EMSCreate_OPT_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
	TRACE_FUNCTION ("SmsRead_R_start()");
	// xreddymn Sep-14-2004 MMI-SPR-24735: EMS editor is now suspended in EMSCreate_exec_cb
	// action_EMS_SuspendEditor();
	return MMI_CreateWindow(parent_window, (T_DIALOG_FUNC)EMSCreate_OPT_exec_cb,(void*)menuAttr, (T_MFW_CB)0, &EMSCreate_OPTAttrib,0);
}


static void EMSCreate_Delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	TRACE_FUNCTION("EMSCreate_Delete_cb");

	switch (reason)
	{
	case INFO_KCD_LEFT:
	    	switch(identifier)
	        {
	    	case EMS_DELETE_PICTURE:
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
			DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteImage,NULL);
	        	break;
	    	case EMS_DELETE_SOUND:
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
			DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteAudio,NULL);
	        	break;
	    	case EMS_DELETE_TEXT:
			DAL_PostMessage(EMG4_Edit,EMG4_Type_NotUsed,0,NULL);
			DAL_PostMessage(EMG4_DeleteObject,EMG4_Type_NotUsed, EDeleteText,NULL);
	        	break;
	        }
		MMI_DestoryWindow(win);
	    	break;
	case INFO_KCD_HUP:
	case INFO_KCD_RIGHT:
	case INFO_KCD_CLEAR:
		MMI_DestoryWindow(win);
	    	break;
	default:
    	break;
    }
}
static int EMSCreate_OPTexeDelPicture(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)EMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=EMS_DELETE_PICTURE;
	info_dialog (win, &display_info);
}
static int EMSCreate_OPTexeDelSound(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)EMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=EMS_DELETE_SOUND;
	info_dialog (win, &display_info);
}
static int EMSCreate_OPTexeDelText(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND    win  = mfwParent(mfw_header());
	T_DISPLAY_DATA display_info;
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)EMSCreate_Delete_cb, FOREVER, KEY_LEFT |KEY_RIGHT|KEY_CLEAR|KEY_HUP);
	display_info.Identifier=EMS_DELETE_TEXT;
	info_dialog (win, &display_info);
}

#if 0 
void FUN_TRACE_EVENT(char * text, unsigned long param)
{
	TRACE_EVENT_P1(text, param);
}
#endif 


/*******************************************************************************

 $Function:    	ems_cb

 $Description:	Call back for ems_dialog
 		       xrashmic 13 Sep, 2004 MMI-SPR-24744
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

static void ems_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
    TRACE_FUNCTION("ems_cb");
}


/*******************************************************************************

 $Function:    	ems_dialog

 $Description:	To display the indication of  EMS sent
 		       xrashmic 13 Sep, 2004 MMI-SPR-24744
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/

void ems_dialog(USHORT TxtId1, USHORT TxtId2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer)
{
	T_DISPLAY_DATA	display_info;
	T_MFW_HND    parent_win  = mfwParent(mfw_header());
       T_MFW_HND win;
	TRACE_FUNCTION("ems_dialog");
	dlg_initDisplayData_TextId( &display_info, SoftKeyTxtId1, SoftKeyTxtId2, TxtId1, TxtId2, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info,(T_VOID_FUNC)ems_cb, timer, KEY_RIGHT);
	display_info.Identifier		= 0;	
	win=info_dialog(parent_win, &display_info);
	win_show(win);
	dspl_Enable(1);
	return;
} 




#undef MMI_MMSCREATE_C
