/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************
 
 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		MMI
 $File:		    MmiEm.c
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    23/09/02                                                      
                                                                               
********************************************************************************
                                                                              
 Description:

    MMI engineering mode handling
                        
********************************************************************************
 $History: MmiExtras.c

	23/09/02			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/




/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/
#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "mfw_sys.h"

#include "prim.h"
#include "cus_aci.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_lng.h"
#include "mfw_tim.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_phb.h"
#include "mfw_cm.h"
#include "mfw_sim.h"
#include "mfw_nm.h"
#include "mfw_sat.h"
#include "mfw_ss.h" /*for convert*/
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_cphs.h"
#include "mfw_sat.h"
#include "Mfw_band.h"
#include "mfw_ffs.h"

#include "dspl.h"

#include "MmiMmi.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiBand.h"
#include "MmiCPHS.h"
/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else
#include "MmiEditor.h"
#endif
#include"MmiBookShared.h"


#include "Mfw_em.h"
#include "MmiEm.h"

#include "mmiColours.h"


#define EM_UPDATE_RATE 1000

#define EM_EDITOR_SIZE 300 /*SPR 1757, increased size of editor buffer*/
/*
**************************************Datatypes****************************************
*/
typedef struct _tEmData_
{
    /* administrative data */

    T_MMI_CONTROL     mmi_control;
    T_MFW_HND         win;
    T_MFW_HND         parent_win;

    /* associated handlers */

    T_MFW_HND         kbd; /*keyboard handler*/
    T_MFW_HND         tim;	/*timer handler*/

/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
	T_ED_DATA *			editor;
	T_ED_ATTR			editor_attr;
#else /* NEW_EDITOR */
    T_MFW_HND         edt; /*mfw editor handler*/
    MfwEdtAttr		editor_data;						/*editor config data*/
#endif /* NEW_EDITOR */

    /* internal data */
    char			edtBuffer[EM_EDITOR_SIZE*2];/*SPR 1757*//*editor contentbuffer*/
	MfwEmDataType CurrentWindow;						/*type of data being displayed*/

} tEmData;


/*
**************************************Prototypes****************************************
*/
int Mmi_em_event_cb(T_MFW_EVENT event, T_MFW_HND para); //Handles events from the MFW
T_MFW_HND Mmi_em_create(T_MFW_HND parent_window, MfwEmDataType data_type); //Create a window to display the information, specifying the keyboard, display and timer handlers.
void Mmi_em_destroy(T_MFW_HND own_window); //Deallocate window data and delete window.
int Mmi_em_kbd_cb(T_MFW_EVENT event,T_MFW_KBD *  kc ); //Handles key presses in the display window
int Mmi_em_win_cb(T_MFW_EVENT event,T_MFW_WIN * win );// Handles the information display.
void Mmi_em_tim_cb(T_MFW_EVENT event,T_MFW_TIM * t); //Handles the timer events.  




/*
**************************************Public functions****************************************
*/


/*******************************************************************************

 $Function:    	mmi_em_init()

 $Description:	initialise Engineering Mode module
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
void mmi_em_init()
{
	Mfw_em_init();

}

/*******************************************************************************

 $Function:    	mmi_em_enit()

 $Description:	exit Engineering Mode module
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
void mmi_em_exit()
{
	Mfw_em_exit();
}

/*******************************************************************************

 $Function:    	mmi_em_start_eng_mode_menus()

 $Description:	starts the emergency mode menu
 
 $Returns:		None

 $Arguments:	parent window
 
*******************************************************************************/
void mmi_em_start_eng_mode_menus(T_MFW_HND parent)
{	
	TRACE_EVENT("mmi_em_start_eng_mode_menus");
	bookMenuStart(parent, EngModeAttributes(), NULL);

}

/*******************************************************************************

 $Function:    	Mmi_em_display_mobile_info_data()

 $Description:	Called from menu; begins process to display Mobile Information
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/


int Mmi_em_display_mobile_info_data(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	TRACE_EVENT_P1("Mmi_em_display_mobile_info(), parent win %d", parent);
	TRACE_EVENT_P1("Memory left:%d", mfwCheckMemoryLeft());
	Mmi_em_create(parent, EM_MOBILE_INFO);
	
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:    	Mmi_em_display_serving_cell_params()

 $Description:	Called from menu; begins process to display Serving Cell parameters
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/

int Mmi_em_display_serving_cell_params(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	TRACE_EVENT_P1("MMiEm, Memory left:%d", mfwCheckMemoryLeft());
	Mmi_em_create(parent, EM_SERVING_CELL_PARAMS);
	
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:    	Mmi_em_display_neighbour_cell_params()

 $Description:	Called from menu; begins process to display Neighbouring Cell parameters
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/ 
int Mmi_em_display_neighbour_cell_params(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	TRACE_EVENT_P1("MMiEm, Memory left:%d", mfwCheckMemoryLeft());
	Mmi_em_create(parent, EM_NEIGHBOURING_CELL_PARAMS);
	
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	Mmi_em_display_location_params()

 $Description:	Called from menu; begins process to display Locationparameters
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/ 
int Mmi_em_display_location_params(MfwMnu* m, MfwMnuItem*i )
{	T_MFW_HND		parent	     = mfwParent( mfw_header());

	Mmi_em_create(parent, EM_LOCATION_PARAMS);
	
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	Mmi_em_display_ciph_hop_DTX_params()

 $Description:	Called from menu; begins process to display Ciphering, hopping and
 discontinuous transmission parameters
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/
int Mmi_em_display_ciph_hop_DTX_params(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	TRACE_EVENT_P1("MMiEm, Memory left:%d", mfwCheckMemoryLeft());
	Mmi_em_create(parent, EM_CIPH_HOP_DTX_PARAMS);
	
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	Mmi_em_display_GPRS_params()

 $Description:	Called from menu; begins process to display GPRS specific parameters
 
 $Returns:		status integer

 $Arguments:	menu and item (not used)
 
*******************************************************************************/

int Mmi_em_display_GPRS_params(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	TRACE_EVENT_P1("MMiEm, Memory left:%d", mfwCheckMemoryLeft());
	Mmi_em_create(parent, EM_GPRS_PARAMS);
	
	return MFW_EVENT_CONSUMED;
}

/*
************************************Internal Functions**************************************
*/

/*******************************************************************************

 $Function:    	Mmi_em_create()

 $Description:	Creates emergency mode display window
 
 $Returns:		window handle

 $Arguments:	parent window, kind of data to be displayed
 
*******************************************************************************/

T_MFW_HND Mmi_em_create(T_MFW_HND parent_window, MfwEmDataType data_type)
{
	tEmData     * data = (tEmData *)ALLOC_MEMORY (sizeof (tEmData ));
	T_MFW_WIN  * win;

	if (data EQ NULL)
	{
		return NULL;
	}

	// Create window handler
	data->win = win_create (parent_window, 0, E_WIN_VISIBLE, (MfwCb)Mmi_em_win_cb);
	if (data->win EQ NULL)
	{
		
		return NULL;
	}
	TRACE_EVENT_P1("Mmi_em_create(), data->win %d", data->win);
	//no window event handler needed
	data->mmi_control.dialog = (T_DIALOG_FUNC)NULL;
	data->mmi_control.data   = data;

	data->kbd      = kbd_create (data->win, KEY_ALL,         (T_MFW_CB)Mmi_em_kbd_cb);

	/*Mobile Info is the only data screen which doesn't need to be updated every second*/
	if (data_type != EM_MOBILE_INFO)
   	{	data->tim		= tim_create(data->win, EM_UPDATE_RATE, (T_MFW_CB)Mmi_em_tim_cb);
		timStart(data->tim);//start timer
	}


   	/*populate the user data*/
	win                      = ((T_MFW_HDR *)data->win)->data;
	win->user                = (void *)data;
	data->parent_win         = parent_window;

	/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
	/*SPR 1757, removed code for Chinese special case*/
    AUI_edit_SetAttr(&data->editor_attr, EM_CREATE_EDITOR, COLOUR_EDITOR_XX, EDITOR_FONT, ED_MODE_READONLY, ED_CURSOR_NONE, ATB_DCS_ASCII, (UBYTE *)data->edtBuffer,EM_EDITOR_SIZE);
   	data->editor = ATB_edit_Create(&data->editor_attr,0);
	/*Clear editor buffer*/
	memset(data->edtBuffer, 0, sizeof(EM_EDITOR_SIZE*2));
	ATB_edit_Init(data->editor);
#else /* NEW_EDITOR */
	 /*SPR 1757, removed code for Chinese special case*/
  	bookSetEditAttributes(EM_CREATE_EDITOR,COLOUR_EDITOR_XX,0,edtCurNone,0,data->edtBuffer,EM_EDITOR_SIZE*2,&data->editor_data);
   	data->edt		= edtCreate(data->win, &data->editor_data, NULL, NULL);
	edtUnhide( data->edt );
	/*Clear editor buffer*/
	memset(data->edtBuffer, 0, sizeof(EM_EDITOR_SIZE*2));
#endif /* NEW_EDITOR */

	/*Make sure we store the kind of window we want to show*/
	data->CurrentWindow = data_type;

	/*bind the MFW event handler to any events from the MFW Eng Mode module*/
	Mfw_em_create(data->win, 0xFF,  (MfwCb)Mmi_em_event_cb);
	Mfw_em_get_data(data_type);/*ask MFW for the required data*/
	win_show(data->win);/*show the screen*/
	return data->win;

}

/*******************************************************************************

 $Function:    	Mmi_em_event_cb()

 $Description:	Handles events coming from the MFW 
 
 $Returns:		status integer

 $Arguments:	event type, pointer to data
 
*******************************************************************************/
int Mmi_em_event_cb(T_MFW_EVENT event,void* para)
{ 	T_MFW_HND       win  = mfw_parent (mfw_header());
  	T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
  	tEmData * data = (tEmData *)win_data->user;

	MFW_EM_Mobile_Info* mob_info;
  	MFW_EM_Serving_Cell_Parameters* sc_info;
  	MFW_EM_Neighbour_Cell_Parameters* nc_info;
  	MFW_EM_Location_Parameters* loc_info;
  	MFW_EM_Ciph_hop_DTX_Parameters* ciph_hop_dtx_info;
  	MFW_EM_GPRS_Parameter* gprs_info;
  	char * DTX_Status;
	char	temp_buffer[EM_EDITOR_SIZE];/*SPR 1757 temporary buffer to hold information*/
	#ifdef NEW_EDITOR
	T_ATB_TEXT temp_text;/*SPR 1757*/
  	#endif 
	TRACE_EVENT_P1("Mmi_em_event_cb(), event:%d", event);

	memset(temp_buffer, 0, EM_EDITOR_SIZE);
	
  	/*if event matches current window type*/
	if (event == data->CurrentWindow)
	{	switch (event)
		{
			case EM_MOBILE_INFO:
			{	mob_info = (MFW_EM_Mobile_Info*)para;/*cast parameter to appropriate type*/
				/*copy data to editor buffer*/
				/*MC, SPR 1554 Added all SW versions to editor string*/ 
				sprintf(temp_buffer, "SIM_VERSION:%d CC_VERSION:%d SS_VERSION:%d SMS_VERSION:%d MM_VERSION:%d RR_VERSION:%d DL_VERSION:%d ALR_VERSION:%d  IMEI:%s IMSI:%s TMSI:%u", 
				mob_info->SIM_version, mob_info->CC_version,  mob_info->SS_version,
				mob_info->SMS_version, mob_info->MM_version, mob_info->RR_version,
				mob_info->DL_version, mob_info->ALR_version,mob_info->IMEI, mob_info->IMSI,
				mob_info->TMSI);
	/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif
				win_show(data->win);/*show data*/
			}
			break;
			case EM_SERVING_CELL_PARAMS:
			{	
				sc_info = (MFW_EM_Serving_Cell_Parameters*)para;/*cast parameter to appropriate type*/
				sprintf(temp_buffer, "ARFCN:%d RSSI:%d RXQ:%d RLT:%d C1:%d C2:%d LAC:%d BSIC:%d TAV:%d",\
          sc_info->arfcn, sc_info->RSSI, sc_info->RXQ, sc_info->RLT, sc_info->C1, sc_info->C2,\
          sc_info->LAC, sc_info->BSIC, sc_info->TAV);
    
	/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif
				win_show(data->win);
			}
			break;
			case EM_NEIGHBOURING_CELL_PARAMS:	
			{	nc_info = (MFW_EM_Neighbour_Cell_Parameters*)para;/*cast parameter to appropriate type*/
				/*copy data to editor buffer*/
				sprintf(temp_buffer, "NUM:%d\nARFCN:RSSI:C2:LAC:BSIC\n %5d%5d%5d%6d%5d\n %5d%5d%5d%6d%5d\n %5d%5d%5d%6d%5d\n %5d%5d%5d%6d%5d\n %5d%5d%5d%6d%5d\n %5d%5d%5d%6d%5d\n SC%4d%5d%5d%6d%5d",\
          nc_info->NUM,\
          nc_info->arfcn[0], nc_info->RSSI[0], nc_info->C2[0], nc_info->LAC_NC[0], nc_info->BSIC_NC[0],\
          nc_info->arfcn[1], nc_info->RSSI[1], nc_info->C2[1], nc_info->LAC_NC[1], nc_info->BSIC_NC[1],\
          nc_info->arfcn[2], nc_info->RSSI[2], nc_info->C2[2], nc_info->LAC_NC[2], nc_info->BSIC_NC[2],\
          nc_info->arfcn[3], nc_info->RSSI[3], nc_info->C2[3], nc_info->LAC_NC[3], nc_info->BSIC_NC[3],\
          nc_info->arfcn[4], nc_info->RSSI[4], nc_info->C2[4], nc_info->LAC_NC[4], nc_info->BSIC_NC[4],\
          nc_info->arfcn[5], nc_info->RSSI[5], nc_info->C2[5], nc_info->LAC_NC[5], nc_info->BSIC_NC[5],\
          nc_info->arfcn[6], nc_info->RSSI[6], nc_info->C2[6], nc_info->LAC_NC[6], nc_info->BSIC_NC[6]);
	/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif			
				/*show the window*/
				win_show(data->win);
			}
			break;
			case EM_LOCATION_PARAMS:
			{	loc_info = (MFW_EM_Location_Parameters*)para;/*cast parameter to appropriate type*/
				/*copy data to editor buffer*/
				/*MC, SPR 1554 Removed Cell id from editor string*/ 
				sprintf(temp_buffer, "LUP:%d MCC:%s MNC:%s LAC:%d ", loc_info->LUP, loc_info->MCC, loc_info->MNC, loc_info->LAC);
	/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif	
				/*show the window*/
				win_show(data->win);
			}
			break;
			case EM_CIPH_HOP_DTX_PARAMS:
			{	ciph_hop_dtx_info = (MFW_EM_Ciph_hop_DTX_Parameters*)para;/*cast parameter to appropriate type*/
				/*convert DTX status to string*/ 
				if (ciph_hop_dtx_info->DTX_status == FALSE)
					DTX_Status = "Off";
				else
					DTX_Status = "On";
				//copy data to editor
				sprintf(temp_buffer, "STATUS:%d HSN:%d DTX:%s ", ciph_hop_dtx_info->ciph_status, ciph_hop_dtx_info->HSN, DTX_Status);
				/*show the window*/
				/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif
				win_show(data->win);
			}
			break;
			case EM_GPRS_PARAMS:
			{	gprs_info = (MFW_EM_GPRS_Parameter*)para;//cast parameter to appropriate type
				/*MC, SPR 1554 Changed ediotr string to show Network Mode of Operation*/ 
				sprintf(temp_buffer, "NMO:%d  NDTS:%d  RAC:%d  C31:%d  C32:%d",\
          gprs_info->NMO, gprs_info->NDTS, gprs_info->RAC, gprs_info->C31, gprs_info->C32);
				//show the window
				/* SPR#1428 - SH - New Editor - string has changed, update word wrap */
#ifdef NEW_EDITOR
				/*SPR 1757 Insert temp buffer into editor*/
				temp_text.data = (UBYTE*)temp_buffer;
				temp_text.dcs = ATB_DCS_ASCII;
				ATB_string_Length(&temp_text);
				ATB_edit_ResetMode(data->editor, ED_MODE_READONLY);		/* Switch off read only to add text */
				ATB_edit_ClearAll(data->editor);
				ATB_edit_InsertString(data->editor, &temp_text);			/* Insert name string */
				ATB_edit_SetMode(data->editor, ED_MODE_READONLY);		/* Switch on read only again */
				ATB_edit_Refresh(data->editor);
#else /* !NEW_EDITOR */
				strncpy(data->edtBuffer, temp_buffer, EM_EDITOR_SIZE);/*SPR 1757*/
#endif
				win_show(data->win);
			}
			break;
		}
	}

}

/*******************************************************************************

 $Function:    	Mmi_em_destroy()

 $Description:	Delete the window
 
 $Returns:		none

 $Arguments:	window handle
 
*******************************************************************************/
void Mmi_em_destroy(T_MFW_HND own_window)
{
  T_MFW_WIN     * win  = ((T_MFW_HDR *)own_window)->data;
  tEmData * data = (tEmData *)win->user;

  TRACE_EVENT ("Mmi_em_destroy()");

  if (own_window == NULL)
  {
	TRACE_EVENT ("Error :- Called with NULL Pointer");
	return;
  }

  if (data)
  {
    /*
     * Exit TIMER & KEYBOARD Handle
     */
    kbd_delete (data->kbd);
    tim_delete (data->tim);
    /* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
	ATB_edit_Destroy(data->editor);
#else
	edt_delete(data->edt);
#endif
    /*
     * Delete WIN Handler
     */
    win_delete (data->win);
    /*
     * Free Memory
     */
    FREE_MEMORY ((void *)data, sizeof (tEmData));
  }
  TRACE_EVENT_P1("MMiEm END, Memory left:%d", mfwCheckMemoryLeft());
}

/*******************************************************************************

 $Function:    	Mmi_em_kbd_cb()

 $Description:	Keyboard handler
 
 $Returns:		status int

 $Arguments:	event, keyboard data
 
*******************************************************************************/
int Mmi_em_kbd_cb(T_MFW_EVENT event,T_MFW_KBD *  kc )
{	T_MFW_HND       win  = mfw_parent (mfw_header());
  	T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
  	tEmData * data = (tEmData *)win_data->user;
  	
 	TRACE_EVENT_P2("Mmi_em_kbd_cb, key:%d, win;%d", kc->code, data->win);
  
	switch(kc->code)
	{
		
		case KCD_MNUUP:/*scroll up */
		/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
			ATB_edit_MoveCursor(data->editor, ctrlUp, TRUE);
#else /* NEW_EDITOR */
        	edtChar(data->edt,ecUp);
#endif /* NEW_EDITOR */
   
        break;
        
        case KCD_MNUDOWN:/*scroll down*/
        /* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
			ATB_edit_Char(data->editor,ctrlDown, TRUE);
#else /* NEW_EDITOR */
        	edtChar(data->edt,ecDown);
#endif /* NEW_EDITOR */
 
        break;
        case KCD_HUP:	/*destroy window*/
		case KCD_RIGHT:
			Mmi_em_destroy(data->win);
		break;
		default:
		break;
	}	
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	Mmi_em_win_cb()

 $Description:	Display handler
 
 $Returns:		status int

 $Arguments:	event, window handle
 
*******************************************************************************/
int Mmi_em_win_cb(T_MFW_EVENT event,T_MFW_WIN * win )
{	
  	tEmData * data = (tEmData *)win->user;
  	


	TRACE_EVENT_P1("EM window: %d", win);
	TRACE_EVENT_P1("Mmi_em_win_cb(), data->CurrentWindow %d", data->CurrentWindow);
  	
	switch( event )
    {
        case MfwWinVisible:
		/*clear screen*/
        dspl_ClearAll();

       /*Show editor content*/
       /* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
		ATB_edit_Show(data->editor);
#else /* NEW_EDITOR */
		edtShow(data->edt);
#endif /* NEW_EDITOR */

        displaySoftKeys(TxtNull, TxtSoftBack); /*show the softkeys*/
		break;
        default:
        	return MFW_EVENT_PASSED;
        break;
	}

	return MFW_EVENT_CONSUMED;

}

/*******************************************************************************

 $Function:    	Mmi_em_tim_cb()

 $Description:	Timer handler (every second)
 
 $Returns:		none

 $Arguments:	event, timer data
 
*******************************************************************************/
void Mmi_em_tim_cb(T_MFW_EVENT event,T_MFW_TIM * t)
{	T_MFW_HND       win  = mfw_parent (mfw_header());
  	T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
  	tEmData * data = (tEmData *)win_data->user;
  	TRACE_EVENT_P1("Mmi_em_tim_cb(), win:%d", data->win);
  	/*Request the data from MFW again*/
	Mfw_em_get_data(data->CurrentWindow);
  	/*restart timer*/
	timStart(data->tim);
}
