/*
+-------------------------------------------------------------------+
| PROJECT: MMI-Framework (8445)         $Workfile:: mmiBluetooth.h			$|
| $Author:: NDH					     $Revision::  1						$|
| CREATED: 26.04.04				     $Modtime:: 26.04.04 10:48			$|
| STATE  : code														 |
+-------------------------------------------------------------------+


   MODULE  : MFW_BT

   PURPOSE : This module contains the definitions for MFW Bluetooth Management

*/

#ifndef DEF_MMI_BLUETOOTH_HEADER
#define DEF_MMI_BLUETOOTH_HEADER

#include "mfw_mfw.h"
#include "mfw_mnu.h"

#define BLUETOOTH_TEST	0

#ifdef BLUETOOTH_TEST
/*
** Module Test Function Prototypes
*/
void bluetoothTestDevMngr(void);
void bluetoothTestDevMngrSrch(void);
void bluetoothTestDevMngrSec(void);
void bluetoothTestDataGw(void);
void bluetoothTestAudioGw(void);
void bluetoothTestObjPush(void);
void bluetoothTestFileTxfr(void);
void bluetoothTestClient(void);
void bluetoothTestServer(void);

GLOBAL int  mmi_bluetooth_test_single_msg(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_test_multi_msg(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_test_buf_ovrflow(MfwMnu * mnu, MfwMnuItem * item);
#endif

/*
** Type Definitions
*/
typedef enum
{
	/*
	** Events generatede Internally, or from Menus
	*/
	BT_BLUETOOTH_ON,
	BT_BLUETOOTH_OFF,
	BT_DISCOVERABLE_ON,
	BT_DISCOVERABLE_TIMED,
	BT_DISCOVERABLE_OFF,
	BT_LIST_KNOWN_DEVICES,
	BT_DEVICE_SEARCH,
	BT_PAIR_DEVICE,
	BT_SHOW_DEV_SERVICES,
	BT_DISABLE_BLUETOOTH,
	BT_DISABLE_SEARCH,
	BT_EDITOR_CANCEL,
	BT_EDITOR_SELECT,
	BT_SET_REM_DEV_NAME,		/* CQ21843 : Internal Event to trigger the process of assigning a Friendly Name to a remote device */

	/*
	** Bluetooth Events handled by the Root Window
	*/
	BT_ENABLE_COMPLETE,
	BT_DISABLE_COMPLETE,
	BT_DEV_NAME_REQ,
	BT_PIN_REQ,
	BT_AUTHORIZE_REQ,
	BT_LINK_UP,
	BT_LINK_DOWN,

	/*
	** Bluetooth Events handled by both the Root and Search Windows
	*/
	BT_AUTH_COMPLETE,

	/*
	** Bluetooth Events handled by the Search Window
	*/
	BT_INQUIRY_COMPLETE,
	BT_DISCOVER_RESULT,
	BT_DISCOVER_COMPLETE
} T_BT_EVENT;

typedef enum
{
	BT_MNU_INIT
} T_BT_MNU_EVENT;

typedef enum
{
	BT_DEV_NAME_EDITOR,
	BT_REM_DEV_NAME_EDITOR,		/* CQ21843 : Identifier for Editor Process for assigning a Friendly Name to a remote device */
	BT_PIN_REQ_EDITOR,
	BT_PAIRING_EDITOR
} T_BT_IDENTIFIER;

typedef enum
{
	BT_NOT_EXPECTED,			/* Authentication result not expected */
	BT_NO_RESP,				/* No Response Required - No Dialog Shown */
	BT_SUCCESS_FAIL_RESP,		/* Display a dialog indicating Success or Failure */
	BT_PAIRED_NOT_RESP		/* Display a dialog indicating Paired or Not Paired */
} T_BT_REQ_RESP;

typedef enum
{
	BT_MODE_NO_SEARCH,				/* No Search is under way */
	BT_MODE_KNOWN_DEVICES,			/* Just getting a list of known devices */
	BT_MODE_LOCAL_SEARCH,			/* Doing a full search for any peer devices */
	BT_MODE_LOCAL_SEARCH_CANCEL,	/* User Canceled Search before All devices were reported */
	BT_MODE_LIST_COMPLETE
} T_BT_SEARCH_MODE;

/*
** Menu Status Functions
*/
USHORT isBluetoothActive( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT isBluetoothInactive( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT isBtDevicePaired( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT isBtDeviceUnPaired( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT isBtDeviceKnown( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT isBtDeviceUnknown( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );

/*
** Menu Action Functions
*/
GLOBAL int  mmi_bluetooth_on(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_automatic(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_off(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_change_name(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_set_discoverable_on(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_set_discoverable_off(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_set_discoverable_timed(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_device_search(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_list_known_devices(MfwMnu * mnu, MfwMnuItem * item);
GLOBAL int  mmi_bluetooth_clear_all_stored_devices(MfwMnu * mnu, MfwMnuItem * item);

/*
** Bluetooth MMI Functions
*/
void  mmi_bt_exit (void);
void  mmi_bt_init (void);

T_MFW_HND mmi_bt_pin_request_create(T_MFW_HND parent);
MfwRes mmi_bt_pin_request_destroy(T_MFW_HND win);

T_MFW_HND mmi_bt_dev_name_create(T_MFW_HND parent);
MfwRes mmi_bt_dev_name_destroy(T_MFW_HND win);

T_MFW_HND mmi_bt_authorize_create(T_MFW_HND parent);
MfwRes mmi_bt_authorize_destroy(T_MFW_HND win);

BOOL mmi_bt_search_create(T_MFW_HND parent);
GLOBAL void  mmi_bt_search_destroy (void);

void mmi_bt_pin_req_cntrl (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
void mmi_bt_dev_name_cntrl(T_MFW_HND win, USHORT event, SHORT value, void * parameter);
void mmi_bt_authorize_cntrl(T_MFW_HND win, USHORT event, SHORT value, void * parameter);
void mmi_bt_search_cntrl (T_MFW_HND win, USHORT event, SHORT value, void * parameter);

int  mmi_bluetooth_win_cb(MfwEvt evt, MfwHnd win);

void mmi_bt_authorize_dlg_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason);


#endif

