#
#	Setting Directory for Layer4 Objects
#
TARID := bmi
OBJ := $(CONDAT_DIR)/obj/obj_$(TARID)

#INCLAYER4 = -I$(SRCMFW)  -I$(SRCACI)  -I$(SRCSMI) -I$(SRCKSD)
INCLAYER4 = -I$(SRCMFW)  -I$(SRCACI)  -I$(SRCSMI) -I$(SRCKSD) -I$(SRCMMS)

# must not be empty. set to "-D" for no local flags.
MY_OPTIONS = -D


SRCWAP=$(CONDAT_DIR)/ms/src/wapaus
SRCEZI=$(CONDAT_DIR)/ms/src/ezitxt
SRCCE=$(CONDAT_DIR)/ms/src/agfa
SRCATB=$(CONDAT_DIR)/ms/src/atb
COLOUR_MMI = 0 
# New editor. 1 -> Compile. 0 -> Don't compile, compile old editor.
NEWED = 1


#
# Sim application setting
#

ifeq ($(TK),1)
COPT1 += -dSIM_TOOLKIT
else
COPT1 += -uSIM_TOOLKIT
endif

ifeq ($(MELGEN),1)
COPT1 += -dMMI_MELODYGENERATOR
else
COPT1 += -uMMI_MELODYGENERATOR
endif

ifeq ($(GAME),1)
COPT1 += -dMMIGAME
else
COPT1 += -uMMIGAME
endif


ifeq ($(CHIMMI),1)
COPT1+= -dCHINESE_MMI
else
COPT1+= -uCHINESE_MMI
endif


ifeq ($(ETXT),1)
COPT1 += -dEASY_TEXT_ENABLED
else
COPT1 += -uEASY_TEXT_ENABLED
endif


ifeq ($(WAP),1)
COPT1 += -dMMI_WAP_ENABLED
else
COPT1 += -uMMI_WAP_ENABLED
endif

#
# Support for Homezone

ifeq ($(HZONE),1)
COPT1 += -dMMI_HOMEZONE_ENABLED
else
COPT1 += -uMMI_HOMEZONE_ENABLED
endif


#
# Support for UNICODE
#	

ifeq ($(UNIC),1)
COPT1 += -dNO_ASCIIZ
endif

#SPR890 - SH - Test mode menu
ifeq ($(MMITEST),1)
COPT1 += -dMMI_TEST_MODE
else
COPT1 += -uMMI_TEST_MODE
endif

#
# Support for GPRS
#
ifeq ($(PMODE),2)
COPT1 += -dMMI_GPRS_ENABLED
else
COPT1 += -uMMI_GPRS_ENABLED
endif

#
# Support for light version
#
#JVJ-SPR-1298. Provisional until a new option in the .inf file is inserted.

ifeq ($(SRVC),0)
COPT1 += -dMMI_LITE
else
COPT1 += -uMMI_LITE
endif


#
# Support for ENGINEERING MODE
#
ifeq ($(EM),1)
COPT1 += -dMMI_EM_ENABLED
else
COPT1 += -uMMI_EM_ENABLED
endif


#
# Support for Colour display
#	
ifeq ($(BOARD),41)
LSCREEN = 1
COLOUR_MMI = 1
endif

ifeq ($(BOARD),40)
LSCREEN = 1
COLOUR_MMI = 1
endif

ifeq ($(SRVC),0)
COLOUR_MMI = 0
endif

ifeq ($(LSCREEN),1)
COPT1 += -dLSCREEN
else
COPT1 += -uLSCREEN
endif


ifeq ($(COLOUR_MMI),1)
COPT1 += -dCOLOURDISPLAY
else
COPT1 += -uCOLOURDISPLAY
endif

#TTY settings
ifeq ($(FF_TTY),1)
COPT1 += -dMMI_TTY_ENABLED
else
COPT1 += -uMMI_TTY_ENABLED
endif

#
# Internal Phonebook
# Currently always on
#
COPT1 += -dINT_PHONEBOOK

# temporary addition for 2TO1 stack; the assumption is that 2.1.x and 3.1 don't
# use this makefile; 2.0 and 1.0 will be on the g23m branch; so it should be 
# safe to put the 2to1 related definition here without enclosing them within 
# conditions

COPT1 += -dFF_2TO1_PS
#
# New editor (SPR#1428 - SH)
#
ifeq ($(NEWED),1)
COPT1 += -dNEW_EDITOR
else
COPT1 += -uNEW_EDITOR
endif

COREOBJ = $(OBJ)/MmiCall.$(OBJ_TAIL) \
                $(OBJ)/MmiResources.$(OBJ_TAIL) \
                $(OBJ)/MmiBlkLangDB.$(OBJ_TAIL) \
                $(OBJ)/MmiBlkManager.$(OBJ_TAIL) \
                $(OBJ)/MmiBlkResources.$(OBJ_TAIL) \
                $(OBJ)/MmiBookCallDetailsWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookCallListWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookController.$(OBJ_TAIL) \
                $(OBJ)/MmiBookDetailsWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookMenuWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookPhonebook.$(OBJ_TAIL) \
                $(OBJ)/MmiBookSDNWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookSearchWindow.$(OBJ_TAIL) \
                $(OBJ)/MmiBookServices.$(OBJ_TAIL) \
                $(OBJ)/MmiBookShared.$(OBJ_TAIL) \
                $(OBJ)/MmiBookUtils.$(OBJ_TAIL) \
		$(OBJ)/MmiDialogs.$(OBJ_TAIL) \
		$(OBJ)/MmiDummy.$(OBJ_TAIL) \
		$(OBJ)/MmiIcons.$(OBJ_TAIL) \
		$(OBJ)/MmiIdle.$(OBJ_TAIL) \
		$(OBJ)/MmiLists.$(OBJ_TAIL) \
		$(OBJ)/MmiLists2.$(OBJ_TAIL) \
		$(OBJ)/MmiMain.$(OBJ_TAIL) \
		$(OBJ)/MmiMenu.$(OBJ_TAIL) \
		$(OBJ)/MmiMmi.$(OBJ_TAIL) \
		$(OBJ)/MmiNetwork.$(OBJ_TAIL) \
		$(OBJ)/MmiPins.$(OBJ_TAIL) \
		$(OBJ)/MmiServices.$(OBJ_TAIL) \
		$(OBJ)/MmiSettings.$(OBJ_TAIL) \
		$(OBJ)/MmiSmsBroadcast.$(OBJ_TAIL) \
		$(OBJ)/MmiSounds.$(OBJ_TAIL) \
		$(OBJ)/MmiSmsIdle.$(OBJ_TAIL) \
		$(OBJ)/MmiSmsMenu.$(OBJ_TAIL) \
		$(OBJ)/MmiSmsSend.$(OBJ_TAIL) \
		$(OBJ)/MmiSmsRead.$(OBJ_TAIL) \
		$(OBJ)/MmiSoftkeys.$(OBJ_TAIL) \
		$(OBJ)/MmiStart.$(OBJ_TAIL) \
                $(OBJ)/MmiTimeDate.$(OBJ_TAIL) \
                $(OBJ)/MmiUserData.$(OBJ_TAIL)\
		$(OBJ)/MmiSatcall.$(OBJ_TAIL) \
		$(OBJ)/MmiSatinfo.$(OBJ_TAIL) \
		$(OBJ)/MmiSatinput.$(OBJ_TAIL) \
		$(OBJ)/MmiSatmenu.$(OBJ_TAIL) \
		$(OBJ)/MmiSimtoolkit.$(OBJ_TAIL) \
		$(OBJ)/MmiVoiceMemo.$(OBJ_TAIL)\
		$(OBJ)/MmiCalculatorMain.$(OBJ_TAIL) \
		$(OBJ)/MmiMelody_data.$(OBJ_TAIL) \
		$(OBJ)/MmiTimers.$(OBJ_TAIL) \
		$(OBJ)/MmiAoc.$(OBJ_TAIL) \
		$(OBJ)/MmiCPHS.$(OBJ_TAIL) \
		$(OBJ)/MmiBand.$(OBJ_TAIL) \
		$(OBJ)/MmiSatClassE.$(OBJ_TAIL) \

BMIOBJ = $(COREOBJ)

ifeq ($(NEWED),1)
NEWEDOBJ =	$(OBJ)/AUIEditor.$(OBJ_TAIL)\
		$(OBJ)/AUISymbol.$(OBJ_TAIL)\
		$(OBJ)/AUITextEntry.$(OBJ_TAIL)\
		$(OBJ)/AUICalcEditor.$(OBJ_TAIL)\
		$(OBJ)/AUIPINEditor.$(OBJ_TAIL)
else
NEWEDOBJ += $(OBJ)/MmiBookInputWindow.$(OBJ_TAIL) \
		$(OBJ)/MmiEditor.$(OBJ_TAIL)
endif
BMIOBJ += $(NEWEDOBJ)
EXTRAOBJ += $(NEWEDOBJ)
		
		
ifeq ($(HZONE),1)
BMIOBJ +=	$(OBJ)/MmiHomezone.$(OBJ_TAIL)
EXTRAOBJ +=	$(OBJ)/MmiHomezone.$(OBJ_TAIL)
endif

# aka GPRS
ifeq ($(PMODE),2)
BMIOBJ +=	$(OBJ)/MmiGprs.$(OBJ_TAIL)
EXTRAOBJ +=	$(OBJ)/MmiGprs.$(OBJ_TAIL)
endif

ifeq ($(EM),1)
BMIOBJ +=	$(OBJ)/MmiEm.$(OBJ_TAIL)
EXTRAOBJ +=	$(OBJ)/MmiEm.$(OBJ_TAIL)
endif
	
ifeq ($(ETXT),1)
BMIOBJ += 	$(OBJ)/MmiDictionary.$(OBJ_TAIL)
EXTRAOBJ += 	$(OBJ)/MmiDictionary.$(OBJ_TAIL)
# SH - Only compile MmiLatinPredText.c if new editor is switched OFF
ifeq ($(NEWED),0)
BMIOBJ +=	$(OBJ)/MmiLatinPredText.$(OBJ_TAIL)
EXTRAOBJ +=	$(OBJ)/MmiLatinPredText.$(OBJ_TAIL)
endif
endif

ifeq ($(CHIMMI),1)
BMIOBJ += $(OBJ)/MmiChineseInput.$(OBJ_TAIL)
EXTRAOBJ += $(OBJ)/MmiChineseInput.$(OBJ_TAIL)
endif

ifeq ($(MELGEN),1)
BMIOBJ += 	$(OBJ)/MmiMelodygeneratorMain.$(OBJ_TAIL)
EXTRAOBJ += 	$(OBJ)/MmiMelodygeneratorMain.$(OBJ_TAIL)
endif

ifeq ($(GAME),1)
BMIOBJ += 	$(OBJ)/Mmigame.$(OBJ_TAIL)
EXTRAOBJ += 	$(OBJ)/Mmigame.$(OBJ_TAIL)
endif

ifeq ($(WAP),1)
BMIWAPOBJ =	$(OBJ)/wap_codec.$(OBJ_TAIL)
EXTRAOBJ +=	$(OBJ)/wap_codec.$(OBJ_TAIL)

WAPOBJ =	$(OBJ)/MmiWapFfs.$(OBJ_TAIL) \
		$(OBJ)/ATBWapAUI.$(OBJ_TAIL) \
		$(OBJ)/ATBWapACI.$(OBJ_TAIL) \
		$(OBJ)/AUIWap.$(OBJ_TAIL)
BMIOBJ += $(WAPOBJ)
EXTRAOBJ += $(WAPOBJ)
endif
		
#
# Creating bmi.lib
#
# Note: AR reached its limit in terms of command line length so we need to 
# split the creation of $(BMI_LIB) into 2 steps: initial creation of a new 
# library; then separate addition of "extra" objects. There are therefore 
# 2 groups of objects - one for compilation (BMIOBJ/BMIWAPOBJ), and one for 
# archiving (COREOBJ/EXTRAOBJ). AR does allow a 'command file' to be used 
# instead of the command line; however, this has its own file formatting 
# requirements and line length limits (neither of which are very clear) and
# there is no ready access to individual object file names, so the 
# "COREOBJ/EXTRAOBJ" method is used - for now. Something similar is done in 
# the ACI.

$(TOP_DIR)/$(BMI_LIB) : $(OBJ) $(COREOBJ) $(EXTRAOBJ)
	-$(PERL) $(CONDAT_DIR)/int/bin/make_ver.pl
	@cp ver.$(OBJ_TAIL) $(subst /,$(SLASH),$(OBJ)/ver.$(OBJ_TAIL))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(BMI_LIB) $(patsubst $(OBJ)/%,%,$(COREOBJ))
	cd $(subst /,$(SLASH),$(OBJ)) $(DELIMITER) $(AR) r $(TOP_DIR)/$(BMI_LIB) $(patsubst $(OBJ)/%,%,$(EXTRAOBJ) ver.$(OBJ_TAIL))

$(OBJ):	
	mkdir $(subst /,$(SLASH),$(OBJ))
	
clean: 
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))

$(BMIOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCBMI)/%.c
	echo -D$(NCONFIG) >  cmd
#HHV: Added FF_SAT_E for compilation of BMI. Must be removed after TCS4 merge!!!
	echo -DFF_SAT_E >> cmd
#	echo $(MY_OPTIONS) >> cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DTRGT_G23 >> cmd
	echo -DAUS_CONDAT_TYPE_PORTING >> cmd
	echo -DUSE_WIP_MALLOC >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(IAUS) >> cmd
	echo -I$(IGLE) >> cmd
	echo -I$(IAUSC) >> cmd
	echo -I$(SRCWAP) >> cmd
	echo -I$(SRCATB) >> cmd
	echo -I$(TOP_DIR)/zi/include >> cmd
	echo $(INCLAYER4) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCACIDTI) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

$(BMIWAPOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCWAP)/%.c
	echo -D$(NCONFIG) >  cmd
#	echo $(MY_OPTIONS) >> cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DTRGT_G23 >> cmd
	echo -DAUS_CONDAT_TYPE_PORTING >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(IAUS) >> cmd
	echo -I$(IAUSC) >> cmd
	echo -I$(IGLE) >> cmd
	echo -I$(SRCWAP) >> cmd
	echo -I$(SRCATB) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -I$(SRCACIEXT) >> cmd
	echo -I$(SRCACIDTI) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

# files to be added for MMS
# $(OBJ)/MmiMMSMenu.$(OBJ_TAIL) \
# $(OBJ)/MmiEMSCreate.$(OBJ_TAIL) \
# $(OBJ)/MmiMMSCreate.$(OBJ_TAIL) \
# $(OBJ)/MmiMMSBox.$(OBJ_TAIL) \
# $(OBJ)/Auiwapmms.$(OBJ_TAIL) \
# $(OBJ)/MmiMMSom.$(OBJ_TAIL) \
# $(OBJ)/MmiWindow.$(OBJ_TAIL) \
# $(OBJ)/MmiMmsSetting.$(OBJ_TAIL) 
# $(OBJ)/AUIWap.$(OBJ_TAIL)\
# $(OBJ)/AUIWapPush.$(OBJ_TAIL)
# $(OBJ)/MmiMP3Test.$(OBJ_TAIL) 
