/*******************************************************************************

					Texas Instrument - SH

********************************************************************************                                                                              

 This software product is the property of TI Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    AUIWapMMS.c
 $Revision:		                                                      
                                                                              
 $Author:		TISH                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
  	The user interface for WAP MMS.
                        
********************************************************************************

 $History: AUIWapMMS.c

    xrashmic 27 Jan, 2006 MMI-SPR-OMAPS00053357     
    To delete the please wait screen when we start receving a mms while we are trying to send one.
 
     xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
     Sepearted the call back funtion for the sending and receving mms info dialog screns.
 
     Jun 30 2005  REF:  MMI-SPR-30212  x0012849
     Display 100% sent before displaying MMS sent.

    Jun 30 2005  REF:  MMI-SPR-30213  x0012849
    To avoid "connecting" dialog coming up while receiving MMS .

     May 11 2005  REF:  MMI-SPR-29887  x0012849
     To Implement the deferred MMS retrieval.

    xreddymn Mar-05-2005 MMI-SPR-26144
    Added changes for cancel sending MMS
xreddymn May-15-2005 MMI-SPR-30962: Added changes to maintain WAP busy state
    during MMS transactions.

       Mar 22 2005  REF: MMI-SPR-29368  x0012849
       Description :when receiving MMS. Between the message "receiving MMS" and "New MMS",
       there is a short second that the screen will turn white. 
       Solution : Instead of deleting and drawing a new window update the window contents.

    xreddymn Mar-05-2005 MMI-SPR-26144
    Added changes for cancel sending MMS

       Feb 28 2005  REF: MMI-SPR-28222  x0012849
       To avoid showing a dialog box saying New MMS received, when it is actually not there in inbox.
      
       xrashmic 08 Feb, 2005 MMI-SPR-27853
       Error handling in sending MMS and also displaying the progress value

	xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
	All the status screen, .i.e sending, receiving etc. are displayed separatly for the MMS module.
	Previously the WAP screens were being used. 

	29/09/03 - TISH - Created
	   
 $End

*******************************************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else  /* NEW_FRAME */

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif /* NEW_FRAME */

#include "mfw_sys.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "mfw_sms.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_cm.h"

#include "dspl.h"

#include "wapmic_types.h"

#include "MmiMmi.h"
#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "mmiCall.h"

#include "MmiMenu.h"
#include "MmiSoftKeys.h"
#include "MmiResources.h"

#include "MmiBlkLangDB.h"
#include "MmiBookUtils.h"
//#include "MmiEditor.h"
//#include "MmiEditor_i.h"
#include "MmiBookShared.h"
#include "ATBData.h"
#include "ATBWapAUI.h"
#include "mmiSmsMenu.h"
#include "mmismssend.h"
#include "AUIWapext.h"
#include "AUIWap.h"
//xrashmic 08 Feb, 2005 MMI-SPR-27853
#include "MmiDialogs.h"

#ifdef MMI_GPRS_ENABLED
#include "MmiGprs.h"
#endif

#include "cus_aci.h"
#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "mmiColours.h"
#include "font_bitmaps.h"


#if 0
typedef signed int    INT16;
typedef signed long     INT32;
typedef unsigned long   UINT32;

#include "capiclnt.h"

#endif
#ifdef FF_MMI_MMS 
// Jun 23 2005  REF:  MMI-SPR-29887  x0012849
UBYTE rtvprogressValue=0;  
char AUI_MMS_rtv_progress_string[8];
extern BOOL is_downloadcancelled;
void AUI_mms_wap_start_cb(UBYTE result);
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern int progressValue;
void AUI_mms_error_dialog(SHORT errorCode);
// May 12 2005  REF:  MMI-SPR-29887  x0012849
extern BOOL is_deferdownload;   

/*******************************************************************************

 $Function:    	AUI_mms_wap_start

 $Description:	Start MMS
 				SPR#2088 - TISH - Added
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

//xmzhou02 static void AUI_mms_wap_start_cb(UBYTE result)
void AUI_mms_wap_start_cb(UBYTE result)
{
	T_WAP_DATA *data;
	
	TRACE_FUNCTION("AUI_mms_wap_start_cb");

	if (!result)
	{
		TRACE_EVENT("*** Failed to start up for WAP PUSH ***");
		return;
	}

	data = AUI_wap_data();

    //to do
	return;
}
void AUI_mms_wap_start()
{

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_mms_wap_start()");
#endif

	AUI_wap_start(WAP_MMS, (T_WAP_CB)AUI_mms_wap_start_cb);

	return;
}

// xreddymn Mar-05-2005 MMI-SPR-26144: Changes for cancel sending MMS
void AUI_mms_cancel_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
void mms_post_error(void);
void AUI_mms_status_notify(int status);
char AUI_MMS_progress_string[8];
// May 11 2005  REF:  MMI-SPR-29887  x0012849
void AUI_mms_recieve_cancel_cb(T_MFW_HND win, USHORT identifier, USHORT reason); 

/*******************************************************************************

 $Function:    	AUI_mms_send_progress

 $Description:	Displays progress for MMS send

 $Returns:		None.

 $Arguments:	progress: an integer value between 0 and 100
*******************************************************************************/

void AUI_mms_send_progress(int progress)
{
	progressValue=progress;
//  AUI_mms_status_notify(MMS_SEND_PROGRESS);
}

/*******************************************************************************

 $Function:    	AUI_mms_send_start

 $Description:	Displays the initial "connecting" dialog

 $Returns:		None.

 $Arguments:	None.
*******************************************************************************/

void AUI_mms_send_start(void)
{
	progressValue=0;
	AUI_mms_status_notify(MMS_SEND_START);
}

/*******************************************************************************

 $Function:    	AUI_wap_net_send_ind

 $Description:	Displays progress for MMS send

 $Returns:		None.

 $Arguments:	None.
*******************************************************************************/

void AUI_wap_net_send_ind(void)
{
	T_WAP_DATA 	*data = AUI_wap_data();
	// xreddymn May-19-2005 MMI-SPR-29887: Call AUI_mms_status notify only
	// during a MMS send operation
	if( (data->mms_win != NULL) && ((MMS_TYPE_SEND_START == data->mms_win_type) || (MMS_TYPE_SEND_PROGRESS == data->mms_win_type)) )
	{
		AUI_mms_status_notify(MMS_SEND_PROGRESS);
	}
}

// xreddymn May-15-2005 MMI-SPR-30962: external functions
extern void MMS_set_WAP_busy(void);
extern void MMS_reset_WAP_busy(void);
extern void MMS_process_push_queue(void);

/*******************************************************************************

 $Function:    	AUI_mms_status_notify

 $Description:	
xrashmic 08 Feb, 2005 MMI-SPR-27853
MMS send/rcv state is displayed to the user here
All calls to AUI_wap_status_notify is routed to this function for MMS module
xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42

 $Returns:		None.

 $Arguments:	 
*******************************************************************************/
void AUI_mms_status_notify(int status)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
    T_MFW_HND win_handle;
    T_MFW_WIN      * win_data ;
    T_dialog_info  * mms_info_dialog_data  ;
    
  	if (!data)
	{
		return;
	}
	
	switch (status)
	{
              // May 11 2005  REF:  MMI-SPR-29887  x0012849
              // Control comes to this case immediately after coming to know that the retrieval condition is deferred
              case MMS_NOTIFICATION_PROGRESS:  
                        TRACE_EVENT("MMS_NOTIFICATION_PROGRESS");
                        data->mms_win_type = MMS_TYPE_NOTIFICATION_PROGRESS;
			   break;		   
              // May 11 2005  REF:  MMI-SPR-29887  x0012849
              // Control comes to here once the Notification is responded 
              case MMS_NOTIFICATION_RECEIVED:  
                    TRACE_EVENT("MMS_NOTIFICATION_RECEIVED");
                     if(MMS_TYPE_NOTIFICATION_PROGRESS == data->mms_win_type)
                     {
                             //xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		              //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
          		       data->mms_win=information_dialog(TxtNew,TxtMMSNotification,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_RIGHT,(T_VOID_FUNC)AUI_mmsrcv_cb);
	        	       data->mms_win_type = MMS_TYPE_NOTIFICATION_RECEIVED; 
                     }					 

                     break;
              case MMS_PLEASEWAIT:
                        data->mms_win_type = MMS_TYPE_PLEASEWAIT;
            		   data->mms_win=information_dialog(TxtPleaseWait,TxtNull,NULL,NULL,TxtNull,TxtNull,FOREVER,0,NULL);		
                    break;
      		case MMS_SEND_PROGRESS:	
					// If user has canceled sending MMS, do not display any more dialogs
                    if(data->mms_cancel) break;

                    // xreddymn Mar-05-2005 MMI-SPR-26144
                    // Handle the "connecting" dialog box
                    if((MMS_TYPE_PLEASEWAIT == data->mms_win_type) || (MMS_TYPE_SEND_START == data->mms_win_type))
                    {
                         SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
                         data->mms_win_type = MMS_TYPE_NONE;
                    }
                    // xreddymn Mar-05-2005 MMI-SPR-26144
                    // Display MMS send progress in percentage
                    if(progressValue < 0)
                    {
                        progressValue = 0;
                    }
                    if(progressValue > 100)
                    {
                        progressValue = 100;
                    }
                    sprintf(AUI_MMS_progress_string, "%d", progressValue);
                    strcat(AUI_MMS_progress_string, "%");
	
                     if(MMS_TYPE_NONE == data->mms_win_type)
                    {
                        data->mms_win=information_dialog(TxtMMSSendng, TxtNull, NULL, AUI_MMS_progress_string, TxtNull, TxtCancel, FOREVER, KEY_RIGHT|KEY_HUP, (T_VOID_FUNC)AUI_mms_cancel_cb);
                        data->mms_win_type = MMS_TYPE_SEND_PROGRESS;
	        	           win_data     = ((T_MFW_HDR *) data->mms_win)->data;
                           mms_info_dialog_data         = (T_dialog_info *)win_data->user;
                    }
                     else if(MMS_TYPE_SEND_PROGRESS == data->mms_win_type)
                    {
                           win_data     = ((T_MFW_HDR *) data->mms_win)->data;
                           mms_info_dialog_data         = (T_dialog_info *)win_data->user;
                           dspl_Enable(0);
                           winShow(data->mms_win);
                           dspl_Enable(1);
                   }
                   break;
		// xreddymn Feb-25-2005 MMI-SPR-26144: This is displayed while waiting for WAP to connect
		case MMS_SEND_START:
                   //  Jun 30 2005  REF:  MMI-SPR-30213  x0012849
                   //  To avoid "connecting" dialog coming up while receiving MMS .
                   if(MMS_TYPE_PLEASEWAIT == data->mms_win_type)
                   {
                       SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0); 
                       data->mms_win=information_dialog(TxtConnecting,TxtNull,NULL,NULL,TxtNull,TxtNull,FOREVER,0,(T_VOID_FUNC)AUI_mms_cancel_cb);
                       data->mms_win_type = MMS_TYPE_SEND_START;
                   }
                   break;					 
		case MMS_SEND_SUCCESS:
                         // xreddymn Mar-05-2005 MMI-SPR-26144: Handle "please wait" 
                         // and "connecting" windows
			dspl_Enable(0);
			if((MMS_TYPE_SEND_PROGRESS == data->mms_win_type) || (MMS_TYPE_PLEASEWAIT == data->mms_win_type) || (MMS_TYPE_SEND_START == data->mms_win_type))
			{
                            // Jun 30 2005  REF:  MMI-SPR-30212  x0012849
                           // Display 100% sent before displaying MMS sent.
        			       progressValue=100;  
                            sprintf(AUI_MMS_progress_string, "%d", progressValue);  
                            strcat(AUI_MMS_progress_string, "%");
				SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
                            data->mms_win=information_dialog(TxtMMSSendng, TxtNull, NULL, AUI_MMS_progress_string, TxtNull, TxtNull, ONE_SECS, TxtNull,NULL ); 
				data->mms_win_type = MMS_TYPE_NONE;
			}
			data->mms_win_type = MMS_TYPE_SEND_SUCCESS;
			//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
                    //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
			data->mms_win = information_dialog(TxtMMS,TxtMMSSendSucess,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_RIGHT,(T_VOID_FUNC)AUI_mmssend_cb);	
			dspl_Enable(1);
			break;
		case MMS_RECEIVE_PROGRESS:	
			//xrashmic 27 Jan, 2006 MMI-SPR-OMAPS00053357     
			//To delete the please wait screen when we start receving a mms while we are trying to send one.
			   if(MMS_TYPE_NONE != data->mms_win_type && MMS_TYPE_RECIEVE_PROGRESS != data->mms_win_type)
	                 {
	                         SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
	                         data->mms_win_type = MMS_TYPE_NONE;
	                  }
			TRACE_EVENT("MMS_RECEIVE_PROGRESS");
                    // May 12 2005  REF:  MMI-SPR-29887  x0012849
                    // When The MMS_RECEIVE_PROGRESS
                    if(TRUE == is_deferdownload )						
                    {
                        // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
                        //Display the progress while retrieving MMS.
		          if(FALSE == is_downloadcancelled)     
                 	   {
                            sprintf(AUI_MMS_rtv_progress_string, "%d", rtvprogressValue);  
                            strcat(AUI_MMS_rtv_progress_string, "%");							
                            if(MMS_TYPE_NONE == data->mms_win_type)
                            {                     
  		                 data->mms_win=information_dialog(TxtMMSRetrieving,TxtNull,NULL,AUI_MMS_rtv_progress_string,TxtNull,TxtCancel, FOREVER, KEY_RIGHT|KEY_HUP, (T_VOID_FUNC)AUI_mms_recieve_cancel_cb);		
                               data->mms_win_type = MMS_TYPE_RECIEVE_PROGRESS;
	        	          win_data     = ((T_MFW_HDR *) data->mms_win)->data;
                               mms_info_dialog_data         = (T_dialog_info *)win_data->user;
                             }
                            else if(MMS_TYPE_RECIEVE_PROGRESS == data->mms_win_type)
                            {
                               win_data     = ((T_MFW_HDR *) data->mms_win)->data;
                               mms_info_dialog_data         = (T_dialog_info *)win_data->user;
                               dspl_Enable(0);
                               winShow(data->mms_win);
                               dspl_Enable(1);
                            }
		
             	          }
		       }
                    else
                    {			
			  data->mms_win_type = MMS_TYPE_RECIEVE_PROGRESS;
			  data->mms_win=information_dialog(TxtMMSDownloading,TxtMMSDots,NULL,NULL,TxtNull,TxtNull,FOREVER,0,NULL);		
                    }
			break;
		case MMS_RECEIVE_SUCCESS:	
			TRACE_EVENT("MMS_RECEIVE_SUCCESS");
                    // May 12 2005  REF:  MMI-SPR-29887  x0012849
                    // Instead of showing NewMMS, show MMS Retrieved.                     
                     if(TRUE ==  is_deferdownload)  
                    	{                    	
		         if(MMS_TYPE_RECIEVE_PROGRESS == data->mms_win_type)
        		   {
        			SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
        			data->mms_win_type = MMS_TYPE_NONE;
        		    }
			    data->mms_win_type=MMS_TYPE_RECIEVE_SUCCESS;
                          is_deferdownload=FALSE;
  			     //xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		            //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
			     data->mms_win = information_dialog(TxtMMSRetrieved, TxtNull, NULL, NULL, TxtNull, TxtNull, FIVE_SECS, 0, (T_VOID_FUNC)AUI_mmsrcv_cb);		
                   	}
		       else
		       {		
                    // Mar 22 2005  REF: MMI-SPR-29368  x0012849			
                    //Instead of Destroying and drawing a new window to diaply new MMS , update the erlier window contents. 
		     data->mms_win_type = MMS_TYPE_RECIEVE_SUCCESS;
                     win_data     = ((T_MFW_HDR *) data->mms_win)->data;
                     mms_info_dialog_data         = (T_dialog_info *)win_data->user;
                     mms_info_dialog_data->TextId= TxtNewMMS;
                     mms_info_dialog_data->TextId2 = TxtNull;
			//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
	              //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
                     mms_info_dialog_data->Callback=(T_VOID_FUNC)AUI_mmsrcv_cb;
		     mms_info_dialog_data->Time = FOREVER;
		     mms_info_dialog_data->KeyEvents = KEY_RIGHT;
		     mms_info_dialog_data->RightSoftKey= TxtSoftBack;
                     dspl_Enable(0);
                     winShow(data->mms_win);
                     dspl_Enable(1);		 
		      	}
		     break;
		  //xrashmic 23 Feb, 2005 MMI-SPR-28222
                // Added support to display the receive fail for MMS
		case MMS_RECEIVE_FAIL:
                    // May 12 2005  REF:  MMI-SPR-29887  x0012849
                    // Instead of showing Receive Failed show Retrieve Failed                
		 
                    if((data->mms_win_type != MMS_TYPE_RECIEVE_FAILED) && (data->mms_win_type != MMS_TYPE_ERROR))
                        {
        			if(MMS_TYPE_RECIEVE_PROGRESS == data->mms_win_type)
        			{
        				SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
        				data->mms_win_type = MMS_TYPE_NONE;
        			}
                            data->mms_win_type = MMS_TYPE_RECIEVE_FAILED;
                          if(TRUE == is_deferdownload)  
                    	     {
                    	         //xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
  		                //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
                    	          is_deferdownload=FALSE;
        			  data->mms_win = information_dialog(TxtRetrieve, TxtFailed, NULL, NULL, TxtNull, TxtNull, FIVE_SECS, 0, (T_VOID_FUNC)AUI_mmsrcv_cb);
                   	      }
 		            else 	
 		            	{
				  	//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
			              //Sepearted the call back funtion for the sending and receving mms info dialog screns.	
	        			data->mms_win = information_dialog(TxtMMS, TxtMMSRcvFail, NULL, NULL, TxtNull, TxtSoftBack, FOREVER, KEY_RIGHT, (T_VOID_FUNC)AUI_mmsrcv_cb);		
			      	}
                        }
                    // xreddymn May-15-2005 MMI-SPR-30962: Clear WAP busy state once MMS transaction is complete
                    MMS_reset_WAP_busy();
                    MMS_process_push_queue();
                    break;		
                //xrashmic 23 Feb, 2005 MMI-SPR-28222
                // Added support to display the receive fail for MMS when MMS folder is full
              case MMS_NO_MEMORY:
                        if(data->mms_win_type != MMS_TYPE_RECIEVE_FAILED)
                        {
        			if(MMS_TYPE_RECIEVE_PROGRESS == data->mms_win_type)
        			{
        				SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
        				data->mms_win_type = MMS_TYPE_NONE;
        			}
                              data->mms_win_type = MMS_TYPE_RECIEVE_FAILED;
				//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		              //Sepearted the call back funtion for the sending and receving mms info dialog screns.			  
        			data->mms_win = information_dialog(TxtNewMMS, TxtErrorOutOfMem, NULL, NULL, TxtNull, TxtSoftBack, FOREVER, KEY_RIGHT, (T_VOID_FUNC)AUI_mmsrcv_cb);		
                        }
                break;
		case MMS_SEND_FAIL:
		case ATB_WAP_DEACTIVATING:
		case ATB_WAP_ATTACH_FAILED:
		case ATB_WAP_ERROR:
		case ATB_WAP_ACTIVATE_FAILED:	
			// xreddymn Feb-17-2005 MMI-SPR-26144: handle errors when sending MMS
			mms_post_error();
            dspl_Enable(0); // Disable screen refresh while we change dialogs
            // xreddymn Mar-07-2005 MMI-SPR-26144: Modified this so that Error
            //    dialog is displayed if FFS write failed when sending MMS
			if(data->mms_cancel)
			{
				data->mms_cancel=0;
				if((MMS_TYPE_SEND_PROGRESS==data->mms_win_type)||(MMS_TYPE_PLEASEWAIT==data->mms_win_type))
			{
				SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
				data->mms_win_type=MMS_TYPE_NONE;
			}
			}
			else
			{        
                		AUI_mms_error_dialog(MMS_ERROR);
            		}
            // xreddymn May-15-2005 MMI-SPR-30962: Clear WAP busy state once MMS transaction is complete
            MMS_reset_WAP_busy();
            MMS_process_push_queue();
            
            dspl_Enable(1); // Enable screen refresh after invoking the new dialog
            break;
		default:
			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_mms_error_dialog

 $Description:	
//xrashmic 08 Feb, 2005 MMI-SPR-27853
The mms send/rcv failure are displayed here
 All calls to AUI_error_dialog is routed to this function for MMS module
//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42

 $Returns:		None.

 $Arguments:	 
*******************************************************************************/
void AUI_mms_error_dialog(SHORT errorCode)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	int txtId=TxtNull;
	TRACE_EVENT("AUI_mms_error_dialog");

	if (!data)
	{
		return;
	}
	
	if(MMS_TYPE_SEND_PROGRESS == data->mms_win_type || MMS_TYPE_PLEASEWAIT == data->mms_win_type || MMS_TYPE_SEND_START == data->mms_win_type)
	{
		txtId=TxtMMSSendFail;
	}
	else if(data->mms_win_type == MMS_TYPE_RECIEVE_PROGRESS)
	{
		txtId=TxtMMSRcvFail;				
	}
	
	if(MMS_TYPE_RECIEVE_PROGRESS == data->mms_win_type || MMS_TYPE_SEND_PROGRESS == data->mms_win_type || data->mms_win_type==MMS_TYPE_PLEASEWAIT || MMS_TYPE_SEND_START == data->mms_win_type)
	{
		SEND_EVENT(data->mms_win, DIALOG_DESTROY, 0, 0);	
		data->mms_win_type = MMS_TYPE_NONE;
	}
	
     // May 25 2005  REF:  MMI-SPR-29887  xrashmic
     // Display Retrieve failed instead of recieve failed.
	if(txtId != TxtNull && data->mms_win_type != MMS_TYPE_ERROR) 
	{
		data->mms_win_type = MMS_TYPE_ERROR;
		if(TRUE == is_deferdownload && txtId==TxtMMSRcvFail)
		{ 
			is_deferdownload=FALSE;
			//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		       //Sepearted the call back funtion for the sending and receving mms info dialog screns.
			data->mms_win = information_dialog(TxtRetrieve, TxtFailed, NULL, NULL,
				TxtNull, TxtNull, FIVE_SECS, 0, (T_VOID_FUNC)AUI_mmsrcv_cb);
		}
		else
		{
		       //xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
		       //Sepearted the call back funtion for the sending and receving mms info dialog screns.
			if(txtId == TxtMMSRcvFail)
				data->mms_win=information_dialog(TxtMMS,txtId,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_RIGHT,(T_VOID_FUNC)AUI_mmsrcv_cb);		
			else
				data->mms_win=information_dialog(TxtMMS,txtId,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_RIGHT,(T_VOID_FUNC)AUI_mmssend_cb);		
		}
	}
	return;

}

#endif

