/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    MmiWapFfs.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Data structures, constants and function prototypes for WAP flash handling.
                        
********************************************************************************

 $History: MmiWapFfs.h

     May 11 2005  REF:  MMI-SPR-29887  x0012849
     To Implement the deferred MMS retrieval.
	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/

#ifndef _DEF_MMI_FFS_H_
#define _DEF_MMI_FFS_H_

/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#ifndef NEPTUNE_BOARD
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/
#include "ffs/ffs.h"
/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#else
#include "ffs.h"
#endif
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/

#ifndef ATBDATA
#include "ATBData.h"
#endif

/* FlashDataWap - Data structure for WAP Data file */
 
typedef struct
{
	UBYTE			ProfileId;				/* Last profile used */
	UBYTE			Status;					/* Stores status flags, inc save history, scale images */
	UBYTE			no_of_profiles;			/* Number of profiles stored */
	UBYTE			no_of_history;			/* Number of history entries */
	USHORT 			History[MAX_HISTORY][CARD_TITLE_MAX_LEN+NUMBER_PADDING+1];		/* History card names */
	char			HistoryURL[MAX_HISTORY][URL_MAX_LEN+1];			/* History URLs */
	UBYTE			no_of_bookmarks;									/* Number of bookmarks */
	USHORT 			Bookmarks[MAX_BOOKMARKS][CARD_TITLE_MAX_LEN+1];	/* Bookmark card names */
	char			BookmarksURL[MAX_BOOKMARKS][URL_MAX_LEN+1];		/* Bookmark URLs */
} FlashDataWap;

/* FlashDataWapProfiles - Data structure for WAP Profiles file */

typedef struct
{
	T_WAP_PROFILE	Profile[MAX_PROFILES];
} FlashDataWapProfiles;

#ifdef FF_MMI_MMS
//TISHMMS Project
// May 11 2005  REF:  MMI-SPR-29887  x0012849
// Structure used to store the MMS retrieval type
typedef struct
{
    BOOL  retrieval_type;  // 0= Immediate 1= Deferred.
} FlashDataMmsRetrievalType;
typedef struct
{
    T_MMS_PROFILE   Profile[MAX_PROFILES];
} FlashDataMmsProfiles;
#endif

extern FlashDataWap *WapData;
extern FlashDataWapProfiles *WapProfilesData;

#ifdef FF_MMI_MMS
//TISHMMS Project
extern FlashDataMmsProfiles *MmsProfilesData;
#endif

/* Flash access routines */

T_FFS_RET flash_wap_init();
T_FFS_RET flash_wap_write();
T_FFS_SIZE flash_wap_read();


#ifdef FF_MMI_MMS
//TISHMMS Project
 // May 11 2005  REF:  MMI-SPR-29887  x0012849
 // prototypes of 2 functions
T_FFS_SIZE flash_mms_retrieval_type_read(BOOL *RetrievalType); 
T_FFS_RET flash_mms_retrieval_type_write(BOOL RetrievalType);  
T_FFS_SIZE flash_mms_read();
T_FFS_RET flash_mms_write();
#endif

#endif



