/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    MmiWapFfs.c
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Flash handling for WAP.
                        
********************************************************************************

 $History: MmiWapFfs.c

      May 11 2005  REF:  MMI-SPR-29887  x0012849
      To Implement the deferred MMS retrieval.    
	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/

#define ENTITY_MFW

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif


#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#include "mfw_sys.h"
#include "prim.h"

#include "vsi.h"

#include "mfw_mfw.h"
#include "mfw_win.h"

#include "mfw_kbd.h"
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_lng.h"
#include "mfw_tim.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_phb.h"
#include "mfw_cm.h"
#include "mfw_sim.h"
#include "mfw_nm.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_sat.h"

#include "mfw_ffs.h"

#include "dspl.h"

#include "gdi.h"

#include "MmiMmi.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"

#include "MmiSoftKeys.h"
#include "Mmiicons.h"
#include "MmiMenu.h"
#include "MmiMain.h"
#include "MmiIdle.h"
#include "MmiStart.h"
#include "MmiPins.h"
#include "MmiSounds.h"
#include "audio.h"
#include "cus_aci.h"

#include "MmiWapFfs.h"

#ifndef PCm_2_FFS
#include "ffs_coat.h"
#endif

#define hCommACI _ENTITY_PREFIXED(hCommACI)

#if defined (NEW_FRAME)
EXTERN T_HANDLE hCommACI;
#else
EXTERN T_VSI_CHANDLE hCommACI;
#endif
#define hCommMMI  hCommACI


/* WAP data stored in two files */

FlashDataWap *WapData;
FlashDataWapProfiles *WapProfilesData;
#ifdef FF_MMI_MMS 
    FlashDataMmsProfiles *MmsProfilesData; 
// May 11 2005  REF:  MMI-SPR-29887  x0012849
// MmsRetrievalType is used while Reading or writing Data from flash regarding retrieval type.
   FlashDataMmsRetrievalType *MmsRetrievalType; 
#endif


/*************************************************************************
 * flash_wap_init()
 * 
 * Init function for WAP flash file.
 * If the 'tmp' directory does not exist, create it.
 * If it does exist, and there is a copy of wapdata in 'tmp' directory, it is removed.
 *
 *************************************************************************/
 
T_FFS_RET flash_wap_init()
{
	T_FFS_RET result;
	T_FFS_STAT stat;

	TRACE_FUNCTION("flash_wap_init()");

	/* Check if wapdata file exists and is correct size
	 * If the size of the WAP data changes or it is corrupted, it is deleted
	 * so a new file can be written in its place later. */
	
	result = ffs_stat("/mmi/wapdata", &stat);

	TRACE_EVENT_P1("ffs_stat wapdata, result = %d", result);

	if (result==EFFS_OK)
	{
		if (stat.size==sizeof(FlashDataWap))
		{
			TRACE_EVENT("wapdata found OK & is correct size");
		}
	}
	
	/* Try to reconstruct intact file, in case of interrupted
	 * save operation */

	else
	{
		result = ffs_stat("/mmi/wapdata.zzz",&stat);
		TRACE_EVENT_P1("ffs_stat wapdata.zzz', result = %d", result);
		
		if (result==EFFS_OK)
		{
			if (stat.size==sizeof(FlashDataWap))
			{
				TRACE_EVENT("wapdata.zzz found OK & is correct size");
				result = ffs_rename("/mmi/wapdata", "/mmi/wapdata.zzz");
				TRACE_EVENT_P1("rename '/mmi/wapdata' to '/mmi/wapdata.zzz': result %d", result);
			}
			else
			{
				TRACE_EVENT("wapdata.zzz found, but size is incorrect");
			}
		}
		else
		{
			TRACE_EVENT("wapdata.zzz not found.");
		}
	}	

	/* WAP PROFILES */
	
	/* Check if wapprof file exists and is correct size */
	
	result = ffs_stat("/mmi/wapprof", &stat);

	TRACE_EVENT_P1("ffs_stat wapprof, result = %d", result);

	if (result==EFFS_OK)
	{
		if (stat.size==sizeof(FlashDataWapProfiles))
		{
			TRACE_EVENT("wapprof found OK & is correct size");
		}
	}
	
	/* Try to reconstruct intact file, in case of interrupted
	 * save operation */

	else
	{
		result = ffs_stat("/mmi/wapprof.zzz",&stat);
		TRACE_EVENT_P1("ffs_stat wapprof.zzz', result = %d", result);
		
		if (result==EFFS_OK)
		{
			if (stat.size==sizeof(FlashDataWapProfiles))
			{
				TRACE_EVENT("waprof.zzz found OK & is correct size");
				result = ffs_rename("/mmi/wapprof", "/mmi/wapprof.zzz");
				TRACE_EVENT_P1("rename '/mmi/wapprof' to '/mmi/wapprof.zzz': result %d", result);
			}
			else
			{
				TRACE_EVENT("wapprof.zzz found, but size is incorrect");
			}
		}
		else
		{
			TRACE_EVENT("wapprof.zzz not found.");
		}
	}
	
	return result;
}


/*************************************************************************
 * flash_wap_write()
 *
 * Write WAP data to file.
 *
 *************************************************************************/

T_FFS_RET flash_wap_write()
{	
	T_FFS_RET result;

	/* Procedure to minimise data corruption */

	/* WAP Data File */
	
	result = ffs_file_write("/mmi/wapdata.zzz",  WapData, sizeof(FlashDataWap), FFS_O_TRUNC | FFS_O_CREATE);
	TRACE_EVENT_P1("write '/mmi/wapdata.zzz': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("** ERROR WRITING FILE **");
		return;
	}

	result = ffs_remove("/mmi/wapdata");
	TRACE_EVENT_P1("remove '/mmi/wapdata': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("/mmi/wapdata does not exist yet");
	}

	result = ffs_rename("/mmi/wapdata.zzz", "/mmi/wapdata");
	TRACE_EVENT_P1("rename '/mmi/wapdata.zzz' to '/mmi/wapdata': result %d", result);

	if (result!=EFFS_OK)
	{
		if (result==EFFS_NOTFOUND)
		{
			TRACE_EVENT("mmi/wapdata.zzz doesn't exist");
		}
		else
		{
			TRACE_EVENT("** ERROR RENAMING FILE **");
		}
	}

	/* WAP Profiles File */
	
	result = ffs_file_write("/mmi/wapprof.zzz",  WapProfilesData, sizeof(FlashDataWapProfiles), FFS_O_TRUNC | FFS_O_CREATE);
	TRACE_EVENT_P1("write '/mmi/wapprof.zzz': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("** ERROR WRITING FILE **");
		return;
	}

	result = ffs_remove("/mmi/wapprof");
	TRACE_EVENT_P1("remove '/mmi/wapprof': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("/mmi/wapprof does not exist yet");
	}

	result = ffs_rename("/mmi/wapprof.zzz", "/mmi/wapprof");
	TRACE_EVENT_P1("rename '/mmi/wapprof.zzz' to '/mmi/wapprof': result %d", result);

	if (result!=EFFS_OK)
	{
		if (result==EFFS_NOTFOUND)
		{
			TRACE_EVENT("mmi/wapprof doesn't exist");
		}
		else
		{
			TRACE_EVENT("** ERROR RENAMING FILE **");
		}
	}
	
	return;
}

/*************************************************************************
 * flash_wap_read()
 *
 * Read WAP data from file.
 *
 *************************************************************************/

T_FFS_SIZE flash_wap_read()
{	
	T_FFS_RET result;
	T_FFS_STAT stat;
	T_FFS_SIZE size;

	/* Read two files. If either file is of the wrong size, return 0 */
	 
	/* WAP Data File */

	/* Check if wapdata file exists and is correct size */
	
	result = ffs_stat("/mmi/wapdata", &stat);
	
	if (result!=EFFS_OK || stat.size!=sizeof(FlashDataWap))
	{
		TRACE_EVENT("mmi/wapdata does not exist or is not correct size");
		return 0;
	}

	/* Read the file */

	size = ffs_file_read("/mmi/wapdata",  WapData, sizeof(FlashDataWap));
	TRACE_EVENT_P1("Read 'mmi/wapdata': result %d", size);

	/* WAP Profiles File */

	/* Check if wapprof file exists and is correct size */
	
	result = ffs_stat("/mmi/wapprof", &stat);

	if (result!=EFFS_OK || stat.size!=sizeof(FlashDataWapProfiles))
	{
		TRACE_EVENT("mmi/wapprof does not exist or is not correct size");
		return 0;
	}

	/* Read the file */
	
	size = ffs_file_read("/mmi/wapprof",  WapProfilesData, sizeof(FlashDataWapProfiles));
	TRACE_EVENT_P1("Read 'mmi/wapprof': result %d", size);
	
	return size;
}

#ifdef FF_MMI_MMS 
//TISHMMS Project begin

// May 11 2005  REF:  MMI-SPR-29887  x0012849
/*******************************************************************************
 $Function:     flash_mms_retrieval_type_read
 $Description:  This function is called when user wants to know the status of the Retrieval Type
                       and each a time MMS is recieved .
 $Returns:        Result of the rename file operation 
 $Arguments:  RetrievalType - 0- For Immediate  &  1 for Deferred 
*******************************************************************************/

T_FFS_SIZE flash_mms_retrieval_type_read(BOOL *RetrievalType)
{	

	T_FFS_RET result;
	T_FFS_STAT stat;
	T_FFS_SIZE size;	

	/* Check if mmsretieval file exists and is correct size */
	
	result = ffs_stat("/mmi/mmsretrieval", &stat);

	if (result!=EFFS_OK || stat.size!=sizeof(FlashDataMmsRetrievalType))
	{
		TRACE_EVENT("mmi/mmsretrieval does not exist or is not correct size");
		return 0;
	} 

	/* Read the file */
	size = ffs_file_read("/mmi/mmsretrieval",  MmsRetrievalType, sizeof(FlashDataMmsRetrievalType));
       *RetrievalType = MmsRetrievalType ->retrieval_type;
	TRACE_EVENT_P1("Read 'mmi/mmsretrieval ': result %d", size);
	
	return size;
}/* end of flash_mms_retrieval_type_read*/

// May 11 2005  REF:  MMI-SPR-29887  x0012849
/*******************************************************************************
 $Function:     flash_mms_retrieval_type_write

 $Description:  This function is called when user wants to set the Retrieval condition of MMS.
 $Returns:        Result of the rename file operation 
 $Arguments:  RetrievalType - 0- For Immediate  & 1 for Deferred
*******************************************************************************/

T_FFS_RET flash_mms_retrieval_type_write(BOOL RetrievalType)
{
	T_FFS_RET result;
    
	MmsRetrievalType->retrieval_type=RetrievalType;	
	result = ffs_file_write("/mmi/mmsretrieval.zzz",  MmsRetrievalType, sizeof(FlashDataMmsRetrievalType), FFS_O_TRUNC | FFS_O_CREATE);
	TRACE_EVENT_P1("write '/mmi/mmsretrieval.zzz': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("** ERROR WRITING FILE **");
		return result;
	}

	result = ffs_remove("/mmi/mmsretrieval");
	TRACE_EVENT_P1("remove '/mmi/mmsretrieval': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("/mmi/mmsretrieval does not exist yet");
	}

	result = ffs_rename("/mmi/mmsretrieval.zzz", "/mmi/mmsretrieval");
	TRACE_EVENT_P1("rename '/mmi/mmsretrieval.zzz' to '/mmi/mmsretrieval': result %d", result);

	if (result!=EFFS_OK)
	{
		if (EFFS_NOTFOUND == result)
		{
			TRACE_EVENT("mmi/mmsretrieval doesn't exist");
		}
		else
		{
			TRACE_EVENT("** ERROR RENAMING FILE **");
		}
	}
	
	return result;
}/* end of flash_mms_retrieval_type_write */

T_FFS_SIZE flash_mms_read()
{	

	T_FFS_RET result;
	T_FFS_STAT stat;
	T_FFS_SIZE size;	

	/* Check if mmsprof file exists and is correct size */
	
	result = ffs_stat("/mmi/mmsprof", &stat);

	if (result!=EFFS_OK || stat.size!=sizeof(FlashDataMmsProfiles))
	{
		TRACE_EVENT("mmi/mmsprof does not exist or is not correct size");
		return 0;
	}

	/* Read the file */
	size = ffs_file_read("/mmi/mmsprof",  MmsProfilesData, sizeof(FlashDataMmsProfiles));
	TRACE_EVENT_P1("Read 'mmi/mmsprof': result %d", size);
	
	return size;
}/* end of flash_mms_read */

T_FFS_RET flash_mms_write()
{
	T_FFS_RET result;
    
	/* MMS Profiles File */
	
	result = ffs_file_write("/mmi/mmsprof.zzz",  MmsProfilesData, sizeof(FlashDataMmsProfiles), FFS_O_TRUNC | FFS_O_CREATE);
	TRACE_EVENT_P1("write '/mmi/mmsprof.zzz': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("** ERROR WRITING FILE **");
		return;
	}

	result = ffs_remove("/mmi/mmsprof");
	TRACE_EVENT_P1("remove '/mmi/mmsprof': result %d", result);

	if (result!=EFFS_OK)
	{
		TRACE_EVENT("/mmi/mmsprof does not exist yet");
	}

	result = ffs_rename("/mmi/mmsprof.zzz", "/mmi/mmsprof");
	TRACE_EVENT_P1("rename '/mmi/mmsprof.zzz' to '/mmi/mmsprof': result %d", result);

	if (result!=EFFS_OK)
	{
		if (result==EFFS_NOTFOUND)
		{
			TRACE_EVENT("mmi/mmsprof doesn't exist");
		}
		else
		{
			TRACE_EVENT("** ERROR RENAMING FILE **");
		}
	}
	
	return;
}/* end of flash_mms_write */
//TISHMMS Project
//modification end
#endif
