/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   VOICEMEMO
 $File:       MmiVoiceMemo.c
 $Revision:   1.0

 $Author:   Condat(UK)
 $Date:       09/04/01

********************************************************************************

 Description:

    This provides the start code for the MMI

********************************************************************************
 $History: MmiVoiceMemo.c

  09/04/01      Original Condat(UK) BMI version.

 $End

*******************************************************************************/




/*******************************************************************************

                                Include files

*******************************************************************************/
#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#include "mfw_sys.h"

#include "prim.h"

#include "cus_aci.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_lng.h"
#include "mfw_tim.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_phb.h"
#include "mfw_cm.h"
#include "mfw_sim.h"
#include "mfw_nm.h"
#include "mfw_sat.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_cphs.h"
#include "mfw_sat.h"

#include "dspl.h"


#include "MmiMmi.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiIdle.h"
#include "MmiSoftKeys.h"
#include "Mmiicons.h"
#include "MmiMenu.h"
#include "MmiMain.h"
#include "MmiStart.h"
#include "MmiPins.h"
#include "MmiSettings.h"

#include "gdi.h"
#include "audio.h"
#include "MmiSounds.h"
#include "MmiResources.h"
#include "mmiColours.h"

//#include "vmd.h"
#include "MmiVoiceMemo.h"
#include "mfw_ffs.h"

/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#ifndef NEPTUNE_BOARD
/* END ADD: Req ID: : Sumit : 14-Mar-05 */
#include "Audio/audio_api.h"
/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#endif /* NEPTUNE_BOARD*/
/* END ADD: Req ID: : Sumit : 14-Mar-05 */

#include "mfw_aud.h"

/*******************************************************************************

                                internal data

*******************************************************************************/

/*
 * Internal events
 */
#define VM_INIT           500
#define VM_DESTROY       501
#define VM_PLAY           502
#define VM_RECORD         503
#define VM_DELETE_BUFFER  504

#define VOICE_MEMO_MAX_DURATION 10					// 10 Secs


typedef struct
{
  T_MMI_CONTROL   mmi_control;
  T_MFW_HND       parent_win;
  T_MFW_HND       info_win;
  T_MFW_HND       info_tim;
  T_MFW_HND       info_kbd;
  USHORT          Identifier;
  USHORT          time;
  char         elapsed_time[7];
  int			  play_sk2;
} T_voice_memo;




/*******************************************************************************

                                Local prototypes

*******************************************************************************/


T_MFW_HND       voice_memo_start  (T_MFW_HND  parent_win, SHORT ID);
static T_MFW_HND    voice_memo_create (T_MFW_HND  parent_win);
static void       voice_memo_destroy  (T_MFW_HND  own_window);
static void       voice_memo      (T_MFW_HND  win, USHORT event, SHORT value, void * parameter);
static int        voice_memo_win_cb (T_MFW_EVENT event, T_MFW_WIN * win);
static T_MFW_CB     voice_memo_tim_cb (T_MFW_EVENT event, T_MFW_TIM * tc);
static int        voice_memo_kbd_cb (T_MFW_EVENT event, T_MFW_KBD * keyboard);
static void			voice_memo_dialog_create(T_MFW_HND win, int str1, int str2);
void          voice_memo_dialog_cb (T_MFW_HND win, UBYTE identifier, UBYTE reason);

/*
** Rivera Callback functions
*/
static void voice_memo_riv_record_cb(void *parameter);
static void voice_memo_riv_play_cb(void *parameter);



/*******************************************************************************

 $Function:     voice_memo_init

 $Description:

 $Returns:

 $Arguments:

*******************************************************************************/
GLOBAL void voice_memo_init (void)
{
  TRACE_FUNCTION ("voice_memo_init()");
}

/*******************************************************************************

 $Function:     voice_memo_exit

 $Description:


 $Returns:

 $Arguments:

*******************************************************************************/
GLOBAL void voice_memo_exit (void)
{
  TRACE_FUNCTION ("voice_memo_exit()");

}




/*******************************************************************************

 $Function:     voice_memo_play

 $Description:

 $Returns:

 $Arguments:

*******************************************************************************/
GLOBAL int  voice_memo_play (MfwMnu* m, MfwMnuItem* i)
{
  T_MFW_HND win = mfw_parent(mfw_header());

  TRACE_FUNCTION ("voice_memo_play()");

  //create a new voice memo dialog
  voice_memo_start (win, VM_PLAY);
  return 1;  // ADDED BY RAVI - 29-11-2005
}



/*******************************************************************************

 $Function:     voice_memo_record

 $Description:


 $Returns:

 $Arguments:

*******************************************************************************/
GLOBAL int voice_memo_record (MfwMnu* m, MfwMnuItem* i)
{

  T_MFW_HND win = mfw_parent(mfw_header());


  TRACE_FUNCTION ("voice_memo_record()");

  //create a new voice memo dialog
  voice_memo_start (win, VM_RECORD);
  return 1;  // RAVI - 29-11-2005
}


/*******************************************************************************

 $Function:     voice_memo_start

 $Description:  create a new voicememo dialog

 $Returns:    Dialogue info win

 $Arguments:  parent win, display info

*******************************************************************************/
T_MFW_HND voice_memo_start (T_MFW_HND  parent_win, SHORT ID)
{
  T_MFW_HND win;

  win = voice_memo_create (parent_win);

  if (win NEQ NULL)
  {
    SEND_EVENT (win, VM_INIT, ID, 0);
  }
  return win;
}



/*******************************************************************************

 $Function:     vocie_memo_create

 $Description:  Creation of window

 $Returns:    Dialogue info win

 $Arguments:  parent win

*******************************************************************************/
static T_MFW_HND voice_memo_create (T_MFW_HND parent_win)
{
  T_MFW_WIN     * win_data;
  T_voice_memo *  data = (T_voice_memo *)ALLOC_MEMORY (sizeof (T_voice_memo));

  TRACE_FUNCTION ("vocie_memo_create()");

  data->info_win = win_create (parent_win, 0, E_WIN_VISIBLE, (T_MFW_CB)voice_memo_win_cb);

  if (data->info_win EQ 0)
    return 0;

  /*
   * Create window handler
   */
  data->mmi_control.dialog   = (T_DIALOG_FUNC)voice_memo;
  data->mmi_control.data     = data;
  data->parent_win           = parent_win;
  win_data                   = ((T_MFW_HDR *)data->info_win)->data;
  win_data->user             = (void *)data;

  /*
  ** Initialise values to safe defualts
  */
  data->play_sk2 = TxtSoftBack;
	
  /*
   * return window handle
   */
  return data->info_win;
}


/*******************************************************************************

 $Function:     voice_memo_destroy

 $Description:  Destruction of an dialog

 $Returns:    void

 $Arguments:  win

*******************************************************************************/
void voice_memo_destroy (T_MFW_HND own_window)
{
  T_MFW_WIN     * win  = ((T_MFW_HDR *)own_window)->data;
  T_voice_memo * data   = (T_voice_memo *)win->user;

  TRACE_FUNCTION ("voice_memo_destroy()");

	if (own_window == NULL)
	{
		TRACE_EVENT ("Error : Called with NULL Pointer");
		return;
	}

  if (data)
  {
    /*
     * Exit TIMER & KEYBOARD Handle
     */
    kbd_delete (data->info_kbd);
    tim_delete (data->info_tim);

    /*
     * Delete WIN Handler
     */
    win_delete (data->info_win);
    /*
     * Free Memory
     */
    FREE_MEMORY ((void *)data, sizeof (T_voice_memo));
  }
}



/*******************************************************************************

 $Function:     voice_memo

 $Description:  Dialog function for voice memo dialog

 $Returns:    void

 $Arguments:  win, window handle event, value, parameter

*******************************************************************************/
void voice_memo (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
  T_MFW_WIN      * win_data     = ((T_MFW_HDR *)win)->data;
  T_voice_memo    * data         = (T_voice_memo *)win_data->user;

 // T_DISPLAY_DATA display_info;   // RAVI
  
  SHORT	mfw_aud_retVal;

  data->Identifier = value;

  TRACE_FUNCTION ("voice_memo()");

  switch (event)
  {
    case VM_INIT:
    TRACE_EVENT ("VM_INIT()");
      /*
       * Initialize dialog
       */

      /*
       * Create timer and keyboard handler
       */
    data->info_tim = tim_create (win, 1000, (T_MFW_CB)voice_memo_tim_cb);
    data->info_kbd = kbd_create (win, KEY_ALL, (T_MFW_CB)voice_memo_kbd_cb);


    if (value EQ VM_PLAY)
    {
      TRACE_EVENT ("VM_PLAY()");
	  
	  mfw_aud_retVal = mfw_aud_vm_start_playback(voice_memo_riv_play_cb);
	  
	  if (mfw_aud_retVal == MFW_AUD_VM_OK)
      {
        //start the second timer
        data->time = 0;
	    tim_start (data->info_tim);
	    
	    //Set the Right Softkey Id
	    data->play_sk2 = TxtStop;
      }
	  else
	  {
	    if (mfw_aud_retVal == MFW_AUD_VM_MEM_EMPTY)
	    {
	    	voice_memo_dialog_create(win, TxtRecording, TxtEmpty);
	    }
	    else
	    {
	    	//Display a dialog and exit
	    	TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_start_playback failed with return value : %d", mfw_aud_retVal);
	    
	    	voice_memo_dialog_create( win, TxtPlayback, TxtFailed);
	    }
	  }
    }
    else if (value EQ VM_RECORD)
    {
      TRACE_FUNCTION ("VM_RECORD()");
	  
	  mfw_aud_retVal = mfw_aud_vm_start_record(VOICE_MEMO_MAX_DURATION, voice_memo_riv_record_cb);
	  
	  // If the Riviera call failed
	  if (mfw_aud_retVal == MFW_AUD_VM_OK)
	  {
	  	//start the second timer
	  	data->time = 0;
	  	tim_start (data->info_tim);
	  }
	  else
	  {
	  	if (mfw_aud_retVal == MFW_AUD_VM_MEM_FULL)
	    {
	      TRACE_EVENT ("memory full ");
/* RAVI - 20-1-2006 */
/* Silent Implementation */
#ifdef NEPTUNE_BOARD
             audio_PlaySoundID(0, TONES_KEYBEEP, getCurrentVoulmeSettings(), 
                                              AUDIO_PLAY_ONCE ); /* GW#2355 /CQ11341 */
#else
	      /* play Keybeep */
	      audio_PlaySoundID(0, TONES_KEYBEEP, 200, AUDIO_PLAY_ONCE ); /* GW#2355 /CQ11341 */
#endif
/* END RAVI */
	  
	  	  voice_memo_dialog_create( win, TxtRecording, TxtFull );
	    }
	    else
	    {
	      //Display a dialog and exit
	      TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_start_record failed with return value : %d", mfw_aud_retVal);
	    
	      voice_memo_dialog_create( win, TxtRecording, TxtFailed );
	    }
      }
    }
    win_show (win);
      break;


  //if the user selected to clear the Voicememo buffer
    case VM_DELETE_BUFFER:
	voice_memo_dialog_create( win, TxtDeleted, TxtNull );

	/*
	** Delete the voice memo file
	*/
	mfw_aud_vm_delete_file();
  break;

    case VM_DESTROY:
    voice_memo_destroy(win);
  break;
  }
}

/*******************************************************************************

 $Function:     voice_memo_win_cb

 $Description:  Callback function for information dialog

 $Returns:    void

 $Arguments:  window handle event, win
*******************************************************************************/
static int voice_memo_win_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
    T_voice_memo * data = (T_voice_memo *)win->user;

    TRACE_FUNCTION ("voice_memo_win_cb()");

    if (data EQ 0)
  return 1;

    switch (event)
  {
  case E_WIN_VISIBLE:
      if (win->flags & E_WIN_VISIBLE)
    {
        /*
         * Clear Screen
         */
        dspl_ClearAll();

      switch (data->Identifier)
      {
        case VM_PLAY:
            /*
             * Print the information screen
             */
					ALIGNED_PROMPT(LEFT,Mmi_layout_line(1),0, TxtPlayback);

            /*
             * Print the elapsed time
             */
				    displayAlignedText(LEFT, Mmi_layout_line(2), 0, data->elapsed_time);

            /*
             * Print softkeys
             */
					displaySoftKeys(TxtDelete, data->play_sk2);
          break;

        case VM_RECORD:
            /*
             * Print the information screen
             */
					ALIGNED_PROMPT(LEFT,Mmi_layout_line(1),0, TxtRecording);

            /*
             * Print the elapsed time
             */
				    displayAlignedText(LEFT, Mmi_layout_line(2), 0, data->elapsed_time);

            /*
             * Print softkeys
             */
            displaySoftKeys(TxtStop, '\0');
          break;
      }

    }
      break;

  default:
      return 0;
  }
    return 1;
}


/*******************************************************************************

 $Function:     voice_memo_tim_cb

 $Description:  Callback function for the voice_memo timer.


 $Returns:    MFW event handler

 $Arguments:  window handle event, timer control block

*******************************************************************************/
static T_MFW_CB voice_memo_tim_cb (T_MFW_EVENT event, T_MFW_TIM *tc)
{
  T_MFW_HND       win  = mfw_parent (mfw_header());
  T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
  T_voice_memo   * data = (T_voice_memo *)win_data->user;

	SHORT	mfw_aud_retVal;

//  char buf[40];   // RAVI

    TRACE_FUNCTION ("voice_memo_tim_cb()");

  switch (data->Identifier)
  {
    case VM_PLAY:
      //the max. playback time is 10 second
			if (data->time < mfw_aud_vm_get_duration())
      {
          TRACE_EVENT ("continue the second timer");

        data->time ++;
        // it shows here the elapsed time
        sprintf(data->elapsed_time,"%02d sec", data->time);

          TRACE_EVENT (data->elapsed_time);

        //continue the second timer
        tim_start (data->info_tim);
      }
      else
      {
		data->play_sk2 = TxtSoftBack;
#ifndef _SIMULATION_
		/*
		** Stop playing the Voice Memo.
		*/
		mfw_aud_retVal = mfw_aud_vm_stop_playback(voice_memo_riv_play_cb);

		if (mfw_aud_retVal != MFW_AUD_VM_OK)
			TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_stop_playback failed with return value : %d", mfw_aud_retVal);
#else
		TRACE_EVENT("call mfw_aud_vm_stop_playback()");
#endif
      }
      break;


    case VM_RECORD:

	  data->time++;
	  
	  if (data->time < VOICE_MEMO_MAX_DURATION)
      {
          TRACE_EVENT ("continue the second timer");

        // it shows here the remainig time
		sprintf(data->elapsed_time,"%02d sec", (VOICE_MEMO_MAX_DURATION - data->time));

          TRACE_EVENT (data->elapsed_time);

        //continue the second timer
        tim_start (data->info_tim);
      }
      else
      {
		mfw_aud_vm_set_duration(VOICE_MEMO_MAX_DURATION);
				
#ifndef _SIMULATION_
		/*
		** Stop recording the Voice Memo.
		*/
		mfw_aud_retVal = mfw_aud_vm_stop_record(voice_memo_riv_record_cb);

		if (mfw_aud_retVal != MFW_AUD_VM_OK)
			TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_stop_record failed with return value : %d", mfw_aud_retVal);
/* RAVI - 20-1-2006 */
#ifdef NEPTUNE_BOARD
              audio_PlaySoundID(0, TONES_KEYBEEP, getCurrentVoulmeSettings(),
                                               AUDIO_PLAY_ONCE ); /* GW#2355 /CQ11341 */
#else
		/*the voice memo is now full, show "memory full" */
		audio_PlaySoundID(0, TONES_KEYBEEP, 200, AUDIO_PLAY_ONCE ); /* GW#2355 /CQ11341 */
#endif
/* END RAVI */

		voice_memo_dialog_create( win, TxtRecording, TxtFull );
#else
		TRACE_EVENT("call mfw_aud_vm_stop_record()");
#endif
      }
      break;
  }

  //Update the screen
  winShow(win);

  return 0;
}


/*******************************************************************************

 $Function:     voice_memo_kbd_cb

 $Description:  Keyboard event handler

 $Returns:    status int

 $Arguments:  window handle event, keyboard control block

*******************************************************************************/

static int voice_memo_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
  T_MFW_HND       win  = mfw_parent (mfw_header());
  T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
  T_voice_memo   * data = (T_voice_memo *)win_data->user;

  USHORT          Identifier = data->Identifier;
	SHORT			mfw_aud_retVal;


  TRACE_FUNCTION("voice_memo_kbd_cb");

  switch (keyboard->code)
  {
  case KCD_HUP:
    case KCD_LEFT:
    if (Identifier EQ VM_PLAY)
    {
#ifndef _SIMULATION_
	  /*
	  ** Stop playing the Voice Memo and Delete it.
	  */
	  mfw_aud_retVal = mfw_aud_vm_stop_playback(voice_memo_riv_play_cb);
	  
	  if (mfw_aud_retVal != MFW_AUD_VM_OK)
	  	TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_stop_playback failed with return value : %d", mfw_aud_retVal);
#else
	  TRACE_EVENT("call mfw_aud_vm_stop_playback()");
#endif
      //delete the voicememo buffer
	  mfw_aud_vm_set_duration(0);

      //user selected the delete-key
      SEND_EVENT (win, VM_DELETE_BUFFER, 0, 0);
    }
    else if (Identifier EQ VM_RECORD)
    {
	  mfw_aud_vm_set_duration(data->time);
	  
#ifndef _SIMULATION_
	  /*
	  ** Stop recording the Voice Memo.
	  */
	  mfw_aud_retVal = mfw_aud_vm_stop_record(voice_memo_riv_record_cb);
	  
	  if (mfw_aud_retVal != MFW_AUD_VM_OK)
	  	TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_stop_record failed with return value : %d", mfw_aud_retVal);
	  
	  //go back to the previous dialog
	  SEND_EVENT (win, VM_DESTROY, 0, 0);
#else
	  TRACE_EVENT("call mfw_aud_vm_stop_record()");
#endif
    }
       break;

    case KCD_RIGHT:
    if (Identifier EQ VM_PLAY)
    {

#ifndef _SIMULATION_
	  /*
	  ** Stop playing the Voice Memo.
	  */
	  mfw_aud_retVal = mfw_aud_vm_stop_playback(voice_memo_riv_play_cb);
	  
	  if (mfw_aud_retVal != MFW_AUD_VM_OK)
	  	TRACE_EVENT_P1 ("ERROR : mfw_aud_vm_stop_playback failed with return value : %d", mfw_aud_retVal);
#else
	  TRACE_EVENT("call mfw_aud_vm_stop_playback()");
#endif

      //go back to the previous dialog
      SEND_EVENT (win, VM_DESTROY, 0, 0);
    }
    else if (Identifier EQ VM_RECORD)
    {
      //nothing
    }
       break;

    default:
       break;
  }
  return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:     voice_memo_dialog_cb

 $Description:

 $Returns:

 $Arguments:

*******************************************************************************/
void voice_memo_dialog_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
  TRACE_FUNCTION ("voice_memo_dialog_cb()");

      switch (reason)
      {
        case INFO_KCD_LEFT:
          /* no break; */
        case INFO_TIMEOUT:
          /* no break; */
        case INFO_KCD_HUP:
          /* no break; */
        case INFO_KCD_RIGHT:
          /* no break; */
        case INFO_KCD_CLEAR:

        //go back to the previous dialog
      SEND_EVENT (win, VM_DESTROY,0, 0);

          break;
      }
}


/*******************************************************************************

 $Function:     voice_memo_dialog_create

 $Description:

 $Returns:

 $Arguments:

*******************************************************************************/
static void voice_memo_dialog_create(T_MFW_HND win, int str1, int str2)
{
	T_DISPLAY_DATA display_info;
	
	TRACE_FUNCTION ("voice_memo_dialog_create()");

	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, str1, str2, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)voice_memo_dialog_cb, THREE_SECS, KEY_CLEAR | KEY_RIGHT | KEY_LEFT );
	/*
	* Call Info Screen
	*/
	info_dialog (win, &display_info);
}

static void voice_memo_riv_record_cb(void *parameter)
{
/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#ifndef NEPTUNE_BOARD
/* END ADD: Req ID: : Sumit : 14-Mar-05 */

	T_AUDIO_VM_RECORD_STATUS *record_status;

	record_status = (T_AUDIO_VM_RECORD_STATUS *)parameter;

	if (record_status->status != AUDIO_OK)
	{
		TRACE_EVENT_P1("ERROR : voice_memo_riv_play_cb received AUDIO_ERROR, recorded duration is %d",
						 record_status->recorded_duration);
	}
	else
	{
		TRACE_EVENT_P1("INFO : voice_memo_riv_play_cb received AUDIO_OK, recorded duration is %d",
						 record_status->recorded_duration);

		mfw_aud_vm_set_duration((UINT8)record_status->recorded_duration);
	}
/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#endif /* NEPTUNE_BOARD */
/* END ADD: Req ID: : Sumit : 14-Mar-05 */

}

static void voice_memo_riv_play_cb(void *parameter)
{
/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#ifndef NEPTUNE_BOARD
/* END ADD: Req ID: : Sumit : 14-Mar-05 */

	T_AUDIO_VM_PLAY_STATUS *play_status;

	play_status = (T_AUDIO_VM_PLAY_STATUS *)parameter;

	if (play_status->status != AUDIO_OK)
	{
		TRACE_EVENT("ERROR : voice_memo_riv_play_cb received AUDIO_ERROR");
	}
	else
	{
		TRACE_EVENT("INFO : voice_memo_riv_play_cb received AUDIO_OK");
	}
/* BEGIN ADD: Req ID: : Sumit : 14-Mar-05 */
#endif /* NEPTUNE_BOARD*/
/* END ADD: Req ID: : Sumit : 14-Mar-05 */

}


