/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		Softkeys
 $File:		    MmiSoftkeys.c
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    22/02/01                                                      
                                                                               
********************************************************************************
                                                                              
 Description:

  

********************************************************************************

 $History:

       xrashmic 5 Oct, 2005 MMI-SPR-29356, MMI-SPR-29357
       To display '?' to indicate to the user that help is available for a STK menu

	25/10/00			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/


/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "mfw_sys.h"
#include "prim.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_lng.h"
#include "mfw_phb.h"
#include "mfw_nm.h"
#include "dspl.h"

#include "ksd.h"
#include "psa.h"


#include "MmiMmi.h"
#include "MmiMain.h"

#include "MmiUserData.h"
#include "MmiSoftKeys.h"
#include "MmiResources.h"

#include "mmiColours.h"

typedef struct
{
    MfwHnd leftKeyHandler;
    MfwHnd rightKeyHandler;

    LangTxt leftKeyLabel;
    LangTxt rightKeyLabel;
} SoftKeysData, *SoftKeys;


#ifdef LSCREEN
#define HorizontalOffset 4
#else
#define HorizontalOffset 1
#endif
#define LeftMargin       (HorizontalOffset)
#define RightMargin      (HorizontalOffset)

#define ALLOC_MEMORY mfwAlloc
#define FREE_MEMORY  mfwFree

static U8    softKeyFont              = 0;
static UBYTE softKeysDisplayAttibutes = DSPL_TXTATTR_NORMAL;


/*
 * Change the <font> and <displayAttibutes> for _all_ softkeys.
 * All consecutive calls of softKeysUpdate() will reflect the change.
 * Returns SOFTKEYS_CHANGED when everything went fine,
 * or SOFTKEYS_FAILURE on failure.
 */
SoftKeysResult softKeysAttributes( U8 font, UBYTE displayAttibutes)
{
    if( font == (U8)-1 )
    {
        return SOFTKEYS_FAILURE;
    }

    softKeyFont              = font;
    softKeysDisplayAttibutes = displayAttibutes;

    return SOFTKEYS_CHANGED;
}


/*
 * Creates the softkeys for <window>, which will display the
 * <leftKeyLabel> and <rightKeyLabel> in the softkey area
 * on the screen, and invoke <leftKeyCallBack> or <rightKeyCallBack>
 * when the approrpiate key is pressed. Returns SOFTKEYS_CREATED when
 * everything went fine, or SOFTKEYS_FAILURE on failure.
 */
SoftKeysResult softKeysHndCreate( MfwHnd window, SoftKeysSetup *setup)
{
	if( window == NULL || setup == NULL )
    {
        return SOFTKEYS_FAILURE;
    }

	return softKeysWinCreate( (MfwWin *)((MfwHdr *)window)->data, setup);
}


SoftKeysResult softKeysWinCreate( MfwWin *window, SoftKeysSetup *setup)
{
    SoftKeys newKeys;

    if( window == NULL || setup == NULL )
    {
        return SOFTKEYS_FAILURE;
    }

    newKeys = (SoftKeys)ALLOC_MEMORY(sizeof(SoftKeysData));

    if( newKeys == NULL )
    {
        return SOFTKEYS_FAILURE;
    }

    if( userDataWinSet( window, UD_SOFTKEYS, (void *)newKeys) == NULL )
    {
        FREE_MEMORY( (void *)newKeys, sizeof(SoftKeysData));

        return SOFTKEYS_FAILURE;
    }

    newKeys->leftKeyHandler  = kbdCreate( NULL, KEY_LEFT,
                                          setup->leftKeyCallBack);
    newKeys->rightKeyHandler = kbdCreate( NULL, KEY_RIGHT,
                                          setup->rightKeyCallBack);

    newKeys->leftKeyLabel    = setup->leftKeyLabel;
    newKeys->rightKeyLabel   = setup->rightKeyLabel;

    if( newKeys->leftKeyHandler == NULL || newKeys->rightKeyHandler == NULL )
    {
        kbdDelete(newKeys->leftKeyHandler);
        kbdDelete(newKeys->rightKeyHandler);

        userDataWinDelete( window, UD_SOFTKEYS);

        FREE_MEMORY( (void *)newKeys, sizeof(SoftKeysData));

        return SOFTKEYS_FAILURE;
    }

    return SOFTKEYS_CREATED;
}


/*
 * Change the setup of the softkeys for <window>. Use TxtNull if you
 * don't want to change a ...Label, and NULL if you don't want to change
 * a ...CallBack. Returns SOFTKEYS_CHANGED when everything went fine,
 * or SOFTKEYS_FAILURE on failure.
 */
SoftKeysResult softKeysHndSet( MfwHnd window, SoftKeysSetup *changes)
{
	if( window == NULL || changes == NULL )
    {
        return SOFTKEYS_FAILURE;
    }

	return softKeysWinSet( (MfwWin *)((MfwHdr *)window)->data, changes);
}


SoftKeysResult softKeysWinSet( MfwWin *window, SoftKeysSetup *changes)
{
    SoftKeys softKeys = (SoftKeys)userDataWinGet( window, UD_SOFTKEYS);

    if( window == NULL || softKeys == NULL || changes == NULL )
    {
        return SOFTKEYS_FAILURE;
    }

    if( changes->leftKeyCallBack != NULL )
    {
        MfwHnd NewKeyHandler = kbdCreate( NULL, KEY_LEFT,
                                          changes->leftKeyCallBack);

        if( NewKeyHandler == NULL )
        {
            return SOFTKEYS_FAILURE;
        }
        else
        {
            kbdDelete(softKeys->leftKeyHandler);

            softKeys->leftKeyHandler = NewKeyHandler;
        }
    }

    if( changes->rightKeyCallBack != NULL )
    {
        MfwHnd NewKeyHandler = kbdCreate( NULL, KEY_LEFT,
                                          changes->rightKeyCallBack);

        if( NewKeyHandler == NULL )
        {
            return SOFTKEYS_FAILURE;
        }
        else
        {
            kbdDelete(softKeys->rightKeyHandler);

            softKeys->rightKeyHandler = NewKeyHandler;
        }
    }

    if( changes->leftKeyLabel != TxtNull )
    {
        softKeys->leftKeyLabel = changes->leftKeyLabel;
    }

    if( changes->rightKeyLabel != TxtNull )
    {
        softKeys->rightKeyLabel = changes->rightKeyLabel;
    }

    return SOFTKEYS_CHANGED;
}


/*
 * You will need to call this whenever <window> is updated.
 */
void softKeysHndUpdate(MfwHnd window)
{
	if( window == NULL )
    {
        return;
    }

	softKeysWinUpdate((MfwWin *)((MfwHdr *)window)->data);
}


void softKeysWinUpdate(MfwWin *window)
{
    SoftKeys    softKeys     = (SoftKeys)userDataWinGet( window, UD_SOFTKEYS);
    U8          oldFont      = dspl_SelectFontbyID(softKeyFont);

    if( window == NULL || softKeys == NULL )
    {
        return;
    }

    PROMPT( LeftMargin,Mmi_layout_line(LAST_LINE_TOP), 0, softKeys->leftKeyLabel);

    dspl_SelectFontbyID(oldFont);
}


/*
 * Deletes the softkeys for <window>.
 */
void softkeysHndDelete(MfwHnd window)
{
	if( window == NULL )
    {
        return;
    }

	softkeysWinDelete((MfwWin *)((MfwHdr *)window)->data);
}


void softkeysWinDelete(MfwWin *window)
{
    SoftKeys softKeys = (SoftKeys)userDataWinDelete( window, UD_SOFTKEYS);

    if( window == NULL || softKeys == NULL )
    {
        return;
    }

    kbdDelete(softKeys->leftKeyHandler);
    kbdDelete(softKeys->rightKeyHandler);

    FREE_MEMORY( (void *)softKeys, sizeof(SoftKeysData));
}
typedef struct {
	char* str;
	int posX;
	int posY;
} T_SK_DATA;
typedef struct {
	T_SK_DATA  lsk;
	T_SK_DATA  rsk;
	MfwRect*	rect;
} T_SK_DSPL_STRUCT;

/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
static void softKeys_displayAll(T_SK_DSPL_STRUCT* sk_data , int format, unsigned int colIndex )
{
	resources_setSKColour(colIndex);
//	#ifdef COLOURDISPLAY	
	dspl_Clear(	sk_data->rect->px,
				sk_data->rect->py,
				sk_data->rect->px+sk_data->rect->sx-1,
				sk_data->rect->py+sk_data->rect->sy-1);
	/* Line height must be less than rect.sy */	
//	#endif
	if (sk_data->lsk.str!= NULL)
		dspl_TextOut(sk_data->lsk.posX, sk_data->lsk.posY,DSPL_TXTATTR_CURRENT_MODE, sk_data->lsk.str);
	if (sk_data->rsk.str!= NULL)
		dspl_TextOut(sk_data->rsk.posX, sk_data->rsk.posY,DSPL_TXTATTR_CURRENT_MODE, sk_data->rsk.str);
	resources_restoreMnuColour();
}

/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
void softKeys_displayStrXY(char* leftSoftKey_str,char* rightSoftKey_str, int format, unsigned int colIndex, MfwRect* rect )
{
	MfwRect defRect;
	
	T_SK_DSPL_STRUCT sk_data;
	sk_data.lsk.str = leftSoftKey_str;
	sk_data.rsk.str = rightSoftKey_str;
	if (rect != NULL)
		sk_data.rect = rect;
	else
	{
		Mmi_layout_softkeyArea( &defRect );	
		sk_data.rect = &defRect;
	}
	sk_data.lsk.posY = sk_data.rect->py + (sk_data.rect->sy-Mmi_layout_line_height())/2;
	sk_data.rsk.posY = sk_data.lsk.posY;
	sk_data.lsk.posX = sk_data.rect->px+LeftMargin;
	sk_data.rsk.posX = sk_data.rect->px+sk_data.rect->sx-RightMargin-dspl_GetTextExtent(sk_data.rsk.str, 0);

	softKeys_displayAll( &sk_data , format, colIndex);
}
/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
void softKeys_displayStr(char* leftSoftKey_str,char* rightSoftKey_str, int format, int unsigned colIndex)
{
	softKeys_displayStrXY(leftSoftKey_str, rightSoftKey_str,format,colIndex, NULL);
}

/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
void softKeys_displayId(int leftSoftKey,int rightSoftKey, int format, unsigned int colIndex)
{
	char *lsk,*rsk;
	lsk = MmiRsrcGetText(leftSoftKey);
	rsk = MmiRsrcGetText(rightSoftKey);
	softKeys_displayStrXY(lsk,rsk,format,colIndex,NULL);
}

/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
//Old function - replace with calls to 'softKeys_displayId'
//GW 28/11/02 - Removed commented out code
void displaySoftKeys(int leftSoftKey,int rightSoftKey)
{
	char *lsk,*rsk;
	lsk = MmiRsrcGetText(leftSoftKey);
	rsk = MmiRsrcGetText(rightSoftKey);
	softKeys_displayStrXY(lsk,rsk,0, COLOUR_LIST_SUBMENU, NULL);
}

/*******************************************************************************

 $Function:    	

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
void displaySoftKeysXY(int leftSoftKey,int rightSoftKey,int lskX,int rskX, int lpos)
{
	char *lsk,*rsk;
	MfwRect rect;
	
	lsk = MmiRsrcGetText(leftSoftKey);
	rsk = MmiRsrcGetText(rightSoftKey);
	rect.px = lskX;
	rect.py = lpos;
	rect.sx = rskX-lskX;
	rect.sy = Mmi_layout_softkeyHeight();
	softKeys_displayStrXY(lsk, rsk, 0,COLOUR_LIST_MAIN, &rect);



}


/*******************************************************************************

 $Function:    	displaySoftKeys_edition

 $Description:	
 
 $Returns:		

 $Arguments:	
 				
 $History

*******************************************************************************/
void displaySoftKeys_edition(int leftSoftKey,int index, int rightSoftKey)
{
	char *lsk,*rsk, *ind;
	USHORT lpos;
	
	lsk = MmiRsrcGetText(leftSoftKey);
	ind = MmiRsrcGetText(index);
	rsk = MmiRsrcGetText(rightSoftKey);
	lpos = Mmi_layout_line(SECOND_LAST_LINE_TOP);

	dspl_TextOut(LeftMargin,lpos, 0,lsk);

	dspl_TextOut( 5 + dspl_GetTextExtent(lsk, (USHORT)strlen(lsk)) ,lpos, 0, ind);

    dspl_TextOut((mmiScrX-1)-RightMargin-dspl_GetTextExtent(rsk, (USHORT)strlen(rsk)),lpos ,0, rsk);
}


/*******************************************************************************

 $Function:    	displayCustSoftKeys

 $Description:	Display softkeys with text strings instead of text ID's
 
 $Returns:		None

 $Arguments:	LeftSoftKey -	char array to be displayed at the bottom-left of the display 
 								or NULL if no string is to be displayed
 				RightSoftKey- 	char array to be displayed at the bottom-right of the display
 								or NULL if no string is to be displayed
 				
 $History
  GW 28/11/02 - 

*******************************************************************************/
// SH - 25/5/01
// This function provided for WAP, to allow the printing of custom softkeys
// from strings provided.

void displayCustSoftKeys(char *LeftSoftKey, char *RightSoftKey)
{
	softKeys_displayStrXY(LeftSoftKey,RightSoftKey,0,COLOUR_LIST_MAIN, NULL);
}

        
/*******************************************************************************

 $Function:    	displayHelpSymbol

 $Description:	Displaying '?' to indicate to the user that help is available for a menu
                     xrashmic 5 Oct, 2005 MMI-SPR-29356, MMI-SPR-29357
 
 $Returns:	None

 $Arguments:	None 			
*******************************************************************************/
void displayHelpSymbol(void)
{
    MfwRect defRect, rect;
    U16 line_height;
    T_SK_DSPL_STRUCT sk_data;
    Mmi_layout_softkeyArea( &defRect );	
    rect.px = defRect.sx >> 1;     
    rect.py = defRect.py + 4;
    resources_setSKColour(COLOUR_LIST_XX);
    //Display the symbol in the center between the softkeys
    dspl_TextOut(rect.px, rect.py, DSPL_TXTATTR_CURRENT_MODE, "?");
    resources_restoreMnuColour();

}
