/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   MMI
 $File:       MmiMmi.c
 $Revision:   1.0

 $Author:   Condat(UK)
 $Date:       25/10/00

********************************************************************************

 Description:

    This provides the root mofule for the basic MMI

********************************************************************************
 $History: MmiMmi.c

	Jun 13 2005,	REF:LOCOSTO-OTH-32113	-	xpradipg
	Description:	Bypass the powerkey initialization at bootup
	Solution:		The powerkey initialization is bypassed by calling the
					drvKeyUpDown() in mmi_main() instead of key_power_initialize

//  	Jun 23, 2004        	REF: CRR MMI-SPR-16665  Rashmi C N(Sasken)
// 	Description:		Ocasionaly the LCD used to get stuck with the TI LOGO during power off.
//	Solution:			By calling dspl_Enable(1) we are forcing the LCD to get updated.

  25/10/00      Original Condat(UK) BMI version.

 $End

*******************************************************************************/




/*******************************************************************************

                                Include Files

*******************************************************************************/

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "mfw_sys.h"

#include "prim.h"


#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_lng.h"
#include "mfw_tim.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_phb.h"
#include "mfw_sim.h"
#include "mfw_nm.h"
#include "mfw_mme.h"
#include "mfw_sat.h"
#include "mfw_sms.h"

#include "cus_aci.h"

#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif

#include "ksd.h"
#include "psa.h"


#include "MmiMmi.h"
#include "MmiMain.h"

#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"




#include "dspl.h"
#include "drv_key.h"

#ifdef FF_MMI_MULTIMEDIA
/* To Assign the MSL_Init Return Value */
#include "MSL.h"
#include "mmiMultimediaApp.h"
#include "omxutil.h"
#endif

#ifdef MMI_LITE
#define MFW_MEMORY_POOL_SIZE 22000 /*SPR 2686*/
#else
	#ifdef FF_MMI_MMS
	#define MFW_MEMORY_POOL_SIZE (220*1024)
        #else
		#ifdef FF_MMI_MULTIMEDIA
			#define MFW_MEMORY_POOL_SIZE (220 * 1024)   // RAVI - 18-07-2005 - For Image display
		#else
	#define MFW_MEMORY_POOL_SIZE 35000
	#endif
#endif
#endif


#ifndef _SIMULATION_
extern void AI_Power(unsigned char power);
#endif  //_SIMULATION_

/*******************************************************************************

                                Global Data Elements

*******************************************************************************/

U16 mmiScrX, mmiScrY;                   /* display sreen size       */

static U8 mfwMem [MFW_MEMORY_POOL_SIZE];      /* mfw memory pool          */
static int initialized = 0;             /* initialization flag      */




/*******************************************************************************

                                Public Methods

*******************************************************************************/

/*******************************************************************************

 $Function:     mmi_main

 $Description:  entry point for the MMI, this hands control to mmiInit

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/

void mmi_main( void )
{
    /* JVJ #1874 - mmi_main doesnt start the MMI. It only initilizes the Keyboard handler*/
    /* The keyboard handler will call mmiInit() when the Power Key is pressed */
//    	Jun 13 2005,	REF:LOCOSTO-OTH-32113	-	xpradipg
#if (BOARD == 61)
#if FF_MMI_SERVICES_MIGRATION
	   drvKeyUpDown(0,0);
#else
	 key_power_init();
#endif

#ifndef FF_MMI_MULTIMEDIA
	vsi_t_sleep(VSI_CALLER 50);
	mmiInit();	 
#endif

#else  /* Other Builds */
     key_power_init();
#endif

}



/*******************************************************************************

 $Function:     mmiInit

 $Description:  This initialises the MMI application

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/


void mmiInit( void )
{
#ifdef FF_MMI_MULTIMEDIA
   unsigned int uiResult = 0;
#endif

  /* get the resources running
  */

  /* Initialise the MFW and windowing system
  */
  mfwInit( mfwMem,   sizeof( mfwMem ) );
  winInit( &mmiScrX, &mmiScrY );


  timInit();                          /* init timer handler       */
  kbdInit();                          /* init keyboard handler    */
  lngInit();                          /* init language handler    */
  #ifndef NEW_EDITOR				/* SPR#1428 - SH - New Editor changes */
  edtInit();                          /* init editor handler      */
  #endif /* NEW_EDITOR */
  mnuInit();                          /* init menu handler        */
  icnInit();                          /* init icon handler        */
  mainInit(0);

#ifdef NEPTUNE_BOARD
  sAT_PercentCSQ ( CMD_SRC_LCL, CSQ_Enable );
#endif

#ifdef FF_MMI_MULTIMEDIA
    /* MSL Init Call */
   uiResult = MSL_Init();
   vsi_t_sleep(0, 100);
   mmi_setInitResult(uiResult);

   /* PCM Setup Done */
/*  MSLRM_Start ();  */
#endif

}






/*******************************************************************************

 $Function:     mmiExit

 $Description:  This exits the MMI application

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/





void mmiExit( void )
{
    TRACE_EVENT("mmiExit");

  icnExit();                          /* finit icon handler       */
  mnuExit();                          /* finit menu handler       */
  #ifndef NEW_EDITOR				/* SPR#1428 - SH - New Editor changes */
  edtExit();                          /* finit edit handler       */
  #endif /* NEW_EDITOR */
  lngExit();                          /* finit language handler   */
  kbdExit();                          /* finit keyboard handler   */
  timExit();                          /* finit timer handler      */

  winExit();                          /* finit window handler     */
  mfwExit();                          /* exit mfw                 */

  dspl_ClearAll();
//  	Jun 23, 2004        	REF: CRR MMI-SPR-16665  Rashmi C N(Sasken)
// 	Description:		Ocasionaly the LCD used to get stuck with the TI LOGO during power off.
//	Solution:			By calling dspl_Enable(1) we are forcing the LCD to get updated.
  dspl_Enable(1);
  TRACE_EVENT("SWITCHING_OFF!!!!!");
  vsi_t_sleep (VSI_CALLER 50);
  /*
   *  Power off the board
   *
   */
#ifndef _SIMULATION_
  AI_Power(0);
#endif   //_SIMULATION_

}




/*******************************************************************************

                                End Of File

*******************************************************************************/

