/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI                                                            
 $Module:		MMI
 $File:		    MmiLatinPredText.c
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                         
                                                                               
********************************************************************************
                                                                              
 Description: Latin alphabet predictiev text editor.  English-only for the moment.

  

********************************************************************************

 $History: MmLatinPredText.c
 03/10/02		Replaced most of the file with version on 3.3.3 line (MC, SPR 1242)
	   
 $End

*******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#if defined (NEW_FRAME)

#include "typedefs.h"
#include "Vsi.h"
#include "PEI.H"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "mfw_sms.h"
#include "mfw_ss.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_cm.h"

#include "dspl.h"

#include "ksd.h"
#include "psa.h"


#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiMmi.h"

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
#include "MmiIdle.h"

#include "MmiEditor.h"
#include "MmiEditor_i.h"
#include "MmiDictionary.h"
#include "mmiColours.h"

#include "cus_aci.h"
#include "prim.h"


#ifndef MFW_EVENT_PASSED
#define MFW_EVENT_PASSED 0
#endif

//data structure for punctuation symbols selection screen
typedef struct
{
    T_MMI_CONTROL   mmi_control;
    T_MFW_HND       parent;
    T_MFW_HND       edt_win;
    T_MFW_HND       edt_edt;
    T_MFW_HND       edt_kbd;
    T_MFW_HND       edt_kbd_long;
    T_MFW_HND       edt_tim; // c015 rsa
	T_MFW_HND		edt_input; // RM 25-08

    T_EDITOR_DATA   editor_data;
    UBYTE			cursor_position;
    char* 			output_symbol;
	
}
T_SYMBOL_INFO;

//events in main editor screen
typedef enum
{
   EDITOR_INIT,
   EDITOR_DEINIT,
   EDITOR_UPDATE
} editor_events;

/*********************************************************************
**********************************************************************

                                 DYNAMIC EDITOR WINDOW. DECLARATION

*********************************************************************
**********************************************************************/


//protoypes



static T_MFW_HND SymbolScreencreate (T_MFW_HND  parent);
static int SymbolScreenwin_cb (T_MFW_EVENT event, T_MFW_WIN * win);
static int SymbolScreenkbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard);
static void SymbolScreenexec_cb (T_MFW_HND win, USHORT event, SHORT value, char * symbol);

char SymbolChar;



/*******************************************************************************

 $Function:    	SymbolScreendestroy

 $Description:	Destroy thesymbol screen
 
 $Returns:		None.

 $Arguments:	window handle
 
*******************************************************************************/

void SymbolScreendestroy (T_MFW_HND window)
{
    T_MFW_WIN     * win  = ((T_MFW_HDR *)window)->data;
    T_SYMBOL_INFO * data = (T_SYMBOL_INFO *)win->user;
	char Punctuation_symbol = *data->output_symbol;
    TRACE_FUNCTION ("SymbolScreendestroy()");
    
    
	SEND_EVENT (data->parent, EDITOR_UPDATE,(short)Punctuation_symbol, NULL); 
    if (data)
        {                       
            /*
             * Delete WIN Handler
             */
            win_delete (data->edt_win);
            /*
             * Free Memory
             */
            FREE_MEMORY ((void *)data, sizeof (T_SYMBOL_INFO));
        }
    else
        {
            TRACE_EVENT ("SymbolScreendestroy() called twice");
            return ;
        }
}


/*******************************************************************************

 $Function:    	SymbolScreenstart

 $Description:	Starts the symbol screen
 
 $Returns:		handle

 $Arguments:	parent window, editor data
 
*******************************************************************************/
T_MFW_HND SymbolScreenstart (T_MFW_HND parent, char * symbol)
{
    T_MFW_HND win;
  

    TRACE_FUNCTION ("SymbolScreenstart()");

    win = SymbolScreencreate (parent);
	
    if (win NEQ NULL)
        {
            SEND_EVENT (win, E_EDITOR_INIT, 0, 0);
        }
    return win;
}


/*******************************************************************************

 $Function:    	LatinEditorcreate

 $Description:	Creation of a symbol screen
 
 $Returns:		handle of new window

 $Arguments:	parent window
 
*******************************************************************************/
static T_MFW_HND SymbolScreencreate (T_MFW_HND  parent)
{
    T_SYMBOL_INFO *  data = (T_SYMBOL_INFO *)ALLOC_MEMORY (sizeof (T_SYMBOL_INFO));
    T_MFW_WIN     *  win;

    TRACE_FUNCTION ("SymbolScreencreate()");

    /*
     * Create window handler
     */

    data->edt_win = win_create (parent, 0, E_WIN_VISIBLE, (T_MFW_CB)SymbolScreenwin_cb);

    if (data->edt_win EQ NULL)
    {
        return NULL;
    }

        /* 
     * connect the dialog data to the MFW-window
     */


    		data->mmi_control.dialog = (T_DIALOG_FUNC)SymbolScreenexec_cb;
    		data->mmi_control.data   = data;
    		data->parent             = parent;
    		win                      = ((T_MFW_HDR *)data->edt_win)->data;
    		win->user                = (void *)data;
    		
     return data->edt_win;
}

/*******************************************************************************

 $Function:    	SymbolScreenexec_cb

 $Description:	handles events for symbol window
 
 $Returns:		None.

 $Arguments:	window, event, value, editor data
 
*******************************************************************************/
static void SymbolScreenexec_cb (T_MFW_HND win, USHORT event, SHORT value, char * symbol)
{
    T_MFW_WIN      * win_data  = ((T_MFW_HDR *)win)->data;
    T_SYMBOL_INFO  * data      = (T_SYMBOL_INFO *)win_data->user;

    T_MFW_HND       parent_win = data->parent;
    USHORT          Identifier = data->editor_data.Identifier;
    T_EDIT_CB       Callback   = data->editor_data.Callback;
    char debug[20];
	char* symStr = ".,?!:;-+#*()\'\"_@&$%/<>=";
  
    TRACE_FUNCTION ("SymbolScreenexec_cb()");

    switch (event)
        {
        case E_EDITOR_INIT:
           
           
            /* Note that we do not copy the edited buffer here */
			data->editor_data.editor_attr.predText[0] = '\0';

            /*
             * Create the handler
             */
            data->edt_kbd      = kbd_create (data->edt_win, KEY_ALL,         (T_MFW_CB)SymbolScreenkbd_cb);
            data->edt_edt      = edtCreate  (data->edt_win, &data->editor_data.editor_attr,MfwEdtVisible,0);

            /*
             * Set the mode for the editor
             */
			editor_attr_init(&data->editor_data.editor_attr, 0, edtCurMask, NULL, symStr, strlen(symStr), COLOUR_EDITOR );
            editActivate(data->edt_edt,ALPHA_MODE);  
            data->output_symbol = symbol;
            data->cursor_position = 0;
                             
		   	edtChar(data->edt_edt,ecTop);              /* in read-only mode set cursor to begin  */
            win_show(data->edt_win);

    break;
      
        case E_EDITOR_DEINIT:
        
            	SymbolScreendestroy (data->edt_win);   
            break;

        default:
            break;
    	}
}
/*******************************************************************************

 $Function:    	SymbolScreenwin_cb

 $Description:	Editor window event handler.
 
 $Returns:		status int

 $Arguments:	event, window
 
*******************************************************************************/
static int SymbolScreenwin_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
    T_SYMBOL_INFO * data = (T_SYMBOL_INFO *)win->user;
    TRACE_FUNCTION ("SymbolScreen_win_cb()");
	

      if (data->edt_edt!=activeEditor())
			editActivate(data->edt_edt,data->editor_data.mode);  
    if (data EQ 0)
        {
            return MFW_EVENT_CONSUMED;
        }
   
    switch (event)
        {
        case E_WIN_VISIBLE: /* window is visible  */
            if (win->flags & E_WIN_VISIBLE)
                {
                    /*
                     * Clear Screen
                     */
                    dspl_ClearAll();

                    /*
                     * Print the information 
                     */
                    edtShow(data->edt_edt);
                    
                    /*
                     * Print the softkeys
                     */
	               displaySoftKeys(TxtSoftSelect, TxtSoftBack);
           
                }
            break;
        default:
            return MFW_EVENT_PASSED;
        }
    return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:    	SymbolScreen_kbd_cb

 $Description:	Symbol screen keyboard event handler
 
 $Returns:		None.

 $Arguments:	event, keyborad data
 
*******************************************************************************/
static int SymbolScreenkbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
    T_MFW_HND       win        = mfw_parent (mfw_header());
    T_MFW_WIN     * win_data   = ((T_MFW_HDR *)win)->data;
    T_SYMBOL_INFO * data       = (T_SYMBOL_INFO *)win_data->user;
    char debug[20];
    TRACE_FUNCTION ("SymbolScreen_kbd_cb()");
    
	

                    switch (keyboard->code)
                        {
                        case KCD_MNUUP: 
	                            edtChar(data->edt_edt,ecLeft);
	                            if (data->cursor_position > 0)
	                            	data->cursor_position--;
                            	edtShow(data->edt_edt);
                            break;
            
                        case KCD_MNUDOWN:           
	                        edtChar(data->edt_edt,ecRight);
	                        if (data->cursor_position < strlen(data->editor_data.editor_attr.text))
	                        	data->cursor_position++;
                            edtShow(data->edt_edt);
                            break;
            
                        case KCD_LEFT:
							*data->output_symbol = data->editor_data.editor_attr.text[data->cursor_position];
							SymbolChar = data->editor_data.editor_attr.text[data->cursor_position];
							TRACE_EVENT(debug);
							SymbolScreendestroy(data->edt_win);
                            break;
            
     
            			case KCD_HUP:
                        case KCD_RIGHT:
                             *data->output_symbol = '\0';
                             SymbolChar ='\0' ;
							SymbolScreendestroy(data->edt_win);    
                                
                            break;
  
    }

    return MFW_EVENT_CONSUMED;
}

