/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		Call
 $File:		    MmiIdle.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    25/10/00                                                      
                                                                               
********************************************************************************
                                                                              
 Description:
                        
********************************************************************************

 $History: MmiIdle.h

 	Mar 14, 2006 DR: OMAPS00061468 - x0035544.
   	Description: SAT 27.22.4.22.2 SET UP IDLE MODE TEXT (Icon support) fails 
   	Solution : Added additional parameter to the prototype of  addSatMessage() to hold the display type
   	for  SAT idle text with icon support.

 	Sept 15, 2005    REF: CRR 32410  x0021334
	Description: The keypad unlocks even though the unlocking sequence is not executed in quick succession.
 	Fix:	A new timer expiry event is added and handled.

        xrashmic 26 Aug, 2004 MMI-SPR-23931
        
	25/10/00			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/

/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#else
#include "mfw_edt.h"
#endif
#include "Mmiicons.h" //for T_BITMAP

#ifndef _DEF_MMI_IDLE_H_
#define _DEF_MMI_IDLE_H_

#define EDITOR_SIZE 41					/* SPR761 - SH - Moved from MmiIdle.c, changed to 41 */

typedef enum
{										/* REASONS                  */
 IdleNone = IdleDummy,					/* no reason                */
 IdleNormal,							/* normal idle mode         */
 IdleUpdate,
 IdleSearchNetwork,
 IdleNewSmsMessage,
 IdleActiveKeyPadLocked,
 IdleNewCBImmediateMessage,
 IdleNewCBNormalMessage
};

//	Sept 15, 2005    REF: CRR 32410  x0021334
//	Description: The keypad unlocks even though the unlocking sequence is not executed in quick succession.
// 	Added a new enum member IDLE_KEYPAD_UNLOCK_TIMER_EXPIRED
typedef enum
{										/* REASONS                  */
	IDLE_NO_NETWORK,
	IDLE_UPDATE,
	IDLE_NEW_SMS,
	IDLE_ACTIVE_KEY_PAD_LOCKED,
	IDLE_DETAILS_NUMBER,
	IDLE_DIALLING_INIT,
	IDLE_INFO_ENDED,
	IDLE_KEYPAD_LOCKED_UPDATE,
	IDLE_START_DIALLING_NUMBER,
	IDLE_KEYPAD_UNLOCK_TIMER_EXPIRED 
};

typedef enum
{
    SHOWVERSION_INIT
} Version_events;


#define SHOW_CPRS_DEACTIV   	0
#define SHOW_CPRS_ACITV			1		
#define DONT_SHOW_CPRS			2 //not allowed to show any indication

/*
*  The information related to every window must be encapsulated in such an structure
*/
typedef struct
{
    T_MMI_CONTROL   mmi_control;		// this a common parameter in every structure
	T_MFW_HND win;						// windows handler, another common parameter
	T_MFW_HND kbd;						// To control all of the events, 2 handler are needed kbd that handles the key press
    T_MFW_HND kbd_long;					// event and kbd_long that handles the release and long key event.
#ifdef NEW_EDITOR						/* SPR#1428 - SH - New Editor changes */
	T_ED_DATA *editor;
	T_ED_DATA *editor_sat;
#else /* NEW_EDITOR */
    T_MFW_HND edt;
    T_MFW_HND edt_sat;					/* SPR759 - SH*/
#endif /* NEW_EDITOR */
	T_MFW_HND info_win;
	T_MFW_HND klck_win;				// Keypad Locked Window Handler
	int missedCalls;
	int ems; //xrashmic 26 Aug, 2004 MMI-SPR-23931
	UBYTE search;
	UBYTE flagIdle;
    USHORT nm_status;
	char edt_buf[EDITOR_SIZE];			/* SPR761 - SH - Changed from a number to a constant */
#ifdef NEW_EDITOR						/* SPR#1428 - SH - New Editor changes */
	T_ED_ATTR editor_attr;				/* Dialling editor */
	T_ED_ATTR editor_attr2;				/* CB editor */
	T_ED_ATTR editor_attr3;				/* CLASS 0 SMS editor */
	T_ED_ATTR editor_attr_sat;			/* SAT & Homezone editor */
#else /* NEW_EDITOR */
	MfwEdtAttr edt_attr;				//this one for the dialling editor
	MfwEdtAttr edt_attr2;				//this is for the CB editor
	MfwEdtAttr edt_attr3;				//this is for the (only CLASS 0) SMS editor	
	MfwEdtAttr edt_attr_sat;			/* SPR759 - SH*/
#endif /* NEW_EDITOR */
	char imei[16];
    UBYTE new_sms;
    UBYTE new_cbch;
	CHAR incoming_cb_msg[MAX_CBMSG_LEN]; 
	/*NM, p019*/
	CHAR incoming_sms_msg[MAX_MSG_LEN_SGL]; 	
    UBYTE right_key_pressed;
    UBYTE silent_mode;
    UBYTE clean_screen;
    UBYTE ciphering;
    UBYTE starting_up;                  /*SPR#1662 - NH - New field for checking the start up status */
    CHAR incoming_sat_msg[MAX_CBMSG_LEN];		/* SPR759 - SH*/
    T_BITMAP* idleNetLogo;				//Background for idle screen - NULL if no background.
	T_BITMAP * idleBgd;				//Background image on the idle Screen    
    int defTextOffset;				//start point for text (may vary with bitmap ?)
} T_idle;

extern UBYTE KeyPadLock;

                                        /* PROTOTYPES               */
extern void wake_up_rr(void);

void idleInit (MfwHnd parent);
void idleExit (void);
void idleExec (int reason, MmiState next);
void idleEvent(int reason);
void idleDialBuffer(char* dialBuffer);

MfwHnd idle_get_window(void);

int idleIsFocussed(void);

void idle_set_starting_up(UBYTE set);

void windowsUpdate(void);

void addMissedCall(void);
void addNewEMS(void);//xrashmic 26 Aug, 2004 MMI-SPR-23931
void addCBCH(char* cbch_string, UBYTE type);
void statusCBCH(UBYTE status);

// 09-Dec-2005, Shashi Shekar B.S., a0876501, START
//x0035544 Mar 14, 2006 DR:OMAPS00061468
/*
**Sending additional parameter display_type to hold the display type for SAT Idle text with icon display
*/
#ifdef FF_MMI_SAT_ICON
void addSatMessage(char *satMessage, UBYTE width, UBYTE height,
						char *dst, UBYTE selfExplanatory, T_DISPLAY_TYPE display_type);
#else
void addSatMessage(char *satMessage);		/* SPR759 - SH*/
#endif
extern void showIMEI (T_MFW_HND win, char* IMEI);
void idle_setBgdBitmap(int bmp);

#endif

