/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		Icons
 $File:		    Mmiicons.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    25/10/00                                                      
                                                                               
********************************************************************************
                                                                              
 Description:

    This provides the implementation of the icon handling in the basic MMI
                        
********************************************************************************
 $History: Mmiicons.h

	Oct 28, 2004    REF: CRR 25886 xnkulkar
 	Description: SMS Icon is not seen in Idle Screen.
 	Solution: A check is done to determine if sms memory is full when the phone is in idle screen or
			when any calls are present and blinking sms icon is displayed.
			
	Apr 27, 2004    REF: ENH 12646  Deepa M.D 
	Fix:		When the SMS memory is full,the SMS icon is made to blink   
	SPR:12822 vvadiraj : Network Icon status info displayed always
	25/10/00			Original Condat(UK) BMI version.	
	   
 $End
*******************************************************************************/




/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "mfw_sys.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_lng.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_tim.h"

#include "mfw_sim.h"
#include "mfw_cm.h"
#include "mfw_nm.h"
#include "mfw_phb.h"
#include "mfw_mme.h"
#include "mfw_sat.h"
#include "mfw_sms.h"

#include "dspl.h"

#include "ksd.h"
#include "psa.h"

#include "MmiMain.h"
#include "MmiBookController.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"



#include "MmiMenu.h"
#include "mmiCall.h"
#include "Mmiicons.h"
#include "MmiIdle.h"

#include "MmiSoftKeys.h"
#include "MmiSounds.h"
#include "MmiIdle.h"
#include "MmiNetwork.h"
#include "mmiSat_i.h"
#include "MmiAoc.h"

#include "gdi.h"
#include "audio.h"

#include "cus_aci.h"
#include "mfw_ffs.h"
#include "MmiTimers.h"
/* sbh...21/01/02 */
#ifdef MMI_GPRS_ENABLED
#include "MmiGprs.h" 
#endif
#include "MmiResources.h"
#include "mmiColours.h"

#include "Icons\IcnDefs.h"

// Oct 28, 2004    REF: CRR 25886 xnkulkar
// Description: SMS Icon is not seen in Idle Screen.
// Added extern call_data to determine if there are any calls active.
extern T_call call_data;
/*******************************************************************************
                                                                              
                                Local definitions
                                                                              
*******************************************************************************/

#define CLEAR_BOTTOM_ZONE_ICON dspl_Clear(42,54,52,60)

/*******************************************************************************
                                                                              
                                Local function prototypes
                                                                              
*******************************************************************************/
// ADDED BY RAVI- 28-11-2005
EXTERN BOOL smsidle_get_memory_full(void);
// END RAVI - 28-11-2005

static void iconsEvent( MfwEvt e, MfwIcn *i );
static void iconsBattEvent( MfwEvt e, MfwIcn *i );
static void iconsSignEvent( MfwEvt e, MfwIcn *i );
static void iconsScreenDelete( void );
//  Apr 27, 2004    REF: ENH 12646  Deepa M.D
static UBYTE smsStatus=0;  //Used to blink the SMS icon.0=Icon visible 1=Icon invisible
MfwHnd sms_animate;      // Timer for SMS Full Icon 
UBYTE isIconBlinking=0;  //Flag to check whether the timer is running


#define CLEAR_ICON_AREA	dspl_Clear(0,7,LCD_X,52);

#if ! defined(WIN32)
extern void scrOnOff (int on);          /* ES!! add. functions      */
#endif

/*******************************************************************************
										
								  Icon Bitmaps
                                                                              
*******************************************************************************/

/* battery  0-4%
*/
static  const unsigned char idlBattery4[] =
{
    0xff,0x81,0x81,0x81,0xff            
};

/* battery  5-14%           
*/
static  const unsigned char idlBattery14[] =
{
    0xff,0xc1,0xc1,0xc1,0xff            
};

/* battery  15-24%          
*/
static  const unsigned char idlBattery24[] =
{
    0xff,0xe1,0xe1,0xe1,0xff            
};

/* battery  25-49%          
*/
static  const unsigned char idlBattery49[] =
{
    0xff,0xf9,0xf9,0xf9,0xff            
};

/* battery  50-100%         
*/
static  const unsigned char idlBattery100[] =
{
    0xff,0xff,0xff,0xff,0xff         
};

/* SMS                      
*/
static  const unsigned char idlSMS[] =
{
   0xff,0xc3,0xa5,0x99,0xff             
};

/* Voice                    
*/
static const unsigned char idlVoice[] =
{
  0x00,0x00,0x3F,0xC0,0x50,0xE0,0x89,0xF0,0x50,0xE0,0x00,0x00
};

/* Call forwarding uncond   
*/
static const unsigned char idlCallforw[] =
{
	0xC4,0xC6,0xFF,0x7E,0x04
};

/* Silent ringer            
*/
static const unsigned char idlSilRinger[] =
{
   0xa4,0xa4,0xbf,0xae,0x44             
};

/* Keypad locked            
*/
static const unsigned char idlKeypLock[] =
{
   0x41,0xa1,0xbe,0xa0,0x40             
};


/* Ciphering
*/
static const unsigned char idlCipheringActiv[] =
{
   0x18,0x24,0x3c,0x24,0x3c             
};

static const unsigned char idlCipheringDeActiv[] =
{
   0x28,0x44,0x6c,0x6c,0x6c             
};


/* Signal strength 0-49     
*/
static const unsigned char idlSigStr49[] =
{
    0x00,0x00,0x00,0x00,0x00            
};

/* Signal strength 50-99    
*/
static const unsigned char idlSigStr99[] =
{
    0x00,0x00,0x00,0x80,0x80            
};

/* Signal strength 100-149  
*/
static const unsigned char idlSigStr149[] =
{
    0x00,0x00,0x20,0xa0,0xa0            
};

/* Signal strength 150-199  
*/
static const unsigned char idlSigStr199[] =
{
    0x00,0x08,0x28,0xa8,0xa8            
};

/* Signal strength 200-255  
*/
static const unsigned char idlSigStr255[] =
{
    0x02,0x0a,0x2a,0xaa,0xaa            
};

/* sbh...18/01/02. GPRS On icon - appears when GPRS is on            
*/
static const unsigned char idlGPRSOn[] =
{
   0x3E,0x60,0x6E,0x66,0x3E             
};

/* Homezone icon            
*/
static const unsigned char idlHomezone[] =
{
   0x38,0x7C,0xFE,0xAA,0xEE             
};

/* SPR#1352 - SH - TTY icon            
*/
static const unsigned char idlTTY[] =
{
   0x7D,0x7D,0x2A,0x2A,0x2A  
};

/* SPR#1985 - SH - Larger TTY icon */

static const unsigned char idlTTYLarge[] =
{
   0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
   0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
   0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x25,0x25,0x25,0x00,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x00,0x25,0x25,0x25,0x00,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x00,0x25,0x25,0x25,0x00,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x00,0x25,0x25,0x25,0x00,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x00,0x25,0x00,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,
   0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25,0x25,0x25,0x00,0x25,0x25
};

//Game: Four in a row icons
const unsigned char game_field[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0x84,0x21,0x08,0x42,0x10,0x84,0x21,
	0x84,0x21,0x08,0x42,0x10,0x84,0x21, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
};

#ifndef LSCREEN

const unsigned char game_cursor[]={
	0x00,0xFC,0xFC,0x78,0x78,0x30,
};
const unsigned char black_stone_bw[]={
	0x60,0xF0,0xF0,0x60,
};
const unsigned char white_stone_bw[]={
	0x60,0x90,0x90,0x60,
};

#else

const unsigned char multi_pointer[]={
	0x08,0x0C,0xFE,0xFF,0xFE,0x0C,0x08,0x00,
};
const unsigned char game_cursor[]={
	0x18,0x18,0x18,0x18,0xFF,0x7E,0x3C,0x18,
};
const unsigned char black_stone_bw[]={
	0x3C,0x7E,0xFF,0xFF,0xFF,0xFF,0x7E,0x3C,
};
const unsigned char white_stone_bw[]={
	0x18,0x3C,0x42,0xC3,0xC3,0x42,0x3C,0x18,
};

#endif

const unsigned char game_name1[]={
	0x00,0x00,0x00,0x6F,0x52,0x33,0x6F,0x5A,0x4B,0x6F,0x56,0x4B,0x6F,0x56,0x7B,
	0x6F,0x52,0x4B,0x61,0x00,0x03,0x6D,0xFF,0xFF,0x6C,0x08,0x08,0x7E,0xE3,0x2A,
	0x7E,0x94,0xAA,0x0C,0x94,0xAA,0xEC,0xE4,0xA2,0xEC,0xC4,0xAA,0xEC,0xA4,0xAA,
	0xEC,0x93,0x14,0xE0,0x00,0x01,0xFF,0xFE,0x0F
};
const unsigned char game_name2[]={
	0xAA,0xA8,0xE1,0x55,0x53,0x18,
	0xAA,0xA4,0x04,0x55,0x49,0x12,0xAA,0x88,0x02,0x55,0x50,0x01,0xAA,0x90,0x01,
	0x55,0x52,0x09,0xAA,0x89,0x12,0x50,0x48,0xE2,0x87,0x04,0x04,0x1F,0xC3,0x19,
	0x3F,0xE0,0xE2,0x77,0x74,0x05,0x7F,0xF2,0xAA,0xFF,0xF9,0x55,0xFF,0xFA,0xAA,
	0xFF,0xF9,0x55,0x6F,0xB2,0xAA,0x77,0x75,0x55,0x38,0xE2,0xAA,0x1F,0xC5,0x55,
	0x87,0x0A,0xAA,0x50,0x55,0x55
};
const unsigned char board_full1[]={
	0x00,0x00,0x00,0xE3,0x19,0xCE,0x94,0xA5,0x29,0x94,0xA5,0x29,0xE4,0xA5,0x29,
	0x94,0xBD,0xC9,0x94,0xA5,0x89,0x94,0xA5,0x49,0xE3,0x25,0x2E,0x00,0x00,0x00,
	0x00,0x00,0x00,0x3D,0x28,0x40,0x21,0x28,0x40,0x21,0x28,0x40,0x21,0x28,0x40,
	0x39,0x28,0x40,0x21,0x28,0x40,0x21,0x28,0x40,0x20,0xCF,0x78,0x00,0x00,0x00,
	0xFF,0xFF,0xFF
};
const unsigned char board_full2[]={
	0x00,0x00,0x00,0xFE,0xFD,0xFF,0x00,0xFC,0x00,0xFE,0xFD,0xFF,
	0x00,0xFC,0x00,0xFE,0x79,0xFF,0x00,0x78,0x00,0xFF,0x7B,0xFF,0x00,0x30,0x00,
	0xFF,0xB7,0xFF,0x00,0x30,0x00,0xFF,0x87,0xFF,0x00,0x30,0x00,0xFF,0x7B,0xFF,
	0x00,0x78,0x00,0xFF,0x33,0xFF,0x00,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,
	0xFF,0xFF,0xFF,0x00,0x00,0x00
};
const unsigned char player_win1[]={
	0x00,0x00,0x00,0xC6,0x7C,0xC3,0xC6,0xFE,0xC3,0x6C,0xC6,0xC3,0x3C,0xC6,0xC3,
	0x30,0xC6,0xC3,0x70,0xC6,0xC3,0xE0,0xC6,0xE7,0x80,0xFE,0x7E,0x80,0x7C,0x3C,
	0x00,0x00,0x00,0x00,0x00,0x00,0xC3,0x36,0x30,0xC3,0x36,0x30,0xC3,0x37,0x30,
	0xC3,0x37,0xB0,0xDB,0x37,0xF0,0xDB,0x36,0xF0,0xFF,0x36,0x70,0x66,0x36,0x30,
	0x00,0x00,0x00
};
const unsigned char player_win2[]={
	0x00,0x78,0x00,0x01,0x86,0x00,0x02,0x01,0x00,0x04,0x84,0x80,
	0x09,0xCE,0x40,0x08,0x84,0x40,0x10,0x00,0x20,0x16,0x01,0xA0,0x13,0x03,0x20,
	0x12,0x85,0x20,0x09,0x7A,0x40,0x08,0x84,0x40,0x04,0x48,0x80,0x02,0x31,0x00,
	0x01,0x86,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x02,0xAA,0x00,0x09,0x54,0x80,
	0x02,0xAA,0x00,0x00,0x00,0x00
};
const unsigned char player_lost1[]={
	0x00,0x00,0x00,0xC6,0x7C,0xC3,0xC6,0xFE,0xC3,0x6C,0xC6,0xC3,0x3C,0xC6,0xC3,
	0x30,0xC6,0xC3,0x70,0xC6,0xC3,0xE0,0xC6,0xE7,0x80,0xFE,0x7E,0x80,0x7C,0x3C,
	0x00,0x00,0x00,0x00,0x00,0x00,0xC3,0x8F,0x7E,0xC7,0xDF,0x7E,0xC6,0xD8,0x18,
	0xC6,0xCE,0x18,0xC6,0xC7,0x98,0xC6,0xD9,0x98,0xF7,0xDF,0x98,0xF3,0x8F,0x18,
	0x00,0x00,0x00
};
const unsigned char player_lost2[]={
	0x00,0x78,0x00,0x01,0x86,0x00,0x02,0x01,0x00,0x04,0x84,0x80,
	0x09,0xCE,0x40,0x08,0x84,0x40,0x10,0x00,0x20,0x10,0x00,0x20,0x10,0x00,0x20,
	0x10,0x30,0x20,0x08,0xCC,0x40,0x09,0x02,0x40,0x04,0x00,0x80,0x02,0x01,0x00,
	0x01,0x86,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x02,0xAA,0x00,0x09,0x54,0x80,
	0x02,0xAA,0x00,0x00,0x00,0x00,
};

//Melodygenerator icons

const unsigned char akt_frame[]={
	0xF0,0x0F,0x80,0x01,0x80,0x01,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
	0x01,0x80,0x01,0x80,0x01,0xF0,0x0F,
};
const unsigned char noteline_begin[]={
	0xAA,0xAA,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,
	0x00,0x1A,0x00,0x22,0xAA,0xA2,0x00,0x22,0x00,0x1A,0x00,0x02,0x00,0x02,0xAA,
	0xAA,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,
	0x00,0x02,0x00,0x02,0xAA,0x82,0x00,0x1A,0x00,0x22,0x00,0x22,0x00,0x22,0xAA,
	0x9A,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,
	0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,0x00,0x1A,0x00,0x22,0xAA,
	0xA2,0x00,0x22,0x00,0x1A,0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,
	0x06,0x02,0x0F,0x02,0xD3,0xBF,0x11,0x82,0x09,0x82,0x09,0x82,0x05,0x02,0xF6,
	0x7F,0x04,0x02,0x0A,0x02,0x0A,0x02,0x10,0xE2,0x91,0xF3,0x33,0x1A,0x30,0x1A,
	0x10,0x9A,0x10,0x92,0xC8,0xB7,0x0C,0x62,0x03,0x82,0x00,0x42,0x03,0x42,0xF7,
	0x2F,0x06,0x22,0x03,0xC2,0x01,0x9A,0x00,0x22,0xAA,0xA2,0x00,0x22,0x00,0x1A,
	0x00,0x02,0x00,0x02,0xAA,0xAA,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,
	0xAA,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,0x82,0x00,0x1A,0x00,0x22,
	0x00,0x22,0x00,0x22,0xAA,0x9A,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0xAA,
	0xAA,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,
};
const unsigned char noteline_end[]={
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xFF,0xFF,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xFF,0xFF,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xFF,0xFF,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xFF,0xFF,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xFF,0xFF,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,
	0x18,0x01,0x18,0x01,0x18,0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
	0xAB,0xBA,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,0x01,0x18,
};
const unsigned char noteline_background[]={
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xAA,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};
const unsigned char n1[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x68,0x00,0xF8,0x00,0xF0,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n1_16[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0A,0x00,0x09,0x00,0x0C,0x00,0x0A,
	0x00,0x09,0x00,0x08,0x00,0x08,0x00,0x68,0x00,0xF8,0x00,0xF0,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n1_32[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0A,0x00,0x09,0x00,0x0C,0x00,0x0A,
	0x00,0x09,0x00,0x0C,0x00,0x0A,0x00,0x69,0x00,0xF8,0x00,0xF0,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n1_8[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x0A,0x00,0x09,0x00,0x08,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x68,0x00,0xF8,0x00,0xF0,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n1_f[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x90,0x00,0x90,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n1_h[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x68,0x00,0x98,0x00,0x90,0x00,0x60,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n5[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF8,0x00,0x68,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n5_16[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF8,0x00,0x68,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x48,0x00,0x28,0x00,0x58,0x00,0x28,0x00,0x18,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n5_32[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF8,0x00,0x68,0x00,0x08,
	0x00,0x48,0x00,0x28,0x00,0x58,0x00,0x28,0x00,0x58,0x00,0x28,0x00,0x18,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n5_8[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0xF0,0x00,0xF8,0x00,0x68,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x48,0x00,0x28,0x00,0x18,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n5_h[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x90,0x00,0x98,0x00,0x68,0x00,0x08,
	0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n4_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x80,0x00,0x40,0x00,0x60,0x00,0x60,0x00,0x40,0x00,0x80,0x00,0x80,
	0x00,0x80,0x00,0x40,0x00,0x80,0x01,0x80,0x01,0x80,0x00,0x80,0x00,0x40,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n8_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x30,0x03,0xD0,0x00,0x20,0x00,0x60,
	0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n16_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x30,0x03,0xD0,0x00,0x20,0x06,0x60,
	0x07,0xC0,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n32_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x30,0x03,0xD0,0x00,0x20,0x06,0x60,
	0x07,0xC0,0x00,0x40,0x19,0x80,0x1E,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char nf_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char nh_b[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE0,0x07,0xE0,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n_point[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char n_hash[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x00,0x3E,0x00,0x14,0x00,0x3E,0x00,0x14,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
//the seperate screenparts are in the begining empty
const unsigned char screenpart0[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char screenpart1[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char screenpart2[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char screenpart3[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
const unsigned char screenpart4[]={
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,
};
//End of the melodygenerator icons

#ifdef COLOURDISPLAY

#endif

/*Calculator Icon 
*/
static const unsigned char iconMainCalculator[] =
{
	0xFE,0x0F,0x5A,0x44,0x00,0x00,0x00,0x00, 0x00,0x00,0xFC,0xE7,0xFD,0x10,0x00,0x1F,
	0x80,0x00,0x00,0xFC,0xF9,0x13,0xFA,0x00, 0x00,0x66,0x40,0x00,0x03,0x32,0xF2,0x09,
	0xDC,0x40,0x01,0x98,0x40,0x00,0x0C,0xC2, 0xE4,0xE4,0xFA,0x00,0x06,0x60,0x40,0x00,
	0x33,0x02,0xC9,0x12,0x74,0x80,0x0F,0x83, 0x4C,0x18,0x7C,0x02,0x92,0x09,0x3A,0x28,
	0x0D,0x04,0xDE,0x24,0xE8,0x02,0x24,0x44, 0x9D,0x00,0x0B,0x3B,0xFF,0xDF,0xD8,0x02,
	0x48,0x22,0x4A,0x00,0x0D,0x4A,0x38,0x51, 0xE8,0x02,0x91,0x11,0x20,0x20,0x0B,0x6B,
	0x7D,0x5B,0xD8,0x02,0x22,0x88,0x92,0x80, 0x0D,0x3B,0xFF,0xDF,0xE8,0x02,0x44,0x44,
	0x88,0x04,0x0B,0x04,0xDE,0x24,0xD8,0x02, 0x80,0x80,0x84,0x00,0x0D,0x03,0x4C,0x18,
	0x68,0x02,0x01,0x11,0x22,0x20,0x0B,0x07, 0x40,0x60,0x58,0x02,0x08,0xA2,0x51,0x00,
	0x0D,0x0F,0xC0,0x90,0x68,0x02,0x44,0x44, 0xA8,0x80,0x0B,0x3F,0xFF,0x7F,0xD8,0x02,
	0x2A,0x09,0x54,0x40,0x0D,0x5C,0x01,0x40, 0x68,0x02,0x11,0x12,0x2A,0x20,0x0B,0x7D,
	0x55,0x6A,0xD8,0x02,0x00,0x25,0x11,0x10, 0x0D,0x3F,0xFF,0x7F,0xE8,0x02,0x00,0x4A,
	0xAA,0x88,0x0B,0x0F,0xC0,0x90,0x58,0x02, 0x80,0x95,0x44,0x44,0x0D,0x07,0x40,0x60,
	0x68,0x02,0x41,0x22,0xAA,0xA2,0x0B,0x00, 0x4C,0x01,0xD8,0x02,0xA2,0x51,0x11,0x11,
	0x0D,0x00,0x5E,0x02,0x68,0x02,0xDC,0xAA, 0xAA,0xA8,0x8B,0x3F,0xFF,0xFD,0xD8,0x02,
	0x61,0x54,0x44,0x44,0x8D,0x40,0x38,0x05, 0x68,0x02,0x32,0x2A,0xAA,0xA8,0x8B,0x6A,
	0xBD,0x55,0xD8,0x02,0x99,0x11,0x11,0x11, 0x0D,0x3F,0xFF,0xFD,0xE8,0x02,0xCC,0xAA,
	0xAA,0xA2,0x0B,0x01,0x9E,0x02,0x58,0x0C, 0xE6,0x44,0x44,0x44,0x0D,0x07,0x4C,0x01,
	0xE8,0x3A,0xF3,0x2A,0xAA,0x88,0x0B,0x1A, 0xA0,0x00,0x58,0xD5,0xF9,0x91,0x11,0x10,
	0x0D,0x75,0x50,0x00,0x6B,0xAA,

};

/*CallDivert Icon 
*/
static const unsigned char iconMainCallDivert[] =
{
	0xFF,0xDD,0x49,0x20,0x0C,0x00,0x00,0x00, 0x00,0x00,0xFF,0x7A,0xA0,0x01,0x18,0x00,
	0x00,0x00,0x00,0x00,0xFF,0xFD,0x52,0x88, 0x30,0x00,0x00,0x00,0x00,0x00,0xE3,0xEE,
	0xA0,0x00,0x60,0x00,0x00,0x00,0x00,0x00, 0xE9,0xFD,0x54,0x80,0xC0,0x00,0x00,0x00,
	0x00,0x00,0xEC,0xDE,0xA0,0x01,0x80,0x00, 0x00,0x00,0x00,0x00,0xE6,0x7B,0x52,0x83,
	0x00,0x00,0x1F,0xFF,0x80,0x00,0xF3,0x3E, 0xA4,0x26,0x00,0x00,0x18,0x00,0x80,0x00,
	0xF9,0x87,0x40,0x0C,0x00,0x00,0x73,0x9C, 0x60,0x00,0xFC,0xF2,0xA8,0x99,0x00,0x01,
	0xD3,0xF4,0x18,0x00,0xF8,0xC9,0x40,0x30, 0x00,0x03,0x46,0x02,0x04,0x00,0xE3,0x34,
	0x2A,0x60,0x00,0x07,0xFD,0x01,0xFE,0x00, 0x8C,0xCA,0x50,0xC4,0x00,0x06,0x08,0xF1,
	0x82,0x00,0xB3,0x15,0x21,0x80,0x00,0x07, 0xFD,0x09,0xFE,0x00,0x24,0x24,0x83,0x00,
	0x00,0x40,0x1A,0x64,0x80,0x00,0x54,0x08, 0x46,0x00,0x00,0x60,0x34,0x92,0x40,0x00,
	0x4A,0x91,0xA1,0x99,0x99,0xF0,0x3D,0x02, 0x40,0x00,0x25,0x23,0x51,0x99,0x99,0xF0,
	0x35,0x22,0x40,0x00,0xB2,0xC6,0xA8,0x00, 0x00,0x60,0x3C,0x82,0x40,0x00,0x99,0x0D,
	0x54,0x20,0x00,0x40,0x32,0x44,0x40,0x00, 0xCC,0x9A,0xAA,0x00,0x00,0x00,0x79,0x08,
	0x20,0x00,0xEA,0x5D,0x55,0x04,0x00,0x00, 0x60,0xF0,0x20,0x00,0xE5,0x2E,0xAA,0x80,
	0x00,0x00,0xD0,0x00,0x10,0x00,0xF2,0x97, 0x55,0x40,0x20,0x01,0xFF,0xFF,0xF8,0x00,
	0xF9,0x4B,0xAA,0xA0,0x00,0x03,0x50,0x00, 0x04,0x00,0xFC,0xA5,0xD5,0xA0,0x00,0x03,
	0xA0,0x00,0x07,0x80,0xFE,0x52,0xEB,0x44, 0x00,0x01,0xFF,0xFF,0xF8,0xC0,0xFF,0x29,
	0x77,0x40,0x00,0x00,0x00,0x00,0x00,0x78, 0xFF,0x94,0xBA,0x80,0x00,0x00,0x00,0x00,
	0x00,0x0F,0xFF,0xCA,0x5C,0x80,0x00,0x00, 0x00,0x00,0x00,0x00,0xFF,0xE5,0x29,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
};

/*Messages Icon 
*/
static const unsigned char iconMainMessages[] =
{
	0xFF,0xF8,0xC4,0x27,0x04,0x00,0x00,0x01, 0x05,0x60,0xFF,0xE3,0x04,0x12,0x40,0x0F,
	0x00,0x02,0x0A,0xC0,0xFF,0x8C,0x04,0x09, 0x10,0xFF,0x00,0x02,0x0D,0x80,0xFE,0x30,
	0x04,0x04,0x01,0xF9,0x80,0x04,0x0A,0x80, 0xF8,0xC0,0x04,0x02,0x43,0x01,0x80,0x04,
	0x15,0x80,0xE3,0x00,0x04,0x01,0x03,0x01, 0xC0,0x08,0x1B,0x00,0x8C,0x00,0x04,0x00,
	0x80,0x01,0xC0,0x08,0x36,0x00,0x30,0x00, 0x04,0x00,0x48,0x01,0xC0,0x08,0x2A,0x00,
	0xC0,0x00,0x04,0x00,0x20,0x7F,0xC0,0x04, 0x54,0x00,0x00,0x00,0x04,0x00,0x21,0xFF,
	0xC0,0x04,0x78,0x00,0x00,0x00,0x04,0x00, 0x43,0xC0,0xC0,0x04,0xC0,0x00,0x00,0x00,
	0x04,0x00,0x47,0x00,0xC0,0x02,0x80,0x00, 0x00,0x00,0x04,0x00,0x8E,0x00,0xC0,0x01,
	0x80,0x00,0x00,0x00,0x04,0x00,0x8C,0x00, 0xC0,0xFF,0xE0,0x00,0x00,0x00,0x04,0x01,
	0x0E,0x00,0xE3,0x01,0x18,0x00,0xFF,0xFF, 0xFC,0x01,0x27,0x03,0xF6,0x7F,0xCC,0x00,
	0x00,0x00,0x00,0x02,0x07,0x87,0xF5,0x00, 0x14,0x00,0x00,0x00,0x00,0x02,0x81,0xFF,
	0xF4,0xFF,0xE4,0x00,0x00,0x00,0x00,0x04, 0x00,0xFC,0x72,0x00,0x08,0x00,0x00,0x00,
	0x00,0x04,0x00,0x00,0x01,0xFF,0xF0,0x00, 0x80,0x00,0x00,0x08,0x80,0x00,0x01,0x02,
	0x10,0x00,0x40,0x00,0x00,0x0A,0x10,0x00, 0x01,0x22,0x10,0x00,0x20,0x00,0x00,0x10,
	0x40,0x01,0xC1,0x24,0x10,0x00,0x90,0x00, 0x00,0x12,0x03,0xE0,0x02,0xA4,0x68,0x00,
	0xC8,0x00,0x00,0x20,0x0F,0xE0,0x04,0x55, 0x04,0x00,0xE4,0x00,0x00,0x29,0xFF,0xF8,
	0x0A,0xAE,0xAA,0x00,0xF2,0x00,0x00,0x42, 0x7F,0xF8,0x0F,0x5D,0x5E,0x00,0xF9,0x00,
	0x00,0x58,0x07,0x00,0x0B,0xEA,0xFE,0x00, 0xFC,0x80,0x00,0x95,0x00,0x00,0x0B,0xFF,
	0xFE,0x00,0xFE,0x40,0x00,0xBA,0x18,0x00, 0x0B,0xFF,0xFE,0x00,0xFF,0x20,0x01,0x35,
	0x00,0x00,0x0F,0xFF,0xFE,0x00,
};

/*Phonebook Icon 
*/
static const unsigned char iconMainPhonebook[] =
{
	0xFF,0xB8,0xED,0x00,0x00,0x00,0x00,0x00, 0x30,0xC4,0xFF,0x9E,0x7A,0x14,0x80,0x00,
	0x00,0x00,0xC3,0x22,0xFF,0x19,0x34,0x80, 0x00,0x00,0x00,0x03,0x0C,0x11,0xFC,0x60,
	0xBA,0x00,0x00,0x00,0x00,0x0C,0x30,0x08, 0xF1,0x86,0x9D,0x10,0x00,0x00,0x00,0x30,
	0xC0,0x0C,0xC6,0x1A,0x5A,0x04,0x00,0x00, 0x00,0x23,0x00,0x30,0x18,0x61,0x4C,0x40,
	0x80,0x00,0x00,0x52,0x00,0xC0,0x61,0x81, 0x2A,0x00,0x00,0x00,0x00,0xA9,0x03,0x00,
	0x86,0x04,0xA4,0x90,0x00,0x00,0xF0,0xD5, 0xEC,0x00,0x98,0x60,0x92,0x00,0x00,0x03,
	0x0C,0x6E,0x18,0x00,0x51,0x82,0x50,0x00, 0x00,0x0C,0x03,0x38,0x06,0x00,0x4A,0x20,
	0xCA,0x41,0x00,0x01,0xE0,0xA3,0xE1,0x80, 0xA8,0xC3,0x08,0x10,0x00,0x52,0x18,0x4C,
	0x18,0x40,0xA5,0x0C,0x64,0x30,0x00,0x18, 0x06,0x50,0x06,0xC0,0x54,0x31,0xC4,0x7F,
	0xFF,0xFC,0xC0,0x80,0x00,0xC0,0x52,0xC0, 0x12,0xFF,0xFF,0xFE,0x30,0x8F,0x81,0x80,
	0x2B,0x00,0x72,0x7F,0xFF,0xFC,0x0D,0x30, 0x61,0x80,0xA8,0x61,0xE9,0x30,0x00,0x19,
	0x01,0x40,0x1B,0x80,0x95,0xC7,0xB9,0x10, 0x02,0x10,0xC2,0x00,0x03,0x40,0xD4,0x1E,
	0xF4,0x80,0x04,0x40,0x32,0x3E,0x06,0x21, 0xCA,0x7B,0xDC,0x82,0x04,0x8E,0x04,0xC1,
	0x86,0x96,0xEA,0x6F,0x7A,0x48,0x08,0x31, 0x85,0x00,0x6F,0x4D,0xE5,0x3D,0xEE,0x40,
	0x08,0xC0,0x68,0x00,0x0D,0xBA,0xF5,0x37, 0xBD,0x20,0x11,0x00,0x08,0xF8,0x18,0xD5,
	0xF2,0x9E,0xF7,0x20,0x10,0x00,0x13,0x06, 0x18,0x6A,0xFA,0x9B,0xDE,0x91,0x20,0x00,
	0x14,0x01,0xB8,0x35,0xF9,0x4F,0x7B,0x90, 0x20,0xF0,0x21,0xE0,0x30,0x1B,0xFD,0x4D,
	0xEF,0x48,0x43,0x5C,0x26,0xB8,0x60,0x0E, 0xFC,0xA7,0xBD,0xC8,0x4E,0xAB,0x5D,0x56,
	0x40,0x00,0xFE,0xA6,0xF7,0x84,0x35,0xFF, 0xFF,0xAB,0x80,0x00,0xFE,0x53,0xDE,0x04,
	0x0B,0x00,0x00,0xFE,0x00,0x00,
};

/*RecentCalls Icon 
*/
static const unsigned char iconMainRecentCalls[] =
{
	0xFE,0xE8,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0xFF,0xD4,0x20,0x00,0x00,0x60,
	0x00,0x00,0x00,0x00,0xFF,0xE8,0x80,0x00, 0x00,0x60,0x00,0x00,0x00,0x00,0xFF,0xD0,
	0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00, 0xFF,0x68,0x88,0x00,0x00,0x60,0x00,0x00,
	0x00,0x00,0xFF,0xD2,0x00,0x01,0xFF,0xE0, 0x00,0x00,0x00,0x00,0xFF,0xA8,0x00,0x02,
	0x00,0x10,0x00,0x00,0x00,0x00,0xFE,0xD4, 0x00,0x02,0xFF,0xD0,0x00,0x00,0x00,0x00,
	0xFF,0xE8,0x80,0x03,0x00,0x30,0x00,0x00, 0x00,0x00,0xFF,0xD0,0x00,0x03,0x09,0x30,
	0x00,0x00,0x00,0x00,0xFF,0x68,0x04,0x03, 0x35,0x30,0x04,0x00,0x00,0x00,0xFF,0xD5,
	0x06,0x03,0x00,0x30,0x06,0x00,0x00,0x00, 0xFF,0xA8,0x27,0x03,0x00,0x30,0x07,0x00,
	0x00,0x00,0xFF,0xD0,0x05,0x82,0xFF,0xD0, 0x05,0x80,0x00,0x00,0xFF,0x6B,0xFE,0xC2,
	0x00,0x13,0xFE,0xC0,0x00,0x00,0xFD,0xD2, 0x07,0x62,0xC0,0xD2,0x07,0x60,0x00,0x00,
	0xFF,0xEB,0xFF,0xB2,0xC0,0xD3,0xFF,0xB0, 0x00,0x00,0xFF,0xD3,0xFF,0xFA,0x00,0x13,
	0xFF,0xF8,0x00,0x00,0xFF,0xAB,0xFF,0xF2, 0xFF,0xD3,0xFF,0xF0,0x00,0x00,0xFF,0xD3,
	0xFF,0xE2,0x92,0x53,0xFF,0xE0,0x00,0x00, 0xFF,0xEB,0xFF,0xC2,0x92,0x53,0xFF,0xC0,
	0x00,0x00,0xFE,0xD0,0x07,0x82,0xFF,0xD0, 0x07,0x80,0x00,0x00,0xFF,0xE8,0x47,0x02,
	0x92,0x50,0x07,0x00,0x00,0x00,0xFF,0xD4, 0x06,0x02,0x92,0x50,0x06,0x00,0x00,0x00,
	0xFB,0xA8,0x04,0x02,0xFF,0xD0,0x04,0x00, 0x00,0x00,0xFF,0xD0,0x00,0x02,0x92,0x50,
	0x00,0x00,0x00,0x00,0xFF,0xE9,0x00,0x02, 0x92,0x50,0x00,0x00,0x00,0x00,0xFF,0x50,
	0x00,0x02,0xFF,0xD0,0x00,0x00,0x00,0x00, 0xFD,0xE8,0x10,0x02,0x00,0x10,0x00,0x00,
	0x00,0x00,0xFF,0xD4,0x80,0x01,0xFF,0xE0, 0x00,0x00,0x00,0x00,0xFF,0xA8,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
};

/*Security Icon 
*/
static const unsigned char iconMainSecurity[] =
{
	0xF0,0xC3,0x6A,0x10,0x00,0x38,0x00,0x00, 0x00,0x00,0xC7,0x3B,0xD5,0x44,0x80,0xC6,
	0x00,0x00,0x00,0x00,0x98,0x09,0xEA,0x00, 0x01,0x01,0x80,0x00,0x00,0x00,0x21,0xE4,
	0xB4,0x84,0x01,0x38,0x40,0x07,0xFF,0xFF, 0x56,0x12,0xEA,0x10,0x02,0x46,0x20,0x08,
	0x00,0x00,0x68,0xD2,0x74,0x40,0x02,0x41, 0x20,0x11,0xFF,0xFF,0x7B,0xC9,0x28,0x01,
	0x0C,0x9D,0x20,0x12,0x00,0x00,0x69,0xE4, 0x81,0x20,0x30,0x62,0x20,0x14,0x72,0x90,
	0x35,0xC4,0xFC,0x08,0xC3,0x2C,0xC0,0x14, 0x4A,0xD4,0xBC,0x1B,0x32,0x43,0x17,0xA9,
	0x80,0x14,0x72,0xB0,0x9A,0x60,0xC1,0x0C, 0x5C,0x6E,0xC0,0x14,0x42,0x94,0xDD,0x83,
	0x00,0xB1,0x70,0x2A,0x40,0x14,0x42,0x90, 0xCF,0x0C,0x00,0xC5,0xC0,0x25,0x40,0x12,
	0x00,0x00,0x97,0x30,0x03,0x57,0x00,0x12, 0x40,0x11,0xFF,0xFF,0xA8,0xD0,0x02,0xAC,
	0x00,0x08,0x80,0x10,0x00,0x00,0xBF,0xA1, 0xE1,0x4C,0x00,0x04,0x80,0x10,0x00,0x00,
	0xBB,0x43,0xF0,0xA7,0x00,0x06,0x80,0x11, 0xFF,0xFF,0xB6,0xA3,0xF0,0x50,0x80,0x04,
	0x80,0x12,0x0A,0x14,0xBB,0x43,0xF0,0x29, 0x80,0x06,0x80,0x15,0x0C,0x18,0x9D,0xA1,
	0xF0,0x17,0x00,0x04,0x80,0x16,0x0A,0x14, 0xDE,0xD0,0x78,0x0D,0x00,0x06,0x80,0x15,
	0x0C,0x18,0xCD,0xA0,0x7C,0x01,0x00,0x04, 0x80,0x16,0x0A,0x14,0xEE,0xD0,0x7E,0x01,
	0x00,0x06,0x80,0x17,0xFF,0xFF,0xE7,0x68, 0x3F,0x01,0x00,0x04,0x80,0x15,0x0A,0x14,
	0xF6,0xB0,0x3F,0xC1,0x00,0x06,0x80,0x16, 0x0C,0x18,0xF3,0x68,0x3F,0x81,0x00,0x04,
	0x80,0x15,0x0A,0x14,0xFB,0xB4,0x1F,0x02, 0x00,0x06,0xE0,0x16,0x0C,0x18,0xFB,0xDA,
	0x1C,0x02,0x00,0x04,0x20,0x15,0x0A,0x14, 0xF9,0xAD,0x10,0x04,0x00,0x06,0xE0,0x17,
	0xFF,0xFF,0xFD,0xDA,0x80,0x04,0x00,0x04, 0xF8,0x15,0x0A,0x14,0xFC,0xEF,0x40,0x08,
	0x00,0x06,0x08,0x16,0x0C,0x18,
};

/*Settings Icon 
*/
static const unsigned char iconMainSettings[] =
{
	0xFF,0xFE,0x55,0x2D,0x44,0x00,0x05,0x00, 0x00,0x70,0xFF,0xFC,0xB6,0xBA,0x90,0x80,
	0x08,0x80,0x01,0x88,0x1F,0xFD,0xA0,0x5D, 0x44,0x00,0x50,0x40,0x02,0x10,0xCF,0xF8,
	0x80,0x8A,0x90,0x80,0xA0,0x20,0x04,0x61, 0xA8,0xFB,0x88,0xED,0x44,0x01,0xC0,0x40,
	0x04,0x82,0xE2,0x7B,0x1C,0x2A,0x90,0x80, 0x80,0x80,0x08,0x85,0xA7,0x3B,0x88,0xED,
	0x44,0x01,0x41,0x00,0x08,0x44,0x6C,0xB8, 0x80,0x8A,0x90,0x82,0x82,0x00,0x04,0x3B,
	0x99,0x3D,0xA0,0x5D,0x44,0x07,0x25,0x00, 0x04,0x07,0x02,0x7C,0xB6,0x9A,0x90,0x86,
	0x8C,0x80,0x08,0xAE,0x84,0xFE,0x55,0x3D, 0x44,0x07,0x56,0x40,0x11,0xFC,0x04,0x0F,
	0x1C,0x6A,0x90,0x86,0xA3,0x20,0x23,0x30, 0x83,0xEF,0xC0,0xF5,0x44,0x07,0x41,0x90,
	0x46,0x00,0xC0,0x2F,0xFF,0xBA,0x90,0x06, 0x80,0xC8,0x8C,0x00,0xC0,0x2F,0xFE,0xFD,
	0x00,0x87,0x00,0x65,0x18,0x00,0x83,0xEF, 0xFF,0xEA,0x3C,0x06,0x00,0x32,0x30,0x00,
	0x04,0x0F,0x00,0x7D,0x7E,0x00,0x00,0x19, 0x60,0x00,0x84,0xFF,0x7F,0x7A,0x7E,0x80,
	0x00,0x0C,0xC0,0x00,0x02,0x63,0x69,0x61, 0x7E,0x00,0x01,0x96,0x40,0x00,0x99,0x09,
	0x71,0x48,0x39,0x00,0x02,0x63,0x20,0x00, 0x6C,0x9C,0x69,0x14,0x84,0x80,0x04,0x07,
	0x90,0x00,0xA7,0x32,0x71,0x22,0x12,0x40, 0x04,0x44,0xC8,0x00,0xE2,0x69,0x80,0xC1,
	0x01,0x20,0x09,0xA4,0x78,0x00,0xA8,0xD0, 0x00,0x00,0x90,0x90,0x0A,0x52,0x30,0x00,
	0xCE,0x69,0x00,0x01,0x04,0x48,0x04,0x26, 0x00,0x00,0x1F,0x32,0x00,0x02,0x50,0x27,
	0xC0,0x36,0x00,0x00,0xF8,0x10,0x00,0x04, 0x04,0x9F,0xF0,0x5C,0x00,0x00,0xFB,0xE0,
	0x00,0x03,0xF0,0x1F,0x98,0xF8,0x00,0x00, 0xFB,0x48,0x1C,0x00,0x14,0x7F,0xEE,0x60,
	0x00,0x00,0xFB,0xA0,0x3E,0x00,0x10,0xFF, 0xF3,0x00,0x00,0x00,0xFB,0x48,0x77,0x00,
	0x14,0xFF,0xFD,0x00,0x00,0x00,
};

/*SimToolkit Icon 
*/
static const unsigned char iconMainSimToolkit[] =
{
	0xFF,0xFF,0xFB,0xAA,0x08,0x80,0x40,0x00, 0x96,0x00,0x00,0x0F,0xDE,0xA0,0x40,0x00,
	0x00,0x01,0x2C,0x00,0xFF,0xE1,0xFB,0x0A, 0x08,0x00,0x00,0xF2,0x58,0x00,0x80,0x14,
	0xF7,0xA8,0x40,0x80,0x01,0x0C,0xB0,0x00, 0x40,0x0A,0x7D,0x22,0x08,0x08,0x02,0x01,
	0x60,0x00,0x20,0x05,0x37,0xA8,0x40,0x00, 0x44,0x02,0xC0,0x00,0x90,0x03,0xBE,0x82,
	0x08,0x00,0x04,0xF1,0x80,0x00,0xC8,0x01, 0x3F,0xAA,0x40,0x80,0x05,0x0A,0x80,0x00,
	0xE4,0x00,0x98,0x00,0x00,0x00,0x02,0x09, 0x80,0x00,0xF2,0x00,0x43,0xFF,0xFF,0xFF,
	0xC0,0x0A,0x80,0x00,0xF3,0x00,0x24,0x00, 0x00,0x00,0x20,0x15,0x80,0x00,0xE5,0x80,
	0x58,0x00,0x00,0x00,0x10,0xE7,0x00,0x00, 0xC8,0xC0,0xB9,0xFF,0xFE,0x00,0x08,0x7E,
	0x00,0x00,0x91,0x61,0x6A,0xAA,0xAB,0x00, 0x04,0x38,0x00,0x00,0x22,0xDA,0xCB,0xFD,
	0x55,0x80,0x02,0x00,0x00,0x00,0x45,0x8D, 0x8B,0x02,0xAA,0x80,0x01,0x00,0x00,0x00,
	0x8B,0x27,0x2A,0x01,0x55,0x80,0x01,0x00, 0x00,0x00,0x16,0x72,0x6A,0x01,0xBE,0x80,
	0x01,0x00,0x00,0x00,0x2C,0xF8,0xEB,0x03, 0x41,0x80,0x01,0x00,0x00,0x00,0x59,0xFF,
	0xEA,0xFE,0x80,0x80,0x01,0x00,0x00,0x00, 0xB3,0xFF,0xEB,0x55,0x80,0x80,0x01,0x00,
	0x00,0x00,0x67,0xFF,0xEA,0xFE,0x80,0x80, 0x01,0x00,0x00,0x00,0xCF,0xFF,0xEB,0x03,
	0x41,0x80,0x01,0x00,0x00,0x00,0x9F,0xFF, 0xEA,0x01,0xBE,0x80,0x01,0x00,0x00,0x00,
	0x3F,0xFF,0xEA,0x01,0x55,0x80,0x01,0x00, 0x00,0x00,0xFF,0xFF,0xEB,0x02,0xAA,0x80,
	0x01,0x00,0x00,0x00,0xFF,0xFF,0xEB,0xFD, 0x55,0x80,0x01,0x00,0x00,0x00,0xFF,0xFF,
	0xE9,0xAA,0xAB,0x00,0x01,0x00,0x00,0x00, 0xFF,0xFF,0xE8,0xFF,0xFE,0x00,0x01,0x00,
	0x00,0x00,0xFF,0xFF,0xE4,0x00,0x00,0x00, 0x02,0x00,0x00,0x00,0xFF,0xFF,0xF3,0xFF,
	0xFF,0xFF,0xFC,0x00,0x00,0x00,
};


/*WAP Icon 
*/
static const unsigned char iconMainWAP[] =
{
	0xFF,0xDA,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF5,0x00,0x10,0x00,0x00,
	0x00,0x00,0x00,0x00,0xFF,0x6A,0x40,0x80,0x03,0xFC,0x00,0x00,0x00,0x00,0xFF,0xF5,
	0x10,0x00,0x1F,0xFF,0x00,0x00,0x00,0x00,0xFF,0xDA,0x80,0x00,0x3F,0xFF,0xC0,0x00,
	0x00,0x00,0xFF,0xF5,0x40,0x00,0xFC,0x07,0xE0,0x00,0x00,0x00,0xF0,0x68,0x04,0x01,
	0xF0,0x01,0xF0,0x00,0x00,0x00,0xF7,0x35,0xC0,0x71,0xE0,0x00,0xF8,0x3F,0xF0,0x00,
	0xF7,0xB9,0xC0,0xF3,0xC3,0xC7,0x78,0x3F,0xFC,0x00,0xF3,0xB3,0xE0,0xE3,0x8F,0xEF,
	0x38,0x3F,0xFC,0x00,0xFB,0xBB,0xE0,0xE7,0x1F,0xFE,0x3C,0x38,0x1E,0x00,0xFB,0x93,
	0x60,0xE7,0x1E,0x3E,0x1C,0x38,0x0E,0x00,0xF9,0xD7,0x71,0xCF,0x38,0x1E,0x1C,0x38,
	0x0E,0x00,0xFD,0xD7,0x71,0xCE,0x38,0x1E,0x1C,0x38,0x0E,0x00,0xFD,0xC7,0x71,0xCE,
	0x70,0x1C,0x1C,0x38,0x1E,0x00,0xFD,0xEE,0x33,0xCE,0x70,0x1C,0x1C,0x3F,0xFC,0x00,
	0xFC,0xEE,0x3B,0x8E,0x70,0x1C,0x38,0x3F,0xF8,0x00,0xFE,0xEE,0x3B,0x8E,0x70,0x3C,
	0x38,0x3F,0xF0,0x00,0xFE,0xEE,0x3B,0x8E,0x70,0x78,0x70,0x38,0x00,0x00,0xFE,0x7C,
	0x1F,0x0E,0x78,0xF8,0x70,0x38,0x00,0x00,0xFF,0x7D,0x1F,0x07,0x3F,0xF9,0xE0,0x38,
	0x00,0x00,0xFF,0x7C,0x1F,0x07,0x1F,0xBF,0x80,0x38,0x00,0x00,0xFF,0x39,0x4E,0x07,
	0x8F,0x1F,0x0E,0x38,0x00,0x00,0xFF,0xBA,0x0E,0x03,0xC0,0x00,0x1C,0x38,0x00,0x00,
	0xFF,0x81,0x00,0x01,0xF0,0x00,0x78,0x00,0x00,0x00,0xFF,0xEA,0x90,0x00,0xFC,0x01,
	0xF0,0x00,0x00,0x00,0xFD,0xF5,0x00,0x80,0x7F,0xFF,0xE0,0x00,0x00,0x00,0xFF,0xDA,
	0x44,0x00,0x1F,0xFF,0x80,0x00,0x00,0x00,0xFF,0xF5,0x10,0x20,0x03,0xFE,0x00,0x00,
	0x00,0x00,0xFF,0xAA,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xF5,0x22,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
};

#if 0
//Old Condat logo
/*animframe01 Icon 
*/
static const unsigned char animframe01[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
	
};

/*animframe0 Icon 
*/
static const unsigned char animframe0[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
	0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x1C, 0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x00,
	0x00,0x00,0x00,0x00,0x00,0x1F,0x80,0x00, 0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	
};

/*animframe1 Icon 
*/
static const unsigned char animframe1[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,
	0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x3C,
	0x00,0x00,0x00,0x00,0x00,0x00,0x3C,0x00, 0x00,0x00,0x00,0x00,0x00,0x3F,0x00,0x00,
	0x00,0x00,0x00,0x00,0x3F,0xC0,0x00,0x00, 0x00,0x00,0x00,0x3F,0x80,0x00,0x00,0x00,
	0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00, 0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,
	
};

/*animframe2 Icon 
*/
static const unsigned char animframe2[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x1E,0x00,0x00,0x00,0x00,0x00,
	0x00,0x3C,0x00,0x00,0x00,0x00,0x00,0x00, 0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,
	0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00, 0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x00,
	0x00,0x00,0x00,0x00,0x7F,0x80,0x00,0x00, 0x00,0x00,0x00,0x7F,0xE0,0x00,0x00,0x00,
	0x00,0x00,0x7F,0xC0,0x00,0x00,0x00,0x00, 0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x02, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,
};	

/*animframe3 Icon 
*/
static const unsigned char animframe3[] =
{
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,
	0x00,0x3F,0x00,0x00,0x00,0x00,0x00,0x00, 0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,
	0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00, 0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x00,
	0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x00, 0x00,0x00,0x00,0xFF,0xE0,0x00,0x00,0x00,
	0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,0x00, 0x00,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,
	0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x3F, 0x80,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,
	0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,
};

/*animframe4 Icon 
*/
static const unsigned char animframe4[] =
{
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x1F,0xF8,0x00,0x00,0x00,0x00,
	0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,0x00, 0x7F,0xE0,0x00,0x00,0x00,0x00,0x00,0xFF,
	0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0x80, 0x00,0x00,0x00,0x00,0x03,0xFF,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
	0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00, 0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x78,
	0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00, 0x00,0x00,0x00,0x00,0x01,0xFC,0x00,0x00,
	0x00,0x00,0x00,0x03,0xFE,0x00,0x00,0x00, 0x00,0x00,0x03,0xFE,0x00,0x00,0x00,0x00,
	0x00,0x03,0xFF,0x80,0x00,0x00,0x00,0x00, 0x03,0xFF,0xF0,0x00,0x00,0x00,0x00,0x03,
	0xFF,0xFC,0x00,0x00,0x00,0x00,0x03,0xFF, 0xF8,0x00,0x00,0x00,0x00,0x01,0xFF,0xF0,
	0x00,0x00,0x00,0x00,0x00,0xFF,0xE0,0x00, 0x00,0x00,0x00,0x00,0x7F,0xC0,0x00,0x00,
	0x00,0x00,0x00,0x3F,0x80,0x00,0x00,0x00, 0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,
	0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
};

/*animframe5 Icon 
*/
static const unsigned char animframe5[] =
{
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x2A,0xAA,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00, 0x9F,0xFE,0x00,0x00,0x00,0x00,0x00,0x3F,
	0xFC,0x80,0x00,0x00,0x00,0x02,0x7F,0xF9, 0x00,0x00,0x00,0x00,0x00,0xFF,0xF0,0x00,
	0x00,0x00,0x00,0x09,0xFF,0xE4,0x00,0x00, 0x00,0x00,0x03,0xFF,0xC0,0x00,0x00,0x00,
	0x00,0x27,0xFF,0x90,0x00,0x00,0x00,0x00, 0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x99,
	0x55,0x40,0x00,0x00,0x00,0x00,0x38,0x00, 0x00,0x00,0x00,0x00,0x02,0x79,0x00,0x00,
	0x00,0x00,0x00,0x00,0xFC,0x00,0x00,0x00, 0x00,0x00,0x09,0xFC,0x80,0x00,0x00,0x00,
	0x00,0x03,0xFE,0x00,0x00,0x00,0x00,0x00, 0x17,0xFE,0x40,0x00,0x00,0x00,0x00,0x07,
	0xFF,0x14,0x00,0x00,0x00,0x00,0x17,0xFF, 0xC1,0x00,0x00,0x00,0x00,0x07,0xFF,0xF8,
	0x00,0x00,0x00,0x00,0x17,0xFF,0xFE,0x80, 0x00,0x00,0x00,0x03,0xFF,0xFC,0x00,0x00,
	0x00,0x00,0x0B,0xFF,0xF9,0x00,0x00,0x00, 0x00,0x01,0xFF,0xF0,0x00,0x00,0x00,0x00,
	0x04,0xFF,0xE4,0x00,0x00,0x00,0x00,0x00, 0x7F,0xC0,0x00,0x00,0x00,0x00,0x01,0x1F,
	0x90,0x00,0x00,0x00,0x00,0x00,0x47,0x00, 0x00,0x00,0x00,0x00,0x00,0x10,0x40,0x00,
	0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

/*animframe6 Icon 
*/
static const unsigned char animframe6[] =
{
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x22,0x22,0x00,0x00,0x00,0x00,
	0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01, 0x2A,0xAA,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x80,0x00,0x00,0x00,0x04,0x9F,0xFE, 0x08,0x00,0x00,0x00,0x08,0x3F,0xFC,0x80,
	0x00,0x00,0x00,0x02,0x7F,0xF9,0x20,0x00, 0x00,0x00,0x00,0xFF,0xF0,0x00,0x00,0x00,
	0x01,0x49,0xFF,0xE4,0x80,0x00,0x00,0x00, 0x03,0xFF,0xC0,0x40,0x00,0x00,0x00,0x27,
	0xFF,0x90,0x00,0x00,0x00,0x0A,0x08,0x00, 0x05,0x00,0x00,0x00,0x00,0x99,0x55,0x40,
	0x00,0x00,0x00,0x28,0x38,0x11,0x14,0x00, 0x00,0x00,0x02,0x79,0x22,0x21,0x00,0x00,
	0x00,0x00,0xFC,0x00,0x00,0x00,0x00,0x00, 0x09,0xFC,0xA0,0x10,0x00,0x00,0x00,0x43,
	0xFE,0x04,0x80,0x00,0x00,0x00,0x17,0xFE, 0x40,0x00,0x00,0x00,0x00,0x07,0xFF,0x14,
	0x40,0x00,0x00,0x00,0x37,0xFF,0xC1,0x24, 0x00,0x00,0x00,0x47,0xFF,0xF8,0x00,0x00,
	0x00,0x00,0x17,0xFF,0xFE,0x80,0x00,0x00, 0x01,0x03,0xFF,0xFC,0x08,0x00,0x00,0x00,
	0x2B,0xFF,0xF9,0x20,0x00,0x00,0x00,0x01, 0xFF,0xF0,0x00,0x00,0x00,0x00,0x44,0xFF,
	0xE4,0x80,0x00,0x00,0x00,0x00,0x7F,0xC1, 0x40,0x00,0x00,0x00,0x49,0x1F,0x90,0x00,
	0x00,0x00,0x00,0x10,0x47,0x05,0x00,0x00, 0x00,0x00,0x02,0x10,0x40,0x00,0x00,0x00,
	0x00,0x04,0x45,0x14,0x00,0x00,0x00,0x00, 0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x10,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,
	
	
};

/*animframe7 Icon 
*/
static const unsigned char animframe7[] =
{
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x80,0xA0,0x40,0x00,0x00,0x00,
	0x00,0x10,0x08,0x04,0x00,0x00,0x00,0x08, 0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x22,
	0x22,0x00,0x00,0x00,0x00,0x00,0x14,0x51, 0x00,0x00,0x00,0x00,0x85,0x3F,0xFF,0x20,
	0x00,0x00,0x00,0x10,0x40,0x00,0xC0,0x00, 0x00,0x00,0x04,0x9F,0xFE,0x88,0x00,0x00,
	0x08,0x29,0x3F,0xFC,0x80,0x00,0x00,0x01, 0x02,0x7F,0xF9,0x22,0x00,0x00,0x00,0x04,
	0xFF,0xF2,0x00,0x00,0x00,0x01,0x49,0xFF, 0xE4,0x80,0x00,0x00,0x10,0x13,0xFF,0xC8,
	0x40,0x00,0x01,0x00,0x27,0xFF,0x90,0x08, 0x00,0x00,0x0A,0x48,0x00,0x25,0x00,0x00,
	0x00,0x00,0x99,0xFF,0xC0,0x00,0x00,0x00, 0x29,0x3A,0x11,0x14,0x00,0x00,0x00,0x82,
	0x79,0x22,0x21,0x00,0x00,0x00,0x04,0xFD, 0x00,0x00,0x00,0x00,0x00,0x09,0xFC,0xA0,
	0x10,0x00,0x00,0x00,0x53,0xFE,0x84,0x80, 0x00,0x00,0x04,0x17,0xFE,0x60,0x00,0x00,
	0x00,0x00,0x17,0xFF,0x1C,0x40,0x00,0x00, 0x00,0x37,0xFF,0xC3,0x24,0x00,0x00,0x00,
	0x57,0xFF,0xF8,0x80,0x00,0x00,0x00,0x17, 0xFF,0xFE,0x80,0x00,0x00,0x01,0x13,0xFF,
	0xFC,0x88,0x00,0x00,0x00,0x2B,0xFF,0xF9, 0x20,0x00,0x00,0x04,0x09,0xFF,0xF2,0x00,
	0x00,0x00,0x00,0x44,0xFF,0xE4,0x80,0x00, 0x00,0x00,0x02,0x7F,0xC9,0x40,0x00,0x00,
	0x00,0x49,0x1F,0x90,0x04,0x00,0x00,0x00, 0x10,0xC7,0x25,0x00,0x00,0x00,0x00,0x02,
	0x30,0x40,0x20,0x00,0x00,0x00,0x04,0x4F, 0x94,0x00,0x00,0x00,0x00,0x80,0x80,0x00,
	0x00,0x00,0x00,0x00,0x00,0x11,0x12,0x00, 0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00, 0x00,0x00,0x80,0x40,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
	
	
};

/*animframe8 Icon 
*/
static const unsigned char animframe8[] =
{
	
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x80,0xA0,0x40,0x00,0x00,0x00,
	0x00,0x10,0x08,0x04,0x00,0x00,0x00,0x08, 0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x22,
	0x22,0x00,0x00,0x00,0x00,0x00,0x55,0x55, 0x40,0x00,0x00,0x00,0x85,0x7F,0xFF,0xA0,
	0x00,0x00,0x00,0x12,0xC0,0x00,0xC0,0x00, 0x00,0x00,0x05,0x9F,0xFE,0x88,0x00,0x00,
	0x08,0x2B,0x3F,0xFC,0xC0,0x00,0x00,0x01, 0x16,0x7F,0xF9,0xA2,0x00,0x00,0x00,0x2C,
	0xFF,0xF3,0x40,0x00,0x00,0x01,0x59,0xFF, 0xE6,0x80,0x00,0x00,0x10,0xB3,0xFF,0xCD,
	0x40,0x00,0x01,0x01,0x67,0xFF,0x9A,0x08, 0x00,0x00,0x0A,0xC8,0x00,0x35,0x00,0x00,
	0x00,0x05,0x9B,0xFF,0xE8,0x00,0x00,0x00, 0x2B,0x3B,0x55,0x54,0x00,0x00,0x00,0x96,
	0x79,0xA2,0x21,0x00,0x00,0x00,0x0C,0xFD, 0xC0,0x00,0x00,0x00,0x00,0x39,0xFC,0xA0,
	0x10,0x00,0x00,0x00,0x53,0xFE,0xD4,0x80, 0x00,0x00,0x04,0x37,0xFE,0x7A,0x00,0x00,
	0x00,0x00,0x17,0xFF,0x1F,0x40,0x00,0x00, 0x00,0x37,0xFF,0xC3,0xA4,0x00,0x00,0x00,
	0x57,0xFF,0xF8,0xC0,0x00,0x00,0x00,0x37, 0xFF,0xFE,0x80,0x00,0x00,0x01,0x13,0xFF,
	0xFC,0xC8,0x00,0x00,0x00,0x3B,0xFF,0xF9, 0xA0,0x00,0x00,0x04,0x19,0xFF,0xF3,0x40,
	0x00,0x00,0x00,0x4C,0xFF,0xE6,0x80,0x00, 0x00,0x00,0x16,0x7F,0xCD,0x40,0x00,0x00,
	0x00,0x4B,0x1F,0x9A,0x04,0x00,0x00,0x00, 0x15,0xC7,0x35,0x00,0x00,0x00,0x00,0x02,
	0xF0,0x68,0x20,0x00,0x00,0x00,0x04,0x5F, 0xD4,0x00,0x00,0x00,0x00,0x80,0xAA,0xA0,
	0x00,0x00,0x00,0x00,0x00,0x11,0x12,0x00, 0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00, 0x00,0x00,0x80,0x40,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,
	
	
};
#endif

#ifdef EASY_TEXT_ENABLED

// AP - 06/09/2001
/* eZitext Icon
*/

static const unsigned char TextIconeZiText[] = 
{
	0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x07,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x07,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x01,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x01,0x86,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x01,0xF8,0x06,0x00,0x1F,0x99,0xFF,0x80,0x01,0x80,
	0x01,0xF8,0x06,0x00,0x1F,0x99,0xFF,0x80,0x01,0x80,
	0x07,0xF8,0x06,0x00,0x01,0x80,0x18,0x00,0x07,0xE0,
	0x07,0xF8,0x06,0x00,0x01,0x80,0x18,0x00,0x07,0xE0,
	0x18,0x78,0x06,0x06,0x01,0x98,0x18,0x61,0x99,0x80,
	0x18,0x78,0x06,0x06,0x01,0x98,0x18,0x61,0x99,0x80,
	0x01,0xE0,0x06,0x19,0x86,0x18,0x19,0x99,0x99,0x80,
	0x01,0xE0,0x06,0x19,0x86,0x18,0x19,0x99,0x99,0x80,
	0x07,0x80,0x06,0x1F,0x98,0x18,0x19,0xF8,0x61,0x80,
	0x07,0x80,0x06,0x1F,0x98,0x18,0x19,0xF8,0x61,0x80,
	0x18,0x60,0x06,0x18,0x18,0x18,0x19,0x81,0x99,0x98,
	0x18,0x60,0x06,0x18,0x18,0x18,0x19,0x81,0x99,0x98,
	0x1F,0x80,0x06,0x07,0x9F,0x98,0x18,0x79,0x98,0x60,
	0x1F,0x80,0x06,0x07,0x9F,0x98,0x18,0x79,0x98,0x60,
	0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00

};

static const unsigned char TextIconeZiTextSmall[] =
{
	0x03,
	0x03,
	0x18,
	0x7c,
	0xcc,
	0x08,
	0x10,
	0x0c
};

#endif

/* SIM Toolkit icons
*/
static const unsigned char SIMToolAll[] =
{
    /* Large Icon
    */
    0x00,0x1f,0xff,0xf8,0x00, 0x00,0x7f,0xff,0xfe,0x00,
    0x01,0xff,0xff,0xff,0x80, 0x03,0xff,0xff,0xff,0xc0,
    0x07,0xff,0xff,0xff,0xe0, 0x0f,0xff,0xff,0xff,0xf0,
    0x1f,0xff,0xff,0xff,0xf8, 0x3f,0xff,0xff,0xff,0xfc,
    0x7f,0xff,0xff,0xff,0xfe, 0x7f,0xff,0xff,0xff,0xfe,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0x7f,0xff,0xff,0xff,0xfe, 0x7f,0xff,0xff,0xff,0xfe,
    0x3f,0xff,0xff,0xff,0xfc, 0x1f,0xff,0xff,0xff,0xf8,
    0x0f,0xff,0xff,0xff,0xf0, 0x07,0xff,0xff,0xff,0xe0,
    0x03,0xff,0xff,0xff,0xc0, 0x01,0xff,0xff,0xff,0x80,
    0x00,0x7f,0xff,0xfe,0x00, 0x00,0x1f,0xff,0xf8,0x00,

    /* Primary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0xff,0xff,0xff,0x00, 0x07,0xff,0xff,0xff,0xe0,
    0x0f,0xff,0xff,0xff,0xf0, 0x1f,0xff,0xff,0xff,0xf8,
    0x3f,0xff,0xff,0xff,0xfc, 0x7f,0xff,0xff,0xff,0xfe,
    0x7f,0xff,0xff,0xff,0xfe, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0x7f,0xff,0xff,0xff,0xfe,
    0x7f,0xff,0xff,0xff,0xfe, 0x3f,0xff,0xff,0xff,0xfc,
    0x1f,0xff,0xff,0xff,0xf8, 0x0f,0xff,0xff,0xff,0xf0,
    0x07,0xff,0xff,0xff,0xe0, 0x00,0xff,0xff,0xff,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,

    /* Secondary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x0f,0xff,0xf0,0x00, 0x01,0xff,0xff,0xff,0x80,
    0x0f,0xff,0xff,0xff,0xf0, 0x7f,0xff,0xff,0xff,0xfe,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0x7f,0xff,0xff,0xff,0xfe, 0x0f,0xff,0xff,0xff,0xf0,
    0x01,0xff,0xff,0xff,0x80, 0x00,0x0f,0xff,0xf0,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,

    /* Tertiary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x0f,0xff,0xff,0xff,0xf0,
    0x7f,0xff,0xff,0xff,0xfe, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0x7f,0xff,0xff,0xff,0xfe,
    0x0f,0xff,0xff,0xff,0xf0, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00
};

/* Message icons
*/
static const unsigned char MessageAll[] =
{
    /* Large Icon
    */
    0x00,0x1f,0xff,0xf8,0x00, 0x00,0x7f,0xff,0xfe,0x00,
    0x01,0xff,0xff,0xff,0x80, 0x03,0xff,0xff,0xff,0xc0,
    0x07,0xff,0xff,0xff,0xe0, 0x0f,0xff,0xff,0xff,0xf0,
    0x1f,0xc0,0x00,0x03,0xf8, 0x3f,0xdf,0xff,0xf3,0xfc,
    0x7f,0xd7,0xff,0xeb,0xfe, 0x7f,0xdb,0xff,0xdb,0xfe,
    0xff,0xdd,0xff,0xbb,0xff, 0xff,0xde,0xff,0x7b,0xff,
    0xff,0xdf,0x7e,0xfb,0xff, 0xff,0xdf,0xbd,0xfb,0xff,
    0xff,0xdf,0xdb,0xfb,0xff, 0xff,0xdf,0xe7,0xfb,0xff,
    0xff,0xdf,0xff,0xfb,0xff, 0xff,0xdf,0xff,0xfb,0xff,
    0x7f,0xdf,0xff,0xfb,0xfe, 0x7f,0xdf,0xff,0xfb,0xfe,
    0x3f,0xdf,0xff,0xf3,0xfc, 0x1f,0xc0,0x00,0x03,0xf8,
    0x0f,0xff,0xff,0xff,0xf0, 0x07,0xff,0xff,0xff,0xe0,
    0x03,0xff,0xff,0xff,0xc0, 0x01,0xff,0xff,0xff,0x80,
    0x00,0x7f,0xff,0xfe,0x00, 0x00,0x1f,0xff,0xf8,0x00,

    /* Primary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0xff,0xff,0xff,0x00, 0x07,0xff,0xff,0xff,0xe0,
    0x0f,0xff,0xff,0xff,0xf0, 0x1f,0xff,0xff,0xff,0xf8,
    0x3f,0xc0,0x00,0x03,0xfc, 0x7f,0xcf,0xff,0xf3,0xfe,
    0x7f,0xd7,0xff,0xeb,0xfe, 0xff,0xdb,0xff,0xdb,0xff,
    0xff,0xdd,0xff,0xbb,0xff, 0xff,0xde,0xff,0x7b,0xff,
    0xff,0xdf,0x7e,0xfb,0xff, 0xff,0xdf,0xbd,0xfb,0xff,
    0xff,0xdf,0xdb,0xfb,0xff, 0x7f,0xdf,0xe7,0xfb,0xfe,
    0x7f,0xdf,0xff,0xfb,0xfe, 0x3f,0xc0,0x00,0x03,0xfc,
    0x1f,0xff,0xff,0xff,0xf8, 0x0f,0xff,0xff,0xff,0xf0,
    0x07,0xff,0xff,0xff,0xe0, 0x00,0xff,0xff,0xff,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,

    /* Secondary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x0f,0xff,0xf0,0x00, 0x01,0xff,0xff,0xff,0x80,
    0x0f,0xff,0xff,0xff,0xf0, 0x7f,0xff,0xff,0xff,0xfe,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0xff,0xff,0xff,0xff,0xff,
    0x7f,0xff,0xff,0xff,0xfe, 0x0f,0xff,0xff,0xff,0xf0,
    0x01,0xff,0xff,0xff,0x80, 0x00,0x0f,0xff,0xf0,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,

    /* Tertiary Icon
    */
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x0f,0xff,0xff,0xff,0xf0,
    0x7f,0xff,0xff,0xff,0xfe, 0xff,0xff,0xff,0xff,0xff,
    0xff,0xff,0xff,0xff,0xff, 0x7f,0xff,0xff,0xff,0xfe,
    0x0f,0xff,0xff,0xff,0xf0, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00, 0x00,0x00,0x00,0x00,0x00
};

static const unsigned char TILogo_bw[] = {
0x00,0x00,0x3F,0xE0,0x00,0x00,0x00, 0x00,0x00,0x3F,0xE0,0x00,0x00,0x00, 0x00,0x00,0x3F,0xE0,0x00,0x00,0x00, 0x00,0x00,0x3F,0xE0,0x00,0x00,0x00,
0x00,0x00,0x3F,0xE0,0xE0,0x00,0x00, 0x00,0x00,0x3F,0xE0,0xE0,0x00,0x00, 0x00,0x00,0x3F,0xF0,0xE0,0x00,0x00, 0x00,0x00,0x3F,0xF8,0xE0,0x00,0x00,
0x00,0x00,0x3F,0xF8,0x07,0xF0,0x00, 0x00,0x00,0x3F,0xF8,0x07,0xF0,0x00, 0x00,0x00,0x3F,0xF1,0xC7,0xF0,0x00, 0x00,0x00,0x3F,0xF3,0xCF,0xF0,0x00,
0x00,0x00,0x3F,0x83,0xC1,0xF0,0x00, 0x00,0x00,0x3F,0x83,0x81,0xF0,0x00, 0x00,0x00,0x3F,0x83,0x81,0xF8,0x00, 0x00,0xFF,0xFF,0x03,0x81,0xF8,0x00,
0x00,0xFF,0xFF,0x03,0x81,0xFC,0x00, 0x00,0xFF,0xFF,0xE7,0x9F,0xFE,0x00, 0x00,0x7F,0xFF,0xE7,0x9F,0xFE,0x00, 0x00,0x3F,0xFF,0xE7,0x1F,0xFE,0x00,
0x00,0x1F,0xFF,0xEF,0x3F,0xFC,0x00, 0x00,0x0F,0xFF,0xCF,0x3F,0xFC,0x00, 0x00,0x07,0xFF,0xCF,0x7F,0xFC,0x00, 0x00,0x07,0xFF,0xC0,0x27,0xFC,0x00,
0x00,0x07,0xF3,0xC0,0x0F,0xF0,0x00, 0x00,0x03,0xC3,0xC0,0x0F,0xE0,0x00, 0x00,0x01,0xC1,0xE0,0x1F,0x00,0x00, 0x00,0x00,0x00,0xE0,0x3E,0x00,0x00,
0x00,0x00,0x00,0xF8,0xFC,0x00,0x00, 0x00,0x00,0x00,0x7F,0xF8,0x00,0x00, 0x00,0x00,0x00,0x7F,0xF0,0x00,0x00, 0x00,0x00,0x00,0x3F,0xE0,0x00,0x00,
0x00,0x00,0x00,0x3F,0xE0,0x00,0x00, 0x00,0x00,0x00,0x1F,0xE0,0x00,0x00, 0x00,0x00,0x00,0x0F,0xE0,0x00,0x00, 0x00,0x00,0x00,0x0F,0xE0,0x00,0x00,
0x00,0x00,0x00,0x03,0xE0,0x00,0x00, 0x00,0x00,0x00,0x03,0xE0,0x00,0x00};

/*
0x00,0x3F,0xE0,0x00,0x00, 0x00,0x3F,0xE0,0x00,0x00, 0x00,0x3F,0xE0,0x00,0x00, 0x00,0x3F,0xE0,0x00,0x00,
0x00,0x3F,0xE0,0xE0,0x00, 0x00,0x3F,0xE0,0xE0,0x00, 0x00,0x3F,0xF0,0xE0,0x00, 0x00,0x3F,0xF8,0xE0,0x00,
0x00,0x3F,0xF8,0x07,0xF0, 0x00,0x3F,0xF8,0x07,0xF0, 0x00,0x3F,0xF1,0xC7,0xF0, 0x00,0x3F,0xF3,0xCF,0xF0,
0x00,0x3F,0x83,0xC1,0xF0, 0x00,0x3F,0x83,0x81,0xF0, 0x00,0x3F,0x83,0x81,0xF8, 0xFF,0xFF,0x03,0x81,0xF8,
0xFF,0xFF,0x03,0x81,0xFC, 0xFF,0xFF,0xE7,0x9F,0xFE, 0x7F,0xFF,0xE7,0x9F,0xFE, 0x3F,0xFF,0xE7,0x1F,0xFE,
0x1F,0xFF,0xEF,0x3F,0xFC, 0x0F,0xFF,0xCF,0x3F,0xFC, 0x07,0xFF,0xCF,0x7F,0xFC, 0x07,0xFF,0xC0,0x27,0xFC,
0x07,0xF3,0xC0,0x0F,0xF0, 0x03,0xC3,0xC0,0x0F,0xE0, 0x01,0xC1,0xE0,0x1F,0x00, 0x00,0x00,0xE0,0x3E,0x00,
0x00,0x00,0xF8,0xFC,0x00, 0x00,0x00,0x7F,0xF8,0x00, 0x00,0x00,0x7F,0xF0,0x00, 0x00,0x00,0x3F,0xE0,0x00,
0x00,0x00,0x3F,0xE0,0x00, 0x00,0x00,0x1F,0xE0,0x00, 0x00,0x00,0x0F,0xE0,0x00, 0x00,0x00,0x0F,0xE0,0x00,
0x00,0x00,0x03,0xE0,0x00, 0x00,0x00,0x03,0xE0,0x00 };*/

/*******************************************************************************
                                                                              
                                Icon Attribute structures
                                                                              
*******************************************************************************/
//GW #1555 - Adapted icons for large monochrome display by scaling 2xwidth, 4xheight
#ifndef COLOURDISPLAY
#ifdef LSCREEN
#define ICONTYPE 0x0080
#define ICNSX 2
#define ICNSY 4
#else
#define ICONTYPE ICON_TYPE_1BIT_UNPACKED
#define ICNSX 1
#define ICNSY 1
#endif
#else
#define ICONTYPE ICON_TYPE_256_COL

#endif


#ifndef COLOURDISPLAY

#ifndef LSCREEN
const MfwIcnAttr idl_Attr [idlIdMax] =  		        /* all our icon attributes  */
{
    { { 13,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSMS       },  	/* short message indicator  */
    { { 36,  0, 12,  6 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlVoice     },   /* voice mail indicator     */
    { { 50,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCallforw  },	/* call forwarding uncond.  */
    { { 59,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSilRinger },  	/* silent ringer            */
    { { 60,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlKeypLock  },   /* keypad locked            */
    { { 23,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCipheringActiv },		/* Ciphering       */    
    { { 23,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCipheringDeActiv },		/* Ciphering       */    
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },					/*ringer icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },					/*vibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },					/*ringvibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },					/*alarm icon*/
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) SIMToolAll   },  	/* SIMToolkit  Large        */
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) MessageAll   },   /* Messages    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },    					/* Organiser   Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },	    				/* Sounds      Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },		    			/* Settings    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },			    		/* Services    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },			    		/* Extra    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICONTYPE,  0 },			    		/* WAP    Large        */
    { { 60,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlGPRSOn  },		/* SH - GPRS On icon           */
    { { 60,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlHomezone  },	/* SH - Homezone icon           */
    { { 60,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlTTY  }	/* SPR#1352 - SH - TTY icon           */
};
#else

#define ICON_Y_OFS 6

const MfwIcnAttr idl_Attr [idlIdMax] =  		        /* all our icon attributes  */
{
    { { 13*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSMS       },  	/* short message indicator  */
    { { 36*ICNSX,  ICON_Y_OFS, 12*ICNSX,  6*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlVoice     },   /* voice mail indicator     */
    { { 50*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCallforw  },	/* call forwarding uncond.  */
    { { 59*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSilRinger },  	/* silent ringer            */
    { { 60*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlKeypLock  },   /* keypad locked            */
    { { 23*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCipheringActiv },		/* Ciphering       */    
    { { 23*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlCipheringDeActiv },		/* Ciphering       */    
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*ringer icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*vibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*ringvibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*alarm icon*/
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  (char *) SIMToolAll   },  	/* SIMToolkit  Large        */
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  (char *) MessageAll   },   /* Messages    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },    					/* Organiser   Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },	    				/* Sounds      Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },		    			/* Settings    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },			    		/* Services    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },			    		/* Extra    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },			    		/* WAP    Large        */
    { { 60*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlGPRSOn  },		/* SH - GPRS On icon           */
    { { 60*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlHomezone  },	/* SH - Homezone icon           */
    { { 60*ICNSX,  ICON_Y_OFS,  8*ICNSX,  5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlTTY  }	/* SPR#1352 - SH - TTY icon           */
};
#endif //Large b+w display

#else


#define ICON_POS_Y		(1)
#ifdef WIDEICONS
#define ICON_SX			(21)
#define ICON_WIDTH 			((SCREEN_SIZE_X)/8)
#define ICON_POS_X_BATT		(0)
#define ICON_POS_X_CPR		(ICON_WIDTH)
#define ICON_POS_X_MSG		(ICON_WIDTH*2)
#define ICON_POS_X_VMAIL	(ICON_WIDTH*3)
#define ICON_POS_X_FOR		(ICON_WIDTH*4)
#define ICON_POS_X_KLK		(ICON_WIDTH*5)
#define ICON_POS_X_GPRS		(ICON_WIDTH*6)
#define ICON_POS_X_HZONE	(ICON_WIDTH*6)
#define ICON_POS_X_SIG		(ICON_WIDTH*7)
#define ICON_POS_X_SRNG		(0)
#else
#define ICON_SX			(19)	
#define ICON_WIDTH 			((SCREEN_SIZE_X)/9)
#define ICON_POS_X_BATT		(0)
#define ICON_POS_X_CPR		(ICON_WIDTH)
#define ICON_POS_X_MSG		(ICON_WIDTH*2)
#define ICON_POS_X_VMAIL	(ICON_WIDTH*3)
#define ICON_POS_X_FOR		(ICON_WIDTH*4)
#define ICON_POS_X_KLK		(ICON_WIDTH*5)
#define ICON_POS_X_GPRS		(ICON_WIDTH*6)
#define ICON_POS_X_HZONE	(ICON_WIDTH*7)
#define ICON_POS_X_SIG		(ICON_WIDTH*8)
#define ICON_POS_X_SRNG		(0)
#endif
#define ICON_SY			(22)

const MfwIcnAttr idl_Attr [idlIdMax] =  		        /* all our icon attributes  */
{

    { { ICON_POS_X_MSG, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_msgColour       },  	/* short message indicator  */
    { { ICON_POS_X_VMAIL, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_voicemailColour  },	/* call forwarding uncond.  */
    { { ICON_POS_X_FOR, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_forColour  },	/* call forwarding uncond.  */
    { { ICON_POS_X_SRNG,  1,  8,  5 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  (char *) idlSilRinger },  	/* silent ringer            */
    { { ICON_POS_X_KLK, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_klkColour  },   /* keypad locked            */
    { { ICON_POS_X_CPR, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_cipheringActivColour },		/* Ciphering       */    
    { { ICON_POS_X_CPR, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_cipheringDeactivColour },		/* Ciphering       */    
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*ringer icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*vibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*ringvibrator icon*/
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },					/*alarm icon*/
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  (char *) SIMToolAll   },  	/* SIMToolkit  Large        */
    { { 24, 18, 40, 28 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  (char *) MessageAll   },   /* Messages    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },    					/* Organiser   Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },	    				/* Sounds      Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },		    			/* Settings    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },			    		/* Services    Large        */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },		    			/* SPR#1626 - SH - Added */
    { {  0,  0,  0,  0 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  0 },			    		/* SPR#1626 - SH - Added        */
    { { ICON_POS_X_GPRS, ICON_POS_Y, ICON_SX, ICON_SY }, 	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,   (char *)I_gprsColour  },		/* sbh - GPRS On icon           */
    { { ICON_POS_X_HZONE, ICON_POS_Y, ICON_SX, ICON_SY },	1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_homeZoneColour  },	/* sbh - GPRS Attached icon           */
    { { ICON_POS_X_HZONE,  ICON_POS_Y,  15,  14 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) idlTTYLarge  }	/* SPR#1958 - SH - TTY icon now larger,colour */
};

#endif

#ifndef COLOURDISPLAY
#ifdef LSCREEN
const MfwIcnAttr batt_Attr [iconBattMax] =  	        /* all batt icon attributes */
{
    { { 3*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery4   }, 		/* battery status 0-4%      */
    { { 3*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery14  },	    /* battery status 5-14%     */
    { { 3*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery24  },	   	/* battery status 15-24%    */
    { { 3*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery49  }, 		/* battery status 25-49%    */
    { { 3*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery100 }	    /* battery status 50-100%   */
};	
#else
const MfwIcnAttr batt_Attr [iconBattMax] =  	        /* all batt icon attributes */
{
    { { 3, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery4   }, 		/* battery status 0-4%      */
    { { 3, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery14  },	    /* battery status 5-14%     */
    { { 3, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery24  },	   	/* battery status 15-24%    */
    { { 3, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery49  }, 		/* battery status 25-49%    */
    { { 3, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlBattery100 }	    /* battery status 50-100%   */
};	
#endif
#else
const MfwIcnAttr batt_Attr [iconBattMax] =  	        /* all batt icon attributes */
{
    { { ICON_POS_X_BATT, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_batColour4   }, 		/* battery status 0-4%      */
    { { ICON_POS_X_BATT, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_batColour14  },	    /* battery status 5-14%     */
    { { ICON_POS_X_BATT, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_batColour24  },	   	/* battery status 15-24%    */
    { { ICON_POS_X_BATT, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_batColour49  }, 		/* battery status 25-49%    */
    { { ICON_POS_X_BATT, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_batColour100 }	    /* battery status 50-100%   */
};	
#endif

#ifndef COLOURDISPLAY
#ifdef LSCREEN
const MfwIcnAttr sign_Attr [iconSignalMax] =	        /* all sig icon attributes  */
{
    { { 75*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr49  }, 		/* signal status 0-49       */
    { { 75*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr99  },    	/* signal status 50-99      */
    { { 75*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr149 },	    /* signal status 100-149    */
    { { 75*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr199 },    	/* signal status 150-199    */
    { { 75*ICNSX, ICON_Y_OFS, 8*ICNSX, 5*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr255 }	    /* signal status 200-255    */

};
#else
const MfwIcnAttr sign_Attr [iconSignalMax] =	        /* all sig icon attributes  */
{
    { { 75, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr49  }, 		/* signal status 0-49       */
    { { 75, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr99  },    	/* signal status 50-99      */
    { { 75, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr149 },	    /* signal status 100-149    */
    { { 75, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr199 },    	/* signal status 150-199    */
    { { 75, 1, 8, 5 }, 1, COLOUR_ICON_XX, ICONTYPE,  (char *) idlSigStr255 }	    /* signal status 200-255    */

};
#endif
#else
const MfwIcnAttr sign_Attr [iconSignalMax] =	        /* all sig icon attributes  */
{
    { { ICON_POS_X_SIG, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_sigColour49  }, 		/* signal status 0-49       */
    { { ICON_POS_X_SIG, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_sigColour99  },    	/* signal status 50-99      */
    { { ICON_POS_X_SIG, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) I_sigColour149 },	    /* signal status 100-149    */
    { { ICON_POS_X_SIG, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL, (char *) I_sigColour199 },    	/* signal status 150-199    */
    { { ICON_POS_X_SIG, ICON_POS_Y, ICON_SX, ICON_SY }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL, (char *) I_sigColour255 }	    /* signal status 200-255    */

};
#endif

#ifndef COLOURDISPLAY
const MfwIcnAttr goodbye_Attr [animGoodbye] =  	        /* all goodby icon attributes */
{
/*    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+1, 56, 42 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe8 }, 		
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+1, 56, 42 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe7 },	    
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+4, 56, 36 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe6 },	   
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+6, 56, 32 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe5 }, 		
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+9, 56, 27 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe4 },	    
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+11, 56, 23 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe3 }, 	
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+12, 56, 21 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe2 },	   
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+13, 56, 19 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe1 }, 
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+22, 56, 9 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe0 },	    
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+26, 56, 4 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe01 }	    */
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_GOODBYE, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] }
};	

const MfwIcnAttr welcome_Attr [animwelcome] =  	        
{
/*    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+26, 56, 4 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe01 },		
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+22, 56, 9 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe0 },	   
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+13, 56, 19 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe1 },	   
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+12, 56, 21 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe2 }, 	
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+11, 56, 23 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe3 },	  
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+9, 56, 27 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe4 }, 		
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+6, 56, 32 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe5 },	    
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+4, 56, 36 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe6 }, 		
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+1, 56, 42 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe7 },	    
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y+1, 56, 42 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *) animframe8 }	    
*/
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] },
{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] }
};	

#else

const MfwIcnAttr welcome_Attr [animwelcome] =  	    
{
	{ { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   , 176, 60 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *)&TIlogColour[0]  },	
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   , 176, 60 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *)&TIlogColour[0]  }	

};
/* GW #1471 11/12/02 - Add TI logo as powerdown animation */
const MfwIcnAttr goodbye_Attr [animGoodbye] =  	        /* all goodby icon attributes */
{
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   , 176, 60 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *)&TIlogColour[0]  },	
    { { WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   , 176, 60 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *)&TIlogColour[0]  }	
};


#endif

#ifdef COLOURDISPLAY
const MfwIcnAttr incoming_call_animate [CALLANIMATION] = { 
	{{40,5,100,80},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR, (char *)callAnimation1},
	{{40,5,100,80},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR, (char *)callAnimation2},
	{{40,5,100,80},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR, (char *)callAnimation3},
	{{40,5,100,80},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR, (char *)callAnimation2}
	
};

#endif
/* test                     
*/
static const MfwIcnAttr simtool     =			
{
    { 24, 18, 40, 28 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) SIMToolAll
};

/* icon messages            
*/
static const MfwIcnAttr mess        =			
{
    { 24, 18, 40, 28 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) MessageAll
};

/* icon organiser           
*/
static const MfwIcnAttr organ       =			
{
    { 0, 0, 0, 0 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, 0
};

/* icon sounds              
*/
static const MfwIcnAttr sound       =			
{
    { 0, 0, 0, 0 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, 0
};

/* icon settings            
*/
static const MfwIcnAttr sett         =			
{
    { 0, 0, 0, 0 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, 0
};

/* icon services            
*/
static const MfwIcnAttr servic       =			
{
    { 0, 0, 0, 0 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, 0
};

/* icon extras              
*/
static const MfwIcnAttr extr         =			
{
    { 0, 0, 0, 0 }, 4, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, 0
};


/*** MAIN ICONS **/

MfwIcnAttr mainIconSimToolkit        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainSimToolkit
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) stkColour
#endif
};

MfwIcnAttr mainIconCalculator        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainCalculator
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) applications110x110_bmp
#else
	{ 0, 12, 97, 97 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) applications97x97_bmp
#endif
#endif
};

MfwIcnAttr mainIconSettings        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainSettings
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) phonesettings110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) phoneSettings96x96_bmp
#endif
#endif
};

MfwIcnAttr mainIconRecentCalls        =	
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainRecentCalls
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) recentcalls110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) recentcalls96x96_bmp
#endif

#endif
};
MfwIcnAttr mainIconCallDivert        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainCallDivert
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) networkservices110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) netWorkServices96x96_bmp
#endif
	
#endif
};
MfwIcnAttr mainIconSecurity        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainSecurity
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) security110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) security96x96_bmp
#endif
#endif
};
MfwIcnAttr mainIconMessages        =			
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainMessages
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) messages110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) messages96x96_bmp
#endif
#endif
};

MfwIcnAttr mainIconPhonebook        =		
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainPhonebook
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) phonebook110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) phonebook96x96_bmp
#endif
#endif
};

MfwIcnAttr mainIconWAP		        =		
{
#ifndef COLOURDISPLAY
    { 2, 8, 80*ICNSX, 31*ICNSY }, 1, COLOUR_ICON_XX, ICONTYPE, (char *) iconMainWAP
#else
#ifdef USE_110X110
	{ 0, 12, 110, 110 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) wap110x110_bmp
#else
	{ 0, 12, 96, 96 }, 1, COLOUR_ICON_XX, ICON_TYPE_256_COL,  (char *) wap96x96_bmp
#endif
#endif
};

MfwIcnAttr mainIconGoodbye        =		
{
//    { 13, 0, 56, 48 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) animframe8
	{ WELCOME_ANI_POS_X, WELCOME_ANI_POS_Y   ,  56, 38 }, 1, COLOUR_STATUS_WELCOME, ICON_TYPE_1BIT_UNPACKED,  (char *)&TILogo_bw[0] 
};

#ifdef EASY_TEXT_ENABLED

/* API - 03/09/03 - SPR2383 - Edit the px and py positons so that the icon is in themiddle of the screen for 1.7.0*/
#ifdef COLOURDISPLAY
MfwIcnAttr IconTexteZiText			=
{
	{(SCREEN_SIZE_X / 2) - 40, (SCREEN_SIZE_Y / 2) - 10, 80, 20}, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) TextIconeZiText 
};
#else
MfwIcnAttr IconTexteZiText			=
{
	{2, 8, 80, 20}, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) TextIconeZiText 
};
#endif
/* API - 03/09/03 - SPR2383 - END*/

MfwIcnAttr IconTexteZiTextSmall			=
{
	{2, 12, 8, 8}, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) TextIconeZiTextSmall 
};

#endif

#ifdef COLOURDISPLAY
MfwIcnAttr mainIconBackground = 
	{{ 0, 0, 176, 220 }, 1, COLOUR_ICON_XX, COLOUR_ICON_XX,  (char *)bmpDataSquares };
#else
MfwIcnAttr mainIconBackground = 
	{{ 0, 0, SCREEN_SIZE_X, SCREEN_SIZE_Y  }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED,  NULL };
#endif

/*******************************************************************************

 $Function:    	icon_setMainBgdBitmap

 $Description:	Change the background bitmap for the main menu to the id supplied
 
 $Returns:		None.

 $Arguments:	bmpId - enumerated type for background bitmaps
 
*******************************************************************************/
void icon_setMainBgdBitmap (int bmpId)
{
	TRACE_FUNCTION("icon_setMainBgdBitmap()");
	icon_getBitmapFromId(bmpId,  &mainIconBackground);		
}


/*** Melodygenerator Icons ***/

const MfwIcnAttr melodygenerator_Attr [screenparts] =  	        /* all welcome icon attributes */
{
    { { 2, 8, 16, 26 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) screenpart0 },		/* screenpart0*/
    { { 18, 8, 16, 26 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) screenpart1 },	    /* screenpart1*/
    { { 34, 8, 16, 26 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) screenpart2 },	   	/* screenpart2*/
    { { 50, 8, 16, 26 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) screenpart3 }, 	/* screenpart3*/
    { { 66, 8, 16, 26 }, 1, COLOUR_ICON_XX, ICON_TYPE_1BIT_UNPACKED, (char *) screenpart4 }	    /* screenpart4*/
};	
/*******************************************************************************
                                                                              
                                Additional type definitions
                                                                              
*******************************************************************************/

typedef struct iconStateTag             /* state icons              */
{
    MfwHnd h;                           /* mfw handle of icon       */
    U8 state;                           /* state of icon            */
} IconState;


/*******************************************************************************
                                                                              
                                Static data
                                                                              
*******************************************************************************/

static IconState state[ idlIdMax ];
static IconState battstate[ iconBattMax ];
static IconState signalstate[ iconSignalMax ];




/*******************************************************************************
                                                                              
                                Private Methods
                                                                              
*******************************************************************************/


/*******************************************************************************

 $Function:    	iconsEvent

 $Description:	handle an icon event, empty handler
 
 $Returns:		None.

 $Arguments:	e, event, i, icon
 
*******************************************************************************/

static void iconsEvent( MfwEvt e, MfwIcn *i )
{
}


/*******************************************************************************

 $Function:    	iconsBattEvent

 $Description:	handle a battery icon event, empty handler
 
 $Returns:		None.

 $Arguments:	e, event, i, icon
 
*******************************************************************************/

static void iconsBattEvent( MfwEvt e, MfwIcn *i )
{
}



/*******************************************************************************

 $Function:    	iconsSignEvent

 $Description:	handle a signal icon event, empty handler
 
 $Returns:		None.

 $Arguments:	e, event, i, icon
 
*******************************************************************************/

static void iconsSignEvent( MfwEvt e, MfwIcn *i )
{
}



/*******************************************************************************

 $Function:    	iconsScreenDelete

 $Description:	Clears the icon area of all currently displayed icons
 
 $Returns:		None.

 $Arguments:	None.
 
*******************************************************************************/

static void iconsScreenDelete( void )
{
    dspl_Clear( 0,0, SCREEN_SIZE_X, Mmi_layout_IconHeight()-1 );
}




/*******************************************************************************

 $Function:    	iconsShowIcon

 $Description:	display a single icon if it is currently visible
 
 $Returns:		None

 $Arguments:	Icon, pointer to the icon in question
 
*******************************************************************************/

static void iconsShowIcon( IconState *Icon )
{
	if ( Icon->state == ICON_VISIBLE )
	{
		icnShow( Icon->h );
	}
}





/*******************************************************************************
                                                                              
                                Public Methods
                                                                              
*******************************************************************************/

/*******************************************************************************

 $Function:    	iconsInit

 $Description:	Initialise the MMI Icon handling
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void iconsInit()
{
    int i;

	/* Create and initialise each of the icon state tables, to provide
	   invisible (initially) icons
	*/
    for (i = 0; i < idlIdMax; i++)
    {
       state[i].state = ICON_INVISIBLE;
       state[i].h = icnCreate( 0, (MfwIcnAttr *)&idl_Attr[i], E_ICN_VISIBLE, (MfwCb) iconsEvent );
    }

	/* Battery icons
	*/
	for (i = 0; i < iconBattMax; i++)
    {
        battstate[i].state = ICON_INVISIBLE;
        battstate[i].h = icnCreate( 0, (MfwIcnAttr *)&batt_Attr[i], E_ICN_VISIBLE, (MfwCb) iconsBattEvent );
    }

	/* Signal icons
	*/
	for (i = 0; i < iconSignalMax; i++)
    {
        signalstate[i].state = ICON_INVISIBLE;
        signalstate[i].h = icnCreate( 0, (MfwIcnAttr *)&sign_Attr[i], E_ICN_VISIBLE, (MfwCb) iconsSignEvent );
    }
}





/*******************************************************************************

 $Function:    	iconsExit

 $Description:	Exit the MMI icons handling
 
 $Returns:		None.

 $Arguments:	None.
 
*******************************************************************************/

void iconsExit( void )
{
    int i;

	/* Delete all of the icons created during the iconsInit routine
	*/
    for ( i = 0; i < idlIdMax; i++ )
        icnDelete( state[i].h );

    for ( i = 0; i < iconBattMax; i++ )
        icnDelete( battstate[i].h );

	for ( i = 0; i < iconSignalMax; i++ )
        icnDelete( signalstate[i].h );

}

//API - 1259 - 13-01-03 - Removed Functions iconsChargeDisplayOnOff & iconsStateOfCharge they were not being called.

/*******************************************************************************

 $Function:    	iconsGetState

 $Description:	Get the state of an icon ICON_VISIBLE/ICON_INVISIBLE
 
 $Returns:		Return state of icon.

 $Arguments:	iconId, the id of the icon to be set
 
*******************************************************************************/

U8 iconsGetState( int iconId )
{
	TRACE_FUNCTION("iconsGetState() ");
	/* Only set the state if the iconId is valid, ie in range
	*/
    if ( ( iconId >= 0 ) && ( iconId < idlIdMax ) )
       return state[iconId].state;
}

/*******************************************************************************

 $Function:    	iconsSetState

 $Description:	Sets the state of an icon to be visible
 
 $Returns:		None

 $Arguments:	iconId, the id of the icon to be set
 
*******************************************************************************/

void iconsSetState( int iconId )
{
	TRACE_FUNCTION("iconsSetState() ");
	/* Only set the state if the iconId is valid, ie in range
	*/
    if ( ( iconId >= 0 ) && ( iconId < idlIdMax ) )
        state[iconId].state = ICON_VISIBLE;
}





/*******************************************************************************

 $Function:    	iconsDeleteState

 $Description:	Sets the state of an icon to be invisible
 
 $Returns:		None

 $Arguments:	iconId, the id of the icon to be deleted
 
*******************************************************************************/

void iconsDeleteState( int iconId )
{
	TRACE_FUNCTION("iconsDeleteState()");
	/* Only set the state if the iconId is valid, ie in range
	*/
    if ( ( iconId >= 0 ) && ( iconId < idlIdMax ) )
        state[iconId].state = ICON_INVISIBLE;
}




/*******************************************************************************

 $Function:    	iconsShow

 $Description:	Show the current set of icons on the display
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void iconsShow( void )
{
	// U32 oldfcol,oldbcol; // RAVI - Not used.

    TRACE_FUNCTION("iconsShow");

	/* The power-off scenario requires a check in here to override the
	   normal behaviour of the show routine
	*/

		//nm + 25.2.01
		//it is only temporary for the B-Sample
		// just testing the icon
        globalBatteryPicNumber = 4;
		resources_setTitleColour( COLOUR_IDLE );
#ifndef COLOURDISPLAY
		iconsScreenDelete();
#endif

		if ( GlobalIconStatus & GlobalBatteryIconFlag )
			iconsShowBattery( globalBatteryPicNumber );
		
		if ( GlobalIconStatus & GlobalSignalIconFlag )
			iconsShowSignal( globalSignalPicNumber );
		//  Apr 27, 2004    REF: ENH 12646  Deepa M.D
		if ( GlobalIconStatus & GlobalSMSIconFlag )
		{
			if (smsidle_get_memory_full())  //If memory is full, blink the SMS icon
				iconsShowSmsFull ( );
			else
				iconsShowIcon( &state[ iconIdSMS ] );  //else show the normal SMS icon
		}

//nm do it later, step by step

		if ( GlobalIconStatus & GlobalVoiceMailIconFlag )
			iconsShowIcon( &state[ iconIdVoice ] );

		if ( GlobalIconStatus & GlobalCallForwardingIconFlag )
			iconsShowIcon( &state[ iconIdCallFor ] );


		if ( GlobalIconStatus & GlobalKeyplockIconFlag )
			iconsShowIcon( &state[ iconIdKeyplock ] );

		if ( GlobalIconStatus & GlobalCipheringActivIconFlag )
			iconsShowIcon( &state[ iconIdCipheringActiv ] );

		if ( GlobalIconStatus & GlobalCipheringDeactivIconFlag )
			iconsShowIcon( &state[ iconIdCipheringDeActiv ] );

		/* SPR#2346 - SH - Show GPRS Attached icon*/

		#ifdef MMI_GPRS_ENABLED
		if ( GlobalIconStatus & GlobalGPRSOnIconFlag )
		{
			GPRS_Status();
			iconsShowIcon( &state[ iconIdGPRSOn ] );
		}
		#endif

		/* SPR#1985 - SH - Only show one of TTY or Homezone icons.
		 * Homezone takes precedence */
		 
		/* Show Homezone icon. */
		
		#ifdef MMI_HOMEZONE_ENABLED
		if ( GlobalIconStatus & GlobalHomezoneIconFlag )
		{
			iconsShowIcon( &state[ iconIdHomezone ] );
		}
		#endif

		/* Show TTY icon if active & homezone icon is not shown */
		#ifdef MMI_TTY_ENABLED
		if ( (GlobalIconStatus & GlobalTTYIconFlag) &&
			!( ( GlobalIconStatus & GlobalHomezoneIconFlag ) && state[iconIdHomezone].state==ICON_VISIBLE ) )
		{
			iconsShowIcon( &state[ iconIdTTY ] );
		}
		#endif
		/* end SH */


		

		if ( GlobalIconStatus & GlobalAlarmIconFlag )
			iconsShowIcon( &state[ iconIdAlarm ] );

	//Change the colour back to what the menu was.
	resources_restoreMnuColour();
}



/*******************************************************************************

 $Function:    	iconsShowBattery

 $Description:	Show battery status icons
 
 $Returns:		0 if error detected, otherwise 1

 $Arguments:	batterystatus, the current battery icon to be displayed
 
*******************************************************************************/

int iconsShowBattery( U8 batterystatus )
{
	int i;

	/* If we have an error, ie invalid id then return 0
	*/
	if ( ( batterystatus < 0 ) || ( batterystatus >= iconBattMax ) )
        return 0;

	/* Otherwise clear all of the battery icons, and then set the
	   selected value to be visible
	*/
    for( i = 0; i < iconBattMax; i++ )
        battstate[ i ].state = ICON_INVISIBLE;
	battstate[ batterystatus ].state = ICON_VISIBLE;

	/* and display the current selection
	*/
    icnShow( battstate[ batterystatus ].h );

	return 1;
}


//  Apr 27, 2004    REF: ENH 12646  Deepa M.D 
/*******************************************************************************

  $Function:    	iconsShowSmsFull
  
  $Description:	When SMS meory is full,start the timer for blinking the icon. 
	
  $Returns:		0 if error detected, otherwise 1
	  
  $Arguments:	None
		
*******************************************************************************/
int iconsShowSmsFull(  )
{
	// int i;  // RAVI
	MfwIcn *icn;
	TRACE_FUNCTION("iconsShowSmsFull");
	if(isIconBlinking==1)
	{
		if(smsStatus==0)  
		{
			
			icn=((MfwHdr *)state[ iconIdSMS ] .h)->data;
			dspl_BitBlt2(icn->attr->area.px,icn->attr->area.py,
				icn->attr->area.sx,icn->attr->area.sy,
				icn->attr->icons,icn->index,icn->attr->icnType);
		}
		return 0;
	}
	
	isIconBlinking=1;
	
	if (sms_animate)
	{
		
		timStart(sms_animate);
	}
	
	return 1;
}

//  Apr 27, 2004    REF: ENH 12646  Deepa M.D 
/*******************************************************************************

  $Function:    	smsFullEventTim
  
  $Description:	Callback function for SMSFull timer.The SMS icon is toggled between visible 
				and invisible.
				
  $Returns:	Event consumed
				  
  $Arguments: unused	
					
*******************************************************************************/

int smsFullEventTim( MfwEvt e, MfwTim *tc )
{
	
	TRACE_FUNCTION("smsFullEventTim");

//	Oct 28, 2004    REF: CRR 25886 xnkulkar
// 	Description: SMS Icon is not seen in Idle Screen.
// 	Solution: A check is done to determine if sms memory is full when the phone is in idle screen or
//			when any calls are present and blinking sms icon is displayed.		
	if(idleIsFocussed() ||(call_data.calls.numCalls!=0))    
	{
		smsStatus++;
		if( smsStatus<0 ||  smsStatus>=2)
			smsStatus=0;
		
		if(smsStatus==0)   //The icon will be visible
		{
			state[ iconIdSMS ] .state = ICON_VISIBLE;
			icnUnhide(state[ iconIdSMS ] .h);
		}
		else    //The icon will be invisible
		{
			state[ iconIdSMS ] .state = ICON_INVISIBLE;
			icnHide(state[ iconIdSMS ] .h);
		}
		windowsUpdate();  //redraw the idle screen again.
		if (sms_animate)
		{
			timStart(sms_animate);
		}
		
	}
	else    //else stop the timer for blinking.
	{
		isIconBlinking=0;
		
		if (sms_animate)
		{
			timStop(sms_animate);
		}
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	iconShowGoodbye

 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void iconShowGoodbye( void)
{
//	iconsShowIcon( &state[ iconGoodbye ] );
}



/*******************************************************************************

 $Function:    	iconsShowSignal

 $Description:	Shows the signal status icons
 
 $Returns:		0 if error detected, otherwise 1

 $Arguments:	signalstatus, the current signal icon to be displayed
 
*******************************************************************************/

int iconsShowSignal (U8 signalstatus)
{
	int i;

	/* If we have an error, ie invalid id then return 0
	*/
	if ( ( signalstatus < 0 ) || ( signalstatus >= iconSignalMax ) )
        return 0;

	/* Otherwise clear all of the signal icons, and then set the
	   selected value to be visible
	*/
    for( i = 0; i < iconSignalMax; i++ )
        signalstate[ i ].state = ICON_INVISIBLE;
	signalstate[ signalstatus ].state = ICON_VISIBLE;

	/* and display the current selection
	*/
    icnShow( signalstate[ signalstatus ].h );

	return 1;
}



/*******************************************************************************

 $Function:    	iconsInputShow

 $Description:	show current input icons
 
 $Returns:		None

 $Arguments:	IconInputId, id of icon to be displayed
 
*******************************************************************************/

void iconsInputShow (int IconInputId)
{
	CLEAR_BOTTOM_ZONE_ICON;
}


/*******************************************************************************

 $Function:    	iconsMainIconsAreaSet

 $Description:	sets the current main icons area
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

#ifndef LSCREEN
#define MAIN_ICON_Y 31
#endif

void copyAreaAttr(MfwRect *iconArea, MfwRect *display_area)
{
	if (display_area->sx > iconArea->sx)
	{
		iconArea->px = display_area->px + (display_area->sx - iconArea->sx)/2;
	}
	else
	{
		iconArea->px = display_area->px;
	}
	if (display_area->sy > iconArea->sy)
	{
		iconArea->py = display_area->py + (display_area->sy - iconArea->sy)/2;
	}
	else 
	{
		iconArea->py = display_area->py;

		if (display_area->sy < iconArea->sy)
			iconArea->sy = display_area->sy;
#ifndef LSCREEN
/*With the small screen we change the size of the idle icons (when changing language)*/
		else
			iconArea->sy = MAIN_ICON_Y;			
#endif
	}
}

void iconsMainIconsAreaSet (MfwRect selected_area)
{

	
	copyAreaAttr( &mainIconSimToolkit.area,    &selected_area);
	copyAreaAttr( &mainIconCalculator.area,	&selected_area);
	copyAreaAttr( &mainIconSettings.area,	&selected_area);
	copyAreaAttr( &mainIconWAP.area,		&selected_area);
	copyAreaAttr( &mainIconRecentCalls.area,   &selected_area);
	copyAreaAttr( &mainIconCallDivert.area,	&selected_area);
	copyAreaAttr( &mainIconSecurity.area,	&selected_area);
	copyAreaAttr( &mainIconMessages.area,	&selected_area);
	copyAreaAttr( &mainIconPhonebook.area,	&selected_area);

/*
#ifdef COLOURDISPLAY	
#ifdef USE110X110
	//No 110x110 for sim toolkit yet
	mainIconSimToolkit.area.sx   =   96;
	mainIconSimToolkit.area.sy   =   96;
#else
	//Applications icon is 1 pixel wider than the rest
	mainIconCalculator.area.sx   =	97;
	mainIconCalculator.area.sy   =	96;
#endif
#endif*/
}


/*******************************************************************************

 $Function:    	()

 $Description:	
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
#ifdef COLOURDISPLAY
static T_BITMAP bgdBmpBubbles		= 	{{0,0,120,120},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR,(char*) bmpDataBubbles};
static T_BITMAP bgdBmpCloud 		= 	{{0,0,120,100},1,COLOUR_ICON_XX,BMP_FORMAT_32BIT_COLOUR,(char*) bmpDataCloud};
static T_BITMAP bgdBmpSquares 		= 	{{0,0,176,220},1,COLOUR_ICON_XX, ICON_TYPE_16BIT_COL,  (char *)bmpDataSquares };
//static T_BITMAP bgdBmpO2 			= 	{{0,0,120,100},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR,(char*) bmpDataSquares};
static T_BITMAP bgdBmpTree			= 	{{0,0,120,100},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR,(char*) bmpDataSquares};
// by Nitin to set the TI Logo position
// This has to be permamnantly done for Neptune
#if (BOARD == 61)
static T_BITMAP TI_Bgd				= 	{{32,50,176,220},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*) Ti_bgd_bmp};
#else
static T_BITMAP TI_Bgd				= 	{{0,0,176,220},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*) Ti_bgd_bmp};
#endif //(BOARD == 61)

static T_BITMAP call_backdrop	    = 	{{2,8,120,170},1,COLOUR_ICON_XX,ICON_TYPE_1BIT_UNPACKED, (char *) iconInCallBackDrop};

static T_BITMAP Edinburgh1_Bgd		= 	{{0,0,175,220},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR, (char*) Edinburgh1_bgd_bmp};
static T_BITMAP Edinburgh2_Bgd		= 	{{0,0,175,220},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR, (char*) &Edinburgh1_bgd_bmp[2]};
static T_BITMAP Edinburgh3_Bgd		= 	{{0,0,175,220},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR, (char*) Edinburgh3_bgd_bmp};
static T_BITMAP Edinburgh4_Bgd		= 	{{0,0,175,220},1,COLOUR_ICON_XX,BMP_FORMAT_16BIT_LCD_COLOUR, (char*) &Edinburgh3_bgd_bmp[2]};

#endif

T_BITMAP* icon_getBgdBitmap( int bgdId )
{
	TRACE_FUNCTION("icon_getBgdBitmap()");
#ifdef COLOURDISPLAY
	switch (bgdId)
	{
		case BGD_NONE:
			return (NULL);
//			break;   // RAVI
		case BGD_BUBBLES:
			return (&bgdBmpBubbles);
// 			break;  // RAVI
		case BGD_CLOUD:
			return (&bgdBmpCloud);
//			break;  // RAVI
		case BGD_SQUARE:
//			return (&bgdBmpSquares);
			break;
		case BGD_TI_LOGO:
			return (&TI_Bgd);
//			break;   // RAVI
		case BGD_O2:
			return (NULL);
//			break;   // RAVI
		case BGD_TREE:
			return (NULL);
//			break;   // RAVI
		case BGD_SUNSET:
			return (NULL);
//			break; RAVI
		case BGD_EDINBURGH1:
			return (&Edinburgh1_Bgd);
//			break; // RAVI
		case BGD_EDINBURGH2:
			return (&Edinburgh2_Bgd);
//			break; // RAVI
		case BGD_EDINBURGH3:
			return (&Edinburgh3_Bgd);
//			break;  // RAVI
		case BGD_EDINBURGH4:
			return (&Edinburgh4_Bgd);
//			break;  // RAVI
		case BGD_INCALL:
			return(&call_backdrop);
//			break;	 // RAVI
			
	}
#endif
	return (NULL);
}


#ifdef COLOURDISPLAY
/*******************************************************************************

 $Function:    	addnetwork

 $Description:	This function adds a link between a bitmap and a network number.
 
 $Returns:		None

 $Arguments:	networkBitmap - pointer to the bitmap data
 				networkNo - pointer to the UBYTE array containing the network number
 
*******************************************************************************/
#define MAX_NETWORK_NUMBER 50
typedef struct {
	char 			*num;
	T_BITMAP	*bmp;
} T_NETWORK_BITMAP;
static T_NETWORK_BITMAP networkBitmap[MAX_NETWORK_NUMBER];

static void addnetwork(T_BITMAP *networkBmp, char* networkNo)
{
	int i=0;
	while (i<MAX_NETWORK_NUMBER)
	{
		if (networkBitmap[i].num == NULL)
		{
			networkBitmap[i].num = networkNo;
			networkBitmap[i].bmp = networkBmp;
			return;
		}
		i++;
	}
}

T_BITMAP Bouygues_icon 		= {{0,0,175,50},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)Bouygues_bmp};
T_BITMAP SFR_icon 			= {{0,0,103,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)SFR_bmp};
T_BITMAP VodafoneD2_icon 	= {{0,0,107,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)VodafoneD2_bmp};
T_BITMAP Chinamobile_icon 	= {{0,0,175,51},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)Chinamobile_bmp};
T_BITMAP Fareast_icon 		= {{0,0,110,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)Fareast_bmp};
T_BITMAP orange_icon 		= {{0,0, 64,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)orange_bmp};
T_BITMAP sonofon_icon 		= {{0,0,174,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)sonofon_bmp};
T_BITMAP Vodafone_icon 		= {{0,0,108,64},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)Vodafone_bmp};
T_BITMAP Tmobile_icon		= {{0,0,175,49},1,COLOUR_ICON_XX,ICON_TYPE_256_COL, (char*)  Tmobile_bmp};

/*******************************************************************************

 $Function:    	icon_initNetworkBitmaps

 $Description:	This procedure initialises the link between a network icon and a network 
 				number.
 				NB This data should probably be stored in flash.
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
void icon_initNetworkBitmaps( void )
{
	int i;
	for (i=0;i<	MAX_NETWORK_NUMBER;i++)
	{
		networkBitmap[i].num = NULL;
		networkBitmap[i].bmp = NULL;
	} 
	//AP - 29-01-03 - initialise the value to true to show the Bitmap
	//FFS_flashData.ProviderNetworkShow = FFS_flashData.ProviderNetworkShow;
/* API - 29-01-03 - Allowed to uses these service provider bitmaps O2 is still commented out we
					dont have this bitmap yet.
*/	
/* T MOBILE Bitmaps */
	addnetwork(&Tmobile_icon,		"23430");	/* UK */
	addnetwork(&Tmobile_icon,		"23431");	/* UK */
	addnetwork(&Tmobile_icon,		"23432");	/* UK */
	addnetwork(&Tmobile_icon,		"23203");	/* Austria */
	addnetwork(&Tmobile_icon,		"23001");	/* Czeck */	
	addnetwork(&Tmobile_icon,		"26201");	/* Germany */
	addnetwork(&Tmobile_icon,		"TMO UK");	/* UK */

	addnetwork(&Tmobile_icon,		"31016");	/* USA */
	addnetwork(&Tmobile_icon,		"31020");	/* USA */
	addnetwork(&Tmobile_icon,		"31021");	/* USA */
	addnetwork(&Tmobile_icon,		"31022");	/* USA */
	addnetwork(&Tmobile_icon,		"31023");	/* USA */
	addnetwork(&Tmobile_icon,		"31024");	/* USA */
	addnetwork(&Tmobile_icon,		"31025");	/* USA */
	addnetwork(&Tmobile_icon,		"31026");	/* USA */
	addnetwork(&Tmobile_icon,		"31027");	/* USA */
	addnetwork(&Tmobile_icon,		"31031");	/* USA */
	addnetwork(&Tmobile_icon,		"31058");	/* USA */
	addnetwork(&Tmobile_icon,		"31066");	/* USA */
	addnetwork(&Tmobile_icon,		"31080");	/* USA */

/* VODAFONE Bitmaps */	
	addnetwork(&Vodafone_icon, 	 	"23415");	/* UK */
	addnetwork(&Vodafone_icon,		"26202");	/* Germany */
	addnetwork(&Vodafone_icon,		"27201");	/* Ireland */
	addnetwork(&Vodafone_icon,		"20404");	/* Holand */
	addnetwork(&Vodafone_icon,		"24008");	/* Sweden */
	
/* O2 Bitmaps */
//	addnetwork(&O2UK_bmp,				"23410");
	
/* Orange Bitmaps */
	addnetwork(&orange_icon, 		"34001");
	addnetwork(&orange_icon, 		"20801");
	addnetwork(&orange_icon, 		"23433");
	addnetwork(&orange_icon, 		"23830");


}

/*******************************************************************************

 $Function:    	

 $Description:	function to convert 'n' characters in an UBYTE array into a positive integer.
 
 $Returns:		Value in the string

 $Arguments:	str - pointer to the string
 				maxChar - last possible char of the number 
 
*******************************************************************************/
int UbyteToInt(UBYTE* str, int maxChar)
{
	int num = 0;
	int i;
	for (i=0;i<maxChar;i++)
	{
		if ((str[i] >='0') && (str[i] <='9'))
			num = num*10+str[i]-'0';
		else
			return (num);
	}
	return (num);
}

/*******************************************************************************

 $Function:    	icon_getNetworkIcon

 $Description:	This procedure returns a bitmap based on the suplied network number.
 
 $Returns:		Pointer to the network logo bitmap

 $Arguments:	networkNumber - array of data corresponding to the network number
 				NB This may not be null terminated.
 
*******************************************************************************/
T_BITMAP* icon_getNetworkIcon( UBYTE* networkNumber)
{
	char num[SIZE_PLMN_NAME+1];
	int i;
	static int init=1;
	TRACE_FUNCTION("icon_getNetworkIcon()");
	if (init)
	{
		icon_initNetworkBitmaps( );
		init=0;
	}
	// AP - 29-01-03 - IF this is satisfied we dont want to show provider icon
	if( FFS_flashData.ProviderNetworkShow == FALSE )
		return ( NULL );
	
	//NB: NetworkNumber may not be null terminated
	for (i=0;i<SIZE_PLMN_NAME;i++)
		num[i] = (char)networkNumber[i];
	num[SIZE_PLMN_NAME] = 0x00;
	for (i=0;i<MAX_NETWORK_NUMBER;i++)
	{
		if (strcmp(num,networkBitmap[i].num)==0)
			return (networkBitmap[i].bmp);
	}
	TRACE_EVENT_P1("No match for %s",num);
	return (NULL);
}
/*******************************************************************************

 $Function:    	icon_getBitmapIdFromText()

 $Description:	This procedure selects a bitmap Id depending on the textid passed to it.
 
 $Returns:		data - enumerated type corresponding to the desired bitmap

 $Arguments:	mnuId - text id corresponding to the desired bitmap
 
*******************************************************************************/
int icon_getBitmapIdFromText( int mnuId )
{
int data;
	TRACE_FUNCTION("icon_getBitmapIdFromText()");
	switch (mnuId)
	{
		case TxtNone:
			data = BGD_NONE;
			break;
		case TxtBgdSquares:
			data = BGD_SQUARE;
			break;
		case TxtBgdO2:
			data = BGD_O2;
			break;
		case TxtBgdTree:
			data = BGD_TREE;
			break;
		case TxtBgdSunset:
			data = BGD_SUNSET;
			break;
		case TxtBgdEdinburgh1:
			data = BGD_EDINBURGH1;
			break;
		case TxtBgdEdinburgh2:
			data = BGD_EDINBURGH2;
			break;
		case TxtBgdEdinburgh3:
			data = BGD_EDINBURGH3;
			break;
		case TxtBgdEdinburgh4:
			data = BGD_EDINBURGH4;
			break;
		case TxtBgdTILogo:
			data = BGD_TI_LOGO ;
			break;
		default:
			data = BGD_NONE;
			break;
	}
	return (data);
}

/*******************************************************************************

 $Function:    	icon_getBitmapFromId

 $Description:	This procedure selects a bitmap depending on the bgd id passed to it.
 				The procedure can return a pointer to the data or, if a data structure is
 				already in use, can copy the data out into the new structure.
 
 $Returns:		data - pointer to the bitmap

 $Arguments:	bgdId - enumerated type corresponding to the desired bitmap
 				*bmpData - pointer to a structure that can store the bitmap data (if required)
 
*******************************************************************************/
T_BITMAP *icon_getBitmapFromId( int bgdId, T_BITMAP *bmpData)
{
	T_BITMAP* data; 
	TRACE_FUNCTION("icon_getBitmapFromId()");

	data = icon_getBgdBitmap( bgdId );
	//Update the supplied data structure (if any)
	if (bmpData != NULL)
	{
		if (data == NULL)
		{
			bmpData->area.sx = 0;
			bmpData->area.sy = 0;
		}
		else
		{
			bmpData->area.px 	= 	data->area.px;
			bmpData->area.py 	= 	data->area.py;
			bmpData->area.sx 	= 	data->area.sx;
			bmpData->area.sy 	= 	data->area.sy;
			bmpData->area.sx 	= 	data->area.sx;
    		bmpData->nIcons		=	data->nIcons;       
    		bmpData->iconCol	=	data->iconCol;
    		bmpData->icnType	=	data->icnType;	
    		bmpData->icons		=	data->icons; 
		}
	}
	return (data);
}


/*******************************************************************************

 $Function:    	icon_bgdMenuSelected()

 $Description:	This procedure is called when a background image is selected from a menu.
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
int icon_bgdMenuSelected(MfwMnu* mnu, MfwMnuItem* mnuItem)
{
	T_MFW_HND win = mfw_parent(mfw_header());
	int mnuId;
	// int colDisplayType;  // RAVI
	// int colType;  // RAVI
	// int colFgdSelect = FALSE;  // RAVI
	int bmpId;
	// T_BITMAP *backgroundBmp; // RAVI
	int storedMenuId;

 	//The destination for the bitmap has been storeed by the previous menu selection
	storedMenuId = MmiBook_getStoredOption();
	mnuId = (int)mnuItem->str;
	
	//Get the BMI index corresponding to the text string
	bmpId = icon_getBitmapIdFromText(mnuId);

	//Depending on where this is to be displayed, we need either a pointer to the data or we
	//must copy the data out of the structure to update another structure.
	switch (storedMenuId)
	{
case TxtIdleScreen:
		/* Update idle screen bitmap */
		idle_setBgdBitmap(bmpId);		
		FFS_flashData.IdleScreenBgd = bmpId;
		break;
case TxtMenuScreen:
		/* The menu screen bitmap is a fixed structure - we need to update the data within*/
		icon_setMainBgdBitmap(bmpId);
		FFS_flashData.MainMenuBgd = bmpId;
		break;
	
default:	//unknown option
		break;
	}

	info_screen(win, TxtBackground, TxtSelected, 0);
	flash_write();
	return(0);
}
/*******************************************************************************

 $Function:    	icon_networkShow

 $Description:	Procedure to show acivation of Provider Bitmap
 
 $Returns:		Event consumed

 $Arguments:	None
 
*******************************************************************************/

int icon_networkShow (MfwMnu* m, MfwMnuItem* i)
{
T_MFW_HND win = mfwParent(mfw_header());
T_DISPLAY_DATA display_info;

if(FFS_flashData.ProviderNetworkShow == FALSE )
{
	FFS_flashData.ProviderNetworkShow = TRUE;
	flash_write();
}// SPR:12822 vvadiraj
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtProviderIcon,  TxtOn, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, NULL, THREE_SECS, KEY_CLEAR|KEY_LEFT|KEY_RIGHT );

	info_dialog(win, &display_info);

return MFW_EVENT_CONSUMED;
//  SPR:12822 vvadiraj }
}
/*******************************************************************************

 $Function:    	icon_networkDontShow

 $Description:	Procedure to show deActivate of Provider Bitmap
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

int icon_networkDontShow (MfwMnu* m, MfwMnuItem* i)
{
T_MFW_HND win = mfwParent(mfw_header());
T_DISPLAY_DATA display_info;

if(FFS_flashData.ProviderNetworkShow == TRUE )
{
	FFS_flashData.ProviderNetworkShow = FALSE;
	flash_write();
}//  SPR:12822 vvadiraj
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtProviderIcon,  TxtOff, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, NULL, THREE_SECS, KEY_CLEAR|KEY_LEFT|KEY_RIGHT );

	info_dialog(win, &display_info);

	return MFW_EVENT_CONSUMED;
//  SPR:12822 vvadiraj}
}
#endif

#ifndef COLOURDISPLAY

/*******************************************************************************

 $Function:    	icon_getNetworkIcon

 $Description:	Dummy procedure for non-colour displays
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/
T_BITMAP* icon_getNetworkIcon( UBYTE* networkNumber)
{
	return (NULL);
}
/*******************************************************************************

 $Function:    	icon_getBitmapFromId

 $Description:	Dummy procedure for non-colour displays
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

T_BITMAP *icon_getBitmapFromId( int bgdId, T_BITMAP *bmpData)
{
	return (NULL);
}
#endif

/*******************************************************************************
                                                                              
                                End Of File
                                                                              
*******************************************************************************/

