
/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		MMI
 $File:		    MmiEditor_i.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    25/10/00                                                      
                                                                               
********************************************************************************
                                                                              
 Description:
 
    This module provides utility functions for the phone book.

                        
********************************************************************************

 $History: MmiEditor_i.h

	25/10/00			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/


#ifndef _DEF_MMIEDITOR_I_H_
#define _DEF_MMIEDITOR_I_H_


#define MAX_EDITOR_LABEL_LENGTH 160


/* KGT:
 *		internal modes
 */ 
typedef enum
{
    E_NORMAL_MODE = 0,
    E_PIN_SECURITY
} T_E_EDIT_MODE;


/* 
 * Internal struct
 */
typedef struct
{
    T_MMI_CONTROL   mmi_control;
    T_MFW_HND       parent;
    T_MFW_HND       edt_win;
    T_MFW_HND       edt_edt;
    T_MFW_HND       edt_kbd;
    T_MFW_HND       edt_kbd_long;
    T_MFW_HND       edt_tim; // c015 rsa
	T_MFW_HND		edt_input; // RM 25-08

    T_EDITOR_DATA   editor_data;

	//GW-SPR#1035-Added SAT changes.
/* NM, 090702
   increase the size of the LabelText to 161 ;
   need it for the SAT application
   
    /* JVJ-SPR#1208 - The size of this label doesnt have to be as big as concatenated SMS*/
    char            LabelText[MAX_EDITOR_LABEL_LENGTH];    
 /* NM, 090702 END */
	char			*tmpBuf; /* KGT 06-09: used for hide mode. the normal editor buffer will be used
								to display '*' instead of the typed letters and numbers.
								the real typed string will be stored in tmpBuf */

	T_E_EDIT_MODE	edt_mode;//KGT 27-08
	UBYTE			destroyEditor;
	UBYTE			emergency_call;	
	UBYTE			ss_string;
	char			imei[16];
	
}
T_EDITOR_INFO;


#endif

