#ifndef _DEF_MMI_EDITOR_H_
#define _DEF_MMI_EDITOR_H_

/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   MMI
 $File:       MmiEditor.h
 $Revision:   1.0

 $Author:   Condat(UK)
 $Date:       25/10/00

********************************************************************************

 Description:

    This provides the root mofule for the basic MMI

********************************************************************************
 $History: MmiMmi.h

  25/10/00      Original Condat(UK) BMI version.

 $End

*******************************************************************************/




/*******************************************************************************

                    Type definitions

*******************************************************************************/
/*
 * Definitions from common editor function
 */
#define INFO_TIMEOUT      1
#define INFO_KCD_LEFT     2
#define INFO_KCD_RIGHT      3
#define INFO_KCD_HUP      4
#define INFO_KCD_UP       5
#define INFO_KCD_DOWN     6
#define INFO_KCD_0_9      7
#define INFO_KCD_ALTERNATELEFT  8
#define INFO_EMERGENCY      99

#define DIGITS_MODE     0
#define ALPHA_MODE      1
#define READ_ONLY_MODE  2
#define T9_MODE         3
#define CALC_MODE   4
#define PIN_SECURITY    5
#define FORMAT_MODE		6				// SH - formatted input mode for WAP

#define PROMPT_LENGTH  16

#ifndef FOREVER
#define TIMER_EXIT  0x0BB8             /* Default SMS timer period - 3 secs.  */
#define SHORT_SECS  0x01F4                              /* Information dialogue display times. */
#define THREE_SECS  0x0BB8             /* 3000 milliseconds.                  */
#define FIVE_SECS   0x1388             /* 5000 milliseconds.                  */
#define TEN_SECS    0x2710             /* 10000 milliseconds.                 */
#define TWO_MIN     0x1D4C0            /* 2 min                               */
#define FOREVER     0xFFFF             /* Infinite time period.               */
#endif /* FOREVER */

/*
 *  Parameter Decription:
 *    ----------------
 *    mode                 -> sets mode to digits or alpha;
 *                            (ALPHA_MODE | DIGITS_MODE | READ_ONLY_MODE | T9_MODE)
 *    Callback             -> Routine to be called, if the user presses left- or right- or clear-key or a timeout occurs
 *                            (parameter = INFO_KCD_LEFT, INFO_KCD_ALTERNATELEFT, INFO_KCD_RIGHT, INFO_KCD_HUP,
 *                                         INFO_TIMEOUT)
 *    timeout              -> after this timeout the Callback will be executed
 *                            (optional, set to FOREVER if unused)
 *                            (timeout is refreshed on every key-press)
 *    Identifier           -> passed back to the creator as a parameter of Callback (optional)
 *    hide                 -> hide the entered string (currently not supported),
 *    TextId               -> If you want to use a label...
 *                            (optional, set to 0 if unused)
 *    TextString           -> if no TextId is provided this will be used as alternative label
 *                            (optional, set to NULL if unused)
 *    min_enter            -> minimum number of chars to be entered in buffer,
 *                            min_enter= 0x00                 means no min. limit
 *                            min_enter = editor_attr.size-1  means fixed lenght
 *    LeftSoftKey          -> SoftKey to be shown if number of entered chars >= min_enter
 *    AlternateLeftSoftKey -> SoftKey to be shown if number of entered chars < min_enter
 *    RightSoftKey         -> SoftKey to be shown unconditionally
 *                            (in order to hide/disable a Softkey set it to TxtNull)
 * NOTE: The buffer to be edited shall provide sufficient space to hold the terminating zero character.
 * NOTE: We assume that the buffer to be edited is provided by the caller and valid throughout the lifetime of the editor.
 *       Thus we do NOT copy the buffer into local temporary space.
 * NOTE: If digits-mode and hide are concurrently enabled, entering of '+' is not possible
 * NOTE: In read-only mode the cursor is set to the top of the buffer and all normal keys are ignored.
 *       However Softkeys and long-clear are functional.
 * NOTE: There's an exception from the normal behaviour if (mode == DIGITS) and (size == 2).
 *       In this case called "single digit key request" the editor is left immediately on any normal key
 *       by calling <Callback> with parameter INFO_KCD_LEFT.
 */

/*
 * External types
 */

typedef enum
{
    E_EDITOR_INIT,
    E_EDITOR_DEINIT,
    E_EDITOR_UPDATE,
    E_EDITOR_CURSOR_END /*SPR 1392*/
} e_editor_events;


typedef void (*T_EDIT_CB) (T_MFW_HND, USHORT, USHORT);

typedef struct
{
    T_MFW_EDT_ATTR  editor_attr;
    BOOL            hide;
    USHORT          LeftSoftKey;
    USHORT          AlternateLeftSoftKey;
    USHORT          RightSoftKey;
    USHORT          Identifier;
    UBYTE           mode;
    USHORT          TextId;
    char           *TextString;
    UBYTE           min_enter;
    ULONG           timeout;
    T_EDIT_CB       Callback;
    UBYTE     destroyEditor;
    char			*FormatString;		// SH - Formatting string for formatted input
    int				formatIndex;		// SH - Position in formatting string
    int				fieldIndex;			// SH - position within a delimited field
} T_EDITOR_DATA;

//Zone data for drawing windows
#define ZONE_FULL_HEIGHT				0x000F
#define ZONE_TOPHALF_HEIGHT				0x000C
#define ZONE_MIDDLE_HEIGHT				0x0006
#define ZONE_BOTTOMHALF_HEIGHT			0x0003
#define ZONE_FULL_WIDTH					0x00F0
#define ZONE_LEFTHALF_WIDTH				0x00C0
#define ZONE_MIDDLE_WIDTH				0x0060
#define ZONE_RIGHTHALF_WIDTH			0x0030

#define ZONE_ICONS						0x0100
#define ZONE_TITLE						0x0200
#define ZONE_CASE_ABC					0x0400
#define ZONE_SOFTKEYS					0x1000

#define ZONE_FULLSCREEN					(ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)
#define ZONE_FULLICONS					(ZONE_ICONS|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)
#define ZONE_FULLTITLE					(ZONE_TITLE|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)
#define ZONE_FULLSOFTKEYS				(ZONE_SOFTKEYS|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)

#define ZONE_FULL_SK_TITLE				(ZONE_TITLE|ZONE_SOFTKEYS|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)
#define ZONE_FULL_SK_TITLE_ALPHA		(ZONE_TITLE|ZONE_SOFTKEYS|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH | ZONE_CASE_ABC)
#define ZONE_WAP_EDITOR					(ZONE_TITLE|ZONE_SOFTKEYS|ZONE_FULL_HEIGHT | ZONE_FULL_WIDTH)

//Specific editor sizes
#define ZONE_SMALL_EDITOR				(0xFF00)	/* editor for small (one line) editors */
#define ZONE_BORDER_EDITOR 				(0xFE00)    /* editors with a border to the left/right - sim toolkit */
#define ZONE_BOTTOM_LINE	 			(0xFD00)    /* editors for the bottom line */
#define ZONE_BOTTOM_LINE_FIND 			(0xFC00)    /* editors on the bottom line after "Find:" */


/* PROTOTYPES */
extern T_MFW_HND editor_start (T_MFW_HND parent, T_EDITOR_DATA * editor_data);

extern T_MFW_HND editor_start_common(T_MFW_HND win, char * buffer, U16 len,
                                     T_EDITOR_DATA * editor_info, T_EDIT_CB editor_cb);


int showeZiTextIcon(MfwMnu* m, MfwMnuItem* i);

 int Easy_Activate(MfwMnu* m, MfwMnuItem* i);

 int Easy_DeActivate(MfwMnu* m, MfwMnuItem* i);

 //API - 01/10/02 - Concatenation Switch Function Definition
 int Concatenate_DeActivate(MfwMnu* m, MfwMnuItem* i);
 int Concatenate_Activate(MfwMnu* m, MfwMnuItem* i);
 int Concatenate_Status(MfwMnu* m, MfwMnuItem* i);

extern void editor_destroy (T_MFW_HND window);
extern void editor_attr_init(MfwEdtAttr* attr, int zone_id, U8 mode, U8 *controls, char *text, U16 size, int colour);
extern void editor_data_init( T_EDITOR_DATA* editor_info, T_EDIT_CB callback,USHORT lsk, USHORT rsk, USHORT txtId, USHORT min_num_char, UBYTE mode, ULONG timeout);

#endif /* _DEF_MMI_EDITOR */
