/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   MMI
 $File:       MmiEditor.c
 $Revision:   1.0

 $Author:   Condat(UK)
 $Date:       22/02/01

********************************************************************************

 Description:



********************************************************************************

 $History: MmiMain.c
	Nov 24, 2005 DR: OMAPS00045909 - Shashi Shekar B.S.
	Description: Improve IMEI control mechanism
	Solution : When MMI calls sAT_PLUSCFUN, if an IMEI invalid error is returned,
		we will block on that screen & will not allow the user to browse menus further,
		since the PS will not be booted at all!!!

 	May 02, 2005   REF : LOCOSTO-ENH-30818 - xpradipg
	Description:	IMEI retreival  by posting a call to ACI sAT_xx API
	Solution:		The direct call to cl_get_imeisv() is replaced with the
					call to the callNUmber() which inturn calls sAT_Dn() and
					retrieves the IMEI info                                                                            
	Aug 16, 2004    REF: CRR 24323   Deepa M.D
	Bug:Clenup of sprintf used for tracing
	Fix:Replace the char buf[]; sprintf (buf, "...", ...); TRACE_EVENT (buf); statements by TRACE_EVENT_PX

  25/10/00      Original Condat(UK) BMI version.
 $End

*******************************************************************************/

#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_edt.h"
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "mfw_sms.h"
#include "mfw_ss.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_cm.h"

#include "dspl.h"

#include "ksd.h"
#include "psa.h"

#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiMmi.h"

#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"

#include "MmiIdle.h"
#include "MmiEditor.h"
#include "MmiEditor_i.h"

#include "cus_aci.h"

#ifndef PCM_2_FFS
#include "pcm.h"
#endif

#include "Mmiicons.h"
#include "MmiBookShared.h"
#include "mmiSmsMenu.h"
#include "mfw_ffs.h"
#ifdef EASY_TEXT_ENABLED
#include "MmiLatinPredText.h"
#include "MmiDictionary.h"
#endif /* EASY_TEXT_ENABLED */

#include "mmiColours.h"

#ifndef MFW_EVENT_PASSED
#define MFW_EVENT_PASSED 0
#endif

/*********************************************************************
**********************************************************************

                                 DYNAMIC EDITOR WINDOW. DECLARATION

*********************************************************************
**********************************************************************/
/*
 * Internal events
 */



static T_MFW_HND   editor_create       (T_MFW_HND  parent);
//SH - static void        editor_destroy      (T_MFW_HND  window);
static void        editor_exec_cb      (T_MFW_HND  win,USHORT event, SHORT value, T_EDITOR_DATA * editor_data);
static int         editor_win_cb       (T_MFW_EVENT event, T_MFW_WIN * win);
static int         editor_kbd_cb       (T_MFW_EVENT event, T_MFW_KBD * keyboard);
static int         editor_tim_cb       (T_MFW_EVENT event, T_MFW_TIM *tc);


static char SymbolPrompt[40] = "123456789";
static int DoNextLongPress = FALSE;

static UBYTE UPPER_CASE = FALSE;
extern int upCase;
static UBYTE over_length_label = FALSE;

static UBYTE AllowPredText = FALSE;
extern int SymbolChar;
static const unsigned char TextIconeZiTextSmall[] =
{
  0x03,
  0x03,
  0x18,
  0x7c,
  0xcc,
  0x08,
	0x10,
	0x0c
};

/* internal used functions: */
static void editor_hideInit(T_EDITOR_INFO *data);
static void editor_hideInsert(T_EDITOR_INFO *data, U8 key);
static void editor_hideClear(T_EDITOR_INFO *data);
static void editor_hideClearAll(T_EDITOR_INFO *data);
static void editor_hideTerminate(T_EDITOR_INFO *data);


/*********************************************************************
**********************************************************************

                                DYNAMIC EDITOR WINDOW. IMPLEMENTATION

*********************************************************************
**********************************************************************/

void editor_data_init( T_EDITOR_DATA* editor_info, T_EDIT_CB callback,USHORT lsk, USHORT rsk, USHORT txtId, USHORT min_num_char, UBYTE mode, ULONG timeout)
{

	editor_info->LeftSoftKey   	= lsk;	    
	editor_info->RightSoftKey 	= rsk;
	editor_info->TextId      	= txtId;
	editor_info->mode			= mode;
	editor_info->Callback     		= callback;
	editor_info->min_enter   		= min_num_char;
	editor_info->timeout    		= timeout;

	//Set-up default values
	editor_info->AlternateLeftSoftKey	= TxtNull;
	editor_info->Identifier				= 0;  /* optional */

	editor_info->FormatString		= NULL;
	editor_info->formatIndex		= 0;
	editor_info->fieldIndex			= 0;	    
	
	//Set-up default values - the defaults may change depending on what other editors do
	editor_info->hide         		= FALSE;
	editor_info->TextString 		= NULL;
	editor_info->destroyEditor		= TRUE;

}

/*******************************************************************************

 $Function:     calculateWindow

 $Description:	initialises the size of the editor based on the screen size and the 'zone_id'
 				which controls what part of the screen the editor should be in.

 $Returns:    	An updated 'attr' with values for the editor window position and size

 $Arguments:  	zone_id - bitmapped word which defines the editor size and position
 				The definitions are in MMIEditor.h
 				The most common sizes are
	 				full screen
 					full screen with softkkeys
 					full screen with title and softkeys
 				but the macros also support part screens (with/without icons/titles/softkeys) eg.
 					left screen :-	middle width screen	right screen 
 						xxxx----	--xxxx--			----xxxx
 						xxxx----	--xxxx--			----xxxx
 						xxxx----	--xxxx--			----xxxx
 						xxxx----	--xxxx--			----xxxx
 					top screen :-	middle ht screen	bottom screen 
 						xxxxxxxx	--------			---------
 						xxxxxxxx	xxxxxxxx			---------
 						--------	xxxxxxxx			xxxxxxxxx
 						--------	--------			xxxxxxxxx
 				or any combination of width/height.
 				An Id of 0 is assumed to be undefined and is treated as full screen plus softkeys.
*******************************************************************************/
#ifndef LSCREEN
//Sizes defined for CSAMPLE editore
#define BOOKDETAILS_EDITOR_SIZE 		0, 0, SCREEN_SIZE_X-4, Mmi_layout_line(LAST_LINE_TOP)
#define NUMBER_EDITOR_SIZE				0, 12, SCREEN_SIZE_X , MNU3LINE
#define PHONEBOOK_DLG_EDITOR_SIZE		4, Mmi_layout_line(3)+2, SCREEN_SIZE_X-4, SCREEN_SIZE_Y-(Mmi_layout_line(3)+2)
#define BOOKSDN_EDITOR_SIZE 			34, Mmi_layout_line(3)+2, 50, Mmi_layout_line(1)+2

//MMICall
#define CALL_EDITOR_SIZE				4,28,SCREEN_SIZE_X-4, 20
#define CALLSCRATCHPAD_EDITOR_SIZE		6, Mmi_layout_line(2),SCREEN_SIZE_X-6, 16

//MMIServices
#define SERVICE_CREATE_EDITOR_SIZE		4,Mmi_layout_line(1)+2,SCREEN_SIZE_X-4, MNU3LINE
#define PASSWORD_EDITOR_SIZE			0, 12, SCREEN_SIZE_X , 13

//From MMIIdle
//GW Changed window height from 30 (27?) to 24.
#define WIN_DIALLING_SIZE				0,Mmi_layout_line_icons(2), SCREEN_SIZE_X,24
#define WIN_DIALLING_C_SIZE 			0,Mmi_layout_line_icons(1),SCREEN_SIZE_X,32

//Positions for editor windows in mmismssend
#define PHNO_EDITOR_SIZE 				0, (Mmi_layout_line(1)+2), SCREEN_SIZE_X, 20

//NB defines below used twice, second time START/SIZE_Y was same as START/SIZE_Y above 
#define CENTRE_EDITOR_SIZE				0, Mmi_layout_line(1), SCREEN_SIZE_X, MNU3LINE+3

//And for MMIServices - moved here from mmiservices.c
#define SAT_EDITOR_SIZE	 				6,30,SCREEN_SIZE_X-6, 20

#define RPWD_EDITOR_SIZE				0,12,SCREEN_SIZE_X,13

//MMIBookCallDetails
#define PHB_EDITOR_SIZE  				4,0,SCREEN_SIZE_X-4, ALLBUT2LINE

//MMIPins
#define PIN_EDIT_RESET_SIZE 			12,20,84-12,16

//MMITimeDate
#define TIMEDATE_EDITOR_AREA_SIZE 0,10,70,10
#endif
void setSize(MfwRect *win, int px, int py, int sx, int sy)
{
	win->px = px;	win->py = py;
	win->sx = sx;	win->sy = sy;
}

void getSpecificWindowSize(MfwEdtAttr* attr, int zone_id )
{
	switch (zone_id)
	{
	case ZONE_SMALL_EDITOR:
		attr->win.px = 6;
		attr->win.py = Mmi_layout_IconHeight()*2;
		attr->win.sx = SCREEN_SIZE_X-attr->win.px;
		attr->win.sy = Mmi_layout_line_height()*2+4;
		break;
	case ZONE_BOTTOM_LINE:
		attr->win.px = 0;
		attr->win.py = SCREEN_SIZE_Y - Mmi_layout_line_height() - Mmi_layout_softkeyHeight();
		attr->win.sx = SCREEN_SIZE_X-attr->win.px;
		attr->win.sy = Mmi_layout_line_height();
		break;
	case ZONE_BOTTOM_LINE_FIND: //used for phonebook search
		attr->win.px = dspl_GetTextExtent(MmiRsrcGetText(TxtFind),0); 
		attr->win.py = SCREEN_SIZE_Y - Mmi_layout_line_height() - Mmi_layout_softkeyHeight();
		attr->win.sx = SCREEN_SIZE_X-attr->win.px;
		attr->win.sy = Mmi_layout_line_height();
		break;
		
#ifndef LSCREEN
	case BOOKDETAILS_EDITOR: 		setSize(&attr->win,BOOKDETAILS_EDITOR_SIZE);		break;
	case NUMBER_EDITOR:			 	setSize(&attr->win,NUMBER_EDITOR_SIZE);				break;
	case PHONEBOOK_DLG_EDITOR:		setSize(&attr->win,PHONEBOOK_DLG_EDITOR_SIZE);		break;
	case BOOKSDN_EDITOR:			setSize(&attr->win,BOOKSDN_EDITOR_SIZE);			break;
	case CALL_EDITOR: 			 	setSize(&attr->win,CALL_EDITOR_SIZE);				break;
	case CALLSCRATCHPAD_EDITOR:		setSize(&attr->win,CALLSCRATCHPAD_EDITOR_SIZE);		break;
	case SERVICE_CREATE_EDITOR:		setSize(&attr->win,SERVICE_CREATE_EDITOR_SIZE);		break;
	case PASSWORD_EDITOR:			setSize(&attr->win,PASSWORD_EDITOR_SIZE);			break;
	
	case WIN_DIALLING:				
	case WIN_DIALLING_CB:				
			if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
				setSize(&attr->win,WIN_DIALLING_C_SIZE);
			else
				setSize(&attr->win,WIN_DIALLING_SIZE);
			break;
	case WIN_DIALLING_SMS:		 	
			if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
			{
				setSize(&attr->win,0,Mmi_layout_line_icons(1),84,24);
			}
			else
				setSize(&attr->win,WIN_DIALLING_SIZE);
			break;
	case WIN_DIALLING_SAT:		 	
			if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
				setSize(&attr->win,WIN_DIALLING_C_SIZE);
			else
				setSize(&attr->win,WIN_DIALLING_SIZE);
			break;
	
	case PHNO_EDITOR:			 	setSize(&attr->win,PHNO_EDITOR_SIZE);				break;
	case CENTRE_EDITOR:				setSize(&attr->win,CENTRE_EDITOR_SIZE);				break;
	case SAT_EDITOR	:			 	setSize(&attr->win,SAT_EDITOR_SIZE);				break;
	case RPWD_EDITOR:			 	setSize(&attr->win,RPWD_EDITOR_SIZE);				break;
	case PHB_EDITOR: 			 	setSize(&attr->win,PHB_EDITOR_SIZE);				break;
	case PIN_EDIT_RESET:			setSize(&attr->win,PIN_EDIT_RESET_SIZE);			break;
	case TIMEDATE_EDITOR_AREA:		setSize(&attr->win,TIMEDATE_EDITOR_AREA_SIZE);		break;
#endif	
		default:
			break;
	}
}

void calculateWindow(MfwEdtAttr* attr, int zone_id )
{
	attr->win.px = 0;
	attr->win.py = 0;
	attr->win.sx = SCREEN_SIZE_X;
	attr->win.sy = SCREEN_SIZE_Y;
	if (zone_id == ZONE_BORDER_EDITOR)
	{	//Leave border on left/right of screen.
		attr->win.px = 4;
		attr->win.sx = attr->win.sx - 2*attr->win.px;
		zone_id = ZONE_FULLSOFTKEYS;
	}
	else if ((zone_id != 0x0000) && ((zone_id &0xF000)==0xF000))
 	{
		getSpecificWindowSize(attr,zone_id);
	    return;
	}
	else if (zone_id == 0)
		zone_id = ZONE_FULLSOFTKEYS;

	if (zone_id & ZONE_ICONS)
		attr->win.py = attr->win.py + Mmi_layout_IconHeight();

	if (zone_id & ZONE_SOFTKEYS)
		attr->win.sy = attr->win.sy - Mmi_layout_softkeyHeight();

	if (zone_id & ZONE_TITLE)
		attr->win.py = attr->win.py + Mmi_layout_TitleHeight();
	
	if (zone_id & ZONE_CASE_ABC)
		attr->win.sy = attr->win.sy - Mmi_layout_line_height();

	attr->win.sy = attr->win.sy - attr->win.py;

	if ((zone_id & ZONE_FULLSCREEN) == ZONE_FULLSCREEN)
		return;
	
	//Else window is not entire screen
	switch (zone_id & ZONE_FULL_HEIGHT)
	{
	case ZONE_FULL_HEIGHT:	
		break;
	case ZONE_TOPHALF_HEIGHT:
		attr->win.sy = attr->win.sy/2;		
		break;
	case ZONE_MIDDLE_HEIGHT:			
		attr->win.sy = attr->win.sy/2;		
		attr->win.py = attr->win.py+attr->win.sy/2;		
		break;
	case ZONE_BOTTOMHALF_HEIGHT:		
		attr->win.sy = attr->win.sy/2;		
		attr->win.py = attr->win.py+attr->win.sy;		
		break;
	default:
		//No action
		break;
	}
	switch (zone_id & ZONE_FULL_WIDTH)
	{
	case ZONE_FULL_WIDTH:	
		break;
	case ZONE_LEFTHALF_WIDTH:		
		attr->win.sx = attr->win.sx/2;		
		break;
	case ZONE_MIDDLE_WIDTH	:		
		attr->win.sx = attr->win.sx/2;		
		attr->win.px = attr->win.px+attr->win.sx/2;		
		break;
	case ZONE_RIGHTHALF_WIDTH:		
		attr->win.sx = attr->win.sx/2;		
		attr->win.px = attr->win.px+attr->win.sx;		
		break;
	default:
		//No action
		break;
	}
}

void getTitlePosition(MfwEdtAttr* attr, int zone_id )
{
	if (zone_id & 0xFFFF0000)
	{
		//title is on top line/LHS
		
	}
}
#define EDITOR_FONT             0
#define EDITOR_CONTROLS         0
/*******************************************************************************

 $Function:     editor_attr_init

 $Description:  initialize parameters in the edit buffer

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
void editor_attr_init(MfwEdtAttr* attr, int zone_id, U8 mode, U8 *controls, char *text, U16 size, int colour )
{
	calculateWindow(attr, zone_id);
	getTitlePosition(attr, zone_id);
	attr->edtCol = colour;
  	attr->font = EDITOR_FONT;
  	attr->mode = mode;
  	attr->controls = controls;
  	attr->text = text;
  	attr->size = size;
  	AllowPredText = FALSE;
}
#ifdef EASY_TEXT_ENABLED
/*******************************************************************************

 $Function:     editor_attr_init_pred

 $Description:  initialize parameters in the predictive text editor buffer

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
void editor_attr_init_pred(MfwEdtAttr* attr, int zone_id, U8 mode, U8 *controls, char *text, U16 size, int colour)
{
	calculateWindow(attr, zone_id);
	attr->edtCol = colour;
  	attr->font = EDITOR_FONT;
  	attr->mode = mode;
  	attr->controls = controls;
  	attr->text = text;
  	attr->size = size;
  	AllowPredText = TRUE;
}

//returns true if next word after cursor ought to be capitalised
UBYTE capitalise_word(T_MFW_HND editor_handle)
{ char LastChar;
  char CharBefore;

  LastChar = getCursorChar(editor_handle, -1);
  CharBefore = getCursorChar(editor_handle, -2);

  if (LastChar == '.' || LastChar == '!' || LastChar == '?' || LastChar == 0)
    return TRUE;
  if (LastChar == ' ')
    if(CharBefore == '.' || CharBefore == '!' || CharBefore == '?' )
      return TRUE;
  return FALSE;
}


#endif


/*******************************************************************************

 $Function:     editor_start

 $Description:  Common editor.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
T_MFW_HND editor_start (T_MFW_HND parent, T_EDITOR_DATA * editor_data)
{
    T_MFW_HND win;

    TRACE_FUNCTION ("editor_start()");

    win = editor_create (parent);

    if (win NEQ NULL)
        {
            SEND_EVENT (win, E_EDITOR_INIT, 0, editor_data);
        }
    return win;
}

/*******************************************************************************

 $Function:     editor_create

 $Description:  Creation of an editor.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static T_MFW_HND editor_create (T_MFW_HND  parent)
{
    T_EDITOR_INFO *  data = (T_EDITOR_INFO *)ALLOC_MEMORY (sizeof (T_EDITOR_INFO));
    T_MFW_WIN     *  win;

    TRACE_FUNCTION ("editor_create()");

    /*
     * Create window handler
     */

    data->edt_win = win_create (parent, 0, E_WIN_VISIBLE, (T_MFW_CB)editor_win_cb);

    if (data->edt_win EQ NULL)
    {
        return NULL;
    }

    /*
     * connect the dialog data to the MFW-window
     */


    data->mmi_control.dialog = (T_DIALOG_FUNC)editor_exec_cb;
    data->mmi_control.data   = data;
    data->parent             = parent;
    win                      = ((T_MFW_HDR *)data->edt_win)->data;
    win->user                = (void *)data;


    /*
     * return window handle
     */

    return data->edt_win;
}
/*******************************************************************************

 $Function:     editor_destroy

 $Description:  Destroy the editor.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
void editor_destroy (T_MFW_HND window)
{
    T_MFW_WIN     * win  = ((T_MFW_HDR *)window)->data;
    T_EDITOR_INFO * data = (T_EDITOR_INFO *)win->user;

    TRACE_FUNCTION ("editor_destroy()");

	if (window == NULL)
	{
		TRACE_EVENT ("Error : Called with NULL Pointer");
		return;
	}

    if (data)
        {
			AllowPredText = FALSE; //prevent any problems with new editors
            /* end KGT */

            /*
             * Delete WIN Handler
             */
            editDeactivate();
            win_delete (data->edt_win);
            /*
             * Free Memory
             */
            FREE_MEMORY ((void *)data, sizeof (T_EDITOR_INFO));
        }
    else
        {
            TRACE_FUNCTION ("editor_destroy() called twice");
            return ;
        }
}

/*******************************************************************************

 $Function:     editor_exec_cb

 $Description:  Dialog function for editor.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_exec_cb (T_MFW_HND win, USHORT event, SHORT value, T_EDITOR_DATA * editor_data)
{
    T_MFW_WIN      * win_data  = ((T_MFW_HDR *)win)->data;
    T_EDITOR_INFO  * data      = (T_EDITOR_INFO *)win_data->user;

    T_MFW_HND       parent_win = data->parent;
    USHORT          Identifier = data->editor_data.Identifier;
    T_EDIT_CB       Callback   = data->editor_data.Callback;

	 T_EDITOR_DATA editor_label;
  
    TRACE_EVENT ("editor_exec_cb()");
	

    switch (event)
        {
        case E_EDITOR_INIT:
            /*
             * Store data
             */
            data->editor_data = *editor_data;
            if (data->editor_data.TextString NEQ NULL)
                {
                    memcpy (data->LabelText, data->editor_data.TextString, sizeof(data->LabelText));
                }
            /* Note that we do not copy the edited buffer here */
      data->editor_data.editor_attr.predText[0] = '\0';
            /*
             * Create the handler
             */
            data->edt_kbd      = kbd_create (data->edt_win, KEY_ALL,         (T_MFW_CB)editor_kbd_cb);
            data->edt_kbd_long = kbd_create (data->edt_win, KEY_ALL|KEY_LONG,(T_MFW_CB)editor_kbd_cb);
            data->edt_edt      = edtCreate  (data->edt_win, &data->editor_data.editor_attr,MfwEdtVisible,0);

            /*
             * Set the mode for the editor
             */
      data->destroyEditor = editor_data->destroyEditor;
            editActivate(data->edt_edt,data->editor_data.mode);

      // SH - format mode with *M or *m is just alpha mode with case preference

      if (data->editor_data.mode == FORMAT_MODE)
        {
        if (strcmp(data->editor_data.FormatString, "*M")==0)
          {
           upCase = TRUE;
          UPPER_CASE = FALSE;
          }
        if (strcmp(data->editor_data.FormatString, "*m")==0)
          {
          upCase = FALSE;
          UPPER_CASE = TRUE;
          }
        }

      // SH - end of format mode modification

            switch (data->editor_data.mode)
                {
                case READ_ONLY_MODE:
                    data->editor_data.hide  = FALSE;           /* don't allow hide for other modes than DIGITS_MODE.  */
                    data->edt_mode          = E_NORMAL_MODE;   /* if editor is not called in T9 mode, set the normal  */
       				data->editor_data.editor_attr.mode = 0;	// sbh - read only mode has no cursor
                win_show(data->edt_win);
                edtChar(data->edt_edt,ecTop);              /* in read-only mode set cursor to begin               */
                    break;                                     /* editor mode                                         */

                case ALPHA_MODE:

#ifdef EASY_TEXT_ENABLED
                  FFS_flashData.PredTextAvailable = TRUE;
                  Initialize_Dict(Mmi_getCurrentLanguage()/*MC, SPR 1319*/, 0);
          ResetDictSearch();
#endif

                  if ( data->editor_data.hide )              /* if hide is set, show '*' instead of numbers.        */
                    {
                        editor_hideInit(data);                 /* initialize editor for hide                          */
                        editHiddenActivate(data->tmpBuf);   /* initialise multi-tap for hide */
                        data->editor_data.editor_attr.mode |= edtModOverWr; // Must be overwrite mode
                    }
                    data->edt_mode          = E_NORMAL_MODE;   /* if editor is not called in T9 mode, set the normal  */
                win_show(data->edt_win);
                edtChar(data->edt_edt,ecBottom);              /* in read-only mode set cursor to begin               */
                    break;                                     /* editor mode                                         */
                case DIGITS_MODE:
                    if ( data->editor_data.hide )              /* if hide is set, show '*' instead of numbers.        */
                        editor_hideInit(data);                 /* initialize editor for hide                          */
                    data->edt_mode          = E_NORMAL_MODE;   /* if editor is not called in T9 mode, set the normal  */
                win_show(data->edt_win);
                edtChar(data->edt_edt,ecBottom);              /* in read-only mode set cursor to begin               */
                    break;                    /* editor mode                                         */
                case CALC_MODE:
                    data->editor_data.hide  = FALSE;           /* don't allow hide for other modes than DIGITS_MODE.  */
                    data->edt_mode          = E_NORMAL_MODE;   /* if editor is not called in T9 mode, set the normal  */
                win_show(data->edt_win);
                edtChar(data->edt_edt,ecBottom);
                    break;
        case PIN_SECURITY:
                    if ( data->editor_data.hide )              /* if hide is set, show '*' instead of numbers.        */
                        editor_hideInit(data);                 /* initialize editor for hide                          */
                    data->edt_mode          = E_PIN_SECURITY;   /* spec. handling for PIN entering  */
          data->emergency_call = FALSE;
          data->ss_string = FALSE;
                win_show(data->edt_win);
                edtChar(data->edt_edt,ecBottom);
                    break;
        case FORMAT_MODE:
          if ( data->editor_data.hide )              /* if hide is set, show '*' instead of numbers.        */
                    {
                        editor_hideInit(data);                 /* initialize editor for hide                          */
                        editHiddenActivate(data->tmpBuf);   /* initialise multi-tap for hide */
                    }
          data->editor_data.editor_attr.mode |= edtModOverWr; // Must be overwrite mode
          data->edt_mode    = E_NORMAL_MODE;
          win_show(data->edt_win);
          edtChar(data->edt_edt,ecTop);         // Cursor is at start of string
          data->editor_data.formatIndex = -1;         // Current format character.  -1; increased to 0 in editCharFindNext below.
          data->editor_data.fieldIndex = 0;

          // Skip over any fixed characters that may be at start
          setFormatPointers (data->editor_data.FormatString, &(data->editor_data.formatIndex), &(data->editor_data.fieldIndex));
          TRACE_EVENT("Starting format mode");
          editCharFindNext(NULL);
          break;
                }
            // end KGT

            // c015 rsa
            /* create the timer handler */
            if ( data->editor_data.timeout && (data->editor_data.timeout NEQ FOREVER))
                {
                    data->edt_tim      = tim_create (data->edt_win, data->editor_data.timeout, (T_MFW_CB)editor_tim_cb);
                    tim_start (data->edt_tim);
                }
            else
                {
                    data->edt_tim      = NULL;
                }
            
            //GW-SPR#1035-Added SAT changes from 33x build.
			/*NM, 090702 
			  why ? : for SAT application
			  this checks does the label fit on the first screen line ( <14chars) ;
			  if not so open a second editor and show up the whole
			  label (in Read_only_mode).
			  Pressing any key returns back to the main editor
			*/
      		if ( strlen(data->LabelText) >= MAX_LINE )
      		{
      			/* need this flag later in the callback of key_handler */
				over_length_label = TRUE;
				
				editor_attr_init(&editor_label.editor_attr, NULL, edtCurBar1, 0, (char *)data->LabelText, strlen(data->LabelText), COLOUR_EDITOR);
				editor_data_init(&editor_label, NULL, TxtNull, TxtNull, 0, 1, READ_ONLY_MODE, FOREVER);

				editor_start(win,&editor_label);  /* start the editor */
       		}
       		/*NM, 090702 END */

            break;

        case E_EDITOR_DEINIT:
            /* on DEINIT => selfdestroy; sendevent <value> */

          if (Callback)
            (Callback) (parent_win, Identifier, value);

			over_length_label =  FALSE; //GW-SPR#1035

      // MZ Destroy the text edit window after creating the number editor.
      if(data->destroyEditor == TRUE)
              	editor_destroy (data->edt_win);
      break;
      
#ifdef EASY_TEXT_ENABLED
    case E_EDITOR_UPDATE:
        if (SymbolChar != '\0')
            { 
                edtShow(data->edt_edt);
                edtChar(data->edt_edt, SymbolChar);
                 if ((SymbolChar == '.') ||(SymbolChar == '!') || (SymbolChar == '?'))
                {
                  edtChar(data->edt_edt, ' ');
                }

                win_show(data->edt_win);
            }
        break;
#endif
	/*SPR 1392, move cursor to end of editor string*/
	 case E_EDITOR_CURSOR_END:
		edtChar(data->edt_edt, ecBottom);
	 break;
        default:
            break;
        }
}
/*******************************************************************************

 $Function:     editor_win_cb

 $Description:  Editor window event handler.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static int editor_win_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
    T_EDITOR_INFO * data = (T_EDITOR_INFO *)win->user;
	int xPos,yPos;
	{
		/***************************Go-lite Optimization changes Start***********************/
		
		//Aug 16, 2004    REF: CRR 24323   Deepa M.D
		TRACE_EVENT_P1 ("editor_win_cb()-event=%d",event);
		/***************************Go-lite Optimization changes end***********************/

    }


    if (data->edt_edt!=activeEditor())
    	editActivate(data->edt_edt,data->editor_data.mode);

  	// SH - hidden mode
  	if (data->editor_data.hide)
    	editHiddenActivate(data->tmpBuf);
    // end hidden mode

    if (data EQ 0)
    {
    	TRACE_FUNCTION ("editor_win_cb()-no data");
        return MFW_EVENT_CONSUMED;
	}
    switch (event)
        {
        case E_WIN_VISIBLE: /* window is visible  */
            if (win->flags & E_WIN_VISIBLE)
          	{
                /*
                 * Clear Screen
                 */
                dspl_ClearAll();

                /*
                 * Print the information
                 */
#ifdef EASY_TEXT_ENABLED
				if(AllowPredText == TRUE && FFS_flashData.PredTextSelected == TRUE)
                {
                	dspl_BitBlt(SCREEN_SIZE_X-9,0,8,8,0,(char*)TextIconeZiTextSmall,0);
           		}
#endif

                edtShow(data->edt_edt);
                /*
                 * Print the label
                 */
      			//GW Removed T9 reference
      			//GW Actually remove T9 ref, not code executed when T9 not enabled.
      			if (data->editor_data.editor_attr.win.px > 0)
					xPos = data->editor_data.editor_attr.win.px;
      			else
					xPos = editor_menuArea.px;
      			if (data->editor_data.editor_attr.win.py > Mmi_layout_TitleHeight())
                    yPos = data->editor_data.editor_attr.win.py-Mmi_layout_TitleHeight();
      			else
                    yPos = editor_menuArea.py;

      			if (data->editor_data.TextId NEQ 0)
      			{
        			dspl_TextOut(xPos,yPos,DSPL_TXTATTR_CURRENT_MODE, (char*)MmiRsrcGetText(data->editor_data.TextId));
                }
                else if (data->editor_data.TextString NEQ NULL)
                {
        			dspl_TextOut(xPos,yPos,0,data->LabelText);
                }
                /*
                 * Print the softkeys
                 */
                if (data->edt_mode != E_PIN_SECURITY)
                {
#ifdef EASY_TEXT_ENABLED
                    if (data->editor_data.editor_attr.predText[0] != '\0' && FFS_flashData.PredTextSelected == TRUE)
                    	softKeys_displayId(TxtSoftOK, TxtDelete,0,COLOUR_EDITOR_XX);
                  	else
#endif
               		{
                        if (strlen(data->editor_data.editor_attr.text) < data->editor_data.min_enter)
                        {
             				/* entered less than the required number of chars: Alternate Softkey appears */
               				softKeys_displayId(data->editor_data.AlternateLeftSoftKey, data->editor_data.RightSoftKey,0,COLOUR_EDITOR_XX);
                		}
                        else
               			{
              				/* entered sufficient number of chars: Normal Softkey appears */
                  			softKeys_displayId(data->editor_data.LeftSoftKey, data->editor_data.RightSoftKey,0,COLOUR_EDITOR_XX);
             			}
          			}
                }
                else
                {
		            if (data->emergency_call EQ TRUE)
		            {
		            	softKeys_displayId(TxtSoftCall, data->editor_data.RightSoftKey,0,COLOUR_EDITOR_XX);
		            	TRACE_EVENT ("softkeys , call, delete");
		            }
		            else
		            {
		         		//no emergency_call
                 		if (strlen(data->editor_data.editor_attr.text) < data->editor_data.min_enter)
                		{


                  			if (strlen(data->editor_data.editor_attr.text) EQ 0)
                        		softKeys_displayId(data->editor_data.AlternateLeftSoftKey, TxtNull,0,COLOUR_EDITOR_XX);
                       		else
                      			softKeys_displayId(data->editor_data.AlternateLeftSoftKey, data->editor_data.RightSoftKey,0,COLOUR_EDITOR_XX);

                      		TRACE_EVENT ("softkeys , altern, delete");
               			}
                    	else
                      	{
                 	 		if (strlen(data->editor_data.editor_attr.text) EQ 0)
                            	softKeys_displayId(data->editor_data.AlternateLeftSoftKey, TxtNull,0,COLOUR_EDITOR_XX);
                          	else
                            	softKeys_displayId(data->editor_data.LeftSoftKey, data->editor_data.RightSoftKey,0,COLOUR_EDITOR_XX);

                          	TRACE_EVENT ("softkeys , ok, delete");
						}
					}
				}

            }
            break;
        default:
            return MFW_EVENT_PASSED;
        }
    return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:     editor_kbd_cb

 $Description:  Editor keyboard event handler

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static int editor_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
    T_MFW_HND       win        = mfw_parent (mfw_header());
    T_MFW_WIN     * win_data   = ((T_MFW_HDR *)win)->data;
    T_EDITOR_INFO *  data       = (T_EDITOR_INFO *)win_data->user;
    char* PredText = data->editor_data.editor_attr.predText;
    unsigned int editMode;
    char temp[80];
	int sim_status;

    TRACE_FUNCTION("editor_kbd_cb");

// Nov 24, 2005, a0876501, DR: OMAPS00045909
	sim_status = sim_status_check();


    /* subpress unwanted longpresses (mfw throws more than one long press event for one long press on a key)*/
    if ( !( event & KEY_LONG ))
        DoNextLongPress = TRUE;         /* next Key_long event is correct */
    else if ( DoNextLongPress )
        DoNextLongPress = FALSE;        /* mark Key_long event as consumed but do current long press */
    else if ( !DoNextLongPress )
        return MFW_EVENT_CONSUMED;      /* don't do current long press */


    // c015 rsa
    if (data->edt_tim NEQ NULL)
        {
            /* restart the timer for no response */
            tim_stop  (data->edt_tim);
            tim_start (data->edt_tim);
        }
    // end c015 rsa

    editMode = data->edt_mode;

    sprintf(temp, "Editor mode: %d", editMode);
    TRACE_EVENT(temp);
    
#ifdef EASY_TEXT_ENABLED
    if (FFS_flashData.PredTextSelected == FALSE || data->editor_data.mode != ALPHA_MODE)
#else
    if (1)
#endif
    { TRACE_EVENT("Not in predictive mode");
	/***************************Go-lite Optimization changes Start***********************/
	
	//Aug 16, 2004    REF: CRR 24323   Deepa M.D
	TRACE_EVENT_P1("Key: %d", keyboard->code);
	/***************************Go-lite Optimization changes end***********************/

    switch (editMode)
    {

        case E_NORMAL_MODE:



            if (event & KEY_LONG)
                {
					TRACE_EVENT("event and long key");

                    switch (keyboard->code)
                        {
                        case KCD_CALL:
                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_CALL, NULL);                        	
                        	break;
                        case KCD_LEFT:
                            break;
                        case KCD_MNURIGHT:
                        case KCD_MNUUP:
                            if (data->editor_data.mode NEQ READ_ONLY_MODE &&
                                !data->editor_data.hide )
                            break;
                        case KCD_RIGHT:
						  TRACE_EVENT("KCD_RIGHT");						  
                          // SH - special clear all for format mode

                          if (data->editor_data.mode EQ FORMAT_MODE)
                            {
                            editClear();
                            }

                          // SH - End of format mode modification

                            else if(data->editor_data.editor_attr.text[0] NEQ '\0')
                                {
                                    /* clear the whole buffer */
                                    if ( data->editor_data.hide )
                                        editor_hideClearAll(data);
                                    else
                                        {
                                            data->editor_data.editor_attr.text[0] = '\0';
                                            edtChar(data->edt_edt, ecTop);
                                            if (data->editor_data.min_enter > 0)
                                                {
                                                    win_show(data->edt_win); /* in order to update the Softkeys */
                                                }
                                            else
                                                {
                                                    edtShow(data->edt_edt);
                                                }
                                        }
                                }
                            else
                                {
                                    /* leave editor if buffer already empty */
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
                                }
                            break;

                        case KCD_0: /* '+' key */
                            if (data->editor_data.mode NEQ READ_ONLY_MODE) /* ignore normal keys if in read-only mode */
                                {
                                    if (data->editor_data.hide)
                                        {
                                            /* in hidden mode do not allow entering of '+' */
                                            editor_hideClear(data); /* remove the '0' */
                                        }
                                    else
                                        {
                                            edtChar(data->edt_edt,ecBack); /* remove the '0' */
                                            edtChar(data->edt_edt,'+');    /* insert the '+' */
                                            if (data->editor_data.min_enter > 0)
                                                {
                                                    win_show(data->edt_win); /* in order to update the Softkeys */
                                                }
                                            else
                                                {
                                                    edtShow(data->edt_edt);
                                                }
                                      }
                                }
                            break;

                        default:
            {
              // change the Lowercase to Uppercase and visa-versa
              //only possible in Alpha mode (SH - or format mode)
                            if (data->editor_data.mode EQ ALPHA_MODE || data->editor_data.mode EQ FORMAT_MODE)
                            {
                if (UPPER_CASE EQ FALSE)
                {
                    TRACE_EVENT("UPPER_CASE EQ FALSE");
                  UPPER_CASE = TRUE;
                  upCase = FALSE;
                  displaySoftKeys_edition (TxtLowercase ,TxtNull,TxtNull);
                }
                else
                {
                    TRACE_EVENT("UPPER_CASE EQ TRUE");
                  UPPER_CASE = FALSE;
                  upCase = TRUE;
                  displaySoftKeys_edition (TxtUppercase ,TxtNull,TxtNull);
                }
                if (data->editor_data.mode NEQ FORMAT_MODE) // SH - for format mode, don't erase the character
                  edtChar(data->edt_edt,ecBack);
                            }


                        }
                            return MFW_EVENT_CONSUMED; /* we don't handle other long presses here */


                        }
                }
            else
                {
                    switch (keyboard->code)
                        {
                        case KCD_CALL:
                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_CALL, NULL);                        	
                        	break;
                        case KCD_MNURIGHT:
                        case KCD_MNUUP:
                      if (data->editor_data.mode EQ READ_ONLY_MODE)
                              edtChar(data->edt_edt,ecUp);
              else if (!data->editor_data.hide)       // SH - key not available in hide mode
                {

                /* SH - format mode, skip over fixed characters */

                                if (data->editor_data.mode EQ FORMAT_MODE)  // formatted input
                                  {
                                  TRACE_EVENT("MNUUP");
                  editCharFindNext(ecRight);  // Insert character & move cursor forward once
                                    }

                /* end of format mode modification */

                              else
                                {
                                edtChar(data->edt_edt,ecRight);
                                }
                }

				edtShow(data->edt_edt);
				break;
				case KCD_MNULEFT:
				case KCD_MNUDOWN:
				if (data->editor_data.mode EQ READ_ONLY_MODE)
					edtChar(data->edt_edt,ecDown);
				else if (!data->editor_data.hide)       // SH - key not available in hide mode
				{
	                /* SH - format mode, skip over fixed characters */
					if (data->editor_data.mode EQ FORMAT_MODE)  	// formatted input
	                                  editFindPrev();             	// find previous non-fixed character

	                /* end of format mode modification */
	                else
	                {
						edtChar(data->edt_edt,ecLeft);
	                }
				}
                edtShow(data->edt_edt);
				break;

				case KCD_MNUSELECT:
				case KCD_LEFT:
				if (strlen(data->editor_data.editor_attr.text) < data->editor_data.min_enter)
				{
                                    /* entered less than the required number of chars */
                                    if (data->editor_data.AlternateLeftSoftKey NEQ TxtNull)
                                        {
                                            /* an alternate softkey were defined: execute it*/
                                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_ALTERNATELEFT, NULL);
                                        }
                                }
                            else if (data->editor_data.LeftSoftKey NEQ TxtNull)
                                {
                                    /* left Softkey is enabled (and entered sufficient number of chars): execute it */
                                    //KGT
                                    /* get the orginal text back into the editor instead of the
                                       hide buffer ( only filled with '*') */
            if (data->editor_data.hide)
          editor_hideTerminate(data);
                                    //end KGT
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_LEFT, NULL);
                                }
                            else
                                {
            						//GW-SPR#1035-Added SAT changes from 33x build.
            						/*NM, 090702
                                	  in case of long labels (>14chars; when it doesnt fit on the first line)
                                	  so we open a second editor and return by any keypress
                                	 */
                                    if (over_length_label EQ TRUE)
								  	{
										SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
									}
                                }
                            break;

                        case KCD_HUP:                        	
                            if (data->editor_data.RightSoftKey NEQ TxtNull)
                                {
                                    /* Right softkey is enabled: execute it */
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_HUP, NULL);
                                }
                            break;

                        case KCD_RIGHT:                        	
                            if (data->editor_data.mode NEQ READ_ONLY_MODE) /* ignore clear key if in read-only mode */
                                {
                                    if(data->editor_data.editor_attr.text[0] NEQ '\0')
                                        {
                                            /* buffer is not empty, delete the char before the cursor */
                                            //KGT
                                            if ( data->editor_data.hide )
                                                editor_hideClear(data);
                                            else
                                                //end KGT
                                                {

                                              /* SH - format mode, skip over fixed characters */

                                              if (data->editor_data.mode EQ FORMAT_MODE)          // SH - formatted input
                                                {
                                                switch (editFindPrev())                 // Skip over fixed characters
                                                  {
                                                  case 1:
                                                    edtChar(data->edt_edt,' ');           // overwrite with space
                                                    edtChar(data->edt_edt,ecLeft);          // Move cursor left again
                                                    break;
                                                  case 2:
                                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);  // Exit editor
                                                    break;
                                                  case 3:
                                                    edtChar(data->edt_edt,ecRight); // Last character - shorten string
                                                    edtChar(data->edt_edt,ecBack);
                                                    break;
                                                  }

                                                }

                                              /* end of format mode modification */

                                              else
                                                {
                                                    edtChar(data->edt_edt,ecBack);
                                                }
                                                if (data->editor_data.min_enter > 0)
                                                    {
                                                        win_show(data->edt_win); /* in order to update the Softkeys */
                                                    }
                                                else
                                                    {
                                                        edtShow(data->edt_edt);
                                                    }
                                                }
                                        }
                                    else
                                        {
                                            /* leave editor if buffer already empty */
                                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
                                        }
                                }
                                else
                                         SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);

                            break;
#ifdef EASY_TEXT_ENABLED
                            case (KCD_HASH):
                          { if (AllowPredText == TRUE)
                              if (FFS_flashData.PredTextAvailable == TRUE)
                              {
                                FFS_flashData.PredTextSelected = TRUE;
                                win_show(data->edt_win);
                                break;
                              }

                            {
                              editEventKey(event,keyboard);
                                       if (data->editor_data.min_enter > 0)
                                       {
                                          win_show(data->edt_win); /* in order to update the Softkeys */
                                       }
                                       else
                                       {
                                          edtShow(data->edt_edt);
                                       }
                            }
                          }
                            break;
#endif
                        default: /* any key */
                            if (data->editor_data.mode NEQ READ_ONLY_MODE) /* ignore normal keys if in read-only mode */
                                {
                                        {
                                          /* SH - format mode, setup pointers to format string & index */

                                            if (data->editor_data.mode EQ FORMAT_MODE)
                                              {
                                              setFormatPointers (data->editor_data.FormatString, &(data->editor_data.formatIndex),
                                                &(data->editor_data.fieldIndex));
                                              }

                                            /* End of format mode modification */

						  editEventKey(event,keyboard);
                                            
                                            if (data->editor_data.min_enter > 0)
                                                {
                                                    win_show(data->edt_win); /* in order to update the Softkeys */
                                                }
                                            else
                                                {
                                                    edtShow(data->edt_edt);
                                                }
                                    	}
	                              }
                                /*NM, 090702
                                  in case of long labels (>14chars; when it doesnt fit on the first line)
                                  so we open a second editor and return by any keypress
                                 */
								  else
								  {
								  	if (over_length_label EQ TRUE)
								  	{
										SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
									}
                            }
                            break;
                        }
                }
         
            break;
		//GW Removed T9 code.

            /*  E_PIN_SECURITY entering
             *
             */

        case E_PIN_SECURITY:

                    switch (keyboard->code)
                        {
                        case KCD_MNUUP:
                            break;

                        case KCD_MNUDOWN:
                            break;

                  case KCD_STAR:

              //only possible when the first digit is a '*'
              if (strlen(data->editor_data.editor_attr.text) EQ 0 && data->editor_data.hide)
              {
                data->ss_string = TRUE;
                //the string should be visible on screen
                data->editor_data.hide = FALSE;

                editEventKey(event,keyboard);
              }


                    break;

                  case KCD_HASH:

              if(data->ss_string)
              {
                  T_MFW_SS_RETURN ssRes;

                  editEventKey(event,keyboard);

                ssRes = ss_check_ss_string((UBYTE*)data->editor_data.editor_attr.text);
                switch (ssRes)
                {
                  case MFW_SS_MMI:
// 	May 02, 2005   REF : LOCOSTO-ENH-30818 - xpradipg
//	replace the call to get_imei() with callNumber() -> sAT_Dn()
#ifdef FF_MMI_ATC_MIGRATION                  
					mmi_imei_retrieve();
#else
                    get_imei((char*)data->imei);
                    showIMEI(win,(char*)data->imei);
#endif					
                    editor_hideClearAll(data);

                    //set back to the default
                    data->ss_string = FALSE;

                    // go back in the hide mode
                    data->editor_data.hide = TRUE;

                    return MFW_EVENT_CONSUMED;
                }

              }
                else if (strlen(data->editor_data.editor_attr.text) >= data->editor_data.min_enter)
                            {
                    if (data->editor_data.hide)
                    editor_hideTerminate(data);


                                    TRACE_EVENT("press hash");
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_LEFT, NULL);
                           }


                    break;
                        case KCD_LEFT:
              if ( data->emergency_call EQ TRUE )
              {                               
                  TRACE_EVENT("press left  < min");

                                    /* get the orginal text back into the editor instead of the
                                       hide buffer ( only filled with '*') */
                    if (data->editor_data.hide)
                    editor_hideTerminate(data);

                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_EMERGENCY, NULL);

                                }
                            else if (strlen(data->editor_data.editor_attr.text) >= data->editor_data.min_enter)
                                {
                                    /* left Softkey is enabled (and entered sufficient number of chars): execute it */
                                    //KGT
                                    /* get the orginal text back into the editor instead of the
                                       hide buffer ( only filled with '*') */
                    if (data->editor_data.hide)
                    editor_hideTerminate(data);
                                    //end KGT

                                    TRACE_EVENT("press left");
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_LEFT, NULL);
                               }
                            else
                                {
                                    /* NOP */
                                    TRACE_EVENT("NOP");
                                }
                            break;

                        case KCD_HUP:
                        /* API - 15/10/02 - 1162 - Update the Editor TextId after Deleting a value
                        						   from the text editor.
                        */
                      	  if(cm_check_emergency((U8*)data->tmpBuf))
                      	  {
						  	data->editor_data.TextId = '\0';
						  	data->editor_data.TextId = TxtEmergency;
						  	data->emergency_call = TRUE;
                      	  }
						  else
						  {
							if (sim_status == SIM_NOT_ACTIVE)
							{
								data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtNoCard;
							}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
							else if (sim_status == IMEI_NOT_VALID)
							{
								data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtInvalidIMEI;
							}
							else
							{
							 	data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtEnterPin1;
							}
							data->emergency_call = FALSE;
						  }
                         break;

                        case KCD_CALL:
                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_CALL, NULL);
                        break;                    

              			if ( data->emergency_call EQ TRUE )       {
                  		TRACE_EVENT("press left  < min");

                        /* get the orginal text back into the editor instead of the
                           hide buffer ( only filled with '*') */
                    	if (data->editor_data.hide)
                    	editor_hideTerminate(data);

						SEND_EVENT (win, E_EDITOR_DEINIT, INFO_EMERGENCY, NULL);
					}
                    break;

                        case KCD_RIGHT:
                        /* API - 15/10/02 - 1162 - Update the Editor TextId after Deleting a value
                        						   from the text editor.
                        */
                          TRACE_EVENT("Delete key pressed!");                        
                      	  if(cm_check_emergency((U8*)data->tmpBuf))
                      	  {
						  	data->editor_data.TextId = '\0';
						  	data->editor_data.TextId = TxtEmergency;	
						  	data->emergency_call = TRUE;
						  	
                      	  }
						  else
						  {
							if (sim_status == SIM_NOT_ACTIVE)
							{
								data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtNoCard;
							}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
							else if (sim_status == IMEI_NOT_VALID)
							{
								data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtInvalidIMEI;
							}
							else
							{
							 	data->editor_data.TextId = '\0';
							  	data->editor_data.TextId = TxtEnterPin1;
							}
							data->emergency_call = FALSE;							
						  }

                         if(data->editor_data.editor_attr.text[0] NEQ '\0')
                         {
                          	/* buffer is not empty, delete the char before the cursor */
                          	//KGT
                            if ( data->editor_data.hide )
                            {
                            	U8 uMode;

								editor_hideClear(data);
                        		/* API - 15/10/02 - 1162 - Update the Editor TextId after Deleting a value
                        								   from the text editor.
                        		*/
								if(cm_check_emergency((U8*)data->tmpBuf))
								{
									data->editor_data.TextId = '\0';
									data->editor_data.TextId = TxtEmergency;	
									data->emergency_call = TRUE;									
								}
								else
								{
									if (sim_status == SIM_NOT_ACTIVE)
									{
										data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtNoCard;
									}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
									else if (sim_status == IMEI_NOT_VALID)
									{
										data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtInvalidIMEI;
									}
									else
									{	
							 			data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtEnterPin1;
									}
									data->emergency_call = FALSE;							
						  		}

								if (data->editor_data.min_enter > 0 || data->emergency_call)
								{
									win_show(data->edt_win); /* in order to update the Softkeys */
								}
								else
								{
									edtShow(data->edt_edt);
								}


							}
							else
							//end KGT
							{
								edtChar(data->edt_edt,ecBack);

								// this is for the ss_string
								if (strlen(data->editor_data.editor_attr.text) EQ 0 && data->ss_string)
								{
									data->ss_string = FALSE;
									//the string should be visible on screen
									data->editor_data.hide = TRUE;

								}
                      			/* is it a  emergency call number ?!*/
		                        /* API - 15/10/02 - 1162 - Update the Editor TextId after Deleting a value
                		        						   from the text editor.
        		                */		
                      	  		if(cm_check_emergency((U8*)data->tmpBuf))
                      	  		{
						  			data->editor_data.TextId = '\0';
						  			data->editor_data.TextId = TxtEmergency;
						  			data->emergency_call = TRUE;
                      	  		}
						  		else
						  		{
									if (sim_status == SIM_NOT_ACTIVE)
									{
										data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtNoCard;
									}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
									else if (sim_status == IMEI_NOT_VALID)
									{
										data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtInvalidIMEI;
									}
									else
									{
							 			data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtEnterPin1;
									}
									data->emergency_call = FALSE;
						  		}

						  		if (data->editor_data.min_enter > 0 )
                                {
									win_show(data->edt_win); /* in order to update the Softkeys */
								}
								else
								{
									edtShow(data->edt_edt);
								}
							}
						}
                        break;

                        default: /* any key */
						if (data->editor_data.mode NEQ READ_ONLY_MODE) /* ignore normal keys if in read-only mode */
						{
							if ( data->editor_data.hide )
							{
								U8 uMode;
                            	TRACE_EVENT(" hide mode");

								editor_hideInsert(data,keyboard->code);
	                       		 /* API - 15/10/02 - 1162 - Check to see if the inputed value into the PIN editor is
    	                    						  		an emergency number.
                        		*/
								if((strlen((char*)data->tmpBuf) > 1) && (strlen((char*)data->tmpBuf) < 4))
								{
	            		        	if(cm_check_emergency((UBYTE*)data->tmpBuf))
	                    			{
										TRACE_EVENT(" it is a emergency number !");
										data->emergency_call = TRUE;
										//Clear the TextId string before adding
										data->editor_data.TextId = '\0';
										//Change the TextId to display Emergency ?
										data->editor_data.TextId = TxtEmergency;
										displaySoftKeys(TxtSoftCall, data->editor_data.RightSoftKey);
									}
									else
									{
										TRACE_EVENT("data->emergency_call = FALSE");
										if (sim_status == SIM_NOT_ACTIVE)
										{
											data->editor_data.TextId = '\0';
							  				data->editor_data.TextId = TxtNoCard;
										}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
										else if (sim_status == IMEI_NOT_VALID)
										{
											data->editor_data.TextId = '\0';
							  				data->editor_data.TextId = TxtInvalidIMEI;
										}
										else
										{
										 	data->editor_data.TextId = '\0';
										  	data->editor_data.TextId = TxtEnterPin1;
										}
									data->emergency_call = FALSE;
									}
								}
								else
								{
									TRACE_EVENT("data->emergency_call = FALSE");
									if (sim_status == SIM_NOT_ACTIVE)
									{
										data->editor_data.TextId = '\0';
						  				data->editor_data.TextId = TxtNoCard;
									}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
									else if (sim_status == IMEI_NOT_VALID)
									{
										data->editor_data.TextId = '\0';
							  			data->editor_data.TextId = TxtInvalidIMEI;
									}
									else
									{
									 	data->editor_data.TextId = '\0';
									  	data->editor_data.TextId = TxtEnterPin1;
									}								
								data->emergency_call = FALSE;
								}              

								if (data->editor_data.min_enter > 0 || data->emergency_call)
								{	
									win_show(data->edt_win); /* in order to update the Softkeys */
								}
								else
								{
									edtShow(data->edt_edt);
									TRACE_EVENT(" edtShow");
								}


							}
							else
                    		{
                    			TRACE_EVENT(" unhide mode");
                    			editEventKey(event,keyboard);

	                       		 /* API - 15/10/02 - 1162 - Check to see if the inputed value into the PIN editor is
    	                    						  		an emergency number.
                        		*/
                    			if((strlen((char*)data->editor_data.editor_attr.text) > 1) && (strlen((char*)data->editor_data.editor_attr.text) < 4))
                    			{
                    			   TRACE_EVENT("EMERGENCY CHECK POINT!");
	                 			   if(cm_check_emergency((U8*)data->editor_data.editor_attr.text))
	                    			{
	                    				TRACE_EVENT(" it is a emergency number !");
	                      				data->emergency_call = TRUE;
	                      				//Clear the TextId string before adding
	                      				data->editor_data.TextId = '\0';
	                      				//Change the TextId to display Emergency ?
	                      				data->editor_data.TextId = TxtEmergency;
	                    			}
	                    			else
	                    			{
	                      				TRACE_EVENT("data->emergency_call = FALSE");
										if (sim_status == SIM_NOT_ACTIVE)
										{
											data->editor_data.TextId = '\0';
							  				data->editor_data.TextId = TxtNoCard;
										}
// Nov 24, 2005, a0876501, DR: OMAPS00045909
										else if (sim_status == IMEI_NOT_VALID)
										{
											data->editor_data.TextId = '\0';
							  				data->editor_data.TextId = TxtInvalidIMEI;
										}
										else
										{
										 	data->editor_data.TextId = '\0';
										  	data->editor_data.TextId = TxtEnterPin1;
										}	                      				
	                      			data->emergency_call = FALSE;
	                   			 	}
                    			}
								else
	                			{
	                				TRACE_EVENT("data->emergency_call = FALSE");
	                    			data->emergency_call = FALSE;
	                			}
		
								if (data->editor_data.min_enter > 0)
								{
									win_show(data->edt_win); /* in order to update the Softkeys */
								}		
								else
								{
									edtShow(data->edt_edt);
								}
							}
						}
                		break;
				}
            	break;
        }
}
#ifdef EASY_TEXT_ENABLED
     else
     if(FFS_flashData.PredTextAvailable == TRUE)
      {TRACE_EVENT("In predictive mode");
	 /***************************Go-lite Optimization changes Start***********************/
	 
	 //Aug 16, 2004    REF: CRR 24323   Deepa M.D
	 TRACE_EVENT_P1("Key: %d", keyboard->code);
	 /***************************Go-lite Optimization changes end***********************/

            if (event & KEY_LONG)
                {
                    switch (keyboard->code)
                        {
                        case KCD_CALL:
                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_CALL, NULL);
                        	break;
                        case KCD_RIGHT: //empty predictive text string
                            if(PredText[0] NEQ '\0')
                            {
                PredText[0]= '\0';
                ResetDictSearch();

                            }
                            else //empty whole editor
                            {
                                 if(data->editor_data.editor_attr.text[0] NEQ '\0')
                              {
                                  data->editor_data.editor_attr.text[0] = '\0';
                                  if (data->editor_data.min_enter > 0)
                                  {
                                win_show(data->edt_win); /* in order to update the Softkeys */
                                  }
                                  else
                                  {
                                     edtShow(data->edt_edt);
                                  }

                              }
                              else
                              {
                                 /* leave editor if buffer already empty */
                                  SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
                              }
                            }
                            break;

                        case KCD_0: /* '+' key */
                          if(PredText[0] == '\0')
                            {


                                if (data->editor_data.min_enter > 0)
                                {
                                   win_show(data->edt_win); /* in order to update the Softkeys */
                                }
                              else
                                {
                                   edtShow(data->edt_edt);
                                }
                            }

                            break;

                        case(KCD_STAR):
                        { char symbol;
                          SymbolScreenstart (data->edt_win, &symbol);
                        }
                        break;

                        default: //change case
            { if(PredText[0] == '\0')
                            {
                // change the Lowercase to Uppercase and visa-versa
                //only possible in Alpha mode
                              if (data->editor_data.mode EQ ALPHA_MODE)
                              {
                  if (UPPER_CASE EQ FALSE)
                  {
                      TRACE_EVENT("UPPER_CASE EQ FALSE");
                    UPPER_CASE = TRUE;
                    upCase = FALSE;
                    displaySoftKeys_edition (TxtLowercase ,TxtNull,TxtNull);
                  }
                  else
                  {
                     TRACE_EVENT("UPPER_CASE EQ TRUE");
                    UPPER_CASE = FALSE;
                    upCase = TRUE;
                    displaySoftKeys_edition (TxtUppercase ,TxtNull,TxtNull);
                  }
                              }
                            }
                        }
                            return MFW_EVENT_CONSUMED; /* we don't handle other long presses here */


                        }
                }
            else
                {
                    switch (keyboard->code)
                        {
                        case KCD_CALL:
                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_CALL, NULL);                        	
                        	break;
                        case KCD_MNURIGHT:
                        case KCD_MNUUP:
                          if(PredText[0] == '\0')
                          {
                              edtChar(data->edt_edt,ecRight);
                              edtShow(data->edt_edt);
                          }
                            break;
						case KCD_MNULEFT:
                        case KCD_MNUDOWN:
                          if(PredText[0] == '\0')
                            {

                              edtChar(data->edt_edt,ecLeft);
                              edtShow(data->edt_edt);
                          }
                            break;

                        case KCD_LEFT:
                            if(PredText[0] == '\0')
                            {

                            if (data->editor_data.LeftSoftKey NEQ TxtNull)
                                {

                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_LEFT, NULL);
                                }
                            }
                            else
                            {   char TempString[16];
                              char LastChar;

                            if ((strlen(data->editor_data.editor_attr.text) + strlen(PredText)) < MAX_MSG_LEN)
                if (PredText[0] != '*')
                              { if (capitalise_word(data->edt_edt) == TRUE|| (strlen(PredText)== 1 && PredText[0] == 'i'))
                                { PredText[0] -= 0x20;
                                }
                                LastChar = getCursorChar(data->edt_edt, -1);
                                if ( LastChar != ' ' && LastChar != 0)
                              {
                                  sprintf(TempString, " %s", PredText);
                                  edtInsertString(data->edt_edt, TempString);
                            }
                                else
                                  edtInsertString(data->edt_edt,PredText);
                              }
                PredText[0] = '\0';
                ResetDictSearch();
                win_show(data->edt_win);
                            }

                            break;

                        case KCD_HUP:
                            if (data->editor_data.RightSoftKey NEQ TxtNull)
                                {
                                    /* Right softkey is enabled: execute it */
                                    SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_HUP, NULL);
                                }
                            break;

                        case KCD_RIGHT:
                            if(PredText[0] == '\0')
                                {
                                    if(data->editor_data.editor_attr.text[0] NEQ '\0')
                                        {

                                                {
                                                    edtChar(data->edt_edt,ecBack);
                                                    if (data->editor_data.min_enter > 0)
                                                        {
                                                            win_show(data->edt_win); /* in order to update the Softkeys */
                                                        }
                                                    else
                                                        {
                                                            edtShow(data->edt_edt);
                                                        }
                                                }
                                        }
                                    else
                                        {
                                            /* leave editor if buffer already empty */
                                            SEND_EVENT (win, E_EDITOR_DEINIT, INFO_KCD_RIGHT, NULL);
                                        }
                                }
                                else
                                {
                                if (strlen(PredText) == 1)
                                {
                                  DictBackSpace(data->editor_data.editor_attr.predText);
                                   PredText[0] = '\0';
                                }
                                else
                  DictBackSpace(data->editor_data.editor_attr.predText);

                win_show(data->edt_win);
                                }

                            break;
                        case (KCD_2):
                        case (KCD_3):
                        case (KCD_4):
                        case (KCD_5):
                        case (KCD_6):
                        case (KCD_7):
                        case (KCD_8):
                        case (KCD_9):
                        {
                          DictAlphaKeyPress(keyboard->code,PredText);
                          win_show(data->edt_win);
                        }
                          break;

                       case (KCD_HASH):
                        {   FFS_flashData.PredTextSelected = FALSE;
                          PredText[0] = '\0';
                          win_show(data->edt_win);
                        }
                        break;

            case (KCD_STAR):
              if (PredText[0] == '\0')
              { char symbol;
                            SymbolScreenstart (data->edt_win, &symbol);
                          }
              else
                          {   int i;
                            MoreCandidates(PredText, &i);
                            win_show(data->edt_win);
                          }
                        break;

            case KCD_0:
                        case KCD_1:
                          if (PredText[0] != '\0')
                          {   char TempString[16];
                            char LastChar;

                              if ((strlen(data->editor_data.editor_attr.text) + strlen(PredText)) < MAX_MSG_LEN)
                              {
                                //if char b4 cursor full stop/question/exclamation
                                //(or last char space and char b4 full stop)
                                if (capitalise_word(data->edt_edt) == TRUE || (strlen(PredText)== 1 && PredText[0] == 'i'))
                                { PredText[0] -= 0x20;

                                }
                                  //capitalise first letter of char
                  //if char b4 cursor not space
                    //insert spac
                  LastChar = getCursorChar(data->edt_edt, -1);

                              if (PredText[0] != '*')
                                { if (keyboard->code == KCD_1)
                                  { if ( LastChar != ' ' && LastChar != 0)
                                    sprintf(TempString, " %s ", PredText);
                                    else
                                      sprintf(TempString, "%s ", PredText);
                                  }
                                  else
                                  { if ( LastChar != ' ' && LastChar != 0)
                                    sprintf(TempString, " %s. ", PredText);
                                    else
                                      sprintf(TempString, "%s. ", PredText);
                                  }
                    edtInsertString(data->edt_edt, TempString);
                              }
                              }
                PredText[0] = '\0';
                ResetDictSearch();
                win_show(data->edt_win);
                break;
                            }

                        default:
                         /* any key */
                            if (data->editor_data.mode NEQ READ_ONLY_MODE) /* ignore normal keys if in read-only mode */
                                {
                                        {
                                            editEventKey(event,keyboard);
                                            if (data->editor_data.min_enter > 0)
                                                {
                                                    win_show(data->edt_win); /* in order to update the Softkeys */
                                                }
                                            else
                                                {
                                                    edtShow(data->edt_edt);
                                                }
                                      }
                                }
                            break;
                        }
              }
      }
#endif
    return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:     editor_tim_cb

 $Description:  Callback function for the editor info timer.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static int editor_tim_cb (T_MFW_EVENT event, T_MFW_TIM *tc)
{
    T_MFW_HND       win  = mfw_parent (mfw_header());
    T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
    T_EDITOR_INFO * data       = (T_EDITOR_INFO *)win_data->user;

    T_MFW_HND       parent_win = data->parent;
    USHORT          Identifier = data->editor_data.Identifier;
    T_EDIT_CB       Callback   = data->editor_data.Callback;

    /* timer elapsed => selfdestroy; sendevent INFO_TIMEOUT */
    editor_destroy (data->edt_win);
    
    if (Callback)
        (Callback) (parent_win, Identifier, INFO_TIMEOUT);

    return MFW_EVENT_CONSUMED;
}

T_MFW_HND editor_start_common(T_MFW_HND win, char * buffer, U16 len, T_EDITOR_DATA * editor_info, T_EDIT_CB editor_cb)
{
	editor_attr_init( &editor_info->editor_attr, ZONE_BORDER_EDITOR, edtCurBar1, EDITOR_CONTROLS, buffer, len, COLOUR_EDITOR);     
	editor_info->hide			= FALSE;
	editor_info->destroyEditor	= TRUE;
    editor_info->Callback 		= editor_cb;

    /* create the dialog handler */
    return editor_start(win, editor_info);  /* start the common editor */
}

/*******************************************************************************

 $Function:     editor_hideInit

 $Description:  the editor hides letters and numbers behind '*'.
         Initialize editor for hide.

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_hideInit(T_EDITOR_INFO *data)
{
    USHORT  len = strlen(data->editor_data.editor_attr.text);

    TRACE_FUNCTION("MmiEditor.editor_hideInit");

    /* get memory for the tempory buffer */
    data->tmpBuf = (char *) ALLOC_MEMORY(data->editor_data.editor_attr.size);

    /* copy text to the tempory buffer */
    strcpy(data->tmpBuf, data->editor_data.editor_attr.text);

    /* overwrite the string in the editor buffer with stars */
    memset(data->editor_data.editor_attr.text,'\0',sizeof(data->editor_data.editor_attr.text));
    edtReset(data->edt_edt);

    while ( strlen(data->editor_data.editor_attr.text) < len )
        edtChar(data->edt_edt,'*');

    /* show editor with hide buffer */
    if (data->editor_data.min_enter > 0)
        win_show(data->edt_win); /* in order to update the Softkeys */
    else
        edtShow(data->edt_edt);

    return;
}

/*******************************************************************************

 $Function:     editor_hideInsert

 $Description:  Insert the typed letter/number with editEventKey into the
        original editor buffer and insert a '*' into the hide buffer

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_hideInsert(T_EDITOR_INFO *data, U8 key)
{
    USHORT  i;
    MfwEdt  *edt = ((T_MFW_HDR      *)(data->edt_edt))->data;

    TRACE_FUNCTION("MmiEditor.editor_hideInsert");

    /* check if no more space in buffer  */
    if ((int) strlen(data->editor_data.editor_attr.text) >=
        data->editor_data.editor_attr.size - 1)
        return;

    /* do insert on original editor buffer without cursor move: */
    if (!data->editor_data.editor_attr.mode)
        return;
    else
        /* if not in overwrite mode, move text behind cursor position 1 position
           to the right */
        if (!(data->editor_data.editor_attr.mode & edtModOverWr))

            for (i = strlen(data->tmpBuf); i > edt->cp; i--)
                data->tmpBuf[i] = data->tmpBuf[i-1];

    /* insert the character */
    data->tmpBuf[edt->cp] = (char) (key + '0');

    /* do insert on hide buffer with cursor move */
    edtChar(data->edt_edt,'*');

    /* show editor with hide buffer */
    if (data->editor_data.min_enter > 0)
        win_show(data->edt_win); /* in order to update the Softkeys */
    else
        edtShow(data->edt_edt);

    return;
}

/*******************************************************************************

 $Function:     editor_hideClear

 $Description:  clears a character at the cursor position inthe  original editor
        buffer and the hide buffer

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_hideClear(T_EDITOR_INFO *data)
{
    MfwEdt *edt = ((T_MFW_HDR *)(data->edt_edt))->data;

    TRACE_FUNCTION("MmiEditor.editor_hideClear");

    /* check if at beginning of buffer  */
    if (edt->cp == 0)
        return;

    /* do delete on original editor buffer without cursor move */
    strcpy(data->tmpBuf + edt->cp - 1, data->tmpBuf + edt->cp);

    /* do delete on hide buffer with cursor move */
    edtChar(data->edt_edt,ecBack);

    /* show editor with hide buffer */
    if (data->editor_data.min_enter > 0)
        win_show(data->edt_win); /* in order to update the Softkeys */
    else
        edtShow(data->edt_edt);

    return;
}

/*******************************************************************************

 $Function:     editor_hideClearAll

 $Description:  clears hole original editor buffer and hole hide buffer

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_hideClearAll(T_EDITOR_INFO *data)
{
    TRACE_FUNCTION("MmiEditor.editor_hideClearAll");

    /* clear the original editor buffer and the hide buffer */
    memset(data->tmpBuf,'\0',sizeof(data->tmpBuf));
    memset(data->editor_data.editor_attr.text,'\0',sizeof(data->editor_data.editor_attr.text));
    edtReset(data->edt_edt);

    /* show editor with hide buffer */
    if (data->editor_data.min_enter > 0)
        win_show(data->edt_win); /* in order to update the Softkeys */
    else
        edtShow(data->edt_edt);

    return;
}

/*******************************************************************************

 $Function:     editor_hideTerminate

 $Description:  switchs the normal editor buffer with the tempory buffer in
        T_EDITOR_INFO

 $Returns:    None.

 $Arguments:  None.

*******************************************************************************/
static void editor_hideTerminate(T_EDITOR_INFO *data)
{
    TRACE_FUNCTION("MmiEditor.editor_hideTerminate");

    /* overwrite the stars with the original typed text */
    strcpy(data->editor_data.editor_attr.text, data->tmpBuf);

    /* free the memory for the tempory buffer */
    FREE_MEMORY ((void *)data->tmpBuf, data->editor_data.editor_attr.size);

    return;
}
